/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.ChangePasswordResponse;
import pl.smartapps.restserver.service.UserService;
import pl.smartapps.restserver.service.impl.UserServiceImpl;
import pl.smartapps.restserver.servlet.ChangePasswordServlet;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ChangePasswordServlet.class})
public class ChangePasswordServletTests {
    private ChangePasswordServlet changePasswordServlet;
    private UserServiceImpl userService;
    private UserDAO userDAO;
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Before
    public void setUp() {
        this.changePasswordServlet = new ChangePasswordServlet();
        this.userService = (UserServiceImpl)PowerMock.createMock(UserServiceImpl.class);
        this.changePasswordServlet.setUserService((UserService)this.userService);
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.changePasswordServlet.setUserDAO(this.userDAO);
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
    }

    @Test
    public void testChangePasswordFailureEmptyCode() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn(null);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.changePasswordServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testDisplayChangePasswordPage() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234");
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode("1234")).andReturn((Object)new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.request.getParameter("password")).andReturn(null);
        EasyMock.expect((Object)this.request.getParameter("confirmPassword")).andReturn(null);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/ChangePassword.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.changePasswordServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordSuccessfuly() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234");
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode("1234")).andReturn((Object)new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.request.getParameter("password")).andReturn((Object)"test5A");
        EasyMock.expect((Object)this.request.getParameter("confirmPassword")).andReturn((Object)"test5A");
        ChangePasswordResponse changePasswordResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.SUCCESS);
        EasyMock.expect((Object)this.userService.changePasswordByCode("1234", "test5A", "test5A")).andReturn((Object)changePasswordResponse);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/PasswordChanged.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.changePasswordServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordInvalidCode() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234");
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode("1234")).andReturn(null);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/InvalidChangePasswordCode.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.changePasswordServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordFailureServiceError() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234");
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode("1234")).andReturn((Object)new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.request.getParameter("password")).andReturn((Object)"test5A");
        EasyMock.expect((Object)this.request.getParameter("confirmPassword")).andReturn((Object)"test5A");
        ChangePasswordResponse changePasswordResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.ERROR);
        EasyMock.expect((Object)this.userService.changePasswordByCode("1234", "test5A", "test5A")).andReturn((Object)changePasswordResponse);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/ChangePassword.jsp")).andReturn((Object)requestDispatcher);
        this.request.setAttribute("status", (Object)"ERROR");
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.changePasswordServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordFailureServiceNotFoundUser() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234");
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode("1234")).andReturn((Object)new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.request.getParameter("password")).andReturn((Object)"test5A");
        EasyMock.expect((Object)this.request.getParameter("confirmPassword")).andReturn((Object)"test5A");
        ChangePasswordResponse changePasswordResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_NOTFOUNDUSER);
        EasyMock.expect((Object)this.userService.changePasswordByCode("1234", "test5A", "test5A")).andReturn((Object)changePasswordResponse);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/ChangePassword.jsp")).andReturn((Object)requestDispatcher);
        this.request.setAttribute("status", (Object)"FAILED_NOTFOUNDUSER");
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.changePasswordServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }
}

