/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import java.util.Date;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.shiro.util.ThreadContext;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.service.EventService;
import pl.smartapps.restserver.servlet.BrickcomMotionDetectionEventServlet;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={BrickcomMotionDetectionEventServlet.class, ServletFileUpload.class, FileItemFactory.class, ThreadContext.class})
public class BrickcomMotionDetectionEventServletTests {
    private BrickcomMotionDetectionEventServlet servlet;
    private EventService eventService;
    private HttpServletRequest servletRequest;
    private HttpServletResponse servletResponse;

    @Before
    public void setUp() {
        this.servlet = new BrickcomMotionDetectionEventServlet();
        this.eventService = (EventService)PowerMock.createMock(EventService.class);
        this.servlet.setEventService(this.eventService);
        this.servletRequest = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.servletResponse = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
        PowerMock.mockStatic(ServletFileUpload.class);
        PowerMock.mockStatic(ThreadContext.class);
    }

    @Test
    public void testWithPirEventType() throws ServletException, IOException {
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDecviceId")).andReturn((Object)1);
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)23, (int)14, (int)32, (int)9);
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceEventDate")).andReturn((Object)eventDate);
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceEventType")).andReturn((Object)"PIR");
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceSnapshot")).andReturn((Object)snapshot);
        byte[] videoClip = new byte[5];
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceVideoClip")).andReturn((Object)videoClip);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, videoClip)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testWithAudioEventType() throws ServletException, IOException {
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDecviceId")).andReturn((Object)1);
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)23, (int)14, (int)32, (int)9);
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceEventDate")).andReturn((Object)eventDate);
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceEventType")).andReturn((Object)"AD");
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceSnapshot")).andReturn((Object)snapshot);
        byte[] videoClip = new byte[5];
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceVideoClip")).andReturn((Object)videoClip);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "AD", snapshot, "VIDEO", null, eventDate, videoClip)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testWithEmptyEventType() throws ServletException, IOException {
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDecviceId")).andReturn((Object)1);
        Date eventDate = Utils.constructDate((int)2012, (int)2, (int)23, (int)14, (int)32, (int)9);
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceEventDate")).andReturn((Object)eventDate);
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceEventType")).andReturn(null);
        byte[] snapshot = new byte[5];
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceSnapshot")).andReturn((Object)snapshot);
        byte[] videoClip = new byte[5];
        EasyMock.expect((Object)ThreadContext.get((Object)"lanDeviceVideoClip")).andReturn((Object)videoClip);
        EasyMock.expect((Object)this.eventService.processEvent(Integer.valueOf(1), "MOTION", snapshot, "VIDEO", null, eventDate, videoClip)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.servlet.handleRequest(this.servletRequest, this.servletResponse);
        PowerMock.verifyAll();
    }
}

