/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.servlet;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.servlet.AccountActivationServlet;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={AccountActivationServlet.class})
public class AccountActivationServletTests {
    private AccountActivationServlet accountActivationServlet;
    private UserDAO userDAO;
    private HttpServletRequest request;
    private HttpServletResponse response;

    @Before
    public void setUp() {
        this.accountActivationServlet = new AccountActivationServlet();
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.accountActivationServlet.setUserDAO(this.userDAO);
        this.request = (HttpServletRequest)PowerMock.createMock(HttpServletRequest.class);
        this.response = (HttpServletResponse)PowerMock.createMock(HttpServletResponse.class);
    }

    @Test
    public void testNotFoundActivationCode() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn(null);
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivationCodeWithoutIdPart() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234");
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testIdNotANumber() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234_000abc");
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testNoCode() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"_000abc");
        this.response.setStatus(404);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testIncorrectActivationCodeIdTooShort() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234_00001");
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)new UserEntity());
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("1234")).andReturn(null);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/InvalidActivationCode.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testIncorrectActivationCodeNoUserForId() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234_000001");
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("1234")).andReturn(null);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/InvalidActivationCode.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testIncorrectActivationCodeWrongCodeForUser() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234_000001");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setActivationCode("5678");
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)foundUser);
        UserEntity wrongUser = new UserEntity();
        wrongUser.setId(Integer.valueOf(2));
        wrongUser.setActivationCode("1234");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("1234")).andReturn((Object)wrongUser);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/InvalidActivationCode.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testIncorrectActivationCodeCodeForDifferentUser() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234_000001");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)foundUser);
        UserEntity wrongUser = new UserEntity();
        wrongUser.setId(Integer.valueOf(2));
        wrongUser.setActivationCode("1234");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("1234")).andReturn((Object)wrongUser);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/InvalidActivationCode.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateAccountFailure() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234_000001");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setActivationCode("1234");
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)foundUser);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("1234")).andReturn((Object)foundUser);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("test");
        savedUser.setEmail("test@test.pl");
        savedUser.setActivationCode(null);
        Capture captureUserEntity = new Capture();
        EasyMock.expect((Object)this.userDAO.updateUser((UserEntity)EasyMock.capture((Capture)captureUserEntity))).andReturn(null);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/ErrorDuringActivation.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        Assert.assertEquals((Object)savedUser, (Object)captureUserEntity.getValue());
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateAccountSuccessfuly() throws ServletException, IOException {
        EasyMock.expect((Object)this.request.getParameter("code")).andReturn((Object)"1234_000001");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setActivationCode("1234");
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)foundUser);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("1234")).andReturn((Object)foundUser);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("test");
        savedUser.setEmail("test@test.pl");
        savedUser.setActivationCode(null);
        EasyMock.expect((Object)this.userDAO.updateUser(savedUser)).andReturn((Object)savedUser);
        RequestDispatcher requestDispatcher = (RequestDispatcher)PowerMock.createMock(RequestDispatcher.class);
        EasyMock.expect((Object)this.request.getRequestDispatcher("/jsp/ActivationSuccess.jsp")).andReturn((Object)requestDispatcher);
        requestDispatcher.forward((ServletRequest)this.request, (ServletResponse)this.response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.accountActivationServlet.handleRequest(this.request, this.response);
        PowerMock.verifyAll();
    }
}

