/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.springframework.core.task.TaskExecutor;
import pl.smartapps.containerserver.HttpClientFactory;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.notification.impl.SmsxchangeGateImpl;
import pl.smartapps.restserver.util.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SmsxchangeGateImpl.class, Utils.class, HttpGet.class, EntityUtils.class})
public class SmsxchangeGateImplTests {
    private SmsxchangeGateImpl service;
    private ParameterService parameterService;
    private HttpClientFactory httpClientFactory;
    private TaskExecutor taskExecutor;

    @Before
    public void setUp() {
        this.service = new SmsxchangeGateImpl();
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.service.setParameterService(this.parameterService);
        this.httpClientFactory = (HttpClientFactory)PowerMock.createMock(HttpClientFactory.class);
        this.service.setHttpClientFactory(this.httpClientFactory);
        this.taskExecutor = (TaskExecutor)PowerMock.createMock(TaskExecutor.class);
        this.service.setTaskExecutor(this.taskExecutor);
        PowerMock.mockStatic(EntityUtils.class);
    }

    @Test
    public void testSendSynchronously() throws Exception {
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_ENDPOINT)).andReturn((Object)"https://www.smsxchange.com/scripts/sendsms.asp");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_USERID)).andReturn((Object)"xyz");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_PASSWORD)).andReturn((Object)"1234");
        String url = "https://www.smsxchange.com/scripts/sendsms.asp?userid=xyz&password=1234&phone=123456789&sms=a%26b%2Bc%25d%23e%20f%3Dghij";
        HttpGet httpGet = (HttpGet)PowerMock.createMock(HttpGet.class);
        PowerMock.expectNew(HttpGet.class, (Object[])new Object[]{url}).andReturn((Object)httpGet);
        HttpClient httpClient = (HttpClient)PowerMock.createMock(HttpClient.class);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.SMSXCHANGE_ALLOW_INSECURE, false)).andReturn((Object)false);
        EasyMock.expect((Object)this.httpClientFactory.getHttpClient(false)).andReturn((Object)httpClient);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpGet)).andReturn((Object)response);
        StatusLine statusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)statusLine);
        EasyMock.expect((Object)statusLine.getStatusCode()).andReturn((Object)200);
        HttpEntity entity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)entity);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)entity)).andReturn((Object)"01");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.service.sendSynchronously("123456789", "a&b+c%d#e f=ghij"));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendSynchronouslyNotSend() throws Exception {
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_ENDPOINT)).andReturn((Object)"https://www.smsxchange.com/scripts/sendsms.asp");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_USERID)).andReturn((Object)"xyz");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_PASSWORD)).andReturn((Object)"1234");
        String url = "https://www.smsxchange.com/scripts/sendsms.asp?userid=xyz&password=1234&phone=123456789&sms=a%26b%2Bc%25d%23e%20f%3Dghij";
        HttpGet httpGet = (HttpGet)PowerMock.createMock(HttpGet.class);
        PowerMock.expectNew(HttpGet.class, (Object[])new Object[]{url}).andReturn((Object)httpGet);
        HttpClient httpClient = (HttpClient)PowerMock.createMock(HttpClient.class);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.SMSXCHANGE_ALLOW_INSECURE, false)).andReturn((Object)false);
        EasyMock.expect((Object)this.httpClientFactory.getHttpClient(false)).andReturn((Object)httpClient);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpGet)).andReturn((Object)response);
        StatusLine statusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)statusLine);
        EasyMock.expect((Object)statusLine.getStatusCode()).andReturn((Object)200);
        HttpEntity entity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)entity);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)entity)).andReturn((Object)"05");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.service.sendSynchronously("123456789", "a&b+c%d#e f=ghij"));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendSynchronouslyUnknownStatus() throws Exception {
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_ENDPOINT)).andReturn((Object)"https://www.smsxchange.com/scripts/sendsms.asp");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_USERID)).andReturn((Object)"xyz");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_PASSWORD)).andReturn((Object)"1234");
        String url = "https://www.smsxchange.com/scripts/sendsms.asp?userid=xyz&password=1234&phone=123456789&sms=a%26b%2Bc%25d%23e%20f%3Dghij";
        HttpGet httpGet = (HttpGet)PowerMock.createMock(HttpGet.class);
        PowerMock.expectNew(HttpGet.class, (Object[])new Object[]{url}).andReturn((Object)httpGet);
        HttpClient httpClient = (HttpClient)PowerMock.createMock(HttpClient.class);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.SMSXCHANGE_ALLOW_INSECURE, false)).andReturn((Object)false);
        EasyMock.expect((Object)this.httpClientFactory.getHttpClient(false)).andReturn((Object)httpClient);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpGet)).andReturn((Object)response);
        StatusLine statusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)statusLine);
        EasyMock.expect((Object)statusLine.getStatusCode()).andReturn((Object)200);
        HttpEntity entity = (HttpEntity)PowerMock.createMock(HttpEntity.class);
        EasyMock.expect((Object)response.getEntity()).andReturn((Object)entity);
        EasyMock.expect((Object)EntityUtils.toString((HttpEntity)entity)).andReturn((Object)"test");
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.service.sendSynchronously("123456789", "a&b+c%d#e f=ghij"));
        PowerMock.verifyAll();
    }

    @Test
    public void testSendSynchronouslyIncorrectStatusCode() throws Exception {
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_ENDPOINT)).andReturn((Object)"https://www.smsxchange.com/scripts/sendsms.asp");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_USERID)).andReturn((Object)"xyz");
        EasyMock.expect((Object)this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_PASSWORD)).andReturn((Object)"1234");
        String url = "https://www.smsxchange.com/scripts/sendsms.asp?userid=xyz&password=1234&phone=123456789&sms=a%26b%2Bc%25d%23e%20f%3Dghij";
        HttpGet httpGet = (HttpGet)PowerMock.createMock(HttpGet.class);
        PowerMock.expectNew(HttpGet.class, (Object[])new Object[]{url}).andReturn((Object)httpGet);
        HttpClient httpClient = (HttpClient)PowerMock.createMock(HttpClient.class);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.SMSXCHANGE_ALLOW_INSECURE, false)).andReturn((Object)false);
        EasyMock.expect((Object)this.httpClientFactory.getHttpClient(false)).andReturn((Object)httpClient);
        HttpResponse response = (HttpResponse)PowerMock.createMock(HttpResponse.class);
        EasyMock.expect((Object)httpClient.execute((HttpUriRequest)httpGet)).andReturn((Object)response);
        StatusLine statusLine = (StatusLine)PowerMock.createMock(StatusLine.class);
        EasyMock.expect((Object)response.getStatusLine()).andReturn((Object)statusLine);
        EasyMock.expect((Object)statusLine.getStatusCode()).andReturn((Object)404);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.service.sendSynchronously("123456789", "a&b+c%d#e f=ghij"));
        PowerMock.verifyAll();
    }
}

