/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.HttpClientFactory;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.notification.SmsGate;
import pl.smartapps.restserver.service.notification.impl.SmsxchangeGateImpl;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SmsxchangeGateImpl
implements SmsGate {
    private static final Logger log = Logger.getLogger(SmsxchangeGateImpl.class);
    private static final Map<String, Status> STATUS_CODES = new /* Unavailable Anonymous Inner Class!! */;
    private static final Map<String, String> MSG_RESTRICTED_CHARS = new /* Unavailable Anonymous Inner Class!! */;
    private ParameterService parameterService;
    private HttpClientFactory httpClientFactory;
    private TaskExecutor taskExecutor;
    private BlockingQueue<Message> queue = new PriorityBlockingQueue();
    private boolean discardMessages;
    private Sender sender;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    @Autowired
    @Required
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @PostConstruct
    public void setUp() {
        this.sender = new Sender(this, null);
        this.taskExecutor.execute((Runnable)this.sender);
    }

    @PreDestroy
    public void tearDown() {
        Sender.access$1((Sender)this.sender, (boolean)false);
    }

    public void send(String phoneNumber, String text) {
        this.queue.add(new Message(phoneNumber, text));
    }

    public boolean sendSynchronously(String phoneNumber, String text) {
        return this.doSend(new Message(phoneNumber, text));
    }

    private boolean doSend(Message message) {
        if (this.discardMessages) {
            log.info((Object)("Discarding message " + message));
            return true;
        }
        log.debug((Object)("Sending SMS: " + message));
        try {
            HttpGet httpGet = new HttpGet(this.getUrl(message));
            HttpClient httpClient = this.httpClientFactory.getHttpClient(this.getAllowInsecure());
            HttpResponse response = httpClient.execute((HttpUriRequest)httpGet);
            Status status = this.getStatus(response, message);
            if (status == null || status != Status.MESSAGE_SENT) {
                log.warn((Object)("SMS messgage " + message + " not sent: status=" + status));
                return false;
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to send message " + message), (Throwable)e);
            return false;
        }
        return true;
    }

    private Status getStatus(HttpResponse response, Message message) throws ParseException, IOException {
        if (response == null) {
            log.warn((Object)("Failed to send sms message " + message + ": null response"));
            return null;
        }
        int code = response.getStatusLine().getStatusCode();
        if (code != 200) {
            log.warn((Object)("Failed to send sms message " + message + ". Status code " + code));
            return null;
        }
        String body = EntityUtils.toString((HttpEntity)response.getEntity());
        log.trace((Object)("Got " + body + " in response to send " + message));
        Status status = (Status)STATUS_CODES.get(body.trim());
        if (status == null) {
            log.warn((Object)("Unknown status code: " + body));
            return null;
        }
        return status;
    }

    private String getUrl(Message message) {
        StringBuilder url = new StringBuilder();
        url.append(this.getEndpoint());
        url.append("?userid=").append(this.getUserId());
        url.append("&password=").append(this.getPassword());
        url.append("&phone=").append(message.getTo());
        url.append("&sms=").append(SmsxchangeGateImpl.encode((String)message.getText()));
        return url.toString();
    }

    private String getUserId() {
        String userId = this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_USERID);
        if (Utils.isBlank((String)userId)) {
            throw new IllegalArgumentException("Blank userId");
        }
        return userId;
    }

    private String getPassword() {
        String password = this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_PASSWORD);
        if (Utils.isBlank((String)password)) {
            throw new IllegalArgumentException("Blank password");
        }
        return password;
    }

    private static String encode(String text) {
        for (Map.Entry entry : MSG_RESTRICTED_CHARS.entrySet()) {
            text = text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return text;
    }

    public static void main(String[] args) {
        String text = "a&b+c%d#e f=g";
        System.out.println(">>>>> " + SmsxchangeGateImpl.encode((String)text));
    }

    private String getEndpoint() {
        String endpoint = this.parameterService.getString(ParameterService.ParameterCode.SMSXCHANGE_ENDPOINT);
        if (Utils.isBlank((String)endpoint)) {
            throw new IllegalArgumentException("Blank endpoint");
        }
        return endpoint;
    }

    private boolean getAllowInsecure() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.SMSXCHANGE_ALLOW_INSECURE, false);
    }

    static /* synthetic */ BlockingQueue access$0(SmsxchangeGateImpl smsxchangeGateImpl) {
        return smsxchangeGateImpl.queue;
    }

    static /* synthetic */ boolean access$1(SmsxchangeGateImpl smsxchangeGateImpl, Message message) {
        return smsxchangeGateImpl.doSend(message);
    }

    static /* synthetic */ Logger access$2() {
        return log;
    }
}

