/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.marre.SmsSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.notification.SmsGate;
import pl.smartapps.restserver.service.notification.impl.SmsGateImpl;
import pl.smartapps.restserver.util.ExceptionsTrigger;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class SmsGateImpl
implements SmsGate {
    private static Logger log = Logger.getLogger(SmsGateImpl.class);
    private ParameterService parameterService;
    private TaskExecutor taskExecutor;
    private BlockingQueue<Message> queue = new PriorityBlockingQueue();
    private String host;
    private Integer port;
    private String user;
    private String password;
    private String from;
    private boolean discardMessages;
    private Sender sender;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @PostConstruct
    public void setUp() {
        this.host = this.parameterService.getParameterValue(ParameterService.ParameterCode.SMS_SENDER_HOST);
        if (this.host == null) {
            log.warn((Object)"SMS-C configuration missing, SmsSender disabled");
            return;
        }
        ExceptionsTrigger.throwIfNull((Object)this.host, (RuntimeException)new NullPointerException("host"));
        this.port = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.SMS_SENDER_PORT);
        ExceptionsTrigger.throwIfNull((Object)this.port, (RuntimeException)new NullPointerException("port"));
        this.user = this.parameterService.getParameterValue(ParameterService.ParameterCode.SMS_SENDER_USER);
        ExceptionsTrigger.throwIfNull((Object)this.user, (RuntimeException)new NullPointerException("user"));
        this.password = this.parameterService.getParameterValue(ParameterService.ParameterCode.SMS_SENDER_PASSORD);
        ExceptionsTrigger.throwIfNull((Object)this.password, (RuntimeException)new NullPointerException("password"));
        this.from = this.parameterService.getParameterValue(ParameterService.ParameterCode.SMS_SENDER_FROM);
        ExceptionsTrigger.throwIfNull((Object)this.from, (RuntimeException)new NullPointerException("from"));
        this.sender = new Sender(this, null);
        this.taskExecutor.execute((Runnable)this.sender);
    }

    @PreDestroy
    public void tearDown() {
        if (this.sender != null) {
            Sender.access$1((Sender)this.sender, (boolean)false);
        }
    }

    public void send(String phoneNumber, String text) {
        if (this.sender != null) {
            this.queue.add(new Message(phoneNumber, text));
        } else {
            log.warn((Object)"SMS-C configuration missing, send SMS request ignored");
        }
    }

    public boolean sendSynchronously(String phoneNumber, String text) {
        if (this.sender != null) {
            return this.doSend(new Message(phoneNumber, text));
        }
        log.warn((Object)"SMS-C configuration missing, send SMS request ignored");
        return true;
    }

    private boolean doSend(Message message) {
        if (this.discardMessages) {
            log.info((Object)("Discarding message " + message));
            return true;
        }
        log.debug((Object)("Sending SMS: " + message));
        SmsSender smsSender = null;
        try {
            try {
                smsSender = SmsSender.getUcpSender((String)this.host, (int)this.port, (String)this.user, (String)this.password);
                smsSender.connect();
                smsSender.sendTextSms(message.getText(), message.getTo(), this.from);
            }
            catch (Exception e) {
                log.error((Object)("Failed to send message " + message), (Throwable)e);
                try {
                    if (smsSender != null) {
                        smsSender.disconnect();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (smsSender != null) {
                    smsSender.disconnect();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    static /* synthetic */ BlockingQueue access$0(SmsGateImpl smsGateImpl) {
        return smsGateImpl.queue;
    }

    static /* synthetic */ boolean access$1(SmsGateImpl smsGateImpl, Message message) {
        return smsGateImpl.doSend(message);
    }

    static /* synthetic */ Logger access$2() {
        return log;
    }
}

