/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import java.util.UUID;
import javax.mail.Message;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.NotificationTokenDAO;
import pl.smartapps.restserver.db.main.NotificationTokenEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.service.NotificationService;
import pl.smartapps.restserver.service.notification.EmailGate;
import pl.smartapps.restserver.service.notification.GenerateTokenException;
import pl.smartapps.restserver.service.notification.PushNotificationGate;
import pl.smartapps.restserver.service.notification.RemoveTokenException;
import pl.smartapps.restserver.service.notification.SendNotificationException;
import pl.smartapps.restserver.service.notification.SendNotificationRequest;
import pl.smartapps.restserver.service.notification.SmsGate;
import pl.smartapps.restserver.service.notification.UpdateTokenException;
import pl.smartapps.restserver.service.notification.impl.EmailGateImpl;
import pl.smartapps.restserver.service.notification.impl.NotificationServiceImpl;
import pl.smartapps.restserver.util.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={NotificationServiceImpl.class, Utils.class, UUID.class, NotificationTokenEntity.class, EmailGateImpl.Message.class})
public class NotificationServiceImplTests {
    private NotificationServiceImpl notificationService;
    private NotificationTokenDAO notificationTokenDAO;
    private EmailGate emailGate;
    private SmsGate smsGate;
    private PushNotificationGate apnsNotificationGate;
    private PushNotificationGate gcmNotificationGate;

    @Before
    public void setUp() {
        this.notificationService = new NotificationServiceImpl();
        this.notificationTokenDAO = (NotificationTokenDAO)PowerMock.createMock(NotificationTokenDAO.class);
        this.notificationService.setNotificationTokenDAO(this.notificationTokenDAO);
        this.emailGate = (EmailGate)PowerMock.createMock(EmailGate.class);
        this.notificationService.setEmailGate(this.emailGate);
        this.smsGate = (SmsGate)PowerMock.createMock(SmsGate.class);
        this.notificationService.setSmsGate(this.smsGate);
        this.apnsNotificationGate = (PushNotificationGate)PowerMock.createMock(PushNotificationGate.class);
        this.notificationService.setApnsNotificationGate(this.apnsNotificationGate);
        this.gcmNotificationGate = (PushNotificationGate)PowerMock.createMock(PushNotificationGate.class);
        this.notificationService.setGcmNotificationGate(this.gcmNotificationGate);
        PowerMock.mockStatic(Utils.class);
        PowerMock.mockStatic(UUID.class);
    }

    @Test
    public void testGenreateNotificationTokenSuccessfully() throws Exception {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        NotificationService.NotificationType type = NotificationService.NotificationType.EMAIL;
        String recipient = "test@test.pl";
        String generatedToken = "00000000-0000-0000-0000-000000000000";
        EasyMock.expect((Object)Utils.isBlank((String)recipient)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        PowerMock.expectNew(NotificationTokenEntity.class, (Object[])new Object[0]).andReturn((Object)notificationToken);
        notificationToken.setUser(user);
        notificationToken.setType(type);
        notificationToken.setRecipient(recipient);
        notificationToken.setToken(generatedToken);
        UUID uuid = (UUID)PowerMock.createMock(UUID.class);
        EasyMock.expect((Object)UUID.randomUUID()).andReturn((Object)uuid);
        EasyMock.expect((Object)this.notificationTokenDAO.store(notificationToken)).andReturn((Object)notificationToken);
        EasyMock.expect((Object)notificationToken.getToken()).andReturn((Object)generatedToken);
        PowerMock.replayAll((Object[])new Object[0]);
        GenerateTokenException.ErrorCode errorCode = null;
        String token = null;
        try {
            token = this.notificationService.genreateNotificationToken(user, type, recipient);
        }
        catch (GenerateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
        Assert.assertEquals((Object)generatedToken, (Object)token);
    }

    @Test
    public void testGenreateNotificationTokenFailure() throws Exception {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        NotificationService.NotificationType type = NotificationService.NotificationType.EMAIL;
        String recipient = "test@test.pl";
        String generatedToken = "00000000-0000-0000-0000-000000000000";
        EasyMock.expect((Object)Utils.isBlank((String)recipient)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        PowerMock.expectNew(NotificationTokenEntity.class, (Object[])new Object[0]).andReturn((Object)notificationToken);
        notificationToken.setUser(user);
        notificationToken.setType(type);
        notificationToken.setRecipient(recipient);
        notificationToken.setToken(generatedToken);
        UUID uuid = (UUID)PowerMock.createMock(UUID.class);
        EasyMock.expect((Object)UUID.randomUUID()).andReturn((Object)uuid);
        EasyMock.expect((Object)this.notificationTokenDAO.store(notificationToken)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GenerateTokenException.ErrorCode errorCode = null;
        String token = null;
        try {
            token = this.notificationService.genreateNotificationToken(user, type, recipient);
        }
        catch (GenerateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)GenerateTokenException.ErrorCode.ERROR, (Object)errorCode);
        Assert.assertEquals(null, (Object)token);
    }

    @Test
    public void testGenreateNotificationTokenBlankRecipient() throws Exception {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        NotificationService.NotificationType type = NotificationService.NotificationType.EMAIL;
        String recipient = "test@test.pl";
        EasyMock.expect((Object)Utils.isBlank((String)recipient)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        GenerateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.genreateNotificationToken(user, type, recipient);
        }
        catch (GenerateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)GenerateTokenException.ErrorCode.NO_RECIPIENT, (Object)errorCode);
    }

    @Test
    public void testGenreateNotificationTokenNoNotificationType() throws Exception {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        NotificationService.NotificationType type = null;
        String recipient = "test@test.pl";
        PowerMock.replayAll((Object[])new Object[0]);
        GenerateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.genreateNotificationToken(user, type, recipient);
        }
        catch (GenerateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)GenerateTokenException.ErrorCode.NO_NOTIFICATION_TYPE, (Object)errorCode);
    }

    @Test
    public void testGenreateNotificationTokenNotAuthorized() throws Exception {
        UserEntity user = null;
        NotificationService.NotificationType type = NotificationService.NotificationType.EMAIL;
        String recipient = "test@test.pl";
        PowerMock.replayAll((Object[])new Object[0]);
        GenerateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.genreateNotificationToken(user, type, recipient);
        }
        catch (GenerateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)GenerateTokenException.ErrorCode.NOT_AUTHORIZED, (Object)errorCode);
    }

    @Test
    public void testUpdateNotificationTokenSuccessfully() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        String recipient = "new@test.com";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)recipient)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        UserEntity tokenUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)notificationToken.getUser()).andReturn((Object)tokenUser);
        EasyMock.expect((Object)tokenUser.getId()).andReturn((Object)12);
        EasyMock.expect((Object)user.getId()).andReturn((Object)12);
        notificationToken.setRecipient(recipient);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.updateNotificationToken(user, token, recipient);
        }
        catch (UpdateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testUpdateNotificationTokenUserIdDoNotMatch() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        String recipient = "new@test.com";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)recipient)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        UserEntity tokenUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)notificationToken.getUser()).andReturn((Object)tokenUser);
        EasyMock.expect((Object)tokenUser.getId()).andReturn((Object)12);
        EasyMock.expect((Object)user.getId()).andReturn((Object)11);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.updateNotificationToken(user, token, recipient);
        }
        catch (UpdateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)UpdateTokenException.ErrorCode.TOKEN_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testUpdateNotificationTokenNotFound() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        String recipient = "new@test.com";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)recipient)).andReturn((Object)false);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.updateNotificationToken(user, token, recipient);
        }
        catch (UpdateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)UpdateTokenException.ErrorCode.TOKEN_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testUpdateNotificationTokenBlankRecipient() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        String recipient = "new@test.com";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)Utils.isBlank((String)recipient)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.updateNotificationToken(user, token, recipient);
        }
        catch (UpdateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)UpdateTokenException.ErrorCode.NO_RECIPIENT, (Object)errorCode);
    }

    @Test
    public void testUpdateNotificationTokenBlankToken() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        String recipient = "new@test.com";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.updateNotificationToken(user, token, recipient);
        }
        catch (UpdateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)UpdateTokenException.ErrorCode.NO_TOKEN, (Object)errorCode);
    }

    @Test
    public void testUpdateNotificationTokenNotAuthorized() {
        UserEntity user = null;
        String token = "testToken";
        String recipient = "new@test.com";
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateTokenException.ErrorCode errorCode = null;
        try {
            this.notificationService.updateNotificationToken(user, token, recipient);
        }
        catch (UpdateTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)UpdateTokenException.ErrorCode.NOT_AUTHORIZED, (Object)errorCode);
    }

    @Test
    public void testSendEmailNotificationSuccessfully() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text).times(2);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        EasyMock.expect((Object)notificationToken.getType()).andReturn((Object)NotificationService.NotificationType.EMAIL);
        String subject = "testSubject";
        EasyMock.expect((Object)request.getSubject()).andReturn((Object)subject).times(2);
        EasyMock.expect((Object)Utils.isBlank((String)subject)).andReturn((Object)false);
        Boolean html = true;
        EasyMock.expect((Object)request.getHtml()).andReturn((Object)html).times(2);
        EmailGateImpl.Message message = (EmailGateImpl.Message)PowerMock.createMock(EmailGateImpl.Message.class);
        PowerMock.expectNew(EmailGateImpl.Message.class, (Object[])new Object[0]).andReturn((Object)message);
        String recipient = "testRecipient";
        EasyMock.expect((Object)notificationToken.getRecipient()).andReturn((Object)recipient);
        message.addRecipient(Message.RecipientType.TO, recipient);
        message.setSubject(subject);
        message.setText(text);
        message.setHtml(html.booleanValue());
        this.emailGate.send(new EmailGateImpl.Message[]{message});
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testSendEmailNotificationMissingHtml() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        EasyMock.expect((Object)notificationToken.getType()).andReturn((Object)NotificationService.NotificationType.EMAIL);
        String subject = "testSubject";
        EasyMock.expect((Object)request.getSubject()).andReturn((Object)subject);
        EasyMock.expect((Object)Utils.isBlank((String)subject)).andReturn((Object)false);
        EasyMock.expect((Object)request.getHtml()).andReturn(null);
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)SendNotificationException.ErrorCode.NO_HTML, (Object)errorCode);
    }

    @Test
    public void testSendEmailNotificationBlankSubject() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        EasyMock.expect((Object)notificationToken.getType()).andReturn((Object)NotificationService.NotificationType.EMAIL);
        String subject = "testSubject";
        EasyMock.expect((Object)request.getSubject()).andReturn((Object)subject);
        EasyMock.expect((Object)Utils.isBlank((String)subject)).andReturn((Object)true);
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)SendNotificationException.ErrorCode.NO_SUBJECT, (Object)errorCode);
    }

    @Test
    public void testSendSmsNotificationSuccessfully() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text).times(2);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        EasyMock.expect((Object)notificationToken.getType()).andReturn((Object)NotificationService.NotificationType.SMS);
        String recipient = "testRecipient";
        EasyMock.expect((Object)notificationToken.getRecipient()).andReturn((Object)recipient);
        this.smsGate.send(recipient, text);
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testSendApnsNotificationSuccessfully() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text).times(2);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        EasyMock.expect((Object)notificationToken.getType()).andReturn((Object)NotificationService.NotificationType.APNS);
        String recipient = "testRecipient";
        EasyMock.expect((Object)notificationToken.getRecipient()).andReturn((Object)recipient);
        EasyMock.expect((Object)this.apnsNotificationGate.sendMessage(recipient, text)).andReturn((Object)true);
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testSendGcmNotificationSuccessfully() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text).times(2);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        EasyMock.expect((Object)notificationToken.getType()).andReturn((Object)NotificationService.NotificationType.GCM);
        String recipient = "testRecipient";
        EasyMock.expect((Object)notificationToken.getRecipient()).andReturn((Object)recipient);
        EasyMock.expect((Object)this.gcmNotificationGate.sendMessage(recipient, text)).andReturn((Object)true);
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testSendNotificationTokenNotFound() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)false);
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn(null);
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)SendNotificationException.ErrorCode.TOKEN_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testSendNotificationBlankText() throws Exception {
        SendNotificationRequest request = (SendNotificationRequest)PowerMock.createMock(SendNotificationRequest.class);
        String token = "testToken";
        String text = "testText";
        EasyMock.expect((Object)request.getToken()).andReturn((Object)token);
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)request.getText()).andReturn((Object)text);
        EasyMock.expect((Object)Utils.isBlank((String)text)).andReturn((Object)true);
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)SendNotificationException.ErrorCode.NO_TEXT, (Object)errorCode);
    }

    @Test
    public void testSendNotificationNullRequest() throws Exception {
        SendNotificationRequest request = null;
        SendNotificationException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.sendNotification(request);
        }
        catch (SendNotificationException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)SendNotificationException.ErrorCode.NO_DATA, (Object)errorCode);
    }

    @Test
    public void testRemoveNotificationTokenSuccessfully() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        NotificationTokenEntity notificationToken = (NotificationTokenEntity)PowerMock.createMock(NotificationTokenEntity.class);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn((Object)notificationToken);
        this.notificationTokenDAO.remove(notificationToken);
        RemoveTokenException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.removeNotificationToken(user, token);
        }
        catch (RemoveTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals(null, (Object)errorCode);
    }

    @Test
    public void testRemoveNotificationTokenNotFound() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)false);
        EasyMock.expect((Object)this.notificationTokenDAO.getByToken(token)).andReturn(null);
        RemoveTokenException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.removeNotificationToken(user, token);
        }
        catch (RemoveTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RemoveTokenException.ErrorCode.TOKEN_NOT_FOUND, (Object)errorCode);
    }

    @Test
    public void testRemoveNotificationTokenNoToken() {
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        String token = "testToken";
        EasyMock.expect((Object)Utils.isBlank((String)token)).andReturn((Object)true);
        RemoveTokenException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.removeNotificationToken(user, token);
        }
        catch (RemoveTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RemoveTokenException.ErrorCode.NO_TOKEN, (Object)errorCode);
    }

    @Test
    public void testRemoveNotificationTokenNotAuthorized() {
        UserEntity user = null;
        String token = "testToken";
        RemoveTokenException.ErrorCode errorCode = null;
        PowerMock.replayAll((Object[])new Object[0]);
        try {
            this.notificationService.removeNotificationToken(user, token);
        }
        catch (RemoveTokenException ex) {
            errorCode = ex.getErrorCode();
        }
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RemoveTokenException.ErrorCode.NOT_AUTHORIZED, (Object)errorCode);
    }
}

