/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import java.util.UUID;
import javax.mail.Message;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.restserver.db.dao.NotificationTokenDAO;
import pl.smartapps.restserver.db.main.NotificationTokenEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.service.NotificationService;
import pl.smartapps.restserver.service.notification.EmailGate;
import pl.smartapps.restserver.service.notification.GenerateTokenException;
import pl.smartapps.restserver.service.notification.PushNotificationGate;
import pl.smartapps.restserver.service.notification.RemoveTokenException;
import pl.smartapps.restserver.service.notification.SendNotificationException;
import pl.smartapps.restserver.service.notification.SendNotificationRequest;
import pl.smartapps.restserver.service.notification.SmsGate;
import pl.smartapps.restserver.service.notification.UpdateTokenException;
import pl.smartapps.restserver.service.notification.impl.EmailGateImpl;
import pl.smartapps.restserver.util.Utils;

@Service
public class NotificationServiceImpl
implements NotificationService {
    private static final Logger log = Logger.getLogger(NotificationServiceImpl.class);
    private NotificationTokenDAO notificationTokenDAO;
    private EmailGate emailGate;
    private SmsGate smsGate;
    private PushNotificationGate apnsNotificationGate;
    private PushNotificationGate gcmNotificationGate;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$service$NotificationService$NotificationType;

    @Autowired
    @Required
    public void setNotificationTokenDAO(NotificationTokenDAO notificationTokenDAO) {
        this.notificationTokenDAO = notificationTokenDAO;
    }

    @Autowired
    @Required
    public void setEmailGate(EmailGate emailGate) {
        this.emailGate = emailGate;
    }

    @Autowired
    @Required
    @Qualifier(value="smsxchangeGateImpl")
    public void setSmsGate(SmsGate smsGate) {
        this.smsGate = smsGate;
    }

    @Autowired
    @Required
    @Qualifier(value="apnsNotificationGateImpl")
    public void setApnsNotificationGate(PushNotificationGate apnsNotificationGate) {
        this.apnsNotificationGate = apnsNotificationGate;
    }

    @Autowired
    @Required
    @Qualifier(value="gcmNotificationGateImpl")
    public void setGcmNotificationGate(PushNotificationGate gcmNotificationGate) {
        this.gcmNotificationGate = gcmNotificationGate;
    }

    @Transactional
    public String genreateNotificationToken(UserEntity user, NotificationService.NotificationType type, String recipient) {
        log.trace((Object)("start genreateNotificationToken(user=" + user + ", type=" + type + ", recipient=" + recipient + ")"));
        this.validate(user, type, recipient);
        NotificationTokenEntity notificationToken = new NotificationTokenEntity();
        notificationToken.setUser(user);
        notificationToken.setType(type);
        notificationToken.setRecipient(recipient);
        notificationToken.setToken(UUID.randomUUID().toString());
        if (this.notificationTokenDAO.store(notificationToken) == null) {
            log.warn((Object)("Failed to store notification token for user=" + user + ", type=" + type + ", recipient=" + recipient + "."));
            throw new GenerateTokenException(GenerateTokenException.ErrorCode.ERROR);
        }
        return notificationToken.getToken();
    }

    private void validate(UserEntity user, NotificationService.NotificationType type, String recipient) {
        if (user == null) {
            throw new GenerateTokenException(GenerateTokenException.ErrorCode.NOT_AUTHORIZED);
        }
        if (type == null) {
            throw new GenerateTokenException(GenerateTokenException.ErrorCode.NO_NOTIFICATION_TYPE);
        }
        if (Utils.isBlank((String)recipient)) {
            throw new GenerateTokenException(GenerateTokenException.ErrorCode.NO_RECIPIENT);
        }
    }

    @Transactional
    public void updateNotificationToken(UserEntity user, String token, String recipient) {
        log.trace((Object)("start updateNotificationToken(user=" + user + ", token=" + token + ", recipient=" + recipient + ")"));
        this.validateUpdateNotificationToken(user, token, recipient);
        NotificationTokenEntity notificationToken = this.notificationTokenDAO.getByToken(token);
        if (notificationToken == null || !notificationToken.getUser().getId().equals(user.getId())) {
            throw new UpdateTokenException(UpdateTokenException.ErrorCode.TOKEN_NOT_FOUND);
        }
        notificationToken.setRecipient(recipient);
    }

    private void validateUpdateNotificationToken(UserEntity user, String token, String recipient) {
        if (user == null) {
            throw new UpdateTokenException(UpdateTokenException.ErrorCode.NOT_AUTHORIZED);
        }
        if (Utils.isBlank((String)token)) {
            throw new UpdateTokenException(UpdateTokenException.ErrorCode.NO_TOKEN);
        }
        if (Utils.isBlank((String)recipient)) {
            throw new UpdateTokenException(UpdateTokenException.ErrorCode.NO_RECIPIENT);
        }
    }

    /*
     * Exception decompiling
     */
    public void sendNotification(SendNotificationRequest request) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private EmailGateImpl.Message getEmailMessage(NotificationTokenEntity notificationToken, SendNotificationRequest request) {
        if (Utils.isBlank((String)request.getSubject())) {
            throw new SendNotificationException(SendNotificationException.ErrorCode.NO_SUBJECT);
        }
        if (request.getHtml() == null) {
            throw new SendNotificationException(SendNotificationException.ErrorCode.NO_HTML);
        }
        EmailGateImpl.Message message = new EmailGateImpl.Message();
        message.addRecipient(Message.RecipientType.TO, notificationToken.getRecipient());
        message.setSubject(request.getSubject());
        message.setText(request.getText());
        message.setHtml(request.getHtml().booleanValue());
        return message;
    }

    @Transactional
    public void removeNotificationToken(UserEntity user, String token) {
        log.trace((Object)("start removeNotificationToken(user=" + user + ", token=" + token + ")"));
        if (user == null) {
            throw new RemoveTokenException(RemoveTokenException.ErrorCode.NOT_AUTHORIZED);
        }
        if (Utils.isBlank((String)token)) {
            throw new RemoveTokenException(RemoveTokenException.ErrorCode.NO_TOKEN);
        }
        NotificationTokenEntity notificationToken = this.notificationTokenDAO.getByToken(token);
        if (notificationToken == null) {
            throw new RemoveTokenException(RemoveTokenException.ErrorCode.TOKEN_NOT_FOUND);
        }
        this.notificationTokenDAO.remove(notificationToken);
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$service$NotificationService$NotificationType() {
        if ($SWITCH_TABLE$pl$smartapps$restserver$service$NotificationService$NotificationType != null) {
            return $SWITCH_TABLE$pl$smartapps$restserver$service$NotificationService$NotificationType;
        }
        int[] nArray = new int[NotificationService.NotificationType.values().length];
        try {
            nArray[NotificationService.NotificationType.APNS.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NotificationService.NotificationType.EMAIL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NotificationService.NotificationType.GCM.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[NotificationService.NotificationType.SMS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$restserver$service$NotificationService$NotificationType = nArray;
        return nArray;
    }
}

