/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import com.notnoop.apns.ApnsService;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.service.notification.impl.ApnsServiceFactory;
import pl.smartapps.restserver.service.notification.impl.InactiveAppleDeviceService;
import pl.smartapps.restserver.util.MasterInhibitor;

@Service
public class InactiveAppleDeviceServiceImpl
implements InactiveAppleDeviceService {
    private static Logger log = Logger.getLogger(InactiveAppleDeviceServiceImpl.class);
    @Autowired
    private ApnsServiceFactory apnsServiceFactory;
    @Autowired
    private EventNotificationDAO eventNotificationDAO;

    public void setApnsServiceFactory(ApnsServiceFactory apnsServiceFactory) {
        this.apnsServiceFactory = apnsServiceFactory;
    }

    public void setEventNotificationDAO(EventNotificationDAO eventNotificationDAO) {
        this.eventNotificationDAO = eventNotificationDAO;
    }

    @Transactional
    public void deleteInactiveDevices() {
        log.debug((Object)"start deleteInactiveDevices()");
        if (!MasterInhibitor.canPerformMasterTask()) {
            return;
        }
        ApnsService service = this.apnsServiceFactory.getInstance();
        if (service == null) {
            log.debug((Object)"APNS service is null");
            return;
        }
        try {
            service.start();
            Map inactiveDevices = service.getInactiveDevices();
            log.debug((Object)("Number of inactive apple device to remove: " + inactiveDevices.size()));
            if (inactiveDevices.size() > 0) {
                int removedEntitiesCount = this.eventNotificationDAO.removeEventNotifications(inactiveDevices.keySet());
                log.debug((Object)("Number of deleted inactive event notifications: " + removedEntitiesCount));
            }
        }
        finally {
            if (service != null) {
                service.stop();
            }
        }
    }
}

