/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.ConnectionListener;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.tcp.XMPPTCPConnection;
import org.json.simple.JSONValue;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.notification.PushNotificationException;
import pl.smartapps.restserver.service.notification.PushNotificationGate;
import pl.smartapps.restserver.service.notification.impl.GcmNotificationGateImpl;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class GcmNotificationGateImpl
implements PushNotificationGate {
    private static final Logger log = Logger.getLogger(GcmNotificationGateImpl.class);
    private static final String GCM_SERVER = "gcm.googleapis.com";
    private static final int GCM_PORT = 5235;
    private static final String GCM_DEV_SERVER = "gcm-preprod.googleapis.com";
    private static final int GCM_DEV_PORT = 5236;
    private static final String GCM_ELEMENT_NAME = "gcm";
    private static final String GCM_NAMESPACE = "google:mobile:data";
    private ParameterService parameterService;
    private TaskExecutor taskExecutor;
    private BlockingQueue<MessageData> queue = new LinkedBlockingQueue();
    private boolean discardMessages;
    private Sender sender;
    private XMPPConnection connection;
    protected volatile boolean connectionDraining = false;

    static {
        ProviderManager.addExtensionProvider((String)"gcm", (String)"google:mobile:data", (Object)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @PostConstruct
    public void setUp() {
        this.sender = new Sender(this, null);
        this.taskExecutor.execute((Runnable)this.sender);
    }

    @PreDestroy
    public void tearDown() {
        Sender.access$1((Sender)this.sender, (boolean)false);
    }

    public boolean sendMessage(String token, String message) {
        log.trace((Object)("start sendMessage(token=" + token + ", message=" + message));
        if (Utils.isBlank((String)token)) {
            throw new PushNotificationException(PushNotificationException.ErrorCode.NO_TOKEN);
        }
        if (Utils.isBlank((String)message)) {
            throw new PushNotificationException(PushNotificationException.ErrorCode.NO_PAYLOAD);
        }
        Payload payload = new Payload(this, message);
        MessageData messageData = new MessageData(token, payload);
        this.queue.add(messageData);
        return true;
    }

    private String createJsonMessage(String toRegId, Payload payload) {
        return this.createJsonMessage(toRegId, this.nextMessageId(), payload.getData(), payload.getCollapseKey(), payload.getTimeToLive(), payload.getDelayWhileIdle());
    }

    private boolean sendDownstreamMessage(String jsonRequest) throws SmackException.NotConnectedException {
        log.trace((Object)("sending message: " + jsonRequest));
        if (!this.connectionDraining) {
            this.send(jsonRequest);
            return true;
        }
        log.warn((Object)"Dropping downstream message since the connection is draining");
        return false;
    }

    private String nextMessageId() {
        return "m-" + UUID.randomUUID().toString();
    }

    protected void send(String jsonRequest) throws SmackException.NotConnectedException {
        Packet request = new GcmPacketExtension(jsonRequest).toPacket();
        this.connection.sendPacket(request);
    }

    protected void handleUpstreamMessage(Map<String, Object> jsonObject) {
        String category = (String)jsonObject.get("category");
        String from = (String)jsonObject.get("from");
        Map payload = (Map)jsonObject.get("data");
        payload.put("ECHO", "Application: " + category);
        String echo = this.createJsonMessage(from, this.nextMessageId(), payload, "echo:CollapseKey", null, Boolean.valueOf(false));
        try {
            this.sendDownstreamMessage(echo);
        }
        catch (SmackException.NotConnectedException e) {
            log.warn((Object)"Not connected anymore, echo message is not sent", (Throwable)e);
        }
    }

    protected void handleAckReceipt(Map<String, Object> jsonObject) {
        String messageId = (String)jsonObject.get("message_id");
        String from = (String)jsonObject.get("from");
        log.debug((Object)("handleAckReceipt() from: " + from + ", messageId: " + messageId));
    }

    protected void handleNackReceipt(Map<String, Object> jsonObject) {
        String messageId = (String)jsonObject.get("message_id");
        String from = (String)jsonObject.get("from");
        log.debug((Object)("handleNackReceipt() from: " + from + ", messageId: " + messageId));
    }

    protected void handleControlMessage(Map<String, Object> jsonObject) throws Exception {
        log.debug((Object)("handleControlMessage(): " + jsonObject));
        String controlType = (String)jsonObject.get("control_type");
        if ("CONNECTION_DRAINING".equals(controlType)) {
            this.connect();
        } else {
            log.warn((Object)("Unrecognized control type: " + controlType + ". This could happen if new features are added to the CCS protocol."));
        }
    }

    private String createJsonMessage(String to, String messageId, Map<String, String> payload, String collapseKey, Long timeToLive, Boolean delayWhileIdle) {
        log.trace((Object)("start createJsonMessage(to=" + to + ", messageId=" + messageId + ", payload=" + payload + ", collapseKey=" + collapseKey + ", timeToLive=" + timeToLive + ", delayWhileIdle=" + delayWhileIdle + ")"));
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("to", to);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive != null) {
            message.put("time_to_live", timeToLive);
        }
        if (delayWhileIdle != null && delayWhileIdle.booleanValue()) {
            message.put("delay_while_idle", true);
        }
        message.put("message_id", messageId);
        message.put("data", payload);
        return JSONValue.toJSONString(message);
    }

    protected static String createJsonAck(String to, String messageId) {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("message_type", "ack");
        message.put("to", to);
        message.put("message_id", messageId);
        return JSONValue.toJSONString(message);
    }

    private void connect() throws XMPPException, IOException, SmackException {
        ConnectionConfiguration config = null;
        config = this.isDevMode() ? new ConnectionConfiguration("gcm-preprod.googleapis.com", 5236) : new ConnectionConfiguration("gcm.googleapis.com", 5235);
        config.setSecurityMode(ConnectionConfiguration.SecurityMode.enabled);
        config.setReconnectionAllowed(true);
        config.setRosterLoadedAtLogin(false);
        config.setSendPresence(false);
        config.setSocketFactory(SSLSocketFactory.getDefault());
        this.connection = new XMPPTCPConnection(config);
        this.connection.connect();
        this.connection.addConnectionListener((ConnectionListener)new LoggingConnectionListener(null));
        this.connection.addPacketListener((PacketListener)new /* Unavailable Anonymous Inner Class!! */, (PacketFilter)new PacketTypeFilter(Message.class));
        this.connection.addPacketInterceptor((PacketInterceptor)new /* Unavailable Anonymous Inner Class!! */, (PacketFilter)new PacketTypeFilter(Message.class));
        this.connection.login(this.getSenderId() + "@gcm.googleapis.com", this.getApiKey());
    }

    private boolean isDevMode() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.GCM_DEV_MODE, false);
    }

    private Long getSenderId() {
        Long senderId = this.parameterService.getLongParameterValue(ParameterService.ParameterCode.GCM_SENDER_ID);
        if (senderId == null) {
            log.warn((Object)"Parameter with code GCM_SENDER_ID is missing.");
            throw new PushNotificationException(PushNotificationException.ErrorCode.ERROR);
        }
        return senderId;
    }

    private String getApiKey() {
        String apiKey = this.parameterService.getParameterValue(ParameterService.ParameterCode.GCM_API_KEY);
        if (Utils.isBlank((String)apiKey)) {
            log.warn((Object)"Parameter with code GCM_API_KEY is missing.");
            throw new PushNotificationException(PushNotificationException.ErrorCode.ERROR);
        }
        return apiKey;
    }

    private boolean doSend(MessageData message) {
        if (this.discardMessages) {
            log.info((Object)("Discarding message " + message));
            return true;
        }
        log.info((Object)("Sending GCM notification: " + message));
        try {
            if (this.connection == null || !this.connection.isConnected()) {
                this.connect();
            }
            return this.sendDownstreamMessage(this.createJsonMessage(message.getToken(), message.getPayload()));
        }
        catch (Exception ex) {
            log.error((Object)("Failed to send message " + message), (Throwable)ex);
            return false;
        }
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ BlockingQueue access$1(GcmNotificationGateImpl gcmNotificationGateImpl) {
        return gcmNotificationGateImpl.queue;
    }

    static /* synthetic */ boolean access$2(GcmNotificationGateImpl gcmNotificationGateImpl, MessageData messageData) {
        return gcmNotificationGateImpl.doSend(messageData);
    }
}

