/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.PriorityBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.service.notification.EmailGate;
import pl.smartapps.restserver.service.notification.impl.EmailGateImpl;

@Service
public class EmailGateImpl
implements EmailGate {
    private static Logger log = Logger.getLogger(EmailGateImpl.class);
    @Value(value="${email.host:localhost}")
    private String host;
    @Value(value="${email.from:team@remote-nas.com}")
    private String from;
    @Value(value="${email.worker.sleep[ms]:10000}")
    private long workerSleepTime;
    @Value(value="${email.worker.try.count:3}")
    private int tryCount;
    @Value(value="${email.enabled:true}")
    private boolean enabled;
    private JavaMailSenderImpl sender;
    private ThreadPoolTaskExecutor taskExecutor;
    private PriorityBlockingQueue<Message> queue = new PriorityBlockingQueue();
    private boolean isRunning = true;

    @Autowired
    @Required
    public void setMailSender(JavaMailSenderImpl sender) {
        this.sender = sender;
    }

    @Autowired
    @Required
    public void setTaskExecutor(ThreadPoolTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @PostConstruct
    public void initialize() {
        this.taskExecutor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }

    @PreDestroy
    private void shutdown() {
        this.isRunning = false;
    }

    public void send(Message ... messages) {
        this.send(Arrays.asList(messages));
    }

    public void send(List<Message> messages) {
        if (this.enabled) {
            this.queue.addAll(messages);
        }
    }

    public boolean sendSynchronously(Message message) {
        return this.enabled ? this.doSend(message) : true;
    }

    private boolean doSend(Message message) {
        try {
            log.info((Object)("Sending message " + message));
            this.sender.setHost(this.host);
            MimeMessage msg = this.sender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(msg, message.isMultipart(), "UTF-8");
            helper.setFrom(this.from);
            this.addRecipients(helper, message);
            helper.setSubject(message.getSubject());
            helper.setText(message.getText(), message.isHtml());
            this.addAttachments(helper, message);
            this.sender.send(msg);
            log.info((Object)"Sent message successfully....");
            return true;
        }
        catch (MessagingException ex) {
            log.warn((Object)String.format("Failed to send message %s, error is %s.", message, ex.getMessage()));
            return false;
        }
    }

    private void addRecipients(MimeMessageHelper helper, Message message) throws MessagingException {
        for (Map.Entry entry : message.getRecipients().entrySet()) {
            for (String recipient : (List)entry.getValue()) {
                this.addRecipient(helper, (Message.RecipientType)entry.getKey(), recipient);
            }
        }
    }

    private void addRecipient(MimeMessageHelper helper, Message.RecipientType recipientType, String recipient) throws MessagingException {
        if (recipientType == Message.RecipientType.CC) {
            helper.addCc(this.address(recipient));
        } else if (recipientType == Message.RecipientType.BCC) {
            helper.addBcc(this.address(recipient));
        } else {
            helper.addTo(this.address(recipient));
        }
    }

    private InternetAddress address(String emailAddress) throws AddressException {
        String email;
        String personal = "";
        int ltIndex = emailAddress.lastIndexOf(60);
        if (ltIndex == -1) {
            email = emailAddress;
        } else {
            int gtIndex = emailAddress.lastIndexOf(62);
            if (gtIndex == -1 || gtIndex < ltIndex) {
                throw new AddressException("invalid email address " + emailAddress);
            }
            personal = emailAddress.substring(0, ltIndex).trim();
            email = emailAddress.substring(ltIndex + 1, gtIndex);
        }
        try {
            return new InternetAddress(email, personal, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void addAttachments(MimeMessageHelper helper, Message message) throws MessagingException {
        if (!message.getAttachments().isEmpty()) {
            for (Message.Attachment attachment : message.getAttachments()) {
                helper.addAttachment(attachment.getName(), attachment.getContent());
            }
        }
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }

    static /* synthetic */ boolean access$1(EmailGateImpl emailGateImpl) {
        return emailGateImpl.isRunning;
    }

    static /* synthetic */ PriorityBlockingQueue access$2(EmailGateImpl emailGateImpl) {
        return emailGateImpl.queue;
    }

    static /* synthetic */ boolean access$3(EmailGateImpl emailGateImpl, Message message) {
        return emailGateImpl.doSend(message);
    }

    static /* synthetic */ int access$4(EmailGateImpl emailGateImpl) {
        return emailGateImpl.tryCount;
    }

    static /* synthetic */ long access$5(EmailGateImpl emailGateImpl) {
        return emailGateImpl.workerSleepTime;
    }
}

