/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import com.notnoop.apns.APNS;
import com.notnoop.apns.ApnsService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.service.ParameterService;

@Component
public class ApnsServiceFactory {
    private static final Logger log = Logger.getLogger(ApnsServiceFactory.class);
    private ParameterService parameterService;
    private String apnsCertificatePath;

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Value(value="${apns.certificatePath}")
    public void setApnsCertificatePath(String apnsCertificatePath) {
        this.apnsCertificatePath = apnsCertificatePath;
    }

    public ApnsService getInstance() {
        File certificate;
        ApnsService service;
        block5: {
            service = null;
            certificate = new File(this.apnsCertificatePath);
            if (certificate.exists() && certificate.isFile() && certificate.canRead()) break block5;
            log.error((Object)"Can't read apns certificate file. APNS service has not been created!");
            return null;
        }
        try {
            FileInputStream certStream = new FileInputStream(certificate);
            String apnsCertificatePass = this.parameterService.getParameterValue(ParameterService.ParameterCode.APNS_CERTIFICATE_PASSWORD);
            if (this.isDevMode()) {
                log.debug((Object)"Creating APSN service with sandbox destination");
                service = APNS.newService().withCert((InputStream)certStream, apnsCertificatePass).withNoErrorDetection().withSandboxDestination().build();
            } else {
                log.debug((Object)"Creating APSN service with production destination");
                service = APNS.newService().withCert((InputStream)certStream, apnsCertificatePass).withNoErrorDetection().withProductionDestination().build();
            }
        }
        catch (IOException ioe) {
            log.error((Object)("Error creating apns service: " + ioe.getMessage()));
        }
        return service;
    }

    private boolean isDevMode() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.APNS_DEV_MODE);
    }
}

