/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.notification.impl;

import com.notnoop.apns.ApnsService;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.service.notification.PushNotificationException;
import pl.smartapps.restserver.service.notification.PushNotificationGate;
import pl.smartapps.restserver.service.notification.impl.ApnsNotificationGateImpl;
import pl.smartapps.restserver.service.notification.impl.ApnsServiceFactory;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class ApnsNotificationGateImpl
implements PushNotificationGate {
    private static Logger log = Logger.getLogger(ApnsNotificationGateImpl.class);
    private ApnsServiceFactory apnsServiceFactory;
    private TaskExecutor taskExecutor;
    private BlockingQueue<Message> queue = new LinkedBlockingQueue();
    private boolean discardMessages;
    private Sender sender;
    private ApnsService apnsService;

    @Autowired
    @Required
    public void setApnsServiceFactory(ApnsServiceFactory apnsServiceFactory) {
        this.apnsServiceFactory = apnsServiceFactory;
    }

    @Autowired
    @Required
    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    @PostConstruct
    public void setUp() {
        this.apnsService = this.apnsServiceFactory.getInstance();
        if (this.apnsService == null) {
            log.warn((Object)"APNS Service has not been obtained. The service will not start...");
            return;
        }
        log.warn((Object)"Starting APNS Service...");
        this.apnsService.start();
        this.sender = new Sender(this, null);
        this.taskExecutor.execute((Runnable)this.sender);
    }

    @PreDestroy
    public void tearDown() {
        Sender.access$1((Sender)this.sender, (boolean)false);
        if (this.isOperable()) {
            this.apnsService.stop();
        }
    }

    private boolean isOperable() {
        return this.apnsService != null;
    }

    public boolean sendMessage(String token, String payload) {
        log.trace((Object)("start sendMessage(token=" + token + ", payload=" + payload + ")"));
        if (Utils.isBlank((String)token)) {
            throw new PushNotificationException(PushNotificationException.ErrorCode.NO_TOKEN);
        }
        if (Utils.isBlank((String)payload)) {
            throw new PushNotificationException(PushNotificationException.ErrorCode.NO_PAYLOAD);
        }
        if (!this.isOperable()) {
            throw new PushNotificationException(PushNotificationException.ErrorCode.ERROR);
        }
        this.queue.add(new Message(token, payload));
        return true;
    }

    private boolean doSend(Message message) {
        if (this.discardMessages) {
            log.info((Object)("Discarding message " + message));
            return true;
        }
        log.info((Object)("Sending APNS notification: " + message));
        try {
            this.apnsService.push(message.getToken(), message.getPayload());
        }
        catch (Exception e) {
            log.error((Object)("Failed to send message " + message), (Throwable)e);
            return false;
        }
        return true;
    }

    static /* synthetic */ BlockingQueue access$0(ApnsNotificationGateImpl apnsNotificationGateImpl) {
        return apnsNotificationGateImpl.queue;
    }

    static /* synthetic */ boolean access$1(ApnsNotificationGateImpl apnsNotificationGateImpl, Message message) {
        return apnsNotificationGateImpl.doSend(message);
    }

    static /* synthetic */ Logger access$2() {
        return log;
    }
}

