/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.SearchCandidatesService;
import pl.smartapps.containerserver.VivotekCameraIpAddressDiscoveryService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.Candidates;
import pl.smartapps.hm.WebViewer.shared.model.ControlParams;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.hm.WebViewer.shared.model.ICEParameters;
import pl.smartapps.hm.WebViewer.shared.model.ICEParams;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LogConfiguration;
import pl.smartapps.hm.WebViewer.shared.model.VideoStreamParams;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.CandidatesResponse;
import pl.smartapps.restserver.rest.response.VideoStreamParamsResponse;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.VideoStreamServiceImpl;
import pl.smartapps.restserver.test.rest.TestDataUtils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={VideoStreamServiceImpl.class, ICEParameters.class, ICEParams.class, LogConfiguration.class, CandidatesResponse.class, CandidatesResponse.class})
public class VideoStreamServiceTests {
    private ControlParams controlParams;
    private VideoStreamServiceImpl videoStreamService;
    private GatewayClientDAO gatewayClientDAO;
    private LanDeviceDAO lanDeviceDAO;
    private AuthenticationUtils authUtils;
    private DeviceDriverFactory deviceDriverFactory;
    private ContainerserverServiceFactory containerserverServiceFactory;
    private EventlogService eventlogService;
    private ParameterService parameterService;

    @Before
    public void setUp() throws ClassNotFoundException, SQLException {
        this.videoStreamService = new VideoStreamServiceImpl();
        this.deviceDriverFactory = (DeviceDriverFactory)PowerMock.createMock(DeviceDriverFactory.class);
        this.videoStreamService.setDeviceDriverFactory(this.deviceDriverFactory);
        this.containerserverServiceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.videoStreamService.setContainerserverServiceFactory(this.containerserverServiceFactory);
        this.gatewayClientDAO = (GatewayClientDAO)PowerMock.createMock(GatewayClientDAO.class);
        this.videoStreamService.setGatewayClientDAO(this.gatewayClientDAO);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.videoStreamService.setLanDeviceDAO(this.lanDeviceDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.videoStreamService.setAuthUtils(this.authUtils);
        this.eventlogService = (EventlogService)PowerMock.createMock(EventlogService.class);
        this.videoStreamService.setEventlogService(this.eventlogService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.videoStreamService.setParameterService(this.parameterService);
        this.controlParams = new ControlParams();
        this.controlParams.setPanLeft("/cgi-bin/viewer/camctrl.cgi?move=left");
        this.controlParams.setPanRight("/cgi-bin/viewer/camctrl.cgi?move=right");
        this.controlParams.setPanUp("/cgi-bin/viewer/camctrl.cgi?move=up");
        this.controlParams.setPanDown("/cgi-bin/viewer/camctrl.cgi?move=down");
        this.controlParams.setPanCenter("/cgi-bin/viewer/camctrl.cgi?move=home");
        this.controlParams.setZoomIn("/cgi-bin/viewer/camctrl.cgi?zoom=tele");
        this.controlParams.setZoomOut("/cgi-bin/viewer/camctrl.cgi?zoom=wide");
    }

    @Test
    public void testGetVideoStreamPametersForNotExistsLanDevice() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        Integer userId = 11;
        Integer ldId = 1234;
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(ldId, userId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        VideoStreamParamsResponse response = this.videoStreamService.getVideoStreamPameters(ldId, false);
        PowerMock.verifyAll();
        VideoStreamParamsResponse expectedResponse = new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.DEVICENOTFOUND);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetVideoStreamPametersForLegacyModeWithMissingLanDeviceParams() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("router_address", "192.168.21.145", "192.168.21.145");
        device.setParam("router_port", "80", "80");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)driver.getControlParams()).andReturn((Object)this.controlParams);
        PowerMock.replayAll((Object[])new Object[0]);
        VideoStreamParams expectedParams = new VideoStreamParams();
        expectedParams.lanDeviceId = 1;
        expectedParams.gcId = 1;
        expectedParams.type = VideoStreamParams.VideoStreamParamType.HTTP_TCP;
        expectedParams.address = "192.168.21.145";
        expectedParams.port = 80;
        expectedParams.user = "viewerUser";
        expectedParams.pass = "viewerPass";
        expectedParams.path = "video2.mjpg";
        expectedParams.pathLow = "video.mjpg";
        expectedParams.snapshotPath = "/cgi-bin/viewer/video.jpg?resolution=640x480";
        expectedParams.snapshotPathLow = "/cgi-bin/viewer/video.jpg?resolution=320x240";
        expectedParams.controlParams = this.controlParams;
        expectedParams.resolution = "640x480";
        expectedParams.resolutionLow = "320x240";
        VideoStreamParamsResponse expectedResponse = new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK, expectedParams);
        VideoStreamParamsResponse response = this.videoStreamService.getVideoStreamPameters(new Integer(1), false);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetVideoStreamPametersForLegacyModeWithoutMissingLanDeviceParams() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("path_rtsp_over_http_get", "pathRtspOverHttpGet");
        device.setParam("path_low_rtsp_over_http_get", "pathLowRtspOverHttpGet");
        device.setParam("path_rtsp_over_http_post", "pathRtspOverHttpPost");
        device.setParam("path_low_rtsp_over_http_post", "pathLowRtspOverHttpPost");
        device.setParam("router_address", "192.168.21.145", "192.168.21.145");
        device.setParam("router_port", "80", "80");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)driver.getControlParams()).andReturn((Object)this.controlParams);
        PowerMock.replayAll((Object[])new Object[0]);
        VideoStreamParams expectedParams = new VideoStreamParams();
        expectedParams.lanDeviceId = 1;
        expectedParams.gcId = 1;
        expectedParams.type = VideoStreamParams.VideoStreamParamType.HTTP_TCP;
        expectedParams.address = "192.168.21.145";
        expectedParams.port = 80;
        expectedParams.user = "viewerUser";
        expectedParams.pass = "viewerPass";
        expectedParams.path = "video2.mjpg";
        expectedParams.pathLow = "video.mjpg";
        expectedParams.snapshotPath = "/cgi-bin/viewer/video.jpg?resolution=640x480";
        expectedParams.snapshotPathLow = "/cgi-bin/viewer/video.jpg?resolution=320x240";
        expectedParams.controlParams = this.controlParams;
        expectedParams.resolution = "640x480";
        expectedParams.resolutionLow = "320x240";
        expectedParams.pathRTSPOverHTTPGET = "pathRtspOverHttpGet";
        expectedParams.pathLowRTSPOverHTTPGET = "pathLowRtspOverHttpGet";
        expectedParams.pathRTSPOverHTTPPOST = "pathRtspOverHttpPost";
        expectedParams.pathLowRTSPOverHTTPPOST = "pathLowRtspOverHttpPost";
        VideoStreamParamsResponse expectedResponse = new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK, expectedParams);
        VideoStreamParamsResponse response = this.videoStreamService.getVideoStreamPameters(new Integer(1), false);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetVideoStreamPametersForProxyModeWithMissingLanDeviceParams() throws FileNotFoundException, IOException, InvalidSessionException {
        this.videoStreamService.setIpAddress("192.168.21.156");
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("path_rtsp_over_http_get", "pathRtspOverHttpGet");
        device.setParam("path_low_rtsp_over_http_get", "pathLowRtspOverHttpGet");
        device.setParam("path_rtsp_over_http_post", "pathRtspOverHttpPost");
        device.setParam("path_low_rtsp_over_http_post", "pathLowRtspOverHttpPost");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)driver.getControlParams()).andReturn((Object)this.controlParams);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)false);
        VivotekCameraIpAddressDiscoveryService ipAddressFinder = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)ipAddressFinder);
        EasyMock.expect((Object)ipAddressFinder.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:80")).andReturn((Object)"192.168.1.156");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        VideoStreamParams expectedParams = new VideoStreamParams();
        expectedParams.lanDeviceId = 1;
        expectedParams.gcId = 1;
        expectedParams.type = VideoStreamParams.VideoStreamParamType.HTTP_TCP;
        expectedParams.address = "192.168.21.156";
        expectedParams.port = 80;
        expectedParams.user = "viewerUser";
        expectedParams.pass = "viewerPass";
        expectedParams.controlParams = this.controlParams;
        expectedParams.path = "video2.mjpg";
        expectedParams.pathLow = "video.mjpg";
        expectedParams.snapshotPath = "/cgi-bin/viewer/video.jpg?resolution=640x480";
        expectedParams.snapshotPathLow = "/cgi-bin/viewer/video.jpg?resolution=320x240";
        expectedParams.controlParams = this.controlParams;
        expectedParams.resolution = "640x480";
        expectedParams.resolutionLow = "320x240";
        expectedParams.pathRTSPOverHTTPGET = "pathRtspOverHttpGet";
        expectedParams.pathLowRTSPOverHTTPGET = "pathLowRtspOverHttpGet";
        expectedParams.pathRTSPOverHTTPPOST = "pathRtspOverHttpPost";
        expectedParams.pathLowRTSPOverHTTPPOST = "pathLowRtspOverHttpPost";
        VideoStreamParamsResponse expectedResponse = new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK, expectedParams);
        VideoStreamParamsResponse response = this.videoStreamService.getVideoStreamPameters(new Integer(1), false);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.equalsVideoStreamParamsResponse(expectedResponse, response));
    }

    @Test
    public void testGetVideoStreamPametersForProxyModeWithoutMissingLanDeviceParams() throws FileNotFoundException, IOException, InvalidSessionException {
        this.videoStreamService.setIpAddress("192.168.21.156");
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("path_rtsp_over_http_get", "pathRtspOverHttpGet");
        device.setParam("path_low_rtsp_over_http_get", "pathLowRtspOverHttpGet");
        device.setParam("path_rtsp_over_http_post", "pathRtspOverHttpPost");
        device.setParam("path_low_rtsp_over_http_post", "pathLowRtspOverHttpPost");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)driver.getControlParams()).andReturn((Object)this.controlParams);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)false);
        VivotekCameraIpAddressDiscoveryService ipAddressFinder = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)ipAddressFinder);
        EasyMock.expect((Object)ipAddressFinder.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:80")).andReturn((Object)"192.168.1.156");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        VideoStreamParams expectedParams = new VideoStreamParams();
        expectedParams.lanDeviceId = 1;
        expectedParams.gcId = 1;
        expectedParams.type = VideoStreamParams.VideoStreamParamType.HTTP_TCP;
        expectedParams.address = "192.168.21.156";
        expectedParams.port = 80;
        expectedParams.user = "viewerUser";
        expectedParams.pass = "viewerPass";
        expectedParams.controlParams = this.controlParams;
        expectedParams.path = "video2.mjpg";
        expectedParams.pathLow = "video.mjpg";
        expectedParams.snapshotPath = "/cgi-bin/viewer/video.jpg?resolution=640x480";
        expectedParams.snapshotPathLow = "/cgi-bin/viewer/video.jpg?resolution=320x240";
        expectedParams.controlParams = this.controlParams;
        expectedParams.resolution = "640x480";
        expectedParams.resolutionLow = "320x240";
        expectedParams.pathRTSPOverHTTPGET = "pathRtspOverHttpGet";
        expectedParams.pathLowRTSPOverHTTPGET = "pathLowRtspOverHttpGet";
        expectedParams.pathRTSPOverHTTPPOST = "pathRtspOverHttpPost";
        expectedParams.pathLowRTSPOverHTTPPOST = "pathLowRtspOverHttpPost";
        VideoStreamParamsResponse expectedResponse = new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK, expectedParams);
        VideoStreamParamsResponse response = this.videoStreamService.getVideoStreamPameters(new Integer(1), false);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.equalsVideoStreamParamsResponse(expectedResponse, response));
    }

    @Test
    public void testGetVideoStreamPametersForICEModeWithMissingLanDeviceParams() throws FileNotFoundException, IOException, InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("path_rtsp_over_http_get", "pathRtspOverHttpGet");
        device.setParam("path_low_rtsp_over_http_get", "pathLowRtspOverHttpGet");
        device.setParam("path_rtsp_over_http_post", "pathRtspOverHttpPost");
        device.setParam("path_low_rtsp_over_http_post", "pathLowRtspOverHttpPost");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)driver.getControlParams()).andReturn((Object)this.controlParams);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)false);
        VivotekCameraIpAddressDiscoveryService ipAddressFinder = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)ipAddressFinder);
        EasyMock.expect((Object)ipAddressFinder.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:80")).andReturn((Object)"192.168.1.156");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)"192.168.1.1");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)9001);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)"192.168.1.2");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)9002);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)"fakeUser");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)"fakePass");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)"192.168.1.3");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)9003);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)"192.168.1.1");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)9001);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)"192.168.1.2");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)9002);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)"fakeUser");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)"fakePass");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)"192.168.1.3");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)9003);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParams iceParams = new ICEParams();
        iceParams.setStunAddress("192.168.1.1");
        iceParams.setStunPort(9001);
        iceParams.setTurnAddress("192.168.1.2");
        iceParams.setTurnPort(9002);
        iceParams.setTurnUsername("fakeUser");
        iceParams.setTurnPassword("fakePass");
        iceParams.setRelayIp("192.168.1.3");
        iceParams.setRelayPort(9003);
        VideoStreamParams expectedParams = new VideoStreamParams();
        expectedParams.lanDeviceId = 1;
        expectedParams.gcId = 1;
        expectedParams.type = VideoStreamParams.VideoStreamParamType.HTTP_ICE;
        expectedParams.address = "192.168.1.156";
        expectedParams.port = 80;
        expectedParams.user = "viewerUser";
        expectedParams.pass = "viewerPass";
        expectedParams.path = "video2.mjpg";
        expectedParams.pathLow = "video.mjpg";
        expectedParams.snapshotPath = "/cgi-bin/viewer/video.jpg?resolution=640x480";
        expectedParams.snapshotPathLow = "/cgi-bin/viewer/video.jpg?resolution=320x240";
        expectedParams.controlParams = this.controlParams;
        expectedParams.resolution = "640x480";
        expectedParams.resolutionLow = "320x240";
        expectedParams.pathRTSPOverHTTPGET = "pathRtspOverHttpGet";
        expectedParams.pathLowRTSPOverHTTPGET = "pathLowRtspOverHttpGet";
        expectedParams.pathRTSPOverHTTPPOST = "pathRtspOverHttpPost";
        expectedParams.pathLowRTSPOverHTTPPOST = "pathLowRtspOverHttpPost";
        expectedParams.iceParams = iceParams;
        expectedParams.controlParams = this.controlParams;
        VideoStreamParamsResponse expectedResponse = new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK, expectedParams);
        VideoStreamParamsResponse response = this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), false);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.equalsVideoStreamParamsResponse(expectedResponse, response));
    }

    @Test
    public void testGetVideoStreamPametersForICEModeWithoutMissingLanDeviceParams() throws FileNotFoundException, IOException, InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        device.setParam("viewer_user", "viewerUser");
        device.setParam("viewer_pass", "viewerPass");
        device.setParam("path", "video2.mjpg");
        device.setParam("path_low", "video.mjpg");
        device.setParam("snapshot_path", "/cgi-bin/viewer/video.jpg?resolution=640x480");
        device.setParam("snapshot_path_low", "/cgi-bin/viewer/video.jpg?resolution=320x240");
        device.setParam("resolution", "640x480");
        device.setParam("resolution_low", "320x240");
        device.setParam("path_rtsp_over_http_get", "pathRtspOverHttpGet");
        device.setParam("path_low_rtsp_over_http_get", "pathLowRtspOverHttpGet");
        device.setParam("path_rtsp_over_http_post", "pathRtspOverHttpPost");
        device.setParam("path_low_rtsp_over_http_post", "pathLowRtspOverHttpPost");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)driver.getControlParams()).andReturn((Object)this.controlParams);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)false);
        VivotekCameraIpAddressDiscoveryService ipAddressFinder = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)ipAddressFinder);
        EasyMock.expect((Object)ipAddressFinder.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:80")).andReturn((Object)"192.168.1.156");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)"192.168.1.1");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)9001);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)"192.168.1.2");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)9002);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)"fakeUser");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)"fakePass");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)"192.168.1.3");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)9003);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)"192.168.1.1");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)9001);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)"192.168.1.2");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)9002);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)"fakeUser");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)"fakePass");
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)"192.168.1.3");
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)9003);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParams iceParams = new ICEParams();
        iceParams.setStunAddress("192.168.1.1");
        iceParams.setStunPort(9001);
        iceParams.setTurnAddress("192.168.1.2");
        iceParams.setTurnPort(9002);
        iceParams.setTurnUsername("fakeUser");
        iceParams.setTurnPassword("fakePass");
        iceParams.setRelayIp("192.168.1.3");
        iceParams.setRelayPort(9003);
        VideoStreamParams expectedParams = new VideoStreamParams();
        expectedParams.lanDeviceId = 1;
        expectedParams.gcId = 1;
        expectedParams.type = VideoStreamParams.VideoStreamParamType.HTTP_ICE;
        expectedParams.address = "192.168.1.156";
        expectedParams.port = 80;
        expectedParams.user = "viewerUser";
        expectedParams.pass = "viewerPass";
        expectedParams.path = "video2.mjpg";
        expectedParams.pathLow = "video.mjpg";
        expectedParams.snapshotPath = "/cgi-bin/viewer/video.jpg?resolution=640x480";
        expectedParams.snapshotPathLow = "/cgi-bin/viewer/video.jpg?resolution=320x240";
        expectedParams.controlParams = this.controlParams;
        expectedParams.resolution = "640x480";
        expectedParams.resolutionLow = "320x240";
        expectedParams.pathRTSPOverHTTPGET = "pathRtspOverHttpGet";
        expectedParams.pathLowRTSPOverHTTPGET = "pathLowRtspOverHttpGet";
        expectedParams.pathRTSPOverHTTPPOST = "pathRtspOverHttpPost";
        expectedParams.pathLowRTSPOverHTTPPOST = "pathLowRtspOverHttpPost";
        expectedParams.iceParams = iceParams;
        expectedParams.controlParams = this.controlParams;
        VideoStreamParamsResponse expectedResponse = new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK, expectedParams);
        VideoStreamParamsResponse response = this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), false);
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)this.equalsVideoStreamParamsResponse(expectedResponse, response));
    }

    private boolean equalsVideoStreamParams(VideoStreamParams p1, VideoStreamParams p2) {
        if (p1 == p2) {
            return true;
        }
        if (p2 == null) {
            return false;
        }
        if (p1.getClass() != p2.getClass()) {
            return false;
        }
        VideoStreamParams other = p2;
        if (p1.address == null ? other.address != null : !p1.address.equals(other.address)) {
            return false;
        }
        if (this.controlParams == null ? other.controlParams != null : !this.controlParams.equals((Object)other.controlParams)) {
            return false;
        }
        if (p1.gcId == null ? other.gcId != null : !p1.gcId.equals(other.gcId)) {
            return false;
        }
        if (p1.iceParams == null ? other.iceParams != null : !p1.iceParams.equals((Object)other.iceParams)) {
            return false;
        }
        if (p1.lanDeviceId == null ? other.lanDeviceId != null : !p1.lanDeviceId.equals(other.lanDeviceId)) {
            return false;
        }
        if (p1.pass == null ? other.pass != null : !p1.pass.equals(other.pass)) {
            return false;
        }
        if (p1.path == null ? other.path != null : !p1.path.equals(other.path)) {
            return false;
        }
        if (p1.pathLow == null ? other.pathLow != null : !p1.pathLow.equals(other.pathLow)) {
            return false;
        }
        if (p1.resolution == null ? other.resolution != null : !p1.resolution.equals(other.resolution)) {
            return false;
        }
        if (p1.resolutionLow == null ? other.resolutionLow != null : !p1.resolutionLow.equals(other.resolutionLow)) {
            return false;
        }
        if (p1.snapshotPath == null ? other.snapshotPath != null : !p1.snapshotPath.equals(other.snapshotPath)) {
            return false;
        }
        if (p1.snapshotPathLow == null ? other.snapshotPathLow != null : !p1.snapshotPathLow.equals(other.snapshotPathLow)) {
            return false;
        }
        if (p1.pathRTSPOverHTTPGET == null ? other.pathRTSPOverHTTPGET != null : !p1.pathRTSPOverHTTPGET.equals(other.pathRTSPOverHTTPGET)) {
            return false;
        }
        if (p1.pathLowRTSPOverHTTPGET == null ? other.pathLowRTSPOverHTTPGET != null : !p1.pathLowRTSPOverHTTPGET.equals(other.pathLowRTSPOverHTTPGET)) {
            return false;
        }
        if (p1.pathRTSPOverHTTPPOST == null ? other.pathRTSPOverHTTPPOST != null : !p1.pathRTSPOverHTTPPOST.equals(other.pathRTSPOverHTTPPOST)) {
            return false;
        }
        if (p1.pathLowRTSPOverHTTPPOST == null ? other.pathLowRTSPOverHTTPPOST != null : !p1.pathLowRTSPOverHTTPPOST.equals(other.pathLowRTSPOverHTTPPOST)) {
            return false;
        }
        if (p1.type != other.type) {
            return false;
        }
        return !(p1.user == null ? other.user != null : !p1.user.equals(other.user));
    }

    public boolean equalsVideoStreamParamsResponse(VideoStreamParamsResponse r1, VideoStreamParamsResponse r2) {
        System.out.println("r1: " + r1);
        System.out.println("r2: " + r2);
        if (r1 == r2) {
            return true;
        }
        if (r2 == null) {
            return false;
        }
        if (r1.status != r2.status) {
            return false;
        }
        return this.equalsVideoStreamParams(r1.params, r2.params);
    }

    @Test
    public void testSearchCandidatesSuccessfully() throws Exception {
        Integer clientId = 1;
        String clientCandidates = "testClientCandidates";
        Integer currentUserId = 2;
        String serialNumber = "testSerialNumber";
        String mac = "testMac";
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(clientId, currentUserId, false)).andReturn((Object)client);
        SearchCandidatesService searchCandidatesService = (SearchCandidatesService)PowerMock.createMock(SearchCandidatesService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getSearchCandidatesService()).andReturn((Object)searchCandidatesService);
        Candidates foundCandidates = (Candidates)PowerMock.createMock(Candidates.class);
        EasyMock.expect((Object)client.getSerialNumber()).andReturn((Object)serialNumber);
        this.authUtils.ensureLoggedIn();
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        EasyMock.expect((Object)searchCandidatesService.searchCandidates(serialNumber, iceParams, clientCandidates)).andReturn((Object)foundCandidates);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        String serverCandidates = "testServerCandidates";
        EasyMock.expect((Object)foundCandidates.getCandidates()).andReturn((Object)serverCandidates);
        Integer startRangePort = 100;
        EasyMock.expect((Object)foundCandidates.getPortRangeStart()).andReturn((Object)startRangePort);
        Integer endRangePort = 200;
        EasyMock.expect((Object)foundCandidates.getPortRangeEnd()).andReturn((Object)endRangePort);
        String description = "{\"clientCandidates\":\"testClientCandidates\", \"deviceCandidates\":\"testServerCandidates\", \"portRangeStart\":100, \"portRangeEnd\":200}";
        this.eventlogService.registerEventlog(GCEventType.ICESETUP, mac, null, CandidatesResponse.CandidatesStatus.OK.name(), description);
        CandidatesResponse response = (CandidatesResponse)PowerMock.createMock(CandidatesResponse.class);
        Integer deviceType = 16;
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)deviceType);
        PowerMock.expectNew(CandidatesResponse.class, (Object[])new Object[]{CandidatesResponse.CandidatesStatus.OK, foundCandidates, deviceType}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CandidatesResponse actualResponse = this.videoStreamService.searchCandidates(clientId, clientCandidates);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesNotFoundOwnClientButShared() throws Exception {
        Integer clientId = 1;
        String clientCandidates = "testClientCandidates";
        Integer currentUserId = 2;
        String serialNumber = "testSerialNumber";
        String mac = "testMac";
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId).times(2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(clientId, currentUserId, false)).andReturn(null);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdSharedWithUserId(clientId, currentUserId)).andReturn((Object)client);
        SearchCandidatesService searchCandidatesService = (SearchCandidatesService)PowerMock.createMock(SearchCandidatesService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getSearchCandidatesService()).andReturn((Object)searchCandidatesService);
        Candidates foundCandidates = (Candidates)PowerMock.createMock(Candidates.class);
        EasyMock.expect((Object)client.getSerialNumber()).andReturn((Object)serialNumber);
        this.authUtils.ensureLoggedIn();
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        EasyMock.expect((Object)searchCandidatesService.searchCandidates(serialNumber, iceParams, clientCandidates)).andReturn((Object)foundCandidates);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        String serverCandidates = "testServerCandidates";
        EasyMock.expect((Object)foundCandidates.getCandidates()).andReturn((Object)serverCandidates);
        Integer startRangePort = 100;
        EasyMock.expect((Object)foundCandidates.getPortRangeStart()).andReturn((Object)startRangePort);
        Integer endRangePort = 200;
        EasyMock.expect((Object)foundCandidates.getPortRangeEnd()).andReturn((Object)endRangePort);
        String description = "{\"clientCandidates\":\"testClientCandidates\", \"deviceCandidates\":\"testServerCandidates\", \"portRangeStart\":100, \"portRangeEnd\":200}";
        this.eventlogService.registerEventlog(GCEventType.ICESETUP, mac, null, CandidatesResponse.CandidatesStatus.OK.name(), description);
        CandidatesResponse response = (CandidatesResponse)PowerMock.createMock(CandidatesResponse.class);
        Integer deviceType = 16;
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)deviceType);
        PowerMock.expectNew(CandidatesResponse.class, (Object[])new Object[]{CandidatesResponse.CandidatesStatus.OK, foundCandidates, deviceType}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CandidatesResponse actualResponse = this.videoStreamService.searchCandidates(clientId, clientCandidates);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesCandidatesNotFound() throws Exception {
        Integer clientId = 1;
        String clientCandidates = "testClientCandidates";
        Integer currentUserId = 2;
        String serialNumber = "testSerialNumber";
        String mac = "testMac";
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(clientId, currentUserId, false)).andReturn((Object)client);
        SearchCandidatesService searchCandidatesService = (SearchCandidatesService)PowerMock.createMock(SearchCandidatesService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getSearchCandidatesService()).andReturn((Object)searchCandidatesService);
        EasyMock.expect((Object)client.getSerialNumber()).andReturn((Object)serialNumber);
        this.authUtils.ensureLoggedIn();
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        EasyMock.expect((Object)searchCandidatesService.searchCandidates(serialNumber, iceParams, clientCandidates)).andReturn(null);
        EasyMock.expect((Object)client.getMac()).andReturn((Object)mac);
        this.eventlogService.registerEventlog(GCEventType.ICESETUP, mac, null, CandidatesResponse.CandidatesStatus.FAILED.name(), "Not found candidates.");
        CandidatesResponse response = (CandidatesResponse)PowerMock.createMock(CandidatesResponse.class);
        PowerMock.expectNew(CandidatesResponse.class, (Object[])new Object[]{CandidatesResponse.CandidatesStatus.FAILED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CandidatesResponse actualResponse = this.videoStreamService.searchCandidates(clientId, clientCandidates);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testSearchCandidatesGatewayClientNotFound() throws Exception {
        Integer clientId = 1;
        String clientCandidates = "testClientCandidates";
        Integer currentUserId = 2;
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId).times(2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(clientId, currentUserId, false)).andReturn(null);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdSharedWithUserId(clientId, currentUserId)).andReturn(null);
        this.eventlogService.registerEventlog(GCEventType.ICESETUP, null, null, CandidatesResponse.CandidatesStatus.FAILED.name(), "Not found gateway client with id=" + clientId + ".");
        CandidatesResponse response = (CandidatesResponse)PowerMock.createMock(CandidatesResponse.class);
        PowerMock.expectNew(CandidatesResponse.class, (Object[])new Object[]{CandidatesResponse.CandidatesStatus.FAILED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        CandidatesResponse actualResponse = this.videoStreamService.searchCandidates(clientId, clientCandidates);
        Assert.assertEquals((Object)response, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetICEParameters() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        ICEParameters iceParameters = (ICEParameters)PowerMock.createMock(ICEParameters.class);
        PowerMock.expectNew(ICEParameters.class, (Object[])new Object[0]).andReturn((Object)iceParameters);
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        iceParameters.setParams(iceParams);
        HashSet clientIds = (HashSet)PowerMock.createMock(HashSet.class);
        PowerMock.expectNew(HashSet.class, (Object[])new Object[0]).andReturn((Object)clientIds);
        Integer currentUserId = 1;
        ArrayList<LanDeviceEntity> ownDevices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity ownDevice1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        ownDevices.add(ownDevice1);
        LanDeviceEntity ownDevice2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        ownDevices.add(ownDevice2);
        LanDeviceEntity ownDevice3 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        ownDevices.add(ownDevice3);
        LanDeviceEntity ownDevice4 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        ownDevices.add(ownDevice4);
        LanDeviceEntity ownDevice5 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        ownDevices.add(ownDevice5);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(currentUserId, false, null)).andReturn(ownDevices);
        EasyMock.expect((Object)ownDevice1.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)ownDevice1.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)ownDevice1.hasParam("router_address")).andReturn((Object)false);
        GatewayClientEntity ownClient1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)ownDevice1.getGatewayClient()).andReturn((Object)ownClient1).times(2);
        EasyMock.expect((Object)ownClient1.getDeleted()).andReturn((Object)false);
        Integer ownClientId1 = 2;
        EasyMock.expect((Object)ownClient1.getGatewayClientId()).andReturn((Object)ownClientId1);
        EasyMock.expect((Object)clientIds.add(ownClientId1)).andReturn((Object)false);
        EasyMock.expect((Object)ownDevice2.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)ownDevice2.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)ownDevice2.hasParam("router_address")).andReturn((Object)false);
        GatewayClientEntity ownClient2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)ownDevice2.getGatewayClient()).andReturn((Object)ownClient2);
        EasyMock.expect((Object)ownClient2.getDeleted()).andReturn((Object)true);
        EasyMock.expect((Object)ownDevice3.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)ownDevice3.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)ownDevice3.hasParam("router_address")).andReturn((Object)true);
        EasyMock.expect((Object)ownDevice4.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)ownDevice4.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.MANUAL);
        EasyMock.expect((Object)ownDevice5.getDeleted()).andReturn((Object)true);
        ArrayList<LanDeviceEntity> sharedDevices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity sharedDevice1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        sharedDevices.add(sharedDevice1);
        LanDeviceEntity sharedDevice2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        sharedDevices.add(sharedDevice2);
        LanDeviceEntity sharedDevice3 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        sharedDevices.add(sharedDevice3);
        LanDeviceEntity sharedDevice4 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        sharedDevices.add(sharedDevice4);
        LanDeviceEntity sharedDevice5 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        sharedDevices.add(sharedDevice5);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesSharedWithUser(currentUserId, null)).andReturn(sharedDevices);
        EasyMock.expect((Object)sharedDevice1.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)sharedDevice1.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)sharedDevice1.hasParam("router_address")).andReturn((Object)false);
        GatewayClientEntity sharedClient1 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)sharedDevice1.getGatewayClient()).andReturn((Object)sharedClient1).times(2);
        EasyMock.expect((Object)sharedClient1.getDeleted()).andReturn((Object)false);
        Integer sharedClientId1 = 3;
        EasyMock.expect((Object)sharedClient1.getGatewayClientId()).andReturn((Object)sharedClientId1);
        EasyMock.expect((Object)clientIds.add(sharedClientId1)).andReturn((Object)false);
        EasyMock.expect((Object)sharedDevice2.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)sharedDevice2.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)sharedDevice2.hasParam("router_address")).andReturn((Object)false);
        GatewayClientEntity sharedClient2 = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)sharedDevice2.getGatewayClient()).andReturn((Object)sharedClient2);
        EasyMock.expect((Object)sharedClient2.getDeleted()).andReturn((Object)true);
        EasyMock.expect((Object)sharedDevice3.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)sharedDevice3.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)sharedDevice3.hasParam("router_address")).andReturn((Object)true);
        EasyMock.expect((Object)sharedDevice4.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)sharedDevice4.getConfigurationStatus()).andReturn((Object)LanDevice.LanDeviceConfigurationStatus.MANUAL);
        EasyMock.expect((Object)sharedDevice5.getDeleted()).andReturn((Object)true);
        iceParameters.setGcIds((Set)clientIds);
        LogConfiguration logConf = (LogConfiguration)PowerMock.createMock(LogConfiguration.class);
        PowerMock.expectNew(LogConfiguration.class, (Object[])new Object[0]).andReturn((Object)logConf);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        String textLogConf = "testTextLogConf";
        EasyMock.expect((Object)currentUser.getLogConf()).andReturn((Object)textLogConf);
        logConf.setConf(textLogConf);
        this.videoStreamService.setServerUrl("http://test.com");
        this.videoStreamService.setLogPath("debuglog");
        logConf.setUrl("http://test.com/debuglog");
        iceParameters.setLogConf(logConf);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParameters actualResponse = this.videoStreamService.getICEParameters();
        Assert.assertEquals((Object)iceParameters, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetICEParametersServerUrlWithoutSlashAtEndAndLogPathWithoutSlashAtBeginning() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        ICEParameters iceParameters = (ICEParameters)PowerMock.createMock(ICEParameters.class);
        PowerMock.expectNew(ICEParameters.class, (Object[])new Object[0]).andReturn((Object)iceParameters);
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        iceParameters.setParams(iceParams);
        HashSet clientIds = (HashSet)PowerMock.createMock(HashSet.class);
        PowerMock.expectNew(HashSet.class, (Object[])new Object[0]).andReturn((Object)clientIds);
        Integer currentUserId = 1;
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId).times(2);
        ArrayList ownDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(currentUserId, false, null)).andReturn(ownDevices);
        ArrayList sharedDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesSharedWithUser(currentUserId, null)).andReturn(sharedDevices);
        iceParameters.setGcIds((Set)clientIds);
        LogConfiguration logConf = (LogConfiguration)PowerMock.createMock(LogConfiguration.class);
        PowerMock.expectNew(LogConfiguration.class, (Object[])new Object[0]).andReturn((Object)logConf);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        String textLogConf = "testTextLogConf";
        EasyMock.expect((Object)currentUser.getLogConf()).andReturn((Object)textLogConf);
        logConf.setConf(textLogConf);
        this.videoStreamService.setServerUrl("http://test.com");
        this.videoStreamService.setLogPath("debuglog");
        logConf.setUrl("http://test.com/debuglog");
        iceParameters.setLogConf(logConf);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParameters actualResponse = this.videoStreamService.getICEParameters();
        Assert.assertEquals((Object)iceParameters, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetICEParametersServerUrlWithSlashAtEndAndLogPathWithoutSlashAtBeginning() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        ICEParameters iceParameters = (ICEParameters)PowerMock.createMock(ICEParameters.class);
        PowerMock.expectNew(ICEParameters.class, (Object[])new Object[0]).andReturn((Object)iceParameters);
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        iceParameters.setParams(iceParams);
        HashSet clientIds = (HashSet)PowerMock.createMock(HashSet.class);
        PowerMock.expectNew(HashSet.class, (Object[])new Object[0]).andReturn((Object)clientIds);
        Integer currentUserId = 1;
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId).times(2);
        ArrayList ownDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(currentUserId, false, null)).andReturn(ownDevices);
        ArrayList sharedDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesSharedWithUser(currentUserId, null)).andReturn(sharedDevices);
        iceParameters.setGcIds((Set)clientIds);
        LogConfiguration logConf = (LogConfiguration)PowerMock.createMock(LogConfiguration.class);
        PowerMock.expectNew(LogConfiguration.class, (Object[])new Object[0]).andReturn((Object)logConf);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        String textLogConf = "testTextLogConf";
        EasyMock.expect((Object)currentUser.getLogConf()).andReturn((Object)textLogConf);
        logConf.setConf(textLogConf);
        this.videoStreamService.setServerUrl("http://test.com/");
        this.videoStreamService.setLogPath("debuglog");
        logConf.setUrl("http://test.com/debuglog");
        iceParameters.setLogConf(logConf);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParameters actualResponse = this.videoStreamService.getICEParameters();
        Assert.assertEquals((Object)iceParameters, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetICEParametersServerUrlWithoutSlashAtEndAndLogPathWithSlashAtBeginning() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        ICEParameters iceParameters = (ICEParameters)PowerMock.createMock(ICEParameters.class);
        PowerMock.expectNew(ICEParameters.class, (Object[])new Object[0]).andReturn((Object)iceParameters);
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        iceParameters.setParams(iceParams);
        HashSet clientIds = (HashSet)PowerMock.createMock(HashSet.class);
        PowerMock.expectNew(HashSet.class, (Object[])new Object[0]).andReturn((Object)clientIds);
        Integer currentUserId = 1;
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId).times(2);
        ArrayList ownDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(currentUserId, false, null)).andReturn(ownDevices);
        ArrayList sharedDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesSharedWithUser(currentUserId, null)).andReturn(sharedDevices);
        iceParameters.setGcIds((Set)clientIds);
        LogConfiguration logConf = (LogConfiguration)PowerMock.createMock(LogConfiguration.class);
        PowerMock.expectNew(LogConfiguration.class, (Object[])new Object[0]).andReturn((Object)logConf);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        String textLogConf = "testTextLogConf";
        EasyMock.expect((Object)currentUser.getLogConf()).andReturn((Object)textLogConf);
        logConf.setConf(textLogConf);
        this.videoStreamService.setServerUrl("http://test.com");
        this.videoStreamService.setLogPath("/debuglog");
        logConf.setUrl("http://test.com/debuglog");
        iceParameters.setLogConf(logConf);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParameters actualResponse = this.videoStreamService.getICEParameters();
        Assert.assertEquals((Object)iceParameters, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetICEParametersServerUrlWithSlashAtEndAndLogPathWithSlashAtBeginning() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        ICEParameters iceParameters = (ICEParameters)PowerMock.createMock(ICEParameters.class);
        PowerMock.expectNew(ICEParameters.class, (Object[])new Object[0]).andReturn((Object)iceParameters);
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        iceParameters.setParams(iceParams);
        HashSet clientIds = (HashSet)PowerMock.createMock(HashSet.class);
        PowerMock.expectNew(HashSet.class, (Object[])new Object[0]).andReturn((Object)clientIds);
        Integer currentUserId = 1;
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)currentUserId).times(2);
        ArrayList ownDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(currentUserId, false, null)).andReturn(ownDevices);
        ArrayList sharedDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesSharedWithUser(currentUserId, null)).andReturn(sharedDevices);
        iceParameters.setGcIds((Set)clientIds);
        LogConfiguration logConf = (LogConfiguration)PowerMock.createMock(LogConfiguration.class);
        PowerMock.expectNew(LogConfiguration.class, (Object[])new Object[0]).andReturn((Object)logConf);
        UserEntity currentUser = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)currentUser);
        String textLogConf = "testTextLogConf";
        EasyMock.expect((Object)currentUser.getLogConf()).andReturn((Object)textLogConf);
        logConf.setConf(textLogConf);
        this.videoStreamService.setServerUrl("http://test.com/");
        this.videoStreamService.setLogPath("/debuglog");
        logConf.setUrl("http://test.com/debuglog");
        iceParameters.setLogConf(logConf);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParameters actualResponse = this.videoStreamService.getICEParameters();
        Assert.assertEquals((Object)iceParameters, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetIceParams() throws Exception {
        this.authUtils.ensureLoggedIn();
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        Integer iceStunPort = 1;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn((Object)iceStunPort);
        iceParams.setStunPort(iceStunPort.intValue());
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        Integer iceTrunPort = 2;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn((Object)iceTrunPort);
        iceParams.setTurnPort(iceTrunPort.intValue());
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        Integer iceRelayPort = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn((Object)iceRelayPort);
        iceParams.setRelayPort(iceRelayPort.intValue());
        Integer iceRelayPortTls = 4;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn((Object)iceRelayPortTls);
        iceParams.setRelayPortTLS(iceRelayPortTls.intValue());
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParams actualResponse = this.videoStreamService.getICEParams();
        Assert.assertEquals((Object)iceParams, (Object)actualResponse);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetIceParamsNullPort() throws Exception {
        this.authUtils.ensureLoggedIn();
        ICEParams iceParams = (ICEParams)PowerMock.createMock(ICEParams.class);
        PowerMock.expectNew(ICEParams.class, (Object[])new Object[0]).andReturn((Object)iceParams);
        String iceStunAddrress = "testIceStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS)).andReturn((Object)iceStunAddrress);
        iceParams.setStunAddress(iceStunAddrress);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT)).andReturn(null);
        String iceTurnAddrress = "testTurnStunAddrress";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS)).andReturn((Object)iceTurnAddrress);
        iceParams.setTurnAddress(iceTurnAddrress);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT)).andReturn(null);
        String iceTurnUsername = "testIceTurnUsername";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME)).andReturn((Object)iceTurnUsername);
        iceParams.setTurnUsername(iceTurnUsername);
        String iceTurnPassword = "testIceTurnPassword";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD)).andReturn((Object)iceTurnPassword);
        iceParams.setTurnPassword(iceTurnPassword);
        String iceRelayIp = "testIceRelayIp";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP)).andReturn((Object)iceRelayIp);
        iceParams.setRelayIp(iceRelayIp);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ICEParams actualResponse = this.videoStreamService.getICEParams();
        Assert.assertEquals((Object)iceParams, (Object)actualResponse);
        PowerMock.verifyAll();
    }
}

