/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.SearchCandidatesService;
import pl.smartapps.containerserver.TcpProxyService;
import pl.smartapps.containerserver.VivotekCameraIpAddressDiscoveryService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericCamera;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.Candidates;
import pl.smartapps.hm.WebViewer.shared.model.GCEventType;
import pl.smartapps.hm.WebViewer.shared.model.ICEParameters;
import pl.smartapps.hm.WebViewer.shared.model.ICEParams;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LogConfiguration;
import pl.smartapps.hm.WebViewer.shared.model.VideoStreamParams;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.rest.response.CandidatesResponse;
import pl.smartapps.restserver.rest.response.VideoStreamParamsResponse;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.VideoStreamService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;

@Service
public class VideoStreamServiceImpl
implements VideoStreamService {
    private static Logger log = Logger.getLogger(VideoStreamServiceImpl.class);
    private String serverUrl;
    private String logPath;
    private String ipAddress;
    private ContainerserverServiceFactory containerserverServiceFactory;
    private LanDeviceDAO lanDeviceDAO;
    private GatewayClientDAO gatewayClientDAO;
    private TcpProxyService tcpProxyService;
    private AuthenticationUtils authUtils;
    private DeviceDriverFactory deviceDriverFactory;
    private EventlogService eventlogService;
    private ParameterService parameterService;
    private LanDeviceService lanDeviceService;

    @Value(value="${tcpProxy.publicAddress:null}")
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Value(value="${lanDevice.serverUrl}")
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Value(value="${debuglog.path:debuglog}")
    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setTcpProxyService(TcpProxyService tcpProxyService) {
        this.tcpProxyService = tcpProxyService;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setContainerserverServiceFactory(ContainerserverServiceFactory containerserverServiceFactory) {
        this.containerserverServiceFactory = containerserverServiceFactory;
    }

    @Autowired
    @Required
    public void setGatewayClientDAO(GatewayClientDAO gatewayClientDAO) {
        this.gatewayClientDAO = gatewayClientDAO;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    @Autowired
    @Required
    public void setEventlogService(EventlogService eventlogService) {
        this.eventlogService = eventlogService;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Transactional
    public VideoStreamParamsResponse getVideoStreamPameters(Integer lanDeviceId, boolean ommitObjects) throws InvalidSessionException {
        log.trace((Object)("start getVideoStreamPameters(lanDeviceId=" + lanDeviceId + ", ommitObjects=" + ommitObjects + ")"));
        this.authUtils.ensureLoggedIn();
        if (lanDeviceId == null) {
            return new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.INVALIDID);
        }
        log.debug((Object)("start getVideoStreamParameters - lanDeviceDAO: " + this.lanDeviceDAO));
        LanDeviceEntity device = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        if (device == null) {
            return new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.DEVICENOTFOUND);
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        String path = device.getParamValue("path");
        VideoStreamParams videoParams = new VideoStreamParams();
        videoParams.gcId = device.getGatewayClient().getGatewayClientId();
        if ("camera".equalsIgnoreCase(device.getDeviceDesc().getClassDevice())) {
            videoParams.controlParams = driver.getControlParams();
            videoParams.path = path;
            videoParams.resolution = device.getParamValue("resolution");
            videoParams.pathLow = device.getParamValue("path_low");
            videoParams.resolutionLow = device.getParamValue("resolution_low");
            videoParams.snapshotPath = device.getParamValue("snapshot_path");
            videoParams.snapshotPathLow = device.getParamValue("snapshot_path_low");
            if ("MPEG4".equals(device.getVideoEncoding()) || "H264".equals(device.getVideoEncoding())) {
                videoParams.pathRTSPOverHTTPGET = device.getParamValue("path_rtsp_over_http_get");
                videoParams.pathLowRTSPOverHTTPGET = device.getParamValue("path_low_rtsp_over_http_get");
                videoParams.pathRTSPOverHTTPPOST = device.getParamValue("path_rtsp_over_http_post");
                videoParams.pathLowRTSPOverHTTPPOST = device.getParamValue("path_low_rtsp_over_http_post");
                videoParams.rtspPort = Integer.parseInt(device.getParamValue("rtsp_port"));
                videoParams.rtspOverHttpPort = Integer.parseInt(device.getParamValue("rtsp_over_http_port"));
                GenericCamera cameraDriver = (GenericCamera)driver;
                videoParams.hasNativeRtspOverHttp = cameraDriver.hasNativeRtspOverHttpSupport();
            }
        }
        if (device.hasParam("router_address")) {
            videoParams.lanDeviceId = lanDeviceId;
            videoParams.type = VideoStreamParams.VideoStreamParamType.HTTP_TCP;
            videoParams.address = device.getParamValue("router_address");
            videoParams.port = Integer.parseInt(device.getParamValue("router_port"));
            videoParams.user = device.getParamValue("viewer_user");
            videoParams.pass = device.getParamValue("viewer_pass");
        } else {
            String deviceIpAddress;
            log.debug((Object)"searching actual ip address");
            String gcSerialNo = device.getGatewayClient().getSerialNumber();
            if (this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)) {
                log.debug((Object)"download ip address from db");
                deviceIpAddress = device.getIpAddress();
            } else {
                log.debug((Object)"download ip address from gc");
                VivotekCameraIpAddressDiscoveryService vivotekCameraIpAddressDiscoveryService = this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService();
                deviceIpAddress = vivotekCameraIpAddressDiscoveryService.getCameraIpAddress(gcSerialNo, device.getMac());
            }
            if (deviceIpAddress == null) {
                return new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.DEVICENOTFOUND);
            }
            if (!this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ICE_ENABLE)) {
                videoParams.type = VideoStreamParams.VideoStreamParamType.HTTP_TCP;
                videoParams.port = this.tcpProxyService.createTcpProxy(gcSerialNo, Integer.valueOf(0), deviceIpAddress, device.getPort());
                videoParams.address = this.ipAddress;
            } else {
                videoParams.type = VideoStreamParams.VideoStreamParamType.HTTP_ICE;
                videoParams.port = device.getPort();
                if (!ommitObjects) {
                    videoParams.iceParams = this.getICEParams();
                }
                videoParams.address = deviceIpAddress;
            }
            videoParams.lanDeviceId = lanDeviceId;
            videoParams.user = device.getParamValue("viewer_user");
            videoParams.pass = device.getParamValue("viewer_pass");
        }
        log.debug((Object)("exit getVideoStreamParameters(" + lanDeviceId + "); params: " + videoParams.toString()));
        return new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK, videoParams);
    }

    public ICEParams getICEParams() throws InvalidSessionException {
        Integer iceRelayPortTls;
        log.debug((Object)"start getICEParams()");
        this.authUtils.ensureLoggedIn();
        ICEParams params = new ICEParams();
        params.setStunAddress(this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_STUN_ADDRESS));
        Integer iceStunPort = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_STUN_PORT);
        if (iceStunPort != null) {
            params.setStunPort(iceStunPort.intValue());
        }
        params.setTurnAddress(this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_ADDRESS));
        Integer iceTurnPort = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_TURN_PORT);
        if (iceTurnPort != null) {
            params.setTurnPort(iceTurnPort.intValue());
        }
        params.setTurnUsername(this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_USERNAME));
        params.setTurnPassword(this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_TURN_PASSWORD));
        params.setRelayIp(this.parameterService.getParameterValue(ParameterService.ParameterCode.ICE_RELAY_IP));
        Integer iceRelayPort = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT);
        if (iceRelayPort != null) {
            params.setRelayPort(iceRelayPort.intValue());
        }
        if ((iceRelayPortTls = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.ICE_RELAY_PORT_TLS)) != null) {
            params.setRelayPortTLS(iceRelayPortTls.intValue());
        }
        return params;
    }

    @Transactional(readOnly=true)
    public ICEParameters getICEParameters() throws InvalidSessionException {
        log.debug((Object)"start getICEParameters()");
        this.authUtils.ensureLoggedIn();
        ICEParameters parameters = new ICEParameters();
        parameters.setParams(this.getICEParams());
        List ownDevices = this.lanDeviceDAO.findLanDevicesByUserId(this.authUtils.getCurrentUserId(), false, null);
        HashSet<Integer> gcIds = new HashSet<Integer>();
        for (LanDeviceEntity device : ownDevices) {
            if (!this.deviceHasIceMode(device) || device.getGatewayClient().getDeleted()) continue;
            gcIds.add(device.getGatewayClient().getGatewayClientId());
        }
        List sharedDevices = this.lanDeviceDAO.findLanDevicesSharedWithUser(this.authUtils.getCurrentUserId(), null);
        for (LanDeviceEntity device : sharedDevices) {
            if (!this.deviceHasIceMode(device) || device.getGatewayClient().getDeleted()) continue;
            gcIds.add(device.getGatewayClient().getGatewayClientId());
        }
        parameters.setGcIds(gcIds);
        LogConfiguration logConf = new LogConfiguration();
        logConf.setConf(this.authUtils.getCurrentUser().getLogConf());
        logConf.setUrl(this.buildDebuglogUrl());
        parameters.setLogConf(logConf);
        return parameters;
    }

    private String buildDebuglogUrl() {
        String url = this.serverUrl.trim();
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        if (this.logPath.startsWith("/")) {
            this.logPath = this.logPath.substring(1, this.logPath.length());
        }
        url = String.valueOf(url) + this.logPath;
        return url;
    }

    private boolean deviceHasIceMode(LanDeviceEntity device) {
        return !device.getDeleted() && device.getConfigurationStatus() == LanDevice.LanDeviceConfigurationStatus.OK && !device.hasParam("router_address");
    }

    @Transactional
    public CandidatesResponse searchCandidates(Integer gcId, String candidates) throws InvalidSessionException {
        log.debug((Object)("start searchCandidates(gcId=" + gcId + ", candidates=" + candidates + ")"));
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientByIdAndUserId(gcId, this.authUtils.getCurrentUserId(), false);
        if (gatewayClient == null) {
            gatewayClient = this.gatewayClientDAO.findGatewayClientByIdSharedWithUserId(gcId, this.authUtils.getCurrentUserId());
        }
        if (gatewayClient == null) {
            this.eventlogService.registerEventlog(GCEventType.ICESETUP, null, null, CandidatesResponse.CandidatesStatus.FAILED.name(), "Not found gateway client with id=" + gcId + ".");
            return new CandidatesResponse(CandidatesResponse.CandidatesStatus.FAILED);
        }
        SearchCandidatesService searchCandidatesService = this.containerserverServiceFactory.getSearchCandidatesService();
        Candidates serverCandidates = searchCandidatesService.searchCandidates(gatewayClient.getSerialNumber(), this.getICEParams(), candidates);
        if (serverCandidates == null) {
            this.eventlogService.registerEventlog(GCEventType.ICESETUP, gatewayClient.getMac(), null, CandidatesResponse.CandidatesStatus.FAILED.name(), "Not found candidates.");
            return new CandidatesResponse(CandidatesResponse.CandidatesStatus.FAILED);
        }
        this.eventlogService.registerEventlog(GCEventType.ICESETUP, gatewayClient.getMac(), null, CandidatesResponse.CandidatesStatus.OK.name(), this.buildCandidatesDescription(candidates, serverCandidates));
        return new CandidatesResponse(CandidatesResponse.CandidatesStatus.OK, serverCandidates, gatewayClient.getDeviceType());
    }

    private String buildCandidatesDescription(String clientCanddiates, Candidates deviceCandidates) {
        StringBuilder description = new StringBuilder();
        description.append("{\"clientCandidates\":\"").append(clientCanddiates);
        description.append("\", \"deviceCandidates\":\"").append(deviceCandidates.getCandidates());
        description.append("\", \"portRangeStart\":").append(deviceCandidates.getPortRangeStart());
        description.append(", \"portRangeEnd\":").append(deviceCandidates.getPortRangeEnd()).append("}");
        return description.toString();
    }

    @Transactional
    public byte[] getCurrentSnapshot(Integer lanDeviceId, String resolution) throws InvalidSessionException {
        log.debug((Object)("satrt getCurrentSnapshot(lanDeviceId=" + lanDeviceId + ", resolution=" + resolution + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        if (device == null) {
            return null;
        }
        GenericCamera driver = (GenericCamera)this.deviceDriverFactory.getDriver(device);
        byte[] snapshot = driver.getCurrentSnapshot(device, resolution);
        log.debug((Object)("stop getCurrentSnapshot(lanDeviceId=" + lanDeviceId + ", resolution=" + resolution + ", snapshot size = " + (snapshot != null ? Integer.valueOf(snapshot.length) : "null") + ")"));
        return snapshot;
    }

    protected byte[] getCurrentSnapshotInternal(Integer lanDeviceId, String resolution) {
        log.debug((Object)("start getCurrentSnapshot(lanDeviceId=" + lanDeviceId + ", resolution=" + resolution + ")"));
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null) {
            return null;
        }
        GenericCamera driver = (GenericCamera)this.deviceDriverFactory.getDriver(device);
        byte[] snapshot = driver.getCurrentSnapshot(device, resolution);
        log.debug((Object)("stop getCurrentSnapshot(lanDeviceId=" + lanDeviceId + ", resolution=" + resolution + ", snapshot size = " + (snapshot != null ? Integer.valueOf(snapshot.length) : "null") + ")"));
        return snapshot;
    }
}

