/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.VideoPostprocessingService;
import pl.smartapps.restserver.service.impl.AwsS3Controller;
import pl.smartapps.restserver.service.impl.EventServiceImpl;
import pl.smartapps.restserver.service.impl.TCPClient;
import pl.smartapps.restserver.service.impl.VideoRecorderServiceImpl;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ProcessBuilder.class, VideoRecorderServiceImpl.class, TCPClient.class})
public class VideoRecorderServiceImplTests {
    private VideoRecorderServiceImpl videoRecorderService;
    private EventDAO eventDAO;
    private SystemSupport systemSupport;
    private EventlogService eventlogService;
    private DeviceDriverFactory deviceDriverFactory;
    private VideoPostprocessingService videoPostprocessingService;
    private EventsFilesController awsController;

    @Before
    public void setUp() {
        this.videoRecorderService = new VideoRecorderServiceImpl();
        this.videoRecorderService.setSnapshotsPath("/videos");
        this.videoRecorderService.setRecordingServerAddress("localhost");
        this.videoRecorderService.setRecordingServerPort("8002");
        this.eventDAO = (EventDAO)PowerMock.createMock(EventDAO.class);
        this.videoRecorderService.setEventDAO(this.eventDAO);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.videoRecorderService.setSystemSupport(this.systemSupport);
        this.eventlogService = (EventlogService)PowerMock.createMock(EventlogService.class);
        this.videoRecorderService.setEventlogService(this.eventlogService);
        this.deviceDriverFactory = (DeviceDriverFactory)PowerMock.createMock(DeviceDriverFactory.class);
        this.videoRecorderService.setDeviceDriverFactory(this.deviceDriverFactory);
        this.videoPostprocessingService = (VideoPostprocessingService)PowerMock.createMock(VideoPostprocessingService.class);
        this.videoRecorderService.setVideoPostprocessingService(this.videoPostprocessingService);
        this.awsController = (EventsFilesController)PowerMock.createMock(AwsS3Controller.class);
        this.videoRecorderService.setEventsFilesController(this.awsController);
    }

    @Test
    public void testDoVideoRecordingRecordingForMjpegVideoEncoding() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingForMpeg4VideoEncoding() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.3gp", "MPEG4", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.3gp")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.3gp", "/videos/20110427123456_1.mp4", "640x480", "MPEG4")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.3gp")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MPEG4", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingForH264VideoEncoding() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.mp4", "H264", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.mp4")).andReturn((Object)file).times(2);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)file.length()).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "H264", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventSuccessfully() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventWithSnapshotInS3Successfully() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventSuccessfullyWithoutVideoPostProcessing() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventWithoutExistingSnapshotSuccessfully() throws Exception {
        EventEntity event = new EventEntity();
        event.setEventId(Integer.valueOf(1));
        event.setDateEvent(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)56));
        event.setDateStartRequested(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)58));
        event.setDateStopRequested(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)38));
        event.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        event.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventWithoutExistingSnapshotSuccessfullyWithOptionsFromParameters() throws Exception {
        EventEntity event = new EventEntity();
        event.setEventId(Integer.valueOf(1));
        event.setDateEvent(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)56));
        event.setDateStartRequested(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)58));
        event.setDateStopRequested(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)38));
        event.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        event.setLanDevice(TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EventEntity stoppedAndConvertedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        stoppedAndConvertedEvent.setDateStarted(dateStarted);
        stoppedAndConvertedEvent.setDateStopped(dateStopped);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        stoppedAndConvertedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedAndConvertedEvent)).andReturn((Object)stoppedAndConvertedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventWithNonExistingFlvVideo() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)false);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventFailureStopRecording() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "ERROR", "Unable to stop recording.");
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventFailureStartRecondingWithErrorStatus() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.ERROR);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "ERROR", null);
        EventEntity deletedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        deletedEvent.setDateStarted(dateStarted);
        deletedEvent.setDeleted(true);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(deletedEvent)).andReturn((Object)deletedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventFailureStartRecondingWithNullStatus() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "FAILED", "Unable to start recording.");
        EventEntity deletedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        deletedEvent.setDateStarted(dateStarted);
        deletedEvent.setDeleted(true);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(deletedEvent)).andReturn((Object)deletedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventFailureStartTcpClient() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)false);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "FAILED", "Unable to start TCPClient.");
        EventEntity savedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        savedEvent.setDeleted(true);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(savedEvent)).andReturn((Object)savedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventFailureHintVideo() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)false);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingManualEventFailureConvertVideoFileToMp4() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)0L);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MANUAL);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(0));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingMotionEventWithEventLedLightOnSuccessfully() throws Exception {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"event_led_light", (String)"ON", (String)"ON");
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION, device);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION, device);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "OFF")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingMotionEventWithEventLedLightOnFiailureDisableIllumination() throws Exception {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"event_led_light", (String)"ON", (String)"ON");
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION, device);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION, device);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "OFF")).andReturn((Object)UpdateSettingStatus.ERROR);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION, device);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingMotionEventWithEventLedLightOffSuccessfully() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION);
        Utils.addDeviceParam((LanDeviceEntity)event.getLanDevice(), (String)"event_led_light", (String)"OFF", (String)"OFF");
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.MOTION);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingAudioEventWithEventLedLightOnSuccessfully() throws Exception {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"event_led_light", (String)"ON", (String)"ON");
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO, device);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO, device);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "OFF")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO, device);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingAudioEventWithEventLedLightOnFailureDisableIllumination() throws Exception {
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false);
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"event_led_light", (String)"ON", (String)"ON");
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO, device);
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO, device);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.updateSingleSetting(device, "illumination", "OFF")).andReturn((Object)UpdateSettingStatus.ERROR);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO, device);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    @Test
    public void testDoVideoRecordingRecordingAudioEventWithEventLedLightOffSuccessfully() throws Exception {
        EventEntity event = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO);
        Utils.addDeviceParam((LanDeviceEntity)event.getLanDevice(), (String)"event_led_light", (String)"OFF", (String)"OFF");
        VideoRecorderServiceImpl videoRecorderServiceImpl = this.videoRecorderService;
        videoRecorderServiceImpl.getClass();
        VideoRecorderServiceImpl.VideoRecordingJob job = new VideoRecorderServiceImpl.VideoRecordingJob(videoRecorderServiceImpl, event);
        TCPClient tcpClient = (TCPClient)PowerMock.createMock(TCPClient.class);
        PowerMock.expectNew(TCPClient.class, (Object[])new Object[0]).andReturn((Object)tcpClient);
        EasyMock.expect((Object)tcpClient.start("localhost", 8002)).andReturn((Object)true);
        Date dateStarted = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStarted);
        EventEntity startedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO);
        startedEvent.setDateStarted(dateStarted);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(startedEvent)).andReturn((Object)startedEvent);
        EasyMock.expect((Object)tcpClient.startRecording("00:1A:B6:00:0B:B5", "localhost", 15812, "viewer", "password", "/video.mjpg", "/videos/20110427123456_1.flv", "MJPEG", true)).andReturn((Object)TCPClient.RecordingStatus.RECORDING);
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)37));
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)39));
        EasyMock.expect((Object)tcpClient.stopRecording("00:1A:B6:00:0B:B5", "localhost", 15812)).andReturn((Object)TCPClient.RecordingStatus.STOPPED);
        tcpClient.stop();
        EventEntity stoppedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO);
        Date dateStopped = Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)43);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)dateStopped);
        stoppedEvent.setDateStarted(dateStarted);
        stoppedEvent.setDateStopped(dateStopped);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(stoppedEvent)).andReturn((Object)stoppedEvent);
        File file = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.flv")).andReturn((Object)file);
        EasyMock.expect((Object)file.exists()).andReturn((Object)true);
        File snapshot = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile("/videos/20110427123456_1.jpg")).andReturn((Object)snapshot);
        EasyMock.expect((Object)snapshot.exists()).andReturn((Object)true);
        EasyMock.expect((Object)this.videoPostprocessingService.convertToMP4("/videos/20110427123456_1.flv", "/videos/20110427123456_1.mp4", "640x480", "MJPEG")).andReturn((Object)12345L);
        EasyMock.expect((Object)this.videoPostprocessingService.hintVideoFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        this.awsController.uploadFile("/videos/20110427123456_1.mp4");
        this.awsController.uploadFile("/videos/20110427123456_1.jpg");
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.mp4")).andReturn((Object)true);
        EasyMock.expect((Object)this.systemSupport.deleteFile("/videos/20110427123456_1.flv")).andReturn((Object)true);
        EventEntity processedEvent = this.prepareEvent(EventServiceImpl.EventTrigger.AUDIO);
        processedEvent.setDateStarted(dateStarted);
        processedEvent.setDateStopped(dateStopped);
        processedEvent.setVideoFileSize(Integer.valueOf(12345));
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        EasyMock.expect((Object)this.eventDAO.updateEvent(processedEvent)).andReturn((Object)processedEvent);
        PowerMock.replayAll((Object[])new Object[0]);
        this.videoRecorderService.doVideoRecording(job, "localhost", 15812, "viewer", "password", "/video.mjpg", "640x480", "MJPEG", true, false);
        PowerMock.verifyAll();
    }

    private EventEntity prepareEvent(EventServiceImpl.EventTrigger eventTirgger) {
        return this.prepareEvent(eventTirgger, TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)false));
    }

    private EventEntity prepareEvent(EventServiceImpl.EventTrigger eventTirgger, LanDeviceEntity device) {
        EventEntity event = new EventEntity();
        event.setEventId(Integer.valueOf(1));
        event.setDateEvent(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)56));
        event.setDateStartRequested(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)34, (int)58));
        event.setDateStopRequested(Utils.constructDate((int)2011, (int)4, (int)27, (int)12, (int)35, (int)38));
        event.setEventtrigger(eventTirgger);
        event.setLanDevice(device);
        return event;
    }

    @Ignore
    @Test
    public void testDoVideoRecording() throws IOException {
        EventEntity event = new EventEntity();
        event.setEventId(Integer.valueOf(1));
        event.setDateEvent(new GregorianCalendar(2011, 3, 27, 12, 34, 56).getTime());
        event.setDateStartRequested(new GregorianCalendar(2011, 3, 27, 12, 34, 58).getTime());
        event.setEventtrigger(EventServiceImpl.EventTrigger.MANUAL);
        EasyMock.expect((Object)this.eventDAO.findEventById(Integer.valueOf(1))).andReturn((Object)event);
        ArrayList<String> expectedVlcCmd = new ArrayList<String>();
        expectedVlcCmd.add("vlc");
        expectedVlcCmd.add("-Idummy");
        expectedVlcCmd.add("--run-time=60");
        expectedVlcCmd.add("http://viewer:password@localhost:15812//video.mjpg");
        expectedVlcCmd.add("--sout='#transcode{vcodec=FLV1,vb=2400}:standard{access=file,mux=ffmpeg{mux=flv},dst=/videos/20110427123456_1.mp4}'");
        expectedVlcCmd.add("'vlc://quit'");
        ProcessBuilder vlcProcessBuilder = (ProcessBuilder)PowerMock.createPartialMock(ProcessBuilder.class, (String[])new String[]{"start"});
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(expectedVlcCmd)).andReturn((Object)vlcProcessBuilder);
        vlcProcessBuilder.start();
        PowerMock.replayAll((Object[])new Object[0]);
        PowerMock.verifyAll();
    }
}

