/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.VideoPostprocessingService;
import pl.smartapps.restserver.service.impl.EventServiceImpl;
import pl.smartapps.restserver.service.impl.EventsFilesControllerFactory;
import pl.smartapps.restserver.service.impl.TCPClient;
import pl.smartapps.restserver.service.impl.VideoRecorderServiceImpl;

@Service
public class VideoRecorderServiceImpl {
    private static Logger log = Logger.getLogger(VideoRecorderServiceImpl.class);
    private boolean running = true;
    private Map<Integer, VideoRecordingJob> jobs = new HashMap();
    private VideoPostprocessingService videoPostprocessingService;
    private SystemSupport systemSupport;
    private EventDAO eventDAO;
    @Autowired
    private EventlogService eventlogService;
    private String snapshotsPath;
    private String recordingServerAddress;
    private String recordingServerPort;
    private DeviceDriverFactory deviceDriverFactory;
    private EventsFilesControllerFactory eventsFilesControllerFactory;
    private EventsFilesController eventsFilesController;

    @Autowired
    @Required
    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    @Value(value="${lanDevice.snapshotsPath:./events}")
    public void setSnapshotsPath(String snapshotsPath) {
        this.snapshotsPath = snapshotsPath;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Value(value="${lanDevice.recordingServerAddress:127.0.0.1}")
    public void setRecordingServerAddress(String recordingServerAddress) {
        this.recordingServerAddress = recordingServerAddress;
    }

    @Value(value="${lanDevice.recordingServerPort:8500}")
    public void setRecordingServerPort(String recordingServerPort) {
        this.recordingServerPort = recordingServerPort;
    }

    @Autowired
    @Required
    public void setEventlogService(EventlogService eventlogService) {
        this.eventlogService = eventlogService;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    public void setEventsFilesController(EventsFilesController eventsFilesController) {
        this.eventsFilesController = eventsFilesController;
    }

    public EventsFilesController getEventsFilesController() {
        return this.eventsFilesController;
    }

    @Autowired
    @Required
    public void setVideoPostprocessingService(VideoPostprocessingService videoPostprocessingService) {
        this.videoPostprocessingService = videoPostprocessingService;
    }

    @Autowired
    @Required
    public void setEventsFilesControllerFactory(EventsFilesControllerFactory eventsFilesControllerFactory) {
        this.eventsFilesControllerFactory = eventsFilesControllerFactory;
    }

    @PostConstruct
    public void init() {
        this.setEventsFilesController(this.eventsFilesControllerFactory.getEventsFilesController());
        log.debug((Object)("PostConstruct::eventsFilesController = " + this.eventsFilesController));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beanDestroyed() {
        log.info((Object)("Destroying bean. Waiting for all (" + this.jobs.size() + ") threads to finish recording"));
        this.running = false;
        Map map = this.jobs;
        synchronized (map) {
            for (VideoRecordingJob job : this.jobs.values()) {
                job.signal.countDown();
            }
        }
        while (true) {
            VideoRecordingJob job = null;
            Map map2 = this.jobs;
            synchronized (map2) {
                if (this.jobs.isEmpty()) {
                    break;
                }
                job = (VideoRecordingJob)this.jobs.values().iterator().next();
            }
            if (job == null) continue;
            try {
                job.workerThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        log.info((Object)"All recording threads have finished");
        this.eventsFilesController.stop();
    }

    public void startRecording(EventEntity event, String camip, int camport, String camusername, String campassword, String url, String resolution, String videoEncoding, boolean supportsRtcpOverRtsp, boolean audioEnabled) {
        log.debug((Object)("start startRecording(event=" + event + ", camip=" + camip + ", camusername=" + camusername + ", campassword=..., url=" + url + ", resolution=" + resolution + ")"));
        VideoRecordingJob job = new VideoRecordingJob(this, event);
        job.workerThread = new /* Unavailable Anonymous Inner Class!! */;
        this.jobs.put(event.getEventId(), job);
        job.workerThread.start();
    }

    public void stopRecording(Integer eventId) {
        log.debug((Object)("start stopRecording(eventId=" + eventId + ")"));
        this.updateRequestedStopTime(eventId, this.systemSupport.getCurrentDate());
    }

    public void forceStopRecordingAndDeleteEvent(Integer eventId) {
        log.debug((Object)("start forceStopRecordingAndDeleteEvent(eventId=" + eventId + ")"));
        this.updateRequestedStopTime(eventId, this.systemSupport.getCurrentDate(), true);
    }

    public void updateRequestedStopTime(Integer eventId, Date dateStopRequested) {
        this.updateRequestedStopTime(eventId, dateStopRequested, false);
    }

    public void updateRequestedStopTime(Integer eventId, Date dateStopRequested, boolean delete) {
        log.debug((Object)("updateRequestedStopTime eventId: " + eventId + ", dateStopRequested: " + dateStopRequested));
        VideoRecordingJob job = (VideoRecordingJob)this.jobs.get(eventId);
        if (job != null) {
            job.event.setDateStopRequested(dateStopRequested);
            if (delete) {
                job.event.setDeleted(true);
            }
            job.signal.countDown();
        } else {
            log.warn((Object)("Could not find job for eventId: " + eventId));
        }
    }

    void startRecordingFailed(EventEntity event, String error, String comment) {
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, event.getLanDevice().getMac(), event.getLanDevice().getIpAddress(), "FAILED", "Unable to start TCPClient.");
        if (event.getEventtrigger().equals((Object)"MANUAL")) {
            event.setDeleted(true);
            this.updateEvent(event);
        } else if (event.getEventtrigger().equals((Object)"MOTION") || event.getEventtrigger().equals((Object)"AUDIO")) {
            event.setDateStartRequested(null);
            event.setDateStarted(null);
            event.setDateStopRequested(null);
            event.setDateStopped(null);
            this.updateEvent(event);
        }
        this.exitVideoRecording(event);
    }

    void doVideoRecording(VideoRecordingJob job, String camip, int camport, String camusername, String campassword, String url, String resolution, String videoEncoding, boolean supportsRtcpOverRtsp, boolean audioEnabled) {
        EventEntity event = job.event;
        log.debug((Object)("doVideoRecording: event: " + event + ", camip: " + camip + ", camport: " + camport + ", camusername: " + camusername + ", url: " + url + ", resolution: " + resolution));
        String videoFileNameBase = String.valueOf(new SimpleDateFormat("yyyyMMddHHmmss").format(event.getDateEvent())) + "_" + event.getEventId();
        String videoFilePath = videoEncoding.equals("MJPEG") ? String.valueOf(this.snapshotsPath) + "/" + videoFileNameBase + ".flv" : (videoEncoding.equals("MPEG4") ? String.valueOf(this.snapshotsPath) + "/" + videoFileNameBase + ".3gp" : String.valueOf(this.snapshotsPath) + "/" + videoFileNameBase + ".mp4");
        String posterFilePath = String.valueOf(this.snapshotsPath) + "/" + videoFileNameBase + ".jpg";
        String videooutFilePath = String.valueOf(this.snapshotsPath) + "/" + videoFileNameBase + ".mp4";
        log.debug((Object)("videoFilePath: " + videoFilePath));
        TCPClient tcpClient = new TCPClient();
        boolean res = tcpClient.start(this.recordingServerAddress, Integer.parseInt(this.recordingServerPort));
        if (!res) {
            log.error((Object)"Unable to start TCPClient");
            this.startRecordingFailed(event, "FAILED", "Unable to start TCPClient");
            return;
        }
        log.debug((Object)("started TCPClient: " + this.recordingServerAddress + ":" + this.recordingServerPort));
        event.setDateStarted(this.systemSupport.getCurrentDate());
        this.updateEvent(event);
        log.debug((Object)"after updateEvent");
        TCPClient.RecordingStatus status = tcpClient.startRecording(event.getLanDevice().getGatewayClient().getMac(), camip, camport, camusername, campassword, url, videoFilePath, videoEncoding, supportsRtcpOverRtsp);
        log.debug((Object)("after tcpClient.startRecording, status = " + (status == null ? "NULL" : status.toString())));
        if (status == null) {
            log.error((Object)"Unable to start recording.");
            this.startRecordingFailed(event, "FAILED", "Unable to start recording.");
            return;
        }
        if (status == TCPClient.RecordingStatus.ERROR) {
            log.debug((Object)"RecordingStatus.ERROR");
            this.startRecordingFailed(event, "ERROR", null);
            return;
        }
        this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, event.getLanDevice().getMac(), event.getLanDevice().getIpAddress(), "OK", null);
        while (this.running) {
            long duration = event.getDateStopRequested().getTime() - this.systemSupport.getCurrentDate().getTime();
            if (duration <= 0L) {
                log.debug((Object)"Recording time is up");
                break;
            }
            try {
                job.signal.await(Math.min(1000L, duration), TimeUnit.MILLISECONDS);
                job.signal = new CountDownLatch(1);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        TCPClient.RecordingStatus stat = tcpClient.stopRecording(event.getLanDevice().getGatewayClient().getMac().toString(), camip, camport);
        if (stat == null) {
            this.eventlogService.registerEventlog(LDEventType.VIDEORECORDING, event.getLanDevice().getMac(), event.getLanDevice().getIpAddress(), "ERROR", "Unable to stop recording.");
            log.error((Object)"Unable to stop recording.");
        }
        tcpClient.stop();
        event.setDateStopped(this.systemSupport.getCurrentDate());
        this.updateEvent(event);
        log.debug((Object)"Recording finished");
        if (this.isMotionEvent(event) || this.isAudioEvent(event)) {
            this.disableIllumination(event.getLanDevice());
        }
        if (this.systemSupport.getFile(videoFilePath).exists()) {
            log.debug((Object)("doVideoRecording::eventsFilesController = " + this.eventsFilesController));
            if (!this.systemSupport.getFile(posterFilePath).exists() && !this.eventsFilesController.fileExists(posterFilePath.substring(posterFilePath.lastIndexOf("/") + 1))) {
                long posterFileSize = this.videoPostprocessingService.convertToPoster(videoFilePath, posterFilePath, resolution, videoEncoding);
                event.setImageFileSize(Integer.valueOf((int)posterFileSize));
            }
            long videoFileSize = audioEnabled || !videoEncoding.equals("H264") ? this.videoPostprocessingService.convertToMP4(videoFilePath, videooutFilePath, resolution, videoEncoding) : this.systemSupport.getFile(videoFilePath).length();
            event.setVideoFileSize(Integer.valueOf((int)videoFileSize));
            if (videoFileSize > 0L) {
                this.videoPostprocessingService.hintVideoFile(videooutFilePath);
            }
            this.eventsFilesController.uploadFile(videooutFilePath);
            this.eventsFilesController.uploadFile(posterFilePath);
            if (!videoFilePath.equals(videooutFilePath)) {
                this.systemSupport.deleteFile(videoFilePath);
            }
        } else {
            log.warn((Object)(String.valueOf(videoFilePath) + " not created!"));
        }
        this.updateEvent(event);
        this.exitVideoRecording(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exitVideoRecording(EventEntity event) {
        Map map = this.jobs;
        synchronized (map) {
            this.jobs.remove(event.getEventId());
        }
    }

    private EventEntity updateEvent(EventEntity event) {
        log.debug((Object)("start updateEvent(event with eventId=" + event.getEventId() + ")"));
        EventEntity e = this.eventDAO.findEventById(event.getEventId());
        if (e == null) {
            log.warn((Object)("Not found event for eventId=" + event.getEventId() + "."));
            return null;
        }
        e.setDateEvent(event.getDateEvent());
        e.setDateStartRequested(event.getDateStartRequested());
        e.setDateStarted(event.getDateStarted());
        e.setDateStopped(event.getDateStopped());
        e.setDateStopRequested(event.getDateStopRequested());
        e.setEventtrigger(event.getEventtrigger());
        e.setImageFileSize(event.getImageFileSize());
        e.setVideoFileSize(event.getVideoFileSize());
        e.setDeletedVideo(event.getDeletedVideo());
        e.setDeleted(event.getDeleted());
        e.setDeletedVideoDate(event.getDeletedVideoDate());
        log.debug((Object)("stop updateEvent(event with eventId=" + event.getEventId() + ")"));
        EventEntity ent = this.eventDAO.updateEvent(e);
        log.debug((Object)("transactionUpdated (event with eventId=" + event.getEventId() + ")"));
        log.debug((Object)("stop updateEvent(event with eventId=" + event.getEventId() + ")"));
        return ent;
    }

    private boolean isMotionEvent(EventEntity event) {
        return event != null && event.getEventtrigger() == EventServiceImpl.EventTrigger.MOTION;
    }

    private boolean isAudioEvent(EventEntity event) {
        return event != null && event.getEventtrigger() == EventServiceImpl.EventTrigger.AUDIO;
    }

    private void disableIllumination(LanDeviceEntity device) {
        log.debug((Object)("start disableIllumination(lanDevice with landeviceId=" + device.getLanDeviceId() + ")"));
        if (this.isEventLedLightEnabled(device)) {
            GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
            UpdateSettingStatus status = null;
            try {
                status = driver.updateSingleSetting(device, "illumination", "OFF");
            }
            catch (Exception e) {
                status = UpdateSettingStatus.ERROR;
                log.warn((Object)("Exception during disableIllumination for lanDeviceId = " + device.getLanDeviceId() + " and mac = " + device.getMac()));
            }
            log.debug((Object)("disable illumination status: " + status));
            if (status != UpdateSettingStatus.SUCCESS) {
                String logMsg = "Failed to disable illumination for device with lanDeviceId=" + device.getLanDeviceId() + ": " + status + ".";
                if (status == UpdateSettingStatus.FAILED_NOANSEWER) {
                    log.debug((Object)logMsg);
                } else {
                    log.warn((Object)logMsg);
                }
            }
        }
    }

    private boolean isEventLedLightEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("event_led_light"));
    }

    static /* synthetic */ Logger access$0() {
        return log;
    }
}

