/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.impl.VideoPostprocessingServiceImpl;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={VideoPostprocessingServiceImpl.class, ProcessBuilder.class})
public class VideoPostprocessingServiceTests {
    private VideoPostprocessingServiceImpl videoPostprocessingService;
    private SystemSupport systemSupport;
    private String ffmpegCmd;
    private String mp4BoxCmd;
    private ParameterService parameterService;

    @Before
    public void setUp() {
        this.videoPostprocessingService = new VideoPostprocessingServiceImpl();
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.videoPostprocessingService.setSystemSupport(this.systemSupport);
        this.ffmpegCmd = "/urs/bin/ffmpeg";
        this.videoPostprocessingService.setFfmpegCmd(this.ffmpegCmd);
        this.mp4BoxCmd = "/usr/bin/mp4Box";
        this.videoPostprocessingService.setMp4BoxCmd(this.mp4BoxCmd);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.videoPostprocessingService.setParameterService(this.parameterService);
    }

    @Test
    public void testConvertToPosterForMjpegVideoEncodingWithDefaultOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        String posterFilePath = "/opt/homemonitor/events/poster.jpg";
        String resolution = "640x480";
        String videoEncoding = "MJPEG";
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-ss");
        vlcCommands.add("0");
        vlcCommands.add("-vcodec");
        vlcCommands.add("mjpeg");
        vlcCommands.add("-vframes");
        vlcCommands.add("1");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-f");
        vlcCommands.add("image2");
        vlcCommands.add(posterFilePath);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OPTIONS)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OFFSET)).andReturn(null);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File poster = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(posterFilePath)).andReturn((Object)poster);
        EasyMock.expect((Object)poster.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToPoster(videoFilePath, posterFilePath, resolution, videoEncoding);
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConvertToPosterForMjpegVideoEncodingWithCustomOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        String posterFilePath = "/opt/homemonitor/events/poster.jpg";
        String resolution = "640x480";
        String videoEncoding = "MJPEG";
        String customOptions = "-ss 0 -vcodec mjpeg -vframes 5 -s %RESOLUTION% -f image2";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OPTIONS)).andReturn((Object)customOptions);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OFFSET)).andReturn((Object)"2");
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-ss");
        vlcCommands.add("0");
        vlcCommands.add("-vcodec");
        vlcCommands.add("mjpeg");
        vlcCommands.add("-vframes");
        vlcCommands.add("5");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-f");
        vlcCommands.add("image2");
        vlcCommands.add(posterFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File poster = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(posterFilePath)).andReturn((Object)poster);
        EasyMock.expect((Object)poster.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToPoster(videoFilePath, posterFilePath, resolution, videoEncoding);
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConvertToPosterForMpeg4VideoEncodingWithDefaultOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        String posterFilePath = "/opt/homemonitor/events/poster.jpg";
        String resolution = "640x480";
        String videoEncoding = "MPEG4";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OPTIONS)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OFFSET)).andReturn(null);
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-ss");
        vlcCommands.add("0");
        vlcCommands.add("-vframes");
        vlcCommands.add("1");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-f");
        vlcCommands.add("image2");
        vlcCommands.add(posterFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File poster = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(posterFilePath)).andReturn((Object)poster);
        EasyMock.expect((Object)poster.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToPoster(videoFilePath, posterFilePath, resolution, videoEncoding);
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConvertToPosterForMpeg4VideoEncodingWithCustomOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        String posterFilePath = "/opt/homemonitor/events/poster.jpg";
        String resolution = "640x480";
        String videoEncoding = "MPEG4";
        String customOptions = "-ss 0 -vcodec mjpeg -vframes 5 -s %RESOLUTION% -f image2";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OPTIONS)).andReturn((Object)customOptions);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OFFSET)).andReturn((Object)"2");
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-ss");
        vlcCommands.add("2");
        vlcCommands.add("-vframes");
        vlcCommands.add("5");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-f");
        vlcCommands.add("image2");
        vlcCommands.add(posterFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File poster = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(posterFilePath)).andReturn((Object)poster);
        EasyMock.expect((Object)poster.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToPoster(videoFilePath, posterFilePath, resolution, videoEncoding);
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConvertToPosterForH264VideoEncodingWithDefaultOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        String posterFilePath = "/opt/homemonitor/events/poster.jpg";
        String resolution = "640x480";
        String videoEncoding = "H264";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OPTIONS)).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OFFSET)).andReturn(null);
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-ss");
        vlcCommands.add("0");
        vlcCommands.add("-vframes");
        vlcCommands.add("1");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-f");
        vlcCommands.add("image2");
        vlcCommands.add(posterFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File poster = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(posterFilePath)).andReturn((Object)poster);
        EasyMock.expect((Object)poster.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToPoster(videoFilePath, posterFilePath, resolution, videoEncoding);
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConvertToPosterForH264VideoEncodingWithCustomOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        String posterFilePath = "/opt/homemonitor/events/poster.jpg";
        String resolution = "640x480";
        String videoEncoding = "H264";
        String customOptions = "-ss 0 -vcodec mjpeg -vframes 5 -s %RESOLUTION% -f image2";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OPTIONS)).andReturn((Object)customOptions);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OFFSET)).andReturn((Object)"2");
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-ss");
        vlcCommands.add("2");
        vlcCommands.add("-vframes");
        vlcCommands.add("5");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-f");
        vlcCommands.add("image2");
        vlcCommands.add(posterFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File poster = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(posterFilePath)).andReturn((Object)poster);
        EasyMock.expect((Object)poster.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToPoster(videoFilePath, posterFilePath, resolution, videoEncoding);
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConvertToMp4WithDefaultOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.flv";
        String videooutFilePath = "/opt/homemonitor/events/video.mp4";
        String resolution = "640x480";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_MP4_OPTIONS)).andReturn(null);
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-vsync");
        vlcCommands.add("2");
        vlcCommands.add("-ss");
        vlcCommands.add("0");
        vlcCommands.add("-vcodec");
        vlcCommands.add("libx264");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-flags");
        vlcCommands.add("+loop");
        vlcCommands.add("-cmp");
        vlcCommands.add("+chroma");
        vlcCommands.add("-deblockalpha");
        vlcCommands.add("0");
        vlcCommands.add("-deblockbeta");
        vlcCommands.add("0");
        vlcCommands.add("-crf");
        vlcCommands.add("24");
        vlcCommands.add("-bt");
        vlcCommands.add("256k");
        vlcCommands.add("-refs");
        vlcCommands.add("1");
        vlcCommands.add("-coder");
        vlcCommands.add("0");
        vlcCommands.add("-me_range");
        vlcCommands.add("16");
        vlcCommands.add("-subq");
        vlcCommands.add("5");
        vlcCommands.add("-partitions");
        vlcCommands.add("+parti4x4+parti8x8+partp8x8");
        vlcCommands.add("-g");
        vlcCommands.add("250");
        vlcCommands.add("-keyint_min");
        vlcCommands.add("25");
        vlcCommands.add("-level");
        vlcCommands.add("30");
        vlcCommands.add("-qmin");
        vlcCommands.add("10");
        vlcCommands.add("-qmax");
        vlcCommands.add("51");
        vlcCommands.add("-trellis");
        vlcCommands.add("2");
        vlcCommands.add("-sc_threshold");
        vlcCommands.add("40");
        vlcCommands.add("-i_qfactor");
        vlcCommands.add("0.71");
        vlcCommands.add("-acodec");
        vlcCommands.add("libfaac");
        vlcCommands.add("-ab");
        vlcCommands.add("128k");
        vlcCommands.add("-ar");
        vlcCommands.add("48000");
        vlcCommands.add("-ac");
        vlcCommands.add("2");
        vlcCommands.add(videooutFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.getErrorStream()).andReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File videooutFile = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(videooutFilePath)).andReturn((Object)videooutFile);
        EasyMock.expect((Object)videooutFile.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToMP4(videoFilePath, videooutFilePath, resolution, "MJPEG");
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testConvertToMp4WithCustomOptions() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.flv";
        String videooutFilePath = "/opt/homemonitor/events/video.mp4";
        String resolution = "640x480";
        String customOptions = "-vsync 2 -ss 0 -vcodec libx264 -s %RESOLUTION% -flags +loop -cmp +chroma -deblockalpha 0 -deblockbeta 0 -crf 24 -bt 256k -refs 1 -coder 0 -me_range 16 -subq 5 -partitions +parti4x4+parti8x8+partp8x8 -g 250 -keyint_min 25 -level 30 -qmin 10 -qmax 51 -trellis 2 -sc_threshold 40 -i_qfactor 0.71 -acodec libfaac -ab 128k -ar 24000 -ac 2";
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_MP4_OPTIONS)).andReturn((Object)customOptions);
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.ffmpegCmd);
        vlcCommands.add("-i");
        vlcCommands.add(videoFilePath);
        vlcCommands.add("-vsync");
        vlcCommands.add("2");
        vlcCommands.add("-ss");
        vlcCommands.add("0");
        vlcCommands.add("-vcodec");
        vlcCommands.add("libx264");
        vlcCommands.add("-s");
        vlcCommands.add(resolution);
        vlcCommands.add("-flags");
        vlcCommands.add("+loop");
        vlcCommands.add("-cmp");
        vlcCommands.add("+chroma");
        vlcCommands.add("-deblockalpha");
        vlcCommands.add("0");
        vlcCommands.add("-deblockbeta");
        vlcCommands.add("0");
        vlcCommands.add("-crf");
        vlcCommands.add("24");
        vlcCommands.add("-bt");
        vlcCommands.add("256k");
        vlcCommands.add("-refs");
        vlcCommands.add("1");
        vlcCommands.add("-coder");
        vlcCommands.add("0");
        vlcCommands.add("-me_range");
        vlcCommands.add("16");
        vlcCommands.add("-subq");
        vlcCommands.add("5");
        vlcCommands.add("-partitions");
        vlcCommands.add("+parti4x4+parti8x8+partp8x8");
        vlcCommands.add("-g");
        vlcCommands.add("250");
        vlcCommands.add("-keyint_min");
        vlcCommands.add("25");
        vlcCommands.add("-level");
        vlcCommands.add("30");
        vlcCommands.add("-qmin");
        vlcCommands.add("10");
        vlcCommands.add("-qmax");
        vlcCommands.add("51");
        vlcCommands.add("-trellis");
        vlcCommands.add("2");
        vlcCommands.add("-sc_threshold");
        vlcCommands.add("40");
        vlcCommands.add("-i_qfactor");
        vlcCommands.add("0.71");
        vlcCommands.add("-acodec");
        vlcCommands.add("libfaac");
        vlcCommands.add("-ab");
        vlcCommands.add("128k");
        vlcCommands.add("-ar");
        vlcCommands.add("24000");
        vlcCommands.add("-ac");
        vlcCommands.add("2");
        vlcCommands.add(videooutFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.getErrorStream()).andReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        File videooutFile = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(videooutFilePath)).andReturn((Object)videooutFile);
        EasyMock.expect((Object)videooutFile.length()).andReturn((Object)1234L);
        PowerMock.replayAll((Object[])new Object[0]);
        long response = this.videoPostprocessingService.convertToMP4(videoFilePath, videooutFilePath, resolution, "MJPEG");
        Assert.assertEquals((long)1234L, (long)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testHintVideoFile() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        File mp4Box = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(this.mp4BoxCmd)).andReturn((Object)mp4Box);
        EasyMock.expect((Object)mp4Box.canExecute()).andReturn((Object)true);
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.mp4BoxCmd);
        vlcCommands.add("-hint");
        vlcCommands.add(videoFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        Process process = (Process)PowerMock.createMock(Process.class);
        EasyMock.expect((Object)processBuilder.start()).andReturn((Object)process);
        EasyMock.expect((Object)process.waitFor()).andReturn((Object)0);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertTrue((boolean)this.videoPostprocessingService.hintVideoFile(videoFilePath));
        PowerMock.verifyAll();
    }

    @Test
    public void testHintVideoFileFailure() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        File mp4Box = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(this.mp4BoxCmd)).andReturn((Object)mp4Box);
        EasyMock.expect((Object)mp4Box.canExecute()).andReturn((Object)true);
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.mp4BoxCmd);
        vlcCommands.add("-hint");
        vlcCommands.add(videoFilePath);
        ProcessBuilder processBuilder = (ProcessBuilder)PowerMock.createMock(ProcessBuilder.class);
        EasyMock.expect((Object)this.systemSupport.getProcessBuilder(vlcCommands)).andReturn((Object)processBuilder);
        EasyMock.expect((Object)processBuilder.start()).andThrow((Throwable)new IOException());
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.videoPostprocessingService.hintVideoFile(videoFilePath));
        PowerMock.verifyAll();
    }

    @Test
    public void testHintVideoFileCanNotExecuteMp4Box() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        File mp4Box = (File)PowerMock.createMock(File.class);
        EasyMock.expect((Object)this.systemSupport.getFile(this.mp4BoxCmd)).andReturn((Object)mp4Box);
        EasyMock.expect((Object)mp4Box.canExecute()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.videoPostprocessingService.hintVideoFile(videoFilePath));
        PowerMock.verifyAll();
    }

    @Test
    public void testHintVideoFileMp4BoxNotExists() throws IOException, InterruptedException {
        String videoFilePath = "/opt/homemonitor/events/video.mp4";
        EasyMock.expect((Object)this.systemSupport.getFile(this.mp4BoxCmd)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertFalse((boolean)this.videoPostprocessingService.hintVideoFile(videoFilePath));
        PowerMock.verifyAll();
    }
}

