/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.VideoPostprocessingService;

@Component
public class VideoPostprocessingServiceImpl
implements VideoPostprocessingService {
    private static Logger log = Logger.getLogger(VideoPostprocessingServiceImpl.class);
    private SystemSupport systemSupport;
    private String ffmpegCmd;
    private String mp4BoxCmd;
    private ParameterService parameterService;

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Value(value="${lanDevice.ffmpegCmd:/usr/local/bin/ffmpeg}")
    public void setFfmpegCmd(String ffmpegCmd) {
        this.ffmpegCmd = ffmpegCmd;
    }

    @Value(value="${lanDevice.mp4BoxCmd:/usr/local/bin/MP4Box}")
    public void setMp4BoxCmd(String mp4BoxCmd) {
        this.mp4BoxCmd = mp4BoxCmd;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public long convertToPoster(String videoFilePath, String posterFilePath, String resolution, String videoEncoding) {
        block6: {
            log.debug((Object)("start convertToPoster(videoFilePath=" + videoFilePath + ", posterFilePath=" + posterFilePath + ", resolution=" + resolution + ", videoEncoding=" + videoEncoding + ")"));
            ArrayList<String> vlcCommands = new ArrayList<String>();
            vlcCommands.add(this.ffmpegCmd);
            vlcCommands.add("-i");
            vlcCommands.add(videoFilePath);
            String defaultOptions = "-ss 0 -vcodec mjpeg -vframes 1 -s %RESOLUTION% -f image2";
            String jpgOptions = this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OPTIONS);
            jpgOptions = jpgOptions != null ? jpgOptions : defaultOptions;
            jpgOptions = jpgOptions.replace("%RESOLUTION%", resolution);
            if (!videoEncoding.equals("MJPEG")) {
                jpgOptions = jpgOptions.replace("-vcodec", "");
                jpgOptions = jpgOptions.replace("mjpeg", "");
            }
            String offset = this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_JPG_OFFSET);
            if ((videoEncoding.equals("MPEG4") || videoEncoding.equals("H264")) && offset != null && !offset.isEmpty()) {
                jpgOptions = jpgOptions.replace("-ss 0", "-ss " + offset);
            }
            log.debug((Object)("convertToPoster: videoFilePath: " + videoFilePath + " options: " + jpgOptions));
            String[] options = jpgOptions.split(" ");
            Integer i = 0;
            while (i < options.length) {
                if (!options[i].isEmpty()) {
                    vlcCommands.add(options[i]);
                }
                i = i + 1;
            }
            vlcCommands.add(posterFilePath);
            ProcessBuilder pb = this.systemSupport.getProcessBuilder(vlcCommands);
            try {
                Process process = pb.start();
                int ret = process.waitFor();
                log.debug((Object)("convertToPoster: ffmpeg returned: " + ret));
            }
            catch (Exception exception) {
                log.error((Object)("Exception during convert video file to poster: " + exception.getMessage()));
                if (!log.isDebugEnabled()) break block6;
                exception.printStackTrace();
            }
        }
        return this.systemSupport.getFile(posterFilePath).length();
    }

    public long convertToMP4(String videoFilePath, String videooutFilePath, String resolution, String videoEncoding) {
        String tempVideooutFilePath;
        block8: {
            String mp4Options;
            String defaultOptions;
            log.debug((Object)("start convertToMP4(videoFilePath=" + videoFilePath + ", videooutFilePath=" + videooutFilePath + ", resolution=" + resolution + ")"));
            ArrayList<String> vlcCommands = new ArrayList<String>();
            vlcCommands.add(this.ffmpegCmd);
            vlcCommands.add("-i");
            vlcCommands.add(videoFilePath);
            boolean transcodeAudio = videoEncoding.equals("H264");
            if (!transcodeAudio) {
                defaultOptions = "-vsync 2 -ss 0 -vcodec libx264 -s %RESOLUTION% -flags +loop -cmp +chroma -deblockalpha 0 -deblockbeta 0 -crf 24 -bt 256k -refs 1 -coder 0 -me_range 16 -subq 5 -partitions +parti4x4+parti8x8+partp8x8 -g 250 -keyint_min 25 -level 30 -qmin 10 -qmax 51 -trellis 2 -sc_threshold 40 -i_qfactor 0.71";
                mp4Options = this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_MP4_OPTIONS);
                mp4Options = mp4Options != null ? mp4Options : defaultOptions;
                mp4Options = mp4Options.replace("%RESOLUTION%", resolution);
            } else {
                defaultOptions = "-vcodec libx264 -vsync 2";
                mp4Options = this.parameterService.getParameterValue(ParameterService.ParameterCode.CONV_TO_MP4_OPTIONS_AUDIO_ONLY);
                mp4Options = mp4Options != null ? mp4Options : defaultOptions;
            }
            String[] options = mp4Options.split(" ");
            Integer i = 0;
            while (i < options.length) {
                vlcCommands.add(options[i]);
                i = i + 1;
            }
            tempVideooutFilePath = String.valueOf(videooutFilePath) + ".tmp.mp4";
            vlcCommands.add(tempVideooutFilePath);
            ProcessBuilder pb = this.systemSupport.getProcessBuilder(vlcCommands);
            try {
                Process process = pb.start();
                InputStream stdout = process.getErrorStream();
                InputStreamReader isr = new InputStreamReader(stdout);
                BufferedReader br = new BufferedReader(isr);
                while (br.readLine() != null) {
                }
                int ret = process.waitFor();
                log.debug((Object)("convertToMP4: ffmpeg returned: " + ret));
                if (ret != 0) {
                    log.info((Object)("ffmpeg failed to convert file '" + videoFilePath + "' to MP4"));
                    return 0L;
                }
            }
            catch (Exception exception) {
                log.error((Object)("Exception during convert video file to mp4: " + exception.getMessage()));
                if (!log.isDebugEnabled()) break block8;
                exception.printStackTrace();
            }
        }
        if (!this.systemSupport.renameFile(tempVideooutFilePath, videooutFilePath)) {
            log.warn((Object)("cannot rename temp recording file " + tempVideooutFilePath + " to " + videooutFilePath));
            return 0L;
        }
        return this.systemSupport.getFile(videooutFilePath).length();
    }

    public boolean hintVideoFile(String videoFilePath) {
        log.debug((Object)("start hintVideoFile(videoFilePath=" + videoFilePath + ")"));
        File mp4Box = this.systemSupport.getFile(this.mp4BoxCmd);
        if (mp4Box == null) {
            log.warn((Object)"mp4Box not exists.");
            return false;
        }
        if (!mp4Box.canExecute()) {
            log.warn((Object)("Cannot MP4 hint file " + videoFilePath + ", MP4Box not found!"));
            return false;
        }
        ArrayList<String> vlcCommands = new ArrayList<String>();
        vlcCommands.add(this.mp4BoxCmd);
        vlcCommands.add("-hint");
        vlcCommands.add(videoFilePath);
        ProcessBuilder pb = this.systemSupport.getProcessBuilder(vlcCommands);
        try {
            Process process = pb.start();
            int ret = process.waitFor();
            log.debug((Object)("hintVideoFile: MP4Box returned: " + ret));
            return true;
        }
        catch (Exception exception) {
            log.error((Object)("Exception during hint video file for path: " + exception.getMessage()));
            if (log.isDebugEnabled()) {
                exception.printStackTrace();
            }
            return false;
        }
    }
}

