/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.Date;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.hm.WebViewer.shared.model.AccountSettings;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.SaveResponse;
import pl.smartapps.restserver.rest.response.UpdateAccountSettingsResponse;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.UserServiceImpl;
import pl.smartapps.restserver.service.impl.UserServiceImplInternal;
import pl.smartapps.restserver.sso.SsoProvider;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserServiceImpl.class, SsoProvider.class})
public class UserServiceUpdateSettingsTests
extends UserServiceImplInternal {
    @Test
    public void testUpdateAccountSettingsFailureNullArgumentPass() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(null);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsFailureInvalidEmail() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_EMAILINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsFailureEmailTaken() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn((Object)new UserEntity(Integer.valueOf(123)));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_EMAILTAKEN);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidFirstname() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_FIRSTNAMEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidLastname() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_LASTNAMEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidAddress() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_ADDRESSINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidTown() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_TOWNINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidZipCode() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_ZIPCODEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidCountry() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_COUNTRYINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidLanguage() throws InvalidSessionException {
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_LANGUAGEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithoutPasswordChangeSuccessfuly() throws InvalidSessionException {
        Date addedDate = new Date();
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        accountSettings.setMailing(Boolean.valueOf(false));
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setEmail("test@email.com");
        user.setAddedDate(addedDate);
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1), false, false)).andReturn((Object)user);
        EasyMock.expect((Object)this.userDAO.updateUser(user)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithPasswordChangeSuccessfuly() throws InvalidSessionException {
        Date addedDate = new Date();
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setPassword("test5A");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        accountSettings.setMailing(Boolean.valueOf(false));
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setEmail("test@email.com");
        foundUser.setAddedDate(addedDate);
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1), false, false)).andReturn((Object)foundUser);
        EasyMock.expect((Object)this.passwordValidator.validate("test5A")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)"newSalt");
        EasyMock.expect((Object)this.passwordHashGenerator.generate("test5A", "newSalt")).andReturn((Object)"hashedPassword");
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setEmail("test2@email.com");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLastname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setState("");
        savedUser.setAddedDate(addedDate);
        savedUser.setPasswordSalt("newSalt");
        savedUser.setPassword("hashedPassword");
        EasyMock.expect((Object)this.userDAO.updateUser(savedUser)).andReturn((Object)savedUser);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithNoAdditionalDataSuccessfuly() throws InvalidSessionException {
        Date addedDate = new Date();
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setPassword("test5A");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        accountSettings.setMailing(Boolean.valueOf(false));
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setEmail("test@email.com");
        foundUser.setAddedDate(addedDate);
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1), false, false)).andReturn((Object)foundUser);
        EasyMock.expect((Object)this.passwordValidator.validate("test5A")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)"newSalt");
        EasyMock.expect((Object)this.passwordHashGenerator.generate("test5A", "newSalt")).andReturn((Object)"hashedPassword");
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setEmail("test2@email.com");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLastname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setState("");
        savedUser.setMailing(false);
        savedUser.setAddedDate(addedDate);
        savedUser.setPasswordSalt("newSalt");
        savedUser.setPassword("hashedPassword");
        EasyMock.expect((Object)this.userDAO.updateUser(savedUser)).andReturn((Object)savedUser);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithNoAdditionalDataNoDataSuccessfuly() throws InvalidSessionException {
        Date addedDate = new Date();
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setPassword("test5A");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress(null);
        accountSettings.setTown(null);
        accountSettings.setZipCode(null);
        accountSettings.setCountry(null);
        accountSettings.setLanguage(null);
        accountSettings.setState(null);
        accountSettings.setMailing(null);
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setEmail("test@email.com");
        foundUser.setAddedDate(addedDate);
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1), false, false)).andReturn((Object)foundUser);
        EasyMock.expect((Object)this.passwordValidator.validate("test5A")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)"newSalt");
        EasyMock.expect((Object)this.passwordHashGenerator.generate("test5A", "newSalt")).andReturn((Object)"hashedPassword");
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setEmail("test2@email.com");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLastname");
        savedUser.setAddress("");
        savedUser.setTown("");
        savedUser.setZipCode("");
        savedUser.setCountry("");
        savedUser.setLanguage("");
        savedUser.setState("");
        savedUser.setMailing(false);
        savedUser.setAddedDate(addedDate);
        savedUser.setPasswordSalt("newSalt");
        savedUser.setPassword("hashedPassword");
        EasyMock.expect((Object)this.userDAO.updateUser(savedUser)).andReturn((Object)savedUser);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSettingsWithInvalidPassword() throws InvalidSessionException {
        Date addedDate = new Date();
        AccountSettings accountSettings = new AccountSettings();
        accountSettings.setUserId(Integer.valueOf(1));
        accountSettings.setEmail("test2@email.com");
        accountSettings.setPassword("test");
        accountSettings.setFirstname("testFirstname");
        accountSettings.setLastname("testLastname");
        accountSettings.setAddress("testAddress");
        accountSettings.setTown("testTown");
        accountSettings.setZipCode("testZipCode");
        accountSettings.setCountry("testCountry");
        accountSettings.setLanguage("testLanguage");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setEmail("test@email.com");
        foundUser.setAddedDate(addedDate);
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.emailValidator.validate("test2@email.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test2@email.com")).andReturn(null);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1), false, false)).andReturn((Object)foundUser);
        EasyMock.expect((Object)this.passwordValidator.validate("test")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateAccountSettingsResponse response = this.userService.updateSettings(accountSettings);
        UpdateAccountSettingsResponse expectedResponse = new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_PASSWORDINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdaeUserSettingsFailureUserNull() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        SaveResponse expectedResponse = new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        SaveResponse response = this.userService.updateUserSettings(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdaeUserSettingsFailureUserIdNull() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        SaveResponse expectedResponse = new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        User user = new User();
        Date date = Utils.constructDate((int)2011, (int)6, (int)15, (int)7, (int)54, (int)41);
        user.setAddedDate(date);
        user.setDeleted(Boolean.valueOf(false));
        user.setDeletedDate(null);
        user.setEmail("test@test.pl");
        user.setId(null);
        user.setUsername("test");
        SaveResponse response = this.userService.updateUserSettings(user);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdaeUserSettingsFailureUserNotExists() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SaveResponse expectedResponse = new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        User user = new User();
        Date date = Utils.constructDate((int)2011, (int)6, (int)15, (int)7, (int)54, (int)41);
        user.setAddedDate(date);
        user.setDeleted(Boolean.valueOf(false));
        user.setDeletedDate(null);
        user.setEmail("test@test.pl");
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        SaveResponse response = this.userService.updateUserSettings(user);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdaeUserSettingsFailureSaving() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)15, (int)7, (int)54, (int)41);
        UserEntity entity = new UserEntity();
        entity.setAddedDate(date);
        entity.setDeleted(Integer.valueOf(0));
        entity.setDeletedDate(null);
        entity.setEmail("test@test.pl");
        entity.setId(Integer.valueOf(1));
        entity.setUsername("test");
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)entity);
        EasyMock.expect((Object)this.userDAO.updateUser(entity)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SaveResponse expectedResponse = new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        User user = new User();
        user.setAddedDate(date);
        user.setDeleted(Boolean.valueOf(false));
        user.setDeletedDate(null);
        user.setEmail("test@test.pl");
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        SaveResponse response = this.userService.updateUserSettings(user);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdaeUserSettingsSuccesfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)15, (int)7, (int)54, (int)41);
        UserEntity foundUser = new UserEntity();
        foundUser.setAddedDate(date);
        foundUser.setDeleted(Integer.valueOf(0));
        foundUser.setDeletedDate(null);
        foundUser.setEmail(null);
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setFirstname("");
        foundUser.setLastname("");
        foundUser.setAddress("");
        foundUser.setTown("");
        foundUser.setZipCode("");
        foundUser.setState("");
        foundUser.setCountry("");
        foundUser.setLanguage("");
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)foundUser);
        UserEntity savedUser = new UserEntity();
        savedUser.setAddedDate(date);
        savedUser.setDeleted(Integer.valueOf(0));
        savedUser.setDeletedDate(null);
        savedUser.setEmail("test@test.pl");
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("test");
        savedUser.setFirstname("firstname");
        savedUser.setLastname("lastname");
        savedUser.setAddress("address");
        savedUser.setTown("town");
        savedUser.setZipCode("zipCode");
        savedUser.setState("state");
        savedUser.setCountry("PL");
        savedUser.setLanguage("en");
        EasyMock.expect((Object)this.userDAO.updateUser(savedUser)).andReturn((Object)savedUser);
        PowerMock.replayAll((Object[])new Object[0]);
        SaveResponse expectedResponse = new SaveResponse(SaveResponse.SaveStatus.SAVED);
        User user = new User();
        user.setAddedDate(date);
        user.setDeleted(Boolean.valueOf(false));
        user.setDeletedDate(null);
        user.setEmail("test@test.pl");
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setFirstname("firstname");
        user.setLastname("lastname");
        user.setAddress("address");
        user.setTown("town");
        user.setZipCode("zipCode");
        user.setState("state");
        user.setCountry("PL");
        user.setLanguage("en");
        SaveResponse response = this.userService.updateUserSettings(user);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }
}

