/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.hm.WebViewer.shared.model.AccountSettings;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.RegisterResponse;
import pl.smartapps.hm.WebViewer.shared.model.ResendActivationCodeStatus;
import pl.smartapps.hm.WebViewer.shared.model.SendActivationCodeStatus;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.hm.WebViewer.shared.model.UserDetails;
import pl.smartapps.hm.WebViewer.shared.model.UserNameId;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.ProductDAO;
import pl.smartapps.restserver.db.dao.SSOParameterDAO;
import pl.smartapps.restserver.db.dao.ShareDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ShareEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.ChangePasswordResponse;
import pl.smartapps.restserver.rest.response.CreateSessionResponse;
import pl.smartapps.restserver.rest.response.ForgotPasswordResponse;
import pl.smartapps.restserver.rest.response.GetUsersResponse;
import pl.smartapps.restserver.rest.response.LogoutResponse;
import pl.smartapps.restserver.rest.response.RemoveUserResponse;
import pl.smartapps.restserver.rest.security.PasswordGenerator;
import pl.smartapps.restserver.rest.security.PasswordHashGenerator;
import pl.smartapps.restserver.rest.validator.EmailValidator;
import pl.smartapps.restserver.rest.validator.NotEmptyValidator;
import pl.smartapps.restserver.rest.validator.PasswordValidator;
import pl.smartapps.restserver.rest.validator.UsernameValidator;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.EmailNotificationServiceImpl;
import pl.smartapps.restserver.service.impl.ProductManagementServiceImpl;
import pl.smartapps.restserver.service.impl.UserServiceImpl;
import pl.smartapps.restserver.sso.SsoProvider;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserServiceImpl.class, SsoProvider.class})
public class UserServiceTests {
    private UserServiceImpl userService;
    private UserDAO userDAO;
    private AuthenticationUtils authUtils;
    private Subject subject;
    private Session session;
    private PasswordHashGenerator passwordHashGenerator;
    private PasswordGenerator passwordGenerator;
    private EmailNotificationServiceImpl emailNotificationService;
    private GatewayDeviceConnectionService gatewayDeviceConnection;
    private ProductManagementService productManagementService;
    private ProductDAO productDAO;
    private GatewayClientDAO gatewayClientDAO;
    private LanDeviceDAO lanDeviceDAO;
    private SSOParameterDAO ssoParameterDAO;
    private EmailValidator emailValidator;
    private UsernameValidator usernameValidator;
    private PasswordValidator passwordValidator;
    private NotEmptyValidator notEmptyValidator;
    private SystemSupport systemSupport;
    private ParameterService parameterService;
    private ShareDAO shareDAO;

    @Before
    public void setUp() {
        this.userService = new UserServiceImpl();
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.userService.setUserDAO(this.userDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.userService.setAuthUtils(this.authUtils);
        this.passwordHashGenerator = (PasswordHashGenerator)PowerMock.createMock(PasswordHashGenerator.class);
        this.userService.setPasswordHashGenerator(this.passwordHashGenerator);
        this.subject = (Subject)PowerMock.createMock(Subject.class);
        this.session = (Session)PowerMock.createMock(Session.class);
        this.passwordGenerator = (PasswordGenerator)PowerMock.createMock(PasswordGenerator.class);
        this.userService.setPasswordGenerator(this.passwordGenerator);
        this.emailNotificationService = (EmailNotificationServiceImpl)PowerMock.createMock(EmailNotificationServiceImpl.class);
        this.userService.setEmailNotificationService((EmailNotificationService)this.emailNotificationService);
        this.gatewayDeviceConnection = (GatewayDeviceConnectionService)PowerMock.createMock(GatewayDeviceConnectionService.class);
        this.userService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.productManagementService = (ProductManagementService)PowerMock.createMock(ProductManagementServiceImpl.class);
        this.userService.setProductManagementService(this.productManagementService);
        this.productDAO = (ProductDAO)PowerMock.createMock(ProductDAO.class);
        this.userService.setProductDAO(this.productDAO);
        this.gatewayClientDAO = (GatewayClientDAO)PowerMock.createMock(GatewayClientDAO.class);
        this.userService.setGatewayClientDAO(this.gatewayClientDAO);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.userService.setLanDeviceDAO(this.lanDeviceDAO);
        this.emailValidator = (EmailValidator)PowerMock.createMock(EmailValidator.class);
        this.userService.setEmailValidator(this.emailValidator);
        this.usernameValidator = (UsernameValidator)PowerMock.createMock(UsernameValidator.class);
        this.userService.setUsernameValidator(this.usernameValidator);
        this.passwordValidator = (PasswordValidator)PowerMock.createMock(PasswordValidator.class);
        this.userService.setPasswordValidator(this.passwordValidator);
        this.notEmptyValidator = (NotEmptyValidator)PowerMock.createMock(NotEmptyValidator.class);
        this.userService.setNotEmptyValidator(this.notEmptyValidator);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.userService.setSystemSupport(this.systemSupport);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.userService.setParameterService(this.parameterService);
        this.shareDAO = (ShareDAO)PowerMock.createMock(ShareDAO.class);
        this.userService.setShareDAO(this.shareDAO);
    }

    @Test
    public void testRegisterUserSuccesfullyWithServerAddressWithoutProtocol() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithServerAddressHttpProtocol() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("http://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithServerAddressWithHttpsProtocol() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithCaptchaChecking() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithNoCaptchaChecking() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithConfirmation() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithNoConfirmation() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)true).times(3);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap placeholders = new HashMap();
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.WELCOME, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.ALREADY_ACTIVE, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithNotSendingEmail() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(4);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)true).times(2);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)false);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.ALREADY_ACTIVE, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithAdditionalData() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithoutFirstnameAndLastName() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname(null);
        user.setLastname(null);
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("");
        newUser.setLastname("");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("");
        savedUser.setLastname("");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithNoAdditionalData() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("");
        newUser.setTown("");
        newUser.setZipCode("");
        newUser.setState("");
        newUser.setCountry("");
        newUser.setLanguage("");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("");
        savedUser.setTown("");
        savedUser.setZipCode("");
        savedUser.setState("");
        savedUser.setCountry("");
        savedUser.setLanguage("");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)true);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSuccesfullyWithUpdatingSomeShares() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(3);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("https://smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        ArrayList<ShareEntity> shares = new ArrayList<ShareEntity>();
        ShareEntity share1 = (ShareEntity)PowerMock.createMock(ShareEntity.class);
        shares.add(share1);
        ShareEntity share2 = (ShareEntity)PowerMock.createMock(ShareEntity.class);
        shares.add(share2);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(shares);
        share1.setUser(savedUser);
        EasyMock.expect((Object)this.shareDAO.update(share1)).andReturn((Object)share1);
        share2.setUser(savedUser);
        EasyMock.expect((Object)this.shareDAO.update(share2)).andReturn((Object)share2);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserSendActivationEmailFailure() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false).times(3);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION)).andReturn((Object)false).times(2);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true);
        this.userService.setServerUrl("smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.FAILED_EMAILPROBLEM, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithUsernameInvalid() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_USERNAMEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithInvalidFirstname() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_FIRSTNAMEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithInvalidLastname() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_LASTNAMEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithInvalidAddress() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_ADDRESSINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithInvalidTown() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_TOWNINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithInvalidZipCode() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_ZIPCODEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithInvalidCountry() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_COUNTRYINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithInvalidLanguage() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_LANGUAGEINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserForUsernameAndEmailToWhichUserAlreadyExistsButNotActivated() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLastname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setPassword("123");
        foundUser.setPasswordSalt("123");
        foundUser.setDeleted(Integer.valueOf(0));
        foundUser.setActivationCode("123");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("test", "test@test.pl")).andReturn((Object)foundUser);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_USERNOTACTIVATED);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithUsernameTaken() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLastname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setPassword("123");
        foundUser.setPasswordSalt("123");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("test", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_USERNAMETAKEN);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithEmailInvalid() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLastname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_EMAILINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithEmailAddressTaken() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setId(null);
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLastname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setPassword("123");
        foundUser.setPasswordSalt("123");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLastname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("test", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn((Object)foundUser);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.FAILED_EMAILTAKEN, (Object)response.status);
        Assert.assertEquals(null, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithPasswordInvalid() {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)false);
        User user = new User();
        user.setUsername("test");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLastname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.isCaptchaCorrect((String)EasyMock.eq((Object)"12345"))).andReturn((Object)true);
        EasyMock.expect((Object)this.usernameValidator.validate("test")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        RegisterResponse expectedResponse = new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_PASSWORDINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithFalseConfirmationAndWithFalseNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(false));
        user.setNotification(Boolean.valueOf(false));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true);
        HashMap placeholders = new HashMap();
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.WELCOME, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.ALREADY_ACTIVE, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithNullConfirmationAndWithNullNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(null);
        user.setNotification(null);
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true);
        HashMap placeholders = new HashMap();
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.WELCOME, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.ALREADY_ACTIVE, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithTrueConfirmationAndWithFalseNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(false));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithTrueConfirmationAndWithNullNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(null);
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("smart-apps.pl");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithFalseConfirmationAndWithTrueNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(false));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true);
        this.userService.setServerUrl("smart-apps.pl");
        HashMap placeholders = new HashMap();
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.WELCOME, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.NEW_ACCOUNT_NOTIFICATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.ALREADY_ACTIVE, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithNotSendingEmailAndWithTrueNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(4);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(false));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)false);
        HashMap placeholders = new HashMap();
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.NEW_ACCOUNT_NOTIFICATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.ALREADY_ACTIVE, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithNullConfirmationAndWithTrueNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(null);
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true);
        this.userService.setServerUrl("smart-apps.pl");
        HashMap placeholders = new HashMap();
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.WELCOME, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.NEW_ACCOUNT_NOTIFICATION, placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.ALREADY_ACTIVE, (Object)response.activationStatus);
    }

    @Test
    public void testRegisterUserWithIntegrationRoleAndWithTrueConfirmationAndWithTrueNotification() throws Exception {
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION)).andReturn((Object)true).times(5);
        String hashedPassword = "4gS43sdwId5hfUF7cZXSFuhPbgnZMDIB8w0uW+C4DHQ=";
        String salt = "4";
        User user = new User();
        user.setId(null);
        user.setUsername("testUser");
        user.setPassword("A1qwDrv");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setMailing(Boolean.valueOf(false));
        user.setConfirmation(Boolean.valueOf(true));
        user.setNotification(Boolean.valueOf(true));
        ProductEntity defaultProduct = new ProductEntity(Integer.valueOf(1), "test", new Date(), new Date());
        UserEntity newUser = new UserEntity();
        newUser.setId(null);
        newUser.setUsername("testUser");
        newUser.setPassword(hashedPassword);
        newUser.setPasswordSalt(salt);
        newUser.setEmail("test@test.pl");
        newUser.setFirstname("testFirstname");
        newUser.setLastname("testLasnname");
        newUser.setAddress("testAddress");
        newUser.setTown("testTown");
        newUser.setZipCode("testZipCode");
        newUser.setState("testState");
        newUser.setCountry("testCountry");
        newUser.setLanguage("testLanguage");
        newUser.setProduct(defaultProduct);
        newUser.setDeleted(Integer.valueOf(0));
        Date addedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        newUser.setAddedDate(addedDate);
        UserEntity savedUser = new UserEntity();
        savedUser.setId(Integer.valueOf(1));
        savedUser.setUsername("testUser");
        savedUser.setPassword(hashedPassword);
        savedUser.setPasswordSalt(salt);
        savedUser.setEmail("test@test.pl");
        savedUser.setFirstname("testFirstname");
        savedUser.setLastname("testLasnname");
        savedUser.setAddress("testAddress");
        savedUser.setTown("testTown");
        savedUser.setZipCode("testZipCode");
        savedUser.setState("testState");
        savedUser.setCountry("testCountry");
        savedUser.setLanguage("testLanguage");
        savedUser.setProduct(defaultProduct);
        savedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA)).andReturn((Object)false);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME)).andReturn((Object)false);
        EasyMock.expect((Object)this.usernameValidator.validate("testUser")).andReturn((Object)true);
        EasyMock.expect((Object)this.passwordValidator.validate("A1qwDrv")).andReturn((Object)true);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testFirstname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLasnname")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testAddress")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testTown")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testZipCode")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testCountry")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("testLanguage")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByUsernameAndEmailAddress("testUser", "test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByName("testUser")).andReturn(null);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)salt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate("A1qwDrv", salt)).andReturn((Object)hashedPassword);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)addedDate);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"occupiedActivationCode");
        UserEntity userWithActivationCode = new UserEntity();
        userWithActivationCode.setId(Integer.valueOf(2));
        userWithActivationCode.setUsername("occupiedCodeUser");
        userWithActivationCode.setPassword("password");
        userWithActivationCode.setPasswordSalt("salt");
        userWithActivationCode.setEmail("occupiedCodeUser@test.pl");
        userWithActivationCode.setActivationCode("occupiedActivationCode");
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode("occupiedActivationCode")).andReturn((Object)userWithActivationCode);
        String activationCode = "1234567890ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)activationCode);
        EasyMock.expect((Object)this.userDAO.findUserByActivationCode(activationCode)).andReturn(null);
        newUser.setActivationCode(activationCode);
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)1);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)defaultProduct);
        EasyMock.expect((Object)this.userDAO.createUser(newUser)).andReturn((Object)savedUser);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL)).andReturn((Object)true).times(2);
        this.userService.setServerUrl("smart-apps.pl");
        HashMap<String, String> activationAccountPlaceholders = new HashMap<String, String>();
        activationAccountPlaceholders.put("%LINK%", "http://smart-apps.pl/user/activateAccount?code=1234567890ABCDEF_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, activationAccountPlaceholders, null)).andReturn((Object)true);
        HashMap newAccountNotificationPlaceholders = new HashMap();
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.NEW_ACCOUNT_NOTIFICATION, newAccountNotificationPlaceholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.shareDAO.findSharesByEmail("test@test.pl")).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        RegisterResponse response = this.userService.registerUser(user, "12345");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)RegisterResponse.RegisterStatus.OK, (Object)response.status);
        Assert.assertEquals((Object)RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED, (Object)response.activationStatus);
    }

    @Test
    public void testSendActivationCodeSuccessfuly() {
        UserEntity userEntity = new UserEntity();
        userEntity.setId(Integer.valueOf(1));
        userEntity.setUsername("test");
        userEntity.setEmail("test@test.pl");
        userEntity.setActivationCode("123abc");
        userEntity.setDeleted(Integer.valueOf(0));
        userEntity.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn((Object)userEntity);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setActivationCode("123abc");
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        this.userService.setServerUrl("homemonitor.ch");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://homemonitor.ch/user/activateAccount?code=123abc_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        SendActivationCodeStatus response = this.userService.sendActivationCode("test@test.pl");
        Assert.assertEquals((Object)SendActivationCodeStatus.SUCCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendActivationCodeForInvalidEmailAddress() {
        PowerMock.replayAll((Object[])new Object[0]);
        SendActivationCodeStatus response = this.userService.sendActivationCode(null);
        Assert.assertEquals((Object)SendActivationCodeStatus.FAILED_INVALIDEMAIL, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendActivationCodeForNotRegisteredUser() {
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SendActivationCodeStatus response = this.userService.sendActivationCode("test@test.pl");
        Assert.assertEquals((Object)SendActivationCodeStatus.FAILED_USERNOTREGISTERED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendActivationCodeForAlreadyActivatedUser() {
        UserEntity userEntity = new UserEntity();
        userEntity.setId(Integer.valueOf(1));
        userEntity.setUsername("test");
        userEntity.setEmail("test@test.pl");
        userEntity.setActivationCode(null);
        userEntity.setDeleted(Integer.valueOf(0));
        userEntity.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn((Object)userEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        SendActivationCodeStatus response = this.userService.sendActivationCode("test@test.pl");
        Assert.assertEquals((Object)SendActivationCodeStatus.FAILED_USERALREADYACTIVATED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testSendActivationCodeFailureSendEmail() {
        UserEntity userEntity = new UserEntity();
        userEntity.setId(Integer.valueOf(1));
        userEntity.setUsername("test");
        userEntity.setEmail("test@test.pl");
        userEntity.setActivationCode("123abc");
        userEntity.setDeleted(Integer.valueOf(0));
        userEntity.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn((Object)userEntity);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setActivationCode("123abc");
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        this.userService.setServerUrl("homemonitor.ch");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://homemonitor.ch/user/activateAccount?code=123abc_000001");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        SendActivationCodeStatus response = this.userService.sendActivationCode("test@test.pl");
        Assert.assertEquals((Object)SendActivationCodeStatus.FAILED_EMAILPROBLEM, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testLogout() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.logoutUser()).andReturn((Object)LogoutResponse.LogoutStatus.OK);
        PowerMock.replayAll((Object[])new Object[0]);
        LogoutResponse response = this.userService.logoutUser();
        LogoutResponse expectedResponse = new LogoutResponse(LogoutResponse.LogoutStatus.OK);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveCurrentLoggedUser() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.authUtils.logoutUser()).andReturn((Object)LogoutResponse.LogoutStatus.OK);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(0), null));
        Date deletedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)deletedDate);
        EasyMock.expect((Object)this.userDAO.getMaxDeletedValueByUsername("test")).andReturn((Object)0);
        UserEntity deletedUser = this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(1), deletedDate);
        EasyMock.expect((Object)this.userDAO.updateUser(deletedUser)).andReturn((Object)deletedUser);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(null);
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.isUserDeleted(deletedUser));
        PowerMock.verifyAll();
    }

    private boolean isUserDeleted(UserEntity user) {
        for (LanDeviceEntity device : user.getLanDevices()) {
            if (!device.getDeleted()) {
                return false;
            }
            for (EventEntity event : device.getEvents()) {
                if (event.getDeleted()) continue;
                return false;
            }
        }
        for (GatewayClientEntity gatewayClient : user.getGatewayClients()) {
            if (gatewayClient.getDeleted()) continue;
            return false;
        }
        return user.isDeleted();
    }

    @Test
    public void testRemoveCurrentLoggedUserFailureUpdate() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.authUtils.logoutUser()).andReturn((Object)LogoutResponse.LogoutStatus.OK);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(0), null));
        Date deletedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)deletedDate);
        EasyMock.expect((Object)this.userDAO.getMaxDeletedValueByUsername("test")).andReturn((Object)0);
        UserEntity deletedUser = this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(1), deletedDate);
        EasyMock.expect((Object)this.userDAO.updateUser(deletedUser)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(null);
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.isUserDeleted(deletedUser));
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveCurrentLoggedAlreadyDeletedUser() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.authUtils.logoutUser()).andReturn((Object)LogoutResponse.LogoutStatus.OK);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(1), null));
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(null);
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.FAILED_USERNOTFOUND);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveCurrentLoggedUserNotFoundUser() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.authUtils.logoutUser()).andReturn((Object)LogoutResponse.LogoutStatus.OK);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(null);
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.FAILED_USERNOTFOUND);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private UserEntity buildUser(Integer userId, String username, Integer deleted, Date deletedDate) {
        UserEntity user = new UserEntity();
        user.setId(userId);
        user.setUsername(username);
        user.setDeleted(deleted);
        user.setDeletedDate(deletedDate);
        boolean isDeleted = !deleted.equals(0);
        HashSet<LanDeviceEntity> devices = new HashSet<LanDeviceEntity>();
        LanDeviceEntity device1 = this.buildLanDevie(Integer.valueOf(1), isDeleted);
        HashSet<EventEntity> events1 = new HashSet<EventEntity>();
        events1.add(this.buildEvent(Integer.valueOf(1), isDeleted));
        events1.add(this.buildEvent(Integer.valueOf(2), isDeleted));
        events1.add(this.buildEvent(Integer.valueOf(3), isDeleted));
        device1.setEvents(events1);
        LanDeviceEntity device2 = this.buildLanDevie(Integer.valueOf(2), isDeleted);
        HashSet events2 = new HashSet();
        events1.add(this.buildEvent(Integer.valueOf(4), isDeleted));
        events1.add(this.buildEvent(Integer.valueOf(5), isDeleted));
        device2.setEvents(events2);
        LanDeviceEntity device3 = this.buildLanDevie(Integer.valueOf(3), true);
        Date device3DeletedDate = Utils.constructDate((int)2011, (int)9, (int)1, (int)10, (int)1, (int)23);
        device3.setDeletedDate(device3DeletedDate);
        HashSet events3 = new HashSet();
        events1.add(this.buildEvent(Integer.valueOf(6), true));
        device3.setEvents(events3);
        devices.add(device1);
        devices.add(device2);
        devices.add(device3);
        user.setLanDevices(devices);
        HashSet<GatewayClientEntity> gatewayClients = new HashSet<GatewayClientEntity>();
        gatewayClients.add(this.buildGatewayClient(Integer.valueOf(1), isDeleted));
        gatewayClients.add(this.buildGatewayClient(Integer.valueOf(2), isDeleted));
        gatewayClients.add(this.buildGatewayClient(Integer.valueOf(3), isDeleted));
        user.setGatewayClients(gatewayClients);
        return user;
    }

    private LanDeviceEntity buildLanDevie(Integer lanDeviceId, boolean deleted) {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(lanDeviceId);
        device.setDeleted(deleted);
        return device;
    }

    private EventEntity buildEvent(Integer eventId, boolean deleted) {
        EventEntity event = new EventEntity();
        event.setEventId(eventId);
        event.setDeleted(deleted);
        return event;
    }

    private GatewayClientEntity buildGatewayClient(Integer gatewayClientId, boolean deleted) {
        GatewayClientEntity gatewayClient = new GatewayClientEntity();
        gatewayClient.setGatewayClientId(gatewayClientId);
        gatewayClient.setDeleted(deleted);
        return gatewayClient;
    }

    @Test
    public void testRemoveNotCurrentLoggedUserSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION})).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)2);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(0), null));
        Date deletedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)deletedDate);
        EasyMock.expect((Object)this.userDAO.getMaxDeletedValueByUsername("test")).andReturn((Object)0);
        UserEntity deletedUser = this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(1), deletedDate);
        EasyMock.expect((Object)this.userDAO.updateUser(deletedUser)).andReturn((Object)deletedUser);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(Integer.valueOf(1));
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.isUserDeleted(deletedUser));
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveNotCurrentLoggedUserFailureUpdate() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION})).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)2);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(0), null));
        Date deletedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)deletedDate);
        EasyMock.expect((Object)this.userDAO.getMaxDeletedValueByUsername("test")).andReturn((Object)0);
        UserEntity deletedUser = this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(1), deletedDate);
        EasyMock.expect((Object)this.userDAO.updateUser(deletedUser)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(Integer.valueOf(1));
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.isUserDeleted(deletedUser));
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveNotCurrentLoggedAlreadyDeletedUser() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION})).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)2);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(1), null));
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(Integer.valueOf(1));
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.FAILED_USERNOTFOUND);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveNotCurrentLoggedUserNotFoundUser() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION})).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)2);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(Integer.valueOf(1));
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.FAILED_USERNOTFOUND);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveNotCurrentLoggedUserWithUnsificientPermissions() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION})).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)2);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(Integer.valueOf(1));
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.FAILED_INSUFFICIENTPERMISSIONS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveCurrentLoggedUserWithUnsificientPermissions() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION})).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(0), null));
        EasyMock.expect((Object)this.authUtils.logoutUser()).andReturn((Object)LogoutResponse.LogoutStatus.OK);
        Date deletedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)30, (int)56);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)deletedDate);
        EasyMock.expect((Object)this.userDAO.getMaxDeletedValueByUsername("test")).andReturn((Object)0);
        UserEntity deletedUser = this.buildUser(Integer.valueOf(1), "test", Integer.valueOf(1), deletedDate);
        EasyMock.expect((Object)this.userDAO.updateUser(deletedUser)).andReturn((Object)deletedUser);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveUserResponse response = this.userService.removeUser(Integer.valueOf(1));
        RemoveUserResponse expectedResponse = new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertTrue((boolean)this.isUserDeleted(deletedUser));
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordError() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordValidator.validate("sdfkljsd;fkadfA1")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(EasyMock.eq((int)1)), EasyMock.eq((boolean)false), EasyMock.eq((boolean)false))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ChangePasswordResponse response = this.userService.changePassword("foo", "sdfkljsd;fkadfA1");
        ChangePasswordResponse expectedResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordFailedInvalidNewPassword() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.passwordValidator.validate("A1")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ChangePasswordResponse response = this.userService.changePassword("xxx", "A1");
        ChangePasswordResponse expectedResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_PASSWORDINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordFailedInvalidOldPassword() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        UserEntity userEntity = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.passwordValidator.validate("sdfkljsd;fkadfA1")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(EasyMock.eq((int)1)), EasyMock.eq((boolean)false), EasyMock.eq((boolean)false))).andReturn((Object)userEntity);
        String hashedPassword = "invalid old password";
        EasyMock.expect((Object)this.passwordHashGenerator.generate((String)EasyMock.eq((Object)"invalid old password"), (String)EasyMock.eq((Object)userEntity.getPasswordSalt()))).andReturn((Object)hashedPassword);
        PowerMock.replayAll((Object[])new Object[0]);
        ChangePasswordResponse response = this.userService.changePassword("invalid old password", "sdfkljsd;fkadfA1");
        ChangePasswordResponse expectedResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_WRONGOLDPASSWORD);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordSuccess() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        UserEntity userEntity = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.passwordValidator.validate("valid New Password 123")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(EasyMock.eq((int)1)), EasyMock.eq((boolean)false), EasyMock.eq((boolean)false))).andReturn((Object)userEntity);
        String hashedPassword = userEntity.getPassword();
        EasyMock.expect((Object)this.passwordHashGenerator.generate((String)EasyMock.eq((Object)"valid old password"), (String)EasyMock.eq((Object)userEntity.getPasswordSalt()))).andReturn((Object)hashedPassword);
        String newHashedPassword = "valid old password";
        String newSalt = "new salt";
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)newSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate((String)EasyMock.eq((Object)"valid New Password 123"), (String)EasyMock.eq((Object)newSalt))).andReturn((Object)newHashedPassword);
        Date now = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        UserEntity userEntityNew = TestDataUtils.prepareUserEntity();
        userEntityNew.setPassword(newHashedPassword);
        userEntityNew.setPasswordSalt(newSalt);
        EasyMock.expect((Object)this.userDAO.updateUser((UserEntity)EasyMock.eq((Object)userEntityNew))).andReturn((Object)userEntityNew);
        PowerMock.replayAll((Object[])new Object[0]);
        ChangePasswordResponse response = this.userService.changePassword("valid old password", "valid New Password 123");
        ChangePasswordResponse expectedResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAccountSettings() throws InvalidSessionException {
        Date addedDate = new Date();
        AccountSettings expectedResponse = new AccountSettings();
        expectedResponse.setUserId(Integer.valueOf(1));
        expectedResponse.setEmail("test@email.com");
        expectedResponse.setAddedDate(addedDate);
        expectedResponse.setMailing(Boolean.valueOf(false));
        expectedResponse.setUsingSSO(Boolean.valueOf(false));
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setEmail("test@email.com");
        user.setAddedDate(addedDate);
        user.setMailing(false);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1), false, false)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        AccountSettings response = this.userService.getSettings();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAccountSettingsForInvalidUser() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1), false, false)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        AccountSettings response = this.userService.getSettings();
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testForgotPasswordInsufficientData() {
        Assert.assertEquals((Object)new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.INSUFFICIENTDATA), (Object)this.userService.forgotPassword(null, null));
    }

    @Test
    public void testForgotPasswordIncorrectUsername() {
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.INCORRECTUSERNAME);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", "test@test.pl");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordIncorrectEmail() {
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.INCORRECTEMAIL);
        ForgotPasswordResponse response = this.userService.forgotPassword(null, "test@test.pl");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordUserUpdateError() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.ERROR);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", "test@test.pl");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordSendEmailFailure() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setFirstname("testFirstname");
        foundUser.setLastname("testLasnname");
        foundUser.setAddress("testAddress");
        foundUser.setTown("testTown");
        foundUser.setZipCode("testZipCode");
        foundUser.setState("testState");
        foundUser.setCountry("testCountry");
        foundUser.setLanguage("testLanguage");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        this.userService.setServerUrl("smart-apps.pl");
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setFirstname("testFirstname");
        updatedUser.setLastname("testLasnname");
        updatedUser.setAddress("testAddress");
        updatedUser.setTown("testTown");
        updatedUser.setZipCode("testZipCode");
        updatedUser.setState("testState");
        updatedUser.setCountry("testCountry");
        updatedUser.setLanguage("testLanguage");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        updatedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn((Object)updatedUser);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setChangePasswordCode(code);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/changePassword?code=0123456789ABCDEF");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.ERROR);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordByUsernameSuccesfully() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setFirstname("testFirstname");
        foundUser.setLastname("testLasnname");
        foundUser.setAddress("testAddress");
        foundUser.setTown("testTown");
        foundUser.setZipCode("testZipCode");
        foundUser.setState("testState");
        foundUser.setCountry("testCountry");
        foundUser.setLanguage("testLanguage");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        this.userService.setServerUrl("smart-apps.pl");
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setFirstname("testFirstname");
        updatedUser.setLastname("testLasnname");
        updatedUser.setAddress("testAddress");
        updatedUser.setTown("testTown");
        updatedUser.setZipCode("testZipCode");
        updatedUser.setState("testState");
        updatedUser.setCountry("testCountry");
        updatedUser.setLanguage("testLanguage");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        updatedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn((Object)updatedUser);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setChangePasswordCode(code);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/changePassword?code=0123456789ABCDEF");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.SUCCESS);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordSuccesfullyWithServerAddresWithoutProtocol() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setFirstname("testFirstname");
        foundUser.setLastname("testLasnname");
        foundUser.setAddress("testAddress");
        foundUser.setTown("testTown");
        foundUser.setZipCode("testZipCode");
        foundUser.setState("testState");
        foundUser.setCountry("testCountry");
        foundUser.setLanguage("testLanguage");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        this.userService.setServerUrl("smart-apps.pl");
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setFirstname("testFirstname");
        updatedUser.setLastname("testLasnname");
        updatedUser.setAddress("testAddress");
        updatedUser.setTown("testTown");
        updatedUser.setZipCode("testZipCode");
        updatedUser.setState("testState");
        updatedUser.setCountry("testCountry");
        updatedUser.setLanguage("testLanguage");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        updatedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn((Object)updatedUser);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setChangePasswordCode(code);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/changePassword?code=0123456789ABCDEF");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.SUCCESS);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordSuccesfullyWithServerAddresWithHttpProtocol() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setFirstname("testFirstname");
        foundUser.setLastname("testLasnname");
        foundUser.setAddress("testAddress");
        foundUser.setTown("testTown");
        foundUser.setZipCode("testZipCode");
        foundUser.setState("testState");
        foundUser.setCountry("testCountry");
        foundUser.setLanguage("testLanguage");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        this.userService.setServerUrl("http://smart-apps.pl");
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setFirstname("testFirstname");
        updatedUser.setLastname("testLasnname");
        updatedUser.setAddress("testAddress");
        updatedUser.setTown("testTown");
        updatedUser.setZipCode("testZipCode");
        updatedUser.setState("testState");
        updatedUser.setCountry("testCountry");
        updatedUser.setLanguage("testLanguage");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        updatedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn((Object)updatedUser);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setChangePasswordCode(code);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/changePassword?code=0123456789ABCDEF");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.SUCCESS);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordSuccesfullyWithServerAddresWithHttpsProtocol() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setFirstname("testFirstname");
        foundUser.setLastname("testLasnname");
        foundUser.setAddress("testAddress");
        foundUser.setTown("testTown");
        foundUser.setZipCode("testZipCode");
        foundUser.setState("testState");
        foundUser.setCountry("testCountry");
        foundUser.setLanguage("testLanguage");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        this.userService.setServerUrl("https://smart-apps.pl");
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setFirstname("testFirstname");
        updatedUser.setLastname("testLasnname");
        updatedUser.setAddress("testAddress");
        updatedUser.setTown("testTown");
        updatedUser.setZipCode("testZipCode");
        updatedUser.setState("testState");
        updatedUser.setCountry("testCountry");
        updatedUser.setLanguage("testLanguage");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        updatedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn((Object)updatedUser);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setChangePasswordCode(code);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "https://smart-apps.pl/user/changePassword?code=0123456789ABCDEF");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.SUCCESS);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordByUsernameSuccesfullWithIssueWithCodeGeneration() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setFirstname("testFirstname");
        foundUser.setLastname("testLasnname");
        foundUser.setAddress("testAddress");
        foundUser.setTown("testTown");
        foundUser.setZipCode("testZipCode");
        foundUser.setState("testState");
        foundUser.setCountry("testCountry");
        foundUser.setLanguage("testLanguage");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)foundUser);
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)"codeUser");
        UserEntity foundUserByCode = new UserEntity();
        foundUserByCode.setId(Integer.valueOf(1));
        foundUserByCode.setUsername("codeUser");
        foundUserByCode.setEmail("codeuser@test.pl");
        foundUserByCode.setPasswordSalt("salt");
        foundUserByCode.setPassword("password");
        foundUserByCode.setChangePasswordCode("codeUser");
        foundUserByCode.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode("codeUser")).andReturn((Object)foundUserByCode);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        this.userService.setServerUrl("smart-apps.pl");
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setFirstname("testFirstname");
        updatedUser.setLastname("testLasnname");
        updatedUser.setAddress("testAddress");
        updatedUser.setTown("testTown");
        updatedUser.setZipCode("testZipCode");
        updatedUser.setState("testState");
        updatedUser.setCountry("testCountry");
        updatedUser.setLanguage("testLanguage");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        updatedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn((Object)updatedUser);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setChangePasswordCode(code);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/changePassword?code=0123456789ABCDEF");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.SUCCESS);
        ForgotPasswordResponse response = this.userService.forgotPassword("test", null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testForgotPasswordByEmailAddressSuccesfull() {
        UserEntity foundUser = new UserEntity();
        foundUser.setId(Integer.valueOf(1));
        foundUser.setUsername("test");
        foundUser.setEmail("test@test.pl");
        foundUser.setFirstname("testFirstname");
        foundUser.setLastname("testLasnname");
        foundUser.setAddress("testAddress");
        foundUser.setTown("testTown");
        foundUser.setZipCode("testZipCode");
        foundUser.setState("testState");
        foundUser.setCountry("testCountry");
        foundUser.setLanguage("testLanguage");
        foundUser.setPasswordSalt("salt");
        foundUser.setPassword("password");
        foundUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("test@test.pl")).andReturn((Object)foundUser);
        String code = "0123456789ABCDEF";
        EasyMock.expect((Object)this.passwordGenerator.generate(16)).andReturn((Object)code);
        EasyMock.expect((Object)this.userDAO.findUserByChangePasswordCode(code)).andReturn(null);
        this.userService.setServerUrl("smart-apps.pl");
        UserEntity updatedUser = new UserEntity();
        updatedUser.setId(Integer.valueOf(1));
        updatedUser.setUsername("test");
        updatedUser.setEmail("test@test.pl");
        updatedUser.setFirstname("testFirstname");
        updatedUser.setLastname("testLasnname");
        updatedUser.setAddress("testAddress");
        updatedUser.setTown("testTown");
        updatedUser.setZipCode("testZipCode");
        updatedUser.setState("testState");
        updatedUser.setCountry("testCountry");
        updatedUser.setLanguage("testLanguage");
        updatedUser.setPasswordSalt("salt");
        updatedUser.setPassword("password");
        updatedUser.setChangePasswordCode(code);
        updatedUser.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.updateUser(updatedUser)).andReturn((Object)updatedUser);
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setFirstname("testFirstname");
        user.setLastname("testLasnname");
        user.setAddress("testAddress");
        user.setTown("testTown");
        user.setZipCode("testZipCode");
        user.setState("testState");
        user.setCountry("testCountry");
        user.setLanguage("testLanguage");
        user.setChangePasswordCode(code);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://smart-apps.pl/user/changePassword?code=0123456789ABCDEF");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ForgotPasswordResponse expectedResponse = new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.SUCCESS);
        ForgotPasswordResponse response = this.userService.forgotPassword(null, "test@test.pl");
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testChangePasswordAsAdminFailureUserNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.passwordValidator.validate("newPassword5")).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(EasyMock.eq((int)1)), EasyMock.eq((boolean)false), EasyMock.eq((boolean)false))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ChangePasswordResponse response = this.userService.changePasswordAsAdmin(Integer.valueOf(1), "newPassword5");
        ChangePasswordResponse expectedResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_NOTFOUNDUSER);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordAsAdminFailedInvalidNewPassword() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.passwordValidator.validate("A1")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ChangePasswordResponse response = this.userService.changePasswordAsAdmin(Integer.valueOf(1), "A1");
        ChangePasswordResponse expectedResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_PASSWORDINVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePasswordAsAdminSuccess() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.passwordValidator.validate("valid New Password 123")).andReturn((Object)true);
        UserEntity userEntity = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(EasyMock.eq((int)1)), EasyMock.eq((boolean)false), EasyMock.eq((boolean)false))).andReturn((Object)userEntity);
        String newHashedPassword = "valid old password";
        String newSalt = "new salt";
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)newSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate((String)EasyMock.eq((Object)"valid New Password 123"), (String)EasyMock.eq((Object)newSalt))).andReturn((Object)newHashedPassword);
        Date now = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        UserEntity userEntityNew = TestDataUtils.prepareUserEntity();
        userEntityNew.setPassword(newHashedPassword);
        userEntityNew.setPasswordSalt(newSalt);
        EasyMock.expect((Object)this.userDAO.updateUser((UserEntity)EasyMock.eq((Object)userEntityNew))).andReturn((Object)userEntityNew);
        PowerMock.replayAll((Object[])new Object[0]);
        ChangePasswordResponse response = this.userService.changePasswordAsAdmin(Integer.valueOf(1), "valid New Password 123");
        ChangePasswordResponse expectedResponse = new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.SUCCESS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testLoginAsUser() throws InvalidSessionException {
        this.userService.setAllowLoginAs(true);
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        this.authUtils.storeData("sudoUserId", (Object)1);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.userService.loginAsUser(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testLoginAsUserDisabled() throws InvalidSessionException {
        this.userService.setAllowLoginAs(false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.userService.loginAsUser(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testLogoutAsUser() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        this.authUtils.removeData("sudoUserId");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.logoutAsUser();
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAllUsersSuccesfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)15, (int)7, (int)54, (int)41);
        UserEntity entity = new UserEntity();
        entity.setAddedDate(date);
        entity.setDeleted(Integer.valueOf(0));
        entity.setDeletedDate(null);
        entity.setEmail("test@test.pl");
        entity.setId(Integer.valueOf(1));
        entity.setUsername("test");
        ArrayList<UserEntity> users = new ArrayList<UserEntity>();
        users.add(entity);
        EasyMock.expect((Object)this.userDAO.findAllUsers()).andReturn(users);
        PowerMock.replayAll((Object[])new Object[0]);
        GetUsersResponse expectedResponse = new GetUsersResponse();
        User user = new User();
        user.setAddedDate(date);
        user.setDeleted(Boolean.valueOf(false));
        user.setDeletedDate(null);
        user.setEmail("test@test.pl");
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setMailing(Boolean.valueOf(false));
        expectedResponse.status = GetUsersResponse.GetUsersStatus.SUCCESS;
        expectedResponse.users = new ArrayList();
        expectedResponse.users.add(user);
        GetUsersResponse response = this.userService.getAllUsers();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAllUsersFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.findAllUsers()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GetUsersResponse expectedResponse = new GetUsersResponse();
        expectedResponse.status = GetUsersResponse.GetUsersStatus.ERROR;
        GetUsersResponse response = this.userService.getAllUsers();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserDetailsByUserIdExcludingDeletedDevices() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date validTo = Utils.constructDate((int)2011, (int)12, (int)31);
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = new GatewayClientEntity();
        client1.setGatewayClientId(Integer.valueOf(1));
        client1.setMac("11:11:11:11:11:11");
        client1.setName("client1");
        client1.setSerialNumber("11:11:11:11:11:11");
        client1.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        client1.setDeleted(false);
        client1.setVersion("1.0");
        client1.setBuildNo(Integer.valueOf(123));
        client1.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        client1.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)10, (int)0));
        clients.add(client1);
        GatewayClientEntity client2 = new GatewayClientEntity();
        client2.setGatewayClientId(Integer.valueOf(2));
        client2.setMac("22:22:22:22:22:22");
        client2.setName("client2");
        client2.setSerialNumber("22:22:22:22:22:22");
        client2.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        client2.setDeleted(false);
        client2.setVersion("1.0");
        client2.setBuildNo(Integer.valueOf(123));
        client2.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        client2.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)10, (int)0));
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClients(Integer.valueOf(1), false)).andReturn(clients);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setCode("productCode");
        product.setName("productName");
        product.setProductfeatures(new HashSet());
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = new LanDeviceEntity();
        device1.setLanDeviceId(Integer.valueOf(1));
        device1.setName("device1");
        device1.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        device1.setMac("AA:AA:AA:AA:AA:AA");
        device1.setIpAddress("127.0.0.1");
        device1.setPort(Integer.valueOf(80));
        device1.setUsername("admin");
        device1.setPass("admin");
        device1.setVersion("1.0");
        device1.setGatewayClient(client1);
        device1.setDeleted(false);
        device1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        device1.setValidTo(validTo);
        device1.setProduct(product);
        device1.setUser(user);
        devices.add(device1);
        LanDeviceEntity device2 = new LanDeviceEntity();
        device2.setLanDeviceId(Integer.valueOf(2));
        device2.setName("device2");
        device2.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        device2.setMac("BB:BB:BB:BB:BB:BB");
        device2.setIpAddress("127.0.0.1");
        device2.setPort(Integer.valueOf(80));
        device2.setUsername("admin");
        device2.setPass("admin");
        device2.setVersion("1.0");
        device2.setGatewayClient(client2);
        device2.setDeleted(false);
        device2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        device2.setValidTo(validTo);
        device2.setProduct(product);
        device2.setUser(user);
        devices.add(device2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevices(Integer.valueOf(1), false)).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        UserDetails response = this.userService.getUserDetailsByUserId(Integer.valueOf(1), false);
        UserDetails expectedResponse = new UserDetails();
        User expectedUser = new User();
        expectedUser.setId(Integer.valueOf(1));
        expectedUser.setUsername("test");
        expectedUser.setEmail("test@test.pl");
        expectedUser.setDeleted(Boolean.valueOf(false));
        expectedUser.setMailing(Boolean.valueOf(false));
        expectedResponse.setUser(expectedUser);
        ArrayList<GatewayClient> expectedClients = new ArrayList<GatewayClient>();
        GatewayClient expectedClient1 = new GatewayClient();
        expectedClient1.setGatewayClientId(Integer.valueOf(1));
        expectedClient1.setMac("11:11:11:11:11:11");
        expectedClient1.setName("client1");
        expectedClient1.setSerialNumber("11:11:11:11:11:11");
        expectedClient1.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        expectedClient1.setDeleted(Boolean.valueOf(false));
        expectedClient1.setVersion("1.0");
        expectedClient1.setBuildNo(Integer.valueOf(123));
        expectedClient1.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        expectedClient1.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)10, (int)0));
        expectedClient1.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        expectedClient1.setPublicIpAddress("1.1.1.1");
        expectedClient1.setUpnpPort(Integer.valueOf(0));
        expectedClient1.setUpnpReason("none");
        expectedClients.add(expectedClient1);
        GatewayClient expectedClient2 = new GatewayClient();
        expectedClient2.setGatewayClientId(Integer.valueOf(2));
        expectedClient2.setMac("22:22:22:22:22:22");
        expectedClient2.setName("client2");
        expectedClient2.setSerialNumber("22:22:22:22:22:22");
        expectedClient2.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        expectedClient2.setDeleted(Boolean.valueOf(false));
        expectedClient2.setVersion("1.0");
        expectedClient2.setBuildNo(Integer.valueOf(123));
        expectedClient2.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        expectedClient2.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)10, (int)0));
        expectedClient2.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        expectedClient2.setPublicIpAddress("2.2.2.2");
        expectedClient2.setUpnpPort(Integer.valueOf(0));
        expectedClient2.setUpnpReason("none");
        expectedClients.add(expectedClient2);
        expectedResponse.setGatewayClients(expectedClients);
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setCode("productCode");
        deviceProduct.setName("productName");
        ArrayList<LanDevice> expectedDevices = new ArrayList<LanDevice>();
        LanDevice expectedDevice1 = new LanDevice();
        expectedDevice1.setLanDeviceId(Integer.valueOf(1));
        expectedDevice1.setName("device1");
        expectedDevice1.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        expectedDevice1.setMac("AA:AA:AA:AA:AA:AA");
        expectedDevice1.setIpAddress("127.0.0.1");
        expectedDevice1.setPort(Integer.valueOf(80));
        expectedDevice1.setUser("admin");
        expectedDevice1.setPass("admin");
        expectedDevice1.setVersion("1.0");
        expectedDevice1.setGatewayClient(expectedClient1);
        expectedDevice1.setDeleted(Boolean.valueOf(false));
        expectedDevice1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        expectedDevice1.setValidTo(validTo);
        expectedDevice1.setRecording(Boolean.valueOf(false));
        expectedDevice1.setHasAudioDetection(Boolean.valueOf(false));
        expectedDevice1.setHasHome(Boolean.valueOf(false));
        expectedDevice1.setHasIllumination(Boolean.valueOf(false));
        expectedDevice1.setHasLedControl(Boolean.valueOf(false));
        expectedDevice1.setHasMotionDetection(Boolean.valueOf(false));
        expectedDevice1.setHasPan(Boolean.valueOf(false));
        expectedDevice1.setHasTilt(Boolean.valueOf(false));
        expectedDevice1.setHasZoom(Boolean.valueOf(false));
        expectedDevice1.setHasMuteAudio(Boolean.valueOf(false));
        expectedDevice1.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedDevice1.setNeedsRestartAfterNetworkChangesToWireless(Boolean.valueOf(false));
        expectedDevice1.setNeedsRestartAfterNetworkChangesToEthernet(Boolean.valueOf(false));
        expectedDevice1.setHasPrivacyButtonControl(Boolean.valueOf(false));
        expectedDevice1.setLanDeviceParams(new ArrayList());
        expectedDevice1.setProduct(deviceProduct);
        expectedDevice1.setOwnerId(Integer.valueOf(1));
        expectedDevice1.setOwnerEmail("test@test.pl");
        expectedDevice1.setBelongsToCurrentUser(true);
        expectedDevice1.setShared(false);
        expectedDevices.add(expectedDevice1);
        LanDevice expectedDevice2 = new LanDevice();
        expectedDevice2.setLanDeviceId(Integer.valueOf(2));
        expectedDevice2.setName("device2");
        expectedDevice2.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        expectedDevice2.setMac("BB:BB:BB:BB:BB:BB");
        expectedDevice2.setIpAddress("127.0.0.1");
        expectedDevice2.setPort(Integer.valueOf(80));
        expectedDevice2.setUser("admin");
        expectedDevice2.setPass("admin");
        expectedDevice2.setVersion("1.0");
        expectedDevice2.setGatewayClient(expectedClient2);
        expectedDevice2.setDeleted(Boolean.valueOf(false));
        expectedDevice2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        expectedDevice2.setValidTo(validTo);
        expectedDevice2.setRecording(Boolean.valueOf(false));
        expectedDevice2.setHasAudioDetection(Boolean.valueOf(false));
        expectedDevice2.setHasHome(Boolean.valueOf(false));
        expectedDevice2.setHasIllumination(Boolean.valueOf(false));
        expectedDevice2.setHasLedControl(Boolean.valueOf(false));
        expectedDevice2.setHasMotionDetection(Boolean.valueOf(false));
        expectedDevice2.setHasPan(Boolean.valueOf(false));
        expectedDevice2.setHasTilt(Boolean.valueOf(false));
        expectedDevice2.setHasZoom(Boolean.valueOf(false));
        expectedDevice2.setHasMuteAudio(Boolean.valueOf(false));
        expectedDevice2.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedDevice2.setNeedsRestartAfterNetworkChangesToWireless(Boolean.valueOf(false));
        expectedDevice2.setNeedsRestartAfterNetworkChangesToEthernet(Boolean.valueOf(false));
        expectedDevice2.setHasPrivacyButtonControl(Boolean.valueOf(false));
        expectedDevice2.setLanDeviceParams(new ArrayList());
        expectedDevice2.setProduct(deviceProduct);
        expectedDevice2.setOwnerId(Integer.valueOf(1));
        expectedDevice2.setOwnerEmail("test@test.pl");
        expectedDevice2.setBelongsToCurrentUser(true);
        expectedDevice2.setShared(false);
        expectedDevices.add(expectedDevice2);
        expectedResponse.setLanDevices(expectedDevices);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserDetailsByUserIdIncludingDeletedDevices() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date validTo = Utils.constructDate((int)2011, (int)12, (int)31);
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setDeleted(Integer.valueOf(0));
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        GatewayClientEntity client1 = new GatewayClientEntity();
        client1.setGatewayClientId(Integer.valueOf(1));
        client1.setMac("11:11:11:11:11:11");
        client1.setName("client1");
        client1.setSerialNumber("11:11:11:11:11:11");
        client1.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        client1.setDeleted(false);
        client1.setVersion("1.0");
        client1.setBuildNo(Integer.valueOf(123));
        client1.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        client1.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)10, (int)0));
        clients.add(client1);
        GatewayClientEntity client2 = new GatewayClientEntity();
        client2.setGatewayClientId(Integer.valueOf(2));
        client2.setMac("22:22:22:22:22:22");
        client2.setName("client2");
        client2.setSerialNumber("22:22:22:22:22:22");
        client2.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        client2.setDeleted(false);
        client2.setVersion("1.0");
        client2.setBuildNo(Integer.valueOf(123));
        client2.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        client2.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)10, (int)0));
        clients.add(client2);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClients(Integer.valueOf(1), true)).andReturn(clients);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setCode("productCode");
        product.setName("productName");
        product.setProductfeatures(new HashSet());
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = new LanDeviceEntity();
        device1.setLanDeviceId(Integer.valueOf(1));
        device1.setName("device1");
        device1.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        device1.setMac("AA:AA:AA:AA:AA:AA");
        device1.setIpAddress("127.0.0.1");
        device1.setPort(Integer.valueOf(80));
        device1.setUsername("admin");
        device1.setPass("admin");
        device1.setVersion("1.0");
        device1.setGatewayClient(client1);
        device1.setDeleted(false);
        device1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        device1.setValidTo(validTo);
        device1.setProduct(product);
        device1.setUser(user);
        devices.add(device1);
        LanDeviceEntity device2 = new LanDeviceEntity();
        device2.setLanDeviceId(Integer.valueOf(2));
        device2.setName("device2");
        device2.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        device2.setMac("BB:BB:BB:BB:BB:BB");
        device2.setIpAddress("127.0.0.1");
        device2.setPort(Integer.valueOf(80));
        device2.setUsername("admin");
        device2.setPass("admin");
        device2.setVersion("1.0");
        device2.setGatewayClient(client2);
        device2.setDeleted(false);
        device2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        device2.setValidTo(validTo);
        device2.setProduct(product);
        device2.setUser(user);
        devices.add(device2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevices(Integer.valueOf(1), true)).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        UserDetails response = this.userService.getUserDetailsByUserId(Integer.valueOf(1), true);
        UserDetails expectedResponse = new UserDetails();
        User expectedUser = new User();
        expectedUser.setId(Integer.valueOf(1));
        expectedUser.setUsername("test");
        expectedUser.setEmail("test@test.pl");
        expectedUser.setDeleted(Boolean.valueOf(false));
        expectedUser.setMailing(Boolean.valueOf(false));
        expectedResponse.setUser(expectedUser);
        ArrayList<GatewayClient> expectedClients = new ArrayList<GatewayClient>();
        GatewayClient expectedClient1 = new GatewayClient();
        expectedClient1.setGatewayClientId(Integer.valueOf(1));
        expectedClient1.setMac("11:11:11:11:11:11");
        expectedClient1.setName("client1");
        expectedClient1.setSerialNumber("11:11:11:11:11:11");
        expectedClient1.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        expectedClient1.setDeleted(Boolean.valueOf(false));
        expectedClient1.setVersion("1.0");
        expectedClient1.setBuildNo(Integer.valueOf(123));
        expectedClient1.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        expectedClient1.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)10, (int)0));
        expectedClient1.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        expectedClient1.setPublicIpAddress("1.1.1.1");
        expectedClient1.setUpnpPort(Integer.valueOf(0));
        expectedClient1.setUpnpReason("none");
        expectedClients.add(expectedClient1);
        GatewayClient expectedClient2 = new GatewayClient();
        expectedClient2.setGatewayClientId(Integer.valueOf(2));
        expectedClient2.setMac("22:22:22:22:22:22");
        expectedClient2.setName("client2");
        expectedClient2.setSerialNumber("22:22:22:22:22:22");
        expectedClient2.setActivationDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        expectedClient2.setDeleted(Boolean.valueOf(false));
        expectedClient2.setVersion("1.0");
        expectedClient2.setBuildNo(Integer.valueOf(123));
        expectedClient2.setConnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        expectedClient2.setDisconnectedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)10, (int)0));
        expectedClient2.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        expectedClient2.setPublicIpAddress("2.2.2.2");
        expectedClient2.setUpnpPort(Integer.valueOf(0));
        expectedClient2.setUpnpReason("none");
        expectedClients.add(expectedClient2);
        expectedResponse.setGatewayClients(expectedClients);
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setCode("productCode");
        deviceProduct.setName("productName");
        ArrayList<LanDevice> expectedDevices = new ArrayList<LanDevice>();
        LanDevice expectedDevice1 = new LanDevice();
        expectedDevice1.setLanDeviceId(Integer.valueOf(1));
        expectedDevice1.setName("device1");
        expectedDevice1.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)10, (int)0, (int)0));
        expectedDevice1.setMac("AA:AA:AA:AA:AA:AA");
        expectedDevice1.setIpAddress("127.0.0.1");
        expectedDevice1.setPort(Integer.valueOf(80));
        expectedDevice1.setUser("admin");
        expectedDevice1.setPass("admin");
        expectedDevice1.setVersion("1.0");
        expectedDevice1.setGatewayClient(expectedClient1);
        expectedDevice1.setDeleted(Boolean.valueOf(false));
        expectedDevice1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        expectedDevice1.setValidTo(validTo);
        expectedDevice1.setRecording(Boolean.valueOf(false));
        expectedDevice1.setHasAudioDetection(Boolean.valueOf(false));
        expectedDevice1.setHasHome(Boolean.valueOf(false));
        expectedDevice1.setHasIllumination(Boolean.valueOf(false));
        expectedDevice1.setHasLedControl(Boolean.valueOf(false));
        expectedDevice1.setHasMotionDetection(Boolean.valueOf(false));
        expectedDevice1.setHasPan(Boolean.valueOf(false));
        expectedDevice1.setHasTilt(Boolean.valueOf(false));
        expectedDevice1.setHasZoom(Boolean.valueOf(false));
        expectedDevice1.setHasMuteAudio(Boolean.valueOf(false));
        expectedDevice1.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedDevice1.setNeedsRestartAfterNetworkChangesToWireless(Boolean.valueOf(false));
        expectedDevice1.setNeedsRestartAfterNetworkChangesToEthernet(Boolean.valueOf(false));
        expectedDevice1.setHasPrivacyButtonControl(Boolean.valueOf(false));
        expectedDevice1.setLanDeviceParams(new ArrayList());
        expectedDevice1.setProduct(deviceProduct);
        expectedDevice1.setOwnerId(Integer.valueOf(1));
        expectedDevice1.setOwnerEmail("test@test.pl");
        expectedDevice1.setBelongsToCurrentUser(true);
        expectedDevice1.setShared(false);
        expectedDevices.add(expectedDevice1);
        LanDevice expectedDevice2 = new LanDevice();
        expectedDevice2.setLanDeviceId(Integer.valueOf(2));
        expectedDevice2.setName("device2");
        expectedDevice2.setAddedDate(Utils.constructDate((int)2011, (int)11, (int)21, (int)11, (int)0, (int)0));
        expectedDevice2.setMac("BB:BB:BB:BB:BB:BB");
        expectedDevice2.setIpAddress("127.0.0.1");
        expectedDevice2.setPort(Integer.valueOf(80));
        expectedDevice2.setUser("admin");
        expectedDevice2.setPass("admin");
        expectedDevice2.setVersion("1.0");
        expectedDevice2.setGatewayClient(expectedClient2);
        expectedDevice2.setDeleted(Boolean.valueOf(false));
        expectedDevice2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        expectedDevice2.setValidTo(validTo);
        expectedDevice2.setRecording(Boolean.valueOf(false));
        expectedDevice2.setHasAudioDetection(Boolean.valueOf(false));
        expectedDevice2.setHasHome(Boolean.valueOf(false));
        expectedDevice2.setHasIllumination(Boolean.valueOf(false));
        expectedDevice2.setHasLedControl(Boolean.valueOf(false));
        expectedDevice2.setHasMotionDetection(Boolean.valueOf(false));
        expectedDevice2.setHasPan(Boolean.valueOf(false));
        expectedDevice2.setHasTilt(Boolean.valueOf(false));
        expectedDevice2.setHasZoom(Boolean.valueOf(false));
        expectedDevice2.setHasMuteAudio(Boolean.valueOf(false));
        expectedDevice2.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedDevice2.setNeedsRestartAfterNetworkChangesToWireless(Boolean.valueOf(false));
        expectedDevice2.setNeedsRestartAfterNetworkChangesToEthernet(Boolean.valueOf(false));
        expectedDevice2.setHasPrivacyButtonControl(Boolean.valueOf(false));
        expectedDevice2.setLanDeviceParams(new ArrayList());
        expectedDevice2.setProduct(deviceProduct);
        expectedDevice2.setOwnerId(Integer.valueOf(1));
        expectedDevice2.setOwnerEmail("test@test.pl");
        expectedDevice2.setBelongsToCurrentUser(true);
        expectedDevice2.setShared(false);
        expectedDevices.add(expectedDevice2);
        expectedResponse.setLanDevices(expectedDevices);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testFindUsersByNameExcludingDeleted() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<UserEntity> users = new ArrayList<UserEntity>();
        users.add(this.buildUser(Integer.valueOf(1), "username1", "firstname1", "lastname1", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(2), "username2", "firstname2", "lastname2", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(3), "username3", "firstname3", "lastname3", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(4), "username4", "firstname4", "lastname4", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(5), "username5", "firstname5", "lastname5", Integer.valueOf(0)));
        EasyMock.expect((Object)this.userDAO.findUsersByName("test", false)).andReturn(users);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.userService.findUsersByName("test", false);
        ArrayList<UserNameId> expectedResponse = new ArrayList<UserNameId>();
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(1), "username1", "firstname1", "lastname1", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(2), "username2", "firstname2", "lastname2", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(3), "username3", "firstname3", "lastname3", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(4), "username4", "firstname4", "lastname4", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(5), "username5", "firstname5", "lastname5", false));
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testFindUsersByNameIncludingDeleted() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<UserEntity> users = new ArrayList<UserEntity>();
        users.add(this.buildUser(Integer.valueOf(1), "username1", "firstname1", "lastname1", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(2), "username2", "firstname2", "lastname2", Integer.valueOf(1)));
        users.add(this.buildUser(Integer.valueOf(3), "username3", "firstname3", "lastname3", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(4), "username4", "firstname4", "lastname4", Integer.valueOf(1)));
        users.add(this.buildUser(Integer.valueOf(5), "username5", "firstname5", "lastname5", Integer.valueOf(0)));
        EasyMock.expect((Object)this.userDAO.findUsersByName("test", true)).andReturn(users);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.userService.findUsersByName("test", true);
        ArrayList<UserNameId> expectedResponse = new ArrayList<UserNameId>();
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(1), "username1", "firstname1", "lastname1", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(2), "username2", "firstname2", "lastname2", true));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(3), "username3", "firstname3", "lastname3", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(4), "username4", "firstname4", "lastname4", true));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(5), "username5", "firstname5", "lastname5", false));
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testFindAllUsersWithoutDeleted() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<UserEntity> users = new ArrayList<UserEntity>();
        users.add(this.buildUser(Integer.valueOf(1), "username1", "firstname1", "lastname1", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(2), "username2", "firstname2", "lastname2", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(3), "username3", "firstname3", "lastname3", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(4), "username4", "firstname4", "lastname4", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(5), "username5", "firstname5", "lastname5", Integer.valueOf(0)));
        EasyMock.expect((Object)this.userDAO.findUsers(false)).andReturn(users);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.userService.findAllUsers(false);
        ArrayList<UserNameId> expectedResponse = new ArrayList<UserNameId>();
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(1), "username1", "firstname1", "lastname1", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(2), "username2", "firstname2", "lastname2", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(3), "username3", "firstname3", "lastname3", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(4), "username4", "firstname4", "lastname4", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(5), "username5", "firstname5", "lastname5", false));
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testFindAllUsersWithDeleted() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<UserEntity> users = new ArrayList<UserEntity>();
        users.add(this.buildUser(Integer.valueOf(1), "username1", "firstname1", "lastname1", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(2), "username2", "firstname2", "lastname2", Integer.valueOf(1)));
        users.add(this.buildUser(Integer.valueOf(3), "username3", "firstname3", "lastname3", Integer.valueOf(0)));
        users.add(this.buildUser(Integer.valueOf(4), "username4", "firstname4", "lastname4", Integer.valueOf(1)));
        users.add(this.buildUser(Integer.valueOf(5), "username5", "firstname5", "lastname5", Integer.valueOf(0)));
        EasyMock.expect((Object)this.userDAO.findUsers(true)).andReturn(users);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.userService.findAllUsers(true);
        ArrayList<UserNameId> expectedResponse = new ArrayList<UserNameId>();
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(1), "username1", "firstname1", "lastname1", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(2), "username2", "firstname2", "lastname2", true));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(3), "username3", "firstname3", "lastname3", false));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(4), "username4", "firstname4", "lastname4", true));
        expectedResponse.add(this.buildUserNameId(Integer.valueOf(5), "username5", "firstname5", "lastname5", false));
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testResendActivationEmailSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        this.userService.setServerUrl("http://test");
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setActivationCode("test1234");
        user.setEmail("test@test.pl");
        user.setDeleted(Integer.valueOf(0));
        user.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://test/user/activateAccount?code=test1234_000001");
        User userDto = new User();
        userDto.setId(Integer.valueOf(1));
        userDto.setActivationCode("test1234");
        userDto.setEmail("test@test.pl");
        userDto.setDeleted(Boolean.valueOf(false));
        userDto.setMailing(Boolean.valueOf(false));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(userDto, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendActivationCodeStatus.SUCCESS, (Object)this.userService.resendActivationCode(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendActivationEmailFailureSendEmail() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        this.userService.setServerUrl("http://test");
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setActivationCode("test1234");
        user.setEmail("test@test.pl");
        user.setDeleted(Integer.valueOf(0));
        user.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        EasyMock.expect((Object)this.emailValidator.validate("test@test.pl")).andReturn((Object)true);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", "http://test/user/activateAccount?code=test1234_000001");
        User userDto = new User();
        userDto.setId(Integer.valueOf(1));
        userDto.setActivationCode("test1234");
        userDto.setEmail("test@test.pl");
        userDto.setDeleted(Boolean.valueOf(false));
        userDto.setMailing(Boolean.valueOf(false));
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(userDto, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendActivationCodeStatus.FAILED_EMAILPROBLEM, (Object)this.userService.resendActivationCode(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendActivationEmailFailureInvalidEmailAddress() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setActivationCode("test1234");
        user.setEmail("testtest.pl");
        user.setDeleted(Integer.valueOf(0));
        user.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        EasyMock.expect((Object)this.emailValidator.validate("testtest.pl")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendActivationCodeStatus.FAILED_INVALIDEMAIL, (Object)this.userService.resendActivationCode(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendActivationEmailFailureNullEmailAddress() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setActivationCode("test1234");
        user.setEmail(null);
        user.setDeleted(Integer.valueOf(0));
        user.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendActivationCodeStatus.FAILED_INVALIDEMAIL, (Object)this.userService.resendActivationCode(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendActivationEmailFailureUserAlreadyActivated() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setActivationCode(null);
        user.setEmail(null);
        user.setDeleted(Integer.valueOf(0));
        user.setMailing(false);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendActivationCodeStatus.FAILED_USERALREADYACTIVATED, (Object)this.userService.resendActivationCode(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendActivationEmailFailureUserNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendActivationCodeStatus.FAILED_USERNOTFOUND, (Object)this.userService.resendActivationCode(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendActivationEmailINvalidUserId() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendActivationCodeStatus.FAILED_INVALIDUSERID, (Object)this.userService.resendActivationCode(null));
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateSessionSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        UserEntity user = new UserEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)user);
        EasyMock.expect((Object)this.authUtils.createSession(user)).andReturn((Object)"sessionId");
        Date subscriptionValidTo = Utils.constructDate((int)2011, (int)12, (int)31);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSessionResponse expectedResponse = new CreateSessionResponse();
        expectedResponse.setStatus(CreateSessionResponse.CreateSessionStatus.SUCCESS);
        expectedResponse.setLoggedIn(true);
        expectedResponse.setSessionId("sessionId");
        expectedResponse.setSubscriptionValidTo(subscriptionValidTo);
        CreateSessionResponse response = this.userService.createSession("test");
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateSessionFailureNullSession() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        UserEntity user = new UserEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn((Object)user);
        EasyMock.expect((Object)this.authUtils.createSession(user)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSessionResponse expectedResponse = new CreateSessionResponse();
        expectedResponse.setStatus(CreateSessionResponse.CreateSessionStatus.ERROR);
        CreateSessionResponse response = this.userService.createSession("test");
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateSessionFailureUserNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.userDAO.findUserByName("test")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSessionResponse expectedResponse = new CreateSessionResponse();
        expectedResponse.setStatus(CreateSessionResponse.CreateSessionStatus.FAILED_USERNOTFOUND);
        CreateSessionResponse response = this.userService.createSession("test");
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateSessionFailureEmptyUsername() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSessionResponse expectedResponse = new CreateSessionResponse();
        expectedResponse.setStatus(CreateSessionResponse.CreateSessionStatus.FAILED_INVALIDUSERNAME);
        CreateSessionResponse response = this.userService.createSession("");
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCreateSessionFailureNullUsername() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        PowerMock.replayAll((Object[])new Object[0]);
        CreateSessionResponse expectedResponse = new CreateSessionResponse();
        expectedResponse.setStatus(CreateSessionResponse.CreateSessionStatus.FAILED_INVALIDUSERNAME);
        CreateSessionResponse response = this.userService.createSession(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private UserEntity buildUser(Integer userId, String username, String firstname, String lastname, Integer deleted) {
        UserEntity user = new UserEntity();
        user.setId(userId);
        user.setUsername(username);
        user.setFirstname(firstname);
        user.setLastname(lastname);
        user.setDeleted(deleted);
        return user;
    }

    private UserNameId buildUserNameId(Integer userId, String username, String firstname, String lastname, boolean deleted) {
        UserNameId user = new UserNameId();
        user.setUserId(userId);
        user.setUsername(username);
        user.setFirstName(firstname);
        user.setLastName(lastname);
        user.setDeleted(Boolean.valueOf(deleted));
        return user;
    }

    @After
    public void tearDown() {
        PowerMock.resetAll((Object[])new Object[0]);
        this.userService = null;
        this.userDAO = null;
        this.authUtils = null;
        this.subject = null;
        this.passwordHashGenerator = null;
        this.passwordGenerator = null;
    }
}

