/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.service.impl.UserServiceImpl;
import pl.smartapps.restserver.service.impl.UserServiceImplInternal;
import pl.smartapps.restserver.util.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserServiceImpl.class, Utils.class})
public class UserServiceImplAssignIndexTests
extends UserServiceImplInternal {
    @Test
    public void testAssignIndexNotFoundAnyAccounts() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        String firstname = "testFirstname";
        EasyMock.expect((Object)user.getFirstname()).andReturn((Object)firstname);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device1);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac)).andReturn(devices);
        UserEntity user1 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device1.getUser()).andReturn((Object)user1);
        EasyMock.expect((Object)user1.getFirstname()).andReturn((Object)"firstname1");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testAssignIndexFoundOnlyOneAccountForFirstname() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        String firstname = "testFirstname";
        EasyMock.expect((Object)user.getFirstname()).andReturn((Object)firstname);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device1);
        LanDeviceEntity device2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device2);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac)).andReturn(devices);
        UserEntity user1 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device1.getUser()).andReturn((Object)user1);
        EasyMock.expect((Object)user1.getFirstname()).andReturn((Object)"firstname1");
        UserEntity user2 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device2.getUser()).andReturn((Object)user2).times(2);
        EasyMock.expect((Object)user2.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user2.getLastname()).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testAssignIndex2WithAscendingOrder() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        String firstname = "testFirstname";
        EasyMock.expect((Object)user.getFirstname()).andReturn((Object)firstname);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device1);
        LanDeviceEntity device2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device2);
        LanDeviceEntity device3 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device3);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac)).andReturn(devices);
        UserEntity user1 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device1.getUser()).andReturn((Object)user1);
        EasyMock.expect((Object)user1.getFirstname()).andReturn((Object)"firstname1");
        UserEntity user2 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device2.getUser()).andReturn((Object)user2).times(2);
        EasyMock.expect((Object)user2.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user2.getLastname()).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        UserEntity user3 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device3.getUser()).andReturn((Object)user3).times(2);
        EasyMock.expect((Object)user3.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user3.getLastname()).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        user.setLastname("#2");
        EasyMock.expect((Object)user.getLastname()).andReturn((Object)"#2");
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testAssignIndex2DescendingOrder() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        String firstname = "testFirstname";
        EasyMock.expect((Object)user.getFirstname()).andReturn((Object)firstname);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device1);
        LanDeviceEntity device2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device2);
        LanDeviceEntity device3 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device3);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac)).andReturn(devices);
        UserEntity user1 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device1.getUser()).andReturn((Object)user1);
        EasyMock.expect((Object)user1.getFirstname()).andReturn((Object)"firstname1");
        UserEntity user3 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device3.getUser()).andReturn((Object)user3).times(2);
        EasyMock.expect((Object)user3.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user3.getLastname()).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        UserEntity user2 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device2.getUser()).andReturn((Object)user2).times(2);
        EasyMock.expect((Object)user2.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user2.getLastname()).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        user.setLastname("#2");
        EasyMock.expect((Object)user.getLastname()).andReturn((Object)"#2");
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testAssignIndex3() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        String firstname = "testFirstname";
        EasyMock.expect((Object)user.getFirstname()).andReturn((Object)firstname);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device1);
        LanDeviceEntity device2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device2);
        LanDeviceEntity device3 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device3);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac)).andReturn(devices);
        UserEntity user1 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device1.getUser()).andReturn((Object)user1);
        EasyMock.expect((Object)user1.getFirstname()).andReturn((Object)"firstname1");
        UserEntity user2 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device2.getUser()).andReturn((Object)user2).times(2);
        EasyMock.expect((Object)user2.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user2.getLastname()).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        UserEntity user3 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device3.getUser()).andReturn((Object)user3).times(2);
        EasyMock.expect((Object)user3.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user3.getLastname()).andReturn((Object)"#2");
        EasyMock.expect((Object)Utils.isBlank((String)"#2")).andReturn((Object)false);
        user.setLastname("#3");
        EasyMock.expect((Object)user.getLastname()).andReturn((Object)"#2");
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testAssignIndexFailedStoreUser() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        String firstname = "testFirstname";
        EasyMock.expect((Object)user.getFirstname()).andReturn((Object)firstname);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device1);
        LanDeviceEntity device2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device2);
        LanDeviceEntity device3 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        devices.add(device3);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac)).andReturn(devices);
        UserEntity user1 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device1.getUser()).andReturn((Object)user1);
        EasyMock.expect((Object)user1.getFirstname()).andReturn((Object)"firstname1");
        UserEntity user2 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device2.getUser()).andReturn((Object)user2).times(2);
        EasyMock.expect((Object)user2.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user2.getLastname()).andReturn(null);
        EasyMock.expect((Object)Utils.isBlank(null)).andReturn((Object)true);
        UserEntity user3 = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device3.getUser()).andReturn((Object)user3).times(2);
        EasyMock.expect((Object)user3.getFirstname()).andReturn((Object)firstname);
        EasyMock.expect((Object)user3.getLastname()).andReturn((Object)"#2");
        EasyMock.expect((Object)Utils.isBlank((String)"#2")).andReturn((Object)false);
        user.setLastname("#3");
        EasyMock.expect((Object)user.getLastname()).andReturn((Object)"#2").times(2);
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testAssignIndexUserDeleted() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testAssignIndexNotFoundUser() {
        Integer userId = 1;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAssignIndexBlankMac() {
        Integer userId = 1;
        String mac = "";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }

    @Test(expected=NullPointerException.class)
    public void testAssignIndexNullUserId() {
        Integer userId = null;
        String mac = "testMac";
        EasyMock.expect((Object)Utils.isBlank((String)mac)).andReturn((Object)false);
        EasyMock.expect((Object)this.userDAO.findUserById(userId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.assignIndex(userId, mac);
        PowerMock.verifyAll();
    }
}

