/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.hm.WebViewer.shared.model.AccountSettings;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationData;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationStatus;
import pl.smartapps.hm.WebViewer.shared.model.RegisterResponse;
import pl.smartapps.hm.WebViewer.shared.model.ResendActivationCodeStatus;
import pl.smartapps.hm.WebViewer.shared.model.SendActivationCodeStatus;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.hm.WebViewer.shared.model.UserDetails;
import pl.smartapps.hm.WebViewer.shared.model.UserNameId;
import pl.smartapps.hm.WebViewer.shared.model.VerifyPasswordStatus;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.ProductDAO;
import pl.smartapps.restserver.db.dao.ShareDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ShareEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.AuthenticateResponse;
import pl.smartapps.restserver.rest.response.ChangePasswordResponse;
import pl.smartapps.restserver.rest.response.CreateSessionResponse;
import pl.smartapps.restserver.rest.response.ForgotPasswordResponse;
import pl.smartapps.restserver.rest.response.GetUsersResponse;
import pl.smartapps.restserver.rest.response.LogoutResponse;
import pl.smartapps.restserver.rest.response.NewChangePasswordReponse;
import pl.smartapps.restserver.rest.response.RemoveUserResponse;
import pl.smartapps.restserver.rest.response.SaveResponse;
import pl.smartapps.restserver.rest.response.UpdateAccountSettingsResponse;
import pl.smartapps.restserver.rest.security.PasswordGenerator;
import pl.smartapps.restserver.rest.security.PasswordHashGenerator;
import pl.smartapps.restserver.rest.validator.EmailValidator;
import pl.smartapps.restserver.rest.validator.NotEmptyValidator;
import pl.smartapps.restserver.rest.validator.PasswordValidator;
import pl.smartapps.restserver.rest.validator.UsernameValidator;
import pl.smartapps.restserver.service.ChangePasswordException;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.UserService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.sso.SsoProvider;
import pl.smartapps.restserver.sso.SsoProviderException;
import pl.smartapps.restserver.sso.SsoProviderFactory;
import pl.smartapps.restserver.sso.SsoUser;
import pl.smartapps.restserver.util.ExceptionsTrigger;
import pl.smartapps.restserver.util.Utils;

@Service
public class UserServiceImpl
implements UserService {
    private static Logger log = Logger.getLogger(UserServiceImpl.class);
    private PasswordHashGenerator passwordHashGenerator;
    private UserDAO userDAO;
    private AuthenticationUtils authUtils;
    private PasswordGenerator passwordGenerator;
    private EmailNotificationService emailNotificationService;
    private GatewayDeviceConnectionService gatewayDeviceConnection;
    private DeviceDriverFactory deviceDriverFactory;
    private ProductManagementService productManagementService;
    private String serverUrl;
    private ProductDAO productDAO;
    private GatewayClientDAO gatewayClientDAO;
    private LanDeviceDAO lanDeviceDAO;
    private EmailValidator emailValidator;
    private UsernameValidator usernameValidator;
    private PasswordValidator passwordValidator;
    private NotEmptyValidator notEmptyValidator;
    private SystemSupport systemSupport;
    private ParameterService parameterService;
    private ShareDAO shareDAO;
    private boolean allowLoginAs;
    private SsoProviderFactory ssoProviderFactory;

    @Autowired
    @Required
    public void setPasswordHashGenerator(PasswordHashGenerator passwordHashGenerator) {
        this.passwordHashGenerator = passwordHashGenerator;
    }

    @Autowired
    @Required
    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setPasswordGenerator(PasswordGenerator passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    @Autowired
    @Required
    public void setEmailNotificationService(EmailNotificationService emailNotificationService) {
        this.emailNotificationService = emailNotificationService;
    }

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnectionService gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    @Autowired
    @Required
    public void setProductManagementService(ProductManagementService productManagementService) {
        this.productManagementService = productManagementService;
    }

    @Value(value="${lanDevice.serverUrl}")
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Autowired
    @Required
    public void setProductDAO(ProductDAO productDAO) {
        this.productDAO = productDAO;
    }

    @Autowired
    @Required
    public void setGatewayClientDAO(GatewayClientDAO gatewayClientDAO) {
        this.gatewayClientDAO = gatewayClientDAO;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setEmailValidator(EmailValidator emailValidator) {
        this.emailValidator = emailValidator;
    }

    @Autowired
    @Required
    public void setUsernameValidator(UsernameValidator usernameValidator) {
        this.usernameValidator = usernameValidator;
    }

    @Autowired
    @Required
    public void setPasswordValidator(PasswordValidator passwordValidator) {
        this.passwordValidator = passwordValidator;
    }

    @Autowired
    @Required
    public void setNotEmptyValidator(NotEmptyValidator notEmptyValidator) {
        this.notEmptyValidator = notEmptyValidator;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setShareDAO(ShareDAO shareDAO) {
        this.shareDAO = shareDAO;
    }

    @Value(value="${security.allowloginas:false}")
    public void setAllowLoginAs(boolean allowLoginAs) {
        this.allowLoginAs = allowLoginAs;
    }

    @Transactional
    public RegisterResponse registerUser(User user, String captchaText) {
        HashMap placeholders;
        RegisterResponse.ActivationStatus activationStatus;
        log.trace((Object)("start registerUser(user=" + user + ", captchaText=" + captchaText + ")"));
        if (!(this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION) || this.isNoCaptcha() || this.isCorrectCaptcha(captchaText))) {
            return new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_CAPTCHAINVALID);
        }
        RegisterResponse.RegisterStatus validateResult = this.validateUser(user);
        if (validateResult != RegisterResponse.RegisterStatus.OK) {
            return new RegisterResponse(validateResult);
        }
        UserEntity newUser = new UserEntity();
        newUser.setUsername(user.getUsername());
        newUser.setFirstname(user.getFirstname() != null ? user.getFirstname() : "");
        newUser.setLastname(user.getLastname() != null ? user.getLastname() : "");
        newUser.setAddress(user.getAddress() != null ? user.getAddress() : "");
        newUser.setTown(user.getTown() != null ? user.getTown() : "");
        newUser.setZipCode(user.getZipCode() != null ? user.getZipCode() : "");
        newUser.setState(user.getState() != null ? user.getState() : "");
        newUser.setCountry(user.getCountry() != null ? user.getCountry() : "");
        newUser.setPhoneNumber(user.getPhoneNumber() != null ? user.getPhoneNumber() : "");
        newUser.setLanguage(user.getLanguage() != null ? user.getLanguage() : "");
        newUser.setMailing(user.getMailing() != null ? user.getMailing() : false);
        newUser.setDeleted(Integer.valueOf(0));
        String salt = this.passwordHashGenerator.getSalt();
        String hashedPassword = this.passwordHashGenerator.generate(user.getPassword(), salt);
        newUser.setPassword(hashedPassword);
        newUser.setEmail(user.getEmail());
        newUser.setPasswordSalt(salt);
        newUser.setPasswordCreationDate(this.systemSupport.getCurrentDate());
        newUser.setAddedDate(new Date());
        if (this.isNeedToConfirmation(user)) {
            newUser.setActivationCode(this.generateUniqueActivationCode());
        }
        ProductEntity defaultProduct = this.getDefaultProduct();
        newUser.setProduct(defaultProduct);
        UserEntity savedUser = this.userDAO.createUser(newUser);
        this.productManagementService.logUserproduct(savedUser.getId(), defaultProduct.getProductId());
        if (savedUser == null || savedUser.getId() == null) {
            return new RegisterResponse(RegisterResponse.RegisterStatus.ERROR);
        }
        if (this.isSendEmail()) {
            HashMap<String, String> placeholders2;
            if (this.isNeedToConfirmation(user)) {
                placeholders2 = new HashMap<String, String>();
                placeholders2.put("%LINK%", this.prepareActivationLink(newUser.getActivationCode(), savedUser.getId()));
                if (!this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders2, null)) {
                    log.error((Object)("Failed to send activaton code for user with userId=" + user.getId() + "."));
                    return new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_EMAILPROBLEM, RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED);
                }
            } else {
                placeholders2 = new HashMap();
                if (!this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.WELCOME, placeholders2, null)) {
                    log.error((Object)("Failed to send welcome email for user with userId=" + user.getId() + "."));
                    return new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_EMAILPROBLEM, RegisterResponse.ActivationStatus.ALREADY_ACTIVE);
                }
            }
        }
        RegisterResponse.ActivationStatus activationStatus2 = !this.isNeedToConfirmation(user) ? RegisterResponse.ActivationStatus.ALREADY_ACTIVE : (activationStatus = this.isSendEmail() ? RegisterResponse.ActivationStatus.CONFIRMATION_NEEDED : RegisterResponse.ActivationStatus.ADMIN_ACTIVATION_NEEDED);
        if (this.isNeedToNotification(user) && !this.emailNotificationService.sendEmail(user, EmailNotificationService.EmailCode.NEW_ACCOUNT_NOTIFICATION, placeholders = new HashMap(), null)) {
            log.error((Object)("Failed to send notification for user with userId=" + user.getId() + "."));
            return new RegisterResponse(RegisterResponse.RegisterStatus.FAILED_EMAILPROBLEM, activationStatus);
        }
        this.updateShares(savedUser);
        log.info((Object)("User " + savedUser.getUsername() + "/" + savedUser.getEmail() + " has been registered."));
        return new RegisterResponse(RegisterResponse.RegisterStatus.OK, activationStatus);
    }

    private boolean isNoCaptcha() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CAPTCHA);
    }

    private boolean isNeedToConfirmation(User user) {
        boolean hasIntegrationRole = this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION);
        return hasIntegrationRole && user.getConfirmation() != null && user.getConfirmation().equals(Boolean.TRUE) || !hasIntegrationRole && !this.isNoConfirmation();
    }

    private boolean isNoConfirmation() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_CONFIRMATION);
    }

    private boolean isSendEmail() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_SEND_EMAIL);
    }

    private boolean isNeedToNotification(User user) {
        return this.authUtils.hasRole(AuthenticationUtils.Role.INTEGRATION) && user.getNotification() != null && user.getNotification().equals(Boolean.TRUE);
    }

    private void updateShares(UserEntity user) {
        List shares = this.shareDAO.findSharesByEmail(user.getEmail());
        if (shares == null) {
            log.warn((Object)("Failed to found shares for email=" + user.getEmail() + ". Manual share updating may be required!"));
        }
        for (ShareEntity share : shares) {
            share.setUser(user);
            if (this.shareDAO.update(share) != null) continue;
            log.warn((Object)("Failed to update share " + share + ". Manual share updating may be required!"));
        }
    }

    public SendActivationCodeStatus sendActivationCode(String email) {
        log.trace((Object)("start sendActivationCode(email=" + email + ")"));
        if (email == null) {
            return SendActivationCodeStatus.FAILED_INVALIDEMAIL;
        }
        UserEntity userEntity = null;
        try {
            userEntity = this.userDAO.findUserByEmailAddress(email);
        }
        catch (RuntimeException re) {
            return SendActivationCodeStatus.ERROR;
        }
        if (userEntity == null) {
            return SendActivationCodeStatus.FAILED_USERNOTREGISTERED;
        }
        if (userEntity.getActivationCode() == null) {
            return SendActivationCodeStatus.FAILED_USERALREADYACTIVATED;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", this.prepareActivationLink(userEntity.getActivationCode(), userEntity.getId()));
        if (!this.emailNotificationService.sendEmail(userEntity.toDTO(), EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)) {
            log.error((Object)("Failed to send activaton code for user with userId=" + userEntity.getId() + "."));
            return SendActivationCodeStatus.FAILED_EMAILPROBLEM;
        }
        log.info((Object)("Activation code has been sent to " + email + "."));
        return SendActivationCodeStatus.SUCCESS;
    }

    private String prepareActivationLink(String activationCode, Integer userId) {
        log.trace((Object)("start prepareActivationLink(activationCode=" + activationCode + ", userId=" + userId + ")"));
        DecimalFormat myFormatter = new DecimalFormat("000000");
        String code = String.valueOf(activationCode) + "_" + myFormatter.format(userId);
        String activationLink = String.valueOf(this.serverUrl) + "/user/activateAccount?code=" + code;
        if (!activationLink.startsWith("http://") && !activationLink.startsWith("https://")) {
            activationLink = "http://" + activationLink;
        }
        return activationLink;
    }

    private String prepareChangePasswordLink(String code) {
        String changePasswordLink = String.valueOf(this.serverUrl) + "/user/changePassword?code=" + code;
        if (!changePasswordLink.startsWith("http://") && !changePasswordLink.startsWith("https://")) {
            changePasswordLink = "http://" + changePasswordLink;
        }
        return changePasswordLink;
    }

    private boolean isNoFirstAndLastName() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_FIRST_AND_LAST_NAME);
    }

    private boolean isNoAdditionalData() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_NO_ADDITIONAL_DATA);
    }

    private RegisterResponse.RegisterStatus validateUser(User user) {
        if (user == null) {
            return RegisterResponse.RegisterStatus.ERROR;
        }
        if (!this.usernameValidator.validate(user.getUsername())) {
            return RegisterResponse.RegisterStatus.FAILED_USERNAMEINVALID;
        }
        if (!this.passwordValidator.validate(user.getPassword())) {
            return RegisterResponse.RegisterStatus.FAILED_PASSWORDINVALID;
        }
        if (!this.emailValidator.validate(user.getEmail())) {
            return RegisterResponse.RegisterStatus.FAILED_EMAILINVALID;
        }
        boolean noFirstAndLastName = this.isNoFirstAndLastName();
        if (!noFirstAndLastName && !this.notEmptyValidator.validate(user.getFirstname())) {
            return RegisterResponse.RegisterStatus.FAILED_FIRSTNAMEINVALID;
        }
        if (!noFirstAndLastName && !this.notEmptyValidator.validate(user.getLastname())) {
            return RegisterResponse.RegisterStatus.FAILED_LASTNAMEINVALID;
        }
        if (this.isPhoneNumberRequired() && !this.notEmptyValidator.validate(user.getPhoneNumber())) {
            return RegisterResponse.RegisterStatus.FAILED_PHONENUMBERINVALID;
        }
        boolean noAdditionalData = this.isNoAdditionalData();
        if (!noAdditionalData && !this.notEmptyValidator.validate(user.getAddress())) {
            return RegisterResponse.RegisterStatus.FAILED_ADDRESSINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(user.getTown())) {
            return RegisterResponse.RegisterStatus.FAILED_TOWNINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(user.getZipCode())) {
            return RegisterResponse.RegisterStatus.FAILED_ZIPCODEINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(user.getCountry())) {
            return RegisterResponse.RegisterStatus.FAILED_COUNTRYINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(user.getLanguage())) {
            return RegisterResponse.RegisterStatus.FAILED_LANGUAGEINVALID;
        }
        UserEntity userEntity = this.userDAO.findUserByUsernameAndEmailAddress(user.getUsername(), user.getEmail());
        if (userEntity != null && userEntity.getActivationCode() != null) {
            return RegisterResponse.RegisterStatus.FAILED_USERNOTACTIVATED;
        }
        if (this.userDAO.findUserByName(user.getUsername()) != null) {
            return RegisterResponse.RegisterStatus.FAILED_USERNAMETAKEN;
        }
        try {
            if (this.userDAO.findUserByEmailAddress(user.getEmail()) != null) {
                return RegisterResponse.RegisterStatus.FAILED_EMAILTAKEN;
            }
        }
        catch (RuntimeException re) {
            return RegisterResponse.RegisterStatus.ERROR;
        }
        return RegisterResponse.RegisterStatus.OK;
    }

    private boolean isPhoneNumberRequired() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_PHONE_NUMBER_REQUIRED, false);
    }

    public AuthenticateResponse authenticateUser(AuthenticationData data) {
        return this.authenticateUser(data, true);
    }

    @Autowired
    @Required
    public void setSsoProviderFactory(SsoProviderFactory ssoProviderFactory) {
        this.ssoProviderFactory = ssoProviderFactory;
    }

    public AuthenticateResponse authenticateUser(AuthenticationData data, boolean checkPasswordExpiration) {
        int expirationInterval;
        String username;
        log.info((Object)("start authenticateUser(" + data + ")"));
        if (data.getUsername() == null || data.getPassword() == null) {
            return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.FAILED);
        }
        UserEntity user = this.userDAO.findUserByName(data.getUsername());
        String ssoId = user != null ? user.getSsoId() : null;
        SsoUser ssoUser = null;
        if (!StringUtils.isBlank((CharSequence)ssoId)) {
            try {
                SsoProvider ssoProvider = this.ssoProviderFactory.getProvider(user.getSsoService().getName());
                ssoUser = ssoProvider.fetchUser(data.getUsername(), data.getPassword());
            }
            catch (SsoProviderException ex) {
                if (ex.getErrorCode() == SsoProviderException.ErrorCode.NOT_AUTHENTICATED) {
                    return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.FAILED);
                }
                return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.ERROR);
            }
            catch (Exception e) {
                log.warn((Object)("Failed to get user info from sso service: " + e.getMessage() + "."));
                if (log.isDebugEnabled()) {
                    e.printStackTrace();
                }
                return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.ERROR);
            }
        }
        if ((username = data.getUsername()).equals("internal")) {
            AuthenticateResponse response = new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.OK);
            Subject currentUser = this.authUtils.getCurrentSubject();
            response.setSessionId(data.getPassword());
            response.setSubscriptionValidTo(this.authUtils.getSubscriptionValidTo());
            String rememberMeCookie = this.authUtils.getRememberMeCookie();
            if (rememberMeCookie != null && data.isRememberMe()) {
                response.setRememberMeCookie(rememberMeCookie);
                currentUser.getSession().setTimeout(1471228928L);
            } else {
                currentUser.getSession().setTimeout(900000L);
            }
            return response;
        }
        AuthenticateResponse.AuthenticateStatus status = this.authUtils.authenticate(data.getUsername(), data.getPassword(), ssoUser == null ? null : ssoUser.getId(), data.isRememberMe());
        if (status != AuthenticateResponse.AuthenticateStatus.OK) {
            return new AuthenticateResponse(status);
        }
        if (checkPasswordExpiration && (expirationInterval = this.getExpirationInterval()) > 0 && this.isPasswordExpired(user, expirationInterval)) {
            return new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.FAILED_PASSWORDEXPIRED);
        }
        AuthenticateResponse response = new AuthenticateResponse(AuthenticateResponse.AuthenticateStatus.OK);
        Subject currentUser = this.authUtils.getCurrentSubject();
        response.setSessionId(currentUser.getSession().getId().toString());
        response.setSubscriptionValidTo(this.authUtils.getSubscriptionValidTo());
        String rememberMeCookie = this.authUtils.getRememberMeCookie();
        if (rememberMeCookie != null && data.isRememberMe()) {
            response.setRememberMeCookie(rememberMeCookie);
            currentUser.getSession().setTimeout(1471228928L);
        } else {
            currentUser.getSession().setTimeout(900000L);
        }
        log.info((Object)("User " + user.getUsername() + "/" + user.getEmail() + " has been logged in."));
        return response;
    }

    private int getExpirationInterval() {
        return this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0));
    }

    private boolean isPasswordExpired(UserEntity user, int expirationInterval) {
        Date expirationDate = this.getExpirationDate(user, expirationInterval);
        Date now = this.systemSupport.getCurrentDate();
        return expirationDate.before(now);
    }

    private Date getExpirationDate(UserEntity user, int expirationInterval) {
        GregorianCalendar expirationDate = new GregorianCalendar();
        expirationDate.setTimeInMillis(this.getPasswordCreationDate(user).getTime());
        ((Calendar)expirationDate).add(5, expirationInterval);
        return expirationDate.getTime();
    }

    private Date getPasswordCreationDate(UserEntity user) {
        return user.getPasswordCreationDate() == null ? user.getAddedDate() : user.getPasswordCreationDate();
    }

    public LogoutResponse logoutUser() throws InvalidSessionException {
        log.trace((Object)"start logoutUser()");
        this.authUtils.ensureLoggedIn();
        return new LogoutResponse(this.authUtils.logoutUser());
    }

    @Transactional
    public RemoveUserResponse removeUser(Integer userId) throws InvalidSessionException {
        UserEntity user;
        log.trace((Object)("start removeUser(userId=" + userId + ")"));
        this.authUtils.ensureLoggedIn();
        if (userId != null && !this.authUtils.hasAnyRole(new AuthenticationUtils.Role[]{AuthenticationUtils.Role.ADMIN, AuthenticationUtils.Role.INTEGRATION}) && !this.authUtils.getCurrentUserId().equals(userId)) {
            return new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.FAILED_INSUFFICIENTPERMISSIONS);
        }
        if (userId != null && this.authUtils.getCurrentUserId().equals(userId)) {
            this.authUtils.logoutUser();
        }
        if (userId == null) {
            userId = this.authUtils.getCurrentUserId();
            this.authUtils.logoutUser();
        }
        if ((user = this.userDAO.findUserById(userId)) == null || user.isDeleted()) {
            return new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.FAILED_USERNOTFOUND);
        }
        Date currentDate = this.systemSupport.getCurrentDate();
        for (LanDeviceEntity device : user.getLanDevices()) {
            if (device.getDeleted()) continue;
            device.setDeleted(true);
            device.setDeletedDate(currentDate);
            for (EventEntity event : device.getEvents()) {
                event.setDeleted(true);
            }
        }
        for (GatewayClientEntity gatewayClient : user.getGatewayClients()) {
            if (gatewayClient.getDeleted()) continue;
            gatewayClient.setDeleted(true);
        }
        Integer maxDeletedValue = this.userDAO.getMaxDeletedValueByUsername(user.getUsername());
        maxDeletedValue = maxDeletedValue + 1;
        user.setDeleted(maxDeletedValue);
        user.setDeletedDate(currentDate);
        if (this.userDAO.updateUser(user) == null) {
            log.warn((Object)("Failed to remove user with userId=" + user.getId() + "."));
            return new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.ERROR);
        }
        log.info((Object)("User with userId=" + user.getId() + " has been removed."));
        return new RemoveUserResponse(RemoveUserResponse.RemoveUserStatus.SUCCESS);
    }

    public AuthenticationStatus checkAuthenticationStatus(String rememberMeCookie) {
        return this.authUtils.checkAuthenticationStatus(rememberMeCookie);
    }

    @Transactional
    public ForgotPasswordResponse forgotPassword(String username, String email) {
        boolean isEmailSet;
        log.trace((Object)("start forgotPassword(username=" + username + ", " + email + ")"));
        boolean isUsernameSet = username != null && username.length() > 0;
        boolean bl = isEmailSet = email != null && email.length() > 0;
        if (!isUsernameSet && !isEmailSet) {
            return new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.INSUFFICIENTDATA);
        }
        UserEntity foundUser = null;
        if (isUsernameSet) {
            foundUser = this.userDAO.findUserByName(username);
        } else {
            try {
                foundUser = this.userDAO.findUserByEmailAddress(email);
            }
            catch (RuntimeException re) {
                return new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.ERROR);
            }
        }
        if (foundUser == null) {
            return isUsernameSet ? new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.INCORRECTUSERNAME) : new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.INCORRECTEMAIL);
        }
        foundUser.setChangePasswordCode(this.generateUniqueChangePasswordCodeCode());
        UserEntity updatedUser = this.userDAO.updateUser(foundUser);
        if (updatedUser == null) {
            log.warn((Object)("Failed to update user with userId=" + foundUser.getId() + " while changing password."));
            return new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.ERROR);
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", this.prepareChangePasswordLink(foundUser.getChangePasswordCode()));
        if (!this.emailNotificationService.sendEmail(foundUser.toDTO(), EmailNotificationService.EmailCode.FORGOT_PASSWORD, placeholders, null)) {
            log.warn((Object)("Failed to send change password link to user with userId=" + foundUser.getId() + "."));
            return new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.ERROR);
        }
        log.info((Object)("Sent change password link to user with userId=" + foundUser.getId() + "."));
        return new ForgotPasswordResponse(ForgotPasswordResponse.ForgotPasswordStatus.SUCCESS);
    }

    @Transactional
    public ChangePasswordResponse changePassword(String oldPassword, String newPassword) throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        if (!this.passwordValidator.validate(newPassword)) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_PASSWORDINVALID);
        }
        UserEntity user = this.userDAO.findUserById(this.authUtils.getCurrentUserId(), false, false);
        if (user == null) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.ERROR);
        }
        String hashedPassword = this.passwordHashGenerator.generate(oldPassword, user.getPasswordSalt());
        if (!hashedPassword.equals(user.getPassword())) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_WRONGOLDPASSWORD);
        }
        String newSalt = this.passwordHashGenerator.getSalt();
        String newHashedPassword = this.passwordHashGenerator.generate(newPassword, newSalt);
        user.setPassword(newHashedPassword);
        user.setPasswordSalt(newSalt);
        user.setPasswordCreationDate(this.systemSupport.getCurrentDate());
        if (this.userDAO.updateUser(user) == null) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.ERROR);
        }
        log.info((Object)("Password for user with userId=" + user.getId() + " has been changed."));
        return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.SUCCESS);
    }

    @Transactional
    public ChangePasswordResponse changePasswordByCode(String changePasswordCode, String newPassword, String newPasswordConfirm) {
        log.trace((Object)("start changePasswordByCode(changePasswordCode=" + changePasswordCode + ", newPassword=" + newPassword + ", newPasswordConfirm=" + newPasswordConfirm + ")"));
        if (newPassword == null || newPasswordConfirm == null) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_PASSWORDINVALID);
        }
        if (!newPassword.equals(newPasswordConfirm)) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_PASSWORDINVALID);
        }
        if (!this.passwordValidator.validate(newPassword)) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_PASSWORDINVALID);
        }
        UserEntity user = this.userDAO.findUserByChangePasswordCode(changePasswordCode);
        if (user == null) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.ERROR);
        }
        String newSalt = this.passwordHashGenerator.getSalt();
        String newHashedPassword = this.passwordHashGenerator.generate(newPassword, newSalt);
        user.setPassword(newHashedPassword);
        user.setPasswordSalt(newSalt);
        user.setPasswordCreationDate(this.systemSupport.getCurrentDate());
        user.setChangePasswordCode(null);
        if (this.userDAO.updateUser(user) == null) {
            log.warn((Object)("Failed to update user with userId=" + user.getId() + " while changing password."));
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.ERROR);
        }
        log.info((Object)("Password for user with userId=" + user.getId() + " has been changed."));
        return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.SUCCESS);
    }

    @Transactional
    public ChangePasswordResponse changePasswordAsAdmin(Integer userId, String newPassword) throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (!this.passwordValidator.validate(newPassword)) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_PASSWORDINVALID);
        }
        UserEntity user = this.userDAO.findUserById(userId, false, false);
        if (user == null) {
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.FAILED_NOTFOUNDUSER);
        }
        String newSalt = this.passwordHashGenerator.getSalt();
        String newHashedPassword = this.passwordHashGenerator.generate(newPassword, newSalt);
        user.setPassword(newHashedPassword);
        user.setPasswordSalt(newSalt);
        user.setPasswordCreationDate(this.systemSupport.getCurrentDate());
        if (this.userDAO.updateUser(user) == null) {
            log.warn((Object)("Failed to update user with userId=" + user.getId() + " while changing password."));
            return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.ERROR);
        }
        log.info((Object)("Password for user with userId=" + userId + " has been changed."));
        return new ChangePasswordResponse(ChangePasswordResponse.ChangePasswordStatus.SUCCESS);
    }

    public AccountSettings getSettings() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity user = this.userDAO.findUserById(this.authUtils.getCurrentUserId(), false, false);
        if (user == null) {
            return null;
        }
        AccountSettings userSettings = new AccountSettings();
        userSettings.setUserId(user.getId());
        userSettings.setEmail(user.getEmail());
        userSettings.setUsername(user.getUsername());
        userSettings.setAddedDate(user.getAddedDate());
        userSettings.setFirstname(user.getFirstname());
        userSettings.setLastname(user.getLastname());
        userSettings.setAddress(user.getAddress());
        userSettings.setTown(user.getTown());
        userSettings.setZipCode(user.getZipCode());
        userSettings.setState(user.getState());
        userSettings.setCountry(user.getCountry());
        userSettings.setPhoneNumber(user.getPhoneNumber());
        userSettings.setLanguage(user.getLanguage());
        userSettings.setMailing(Boolean.valueOf(user.isMailing()));
        userSettings.setUsingSSO(Boolean.valueOf(user.getSsoId() != null && !user.getSsoId().isEmpty()));
        return userSettings;
    }

    @Transactional
    public UpdateAccountSettingsResponse updateSettings(AccountSettings accountSettings) throws InvalidSessionException {
        log.trace((Object)("start updateSettings(accountSettings=" + accountSettings + ")"));
        this.authUtils.ensureLoggedIn();
        UpdateAccountSettingsResponse.UpdateAccountSettingsStatus validateResult = this.validateAccountSettings(accountSettings);
        if (validateResult != UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.SUCCESS) {
            return new UpdateAccountSettingsResponse(validateResult);
        }
        UserEntity user = this.userDAO.findUserById(accountSettings.getUserId(), false, false);
        if (user == null) {
            return new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.ERROR);
        }
        if (accountSettings.getPassword() != null && accountSettings.getPassword().trim().length() > 0) {
            log.debug((Object)"Password has been chnaged.");
            if (!this.passwordValidator.validate(accountSettings.getPassword())) {
                return new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_PASSWORDINVALID);
            }
            String newSalt = this.passwordHashGenerator.getSalt();
            String newHashedPassword = this.passwordHashGenerator.generate(accountSettings.getPassword(), newSalt);
            user.setPassword(newHashedPassword);
            user.setPasswordSalt(newSalt);
            user.setPasswordCreationDate(this.systemSupport.getCurrentDate());
        }
        user.setEmail(accountSettings.getEmail());
        user.setFirstname(accountSettings.getFirstname());
        user.setLastname(accountSettings.getLastname());
        user.setAddress(accountSettings.getAddress() != null ? accountSettings.getAddress() : "");
        user.setTown(accountSettings.getTown() != null ? accountSettings.getTown() : "");
        user.setZipCode(accountSettings.getZipCode() != null ? accountSettings.getZipCode() : "");
        user.setState(accountSettings.getState() != null ? accountSettings.getState() : "");
        user.setCountry(accountSettings.getCountry() != null ? accountSettings.getCountry() : "");
        user.setLanguage(accountSettings.getLanguage() != null ? accountSettings.getLanguage() : "");
        user.setMailing(accountSettings.getMailing() != null ? accountSettings.getMailing() : false);
        UserEntity updatedUser = this.userDAO.updateUser(user);
        if (updatedUser != null) {
            log.info((Object)("User's settings for user with userId=" + user.getId() + " has been changed."));
            return new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.SUCCESS);
        }
        log.warn((Object)("Failed to update user's settings for user with userId=" + user.getId() + "."));
        return new UpdateAccountSettingsResponse(UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.ERROR);
    }

    private UpdateAccountSettingsResponse.UpdateAccountSettingsStatus validateAccountSettings(AccountSettings accountSettings) {
        if (accountSettings == null) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.ERROR;
        }
        if (!this.emailValidator.validate(accountSettings.getEmail())) {
            log.debug((Object)("Invalid email address: '" + accountSettings.getEmail() + "'."));
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_EMAILINVALID;
        }
        UserEntity foundUserByEmail = null;
        try {
            foundUserByEmail = this.userDAO.findUserByEmailAddress(accountSettings.getEmail());
        }
        catch (RuntimeException re) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.ERROR;
        }
        if (foundUserByEmail != null && !foundUserByEmail.getId().equals(accountSettings.getUserId())) {
            log.debug((Object)("Email address '" + accountSettings.getEmail() + "' already taken."));
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_EMAILTAKEN;
        }
        if (!this.notEmptyValidator.validate(accountSettings.getFirstname())) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_FIRSTNAMEINVALID;
        }
        if (!this.notEmptyValidator.validate(accountSettings.getLastname())) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_LASTNAMEINVALID;
        }
        boolean noAdditionalData = this.isNoAdditionalData();
        if (!noAdditionalData && !this.notEmptyValidator.validate(accountSettings.getAddress())) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_ADDRESSINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(accountSettings.getTown())) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_TOWNINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(accountSettings.getZipCode())) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_ZIPCODEINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(accountSettings.getCountry())) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_COUNTRYINVALID;
        }
        if (!noAdditionalData && !this.notEmptyValidator.validate(accountSettings.getLanguage())) {
            return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.FAILED_LANGUAGEINVALID;
        }
        return UpdateAccountSettingsResponse.UpdateAccountSettingsStatus.SUCCESS;
    }

    public boolean loginAsUser(Integer userId) throws InvalidSessionException {
        log.trace((Object)("start loginAsUser(userId=" + userId + ")"));
        if (!this.allowLoginAs) {
            log.debug((Object)"Login as is not allowed.");
            return false;
        }
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        log.debug((Object)("store sudoUserId: " + userId));
        this.authUtils.storeData("sudoUserId", (Object)userId);
        return true;
    }

    public void logoutAsUser() throws InvalidSessionException {
        log.trace((Object)"start logoutAsUser()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        this.authUtils.removeData("sudoUserId");
    }

    public GetUsersResponse getAllUsers() throws InvalidSessionException {
        log.trace((Object)"start getAllUsers()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List users = this.userDAO.findAllUsers();
        if (users == null) {
            return new GetUsersResponse(GetUsersResponse.GetUsersStatus.ERROR, null);
        }
        return new GetUsersResponse(GetUsersResponse.GetUsersStatus.SUCCESS, UserEntity.toDTOs((List)users));
    }

    public GetUsersResponse getUsers(boolean deleted) throws InvalidSessionException {
        log.trace((Object)("start getUsers(deleted=" + deleted + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List users = this.userDAO.findUsers(true, deleted);
        if (users == null) {
            return new GetUsersResponse(GetUsersResponse.GetUsersStatus.ERROR, null);
        }
        return new GetUsersResponse(GetUsersResponse.GetUsersStatus.SUCCESS, UserEntity.toDTOs((List)users));
    }

    @Transactional
    public SaveResponse updateUserSettings(User userSettings) throws InvalidSessionException {
        log.trace((Object)("start updateUserSettings(userSettings=" + userSettings + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (userSettings == null || userSettings.getId() == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        UserEntity user = this.userDAO.findUserById(userSettings.getId());
        if (user == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        try {
            UserEntity foundUser = this.userDAO.findUserByEmailAddress(userSettings.getEmail());
            if (foundUser != null && !foundUser.getId().equals(user.getId())) {
                return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
            }
        }
        catch (RuntimeException re) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        user.setEmail(userSettings.getEmail());
        user.setLogConf(userSettings.getLogConf());
        user.setActivationCode(userSettings.getActivationCode());
        user.setChangePasswordCode(userSettings.getChangePasswordCode());
        user.setFirstname(userSettings.getFirstname());
        user.setLastname(userSettings.getLastname());
        user.setAddress(userSettings.getAddress() != null ? userSettings.getAddress() : "");
        user.setTown(userSettings.getTown() != null ? userSettings.getTown() : "");
        user.setZipCode(userSettings.getZipCode() != null ? userSettings.getZipCode() : "");
        user.setState(userSettings.getState() != null ? userSettings.getState() : "");
        user.setCountry(userSettings.getCountry() != null ? userSettings.getCountry() : "");
        user.setLanguage(userSettings.getLanguage() != null ? userSettings.getLanguage() : "");
        UserEntity updatedUser = this.userDAO.updateUser(user);
        if (updatedUser != null) {
            log.info((Object)("User's settings for user with userId=" + user.getId() + " has been changed."));
            return new SaveResponse(SaveResponse.SaveStatus.SAVED);
        }
        log.warn((Object)("Failed to update user's settings for user with userId=" + user.getId() + "."));
        return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
    }

    @Transactional(readOnly=true)
    public UserDetails getUserDetailsByUserId(Integer userId, boolean fetchDeletedDevices) throws InvalidSessionException {
        log.trace((Object)("start getUserDetailsByUserId(userId=" + userId + ", fetchDeletedDevices=" + fetchDeletedDevices + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        UserEntity userEntity = this.userDAO.findUserById(userId);
        if (userEntity == null) {
            return null;
        }
        List clients = this.gatewayClientDAO.findGatewayClients(userId, fetchDeletedDevices);
        List devices = this.lanDeviceDAO.findLanDevices(userId, fetchDeletedDevices);
        UserDetails userDetails = new UserDetails();
        userDetails.setUser(userEntity.toDTO());
        userDetails.setGatewayClients(GatewayClientEntity.toDTOs((List)clients, (GatewayDeviceConnectionService)this.gatewayDeviceConnection, (DeviceDriverFactory)this.deviceDriverFactory, (boolean)false, (boolean)false));
        userDetails.setLanDevices(LanDeviceEntity.toDTOs((GatewayDeviceConnectionService)this.gatewayDeviceConnection, (DeviceDriverFactory)this.deviceDriverFactory, (List)devices, (boolean)true, (boolean)true, (boolean)true, null, null, (Integer)userId));
        return userDetails;
    }

    public Boolean isAdmin() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        return this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN);
    }

    private boolean isCorrectCaptcha(String captchaText) {
        log.trace((Object)("start isCorrectCaptcha(captchaText=" + captchaText + ")"));
        return this.authUtils.isCaptchaCorrect(captchaText);
    }

    private String generateUniqueActivationCode() {
        String activationCode = null;
        while (this.userDAO.findUserByActivationCode(activationCode = this.passwordGenerator.generate(16)) != null) {
        }
        return activationCode;
    }

    private String generateUniqueChangePasswordCodeCode() {
        String code = null;
        while (this.userDAO.findUserByChangePasswordCode(code = this.passwordGenerator.generate(16)) != null) {
        }
        return code;
    }

    public VerifyPasswordStatus verifyPassword(String password) throws InvalidSessionException {
        log.trace((Object)"start verifyPassword(password=...)");
        this.authUtils.ensureLoggedIn();
        UserEntity user = this.userDAO.findUserById(this.authUtils.getCurrentUserId(), false, false);
        if (user == null) {
            return VerifyPasswordStatus.ERROR;
        }
        String hashedPassword = this.passwordHashGenerator.generate(password, user.getPasswordSalt());
        return hashedPassword.equals(user.getPassword()) ? VerifyPasswordStatus.CORRECT : VerifyPasswordStatus.INCORRECT;
    }

    public ProductEntity getDefaultProduct() {
        log.trace((Object)"start getDefaultProduct()");
        Integer defaultProductId = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID);
        return this.productDAO.findProductById(defaultProductId);
    }

    public List<UserNameId> findUsersByName(String name, boolean fetchDeleted) throws InvalidSessionException {
        log.trace((Object)("start findUsersByName(name=" + name + ", fetchDeleted=" + fetchDeleted + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (name == null || name.isEmpty()) {
            return Collections.emptyList();
        }
        List users = this.userDAO.findUsersByName(name, fetchDeleted);
        if (users == null) {
            return null;
        }
        ArrayList<UserNameId> usernames = new ArrayList<UserNameId>();
        for (UserEntity user : users) {
            usernames.add(this.toUserNameId(user));
        }
        return usernames;
    }

    private UserNameId toUserNameId(UserEntity user) {
        if (user == null) {
            return null;
        }
        return new UserNameId(user.getId(), user.getUsername(), user.getFirstname(), user.getLastname(), Boolean.valueOf(user.isDeleted()));
    }

    public List<UserNameId> findAllUsers(boolean fetchDeleted) throws InvalidSessionException {
        log.trace((Object)("start findUsersByName(fetchDeleted=" + fetchDeleted + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List users = this.userDAO.findUsers(fetchDeleted);
        if (users == null) {
            return null;
        }
        ArrayList<UserNameId> usernames = new ArrayList<UserNameId>();
        for (UserEntity user : users) {
            usernames.add(this.toUserNameId(user));
        }
        return usernames;
    }

    public ResendActivationCodeStatus resendActivationCode(Integer userId) throws InvalidSessionException {
        log.trace((Object)("start resendActivationCode(email=" + userId + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (userId == null) {
            return ResendActivationCodeStatus.FAILED_INVALIDUSERID;
        }
        UserEntity user = this.userDAO.findUserById(userId);
        if (user == null) {
            return ResendActivationCodeStatus.FAILED_USERNOTFOUND;
        }
        if (user.getActivationCode() == null) {
            return ResendActivationCodeStatus.FAILED_USERALREADYACTIVATED;
        }
        if (user.getEmail() == null || !this.emailValidator.validate(user.getEmail())) {
            return ResendActivationCodeStatus.FAILED_INVALIDEMAIL;
        }
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%LINK%", this.prepareActivationLink(user.getActivationCode(), user.getId()));
        if (!this.emailNotificationService.sendEmail(user.toDTO(), EmailNotificationService.EmailCode.ACCOUNT_ACTIVATION, placeholders, null)) {
            log.error((Object)("Failed to send activaton code for user with userId=" + user.getId() + "."));
            return ResendActivationCodeStatus.FAILED_EMAILPROBLEM;
        }
        log.info((Object)("Activation code for user with userId=" + userId + " has been resent."));
        return ResendActivationCodeStatus.SUCCESS;
    }

    public CreateSessionResponse createSession(String username) throws InvalidSessionException {
        log.trace((Object)("start createSession(username=" + username + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        if (username == null || username.trim().isEmpty()) {
            return new CreateSessionResponse(CreateSessionResponse.CreateSessionStatus.FAILED_INVALIDUSERNAME);
        }
        UserEntity user = this.userDAO.findUserByName(username);
        if (user == null) {
            return new CreateSessionResponse(CreateSessionResponse.CreateSessionStatus.FAILED_USERNOTFOUND);
        }
        String sessionId = this.authUtils.createSession(user);
        if (sessionId == null) {
            return new CreateSessionResponse(CreateSessionResponse.CreateSessionStatus.ERROR);
        }
        CreateSessionResponse response = new CreateSessionResponse(CreateSessionResponse.CreateSessionStatus.SUCCESS);
        response.setLoggedIn(true);
        response.setSessionId(sessionId);
        response.setSubscriptionValidTo(this.authUtils.getSubscriptionValidTo());
        return response;
    }

    @Transactional
    public void changePassword(String username, String oldPassword, String newPassword) {
        ExceptionsTrigger.throwIfBlank((String)oldPassword, (RuntimeException)((Object)new ChangePasswordException(NewChangePasswordReponse.ErrorCode.NO_OLD_PASSWORD)));
        ExceptionsTrigger.throwIfBlank((String)newPassword, (RuntimeException)((Object)new ChangePasswordException(NewChangePasswordReponse.ErrorCode.NO_NEW_PASSWORD)));
        if (!this.passwordValidator.validate(newPassword)) {
            throw new ChangePasswordException(NewChangePasswordReponse.ErrorCode.PASSWORD_INVALID);
        }
        UserEntity user = this.getUser(username);
        if (user == null || user.isDeleted()) {
            throw new ChangePasswordException(NewChangePasswordReponse.ErrorCode.USER_NOT_FOUND);
        }
        if (!this.verifyPassword(user, oldPassword)) {
            throw new ChangePasswordException(NewChangePasswordReponse.ErrorCode.PASSWORD_INCORRECT);
        }
        String newSalt = this.passwordHashGenerator.getSalt();
        String newHashedPassword = this.passwordHashGenerator.generate(newPassword, newSalt);
        user.setPassword(newHashedPassword);
        user.setPasswordSalt(newSalt);
        user.setPasswordCreationDate(this.systemSupport.getCurrentDate());
        if (this.userDAO.store(user) == null) {
            log.warn((Object)("Failed to update user with userId=" + user.getId() + " while changing password."));
            throw new ChangePasswordException(NewChangePasswordReponse.ErrorCode.ERROR);
        }
        log.info((Object)("Password for user with userId=" + user.getId() + " has been changed."));
    }

    private boolean verifyPassword(UserEntity user, String password) {
        return user.getPassword().equals(this.passwordHashGenerator.generate(password, user.getPasswordSalt()));
    }

    private UserEntity getUser(String username) {
        if (username == null) {
            return this.authUtils.isLoggedIn() ? this.userDAO.getUserById(this.authUtils.getCurrentUserId()) : null;
        }
        return this.userDAO.findUserByName(username);
    }

    @Transactional
    public void assignIndex(Integer userId, String mac) {
        log.debug((Object)("start assignIndex(userId=" + userId + ", mac=" + mac + ")"));
        if (userId == null) {
            throw new NullPointerException("userId");
        }
        if (Utils.isBlank((String)mac)) {
            throw new IllegalArgumentException("mac is blank");
        }
        UserEntity user = this.userDAO.findUserById(userId);
        if (user == null || user.isDeleted()) {
            log.warn((Object)("Not found user with userId=" + userId + " or user is deleted."));
            return;
        }
        String firstname = user.getFirstname();
        int maxIndex = -1;
        int accounts = 0;
        List devices = this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac);
        for (LanDeviceEntity device : devices) {
            if (!device.getUser().getFirstname().equals(firstname)) continue;
            ++accounts;
            int index = this.getIndex(device.getUser());
            if (index <= maxIndex) continue;
            maxIndex = index;
        }
        if (accounts <= 1) {
            log.debug((Object)("Found " + accounts + " account with fistname " + firstname + " with device with mac=" + mac + ". Index will not be assigned."));
            return;
        }
        if (maxIndex == -1) {
            user.setLastname("#2");
        } else {
            user.setLastname("#" + String.valueOf(++maxIndex));
        }
        log.debug((Object)("Assigning index=" + user.getLastname() + " to user with userId=" + userId + "."));
        if (this.userDAO.store(user) == null) {
            log.warn((Object)("Failed to assign index=" + user.getLastname() + " to user with userId=" + userId + "."));
        }
    }

    private int getIndex(UserEntity user) {
        String lasname = user.getLastname();
        if (Utils.isBlank((String)lasname)) {
            return -1;
        }
        return Integer.parseInt(lasname.replace("#", "").trim());
    }
}

