/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.Date;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.NewChangePasswordReponse;
import pl.smartapps.restserver.service.ChangePasswordException;
import pl.smartapps.restserver.service.impl.UserServiceImpl;
import pl.smartapps.restserver.service.impl.UserServiceImplInternal;
import pl.smartapps.restserver.sso.SsoProvider;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserServiceImpl.class, SsoProvider.class})
public class UserServiceChangePasswordTests
extends UserServiceImplInternal {
    @Test
    public void testChangePaswordForUsernameSuccessfully() {
        String username = "testUsername";
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)user.getPassword()).andReturn((Object)oldPassword);
        String oldPasswordSalt = "oldPasswordSalt";
        EasyMock.expect((Object)user.getPasswordSalt()).andReturn((Object)oldPasswordSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate(oldPassword, oldPasswordSalt)).andReturn((Object)oldPassword);
        String newPasswordSalt = "newPasswordSalt";
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)newPasswordSalt);
        String newPasswordHash = "newPasswrdHash";
        EasyMock.expect((Object)this.passwordHashGenerator.generate(newPassword, newPasswordSalt)).andReturn((Object)newPasswordHash);
        user.setPassword(newPasswordHash);
        user.setPasswordSalt(newPasswordSalt);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        user.setPasswordCreationDate(now);
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)1);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForUsernameFailureToUpdateUser() {
        String username = "testUsername";
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)user.getPassword()).andReturn((Object)oldPassword);
        String oldPasswordSalt = "oldPasswordSalt";
        EasyMock.expect((Object)user.getPasswordSalt()).andReturn((Object)oldPasswordSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate(oldPassword, oldPasswordSalt)).andReturn((Object)oldPassword);
        String newPasswordSalt = "newPasswordSalt";
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)newPasswordSalt);
        String newPasswordHash = "newPasswrdHash";
        EasyMock.expect((Object)this.passwordHashGenerator.generate(newPassword, newPasswordSalt)).andReturn((Object)newPasswordHash);
        user.setPassword(newPasswordHash);
        user.setPasswordSalt(newPasswordSalt);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        user.setPasswordCreationDate(now);
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn(null);
        EasyMock.expect((Object)user.getId()).andReturn((Object)1);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForUsernamePasswordIncorrect() {
        String username = "testUsername";
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)user.getPassword()).andReturn((Object)oldPassword);
        String oldPasswordSalt = "oldPasswordSalt";
        EasyMock.expect((Object)user.getPasswordSalt()).andReturn((Object)oldPasswordSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate(oldPassword, oldPasswordSalt)).andReturn((Object)"123");
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.PASSWORD_INCORRECT, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForUsernameUserDeleted() {
        String username = "testUsername";
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.USER_NOT_FOUND, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForUsernameUserNotFound() {
        String username = "testUsername";
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.USER_NOT_FOUND, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForNotLoggedInUserSuccessfully() {
        String username = null;
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer userId = 1;
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.userDAO.getUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)user.getPassword()).andReturn((Object)oldPassword);
        String oldPasswordSalt = "oldPasswordSalt";
        EasyMock.expect((Object)user.getPasswordSalt()).andReturn((Object)oldPasswordSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate(oldPassword, oldPasswordSalt)).andReturn((Object)oldPassword);
        String newPasswordSalt = "newPasswordSalt";
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)newPasswordSalt);
        String newPasswordHash = "newPasswrdHash";
        EasyMock.expect((Object)this.passwordHashGenerator.generate(newPassword, newPasswordSalt)).andReturn((Object)newPasswordHash);
        user.setPassword(newPasswordHash);
        user.setPasswordSalt(newPasswordSalt);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        user.setPasswordCreationDate(now);
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)1);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals(null, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForLoggedInFailureToUpdateUser() {
        String username = null;
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer userId = 1;
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.userDAO.getUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)user.getPassword()).andReturn((Object)oldPassword);
        String oldPasswordSalt = "oldPasswordSalt";
        EasyMock.expect((Object)user.getPasswordSalt()).andReturn((Object)oldPasswordSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate(oldPassword, oldPasswordSalt)).andReturn((Object)oldPassword);
        String newPasswordSalt = "newPasswordSalt";
        EasyMock.expect((Object)this.passwordHashGenerator.getSalt()).andReturn((Object)newPasswordSalt);
        String newPasswordHash = "newPasswrdHash";
        EasyMock.expect((Object)this.passwordHashGenerator.generate(newPassword, newPasswordSalt)).andReturn((Object)newPasswordHash);
        user.setPassword(newPasswordHash);
        user.setPasswordSalt(newPasswordSalt);
        Date now = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        user.setPasswordCreationDate(now);
        EasyMock.expect((Object)this.userDAO.store(user)).andReturn(null);
        EasyMock.expect((Object)user.getId()).andReturn((Object)1);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.ERROR, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForLoggedInPasswordIncorrect() {
        String username = null;
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer userId = 1;
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.userDAO.getUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)user.getPassword()).andReturn((Object)oldPassword);
        String oldPasswordSalt = "oldPasswordSalt";
        EasyMock.expect((Object)user.getPasswordSalt()).andReturn((Object)oldPasswordSalt);
        EasyMock.expect((Object)this.passwordHashGenerator.generate(oldPassword, oldPasswordSalt)).andReturn((Object)"123");
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.PASSWORD_INCORRECT, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForLoggedInUserDeleted() {
        String username = null;
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        Integer userId = 1;
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.userDAO.getUserById(userId)).andReturn((Object)user);
        EasyMock.expect((Object)user.isDeleted()).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.USER_NOT_FOUND, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForLoggedInUserNotFound() {
        String username = null;
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        Integer userId = 1;
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.userDAO.getUserById(userId)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.USER_NOT_FOUND, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordForNotLoggedInAndNullUsername() {
        String username = null;
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.isLoggedIn()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.USER_NOT_FOUND, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordNewPasswordInvalid() {
        String username = null;
        String oldPassword = "oldPassword";
        String newPassword = "newPassword";
        EasyMock.expect((Object)this.passwordValidator.validate(newPassword)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword(username, oldPassword, newPassword);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.PASSWORD_INVALID, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordNoNewPassword() {
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword("testUsername", "oldPassword", null);
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.NO_NEW_PASSWORD, (Object)errorCode);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangePaswordNoOldPassword() {
        PowerMock.replayAll((Object[])new Object[0]);
        NewChangePasswordReponse.ErrorCode errorCode = null;
        try {
            this.userService.changePassword("testUsernanem", null, "newPassword");
        }
        catch (ChangePasswordException ex) {
            errorCode = ex.getErrorCode();
        }
        Assert.assertEquals((Object)NewChangePasswordReponse.ErrorCode.NO_OLD_PASSWORD, (Object)errorCode);
        PowerMock.verifyAll();
    }
}

