/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.Date;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.easymock.EasyMock;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.hm.WebViewer.shared.model.AuthenticationData;
import pl.smartapps.restserver.db.main.SSOServiceEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.AuthenticateResponse;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.UserServiceImpl;
import pl.smartapps.restserver.service.impl.UserServiceImplInternal;
import pl.smartapps.restserver.sso.SsoProvider;
import pl.smartapps.restserver.sso.SsoProviderException;
import pl.smartapps.restserver.sso.SsoUser;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={UserServiceImpl.class, SsoProvider.class, AuthenticateResponse.class})
public class UserServiceAuthenticateUserTests
extends UserServiceImplInternal {
    @Test
    public void testAuthenticateUserSuccessfully() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        response.setRememberMeCookie(rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(1471228928L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserPasswordNotExpiredWithWithPasswordCreationDate() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        response.setRememberMeCookie(rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(1471228928L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserPasswordNotExpiredWithWithoutPasswordCreationDate() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn(null);
        EasyMock.expect((Object)user.getAddedDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0));
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        response.setRememberMeCookie(rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(1471228928L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserPasswordExpiredWithPasswordCreationDate() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)10, (int)0, (int)1);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED_PASSWORDEXPIRED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserPasswordExpiredWithoutPasswordCreationDate() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn(null);
        EasyMock.expect((Object)user.getAddedDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0));
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)10, (int)0, (int)1);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED_PASSWORDEXPIRED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserCheckPasswordExpirationDistabled() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = false;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        response.setRememberMeCookie(rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(1471228928L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserNotRememberMe() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = false;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(900000L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserNoRememberMeCookie() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn(null);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(900000L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserPasswordExpired() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)10, (int)0, (int)1);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED_PASSWORDEXPIRED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserExcessiveAttempts() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.FAILED_EXCESSIVEATTEMPTS);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED_EXCESSIVEATTEMPTS}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserNotActivates() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.FAILED_NOTACTIVATED);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED_NOTACTIVATED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserFailed() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.FAILED);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserForInternalUsername() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "internal";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        response.setSessionId(password);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        response.setRememberMeCookie(rememberMeCookie);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(1471228928L);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserForInternalUsernameAndNotRememberMe() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "internal";
        String password = "testPassword";
        boolean rememberMe = false;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        response.setSessionId(password);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(900000L);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserForInternalUsernameAndNoRememberMeCookie() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "internal";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn(null);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        response.setSessionId(password);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn(null);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(900000L);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserSuccessfully() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        String ssoId = "testSsoId";
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)ssoId);
        String ssoServiceName = "testSsoServiceName";
        SSOServiceEntity ssoServiceEntity = (SSOServiceEntity)PowerMock.createMock(SSOServiceEntity.class);
        EasyMock.expect((Object)user.getSsoService()).andReturn((Object)ssoServiceEntity);
        EasyMock.expect((Object)ssoServiceEntity.getName()).andReturn((Object)ssoServiceName);
        SsoProvider ssoProvider = (SsoProvider)PowerMock.createMock(SsoProvider.class);
        EasyMock.expect((Object)this.ssoProviderFactory.getProvider(ssoServiceName)).andReturn((Object)ssoProvider);
        SsoUser ssoUser = (SsoUser)PowerMock.createMock(SsoUser.class);
        EasyMock.expect((Object)ssoProvider.fetchUser(username, password)).andReturn((Object)ssoUser);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, ssoId, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        response.setRememberMeCookie(rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(1471228928L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserNotRememberMe() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = false;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        String ssoId = "testSsoId";
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)ssoId);
        String ssoServiceName = "testSsoServiceName";
        SSOServiceEntity ssoServiceEntity = (SSOServiceEntity)PowerMock.createMock(SSOServiceEntity.class);
        EasyMock.expect((Object)user.getSsoService()).andReturn((Object)ssoServiceEntity);
        EasyMock.expect((Object)ssoServiceEntity.getName()).andReturn((Object)ssoServiceName);
        SsoProvider ssoProvider = (SsoProvider)PowerMock.createMock(SsoProvider.class);
        EasyMock.expect((Object)this.ssoProviderFactory.getProvider(ssoServiceName)).andReturn((Object)ssoProvider);
        SsoUser ssoUser = (SsoUser)PowerMock.createMock(SsoUser.class);
        EasyMock.expect((Object)ssoProvider.fetchUser(username, password)).andReturn((Object)ssoUser);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, ssoId, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(900000L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserNullRememberMeCookie() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        String ssoId = "testSsoId";
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)ssoId);
        String ssoServiceName = "testSsoServiceName";
        SSOServiceEntity ssoServiceEntity = (SSOServiceEntity)PowerMock.createMock(SSOServiceEntity.class);
        EasyMock.expect((Object)user.getSsoService()).andReturn((Object)ssoServiceEntity);
        EasyMock.expect((Object)ssoServiceEntity.getName()).andReturn((Object)ssoServiceName);
        SsoProvider ssoProvider = (SsoProvider)PowerMock.createMock(SsoProvider.class);
        EasyMock.expect((Object)this.ssoProviderFactory.getProvider(ssoServiceName)).andReturn((Object)ssoProvider);
        SsoUser ssoUser = (SsoUser)PowerMock.createMock(SsoUser.class);
        EasyMock.expect((Object)ssoProvider.fetchUser(username, password)).andReturn((Object)ssoUser);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, ssoId, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn(null);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(900000L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserPasswordExpirationDisabld() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = false;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        String ssoId = "testSsoId";
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)ssoId);
        String ssoServiceName = "testSsoServiceName";
        SSOServiceEntity ssoServiceEntity = (SSOServiceEntity)PowerMock.createMock(SSOServiceEntity.class);
        EasyMock.expect((Object)user.getSsoService()).andReturn((Object)ssoServiceEntity);
        EasyMock.expect((Object)ssoServiceEntity.getName()).andReturn((Object)ssoServiceName);
        SsoProvider ssoProvider = (SsoProvider)PowerMock.createMock(SsoProvider.class);
        EasyMock.expect((Object)this.ssoProviderFactory.getProvider(ssoServiceName)).andReturn((Object)ssoProvider);
        SsoUser ssoUser = (SsoUser)PowerMock.createMock(SsoUser.class);
        EasyMock.expect((Object)ssoProvider.fetchUser(username, password)).andReturn((Object)ssoUser);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, ssoId, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn(null);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(900000L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserPaswordExpired() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        String ssoId = "testSsoId";
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)ssoId);
        String ssoServiceName = "testSsoServiceName";
        SSOServiceEntity ssoServiceEntity = (SSOServiceEntity)PowerMock.createMock(SSOServiceEntity.class);
        EasyMock.expect((Object)user.getSsoService()).andReturn((Object)ssoServiceEntity);
        EasyMock.expect((Object)ssoServiceEntity.getName()).andReturn((Object)ssoServiceName);
        SsoProvider ssoProvider = (SsoProvider)PowerMock.createMock(SsoProvider.class);
        EasyMock.expect((Object)this.ssoProviderFactory.getProvider(ssoServiceName)).andReturn((Object)ssoProvider);
        SsoUser ssoUser = (SsoUser)PowerMock.createMock(SsoUser.class);
        EasyMock.expect((Object)ssoProvider.fetchUser(username, password)).andReturn((Object)ssoUser);
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, ssoId, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)10, (int)0, (int)1);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED_PASSWORDEXPIRED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserUserInfoError() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        String ssoId = "testSsoId";
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)ssoId);
        String ssoServiceName = "testSsoServiceName";
        SSOServiceEntity ssoServiceEntity = (SSOServiceEntity)PowerMock.createMock(SSOServiceEntity.class);
        EasyMock.expect((Object)user.getSsoService()).andReturn((Object)ssoServiceEntity);
        EasyMock.expect((Object)ssoServiceEntity.getName()).andReturn((Object)ssoServiceName);
        SsoProvider ssoProvider = (SsoProvider)PowerMock.createMock(SsoProvider.class);
        EasyMock.expect((Object)this.ssoProviderFactory.getProvider(ssoServiceName)).andReturn((Object)ssoProvider);
        SsoUser ssoUser = (SsoUser)PowerMock.createMock(SsoUser.class);
        EasyMock.expect((Object)ssoProvider.fetchUser(username, password)).andThrow((Throwable)new SsoProviderException(SsoProviderException.ErrorCode.ERROR));
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserAuthTokenNull() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        String ssoId = "testSsoId";
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)ssoId);
        String ssoServiceName = "testSsoServiceName";
        SSOServiceEntity ssoServiceEntity = (SSOServiceEntity)PowerMock.createMock(SSOServiceEntity.class);
        EasyMock.expect((Object)user.getSsoService()).andReturn((Object)ssoServiceEntity);
        EasyMock.expect((Object)ssoServiceEntity.getName()).andReturn((Object)ssoServiceName);
        SsoProvider ssoProvider = (SsoProvider)PowerMock.createMock(SsoProvider.class);
        EasyMock.expect((Object)this.ssoProviderFactory.getProvider(ssoServiceName)).andReturn((Object)ssoProvider);
        SsoUser ssoUser = (SsoUser)PowerMock.createMock(SsoUser.class);
        EasyMock.expect((Object)ssoProvider.fetchUser(username, password)).andThrow((Throwable)new SsoProviderException(SsoProviderException.ErrorCode.NOT_AUTHENTICATED));
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateSsoUserWithEmptySsoId() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByName(username)).andReturn((Object)user);
        EasyMock.expect((Object)user.getSsoId()).andReturn((Object)"");
        EasyMock.expect((Object)this.authUtils.authenticate(username, password, null, rememberMe)).andReturn((Object)AuthenticateResponse.AuthenticateStatus.OK);
        Integer expirationInterval = 10;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_PASSWORD_EXPIRATION_INTERVAL, Integer.valueOf(0))).andReturn((Object)expirationInterval);
        EasyMock.expect((Object)user.getPasswordCreationDate()).andReturn((Object)Utils.constructDate((int)2014, (int)5, (int)1, (int)10, (int)0, (int)0)).times(2);
        Date now = Utils.constructDate((int)2014, (int)5, (int)11, (int)9, (int)59, (int)59);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.OK}).andReturn((Object)response);
        Subject subject = (Subject)PowerMock.createMock(Subject.class);
        EasyMock.expect((Object)this.authUtils.getCurrentSubject()).andReturn((Object)subject);
        Session session = (Session)PowerMock.createMock(Session.class);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        String sessionId = "testSessionId";
        EasyMock.expect((Object)session.getId()).andReturn((Object)sessionId);
        response.setSessionId(sessionId);
        Date subscriptionValidTo = (Date)PowerMock.createMock(Date.class);
        EasyMock.expect((Object)this.authUtils.getSubscriptionValidTo()).andReturn((Object)subscriptionValidTo);
        response.setSubscriptionValidTo(subscriptionValidTo);
        String rememberMeCookie = "testRememberMeCookie";
        EasyMock.expect((Object)this.authUtils.getRememberMeCookie()).andReturn((Object)rememberMeCookie);
        response.setRememberMeCookie(rememberMeCookie);
        EasyMock.expect((Object)subject.getSession()).andReturn((Object)session);
        session.setTimeout(1471228928L);
        EasyMock.expect((Object)user.getUsername()).andReturn((Object)username);
        EasyMock.expect((Object)user.getEmail()).andReturn((Object)"testEmail");
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserNullPassword() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        String username = "testUsername";
        Object password = null;
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn((Object)username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn(password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }

    @Test
    public void testAuthenticateUserNullUsername() throws Exception {
        AuthenticationData data = (AuthenticationData)PowerMock.createMock(AuthenticationData.class);
        Object username = null;
        String password = "testPassword";
        boolean rememberMe = true;
        EasyMock.expect((Object)data.getUsername()).andReturn(username).anyTimes();
        EasyMock.expect((Object)data.getPassword()).andReturn((Object)password).anyTimes();
        EasyMock.expect((Object)data.isRememberMe()).andReturn((Object)rememberMe).anyTimes();
        boolean checkPasswordExpiration = true;
        AuthenticateResponse response = (AuthenticateResponse)PowerMock.createMock(AuthenticateResponse.class);
        PowerMock.expectNew(AuthenticateResponse.class, (Object[])new Object[]{AuthenticateResponse.AuthenticateStatus.FAILED}).andReturn((Object)response);
        PowerMock.replayAll((Object[])new Object[0]);
        this.userService.authenticateUser(data, checkPasswordExpiration);
        PowerMock.verifyAll();
    }
}

