/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.orm.jpa.JpaTransactionManager;
import org.springframework.stereotype.Component;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
public class TransactionUtility {
    private JpaTransactionManager txManager;

    @Autowired
    @Required
    public void setTxManager(JpaTransactionManager txManager) {
        this.txManager = txManager;
    }

    public TransactionStatus startTransaction(String transactionName, int transactionDefinition) {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setName(transactionName);
        def.setPropagationBehavior(transactionDefinition);
        return this.txManager.getTransaction((TransactionDefinition)def);
    }

    public void commitTransaction(TransactionStatus status) {
        this.txManager.commit(status);
    }

    public void rollbackTransaction(TransactionStatus transactionStatus) {
        this.txManager.rollback(transactionStatus);
    }
}

