/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.service.impl.TCPClient;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={TCPClient.class, Socket.class})
public class TCPClientTests {
    private TCPClient tcpClient;
    private Socket socket;

    @Before
    public void setUp() {
        this.socket = (Socket)PowerMock.createMock(Socket.class);
        this.tcpClient = new TCPClient();
    }

    @Test
    public void testStart() throws IOException {
        try {
            PowerMock.expectNew(Socket.class, (Object[])new Object[0]).andReturn((Object)this.socket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String srvAddr = "localhost";
        int srvPort = 8002;
        InetAddress addr = InetAddress.getByName(srvAddr);
        InetSocketAddress sockAddr = new InetSocketAddress(addr, srvPort);
        this.socket.connect(sockAddr);
        PowerMock.replayAll((Object[])new Object[0]);
        this.tcpClient.start(srvAddr, srvPort);
        PowerMock.verifyAll();
    }

    @Test
    public void testStartRecording() throws IOException {
        try {
            PowerMock.expectNew(Socket.class, (Object[])new Object[0]).andReturn((Object)this.socket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String srvAddr = "localhost";
        int srvPort = 8002;
        InetAddress addr = InetAddress.getByName(srvAddr);
        InetSocketAddress sockAddr = new InetSocketAddress(addr, srvPort);
        this.socket.connect(sockAddr);
        String mac = "01:00:00:00:04:05";
        String ip = "192.168.21.138";
        int port = 1337;
        String user = "user";
        String passwd = "passwd";
        String url = "video.mjpg";
        String videoFile = "/videos/video.flv";
        String videoEncoding = "MJPEG";
        StringBuilder message = new StringBuilder();
        message.append("VIDEORECORDER:START");
        message.append(":").append("010000000405");
        message.append(":").append(ip);
        message.append(":").append(String.valueOf(port));
        message.append(":").append(user);
        message.append(":").append(passwd);
        message.append(":").append(url);
        message.append(":").append(videoFile);
        message.append(":").append(videoEncoding);
        OutputStream ostream = (OutputStream)PowerMock.createMock(OutputStream.class);
        EasyMock.expect((Object)this.socket.getOutputStream()).andReturn((Object)ostream);
        ostream.write(EasyMock.aryEq((byte[])message.toString().getBytes()));
        String servMsg = "VIDEORECORDER:STATUS:010000000405:" + ip + ":" + String.valueOf(port) + ":" + "RECORDING";
        byte[] buffer = servMsg.getBytes();
        ByteArrayInputStream stringStream = new ByteArrayInputStream(buffer);
        EasyMock.expect((Object)this.socket.getInputStream()).andReturn((Object)stringStream);
        PowerMock.replayAll((Object[])new Object[0]);
        this.tcpClient.start(srvAddr, srvPort);
        TCPClient.RecordingStatus status = this.tcpClient.startRecording(mac, ip, port, user, passwd, url, videoFile, videoEncoding);
        Assert.assertEquals((Object)status, (Object)TCPClient.RecordingStatus.RECORDING);
        PowerMock.verifyAll();
    }

    @Test
    public void testStopRecording() throws IOException {
        try {
            PowerMock.expectNew(Socket.class, (Object[])new Object[0]).andReturn((Object)this.socket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String srvAddr = "localhost";
        int srvPort = 8002;
        InetAddress addr = InetAddress.getByName(srvAddr);
        InetSocketAddress sockAddr = new InetSocketAddress(addr, srvPort);
        this.socket.connect(sockAddr);
        String mac = "01:00:00:00:04:05";
        String ip = "192.168.21.138";
        int port = 1337;
        String message = "VIDEORECORDER:STOP:010000000405:" + ip + ":" + String.valueOf(port);
        OutputStream ostream = (OutputStream)PowerMock.createMock(OutputStream.class);
        EasyMock.expect((Object)this.socket.getOutputStream()).andReturn((Object)ostream);
        ostream.write(EasyMock.aryEq((byte[])message.getBytes()));
        String servMsg = "VIDEORECORDER:STATUS:010000000405:" + ip + ":" + String.valueOf(port) + ":" + "STOPPED";
        byte[] buffer = servMsg.getBytes();
        ByteArrayInputStream stringStream = new ByteArrayInputStream(buffer);
        EasyMock.expect((Object)this.socket.getInputStream()).andReturn((Object)stringStream);
        PowerMock.replayAll((Object[])new Object[0]);
        this.tcpClient.start(srvAddr, srvPort);
        TCPClient.RecordingStatus status = this.tcpClient.stopRecording(mac, ip, port);
        Assert.assertEquals((Object)status, (Object)TCPClient.RecordingStatus.STOPPED);
        PowerMock.verifyAll();
    }
}

