/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;
import pl.smartapps.restserver.service.impl.ParsingException;
import pl.smartapps.restserver.service.impl.TCPClient;

public class TCPClient {
    private static Logger log = Logger.getLogger(TCPClient.class);
    private Socket socket;

    public boolean start(String srvAddr, int srvPort) {
        InetAddress addr;
        this.socket = new Socket();
        log.debug((Object)("TCPClient::start: " + srvAddr + ":" + String.valueOf(srvPort)));
        try {
            addr = InetAddress.getByName(srvAddr);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return false;
        }
        InetSocketAddress sockAddr = new InetSocketAddress(addr, srvPort);
        try {
            this.socket.connect(sockAddr);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public RecordingStatus startRecording(String macGc, String cameraIP, int cameraPort, String user, String password, String streamUrl, String videoFile, String videoEncoding) {
        return this.startRecording(macGc, cameraIP, cameraPort, user, password, streamUrl, videoFile, videoEncoding, true);
    }

    public RecordingStatus startRecording(String macGc, String cameraIP, int cameraPort, String user, String password, String streamUrl, String videoFile, String videoEncoding, boolean supportsRtcpOverRtsp) {
        BufferedInputStream stream;
        String mac = macGc.replace(":", "");
        StringBuilder message = new StringBuilder();
        message.append("VIDEORECORDER:START");
        message.append(":").append(mac);
        message.append(":").append(cameraIP);
        message.append(":").append(String.valueOf(cameraPort));
        message.append(":").append(user);
        message.append(":").append(password);
        message.append(":").append(streamUrl);
        message.append(":").append(videoFile);
        message.append(":").append(videoEncoding);
        if (!supportsRtcpOverRtsp) {
            message.append(":").append("NORTCP");
        }
        log.debug((Object)("TCPClient::startRecording: message = " + message));
        try {
            this.socket.getOutputStream().write(message.toString().getBytes());
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
        RecordingStatus status = null;
        try {
            stream = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (IOException ex1) {
            ex1.printStackTrace();
            return null;
        }
        do {
            byte[] buffer = new byte[128];
            try {
                if (stream.read(buffer, 0, buffer.length) <= 0) {
                    return null;
                }
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
                return null;
            }
            String serverMessage = new String(buffer);
            log.debug((Object)("TCPClient::startRecording: serverMessage = " + serverMessage));
            ServerMessage parsedMessage = null;
            try {
                parsedMessage = this.parseServerMessage(serverMessage);
            }
            catch (ParsingException e) {
                log.error((Object)("TCPClient::startRecording: " + e.getMessage()));
                continue;
            }
            if (!parsedMessage.gcMac.equals(mac) || !parsedMessage.cameraIp.equals(cameraIP) || parsedMessage.cameraPort != cameraPort) {
                log.info((Object)("TCPClient::startRecording: got response, but not for my request: request = " + message + " respose = " + serverMessage));
                continue;
            }
            status = parsedMessage.status;
        } while (status != RecordingStatus.ERROR && status != RecordingStatus.RECORDING);
        return status;
    }

    public RecordingStatus stopRecording(String macGc, String cameraIP, int cameraPort) {
        BufferedInputStream stream;
        String mac = macGc.replace(":", "");
        String message = "VIDEORECORDER:STOP:" + mac + ":" + cameraIP + ":" + String.valueOf(cameraPort);
        try {
            this.socket.getOutputStream().write(message.getBytes());
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        RecordingStatus status = null;
        try {
            stream = new BufferedInputStream(this.socket.getInputStream());
        }
        catch (IOException e1) {
            e1.printStackTrace();
            return null;
        }
        do {
            byte[] buffer = new byte[128];
            try {
                stream.read(buffer, 0, buffer.length);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                return null;
            }
            String serverMessage = new String(buffer);
            log.debug((Object)("TCPClient::stopRecording: serverMessage = " + serverMessage));
            ServerMessage parsedMessage = null;
            try {
                parsedMessage = this.parseServerMessage(serverMessage);
            }
            catch (ParsingException e) {
                log.error((Object)("TCPClient::stopRecording: " + e.getMessage()));
            }
            if (!parsedMessage.gcMac.equals(mac) || !parsedMessage.cameraIp.equals(cameraIP) || parsedMessage.cameraPort != cameraPort) {
                log.info((Object)("TCPClient::stopRecording: got response, but not for my request: request = " + message + " respose = " + serverMessage));
                continue;
            }
            status = parsedMessage.status;
        } while (status != RecordingStatus.STOPPED);
        return status;
    }

    public void stop() {
        try {
            this.socket.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ServerMessage parseServerMessage(String message) {
        ServerMessage serverMessage = new ServerMessage(this);
        if (message == null) {
            throw new ParsingException("Invalid server message - message i null");
        }
        String[] splitedMessage = message.trim().split(":");
        if (splitedMessage.length < 6) {
            throw new ParsingException("Invalid server message format (got: " + message + ")");
        }
        String type = splitedMessage[0];
        if (!type.equals("VIDEORECORDER")) {
            throw new ParsingException("Invalid server type - got: " + type + " expected: VIDEORECORDER");
        }
        serverMessage.command = splitedMessage[1];
        if (!serverMessage.command.equals("STATUS")) {
            throw new ParsingException("Invalid command - got: " + serverMessage.command + " expected: STATUS");
        }
        serverMessage.gcMac = splitedMessage[2];
        serverMessage.cameraIp = splitedMessage[3];
        String port = null;
        try {
            port = splitedMessage[4];
            serverMessage.cameraPort = Integer.parseInt(port);
        }
        catch (NumberFormatException e) {
            throw new ParsingException("Invalid server message - port is not a number (got: " + port + ")");
        }
        String status = splitedMessage[5];
        if (status.equals("ERROR")) {
            serverMessage.status = RecordingStatus.ERROR;
        } else if (status.equals("RECORDING")) {
            serverMessage.status = RecordingStatus.RECORDING;
        } else if (status.equals("STOPPED")) {
            serverMessage.status = RecordingStatus.STOPPED;
        } else {
            throw new ParsingException("Invalid status - unexpected value (got: " + status + ")");
        }
        return serverMessage;
    }
}

