/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.hm.WebViewer.shared.model.DashboardData;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.Period;
import pl.smartapps.hm.WebViewer.shared.model.StatData;
import pl.smartapps.hm.WebViewer.shared.model.StatisticsType;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.EventlogDAO;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.ReportingdateDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.StatisticsServiceImpl;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={StatisticsServiceImpl.class})
public class StatisticsServiceImplTests {
    private AuthenticationUtils authUtils;
    private StatisticsServiceImpl statisticsService;
    private UserDAO userDAO;
    private GatewayClientDAO gatewayClientDAO;
    private LanDeviceDAO lanDeviceDAO;
    private EventDAO eventDAO;
    private GatewayDeviceConnectionService gatewayDeviceConnection;
    private ReportingdateDAO reportingdateDAO;
    private EventlogDAO eventlogDAO;

    @Before
    public void setUp() {
        this.statisticsService = new StatisticsServiceImpl();
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.statisticsService.setAuthUtils(this.authUtils);
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.statisticsService.setUserDAO(this.userDAO);
        this.gatewayClientDAO = (GatewayClientDAO)PowerMock.createMock(GatewayClientDAO.class);
        this.statisticsService.setGatewayClientDAO(this.gatewayClientDAO);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.statisticsService.setLanDeviceDAO(this.lanDeviceDAO);
        this.eventDAO = (EventDAO)PowerMock.createMock(EventDAO.class);
        this.statisticsService.setEventDAO(this.eventDAO);
        this.gatewayDeviceConnection = (GatewayDeviceConnectionService)PowerMock.createMock(GatewayDeviceConnectionService.class);
        this.reportingdateDAO = (ReportingdateDAO)PowerMock.createMock(ReportingdateDAO.class);
        this.statisticsService.setReportingdateDAO(this.reportingdateDAO);
        this.eventlogDAO = (EventlogDAO)PowerMock.createMock(EventlogDAO.class);
        this.statisticsService.setEventlogDAO(this.eventlogDAO);
    }

    @Test
    public void testGetRegistredUsersCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.countRegistredUsers()).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5L, (Object)this.statisticsService.getRegistredUsersCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRegistredUsersCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.countRegistredUsers()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getRegistredUsersCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetActivatedGatewayClientsCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.countActivatedGatewayClients()).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5L, (Object)this.statisticsService.getActivatedGatewayClientsCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetActivatedGatewayClientsCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.countActivatedGatewayClients()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getActivatedGatewayClientsCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetConfiguredCamerasCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.OK)).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5L, (Object)this.statisticsService.getConfiguredCamerasCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetConfiguredCamerasCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.OK)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getConfiguredCamerasCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetManualConfigurationCamerasCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.MANUAL)).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5L, (Object)this.statisticsService.getManualConfigurationCamerasCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetManualConfigurationCamerasCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.MANUAL)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getManualConfigurationCamerasCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentlyStoredEventsCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.countCurrentlyStoredEvents()).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5L, (Object)this.statisticsService.getCurrentlyStoredEventsCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentlyStoredEventsCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.countCurrentlyStoredEvents()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getCurrentlyStoredEventsCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRecordedVideoContentSizeSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.countRecordedVideoContentSize()).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5L, (Object)this.statisticsService.getRecordedVideoContentSize());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRecordedVideoContentSizeFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.countRecordedVideoContentSize()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getRecordedVideoContentSize());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRecordedImageContentSizeSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.countRecordedImageContentSize()).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5L, (Object)this.statisticsService.getRecordedImageContentSize());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetRecordedImageContentSizeFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.countRecordedImageContentSize()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getRecordedImageContentSize());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetMaximumSizeOfStoredVideoSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.getMaximumSizeOfStoredVideo()).andReturn((Object)5);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5, (Object)this.statisticsService.getMaximumSizeOfStoredVideo());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetMaximumSizeOfStoredVideoFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.getMaximumSizeOfStoredVideo()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getMaximumSizeOfStoredVideo());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAverageSizeOfStoredVideoSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.getAverageSizeOfStoredVideo()).andReturn((Object)5.3);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5.3, (Object)this.statisticsService.getAverageSizeOfStoredVideo());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAverageSizeOfStoredVideoFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.eventDAO.getAverageSizeOfStoredVideo()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getAverageSizeOfStoredVideo());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentConnectedGatewayClientsCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)5, (Object)this.statisticsService.getCurrentConnectedGatewayClientsCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCurrentConnectedGatewayClientsCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.statisticsService.getCurrentConnectedGatewayClientsCount());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserRegistrationsPerDayFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.getUserRegistrationsPerDay(null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getUserRegistrationsPerDay(null);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserRegistrationsPerDayForNullPeriod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.getUserRegistrationsPerDay(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getUserRegistrationsPerDay(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserRegistrationsPerDayForAllPeriod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.getUserRegistrationsPerDay(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getUserRegistrationsPerDay(Period.ALL);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserRegistrationsPerDayForLastYearPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2010, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.userDAO.getUserRegistrationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getUserRegistrationsPerDay(Period.LAST_YEAR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserRegistrationsPerDayForLastMonthPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)2, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.userDAO.getUserRegistrationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getUserRegistrationsPerDay(Period.LAST_MONTH);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserRegistrationsPerDayForLast7DaysPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)25, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.userDAO.getUserRegistrationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getUserRegistrationsPerDay(Period.LAST_7_DAYS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCumulatedGetUserRegistrationsPerDayFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.getCumulatedUserRegistrationsPerDay(null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getCumulatedUserRegistrationsPerDay(Period.ALL);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCumulatedGetUserRegistrationsPerDayForAllPeriod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.getCumulatedUserRegistrationsPerDay(null, null)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedUserRegistrationsPerDay(Period.ALL);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCumulatedGetUserRegistrationsPerDayForLastYearPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2010, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.userDAO.getCumulatedUserRegistrationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedUserRegistrationsPerDay(Period.LAST_YEAR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCumulatedGetUserRegistrationsPerDayForLastMonthPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)2, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.userDAO.getCumulatedUserRegistrationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedUserRegistrationsPerDay(Period.LAST_MONTH);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCumulatedGetUserRegistrationsPerDayForLast7DaysPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)25, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.userDAO.getCumulatedUserRegistrationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedUserRegistrationsPerDay(Period.LAST_7_DAYS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetActivatedGatewayClientsPerDayFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.getActivatedGatewayClientsPerDay(null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getActivatedGatewayClientsPerDay(Period.ALL);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetActivatedGatewayClientsPerDayForAllPeriod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.getActivatedGatewayClientsPerDay(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getActivatedGatewayClientsPerDay(Period.ALL);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetActivatedGatewayClientsPerDayForLastYearPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2010, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.gatewayClientDAO.getActivatedGatewayClientsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getActivatedGatewayClientsPerDay(Period.LAST_YEAR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetActivatedGatewayClientsPerDayForLastMonthPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)2, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.gatewayClientDAO.getActivatedGatewayClientsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getActivatedGatewayClientsPerDay(Period.LAST_MONTH);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetActivatedGatewayClientsPerDayForLast7DaysPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)25, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.gatewayClientDAO.getActivatedGatewayClientsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getActivatedGatewayClientsPerDay(Period.LAST_7_DAYS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedActivatedGatewayClientsPerDayFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.getCumulatedActivatedGatewayClientsPerDay(null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getCumulatedActivatedGatewayClientsPerDay(Period.ALL);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedActivatedGatewayClientsPerDayForAllPeriod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.gatewayClientDAO.getCumulatedActivatedGatewayClientsPerDay(null, null)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedActivatedGatewayClientsPerDay(Period.ALL);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedActivatedGatewayClientsPerDayForLastYearPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2010, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.gatewayClientDAO.getCumulatedActivatedGatewayClientsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedActivatedGatewayClientsPerDay(Period.LAST_YEAR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedActivatedGatewayClientsPerDayForLastMonthPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)2, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.gatewayClientDAO.getCumulatedActivatedGatewayClientsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedActivatedGatewayClientsPerDay(Period.LAST_MONTH);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedActivatedGatewayClientsPerDayForLast7DaysPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)25, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.gatewayClientDAO.getCumulatedActivatedGatewayClientsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedActivatedGatewayClientsPerDay(Period.LAST_7_DAYS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCameraConfigurationsPerDayFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.getCameraConfigurationsPerDay(null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getCameraConfigurationsPerDay(Period.ALL);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCameraConfigurationsPerDayForAllPeriod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.getCameraConfigurationsPerDay(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCameraConfigurationsPerDay(Period.ALL);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCameraConfigurationsPerDayForLastYearPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2010, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.getCameraConfigurationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCameraConfigurationsPerDay(Period.LAST_YEAR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCameraConfigurationsPerDayForLastMonthPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)2, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.getCameraConfigurationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCameraConfigurationsPerDay(Period.LAST_MONTH);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCameraConfigurationsPerDayForLast7DaysPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)25, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.getCameraConfigurationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCameraConfigurationsPerDay(Period.LAST_7_DAYS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGgetCumulatedCameraConfigurationsPerDayFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.getCumulatedCameraConfigurationsPerDay(null, null)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getCumulatedCameraConfigurationsPerDay(Period.ALL);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGgetCumulatedCameraConfigurationsPerDayForAllPeriod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.getCumulatedCameraConfigurationsPerDay(null, null)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedCameraConfigurationsPerDay(Period.ALL);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGgetCumulatedCameraConfigurationsPerDayForLastYearPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2010, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.getCumulatedCameraConfigurationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedCameraConfigurationsPerDay(Period.LAST_YEAR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGgetCumulatedCameraConfigurationsPerDayForLastMonthPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)2, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.getCumulatedCameraConfigurationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedCameraConfigurationsPerDay(Period.LAST_MONTH);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGgetCumulatedCameraConfigurationsPerDayForLast7DaysPeriod() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)5, (int)25, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        PowerMock.expectNew(GregorianCalendar.class, (Object[])new Object[0]).andReturn((Object)Utils.constructGregorianCalendar((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0));
        EasyMock.expect((Object)this.lanDeviceDAO.getCumulatedCameraConfigurationsPerDay(dateFrom, dateTo)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getCumulatedCameraConfigurationsPerDay(Period.LAST_7_DAYS);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDailyIceSessionSetUpCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)10, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getDailyIceSessionSetUpCount(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getDailyIceSessionSetUpCount(dateFrom, dateTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDailyIceSessionSetUpCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)10, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getDailyIceSessionSetUpCount(dateFrom, dateTo)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getDailyIceSessionSetUpCount(dateFrom, dateTo);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyIceSessionSetUpCountSuccessfullyWithDate() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyIceSessionSetUpCount(date)).andReturn((Object)this.prepareHourlyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareHourlyExpectedTestData();
        List response = this.statisticsService.getHourlyIceSessionSetUpCount(date);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyIceSessionSetUpCountSuccessfullyWithNullDate() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)date);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyIceSessionSetUpCount(date)).andReturn((Object)this.prepareHourlyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareHourlyExpectedTestData();
        List response = this.statisticsService.getHourlyIceSessionSetUpCount(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyIceSessionSetUpCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyIceSessionSetUpCount(date)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getHourlyIceSessionSetUpCount(date);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDailyGatewayClientConnectionsCountSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)10, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getDailyGatewayClientConnectionsCount(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getDailyGatewayClientConnectionsCount(dateFrom, dateTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDailyGatewayClientConnectionsCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)10, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getDailyGatewayClientConnectionsCount(dateFrom, dateTo)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getDailyGatewayClientConnectionsCount(dateFrom, dateTo);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyGatewayClientConnectionsCountSuccessfullyWithDate() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyGatewayClientConnectionsCount(date)).andReturn((Object)this.prepareHourlyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareHourlyExpectedTestData();
        List response = this.statisticsService.getHourlyGatewayClientConnectionsCount(date);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyGatewayClientConnectionsCountSuccessfullyWithNullDate() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)date);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyGatewayClientConnectionsCount(date)).andReturn((Object)this.prepareHourlyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareHourlyExpectedTestData();
        List response = this.statisticsService.getHourlyGatewayClientConnectionsCount(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyGatewayClientConnectionsCountFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyGatewayClientConnectionsCount(date)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Object expectedResponse = null;
        List response = this.statisticsService.getHourlyGatewayClientConnectionsCount(date);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDashboardData() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(11);
        EasyMock.expect((Object)this.userDAO.countRegistredUsers()).andReturn((Object)1L);
        EasyMock.expect((Object)this.gatewayClientDAO.countActivatedGatewayClients()).andReturn((Object)2L);
        EasyMock.expect((Object)this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.OK)).andReturn((Object)3L);
        EasyMock.expect((Object)this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.MANUAL)).andReturn(null);
        EasyMock.expect((Object)this.eventDAO.countCurrentlyStoredEvents()).andReturn((Object)5L);
        EasyMock.expect((Object)this.eventDAO.countRecordedVideoContentSize()).andReturn((Object)6L);
        EasyMock.expect((Object)this.eventDAO.countRecordedImageContentSize()).andReturn((Object)7L);
        EasyMock.expect((Object)this.eventDAO.getMaximumSizeOfStoredVideo()).andReturn((Object)8);
        EasyMock.expect((Object)this.eventDAO.getAverageSizeOfStoredVideo()).andReturn((Object)9.0);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<DashboardData> expectedResponse = new ArrayList<DashboardData>();
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.REGISTERED_USERS_COUNT, "1"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.ACTIVATED_GCS_COUNT, "2"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.CONFIGURED_CAMERAS_COUNT, "3"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.MANUAL_CONFIGURATION_CAMERAS_COUNT, null));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.CURRENTLY_STORED_EVENTS_COUNT, "5"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.RECORDED_VIDEO_CONTENT_SIZE, "6"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.RECORDED_IMAGE_CONTENT_SIZE, "7"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.MAXIMUM_SIZE_OF_STORED_VIDEO, "8"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.AVERAGE_SIZE_OF_STORED_VIDEO, "9.0"));
        expectedResponse.add(this.createDashboardData(DashboardData.DashboadDataId.CURRENTLY_CONNECTED_GCS_COUNT, "10"));
        List response = this.statisticsService.getDashboardData();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAggregatedUsersRegistrationsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.userDAO.getUserRegistrationsPerDay(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.AGGREGATED_USER_REGISTRATIONS_PER_DAY, Period.ALL, null, null, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedUsersRegistrationsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.userDAO.getCumulatedUserRegistrationsPerDay(null, null)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.CUMULATED_USER_REGISTRATIONS_PER_DAY, Period.ALL, null, null, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAggregatedGcActivationsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.gatewayClientDAO.getActivatedGatewayClientsPerDay(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.AGGREGATED_GC_ACITIVATIONS_PER_DAY, Period.ALL, null, null, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedGcActivationsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.gatewayClientDAO.getCumulatedActivatedGatewayClientsPerDay(null, null)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.CUMULATED_GC_ACITIVATIONS_PER_DAY, Period.ALL, null, null, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAggregatedCameraConfigurationsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.lanDeviceDAO.getCameraConfigurationsPerDay(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.AGGREGATED_CAMERA_CONFIGURATIONS_PER_DAY, Period.ALL, null, null, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetCumulatedCameraConfigurationsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.lanDeviceDAO.getCumulatedCameraConfigurationsPerDay(null, null)).andReturn((Object)this.prepareCumulatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.CUMULATED_CAMERA_CONFIGURATIONS_PER_DAY, Period.ALL, null, null, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyIceSetupStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyIceSessionSetUpCount(date)).andReturn((Object)this.prepareHourlyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareHourlyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.ICE_SESSIONS_SETUP, null, null, null, date, true);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDailyIceSetupStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.eventlogDAO.getDailyIceSessionSetUpCount(null, null)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.ICE_SESSIONS_SETUP, null, null, null, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetHourlyGcConnectionsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        Date date = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getHourlyGatewayClientConnectionsCount(date)).andReturn((Object)this.prepareHourlyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareHourlyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.GC_CONNECTIONS, null, null, null, date, true);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDailyGcConnectionsStatistics() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expectLastCall().times(2);
        Date dateFrom = Utils.constructDate((int)2011, (int)6, (int)1, (int)0, (int)0, (int)0);
        Date dateTo = Utils.constructDate((int)2011, (int)6, (int)10, (int)0, (int)0, (int)0);
        EasyMock.expect((Object)this.eventlogDAO.getDailyGatewayClientConnectionsCount(dateFrom, dateTo)).andReturn((Object)this.prepareDailyAggregatedTestData());
        PowerMock.replayAll((Object[])new Object[0]);
        List expectedResponse = this.prepareDailyExpectedTestData();
        List response = this.statisticsService.getStatistics(StatisticsType.GC_CONNECTIONS, null, dateFrom, dateTo, null, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @After
    public void tearDown() {
        this.userDAO = null;
        this.gatewayClientDAO = null;
        this.lanDeviceDAO = null;
        this.eventDAO = null;
        this.gatewayDeviceConnection = null;
        this.reportingdateDAO = null;
    }

    private List<Object[]> prepareDailyAggregatedTestData() {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        Date date1 = Utils.constructDate((int)2011, (int)6, (int)15, (int)0, (int)0, (int)0);
        BigInteger data1 = BigInteger.valueOf(3L);
        Date date2 = Utils.constructDate((int)2011, (int)6, (int)16, (int)0, (int)0, (int)0);
        BigInteger data2 = BigInteger.valueOf(7L);
        Object[] row1 = new Object[]{date1, data1};
        Object[] row2 = new Object[]{date2, data2};
        datas.add(row1);
        datas.add(row2);
        return datas;
    }

    private List<StatData> prepareDailyExpectedTestData() {
        ArrayList<StatData> datas = new ArrayList<StatData>();
        Date date1 = Utils.constructDate((int)2011, (int)6, (int)15, (int)0, (int)0, (int)0);
        Long data1 = 3L;
        Date date2 = Utils.constructDate((int)2011, (int)6, (int)16, (int)0, (int)0, (int)0);
        Long data2 = 7L;
        StatData row1 = new StatData();
        row1.setDate(date1);
        row1.setCount(data1);
        StatData row2 = new StatData();
        row2.setDate(date2);
        row2.setCount(data2);
        datas.add(row1);
        datas.add(row2);
        return datas;
    }

    private List<Object[]> prepareHourlyAggregatedTestData() {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        Integer hour1 = 14;
        BigInteger data1 = BigInteger.valueOf(3L);
        Integer hour2 = 15;
        BigInteger data2 = BigInteger.valueOf(7L);
        Object[] row1 = new Object[]{hour1, data1};
        Object[] row2 = new Object[]{hour2, data2};
        datas.add(row1);
        datas.add(row2);
        return datas;
    }

    private List<StatData> prepareHourlyExpectedTestData() {
        ArrayList<StatData> datas = new ArrayList<StatData>();
        Integer hour1 = 14;
        Long data1 = 3L;
        Integer hour2 = 15;
        Long data2 = 7L;
        StatData row1 = new StatData();
        row1.setHour(hour1);
        row1.setCount(data1);
        StatData row2 = new StatData();
        row2.setHour(hour2);
        row2.setCount(data2);
        datas.add(row1);
        datas.add(row2);
        return datas;
    }

    private List<Object[]> prepareCumulatedTestData() {
        ArrayList<Object[]> datas = new ArrayList<Object[]>();
        Date date1 = Utils.constructDate((int)2011, (int)6, (int)15, (int)0, (int)0, (int)0);
        BigInteger data1 = BigInteger.valueOf(3L);
        Date date2 = Utils.constructDate((int)2011, (int)6, (int)16, (int)0, (int)0, (int)0);
        BigInteger data2 = BigInteger.valueOf(7L);
        Object[] row1 = new Object[]{date1, data1};
        Object[] row2 = new Object[]{date2, data2};
        datas.add(row1);
        datas.add(row2);
        return datas;
    }

    private DashboardData createDashboardData(DashboardData.DashboadDataId name, String value) {
        DashboardData data = new DashboardData();
        data.setName(name);
        data.setValue(value);
        return data;
    }
}

