/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.hm.WebViewer.shared.model.DashboardData;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.Period;
import pl.smartapps.hm.WebViewer.shared.model.StatData;
import pl.smartapps.hm.WebViewer.shared.model.StatisticsType;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.EventlogDAO;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.ReportingdateDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.Reportingdate;
import pl.smartapps.restserver.service.StatisticsService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.StatisticsServiceImpl;

@Service
public class StatisticsServiceImpl
implements StatisticsService {
    private static Logger log = Logger.getLogger(StatisticsServiceImpl.class);
    private AuthenticationUtils authUtils;
    private UserDAO userDAO;
    private GatewayClientDAO gatewayClientDAO;
    private LanDeviceDAO lanDeviceDAO;
    private EventDAO eventDAO;
    private ReportingdateDAO reportingdateDAO;
    private EventlogDAO eventlogDAO;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$Period;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$StatisticsType;

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Autowired
    @Required
    public void setGatewayClientDAO(GatewayClientDAO gatewayClientDAO) {
        this.gatewayClientDAO = gatewayClientDAO;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    @Autowired
    @Required
    public void setReportingdateDAO(ReportingdateDAO reportingdateDAO) {
        this.reportingdateDAO = reportingdateDAO;
    }

    @Autowired
    @Required
    public void setEventlogDAO(EventlogDAO eventlogDAO) {
        this.eventlogDAO = eventlogDAO;
    }

    public Long getRegistredUsersCount() throws InvalidSessionException {
        log.debug((Object)"start getRegistredUsersCount()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.userDAO.countRegistredUsers();
    }

    public Long getActivatedGatewayClientsCount() throws InvalidSessionException {
        log.debug((Object)"start getActivatedGatewayClientsCount()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.gatewayClientDAO.countActivatedGatewayClients();
    }

    public Long getConfiguredCamerasCount() throws InvalidSessionException {
        log.debug((Object)"start getConfiguredCamerasCount()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.OK);
    }

    public Long getManualConfigurationCamerasCount() throws InvalidSessionException {
        log.debug((Object)"start getManualConfigurationCamerasCount()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.lanDeviceDAO.countConfiguredCameras(LanDevice.LanDeviceConfigurationStatus.MANUAL);
    }

    public Long getCurrentlyStoredEventsCount() throws InvalidSessionException {
        log.debug((Object)"start getCurrentlyStoredEventsCount()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.eventDAO.countCurrentlyStoredEvents();
    }

    public Long getRecordedVideoContentSize() throws InvalidSessionException {
        log.debug((Object)"start getRecordedVideoContentSize()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.eventDAO.countRecordedVideoContentSize();
    }

    public Long getRecordedImageContentSize() throws InvalidSessionException {
        log.debug((Object)"start getRecordedImageContentSize()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.eventDAO.countRecordedImageContentSize();
    }

    public Integer getMaximumSizeOfStoredVideo() throws InvalidSessionException {
        log.debug((Object)"start getMaximumSizeOfStoredVideo()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.eventDAO.getMaximumSizeOfStoredVideo();
    }

    public Double getAverageSizeOfStoredVideo() throws InvalidSessionException {
        log.debug((Object)"start getAverageSizeOfStoredVideo()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.eventDAO.getAverageSizeOfStoredVideo();
    }

    public Integer getCurrentConnectedGatewayClientsCount() throws InvalidSessionException {
        log.debug((Object)"start getCurrentConnectedGatewayClientsCount()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return null;
    }

    public List<StatData> getUserRegistrationsPerDay(Period period) throws InvalidSessionException {
        log.debug((Object)("start getUserRegistrationsPerDay(period=" + period + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        DateRange range = this.getDateRange(period);
        List rows = this.userDAO.getUserRegistrationsPerDay(range.startDate, range.endDate);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getCumulatedUserRegistrationsPerDay(Period period) throws InvalidSessionException {
        log.debug((Object)("start getCumulatedUserRegistrationsPerDay(period=" + period + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        DateRange range = this.getDateRange(period);
        List rows = this.userDAO.getCumulatedUserRegistrationsPerDay(range.startDate, range.endDate);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getActivatedGatewayClientsPerDay(Period period) throws InvalidSessionException {
        log.debug((Object)("start getActivatedGatewayClientsPerDay(period=" + period + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        DateRange range = this.getDateRange(period);
        List rows = this.gatewayClientDAO.getActivatedGatewayClientsPerDay(range.startDate, range.endDate);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getCumulatedActivatedGatewayClientsPerDay(Period period) throws InvalidSessionException {
        log.debug((Object)("start getCumulatedActivatedGatewayClientsPerDay(period=" + period + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        DateRange range = this.getDateRange(period);
        List rows = this.gatewayClientDAO.getCumulatedActivatedGatewayClientsPerDay(range.startDate, range.endDate);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getCameraConfigurationsPerDay(Period period) throws InvalidSessionException {
        log.debug((Object)("start getCameraConfigurationsPerDay(period=" + period + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        DateRange range = this.getDateRange(period);
        List rows = this.lanDeviceDAO.getCameraConfigurationsPerDay(range.startDate, range.endDate);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getCumulatedCameraConfigurationsPerDay(Period period) throws InvalidSessionException {
        log.debug((Object)("start getCumulatedCameraConfigurationsPerDay(period=" + period + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        DateRange range = this.getDateRange(period);
        List rows = this.lanDeviceDAO.getCumulatedCameraConfigurationsPerDay(range.startDate, range.endDate);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getDailyIceSessionSetUpCount(Date dateFrom, Date dateTo) throws InvalidSessionException {
        log.debug((Object)("start getDailyIceSessionSetUpCount(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List rows = this.eventlogDAO.getDailyIceSessionSetUpCount(dateFrom, dateTo);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getHourlyIceSessionSetUpCount(Date date) throws InvalidSessionException {
        log.debug((Object)("start getHourlyIceSessionSetUpCount(date=" + date + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (date == null) {
            date = new Date();
        }
        List rows = this.eventlogDAO.getHourlyIceSessionSetUpCount(date);
        return this.convertFromHourlyData(rows);
    }

    public List<StatData> getDailyGatewayClientConnectionsCount(Date dateFrom, Date dateTo) throws InvalidSessionException {
        log.debug((Object)"start getDailyGatewayClientConnectionsCount()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List rows = this.eventlogDAO.getDailyGatewayClientConnectionsCount(dateFrom, dateTo);
        return this.convertFromDailyData(rows);
    }

    public List<StatData> getHourlyGatewayClientConnectionsCount(Date date) throws InvalidSessionException {
        log.debug((Object)("start getHourlyGatewayClientConnectionsCount(date=" + date + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (date == null) {
            date = new Date();
        }
        List rows = this.eventlogDAO.getHourlyGatewayClientConnectionsCount(date);
        return this.convertFromHourlyData(rows);
    }

    @Transactional
    public void fillReportingdate() throws InvalidSessionException {
        log.debug((Object)"start fillReportingdate()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        GregorianCalendar startDate = this.constructDate(2011, 1, 1);
        GregorianCalendar endDate = this.constructDate(2012, 12, 31);
        endDate.add(6, 1);
        while (startDate.getTime().before(endDate.getTime())) {
            Reportingdate reportingdate = new Reportingdate(null, startDate.getTime());
            this.reportingdateDAO.createReportingdate(reportingdate);
            startDate.add(6, 1);
        }
    }

    private GregorianCalendar constructDate(int year, int month, int day) {
        GregorianCalendar date = new GregorianCalendar();
        date.set(1, year);
        date.set(2, month - 1);
        date.set(5, day);
        return date;
    }

    private Date prepareDate(int dayAddition) {
        GregorianCalendar date = new GregorianCalendar();
        date.add(6, dayAddition);
        date.set(11, 0);
        date.set(12, 0);
        date.set(13, 0);
        date.set(14, 0);
        return date.getTime();
    }

    /*
     * Exception decompiling
     */
    private DateRange getDateRange(Period period) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<StatData> convertFromDailyData(List<Object[]> rows) {
        if (rows == null) {
            return null;
        }
        ArrayList<StatData> response = new ArrayList<StatData>(rows.size());
        for (Object[] row : rows) {
            StatData dateCount = new StatData();
            dateCount.setDate((Date)row[0]);
            BigInteger count = (BigInteger)row[1];
            dateCount.setCount(Long.valueOf(count.longValue()));
            response.add(dateCount);
        }
        return response;
    }

    private List<StatData> convertFromHourlyData(List<Object[]> rows) {
        if (rows == null) {
            return null;
        }
        ArrayList<StatData> response = new ArrayList<StatData>(rows.size());
        for (Object[] row : rows) {
            StatData hourCount = new StatData();
            hourCount.setHour((Integer)row[0]);
            BigInteger count = (BigInteger)row[1];
            hourCount.setCount(Long.valueOf(count.longValue()));
            response.add(hourCount);
        }
        return response;
    }

    public List<DashboardData> getDashboardData() throws InvalidSessionException {
        log.debug((Object)"start getDashboardData()");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        ArrayList<DashboardData> data = new ArrayList<DashboardData>();
        data.add(this.createDashboardData(DashboardData.DashboadDataId.REGISTERED_USERS_COUNT, this.toString((Object)this.getRegistredUsersCount())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.ACTIVATED_GCS_COUNT, this.toString((Object)this.getActivatedGatewayClientsCount())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.CONFIGURED_CAMERAS_COUNT, this.toString((Object)this.getConfiguredCamerasCount())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.MANUAL_CONFIGURATION_CAMERAS_COUNT, this.toString((Object)this.getManualConfigurationCamerasCount())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.CURRENTLY_STORED_EVENTS_COUNT, this.toString((Object)this.getCurrentlyStoredEventsCount())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.RECORDED_VIDEO_CONTENT_SIZE, this.toString((Object)this.getRecordedVideoContentSize())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.RECORDED_IMAGE_CONTENT_SIZE, this.toString((Object)this.getRecordedImageContentSize())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.MAXIMUM_SIZE_OF_STORED_VIDEO, this.toString((Object)this.getMaximumSizeOfStoredVideo())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.AVERAGE_SIZE_OF_STORED_VIDEO, this.toString((Object)this.getAverageSizeOfStoredVideo())));
        data.add(this.createDashboardData(DashboardData.DashboadDataId.CURRENTLY_CONNECTED_GCS_COUNT, this.toString((Object)this.getCurrentConnectedGatewayClientsCount())));
        return data;
    }

    private DashboardData createDashboardData(DashboardData.DashboadDataId name, String value) {
        DashboardData data = new DashboardData();
        data.setName(name);
        data.setValue(value);
        return data;
    }

    private String toString(Object object) {
        return object == null ? null : object.toString();
    }

    /*
     * Exception decompiling
     */
    public List<StatData> getStatistics(StatisticsType type, Period period, Date dateFrom, Date dateTo, Date date, boolean hourly) throws InvalidSessionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$Period() {
        if ($SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$Period != null) {
            return $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$Period;
        }
        int[] nArray = new int[Period.values().length];
        try {
            nArray[Period.ALL.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Period.LAST_7_DAYS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Period.LAST_MONTH.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Period.LAST_YEAR.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$Period = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$StatisticsType() {
        if ($SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$StatisticsType != null) {
            return $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$StatisticsType;
        }
        int[] nArray = new int[StatisticsType.values().length];
        try {
            nArray[StatisticsType.AGGREGATED_CAMERA_CONFIGURATIONS_PER_DAY.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StatisticsType.AGGREGATED_GC_ACITIVATIONS_PER_DAY.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StatisticsType.AGGREGATED_USER_REGISTRATIONS_PER_DAY.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StatisticsType.CUMULATED_CAMERA_CONFIGURATIONS_PER_DAY.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StatisticsType.CUMULATED_GC_ACITIVATIONS_PER_DAY.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StatisticsType.CUMULATED_USER_REGISTRATIONS_PER_DAY.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StatisticsType.GC_CONNECTIONS.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[StatisticsType.ICE_SESSIONS_SETUP.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$StatisticsType = nArray;
        return nArray;
    }
}

