/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.VivotekCameraIpAddressDiscoveryService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LanDeviceParam;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.EventNotificationEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.rest.response.SettingsResponse;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.SettingsServiceImpl;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={SettingsServiceImpl.class})
public class SettingsServiceTests {
    private SettingsServiceImpl settingsService;
    private DeviceDriverFactory deviceDriverFactory;
    private EventNotificationDAO eventNotificationDAO;
    private LanDeviceDAO lanDeviceDAO;
    private AuthenticationUtils authUtils;
    private GatewayDeviceConnectionService gatewayDeviceConnection;
    private ParameterService parameterService;
    private GatewayClientService gatewayClientService;
    private LanDeviceService lanDeviceService;

    @Before
    public void setUp() {
        this.settingsService = new SettingsServiceImpl();
        this.deviceDriverFactory = (DeviceDriverFactory)PowerMock.createMock(DeviceDriverFactory.class);
        this.settingsService.setDeviceDriverFactory(this.deviceDriverFactory);
        this.eventNotificationDAO = (EventNotificationDAO)PowerMock.createMock(EventNotificationDAO.class);
        this.settingsService.setEventNotificationDAO(this.eventNotificationDAO);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.settingsService.setLanDeviceDAO(this.lanDeviceDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.settingsService.setAuthUtils(this.authUtils);
        this.gatewayDeviceConnection = (GatewayDeviceConnectionService)PowerMock.createMock(GatewayDeviceConnectionService.class);
        this.settingsService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.settingsService.setParameterService(this.parameterService);
        this.gatewayClientService = (GatewayClientService)PowerMock.createMock(GatewayClientService.class);
        this.settingsService.setGatewayClientService(this.gatewayClientService);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.settingsService.setLanDeviceService(this.lanDeviceService);
    }

    private List<LanDeviceParamEntity> prepareChangedLanDeviceParamEntities(boolean legacyMode) {
        ArrayList<LanDeviceParamEntity> params = new ArrayList<LanDeviceParamEntity>();
        int paramId = 1;
        if (legacyMode) {
            params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"router_address", (String)"192.168.21.145", (String)"192.168.21.145"));
            params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"router_port", (String)"80", (String)"80"));
        }
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"system_ledoff", (String)"ON", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"privacy_button", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"motion_detection", (String)"ON", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"video_recording_duration", (String)"15", (String)"30"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity((Integer)paramId++, (String)"email_notification_1", (String)"q3@mail.com", (String)"q2@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParamEntity(null, (String)"email_notification_2", (String)"q4@mail.com", null));
        return params;
    }

    private List<LanDeviceParam> prepareChangedLanDeviceParams(boolean legacyMode) {
        ArrayList<LanDeviceParam> params = new ArrayList<LanDeviceParam>();
        int paramId = 1;
        if (legacyMode) {
            params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"router_address", (String)"192.168.21.145", (String)"192.168.21.145"));
            params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"router_port", (String)"80", (String)"80"));
        }
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"viewer_user", (String)"viewer", (String)"viewer"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"viewer_pass", (String)"NgbE78eBUB", (String)"NgbE78eBUB"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"system_ledoff", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"privacy_button", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"motion_detection", (String)"ON", (String)"ON"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"alarm_limit", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"record_video", (String)"OFF", (String)"OFF"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"video_recording_duration", (String)"15", (String)"15"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"email_notification_0", (String)"q1@mail.com", (String)"q1@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"email_notification_1", (String)"q3@mail.com", (String)"q3@mail.com"));
        params.add(TestDataUtils.prepareLanDeviceParam((Integer)paramId++, (String)"email_notification_2", (String)"q4@mail.com", (String)"q4@mail.com"));
        return params;
    }

    @Test
    public void testGetLanDeviceSettingsForLegacyDevice() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        device.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        device.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(device)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedDevice = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        expectedDevice.setHasHome(Boolean.valueOf(false));
        expectedDevice.setHasPan(Boolean.valueOf(false));
        expectedDevice.setHasTilt(Boolean.valueOf(false));
        expectedDevice.setHasZoom(Boolean.valueOf(false));
        expectedDevice.setHasIllumination(Boolean.valueOf(false));
        expectedDevice.setHasMotionDetection(Boolean.valueOf(true));
        expectedDevice.setHasLedControl(Boolean.valueOf(true));
        expectedDevice.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedDevice.setHasAudioDetection(Boolean.valueOf(false));
        expectedDevice.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedDevice.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedDevice.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedDevice.setProduct(deviceProduct);
        expectedDevice.setOwnerId(Integer.valueOf(1));
        expectedDevice.setShared(false);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedDevice);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWithIpAddressChecking() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        VivotekCameraIpAddressDiscoveryService cameraIpAddressFinder = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)cameraIpAddressFinder.getCameraIpAddres(deviceEntity)).andReturn((Object)"192.168.21.139");
        this.settingsService.setVivotekCameraIpAddressDiscoveryService(cameraIpAddressFinder);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedDevice = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedDevice.setHasHome(Boolean.valueOf(false));
        expectedDevice.setHasPan(Boolean.valueOf(false));
        expectedDevice.setHasTilt(Boolean.valueOf(false));
        expectedDevice.setHasZoom(Boolean.valueOf(false));
        expectedDevice.setHasIllumination(Boolean.valueOf(false));
        expectedDevice.setHasMotionDetection(Boolean.valueOf(true));
        expectedDevice.setHasLedControl(Boolean.valueOf(true));
        expectedDevice.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedDevice.setHasAudioDetection(Boolean.valueOf(false));
        expectedDevice.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedDevice.setIpAddress("192.168.21.139");
        expectedDevice.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedDevice.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedDevice.setProduct(deviceProduct);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedDevice);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWithoutIpAddressChecking() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedDevice = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedDevice.setHasHome(Boolean.valueOf(false));
        expectedDevice.setHasPan(Boolean.valueOf(false));
        expectedDevice.setHasTilt(Boolean.valueOf(false));
        expectedDevice.setHasZoom(Boolean.valueOf(false));
        expectedDevice.setHasIllumination(Boolean.valueOf(false));
        expectedDevice.setHasMotionDetection(Boolean.valueOf(true));
        expectedDevice.setHasLedControl(Boolean.valueOf(true));
        expectedDevice.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedDevice.setHasAudioDetection(Boolean.valueOf(false));
        expectedDevice.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedDevice.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedDevice.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedDevice.setProduct(deviceProduct);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedDevice);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWithOpenWifiSettings() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_enabled", "ON");
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntity, null, "wifi_ssid", "smart-apps");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_enabled", "ON");
        this.addParam(expectedSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(expectedSettings, "wifi_ssid", "smart-apps");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "OPEN");
        this.addParam(expectedSettings, "wifi_alghoritm", "NONE");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "");
        this.addParam(expectedSettings, "wifi_wep_key_length", "");
        this.addParam(expectedSettings, "wifi_wep_key_format", "");
        this.addParam(expectedSettings, "wifi_wep_key1", "");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("smart-apps");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword(null);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWifiEnabledMissingDefaultSsid() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntity, null, "wifi_ssid", "defaultSSID");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        GenericLanDevice defaultSsidDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)defaultSsidDriver);
        EasyMock.expect((Object)defaultSsidDriver.getDefaultSsid()).andReturn((Object)"defaultSSID");
        LanDeviceEntity deviceEntitySaved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        deviceEntitySaved.setProduct(productEntity);
        this.addParam(deviceEntitySaved, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntitySaved, null, "wifi_ssid", "defaultSSID");
        this.addParam(deviceEntitySaved, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntitySaved, null, "wifi_channel", "6");
        this.addParam(deviceEntitySaved, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntitySaved, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntitySaved, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key1", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key2", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key3", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key4", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_default_key", "");
        this.addParam(deviceEntitySaved, null, "wifi_enabled", "OFF", "OFF");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(deviceEntitySaved)).andReturn((Object)deviceEntitySaved);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(expectedSettings, "wifi_ssid", "defaultSSID");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "OPEN");
        this.addParam(expectedSettings, "wifi_alghoritm", "NONE");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "");
        this.addParam(expectedSettings, "wifi_wep_key_length", "");
        this.addParam(expectedSettings, "wifi_wep_key_format", "");
        this.addParam(expectedSettings, "wifi_wep_key1", "");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "");
        this.addParam(expectedSettings, "wifi_enabled", "OFF", "OFF");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("defaultSSID");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword(null);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWifiEnabledEmptySsid() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntity, null, "wifi_ssid", "");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice defaultSsidDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)defaultSsidDriver);
        EasyMock.expect((Object)defaultSsidDriver.getDefaultSsid()).andReturn((Object)"defaultSSID");
        LanDeviceEntity deviceEntitySaved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        deviceEntitySaved.setProduct(productEntity);
        this.addParam(deviceEntitySaved, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntitySaved, null, "wifi_ssid", "");
        this.addParam(deviceEntitySaved, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntitySaved, null, "wifi_channel", "6");
        this.addParam(deviceEntitySaved, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntitySaved, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntitySaved, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key1", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key2", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key3", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key4", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_default_key", "");
        this.addParam(deviceEntitySaved, null, "wifi_enabled", "OFF", "OFF");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(deviceEntitySaved)).andReturn((Object)deviceEntitySaved);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(expectedSettings, "wifi_ssid", "");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "OPEN");
        this.addParam(expectedSettings, "wifi_alghoritm", "NONE");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "");
        this.addParam(expectedSettings, "wifi_wep_key_length", "");
        this.addParam(expectedSettings, "wifi_wep_key_format", "");
        this.addParam(expectedSettings, "wifi_wep_key1", "");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "");
        this.addParam(expectedSettings, "wifi_enabled", "OFF", "OFF");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword(null);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWifiEnabledSSIDDifferentFromDefault() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntity, null, "wifi_ssid", "smart-apps");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice defaultSsidDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)defaultSsidDriver);
        EasyMock.expect((Object)defaultSsidDriver.getDefaultSsid()).andReturn((Object)"defaultSSID");
        LanDeviceEntity deviceEntitySaved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        deviceEntitySaved.setProduct(productEntity);
        this.addParam(deviceEntitySaved, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntitySaved, null, "wifi_ssid", "smart-apps");
        this.addParam(deviceEntitySaved, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntitySaved, null, "wifi_channel", "6");
        this.addParam(deviceEntitySaved, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntitySaved, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntitySaved, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key1", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key2", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key3", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_key4", "");
        this.addParam(deviceEntitySaved, null, "wifi_wep_default_key", "");
        this.addParam(deviceEntitySaved, null, "wifi_enabled", "ON", "ON");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(deviceEntitySaved)).andReturn((Object)deviceEntitySaved);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(expectedSettings, "wifi_ssid", "smart-apps");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "OPEN");
        this.addParam(expectedSettings, "wifi_alghoritm", "NONE");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "");
        this.addParam(expectedSettings, "wifi_wep_key_length", "");
        this.addParam(expectedSettings, "wifi_wep_key_format", "");
        this.addParam(expectedSettings, "wifi_wep_key1", "");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "");
        this.addParam(expectedSettings, "wifi_enabled", "ON", "ON");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("smart-apps");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword(null);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWifiEnabledNoDefaultSSID() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntity, null, "wifi_ssid", "smart-apps");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "OPEN");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "NONE");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice defaultSsidDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)defaultSsidDriver);
        EasyMock.expect((Object)defaultSsidDriver.getDefaultSsid()).andReturn(null);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(expectedSettings, "wifi_ssid", "smart-apps");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "OPEN");
        this.addParam(expectedSettings, "wifi_alghoritm", "NONE");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "");
        this.addParam(expectedSettings, "wifi_wep_key_length", "");
        this.addParam(expectedSettings, "wifi_wep_key_format", "");
        this.addParam(expectedSettings, "wifi_wep_key1", "");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("smart-apps");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword(null);
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWithWEPWifiSettings() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_enabled", "ON");
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "AD_HOC");
        this.addParam(deviceEntity, null, "wifi_ssid", "smart-apps");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "WEP");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "WEP");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "OPEN");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "LENGTH_128_BITS");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "HEX");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "4E710838DA59DEF237D04FEF09");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "1");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_enabled", "ON");
        this.addParam(expectedSettings, "wifi_wlan_mode", "AD_HOC");
        this.addParam(expectedSettings, "wifi_ssid", "smart-apps");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "WEP");
        this.addParam(expectedSettings, "wifi_alghoritm", "WEP");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "OPEN");
        this.addParam(expectedSettings, "wifi_wep_key_length", "LENGTH_128_BITS");
        this.addParam(expectedSettings, "wifi_wep_key_format", "HEX");
        this.addParam(expectedSettings, "wifi_wep_key1", "4E710838DA59DEF237D04FEF09");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "1");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.AD_HOC);
        wlanAccessPoint.setSsid("smart-apps");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WEP, EncryptionMode.Algorithm.WEP));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword("4E710838DA59DEF237D04FEF09");
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWithWpaTkipWifiSettings() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_enabled", "ON");
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntity, null, "wifi_ssid", "smart-apps");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "WPA");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "TKIP");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "password");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_enabled", "ON");
        this.addParam(expectedSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(expectedSettings, "wifi_ssid", "smart-apps");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "WPA");
        this.addParam(expectedSettings, "wifi_alghoritm", "TKIP");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "password");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "");
        this.addParam(expectedSettings, "wifi_wep_key_length", "");
        this.addParam(expectedSettings, "wifi_wep_key_format", "");
        this.addParam(expectedSettings, "wifi_wep_key1", "");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("smart-apps");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword("password");
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetLanDeviceSettingsWithWpa2AesWifiSettings() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        this.addParam(deviceEntity, null, "wifi_enabled", "ON");
        this.addParam(deviceEntity, null, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(deviceEntity, null, "wifi_ssid", "smart-apps");
        this.addParam(deviceEntity, null, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(deviceEntity, null, "wifi_channel", "6");
        this.addParam(deviceEntity, null, "wifi_encryption", "WPA2");
        this.addParam(deviceEntity, null, "wifi_alghoritm", "AES_CCMP");
        this.addParam(deviceEntity, null, "wifi_pre_shared_key", "password");
        this.addParam(deviceEntity, null, "wifi_wep_auth_mode", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_length", "");
        this.addParam(deviceEntity, null, "wifi_wep_key_format", "");
        this.addParam(deviceEntity, null, "wifi_wep_key1", "");
        this.addParam(deviceEntity, null, "wifi_wep_key2", "");
        this.addParam(deviceEntity, null, "wifi_wep_key3", "");
        this.addParam(deviceEntity, null, "wifi_wep_key4", "");
        this.addParam(deviceEntity, null, "wifi_wep_default_key", "");
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)true);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        this.addParam(expectedSettings, "wifi_enabled", "ON");
        this.addParam(expectedSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(expectedSettings, "wifi_ssid", "smart-apps");
        this.addParam(expectedSettings, "wifi_bssid", "98:FC:11:4E:34:9E");
        this.addParam(expectedSettings, "wifi_channel", "6");
        this.addParam(expectedSettings, "wifi_encryption", "WPA2");
        this.addParam(expectedSettings, "wifi_alghoritm", "AES_CCMP");
        this.addParam(expectedSettings, "wifi_pre_shared_key", "password");
        this.addParam(expectedSettings, "wifi_wep_auth_mode", "");
        this.addParam(expectedSettings, "wifi_wep_key_length", "");
        this.addParam(expectedSettings, "wifi_wep_key_format", "");
        this.addParam(expectedSettings, "wifi_wep_key1", "");
        this.addParam(expectedSettings, "wifi_wep_key2", "");
        this.addParam(expectedSettings, "wifi_wep_key3", "");
        this.addParam(expectedSettings, "wifi_wep_key4", "");
        this.addParam(expectedSettings, "wifi_wep_default_key", "");
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("smart-apps");
        wlanAccessPoint.setBssid("98:FC:11:4E:34:9E");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        expectedSettings.setWlanAccessPoint(wlanAccessPoint);
        expectedSettings.setWlanAccessPointPassword("password");
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetSettingsWithAppleDeviceNotRegistered() throws InvalidSessionException {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)false);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        VivotekCameraIpAddressDiscoveryService cameraIpAddressFinder = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)cameraIpAddressFinder.getCameraIpAddres(deviceEntity)).andReturn((Object)"192.168.21.139");
        this.settingsService.setVivotekCameraIpAddressDiscoveryService(cameraIpAddressFinder);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(Integer.valueOf(1), "123")).andReturn(null);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1), "123");
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        LanDeviceParam iphoneParam = new LanDeviceParam();
        iphoneParam.setName("iphone_notification");
        iphoneParam.setValue("OFF");
        expectedSettings.getLanDeviceParams().add(iphoneParam);
        expectedSettings.setIpAddress("192.168.21.139");
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetSettingsWithAppleDeviceRegistered() throws InvalidSessionException {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        deviceEntity.setProduct(productEntity);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)).andReturn((Object)false);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        VivotekCameraIpAddressDiscoveryService cameraIpAddressFinder = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        EasyMock.expect((Object)cameraIpAddressFinder.getCameraIpAddres(deviceEntity)).andReturn((Object)"192.168.21.139");
        this.settingsService.setVivotekCameraIpAddressDiscoveryService(cameraIpAddressFinder);
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(deviceEntity);
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("123");
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(Integer.valueOf(1), "123")).andReturn((Object)eventNotification);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        SettingsResponse response = this.settingsService.getLanDeviceSettings(Integer.valueOf(1), "123");
        PowerMock.verifyAll();
        LanDevice expectedSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedSettings.setHasHome(Boolean.valueOf(false));
        expectedSettings.setHasPan(Boolean.valueOf(false));
        expectedSettings.setHasTilt(Boolean.valueOf(false));
        expectedSettings.setHasZoom(Boolean.valueOf(false));
        expectedSettings.setHasIllumination(Boolean.valueOf(false));
        expectedSettings.setHasMotionDetection(Boolean.valueOf(true));
        expectedSettings.setHasLedControl(Boolean.valueOf(true));
        expectedSettings.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedSettings.setHasAudioDetection(Boolean.valueOf(false));
        expectedSettings.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedSettings.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedSettings.setConnCheckUrl("/connCheck");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setFeatures(new HashMap());
        expectedSettings.setProduct(deviceProduct);
        LanDeviceParam iphoneParam = new LanDeviceParam();
        iphoneParam.setName("iphone_notification");
        iphoneParam.setValue("ON");
        expectedSettings.getLanDeviceParams().add(iphoneParam);
        expectedSettings.setIpAddress("192.168.21.139");
        SettingsResponse expectedResponse = new SettingsResponse(LanDevice.LanDeviceStatus.CHECKING, expectedSettings);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testUpdateLanDeviceSettingsSuccesfully() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        Date modifiedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)56, (int)27);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)modifiedDate);
        changedDeviceEntity.setLanDeviceParams(this.prepareChangedLanDeviceParamEntities(true));
        changedDeviceEntity.setModifiedDate(modifiedDate);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        HashSet<String> supportedParameters = new HashSet<String>();
        supportedParameters.add("system_ledoff");
        supportedParameters.add("privacy_button");
        supportedParameters.add("motion_detection");
        supportedParameters.add("alarm_limit");
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(this.prepareChangedLanDeviceParams(true));
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceSettingsWifiOpenSuccesfully() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        deviceEntity.setLanDeviceParams(TestDataUtils.prepareLanDeviceParamEntities((boolean)true, (boolean)true));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(new ArrayList());
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        this.addParam(changedDeviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(changedDeviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(changedDeviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(changedDeviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(changedDeviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(changedDeviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(changedDeviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(changedDeviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(13), "wifi_ssid", "test-ssid", "default");
        this.addParam(changedDeviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        this.addParam(changedDeviceEntity, Integer.valueOf(15), "wifi_bssid", "test-bssid", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(16), "wifi_channel", "6", "6");
        this.addParam(changedDeviceEntity, Integer.valueOf(17), "wifi_encryption", "OPEN", "OPEN");
        this.addParam(changedDeviceEntity, Integer.valueOf(18), "wifi_alghoritm", "NONE", "NONE");
        this.addParam(changedDeviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(22), "wifi_wep_key1", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "", "");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(TestDataUtils.prepareLanDeviceParams((boolean)true, (boolean)true));
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("test-ssid");
        wlanAccessPoint.setBssid("test-bssid");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        newSettings.setWlanAccessPoint(wlanAccessPoint);
        newSettings.setWlanAccessPointPassword(null);
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceSettingsWifiWepSuccesfully() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        deviceEntity.setLanDeviceParams(TestDataUtils.prepareLanDeviceParamEntities((boolean)true, (boolean)true));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(new ArrayList());
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        this.addParam(changedDeviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(changedDeviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(changedDeviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(changedDeviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(changedDeviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(changedDeviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(changedDeviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(changedDeviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(13), "wifi_ssid", "test-ssid", "default");
        this.addParam(changedDeviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        this.addParam(changedDeviceEntity, Integer.valueOf(15), "wifi_bssid", "test-bssid", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(16), "wifi_channel", "6", "6");
        this.addParam(changedDeviceEntity, Integer.valueOf(17), "wifi_encryption", "WEP", "OPEN");
        this.addParam(changedDeviceEntity, Integer.valueOf(18), "wifi_alghoritm", "WEP", "NONE");
        this.addParam(changedDeviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "OPEN", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "LENGTH_128_BITS", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "HEX", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(22), "wifi_wep_key1", "passwd", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "1", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "", "");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(TestDataUtils.prepareLanDeviceParams((boolean)true, (boolean)true));
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("test-ssid");
        wlanAccessPoint.setBssid("test-bssid");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WEP, EncryptionMode.Algorithm.WEP));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        newSettings.setWlanAccessPoint(wlanAccessPoint);
        newSettings.setWlanAccessPointPassword("passwd");
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceSettingsWifiUseStrongestEncryptionSuccesfully() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        deviceEntity.setLanDeviceParams(TestDataUtils.prepareLanDeviceParamEntities((boolean)true, (boolean)true));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(new ArrayList());
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        this.addParam(changedDeviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(changedDeviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(changedDeviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(changedDeviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(changedDeviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(changedDeviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(changedDeviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(changedDeviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(13), "wifi_ssid", "test-ssid", "default");
        this.addParam(changedDeviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        this.addParam(changedDeviceEntity, Integer.valueOf(15), "wifi_bssid", "test-bssid", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(16), "wifi_channel", "6", "6");
        this.addParam(changedDeviceEntity, Integer.valueOf(17), "wifi_encryption", "WPA2", "OPEN");
        this.addParam(changedDeviceEntity, Integer.valueOf(18), "wifi_alghoritm", "AES_CCMP", "NONE");
        this.addParam(changedDeviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(22), "wifi_wep_key1", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "passwd", "");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(TestDataUtils.prepareLanDeviceParams((boolean)true, (boolean)true));
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("test-ssid");
        wlanAccessPoint.setBssid("test-bssid");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP));
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.AES_CCMP));
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        newSettings.setWlanAccessPoint(wlanAccessPoint);
        newSettings.setWlanAccessPointPassword("passwd");
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceSettingsNullWlanAccessPoint() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        deviceEntity.setLanDeviceParams(TestDataUtils.prepareLanDeviceParamEntities((boolean)true, (boolean)true));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(new ArrayList());
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        this.addParam(changedDeviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(changedDeviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(changedDeviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(changedDeviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(changedDeviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(changedDeviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(changedDeviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(changedDeviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(13), "wifi_ssid", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(15), "wifi_bssid", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(16), "wifi_channel", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(17), "wifi_encryption", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(18), "wifi_alghoritm", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(22), "wifi_wep_key1", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_enabled", "OFF", "OFF");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(TestDataUtils.prepareLanDeviceParams((boolean)true, (boolean)true));
        newSettings.setWlanAccessPoint(null);
        newSettings.setWlanAccessPointPassword(null);
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceSettingsEmptyWlanAccessPointWithEmptyEncryptions() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        deviceEntity.setLanDeviceParams(TestDataUtils.prepareLanDeviceParamEntities((boolean)true, (boolean)true));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(new ArrayList());
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        this.addParam(changedDeviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(changedDeviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(changedDeviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(changedDeviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(changedDeviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(changedDeviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(changedDeviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(changedDeviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(13), "wifi_ssid", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(15), "wifi_bssid", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(16), "wifi_channel", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(17), "wifi_encryption", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(18), "wifi_alghoritm", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(22), "wifi_wep_key1", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_enabled", "OFF", "OFF");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(TestDataUtils.prepareLanDeviceParams((boolean)true, (boolean)true));
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        ArrayList encryptionModes = new ArrayList();
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        newSettings.setWlanAccessPoint(wlanAccessPoint);
        newSettings.setWlanAccessPointPassword(null);
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceSettingsEmptyWlanAccessPointWithNullEncryptions() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        deviceEntity.setLanDeviceParams(TestDataUtils.prepareLanDeviceParamEntities((boolean)true, (boolean)true));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(new ArrayList());
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        this.addParam(changedDeviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(changedDeviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(changedDeviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(changedDeviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(changedDeviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(changedDeviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(changedDeviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(changedDeviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(13), "wifi_ssid", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(15), "wifi_bssid", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(16), "wifi_channel", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(17), "wifi_encryption", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(18), "wifi_alghoritm", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(22), "wifi_wep_key1", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_enabled", "OFF", "OFF");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(TestDataUtils.prepareLanDeviceParams((boolean)true, (boolean)true));
        newSettings.setWlanAccessPoint(new WlanAccessPoint());
        newSettings.setWlanAccessPointPassword(null);
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testChangeWifiSettings() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        deviceEntity.setLanDeviceParams(new ArrayList());
        this.addParam(deviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(deviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(deviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(deviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(deviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(deviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(deviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(deviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(deviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(deviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(deviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(deviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(deviceEntity, Integer.valueOf(13), "wifi_ssid", "test-ssid", "default");
        this.addParam(deviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        this.addParam(deviceEntity, Integer.valueOf(15), "wifi_bssid", "test-bssid", "");
        this.addParam(deviceEntity, Integer.valueOf(16), "wifi_channel", "6", "6");
        this.addParam(deviceEntity, Integer.valueOf(17), "wifi_encryption", "WEP", "WEP");
        this.addParam(deviceEntity, Integer.valueOf(18), "wifi_alghoritm", "WEP", "WEP");
        this.addParam(deviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "OPEN", "OPEN");
        this.addParam(deviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "LENGTH_128_BITS", "LENGTH_128_BITS");
        this.addParam(deviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "HEX", "HEX");
        this.addParam(deviceEntity, Integer.valueOf(22), "wifi_wep_key1", "passwd", "passwd");
        this.addParam(deviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(deviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(deviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(deviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "1", "1");
        this.addParam(deviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "", "");
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)false, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(new ArrayList());
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        this.addParam(changedDeviceEntity, Integer.valueOf(1), "router_address", "192.168.21.145", "192.168.21.145");
        this.addParam(changedDeviceEntity, Integer.valueOf(2), "router_port", "80", "80");
        this.addParam(changedDeviceEntity, Integer.valueOf(3), "viewer_user", "viewer", "viewer");
        this.addParam(changedDeviceEntity, Integer.valueOf(4), "viewer_pass", "NgbE78eBUB", "NgbE78eBUB");
        this.addParam(changedDeviceEntity, Integer.valueOf(5), "system_ledoff", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(6), "privacy_button", "ON", "ON");
        this.addParam(changedDeviceEntity, Integer.valueOf(7), "motion_detection", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(8), "alarm_limit", "15", "15");
        this.addParam(changedDeviceEntity, Integer.valueOf(9), "record_video", "OFF", "OFF");
        this.addParam(changedDeviceEntity, Integer.valueOf(10), "video_recording_duration", "30", "30");
        this.addParam(changedDeviceEntity, Integer.valueOf(11), "email_notification_0", "q1@mail.com", "q1@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(12), "email_notification_1", "q2@mail.com", "q2@mail.com");
        this.addParam(changedDeviceEntity, Integer.valueOf(13), "wifi_ssid", "test-ssid", "default");
        this.addParam(changedDeviceEntity, Integer.valueOf(14), "wifi_wlan_mode", "INFRASTRUCTURE", "INFRASTRUCTURE");
        this.addParam(changedDeviceEntity, Integer.valueOf(15), "wifi_bssid", "test-bssid", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(16), "wifi_channel", "6", "6");
        this.addParam(changedDeviceEntity, Integer.valueOf(17), "wifi_encryption", "WPA", "WEP");
        this.addParam(changedDeviceEntity, Integer.valueOf(18), "wifi_alghoritm", "TKIP", "WEP");
        this.addParam(changedDeviceEntity, Integer.valueOf(19), "wifi_wep_auth_mode", "", "OPEN");
        this.addParam(changedDeviceEntity, Integer.valueOf(20), "wifi_wep_key_length", "", "LENGTH_128_BITS");
        this.addParam(changedDeviceEntity, Integer.valueOf(21), "wifi_wep_key_format", "", "HEX");
        this.addParam(changedDeviceEntity, Integer.valueOf(22), "wifi_wep_key1", "", "passwd");
        this.addParam(changedDeviceEntity, Integer.valueOf(23), "wifi_wep_key2", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(24), "wifi_wep_key3", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(25), "wifi_wep_key4", "", "");
        this.addParam(changedDeviceEntity, Integer.valueOf(26), "wifi_wep_default_key", "", "1");
        this.addParam(changedDeviceEntity, Integer.valueOf(27), "wifi_pre_shared_key", "passwd", "");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(new ArrayList());
        this.addParam(newSettings, "router_address", "192.168.21.145");
        this.addParam(newSettings, "router_port", "80");
        this.addParam(newSettings, "viewer_user", "viewer");
        this.addParam(newSettings, "viewer_pass", "NgbE78eBUB");
        this.addParam(newSettings, "system_ledoff", "OFF");
        this.addParam(newSettings, "privacy_button", "ON");
        this.addParam(newSettings, "motion_detection", "OFF");
        this.addParam(newSettings, "alarm_limit", "15");
        this.addParam(newSettings, "record_video", "OFF");
        this.addParam(newSettings, "video_recording_duration", "30");
        this.addParam(newSettings, "email_notification_0", "q1@mail.com");
        this.addParam(newSettings, "email_notification_1", "q2@mail.com");
        this.addParam(newSettings, "wifi_ssid", "test-ssid");
        this.addParam(newSettings, "wifi_wlan_mode", "INFRASTRUCTURE");
        this.addParam(newSettings, "wifi_bssid", "test-bssid");
        this.addParam(newSettings, "wifi_channel", "6");
        this.addParam(newSettings, "wifi_encryption", "WEP");
        this.addParam(newSettings, "wifi_alghoritm", "WEP");
        this.addParam(newSettings, "wifi_wep_auth_mode", "OPEN");
        this.addParam(newSettings, "wifi_wep_key_length", "LENGTH_128_BITS");
        this.addParam(newSettings, "wifi_wep_key_format", "HEX");
        this.addParam(newSettings, "wifi_wep_key1", "passwd");
        this.addParam(newSettings, "wifi_wep_key2", "");
        this.addParam(newSettings, "wifi_wep_key3", "");
        this.addParam(newSettings, "wifi_wep_key4", "");
        this.addParam(newSettings, "wifi_wep_default_key", "1");
        this.addParam(newSettings, "wifi_pre_shared_key", "");
        WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
        wlanAccessPoint.setWlanMode(WlanAccessPoint.WlanMode.INFRASTRUCTURE);
        wlanAccessPoint.setSsid("test-ssid");
        wlanAccessPoint.setBssid("test-bssid");
        wlanAccessPoint.setChannel(Integer.valueOf(6));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP));
        wlanAccessPoint.setEncryptionModes(encryptionModes);
        newSettings.setWlanAccessPoint(wlanAccessPoint);
        newSettings.setWlanAccessPointPassword("passwd");
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterAppleDevice() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(this.prepareChangedLanDeviceParamEntities(true));
        Date modifiedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)56, (int)27);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)modifiedDate);
        changedDeviceEntity.setModifiedDate(modifiedDate);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        HashSet<String> supportedParameters = new HashSet<String>();
        supportedParameters.add("system_ledoff");
        supportedParameters.add("privacy_button");
        supportedParameters.add("motion_detection");
        supportedParameters.add("alarm_limit");
        driver.updateSettings(changedDeviceEntity);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(Integer.valueOf(1), "73696d756c617465642d6970686f6e652d61706e732d746f6b656e")).andReturn(null);
        EventNotificationEntity newEventNotification = new EventNotificationEntity();
        newEventNotification.setEventnotificationId(null);
        newEventNotification.setLanDevice(deviceEntity);
        newEventNotification.setNotificationType("APNS");
        newEventNotification.setToken("73696d756c617465642d6970686f6e652d61706e732d746f6b656e");
        EventNotificationEntity savedEventNotification = new EventNotificationEntity();
        savedEventNotification.setEventnotificationId(Integer.valueOf(1));
        savedEventNotification.setLanDevice(deviceEntity);
        savedEventNotification.setNotificationType("APNS");
        savedEventNotification.setToken("73696d756c617465642d6970686f6e652d61706e732d746f6b656e");
        EasyMock.expect((Object)this.eventNotificationDAO.createEventNotification(newEventNotification)).andReturn((Object)savedEventNotification);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(this.prepareChangedLanDeviceParams(true));
        LanDeviceParam iphoneParam = new LanDeviceParam();
        iphoneParam.setName("iphone_notification");
        iphoneParam.setValue("ON");
        newSettings.getLanDeviceParams().add(iphoneParam);
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings, "73696d756c617465642d6970686f6e652d61706e732d746f6b656e");
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterAndroidDevice() throws Exception {
        String registrationId = "APA91bFBTw3Ci9LYil344EXUow6gKjiIBWpGC0hwehhWYIwHnrduUYGhLLqeoBPUIKL9QdDl96YdZQAbMza3zz_-NW-i1KIHQR-Y06l1iztWEjmsd0p8_b9Ydz02UYwquD3fAmDxD25gBHiMiN0Wb2ORt3w2GE5ESve6mTTcuVQsdnXm9fZoW9U";
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(this.prepareChangedLanDeviceParamEntities(true));
        Date modifiedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)56, (int)27);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)modifiedDate);
        changedDeviceEntity.setModifiedDate(modifiedDate);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        HashSet<String> supportedParameters = new HashSet<String>();
        supportedParameters.add("system_ledoff");
        supportedParameters.add("privacy_button");
        supportedParameters.add("motion_detection");
        supportedParameters.add("alarm_limit");
        driver.updateSettings(changedDeviceEntity);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(Integer.valueOf(1), registrationId)).andReturn(null);
        EventNotificationEntity newEventNotification = new EventNotificationEntity();
        newEventNotification.setEventnotificationId(null);
        newEventNotification.setLanDevice(deviceEntity);
        newEventNotification.setNotificationType("C2DM");
        newEventNotification.setToken(registrationId);
        EventNotificationEntity savedEventNotification = new EventNotificationEntity();
        savedEventNotification.setEventnotificationId(Integer.valueOf(1));
        savedEventNotification.setLanDevice(deviceEntity);
        savedEventNotification.setNotificationType("C2DM");
        savedEventNotification.setToken(registrationId);
        EasyMock.expect((Object)this.eventNotificationDAO.createEventNotification(newEventNotification)).andReturn((Object)savedEventNotification);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(this.prepareChangedLanDeviceParams(true));
        LanDeviceParam iphoneParam = new LanDeviceParam();
        iphoneParam.setName("iphone_notification");
        iphoneParam.setValue("ON");
        newSettings.getLanDeviceParams().add(iphoneParam);
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings, registrationId);
        PowerMock.verifyAll();
    }

    @Test
    public void testUnregisterAppleDevice() throws Exception {
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(this.prepareChangedLanDeviceParamEntities(true));
        Date modifiedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)56, (int)27);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)modifiedDate);
        changedDeviceEntity.setModifiedDate(modifiedDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        HashSet<String> supportedParameters = new HashSet<String>();
        supportedParameters.add("system_ledoff");
        supportedParameters.add("privacy_button");
        supportedParameters.add("motion_detection");
        supportedParameters.add("alarm_limit");
        driver.updateSettings(changedDeviceEntity);
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(deviceEntity);
        eventNotification.setNotificationType("APNS");
        eventNotification.setToken("73696d756c617465642d6970686f6e652d61706e732d746f6b656e");
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(Integer.valueOf(1), "73696d756c617465642d6970686f6e652d61706e732d746f6b656e")).andReturn((Object)eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.removeEventNotification(eventNotification)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(this.prepareChangedLanDeviceParams(true));
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings, "73696d756c617465642d6970686f6e652d61706e732d746f6b656e");
        PowerMock.verifyAll();
    }

    @Test
    public void testUnregisterAndroidDevice() throws Exception {
        String registrationId = "APA91bFBTw3Ci9LYil344EXUow6gKjiIBWpGC0hwehhWYIwHnrduUYGhLLqeoBPUIKL9QdDl96YdZQAbMza3zz_-NW-i1KIHQR-Y06l1iztWEjmsd0p8_b9Ydz02UYwquD3fAmDxD25gBHiMiN0Wb2ORt3w2GE5ESve6mTTcuVQsdnXm9fZoW9U";
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)deviceEntity);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        changedDeviceEntity.setLanDeviceParams(this.prepareChangedLanDeviceParamEntities(true));
        Date modifiedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)56, (int)27);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)modifiedDate);
        changedDeviceEntity.setModifiedDate(modifiedDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        HashSet<String> supportedParameters = new HashSet<String>();
        supportedParameters.add("system_ledoff");
        supportedParameters.add("privacy_button");
        supportedParameters.add("motion_detection");
        supportedParameters.add("alarm_limit");
        driver.updateSettings(changedDeviceEntity);
        EventNotificationEntity eventNotification = new EventNotificationEntity();
        eventNotification.setEventnotificationId(Integer.valueOf(1));
        eventNotification.setLanDevice(deviceEntity);
        eventNotification.setNotificationType("C2DM");
        eventNotification.setToken(registrationId);
        EasyMock.expect((Object)this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(Integer.valueOf(1), registrationId)).andReturn((Object)eventNotification);
        EasyMock.expect((Object)this.eventNotificationDAO.removeEventNotification(eventNotification)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(this.prepareChangedLanDeviceParams(true));
        this.settingsService.updateLanDeviceSettings(Integer.valueOf(1), newSettings, registrationId);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceSettingsAsAdminSuccesfully() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity deviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDeviceEntity changedDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)true);
        Date modifiedDate = Utils.constructDate((int)2011, (int)5, (int)26, (int)13, (int)56, (int)27);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)modifiedDate);
        changedDeviceEntity.setLanDeviceParams(this.prepareChangedLanDeviceParamEntities(true));
        changedDeviceEntity.setModifiedDate(modifiedDate);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(changedDeviceEntity)).andReturn((Object)changedDeviceEntity);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        HashSet<String> supportedParameters = new HashSet<String>();
        supportedParameters.add("system_ledoff");
        supportedParameters.add("privacy_button");
        supportedParameters.add("motion_detection");
        supportedParameters.add("alarm_limit");
        driver.updateSettings(changedDeviceEntity);
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice newSettings = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)true);
        newSettings.setLanDeviceParams(this.prepareChangedLanDeviceParams(true));
        this.settingsService.updateLanDeviceSettingsAsAdmin(Integer.valueOf(1), newSettings);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDeviceStatusOk() throws InvalidSessionException {
        Integer ldId = 1;
        Integer userId = 11;
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        LanDeviceEntity deviceEntity = new LanDeviceEntity(ldId);
        deviceEntity.setProduct(new ProductEntity(Integer.valueOf(1)));
        deviceEntity.getProduct().setProductfeatures(new HashSet());
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        LanDevice device = new LanDevice(ldId);
        device.setProduct(new DeviceProduct(Integer.valueOf(1)));
        device.getProduct().setFeatures(new HashMap());
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(false));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setHasLedControl(Boolean.valueOf(false));
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setConnCheckUrl("");
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setRecording(Boolean.valueOf(false));
        device.setDeleted(Boolean.valueOf(false));
        AccessVerificationStatus deviceStatus = AccessVerificationStatus.OK;
        EasyMock.expect((Object)driver.checkStatus(device)).andReturn((Object)deviceStatus);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"");
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)LanDevice.LanDeviceStatus.OK, (Object)this.settingsService.getLanDeviceStatus(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDeviceStatusError() throws InvalidSessionException {
        Integer ldId = 1;
        Integer userId = 11;
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        LanDeviceEntity deviceEntity = new LanDeviceEntity(ldId);
        deviceEntity.setProduct(new ProductEntity(Integer.valueOf(1)));
        deviceEntity.getProduct().setProductfeatures(new HashSet());
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        LanDevice device = new LanDevice(ldId);
        device.setProduct(new DeviceProduct(Integer.valueOf(1)));
        device.getProduct().setFeatures(new HashMap());
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(false));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setHasLedControl(Boolean.valueOf(false));
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setConnCheckUrl("");
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setRecording(Boolean.valueOf(false));
        device.setDeleted(Boolean.valueOf(false));
        AccessVerificationStatus deviceStatus = AccessVerificationStatus.ERROR;
        EasyMock.expect((Object)driver.checkStatus(device)).andReturn((Object)deviceStatus);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"");
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)LanDevice.LanDeviceStatus.ERROR, (Object)this.settingsService.getLanDeviceStatus(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDeviceStatusNoAccess() throws InvalidSessionException {
        Integer ldId = 1;
        Integer userId = 11;
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        LanDeviceEntity deviceEntity = new LanDeviceEntity(ldId);
        deviceEntity.setProduct(new ProductEntity(Integer.valueOf(1)));
        deviceEntity.getProduct().setProductfeatures(new HashSet());
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        LanDevice device = new LanDevice(ldId);
        device.setProduct(new DeviceProduct(Integer.valueOf(1)));
        device.getProduct().setFeatures(new HashMap());
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(false));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setHasLedControl(Boolean.valueOf(false));
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setConnCheckUrl("");
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setRecording(Boolean.valueOf(false));
        device.setDeleted(Boolean.valueOf(false));
        AccessVerificationStatus deviceStatus = AccessVerificationStatus.NOACCESS;
        EasyMock.expect((Object)driver.checkStatus(device)).andReturn((Object)deviceStatus);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"");
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)LanDevice.LanDeviceStatus.NOACCESS, (Object)this.settingsService.getLanDeviceStatus(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDeviceStatusNoAnswerLanDeviceNotReachable() throws InvalidSessionException {
        Integer ldId = 1;
        Integer userId = 11;
        String mac = "00:11:22:33:44:55";
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        LanDeviceEntity deviceEntity = new LanDeviceEntity(ldId);
        deviceEntity.setProduct(new ProductEntity(Integer.valueOf(1)));
        deviceEntity.getProduct().setProductfeatures(new HashSet());
        deviceEntity.setGatewayClient(new GatewayClientEntity());
        deviceEntity.getGatewayClient().setMac(mac);
        deviceEntity.getGatewayClient().setDeleted(false);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDevice device = new LanDevice(ldId);
        device.setProduct(new DeviceProduct(Integer.valueOf(1)));
        device.getProduct().setFeatures(new HashMap());
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(false));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setHasLedControl(Boolean.valueOf(false));
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setConnCheckUrl("");
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setRecording(Boolean.valueOf(false));
        device.setDeleted(Boolean.valueOf(false));
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        device.setGatewayClient(new GatewayClient());
        device.getGatewayClient().setMac(mac);
        device.getGatewayClient().setDeleted(Boolean.valueOf(false));
        device.getGatewayClient().setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        device.getGatewayClient().setUpnpReason("none");
        device.getGatewayClient().setUpnpPort(Integer.valueOf(0));
        AccessVerificationStatus deviceStatus = AccessVerificationStatus.NOANSWER;
        EasyMock.expect((Object)driver.checkStatus(device)).andReturn((Object)deviceStatus);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"");
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)this.gatewayClientService.detectDeviceClient(mac)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)LanDevice.LanDeviceStatus.NOTREACHABLE, (Object)this.settingsService.getLanDeviceStatus(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDeviceStatusNoAnswerGCNotReachable() throws InvalidSessionException {
        Integer ldId = 1;
        Integer userId = 11;
        String mac = "00:11:22:33:44:55";
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        LanDeviceEntity deviceEntity = new LanDeviceEntity(ldId);
        deviceEntity.setProduct(new ProductEntity(Integer.valueOf(1)));
        deviceEntity.getProduct().setProductfeatures(new HashSet());
        deviceEntity.setGatewayClient(new GatewayClientEntity());
        deviceEntity.getGatewayClient().setMac(mac);
        deviceEntity.getGatewayClient().setDeleted(false);
        UserEntity userEntity = new UserEntity(Integer.valueOf(1));
        deviceEntity.setUser(userEntity);
        EasyMock.expect((Object)this.lanDeviceService.getLanDeviceByIdWithAccessVerification(Integer.valueOf(1))).andReturn((Object)deviceEntity);
        LanDevice device = new LanDevice(ldId);
        device.setProduct(new DeviceProduct(Integer.valueOf(1)));
        device.getProduct().setFeatures(new HashMap());
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(false));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setHasLedControl(Boolean.valueOf(false));
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setConnCheckUrl("");
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setRecording(Boolean.valueOf(false));
        device.setDeleted(Boolean.valueOf(false));
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        device.setGatewayClient(new GatewayClient());
        device.getGatewayClient().setMac(mac);
        device.getGatewayClient().setDeleted(Boolean.valueOf(false));
        device.getGatewayClient().setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        device.getGatewayClient().setUpnpReason("none");
        device.getGatewayClient().setUpnpPort(Integer.valueOf(0));
        AccessVerificationStatus deviceStatus = AccessVerificationStatus.NOANSWER;
        EasyMock.expect((Object)driver.checkStatus(device)).andReturn((Object)deviceStatus);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceEntity)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"");
        EasyMock.expect((Object)driver.isFirmwareUpToDate(deviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)this.gatewayClientService.detectDeviceClient(mac)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)LanDevice.LanDeviceStatus.GCNOTREACHABLE, (Object)this.settingsService.getLanDeviceStatus(ldId));
        PowerMock.verifyAll();
    }

    private void addParam(LanDeviceEntity device, Integer paramId, String paramName, String paramValue) {
        LanDeviceParamEntity param = new LanDeviceParamEntity(paramName, paramValue, null);
        device.getLanDeviceParams().add(param);
    }

    private void addParam(LanDeviceEntity device, Integer paramId, String paramName, String paramValue, String removeValue) {
        LanDeviceParamEntity param = new LanDeviceParamEntity(paramName, paramValue, removeValue);
        device.getLanDeviceParams().add(param);
    }

    private void addParam(LanDevice device, String paramName, String paramValue) {
        LanDeviceParam param = new LanDeviceParam(paramName, paramValue, null);
        device.getLanDeviceParams().add(param);
    }

    private void addParam(LanDevice device, String paramName, String paramValue, String paramRemoteValue) {
        LanDeviceParam param = new LanDeviceParam(paramName, paramValue, paramRemoteValue);
        device.getLanDeviceParams().add(param);
    }

    @After
    public void tearDown() {
        this.settingsService = null;
    }
}

