/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.VivotekCameraIpAddressDiscoveryService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.containerserver.landevice.WepAuthenticationType;
import pl.smartapps.containerserver.landevice.WepKeyFormat;
import pl.smartapps.containerserver.landevice.WepKeyLength;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LanDeviceParam;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.ShareDAO;
import pl.smartapps.restserver.db.main.EventNotificationEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.db.main.ShareEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.rest.response.SaveResponse;
import pl.smartapps.restserver.rest.response.SettingsResponse;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SettingsService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.EventNotificationType;

@Service
public class SettingsServiceImpl
implements SettingsService {
    private static Logger log = Logger.getLogger(SettingsServiceImpl.class);
    private LanDeviceDAO lanDeviceDAO;
    private ShareDAO shareDAO;
    private EventNotificationDAO eventNotificationDAO;
    private VivotekCameraIpAddressDiscoveryService vivotekCameraIpAddressDiscoveryService;
    private AuthenticationUtils authUtils;
    private GatewayClientService gatewayClientService;
    private LanDeviceService lanDeviceService;
    private DeviceDriverFactory deviceDriverFactory;
    private GatewayDeviceConnectionService gatewayDeviceConnection;
    private ParameterService parameterService;
    private ProductManagementService productManagementService;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus;

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setShareDAO(ShareDAO shareDAO) {
        this.shareDAO = shareDAO;
    }

    @Autowired
    @Required
    public void setEventNotificationDAO(EventNotificationDAO eventNotificationDAO) {
        this.eventNotificationDAO = eventNotificationDAO;
    }

    @Autowired
    @Required
    public void setVivotekCameraIpAddressDiscoveryService(VivotekCameraIpAddressDiscoveryService vivotekCameraIpAddressDiscoveryService) {
        this.vivotekCameraIpAddressDiscoveryService = vivotekCameraIpAddressDiscoveryService;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setGatewayClientService(GatewayClientService gatewayClientService) {
        this.gatewayClientService = gatewayClientService;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnectionService gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setProductManagementService(ProductManagementService productManagementService) {
        this.productManagementService = productManagementService;
    }

    @Transactional
    public SettingsResponse getLanDeviceSettings(Integer lanDeviceId, String appleDeviceId) throws InvalidSessionException {
        Boolean wifiEnabled;
        log.debug((Object)("start getLanDeviceSettings(" + lanDeviceId + ", " + appleDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        if (device == null) {
            return new SettingsResponse(LanDevice.LanDeviceStatus.NOTFOUND);
        }
        LanDevice.LanDeviceStatus status = LanDevice.LanDeviceStatus.CHECKING;
        if (!device.hasParam("router_address")) {
            if (this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_NO_CAMERA_IP_CHECK)) {
                log.debug((Object)"using device IP from the db");
            } else {
                log.debug((Object)"discovering device IP via the gc");
                device.setIpAddress(this.vivotekCameraIpAddressDiscoveryService.getCameraIpAddres(device));
            }
        }
        if (!device.hasParam("wifi_enabled") && (wifiEnabled = this.getWifiEnabled(device)) != null) {
            String value = wifiEnabled != false ? "ON" : "OFF";
            device.setParam("wifi_enabled", value, value);
            this.lanDeviceDAO.updateLanDevice(device);
        }
        LanDevice lanDevice = device.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, true, true, true, null, this.productManagementService, this.authUtils.getCurrentUserId());
        if (appleDeviceId != null) {
            LanDeviceParam apn = new LanDeviceParam();
            apn.setName("iphone_notification");
            EventNotificationEntity eventNotification = this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(lanDeviceId, appleDeviceId);
            if (eventNotification != null) {
                apn.setValue("ON");
            } else {
                apn.setValue("OFF");
            }
            lanDevice.getLanDeviceParams().add(apn);
        }
        lanDevice.setWlanAccessPoint(this.recreateWlanAccessPointUponSettings(device));
        lanDevice.setWlanAccessPointPassword(this.getWifiPassword(device));
        return new SettingsResponse(status, lanDevice);
    }

    private Boolean getWifiEnabled(LanDeviceEntity device) {
        String ssid = device.getParamValue("wifi_ssid");
        if (ssid == null) {
            return null;
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            log.warn((Object)("Not found driver for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return null;
        }
        String defaultSsid = driver.getDefaultSsid();
        if (defaultSsid == null) {
            log.warn((Object)("Driver for device with lanDeviceId=" + device.getLanDeviceId() + " has not defined default ssid."));
            return null;
        }
        return ssid != null && !ssid.equals("") && !ssid.equals(defaultSsid);
    }

    private WlanAccessPoint recreateWlanAccessPointUponSettings(LanDeviceEntity device) {
        if (device.hasParam("wifi_ssid")) {
            WlanAccessPoint wlanAccessPoint = new WlanAccessPoint();
            wlanAccessPoint.setWlanMode(this.getWlanMode(device));
            wlanAccessPoint.setSsid(device.getParamValue("wifi_ssid"));
            wlanAccessPoint.setBssid(device.getParamValue("wifi_bssid"));
            wlanAccessPoint.setChannel(this.getChannel(device));
            ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
            encryptionModes.add(this.recreateEncryptionModeUponSettings(device));
            wlanAccessPoint.setEncryptionModes(encryptionModes);
            return wlanAccessPoint;
        }
        return null;
    }

    private WlanAccessPoint.WlanMode getWlanMode(LanDeviceEntity device) {
        String wlanMode = device.getParamValue("wifi_wlan_mode");
        if (wlanMode == null || wlanMode.trim().equals("")) {
            return null;
        }
        return WlanAccessPoint.WlanMode.valueOf((String)wlanMode);
    }

    private Integer getChannel(LanDeviceEntity device) {
        String channel = device.getParamValue("wifi_channel");
        if (channel == null || channel.equals("")) {
            return null;
        }
        return Integer.parseInt(channel);
    }

    private EncryptionMode recreateEncryptionModeUponSettings(LanDeviceEntity device) {
        return new EncryptionMode(this.getEncryption(device), this.getAlgorithm(device));
    }

    private EncryptionMode.Encryption getEncryption(LanDeviceEntity device) {
        String encryption = device.getParamValue("wifi_encryption");
        if (encryption == null || encryption.equals("")) {
            return null;
        }
        return EncryptionMode.Encryption.valueOf((String)encryption);
    }

    private EncryptionMode.Algorithm getAlgorithm(LanDeviceEntity device) {
        String algorithm = device.getParamValue("wifi_alghoritm");
        if (algorithm == null || algorithm.equals("")) {
            return null;
        }
        return EncryptionMode.Algorithm.valueOf((String)algorithm);
    }

    private String getWifiPassword(LanDeviceEntity device) {
        String enc = device.getParamValue("wifi_encryption");
        if (enc == null || enc.equals("") || enc.equals("OPEN")) {
            return null;
        }
        return enc.equals("WEP") ? device.getParamValue("wifi_wep_key1") : device.getParamValue("wifi_pre_shared_key");
    }

    @Transactional
    public SettingsResponse getLanDeviceSettings(Integer lanDeviceId) throws InvalidSessionException {
        return this.getLanDeviceSettings(lanDeviceId, null);
    }

    private GenericLanDevice getLanDeviceDriver(LanDeviceEntity device) {
        return this.deviceDriverFactory.getDriver(device);
    }

    /*
     * Exception decompiling
     */
    private LanDevice.LanDeviceStatus getSettingsStatus(LanDeviceEntity device) throws InvalidSessionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private SaveResponse updateLanDeviceSettings(LanDeviceEntity device, LanDevice settings, String appleDeviceId) throws InvalidSessionException {
        log.debug((Object)("start updateLanDeviceSettings(device=" + device + ", settings=" + settings + ", appleDeviceId=" + appleDeviceId + ")"));
        if (device == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        boolean deviceChanged = this.changedParams(settings, device);
        GenericLanDevice driver = this.getLanDeviceDriver(device);
        String iphoneNotificationValue = this.extractIPhoneNotificationFromLanDeviceParams(settings);
        if (!this.updateEventNotification(device, appleDeviceId, Boolean.valueOf(deviceChanged), iphoneNotificationValue)) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        this.synchronizeParams(settings, device, driver);
        if (deviceChanged) {
            device.setModifiedDate(new Date());
        }
        log.debug((Object)(">>>>> updating lan device: " + device.dump()));
        LanDeviceEntity updatedDevice = this.lanDeviceDAO.updateLanDeviceWithTransaction(device);
        if (updatedDevice == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        driver.updateSettings(updatedDevice);
        return new SaveResponse(SaveResponse.SaveStatus.SAVED);
    }

    private boolean updateEventNotification(LanDeviceEntity device, String appleDeviceId, Boolean deviceChanged, String iphoneNotificationValue) {
        if (appleDeviceId != null) {
            EventNotificationEntity eventNotification = this.eventNotificationDAO.findEventNotificationsByLanDeviceIdAndToken(device.getLanDeviceId(), appleDeviceId);
            if (this.iPhoneNotificationIsOn(iphoneNotificationValue)) {
                if (eventNotification == null) {
                    deviceChanged = true;
                    EventNotificationEntity newEventNotification = new EventNotificationEntity();
                    newEventNotification.setLanDevice(device);
                    if (this.isHex(appleDeviceId)) {
                        newEventNotification.setNotificationType(EventNotificationType.APNS.name());
                    } else {
                        newEventNotification.setNotificationType(EventNotificationType.C2DM.name());
                    }
                    newEventNotification.setToken(appleDeviceId);
                    EventNotificationEntity savedEventNotification = this.eventNotificationDAO.createEventNotificationWithTransaction(newEventNotification);
                    if (savedEventNotification == null || savedEventNotification.getEventnotificationId() == null) {
                        log.debug((Object)("Event notifcation has not been saved: " + savedEventNotification));
                        return false;
                    }
                }
            } else {
                deviceChanged = true;
                if (eventNotification != null) {
                    this.eventNotificationDAO.removeEventNotificationWithTransaction(eventNotification);
                }
            }
        }
        return true;
    }

    private boolean iPhoneNotificationIsOn(String iphoneNotificationValue) {
        return iphoneNotificationValue != null && iphoneNotificationValue.equals("ON");
    }

    private String extractIPhoneNotificationFromLanDeviceParams(LanDevice settings) {
        String iphoneNotificationValue = null;
        ArrayList newParamsFromSettings = new ArrayList(settings.getLanDeviceParams());
        for (LanDeviceParam newParam : newParamsFromSettings) {
            if (!"iphone_notification".equals(newParam.getName())) continue;
            iphoneNotificationValue = newParam.getValue();
            log.debug((Object)("IPHONE_NOTIFICATION param value: " + iphoneNotificationValue));
            newParamsFromSettings.remove(newParam);
            break;
        }
        settings.setLanDeviceParams(newParamsFromSettings);
        return iphoneNotificationValue;
    }

    private boolean isHex(String code) {
        return code.matches("[0-9A-Fa-f]+");
    }

    public SaveResponse updateLanDeviceSettings(Integer lanDeviceId, LanDevice settings, String appleDeviceId) throws InvalidSessionException {
        log.debug((Object)("start updateLanDeviceSettings(lanDeviceId=" + lanDeviceId + ", settings=" + settings + ", appleDeviceId=" + appleDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceByIdAndUserId(lanDeviceId, this.authUtils.getCurrentUserId());
        return this.updateLanDeviceSettings(device, settings, appleDeviceId);
    }

    @Transactional
    public SaveResponse updateSharedLanDeviceName(Integer lanDeviceId, String lanDeviceName) throws InvalidSessionException {
        log.debug((Object)("start updateSharedLanDeviceSettings(lanDeviceId=" + lanDeviceId + ", settings=" + lanDeviceName + ")"));
        this.authUtils.ensureLoggedIn();
        ShareEntity shareEntity = this.shareDAO.findSharesByLanDeviceIdAndUserId(lanDeviceId, this.authUtils.getCurrentUserId());
        if (shareEntity == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        shareEntity.setName(lanDeviceName);
        ShareEntity updatedShareEntity = this.shareDAO.update(shareEntity);
        if (updatedShareEntity == null) {
            return new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
        }
        return new SaveResponse(SaveResponse.SaveStatus.SAVED);
    }

    public SaveResponse updateLanDeviceSettings(Integer lanDeviceId, LanDevice settings) throws InvalidSessionException {
        return this.updateLanDeviceSettings(lanDeviceId, settings, null);
    }

    @Transactional
    public SaveResponse updateLanDeviceSettingsAsAdmin(Integer lanDeviceId, LanDevice settings) throws InvalidSessionException {
        log.debug((Object)("start updateLanDeviceSettingsWithAdmin(lanDeviceId=" + lanDeviceId + ", settings=" + settings + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        return this.updateLanDeviceSettings(device, settings, null);
    }

    private void synchronizeParams(LanDevice settings, LanDeviceEntity device, GenericLanDevice driver) {
        WlanAccessPoint wlanAccessPoint;
        if (settings.getName() != null) {
            device.setName(settings.getName());
        }
        if (settings.getLocation() != null) {
            device.setLocation(settings.getLocation());
        }
        if (settings.getDescription() != null) {
            device.setDescription(settings.getDescription());
        }
        if (settings.getMac() != null) {
            device.setMac(settings.getMac());
        }
        if (settings.getIpAddress() != null) {
            device.setIpAddress(settings.getIpAddress());
        }
        if (settings.getPort() != null) {
            device.setPort(settings.getPort());
        }
        if (settings.getVersion() != null) {
            device.setVersion(settings.getVersion());
        }
        if (settings.getValidTo() != null && this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)) {
            device.setValidTo(settings.getValidTo());
        }
        if (settings.getDeleted() != null) {
            if (settings.getDeleted().booleanValue() && !device.getDeleted()) {
                device.setDeleted(true);
                device.setDeletedDate(new Date());
            } else if (!settings.getDeleted().booleanValue() && device.getDeleted()) {
                device.setDeleted(false);
                device.setAddedDate(new Date());
            }
        }
        if (settings.isConfigurationStatusChanged() && settings.getConfigurationStatus() != null) {
            device.setConfigurationStatus(settings.getConfigurationStatus());
        }
        HashMap<String, LanDeviceParamEntity> deviceParams = new HashMap<String, LanDeviceParamEntity>();
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            deviceParams.put(param.getName(), param);
        }
        device.getLanDeviceParams().clear();
        for (LanDeviceParamEntity param : settings.getLanDeviceParams()) {
            log.info((Object)(">>>>> heh: " + param));
            this.synchronizeParam(deviceParams, (LanDeviceParam)param, device);
        }
        boolean wifiSupported = device.hasParam("wifi_ssid");
        if (wifiSupported && (wlanAccessPoint = settings.getWlanAccessPoint()) != null && wlanAccessPoint.getEncryptionModes() != null) {
            deviceParams.clear();
            for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
                deviceParams.put(param.getName(), param);
            }
            String wlanMode = wlanAccessPoint.getWlanMode() == null ? "" : wlanAccessPoint.getWlanMode().toString();
            this.synchronizeParam(deviceParams, "wifi_wlan_mode", wlanMode, device);
            this.synchronizeParam(deviceParams, "wifi_ssid", wlanAccessPoint.getSsid(), device);
            this.synchronizeParam(deviceParams, "wifi_bssid", wlanAccessPoint.getBssid(), device);
            String channel = wlanAccessPoint.getChannel() != null ? wlanAccessPoint.getChannel().toString() : "";
            this.synchronizeParam(deviceParams, "wifi_channel", channel, device);
            EncryptionMode encryptionMode = this.getEncryptionMode(wlanAccessPoint);
            String encryption = encryptionMode.getEncryption() == null ? "" : encryptionMode.getEncryption().toString();
            this.synchronizeParam(deviceParams, "wifi_encryption", encryption, device);
            String algorithm = encryptionMode.getAlgorithm() == null ? "" : encryptionMode.getAlgorithm().toString();
            this.synchronizeParam(deviceParams, "wifi_alghoritm", algorithm, device);
            if (encryptionMode.getEncryption() == EncryptionMode.Encryption.WEP) {
                this.synchronizeParam(deviceParams, "wifi_wep_auth_mode", WepAuthenticationType.OPEN.name(), device);
                this.synchronizeParam(deviceParams, "wifi_wep_key_length", WepKeyLength.LENGTH_128_BITS.name(), device);
                this.synchronizeParam(deviceParams, "wifi_wep_key_format", WepKeyFormat.HEX.name(), device);
                this.synchronizeParam(deviceParams, "wifi_wep_key1", settings.getWlanAccessPointPassword(), device);
                this.synchronizeParam(deviceParams, "wifi_wep_key2", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key3", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key4", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_default_key", "1", device);
                this.synchronizeParam(deviceParams, "wifi_pre_shared_key", "", device);
            } else if (encryptionMode.getEncryption() == EncryptionMode.Encryption.OPEN) {
                this.synchronizeParam(deviceParams, "wifi_wep_auth_mode", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key_length", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key_format", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key1", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key2", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key3", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key4", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_default_key", "", device);
                this.synchronizeParam(deviceParams, "wifi_pre_shared_key", "", device);
            } else {
                this.synchronizeParam(deviceParams, "wifi_wep_auth_mode", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key_length", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key_format", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key1", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key2", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key3", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_key4", "", device);
                this.synchronizeParam(deviceParams, "wifi_wep_default_key", "", device);
                this.synchronizeParam(deviceParams, "wifi_pre_shared_key", settings.getWlanAccessPointPassword(), device);
            }
        }
    }

    private void synchronizeParam(Map<String, LanDeviceParamEntity> deviceParams, LanDeviceParam param, LanDeviceEntity device) {
        LanDeviceParamEntity newParam = deviceParams.get(param.getName());
        log.trace((Object)("processing param from db: " + newParam));
        log.trace((Object)("processing param from ui: " + param));
        if (newParam == null) {
            newParam = new LanDeviceParamEntity();
            newParam.setName(param.getName());
            newParam.setValue(param.getValue());
            newParam.setRemoteValue(null);
            device.getLanDeviceParams().add(newParam);
            log.trace((Object)("new param: " + newParam));
        } else {
            this.isChanged(newParam.getValue(), param.getValue());
            newParam.setValue(param.getValue());
            device.getLanDeviceParams().add(newParam);
            deviceParams.remove(param.getName());
            log.trace((Object)("old param: " + newParam));
        }
    }

    private boolean isChanged(String newValue, String value) {
        if (newValue == null && value == null) {
            return false;
        }
        return newValue == null && value != null || newValue != null && value == null || !newValue.equals(value);
    }

    private void synchronizeParam(Map<String, LanDeviceParamEntity> deviceParams, String paramName, String paramValue, LanDeviceEntity device) {
        LanDeviceParamEntity newParam = deviceParams.get(paramName);
        log.trace((Object)("processing param: " + paramName + " ---> " + paramValue));
        if (newParam == null) {
            newParam = new LanDeviceParamEntity();
            newParam.setName(paramName);
            newParam.setValue(paramValue);
            newParam.setRemoteValue(null);
            device.getLanDeviceParams().add(newParam);
            log.trace((Object)("new param: " + newParam));
        } else {
            this.isChanged(newParam.getValue(), paramValue);
            newParam.setValue(paramValue);
            deviceParams.remove(paramName);
            log.trace((Object)("old param: " + newParam));
        }
    }

    private void clearWifiSettings(LanDeviceEntity device) {
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            if (!param.getName().contains("wifi")) continue;
            param.setValue("");
        }
    }

    private boolean changedParams(LanDevice settings, LanDeviceEntity device) {
        if (settings == null || settings.getLanDeviceParams() == null) {
            return false;
        }
        if (device == null || device.getLanDeviceParams() == null) {
            return false;
        }
        if (settings.getName() != null && !settings.getName().equals(device.getName())) {
            return true;
        }
        if (settings.getLocation() != null && !settings.getLocation().equals(device.getLocation())) {
            return true;
        }
        if (settings.getDescription() != null && !settings.getDescription().equals(device.getDescription())) {
            return true;
        }
        HashMap<String, String> settingsParams = new HashMap<String, String>();
        for (LanDeviceParam param : settings.getLanDeviceParams()) {
            settingsParams.put(param.getName(), param.getValue());
        }
        HashMap<String, String> deviceParams = new HashMap<String, String>();
        for (LanDeviceParamEntity param : device.getLanDeviceParams()) {
            deviceParams.put(param.getName(), param.getValue());
        }
        return !settingsParams.equals(deviceParams);
    }

    @Transactional
    public LanDevice.LanDeviceStatus getLanDeviceStatus(Integer ldId) throws InvalidSessionException {
        log.debug((Object)("start getLanDeviceStatus(ldId=" + ldId + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = this.lanDeviceService.getLanDeviceByIdWithAccessVerification(ldId);
        return this.getSettingsStatus(device);
    }

    private EncryptionMode getEncryptionMode(WlanAccessPoint wlanAccessPoint) {
        if (wlanAccessPoint == null) {
            return null;
        }
        if (wlanAccessPoint.getEncryptionModes() == null) {
            return null;
        }
        if (wlanAccessPoint.getWlanMode() == WlanAccessPoint.WlanMode.INFRASTRUCTURE) {
            if (this.containsEncryptionMode(wlanAccessPoint, EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP)) {
                return new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP);
            }
            if (this.containsEncryptionMode(wlanAccessPoint, EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.TKIP)) {
                return new EncryptionMode(EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.TKIP);
            }
            if (this.containsEncryptionMode(wlanAccessPoint, EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.AES_CCMP)) {
                return new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.AES_CCMP);
            }
            if (this.containsEncryptionMode(wlanAccessPoint, EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP)) {
                return new EncryptionMode(EncryptionMode.Encryption.WPA, EncryptionMode.Algorithm.TKIP);
            }
        }
        if (this.containsEncryptionMode(wlanAccessPoint, EncryptionMode.Encryption.WEP, EncryptionMode.Algorithm.WEP)) {
            return new EncryptionMode(EncryptionMode.Encryption.WEP, EncryptionMode.Algorithm.WEP);
        }
        if (this.containsEncryptionMode(wlanAccessPoint, EncryptionMode.Encryption.PASSPHRASE, EncryptionMode.Algorithm.UNKNOWN)) {
            return new EncryptionMode(EncryptionMode.Encryption.PASSPHRASE, EncryptionMode.Algorithm.UNKNOWN);
        }
        return new EncryptionMode(EncryptionMode.Encryption.OPEN, EncryptionMode.Algorithm.NONE);
    }

    private boolean containsEncryptionMode(WlanAccessPoint wlanAccessPoint, EncryptionMode.Encryption encryption, EncryptionMode.Algorithm algorithm) {
        log.debug((Object)("start containsEncryptionMode(wlanAccessPoint=" + wlanAccessPoint + ", encryption=" + encryption + ", algorithm=" + algorithm + ")"));
        for (EncryptionMode mode : wlanAccessPoint.getEncryptionModes()) {
            if (mode.getEncryption() != encryption || mode.getAlgorithm() != algorithm) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus() {
        if ($SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus != null) {
            return $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus;
        }
        int[] nArray = new int[AccessVerificationStatus.values().length];
        try {
            nArray[AccessVerificationStatus.ERROR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.NOACCESS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.NOANSWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.NOT_SUPPORTED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus = nArray;
        return nArray;
    }
}

