/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.QuotasManagingService;
import pl.smartapps.restserver.service.ScheduledTaskService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.notification.impl.InactiveAppleDeviceService;
import pl.smartapps.restserver.util.MasterInhibitor;

@Service
public class ScheduledTaskServiceImpl
implements ScheduledTaskService {
    private static Logger log = Logger.getLogger(ScheduledTaskServiceImpl.class);
    private LanDeviceService lanDeviceService;
    private InactiveAppleDeviceService inactiveAppleDeviceService;
    private QuotasManagingService quotasManagingService;

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setInactiveAppleDeviceService(InactiveAppleDeviceService inactiveAppleDeviceService) {
        this.inactiveAppleDeviceService = inactiveAppleDeviceService;
    }

    @Autowired
    @Required
    public void setQuotasManagingService(QuotasManagingService quotasManagingService) {
        this.quotasManagingService = quotasManagingService;
    }

    public void execute() {
        if (!MasterInhibitor.canPerformMasterTask()) {
            return;
        }
        try {
            this.lanDeviceService.manageDevicesProduct();
        }
        catch (InvalidSessionException ex) {
            log.warn((Object)("Failed to manage devices product: " + ex.getMessage()));
        }
        this.lanDeviceService.notifyDeviceValidityExpiryApproach();
        this.inactiveAppleDeviceService.deleteInactiveDevices();
        try {
            this.quotasManagingService.manageQuatas();
        }
        catch (InvalidSessionException ex) {
            log.warn((Object)("Failed to manage quotas: " + ex.getMessage()));
        }
        this.lanDeviceService.updateIpAddresses();
    }
}

