/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.Date;
import org.easymock.EasyMock;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.QuotasManagingServiceImpl;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={QuotasManagingServiceImpl.class})
public class QuotasManagingServiceTests {
    private QuotasManagingServiceImpl quotasManagingService;
    private ProductManagementService productManagementService;
    private SystemSupport systemSupport;
    private EventDAO eventDAO;
    private LanDeviceDAO lanDeviceDAO;
    private EventsFilesController eventsFilesController;

    @Before
    public void setUp() {
        this.quotasManagingService = new QuotasManagingServiceImpl();
        this.productManagementService = (ProductManagementService)PowerMock.createMock(ProductManagementService.class);
        this.quotasManagingService.setProductManagementService(this.productManagementService);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.quotasManagingService.setSystemSupport(this.systemSupport);
        this.eventDAO = (EventDAO)PowerMock.createMock(EventDAO.class);
        this.quotasManagingService.setEventDAO(this.eventDAO);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.quotasManagingService.setLanDeviceDAO(this.lanDeviceDAO);
        this.eventsFilesController = (EventsFilesController)PowerMock.createMock(EventsFilesController.class);
        this.quotasManagingService.setEventsFilesController(this.eventsFilesController);
    }

    @Test
    public void testManageQuotasForExceededCountQuotaAndExceededSizeQuota() throws InvalidSessionException {
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(new LanDeviceEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(devices);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_COUNT)).andReturn((Object)"5");
        EasyMock.expect((Object)this.eventDAO.countDeviceEvents(Integer.valueOf(1))).andReturn((Object)9L);
        ArrayList<EventEntity> quotaCountEvents = new ArrayList<EventEntity>();
        Date event1Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)16, (int)25);
        quotaCountEvents.add(this.createEvent(Integer.valueOf(1), event1Date, Integer.valueOf(5432456), false, null, false));
        Date event2Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)17, (int)25);
        quotaCountEvents.add(this.createEvent(Integer.valueOf(2), event2Date, null, false, null, false));
        Date event3Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)18, (int)25);
        quotaCountEvents.add(this.createEvent(Integer.valueOf(3), event3Date, Integer.valueOf(0), false, null, false));
        Date event4Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)19, (int)25);
        Date event4VideoDeletedDate = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)34, (int)11);
        quotaCountEvents.add(this.createEvent(Integer.valueOf(4), event4Date, Integer.valueOf(5432456), true, event4VideoDeletedDate, false));
        EasyMock.expect((Object)this.eventDAO.findDeviceEvents(Integer.valueOf(1), Integer.valueOf(4))).andReturn(quotaCountEvents);
        Date event1VideoDeletedDate = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)37, (int)22);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)event1VideoDeletedDate);
        this.testDeleteFile("20111013091625_1.flv");
        this.testDeleteFile("20111013091625_1.mp4");
        this.testDeleteFile("20111013091625_1.jpg");
        EventEntity event1 = this.createEvent(Integer.valueOf(1), event1Date, Integer.valueOf(5432456), true, event1VideoDeletedDate, true);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event1)).andReturn((Object)event1);
        this.testDeleteFile("20111013091725_2.jpg");
        EventEntity event2 = this.createEvent(Integer.valueOf(2), event2Date, null, false, null, true);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event2)).andReturn((Object)event2);
        this.testDeleteFile("20111013091825_3.jpg");
        EventEntity event3 = this.createEvent(Integer.valueOf(3), event3Date, Integer.valueOf(0), false, null, true);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event3)).andReturn((Object)event3);
        this.testDeleteFile("20111013091925_4.jpg");
        EventEntity event4 = this.createEvent(Integer.valueOf(4), event4Date, Integer.valueOf(5432456), true, event4VideoDeletedDate, true);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event4)).andReturn((Object)event4);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_SIZE)).andReturn((Object)"10");
        EasyMock.expect((Object)this.eventDAO.sumDeviceVideoFileSize(Integer.valueOf(1))).andReturn((Object)15456865L);
        ArrayList<EventEntity> quotaSizeEvents = new ArrayList<EventEntity>();
        Date event5Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)6, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(5), event5Date, Integer.valueOf(2687215), false, null, false));
        Date event6Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)7, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(6), event6Date, Integer.valueOf(2769650), false, null, false));
        Date event7Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)8, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(7), event7Date, Integer.valueOf(123), false, null, false));
        Date event8Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)9, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(8), event8Date, Integer.valueOf(123), false, null, false));
        EasyMock.expect((Object)this.eventDAO.findDeviceEventsWithVideo(Integer.valueOf(1))).andReturn(quotaSizeEvents);
        this.testDeleteFile("20111013100655_5.flv");
        this.testDeleteFile("20111013100655_5.mp4");
        Date event5DeletedVideoDate = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)16, (int)49);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)event5DeletedVideoDate);
        EventEntity event5 = this.createEvent(Integer.valueOf(5), event5Date, Integer.valueOf(2687215), true, event5DeletedVideoDate, false);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event5)).andReturn((Object)event5);
        this.testDeleteFile("20111013100755_6.flv");
        this.testDeleteFile("20111013100755_6.mp4");
        Date event6DeletedVideoDate = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)16, (int)55);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)event6DeletedVideoDate);
        EventEntity event6 = this.createEvent(Integer.valueOf(6), event6Date, Integer.valueOf(2769650), true, event6DeletedVideoDate, false);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event6)).andReturn((Object)event6);
        EasyMock.expect((Object)this.eventDAO.findDeviceDeletedEventsWithVideo(Integer.valueOf(1))).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        this.quotasManagingService.manageQuatas();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageQuotasForNullDevices() throws InvalidSessionException {
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.quotasManagingService.manageQuatas();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageQuotasForNoDeviceFound() throws InvalidSessionException {
        ArrayList devices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        this.quotasManagingService.manageQuatas();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageQuotasUnlimitedCountQuotaAndUnlimitedSizeQuota() throws InvalidSessionException {
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(new LanDeviceEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(devices);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_COUNT)).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_SIZE)).andReturn(null);
        EasyMock.expect((Object)this.eventDAO.findDeviceDeletedEventsWithVideo(Integer.valueOf(1))).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        this.quotasManagingService.manageQuatas();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageQuotasForNotExceededCountQuotaAndNotExceededSizeQuota() throws InvalidSessionException {
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(new LanDeviceEntity(Integer.valueOf(1)));
        devices.add(new LanDeviceEntity(Integer.valueOf(2)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(devices);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_COUNT)).andReturn((Object)"10");
        EasyMock.expect((Object)this.eventDAO.countDeviceEvents(Integer.valueOf(1))).andReturn((Object)9L);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_SIZE)).andReturn((Object)"16");
        EasyMock.expect((Object)this.eventDAO.sumDeviceVideoFileSize(Integer.valueOf(1))).andReturn((Object)15456865L);
        EasyMock.expect((Object)this.eventDAO.findDeviceDeletedEventsWithVideo(Integer.valueOf(1))).andReturn(new ArrayList());
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(2), DeviceFeatureCode.STORAGE_QUOTA_COUNT)).andReturn((Object)"12");
        EasyMock.expect((Object)this.eventDAO.countDeviceEvents(Integer.valueOf(2))).andReturn((Object)11L);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(2), DeviceFeatureCode.STORAGE_QUOTA_SIZE)).andReturn((Object)"20");
        EasyMock.expect((Object)this.eventDAO.sumDeviceVideoFileSize(Integer.valueOf(2))).andReturn((Object)19999999L);
        EasyMock.expect((Object)this.eventDAO.findDeviceDeletedEventsWithVideo(Integer.valueOf(2))).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        this.quotasManagingService.manageQuatas();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageQuotasForSlightlyExceededCountQuotaAndSlightlyExceededSizeQuota() throws InvalidSessionException {
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(new LanDeviceEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(devices);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_COUNT)).andReturn((Object)"10");
        EasyMock.expect((Object)this.eventDAO.countDeviceEvents(Integer.valueOf(1))).andReturn((Object)11L);
        ArrayList<EventEntity> quotaCountEvents = new ArrayList<EventEntity>();
        Date event1Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)16, (int)25);
        quotaCountEvents.add(this.createEvent(Integer.valueOf(1), event1Date, Integer.valueOf(5432456), false, null, false));
        EasyMock.expect((Object)this.eventDAO.findDeviceEvents(Integer.valueOf(1), Integer.valueOf(1))).andReturn(quotaCountEvents);
        Date event1VideoDeletedDate = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)37, (int)22);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)event1VideoDeletedDate);
        this.testDeleteFile("20111013091625_1.flv");
        this.testDeleteFile("20111013091625_1.mp4");
        this.testDeleteFile("20111013091625_1.jpg");
        EventEntity event1 = this.createEvent(Integer.valueOf(1), event1Date, Integer.valueOf(5432456), true, event1VideoDeletedDate, true);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event1)).andReturn((Object)event1);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_SIZE)).andReturn((Object)"15");
        EasyMock.expect((Object)this.eventDAO.sumDeviceVideoFileSize(Integer.valueOf(1))).andReturn((Object)15000001L);
        ArrayList<EventEntity> quotaSizeEvents = new ArrayList<EventEntity>();
        Date event5Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)6, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(5), event5Date, Integer.valueOf(2687215), false, null, false));
        Date event6Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)7, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(6), event6Date, Integer.valueOf(2769650), false, null, false));
        Date event7Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)8, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(7), event7Date, Integer.valueOf(123), false, null, false));
        Date event8Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)9, (int)55);
        quotaSizeEvents.add(this.createEvent(Integer.valueOf(8), event8Date, Integer.valueOf(123), false, null, false));
        EasyMock.expect((Object)this.eventDAO.findDeviceEventsWithVideo(Integer.valueOf(1))).andReturn(quotaSizeEvents);
        this.testDeleteFile("20111013100655_5.flv");
        this.testDeleteFile("20111013100655_5.mp4");
        Date event5DeletedVideoDate = Utils.constructDate((int)2011, (int)10, (int)13, (int)10, (int)16, (int)49);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)event5DeletedVideoDate);
        EventEntity event5 = this.createEvent(Integer.valueOf(5), event5Date, Integer.valueOf(2687215), true, event5DeletedVideoDate, false);
        EasyMock.expect((Object)this.eventDAO.updateEvent(event5)).andReturn((Object)event5);
        EasyMock.expect((Object)this.eventDAO.findDeviceDeletedEventsWithVideo(Integer.valueOf(1))).andReturn(new ArrayList());
        PowerMock.replayAll((Object[])new Object[0]);
        this.quotasManagingService.manageQuatas();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageQuotasDeleteFilesOfDeletedEvents() throws InvalidSessionException {
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(new LanDeviceEntity(Integer.valueOf(1)));
        devices.add(new LanDeviceEntity(Integer.valueOf(2)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(devices);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_COUNT)).andReturn((Object)"10");
        EasyMock.expect((Object)this.eventDAO.countDeviceEvents(Integer.valueOf(1))).andReturn((Object)9L);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.STORAGE_QUOTA_SIZE)).andReturn((Object)"16");
        EasyMock.expect((Object)this.eventDAO.sumDeviceVideoFileSize(Integer.valueOf(1))).andReturn((Object)15456865L);
        EasyMock.expect((Object)this.eventDAO.findDeviceDeletedEventsWithVideo(Integer.valueOf(1))).andReturn(new ArrayList());
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(2), DeviceFeatureCode.STORAGE_QUOTA_COUNT)).andReturn((Object)"12");
        EasyMock.expect((Object)this.eventDAO.countDeviceEvents(Integer.valueOf(2))).andReturn((Object)11L);
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(2), DeviceFeatureCode.STORAGE_QUOTA_SIZE)).andReturn((Object)"20");
        EasyMock.expect((Object)this.eventDAO.sumDeviceVideoFileSize(Integer.valueOf(2))).andReturn((Object)19999999L);
        ArrayList<EventEntity> events = new ArrayList<EventEntity>();
        Date date = new Date();
        EventEntity event1 = (EventEntity)PowerMock.createMock(EventEntity.class);
        EventEntity event2 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event1);
        events.add(event2);
        EasyMock.expect((Object)this.eventDAO.findDeviceDeletedEventsWithVideo(Integer.valueOf(2))).andReturn(events);
        Date event1Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)16, (int)25);
        Date event2Date = Utils.constructDate((int)2011, (int)10, (int)13, (int)9, (int)17, (int)25);
        event1.setDeletedVideo(true);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)date);
        event1.setDeletedVideoDate(date);
        EasyMock.expect((Object)event1.getDateEvent()).andReturn((Object)event1Date);
        EasyMock.expect((Object)event1.getEventId()).andReturn((Object)1);
        this.testDeleteFile("20111013091625_1.flv");
        EasyMock.expect((Object)event1.getDateEvent()).andReturn((Object)event1Date);
        EasyMock.expect((Object)event1.getEventId()).andReturn((Object)1);
        this.testDeleteFile("20111013091625_1.mp4");
        EasyMock.expect((Object)event1.getDateEvent()).andReturn((Object)event1Date);
        EasyMock.expect((Object)event1.getEventId()).andReturn((Object)1);
        this.testDeleteFile("20111013091625_1.jpg");
        EasyMock.expect((Object)this.eventDAO.updateEvent(event1)).andReturn((Object)event1);
        event2.setDeletedVideo(true);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)date);
        event2.setDeletedVideoDate(date);
        EasyMock.expect((Object)event2.getDateEvent()).andReturn((Object)event2Date);
        EasyMock.expect((Object)event2.getEventId()).andReturn((Object)2);
        this.testDeleteFile("20111013091725_2.flv");
        EasyMock.expect((Object)event2.getDateEvent()).andReturn((Object)event2Date);
        EasyMock.expect((Object)event2.getEventId()).andReturn((Object)2);
        this.testDeleteFile("20111013091725_2.mp4");
        EasyMock.expect((Object)event2.getDateEvent()).andReturn((Object)event2Date);
        EasyMock.expect((Object)event2.getEventId()).andReturn((Object)2);
        this.testDeleteFile("20111013091725_2.jpg");
        EasyMock.expect((Object)this.eventDAO.updateEvent(event2)).andReturn((Object)event2);
        PowerMock.replayAll((Object[])new Object[0]);
        this.quotasManagingService.manageQuatas();
        PowerMock.verifyAll();
    }

    private void testDeleteFile(String fileName) {
        EasyMock.expect((Object)this.eventsFilesController.deleteFile(fileName)).andReturn((Object)true);
    }

    private EventEntity createEvent(Integer eventId, Date dateEvent, Integer videoFileSize, boolean deletedVideo, Date deletedVideoDate, boolean deleted) {
        EventEntity event = new EventEntity();
        event.setEventId(eventId);
        event.setDateEvent(dateEvent);
        event.setVideoFileSize(videoFileSize);
        event.setDeletedVideo(deletedVideo);
        event.setDeletedVideoDate(deletedVideoDate);
        event.setDeleted(deleted);
        return event;
    }
}

