/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.Date;
import java.util.List;
import javax.annotation.PostConstruct;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.QuotasManagingService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.EventsFilesControllerFactory;
import pl.smartapps.restserver.util.Utils;

@Service
public class QuotasManagingServiceImpl
implements QuotasManagingService {
    private static Logger log = Logger.getLogger(QuotasManagingServiceImpl.class);
    private ProductManagementService productManagementService;
    private SystemSupport systemSupport;
    private EventDAO eventDAO;
    private EventsFilesControllerFactory eventsFilesControllerFactory;
    private EventsFilesController eventsFilesController;
    private LanDeviceDAO lanDeviceDAO;

    @Autowired
    @Required
    public void setProductManagementService(ProductManagementService productManagementService) {
        this.productManagementService = productManagementService;
    }

    @Autowired
    @Required
    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    @Autowired
    @Required
    public void setEventsFilesControllerFactory(EventsFilesControllerFactory eventsFilesControllerFactory) {
        this.eventsFilesControllerFactory = eventsFilesControllerFactory;
    }

    public void setEventsFilesController(EventsFilesController eventsFilesController) {
        this.eventsFilesController = eventsFilesController;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @PostConstruct
    public void init() {
        this.eventsFilesController = this.eventsFilesControllerFactory.getEventsFilesController();
    }

    public void manageQuatas() throws InvalidSessionException {
        log.trace((Object)"start manageQuatas()");
        Integer firstResult = 0;
        Integer maxResult = 100;
        List devices = null;
        do {
            if ((devices = this.lanDeviceDAO.findNotDeletedLanDevices(firstResult, maxResult)) == null) {
                return;
            }
            firstResult = firstResult + devices.size();
            for (LanDeviceEntity device : devices) {
                this.enforceStorageQuotaCount(device);
                this.enforceStorageQuotaSize(device);
                this.deleteFilesOfDeletedEvents(device);
            }
        } while (devices.size() == maxResult.intValue());
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void enforceStorageQuotaCount(LanDeviceEntity device) throws InvalidSessionException {
        Integer storageQuotaCount = this.getStorageQuotaCount(device);
        if (storageQuotaCount == null) {
            log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " can have unlimited number of events."));
            return;
        }
        Integer eventsCount = this.eventDAO.countDeviceEvents(device.getLanDeviceId()).intValue();
        if (eventsCount > storageQuotaCount) {
            log.debug((Object)("Exceeded storage quota count on device with lanDeviceId=" + device.getLanDeviceId() + "."));
            List events = this.eventDAO.findDeviceEvents(device.getLanDeviceId(), Integer.valueOf(eventsCount - storageQuotaCount));
            for (EventEntity event : events) {
                log.debug((Object)("Processing event: " + event));
                if (event.getVideoFileSize() != null && event.getVideoFileSize() > 0 && !event.getDeletedVideo()) {
                    log.debug((Object)"Event still keeps a video file. The video file will be deleted.");
                    event.setDeletedVideo(true);
                    event.setDeletedVideoDate(this.systemSupport.getCurrentDate());
                    this.deleteEventVideoFiles(event);
                }
                event.setDeleted(true);
                if (!this.deleteEventFile(event, "jpg")) {
                    log.warn((Object)("Could not delete file '" + this.prepareFilename(event, "jpg") + "' for event with eventId=" + event.getEventId()));
                }
                this.eventDAO.updateEvent(event);
            }
        }
    }

    private void enforceStorageQuotaSize(LanDeviceEntity device) throws InvalidSessionException {
        Integer storageQuotaSize = this.getStorageQuotaSize(device);
        if (storageQuotaSize == null) {
            log.debug((Object)("Device ith lanDeviceId=" + device.getLanDeviceId() + " have unlimited storage space for video."));
            return;
        }
        Long videoFilesSize = this.eventDAO.sumDeviceVideoFileSize(device.getLanDeviceId());
        if (videoFilesSize > (long)storageQuotaSize.intValue()) {
            log.debug((Object)("Exceeded storage quota size for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            List events = this.eventDAO.findDeviceEventsWithVideo(device.getLanDeviceId());
            Long sizeDiff = videoFilesSize - (long)storageQuotaSize.intValue();
            log.debug((Object)("initial size diff: " + sizeDiff));
            for (EventEntity event : events) {
                log.debug((Object)("Processing event: " + event));
                event.setDeletedVideo(true);
                event.setDeletedVideoDate(this.systemSupport.getCurrentDate());
                this.deleteEventVideoFiles(event);
                this.eventDAO.updateEvent(event);
                sizeDiff = sizeDiff - (long)event.getVideoFileSize().intValue();
                log.debug((Object)("current size diff: " + sizeDiff));
                if (sizeDiff <= 0L) break;
            }
        }
    }

    private void deleteFilesOfDeletedEvents(LanDeviceEntity device) throws InvalidSessionException {
        List events = this.eventDAO.findDeviceDeletedEventsWithVideo(device.getLanDeviceId());
        for (EventEntity event : events) {
            log.debug((Object)("Processing event: " + event));
            event.setDeletedVideo(true);
            event.setDeletedVideoDate(this.systemSupport.getCurrentDate());
            this.deleteEventVideoFiles(event);
            if (!this.deleteEventFile(event, "jpg")) {
                log.warn((Object)("Could not delete file '" + this.prepareFilename(event, "jpg") + "' for event with eventId=" + event.getEventId()));
            }
            this.eventDAO.updateEvent(event);
        }
    }

    private Integer getStorageQuotaSize(LanDeviceEntity device) throws InvalidSessionException {
        String quotaSizeText = this.productManagementService.getDeviceFeatureValue(device.getLanDeviceId(), DeviceFeatureCode.STORAGE_QUOTA_SIZE);
        if (quotaSizeText == null) {
            return null;
        }
        return Integer.parseInt(quotaSizeText) * 1000000;
    }

    private Integer getStorageQuotaCount(LanDeviceEntity device) throws InvalidSessionException {
        String quotaCountText = this.productManagementService.getDeviceFeatureValue(device.getLanDeviceId(), DeviceFeatureCode.STORAGE_QUOTA_COUNT);
        if (quotaCountText == null) {
            return null;
        }
        return Integer.parseInt(quotaCountText);
    }

    private void deleteEventVideoFiles(EventEntity event) {
        String flvVideoFilename = this.prepareFilename(event, "flv");
        this.deleteFile(flvVideoFilename);
        String mp4VideoFilename = this.prepareFilename(event, "mp4");
        if (!this.deleteFile(mp4VideoFilename)) {
            log.warn((Object)("Could not delete file '" + mp4VideoFilename + "' for event with eventId=" + event.getEventId()));
        }
    }

    private boolean deleteEventFile(EventEntity event, String fileExtension) {
        return this.deleteFile(this.prepareFilename(event, fileExtension));
    }

    private String prepareFilename(EventEntity event, String fileExtension) {
        StringBuilder filename = new StringBuilder();
        filename.append(Utils.formatDate((Date)event.getDateEvent(), (String)"yyyyMMddHHmmss"));
        filename.append("_").append(event.getEventId()).append(".").append(fileExtension);
        return filename.toString();
    }

    private boolean deleteFile(String filename) {
        return this.eventsFilesController.deleteFile(filename);
    }
}

