/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.LanDeviceProductlogDAO;
import pl.smartapps.restserver.db.dao.ProductDAO;
import pl.smartapps.restserver.db.dao.ProductFeatureDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.dao.UserproductlogDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceProductlogEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.db.main.UserproductlogEntity;
import pl.smartapps.restserver.rest.response.GetAccountResponse;
import pl.smartapps.restserver.rest.response.UpdateAccountStatus;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;

@Service
public class ProductManagementServiceImpl
implements ProductManagementService {
    private static Logger log = Logger.getLogger(ProductManagementServiceImpl.class);
    private AuthenticationUtils authUtils;
    private ProductDAO productDAO;
    private ProductFeatureDAO productFeatureDAO;
    private UserproductlogDAO userproductlogDAO;
    private UserDAO userDAO;
    private ParameterService parameterService;
    private SystemSupport systemSupport;
    private LanDeviceDAO lanDeviceDAO;
    private LanDeviceProductlogDAO lanDeviceProductlogDAO;

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setProductDAO(ProductDAO productDAO) {
        this.productDAO = productDAO;
    }

    @Autowired
    @Required
    public void setProductFeatureDAO(ProductFeatureDAO productFeatureDAO) {
        this.productFeatureDAO = productFeatureDAO;
    }

    @Autowired
    @Required
    public void setUserproductlogDAO(UserproductlogDAO userproductlogDAO) {
        this.userproductlogDAO = userproductlogDAO;
    }

    @Autowired
    @Required
    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setLanDeviceProductlogDAO(LanDeviceProductlogDAO lanDeviceProductlogDAO) {
        this.lanDeviceProductlogDAO = lanDeviceProductlogDAO;
    }

    @Transactional(readOnly=true)
    public ProductEntity getDefaultProduct() {
        log.trace((Object)"start getDefaultProduct()");
        Integer defaultProductId = this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID);
        return this.productDAO.findProductById(defaultProductId);
    }

    @Transactional(readOnly=true)
    public String getFeatureValue(Integer productId, DeviceFeatureCode featureCode) {
        if (productId == null) {
            return null;
        }
        if (featureCode == null) {
            return null;
        }
        ProductfeatureEntity productfeature = this.productFeatureDAO.findProductfeature(productId, featureCode.name());
        return productfeature == null ? null : productfeature.getFeatureValue();
    }

    @Transactional(readOnly=true)
    public String getFeatureValue(Integer productId, UserFeatureCode featureCode) {
        if (productId == null) {
            return null;
        }
        if (featureCode == null) {
            return null;
        }
        ProductfeatureEntity productfeature = this.productFeatureDAO.findProductfeature(productId, featureCode.name());
        return productfeature == null ? null : productfeature.getFeatureValue();
    }

    @Transactional(readOnly=true)
    public String getUserFeatureValue(UserFeatureCode featureCode) throws InvalidSessionException {
        log.trace((Object)("start getFeatureValue(featureCode=" + featureCode + ")"));
        this.authUtils.ensureLoggedIn();
        return this.getUserFeatureValue(this.authUtils.getCurrentUserId(), featureCode);
    }

    @Transactional(readOnly=true)
    public String getUserFeatureValue(Integer userId, UserFeatureCode featureCode) {
        log.trace((Object)("start getFeatureValue(userId=" + userId + ", featureCode=" + featureCode + ")"));
        ProductfeatureEntity productfeature = this.productFeatureDAO.findUserProductfeature(userId, featureCode.name());
        return productfeature == null ? null : productfeature.getFeatureValue();
    }

    @Transactional(readOnly=true)
    public String getDeviceFeatureValue(Integer lanDeviceId, DeviceFeatureCode featureCode) {
        log.trace((Object)("start getFeatureValue(userId=" + lanDeviceId + ", featureCode=" + featureCode + ")"));
        ProductfeatureEntity productfeature = this.productFeatureDAO.findDeviceProductfeature(lanDeviceId, featureCode.name());
        return productfeature == null ? null : productfeature.getFeatureValue();
    }

    @Transactional
    public void logUserproduct(Integer userId, Integer productId) {
        log.trace((Object)("start logUserproduct(userId=" + userId + ", productId=" + productId + ")"));
        this.logUserproduct(this.userDAO.findUserById(userId), this.productDAO.findProductById(productId));
    }

    @Transactional
    public void logUserproduct(UserEntity user, ProductEntity product) {
        log.trace((Object)("start logUserproduct(user=" + user + ", product=" + product + ")"));
        if (user == null) {
            throw new IllegalArgumentException("User can not be null!");
        }
        if (product == null) {
            throw new IllegalArgumentException("Product can not be null!");
        }
        UserproductlogEntity userproductlog = new UserproductlogEntity();
        userproductlog.setProduct(product);
        userproductlog.setUser(user);
        userproductlog.setDateAdded(this.systemSupport.getCurrentDate());
        if (this.userproductlogDAO.save(userproductlog) == null) {
            log.warn((Object)("Userproduct log for user=" + user + " and product=" + product + " has not been saved!"));
        }
    }

    @Transactional
    public void logDeviceproduct(Integer lanDeviceId, Integer productId) {
        log.trace((Object)("start logLanDeviceproduct(lanDeviceId=" + lanDeviceId + ", productId=" + productId + ")"));
        this.logDeviceproduct(this.lanDeviceDAO.findLanDeviceById(lanDeviceId), this.productDAO.findProductById(productId));
    }

    @Transactional
    public void logDeviceproduct(LanDeviceEntity device, ProductEntity product) {
        log.trace((Object)("start logLanDeviceproduct(device=" + device + ", product=" + product + ")"));
        if (device == null) {
            throw new IllegalArgumentException("Device can not be null!");
        }
        if (product == null) {
            throw new IllegalArgumentException("Product can not be null!");
        }
        LanDeviceProductlogEntity productlog = new LanDeviceProductlogEntity();
        productlog.setLandevice(device);
        productlog.setProduct(product);
        productlog.setDateAdded(this.systemSupport.getCurrentDate());
        if (this.lanDeviceProductlogDAO.persist(productlog) == null) {
            log.warn((Object)("LanDeviceProductlog log for device with lanDeviceId=" + device.getLanDeviceId() + " and product with productId=" + product.getProductId() + " has not been saved!"));
        }
    }

    @Transactional(readOnly=true)
    public GetAccountResponse getAccount() throws InvalidSessionException {
        log.trace((Object)"start getAccount()");
        this.authUtils.ensureLoggedIn();
        UserEntity user = this.userDAO.findUserById(this.authUtils.getCurrentUserId());
        if (user == null) {
            log.warn((Object)("No user found for userId=" + this.authUtils.getCurrentUserId() + "."));
            return new GetAccountResponse(GetAccountResponse.GetAccountStatus.FAILED_USERNOTFOUND);
        }
        if (user.getProduct() == null) {
            log.warn((Object)("User '" + user.getUsername() + "' do not have assignet any product."));
            return new GetAccountResponse(GetAccountResponse.GetAccountStatus.FAILED_NONEPRODUCTASSIGNED);
        }
        return new GetAccountResponse(GetAccountResponse.GetAccountStatus.SUCCESS, user.getProduct().toDTO());
    }

    @Transactional
    public UpdateAccountStatus updateAccount(Integer userId, Integer productId) throws InvalidSessionException {
        log.trace((Object)("start updateAccount(userId=" + userId + ", productId=" + productId + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        UserEntity user = this.userDAO.findUserById(userId);
        if (user == null) {
            return UpdateAccountStatus.FAILED_USERNOTFOUND;
        }
        ProductEntity product = this.productDAO.findProductById(productId);
        if (product == null) {
            return UpdateAccountStatus.FAILED_PRODUCTNOTFOUND;
        }
        user.setProduct(product);
        UserEntity updatedUser = this.userDAO.updateUser(user);
        if (updatedUser != null) {
            this.logUserproduct(user, product);
            return UpdateAccountStatus.SUCCESS;
        }
        return UpdateAccountStatus.ERROR;
    }

    @Transactional(readOnly=true)
    public DeviceProduct.DeviceProductType getDeviceProductType(Integer lanDeviceId) {
        return this.getDeviceProductType(lanDeviceId, false);
    }

    @Transactional(readOnly=true)
    public DeviceProduct.DeviceProductType getDeviceProductType(Integer lanDeviceId, boolean deleted) {
        log.trace((Object)("start getDeviceProductType(lanDeviceId=" + lanDeviceId + ")"));
        if (lanDeviceId == null) {
            return null;
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId, deleted);
        if (device == null) {
            return null;
        }
        String productCode = device.getProduct().getCode();
        if (productCode.equals(this.getUserFeatureValue(device, UserFeatureCode.PRODUCT_BASIC))) {
            return DeviceProduct.DeviceProductType.BASIC;
        }
        if (productCode.equals(this.getUserFeatureValue(device, UserFeatureCode.PRODUCT_TRIAL))) {
            return DeviceProduct.DeviceProductType.TRIAL;
        }
        if (productCode.equals(this.getUserFeatureValue(device, UserFeatureCode.PRODUCT_PREMIUM))) {
            return DeviceProduct.DeviceProductType.PREMIUM;
        }
        return null;
    }

    private String getUserFeatureValue(LanDeviceEntity device, UserFeatureCode code) {
        return this.getUserFeatureValue(device.getUser().getId(), code);
    }

    @Transactional(readOnly=true)
    public ProductEntity getProduct(Integer userId, DeviceProduct.DeviceProductType deviceProduct) {
        log.trace((Object)("start getDeviceProduct(userId=" + userId + ", deviceProduct=" + deviceProduct + ")"));
        if (userId == null) {
            log.debug((Object)"Invalid userId: 'null'");
            return null;
        }
        if (deviceProduct == null) {
            log.debug((Object)"Invalid deviceProduct: 'null'");
            return null;
        }
        String productCode = null;
        productCode = deviceProduct == DeviceProduct.DeviceProductType.BASIC ? this.getUserFeatureValue(userId, UserFeatureCode.PRODUCT_BASIC) : (deviceProduct == DeviceProduct.DeviceProductType.TRIAL ? this.getUserFeatureValue(userId, UserFeatureCode.PRODUCT_TRIAL) : this.getUserFeatureValue(userId, UserFeatureCode.PRODUCT_PREMIUM));
        if (productCode == null) {
            log.debug((Object)("Not found product code for userId=" + userId + " and deviceProduct=" + deviceProduct + "."));
            return null;
        }
        return this.productDAO.findProductByCode(productCode);
    }
}

