/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.Date;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.LanDeviceProductlogDAO;
import pl.smartapps.restserver.db.dao.ProductDAO;
import pl.smartapps.restserver.db.dao.ProductFeatureDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.dao.UserproductlogDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceProductlogEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.db.main.UserproductlogEntity;
import pl.smartapps.restserver.rest.response.GetAccountResponse;
import pl.smartapps.restserver.rest.response.UpdateAccountStatus;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.ProductManagementServiceImpl;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ProductManagementServiceImpl.class})
public class ProductManagemenServiceTests {
    private ProductManagementServiceImpl productManagementService;
    private AuthenticationUtils authUtils;
    private ProductDAO productDAO;
    private ProductFeatureDAO productFeatureDAO;
    private UserproductlogDAO userproductlogDAO;
    private UserDAO userDAO;
    private ParameterService parameterService;
    private SystemSupport systemSupport;
    private LanDeviceDAO lanDeviceDAO;
    private LanDeviceProductlogDAO lanDeviceProductlogDAO;

    @Before
    public void setUp() {
        this.productManagementService = new ProductManagementServiceImpl();
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.productManagementService.setAuthUtils(this.authUtils);
        this.productDAO = (ProductDAO)PowerMock.createMock(ProductDAO.class);
        this.productManagementService.setProductDAO(this.productDAO);
        this.productFeatureDAO = (ProductFeatureDAO)PowerMock.createMock(ProductFeatureDAO.class);
        this.productManagementService.setProductFeatureDAO(this.productFeatureDAO);
        this.userproductlogDAO = (UserproductlogDAO)PowerMock.createMock(UserproductlogDAO.class);
        this.productManagementService.setUserproductlogDAO(this.userproductlogDAO);
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.productManagementService.setUserDAO(this.userDAO);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.productManagementService.setParameterService(this.parameterService);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.productManagementService.setSystemSupport(this.systemSupport);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.productManagementService.setLanDeviceDAO(this.lanDeviceDAO);
        this.lanDeviceProductlogDAO = (LanDeviceProductlogDAO)PowerMock.createMock(LanDeviceProductlogDAO.class);
        this.productManagementService.setLanDeviceProductlogDAO(this.lanDeviceProductlogDAO);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.productManagementService.setParameterService(this.parameterService);
    }

    @Test
    public void testGetDefaultProductSuccessfuly() {
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)3);
        ProductEntity product = new ProductEntity(Integer.valueOf(1), "test", null, null);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(3))).andReturn((Object)product);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)product, (Object)this.productManagementService.getDefaultProduct());
        PowerMock.verifyAll();
    }

    @Test
    public void testNotFoundGetDefaultProductSuccessfuly() {
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.PRODUCTMANAGEMENT_DEFAULT_PRODUCT_ID)).andReturn((Object)3);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(3))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.productManagementService.getDefaultProduct());
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserFeatureValueForCurrentUserSuccessfuly() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "MAX_DEVICE_COUNT")).andReturn((Object)new ProductfeatureEntity(Integer.valueOf(1), "123"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)"123", (Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserFeatureValueForCurrentUserProductFeatureNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "MAX_DEVICE_COUNT")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserFeatureValueSuccessfuly() throws InvalidSessionException {
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "MAX_DEVICE_COUNT")).andReturn((Object)new ProductfeatureEntity(Integer.valueOf(1), "123"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)"123", (Object)this.productManagementService.getUserFeatureValue(Integer.valueOf(1), UserFeatureCode.MAX_DEVICE_COUNT));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetUserFeatureValueProductFeatureNotFound() throws InvalidSessionException {
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "MAX_DEVICE_COUNT")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.productManagementService.getUserFeatureValue(Integer.valueOf(1), UserFeatureCode.MAX_DEVICE_COUNT));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceFeatureValueSuccessfuly() throws InvalidSessionException {
        EasyMock.expect((Object)this.productFeatureDAO.findDeviceProductfeature(Integer.valueOf(1), "ALARM")).andReturn((Object)new ProductfeatureEntity(Integer.valueOf(1), "123"));
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)"123", (Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.ALARM));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceFeatureValueProductFeatureNotFound() throws InvalidSessionException {
        EasyMock.expect((Object)this.productFeatureDAO.findDeviceProductfeature(Integer.valueOf(1), "ALARM")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.ALARM));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAccountSuccessfuly() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareUserEntity());
        PowerMock.replayAll((Object[])new Object[0]);
        GetAccountResponse response = this.productManagementService.getAccount();
        GetAccountResponse expectedResponse = new GetAccountResponse(GetAccountResponse.GetAccountStatus.SUCCESS, TestDataUtils.prepareProduct((String)"DefaultName"));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAccountFailureUserNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        GetAccountResponse response = this.productManagementService.getAccount();
        GetAccountResponse expectedResponse = new GetAccountResponse(GetAccountResponse.GetAccountStatus.FAILED_USERNOTFOUND);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAccountFailureNoneProductAssigned() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        UserEntity user = TestDataUtils.prepareUserEntity();
        user.setProduct(null);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        PowerMock.replayAll((Object[])new Object[0]);
        GetAccountResponse response = this.productManagementService.getAccount();
        GetAccountResponse expectedResponse = new GetAccountResponse(GetAccountResponse.GetAccountStatus.FAILED_NONEPRODUCTASSIGNED);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountSuccessfuly() throws Exception {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareUserEntity());
        ProductEntity product = TestDataUtils.prepareProductEntity((String)"NewProduct");
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        UserEntity userToSave = TestDataUtils.prepareUserEntity();
        userToSave.setProduct(product);
        EasyMock.expect((Object)this.userDAO.updateUser(userToSave)).andReturn((Object)userToSave);
        Date productAssignDate = Utils.constructDate((int)2012, (int)2, (int)27, (int)8, (int)27, (int)3);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)productAssignDate);
        UserproductlogEntity userproductlog = new UserproductlogEntity();
        userproductlog.setDateAdded(productAssignDate);
        userproductlog.setUser(userToSave);
        userproductlog.setProduct(product);
        UserproductlogEntity savedUserproductlog = new UserproductlogEntity();
        savedUserproductlog.setUserproductlogId(Integer.valueOf(1));
        savedUserproductlog.setDateAdded(productAssignDate);
        savedUserproductlog.setUser(userToSave);
        savedUserproductlog.setProduct(product);
        EasyMock.expect((Object)this.userproductlogDAO.save(userproductlog)).andReturn((Object)savedUserproductlog);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)UpdateAccountStatus.SUCCESS, (Object)this.productManagementService.updateAccount(Integer.valueOf(1), Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountFailureUserNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)UpdateAccountStatus.FAILED_USERNOTFOUND, (Object)this.productManagementService.updateAccount(Integer.valueOf(1), Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountFailureProductNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareUserEntity());
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)UpdateAccountStatus.FAILED_PRODUCTNOTFOUND, (Object)this.productManagementService.updateAccount(Integer.valueOf(1), Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateAccountFailureNotSavedInDatabase() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareUserEntity());
        ProductEntity product = TestDataUtils.prepareProductEntity((String)"NewProduct");
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        UserEntity userToSave = TestDataUtils.prepareUserEntity();
        userToSave.setProduct(product);
        EasyMock.expect((Object)this.userDAO.updateUser(userToSave)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)UpdateAccountStatus.ERROR, (Object)this.productManagementService.updateAccount(Integer.valueOf(1), Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testLogUserProductSuccessfully() {
        UserEntity user = new UserEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)2, (int)27, (int)8, (int)27, (int)3);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        UserproductlogEntity userproductlog = new UserproductlogEntity();
        userproductlog.setProduct(product);
        userproductlog.setUser(user);
        userproductlog.setDateAdded(currentDate);
        UserproductlogEntity userproductlogSaved = new UserproductlogEntity();
        userproductlogSaved.setUserproductlogId(Integer.valueOf(1));
        userproductlogSaved.setProduct(product);
        userproductlogSaved.setUser(user);
        userproductlogSaved.setDateAdded(currentDate);
        EasyMock.expect((Object)this.userproductlogDAO.save(userproductlog)).andReturn((Object)userproductlogSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test
    public void testLogUserProductFailureStoreInDatabase() {
        UserEntity user = new UserEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)2, (int)27, (int)8, (int)27, (int)3);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        UserproductlogEntity userproductlog = new UserproductlogEntity();
        userproductlog.setProduct(product);
        userproductlog.setUser(user);
        userproductlog.setDateAdded(currentDate);
        EasyMock.expect((Object)this.userproductlogDAO.save(userproductlog)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLogUserProductNotFoundProduct() {
        UserEntity user = new UserEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn((Object)user);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLogUserProductNotFoundUser() {
        EasyMock.expect((Object)this.userDAO.findUserById(Integer.valueOf(1))).andReturn(null);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logUserproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test
    public void testLogDeviceProductSuccessfully() {
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)2, (int)27, (int)8, (int)27, (int)3);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        LanDeviceProductlogEntity productlog = new LanDeviceProductlogEntity();
        productlog.setLandevice(device);
        productlog.setProduct(product);
        productlog.setDateAdded(currentDate);
        LanDeviceProductlogEntity productlogSaved = new LanDeviceProductlogEntity();
        productlogSaved.setLandeviceproductlogId(Integer.valueOf(1));
        productlogSaved.setLandevice(device);
        productlogSaved.setProduct(product);
        productlogSaved.setDateAdded(currentDate);
        EasyMock.expect((Object)this.lanDeviceProductlogDAO.persist(productlog)).andReturn((Object)productlogSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test
    public void testLogDeviceProductFailureStoreInDatabase() {
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)2, (int)27, (int)8, (int)27, (int)3);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        LanDeviceProductlogEntity productlog = new LanDeviceProductlogEntity();
        productlog.setLandevice(device);
        productlog.setProduct(product);
        productlog.setDateAdded(currentDate);
        EasyMock.expect((Object)this.lanDeviceProductlogDAO.persist(productlog)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLogDeviceProductNotFoundProduct() {
        LanDeviceEntity device = new LanDeviceEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLogDeviceProductNotFoundUser() {
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn(null);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductById(Integer.valueOf(1))).andReturn((Object)product);
        PowerMock.replayAll((Object[])new Object[0]);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetBasicProduct() {
        ProductfeatureEntity productFeature = new ProductfeatureEntity(Integer.valueOf(1), "basicCode");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_BASIC")).andReturn((Object)productFeature);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductByCode("basicCode")).andReturn((Object)product);
        PowerMock.replayAll((Object[])new Object[0]);
        ProductEntity response = this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC);
        Assert.assertEquals((Object)product, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetTrialProduct() {
        ProductfeatureEntity productFeature = new ProductfeatureEntity(Integer.valueOf(1), "trialCode");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_TRIAL")).andReturn((Object)productFeature);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductByCode("trialCode")).andReturn((Object)product);
        PowerMock.replayAll((Object[])new Object[0]);
        ProductEntity response = this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL);
        Assert.assertEquals((Object)product, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetPremiumProduct() {
        ProductfeatureEntity productFeature = new ProductfeatureEntity(Integer.valueOf(1), "premiumCode");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_PREMIUM")).andReturn((Object)productFeature);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productDAO.findProductByCode("premiumCode")).andReturn((Object)product);
        PowerMock.replayAll((Object[])new Object[0]);
        ProductEntity response = this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        Assert.assertEquals((Object)product, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetProductNotFoundProduct() {
        ProductfeatureEntity productFeature = new ProductfeatureEntity(Integer.valueOf(1), "premiumCode");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_PREMIUM")).andReturn((Object)productFeature);
        EasyMock.expect((Object)this.productDAO.findProductByCode("premiumCode")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ProductEntity response = this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetProductNotFoundProductCode() {
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_PREMIUM")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ProductEntity response = this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetProductNullArgumentProductType() {
        PowerMock.replayAll((Object[])new Object[0]);
        ProductEntity response = this.productManagementService.getProduct(Integer.valueOf(1), null);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetProductNullArgumentUserId() {
        PowerMock.replayAll((Object[])new Object[0]);
        ProductEntity response = this.productManagementService.getProduct(null, DeviceProduct.DeviceProductType.PREMIUM);
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetFeatureValueByDeviceFeatureCode() {
        ProductfeatureEntity productFeature = new ProductfeatureEntity(Integer.valueOf(1), "1m");
        EasyMock.expect((Object)this.productFeatureDAO.findProductfeature(Integer.valueOf(1), "LANDEVICE_VALIDITY")).andReturn((Object)productFeature);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY);
        String expectedResponse = "1m";
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetFeatureValueByDeviceFeatureCodeNotFoundFeature() {
        EasyMock.expect((Object)this.productFeatureDAO.findProductfeature(Integer.valueOf(1), "LANDEVICE_VALIDITY")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY);
        Object expectedResponse = null;
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetFeatureValueByUserFeatureCode() {
        ProductfeatureEntity productFeature = new ProductfeatureEntity(Integer.valueOf(1), "CHF");
        EasyMock.expect((Object)this.productFeatureDAO.findProductfeature(Integer.valueOf(1), "CURRENCY")).andReturn((Object)productFeature);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.productManagementService.getFeatureValue(Integer.valueOf(1), UserFeatureCode.CURRENCY);
        String expectedResponse = "CHF";
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetFeatureValueByUserFeatureCodeNotFoundFeature() {
        EasyMock.expect((Object)this.productFeatureDAO.findProductfeature(Integer.valueOf(1), "CURRENCY")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = this.productManagementService.getFeatureValue(Integer.valueOf(1), UserFeatureCode.CURRENCY);
        Object expectedResponse = null;
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetBasicDeviceProductType() {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(new UserEntity(Integer.valueOf(1)));
        ProductEntity product = new ProductEntity();
        product.setCode("basic");
        device.setProduct(product);
        ProductfeatureEntity productFeature = new ProductfeatureEntity();
        productFeature.setFeatureValue("basic");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_BASIC")).andReturn((Object)productFeature);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceProduct.DeviceProductType response = this.productManagementService.getDeviceProductType(Integer.valueOf(1));
        DeviceProduct.DeviceProductType expectedResponse = DeviceProduct.DeviceProductType.BASIC;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetTrialDeviceProductType() {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(new UserEntity(Integer.valueOf(1)));
        ProductEntity product = new ProductEntity();
        product.setCode("trial");
        device.setProduct(product);
        ProductfeatureEntity basicProductFeature = new ProductfeatureEntity();
        basicProductFeature.setFeatureValue("basic");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_BASIC")).andReturn((Object)basicProductFeature);
        ProductfeatureEntity trialProductFeature = new ProductfeatureEntity();
        trialProductFeature.setFeatureValue("trial");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_TRIAL")).andReturn((Object)trialProductFeature);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceProduct.DeviceProductType response = this.productManagementService.getDeviceProductType(Integer.valueOf(1));
        DeviceProduct.DeviceProductType expectedResponse = DeviceProduct.DeviceProductType.TRIAL;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetPremiumDeviceProductType() {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(new UserEntity(Integer.valueOf(1)));
        ProductEntity product = new ProductEntity();
        product.setCode("premium");
        device.setProduct(product);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        ProductfeatureEntity basicProductFeature = new ProductfeatureEntity();
        basicProductFeature.setFeatureValue("basic");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_BASIC")).andReturn((Object)basicProductFeature);
        ProductfeatureEntity trialProductFeature = new ProductfeatureEntity();
        trialProductFeature.setFeatureValue("trial");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_TRIAL")).andReturn((Object)trialProductFeature);
        ProductfeatureEntity premiumProductFeature = new ProductfeatureEntity();
        premiumProductFeature.setFeatureValue("premium");
        EasyMock.expect((Object)this.productFeatureDAO.findUserProductfeature(Integer.valueOf(1), "PRODUCT_PREMIUM")).andReturn((Object)premiumProductFeature);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceProduct.DeviceProductType response = this.productManagementService.getDeviceProductType(Integer.valueOf(1));
        DeviceProduct.DeviceProductType expectedResponse = DeviceProduct.DeviceProductType.PREMIUM;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }
}

