/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.PaymentGateway;
import pl.smartapps.hm.WebViewer.shared.model.ResendPaymentReceiptStatus;
import pl.smartapps.hm.WebViewer.shared.model.Transaction;
import pl.smartapps.hm.WebViewer.shared.model.UpdateDeviceProductResponse;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.TransactionDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.TransactionEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.ExtendValidityResponse;
import pl.smartapps.restserver.rest.response.InitTransactionResponse;
import pl.smartapps.restserver.rest.validator.CurrencyValidator;
import pl.smartapps.restserver.rest.validator.NotEmptyValidator;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.PaymentServiceImpl;
import pl.smartapps.restserver.service.impl.PaymentServiceTests;
import pl.smartapps.restserver.service.impl.ProductBuilder;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={PaymentServiceImpl.class})
public class PaymentServiceTests {
    private PaymentServiceImpl paymentService;
    private EmailNotificationService emailNotificationService;
    private ParameterService parameterService;
    private AuthenticationUtils authUtils;
    private TransactionDAO transactionDAO;
    private LanDeviceService lanDeviceService;
    private LanDeviceDAO lanDeviceDAO;
    private SystemSupport systemSupport;
    private CurrencyValidator currencyValidator;
    private NotEmptyValidator notEmptyValidator;
    private ProductManagementService productManagementService;

    @Before
    public void setUp() {
        this.paymentService = new PaymentServiceImpl();
        this.emailNotificationService = (EmailNotificationService)PowerMock.createMock(EmailNotificationService.class);
        this.paymentService.setEmailNotificationService(this.emailNotificationService);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.paymentService.setParameterService(this.parameterService);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.paymentService.setAuthUtils(this.authUtils);
        this.transactionDAO = (TransactionDAO)PowerMock.createMock(TransactionDAO.class);
        this.paymentService.setTransactionDAO(this.transactionDAO);
        this.lanDeviceService = (LanDeviceService)PowerMock.createMock(LanDeviceService.class);
        this.paymentService.setLanDeviceService(this.lanDeviceService);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.paymentService.setLanDeviceDAO(this.lanDeviceDAO);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.paymentService.setSystemSupport(this.systemSupport);
        this.currencyValidator = (CurrencyValidator)PowerMock.createMock(CurrencyValidator.class);
        this.paymentService.setCurrencyValidator(this.currencyValidator);
        this.notEmptyValidator = (NotEmptyValidator)PowerMock.createMock(NotEmptyValidator.class);
        this.paymentService.setNotEmptyValidator(this.notEmptyValidator);
        this.productManagementService = (ProductManagementService)PowerMock.createMock(ProductManagementService.class);
        this.paymentService.setProductManagementService(this.productManagementService);
    }

    @Test
    public void testInitPostFinanceTransactionSuccessfuly() throws Exception {
        this.authUtils.ensureLoggedIn();
        String pspId = "PSPID";
        String pspUrl = "url";
        String shaIn = "shaIn";
        String paymentGateway = "postfinance";
        ArrayList<String> gatewayData = new ArrayList<String>();
        gatewayData.add(pspId);
        gatewayData.add(pspUrl);
        gatewayData.add(shaIn);
        Integer ldId = 1;
        String currency = "CHF";
        String amount = "82.80";
        String gateway = "POSTFINANCE";
        UserEntity user = new UserEntity(Integer.valueOf(1), "user", "user@smart-apps.pl", "pass");
        LanDeviceEntity ld = new LanDeviceEntity(Integer.valueOf(1), "ld", new Date(), "", "", Integer.valueOf(0), "user", "pass");
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)14, (int)9, (int)57, (int)7);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)timestamp);
        TransactionEntity transaction = new TransactionEntity();
        TransactionEntity savedTransaction = new TransactionEntity();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)new ProductEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn((Object)amount);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(ldId)).andReturn((Object)ld);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_GATEWAY)).andReturn((Object)paymentGateway);
        transaction.setTransactionId(null);
        transaction.setAmount(new BigDecimal(amount));
        transaction.setCurrency(currency);
        transaction.setLanDevice(ld);
        transaction.setTimestamp(timestamp);
        transaction.setUser(user);
        transaction.setGateway(gateway);
        Integer transactionId = 1;
        savedTransaction.setTransactionId(transactionId);
        savedTransaction.setAmount(new BigDecimal(amount));
        savedTransaction.setCurrency(currency);
        savedTransaction.setLanDevice(ld);
        savedTransaction.setTimestamp(timestamp);
        savedTransaction.setUser(user);
        EasyMock.expect((Object)this.transactionDAO.createTransaction(transaction)).andReturn((Object)savedTransaction);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_PSP_ID)).andReturn((Object)pspId);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_URL)).andReturn((Object)pspUrl);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.POSTFINANCE_SHA_IN_PASSPHRASE)).andReturn((Object)shaIn);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.SUCCESS, "20111014095707000001", new BigDecimal(amount), currency, gatewayData, PaymentGateway.POSTFINANCE);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitDatatransTransactionSuccessfuly() throws Exception {
        this.authUtils.ensureLoggedIn();
        String datatransId = "id";
        String datatransUrl = "url";
        String datatransSign = "sign";
        String paymentGateway = "datatrans";
        ArrayList<String> gatewayData = new ArrayList<String>();
        gatewayData.add(datatransId);
        gatewayData.add(datatransUrl);
        gatewayData.add(datatransSign);
        Integer ldId = 1;
        String currency = "CHF";
        String amount = "82.80";
        String gateway = "DATATRANS";
        UserEntity user = new UserEntity(Integer.valueOf(1), "user", "user@smart-apps.pl", "pass");
        LanDeviceEntity ld = new LanDeviceEntity(Integer.valueOf(1), "ld", new Date(), "", "", Integer.valueOf(0), "user", "pass");
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)14, (int)9, (int)57, (int)7);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)timestamp);
        TransactionEntity transaction = new TransactionEntity();
        TransactionEntity savedTransaction = new TransactionEntity();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)new ProductEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn((Object)amount);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(ldId)).andReturn((Object)ld);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_GATEWAY)).andReturn((Object)paymentGateway);
        transaction.setTransactionId(null);
        transaction.setAmount(new BigDecimal(amount));
        transaction.setCurrency(currency);
        transaction.setLanDevice(ld);
        transaction.setTimestamp(timestamp);
        transaction.setUser(user);
        transaction.setGateway(gateway);
        Integer transactionId = 1;
        savedTransaction.setTransactionId(transactionId);
        savedTransaction.setAmount(new BigDecimal(amount));
        savedTransaction.setCurrency(currency);
        savedTransaction.setLanDevice(ld);
        savedTransaction.setTimestamp(timestamp);
        savedTransaction.setUser(user);
        EasyMock.expect((Object)this.transactionDAO.createTransaction(transaction)).andReturn((Object)savedTransaction);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_MERCHANT_ID)).andReturn((Object)datatransId);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_URL)).andReturn((Object)datatransUrl);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.DATATRANS_SIGN)).andReturn((Object)datatransSign);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.SUCCESS, "20111014095707000001", new BigDecimal(amount), currency, gatewayData, PaymentGateway.DATATRANS);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionCurrencyProductFeatureNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(Integer.valueOf(0)));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionPremiumProductNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)"CHF");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionAmountProductFeatureNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)"CHF");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)new ProductEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionAmountProductFeatureNotANumber() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)"CHF");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)new ProductEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn((Object)"amount");
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionLanDeviceNotFound() throws InvalidSessionException {
        String currency = "CHF";
        String amount = "82.80";
        UserEntity user = new UserEntity(Integer.valueOf(1), "user", "user@smart-apps.pl", "pass");
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)new ProductEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn((Object)amount);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionSavedTransactionIsNULL() throws Exception {
        this.authUtils.ensureLoggedIn();
        Integer ldId = 1;
        String currency = "CHF";
        String amount = "82.80";
        UserEntity user = new UserEntity(Integer.valueOf(1), "user", "user@smart-apps.pl", "pass");
        LanDeviceEntity ld = new LanDeviceEntity(Integer.valueOf(1), "ld", new Date(), "", "", Integer.valueOf(0), "user", "pass");
        Date timestamp = new Date();
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)timestamp);
        TransactionEntity transaction = new TransactionEntity();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)new ProductEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn((Object)amount);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(ldId)).andReturn((Object)ld);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_GATEWAY)).andReturn((Object)"postFinance");
        transaction.setTransactionId(null);
        transaction.setAmount(new BigDecimal(amount));
        transaction.setCurrency(currency);
        transaction.setLanDevice(ld);
        transaction.setTimestamp(timestamp);
        transaction.setUser(user);
        transaction.setGateway("POSTFINANCE");
        EasyMock.expect((Object)this.transactionDAO.createTransaction(transaction)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionSavedTransactionIdIsNULL() throws Exception {
        this.authUtils.ensureLoggedIn();
        Integer ldId = 1;
        String currency = "CHF";
        String amount = "82.80";
        UserEntity user = new UserEntity(Integer.valueOf(1), "user", "user@smart-apps.pl", "pass");
        LanDeviceEntity ld = new LanDeviceEntity(Integer.valueOf(1), "ld", new Date(), "", "", Integer.valueOf(0), "user", "pass");
        Date timestamp = new Date();
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)timestamp);
        TransactionEntity transaction = new TransactionEntity();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)new ProductEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn((Object)amount);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(ldId)).andReturn((Object)ld);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_GATEWAY)).andReturn((Object)"POSTFINANCE");
        transaction.setTransactionId(null);
        transaction.setAmount(new BigDecimal(amount));
        transaction.setCurrency(currency);
        transaction.setLanDevice(ld);
        transaction.setTimestamp(timestamp);
        transaction.setUser(user);
        transaction.setGateway("POSTFINANCE");
        TransactionEntity savedTransaction = new TransactionEntity();
        savedTransaction.setTransactionId(null);
        EasyMock.expect((Object)this.transactionDAO.createTransaction(transaction)).andReturn((Object)savedTransaction);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testInitTransactionNullPaymentGateway() throws Exception {
        Integer ldId = 1;
        String currency = "CHF";
        String amount = "82.80";
        UserEntity user = new UserEntity(Integer.valueOf(1), "user", "user@smart-apps.pl", "pass");
        LanDeviceEntity ld = new LanDeviceEntity(Integer.valueOf(1), "ld", new Date(), "", "", Integer.valueOf(0), "user", "pass");
        Date timestamp = new Date();
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)timestamp);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(ldId, DeviceFeatureCode.AMOUNT)).andReturn((Object)amount);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(ldId)).andReturn((Object)ld);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_GATEWAY)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        InitTransactionResponse response = new InitTransactionResponse(InitTransactionResponse.InitTransactionStatus.ERROR);
        Assert.assertEquals((Object)response, (Object)this.paymentService.initTransaction(ldId));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAmountWithCurrencySuccess() throws Exception {
        String currency = "CHF";
        String amount = "82.80";
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setProductfeatures(new HashSet());
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn((Object)amount);
        PowerMock.replayAll((Object[])new Object[0]);
        String response = "CHF 82.80";
        Assert.assertEquals((Object)response, (Object)this.paymentService.getAmountWithCurrency(DeviceProduct.DeviceProductType.PREMIUM));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAmountWithCurrencyCurrencyIsNULL() throws Exception {
        Object currency = null;
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn(currency);
        PowerMock.replayAll((Object[])new Object[0]);
        Object response = null;
        Assert.assertEquals(response, (Object)this.paymentService.getAmountWithCurrency(DeviceProduct.DeviceProductType.PREMIUM));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetAmountWithCurrencyAmountIsNULL() throws Exception {
        String currency = "CHF";
        Object amount = null;
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY)).andReturn((Object)currency);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setProductfeatures(new HashSet());
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.AMOUNT)).andReturn(amount);
        PowerMock.replayAll((Object[])new Object[0]);
        Object response = null;
        Assert.assertEquals(response, (Object)this.paymentService.getAmountWithCurrency(DeviceProduct.DeviceProductType.PREMIUM));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetTransactionsSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        Date dateFrom = Utils.constructDate((int)2011, (int)11, (int)15, (int)10, (int)11, (int)11);
        Date dateTo = Utils.constructDate((int)2011, (int)11, (int)20, (int)10, (int)11, (int)11);
        ArrayList<TransactionEntity> foundTransactions = new ArrayList<TransactionEntity>();
        foundTransactions.add(this.buildTransactionEntity(Integer.valueOf(1), Utils.constructDate((int)2011, (int)11, (int)28, (int)9, (int)12, (int)45), "PLN", 3.3f, "111", "OK"));
        foundTransactions.add(this.buildTransactionEntity(Integer.valueOf(2), Utils.constructDate((int)2011, (int)11, (int)29, (int)10, (int)23, (int)32), "PLN", 3.23f, "222", "OK"));
        EasyMock.expect((Object)this.transactionDAO.findTransactions(Integer.valueOf(1), dateFrom, dateTo, "OK")).andReturn(foundTransactions);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<Transaction> expectedResponse = new ArrayList<Transaction>();
        expectedResponse.add(this.buildTransaction(Integer.valueOf(1), Utils.constructDate((int)2011, (int)11, (int)28, (int)9, (int)12, (int)45), "PLN", 3.3f, "111", "OK"));
        expectedResponse.add(this.buildTransaction(Integer.valueOf(2), Utils.constructDate((int)2011, (int)11, (int)29, (int)10, (int)23, (int)32), "PLN", 3.23f, "222", "OK"));
        List response = this.paymentService.getTransactions(dateFrom, dateTo, "OK");
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetTransactionsFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        Date dateFrom = Utils.constructDate((int)2011, (int)11, (int)15, (int)10, (int)11, (int)11);
        Date dateTo = Utils.constructDate((int)2011, (int)11, (int)20, (int)10, (int)11, (int)11);
        EasyMock.expect((Object)this.transactionDAO.findTransactions(Integer.valueOf(1), dateFrom, dateTo, "OK")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.paymentService.getTransactions(dateFrom, dateTo, "OK");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetTransactionsAsAdminSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)11, (int)15, (int)10, (int)11, (int)11);
        Date dateTo = Utils.constructDate((int)2011, (int)11, (int)20, (int)10, (int)11, (int)11);
        ArrayList<TransactionEntity> foundTransactions = new ArrayList<TransactionEntity>();
        foundTransactions.add(this.buildTransactionEntity(Integer.valueOf(1), Utils.constructDate((int)2011, (int)11, (int)28, (int)9, (int)12, (int)45), "PLN", 3.3f, "111", "OK"));
        foundTransactions.add(this.buildTransactionEntity(Integer.valueOf(2), Utils.constructDate((int)2011, (int)11, (int)29, (int)10, (int)23, (int)32), "PLN", 3.23f, "222", "OK"));
        EasyMock.expect((Object)this.transactionDAO.findTransactions(dateFrom, dateTo, "heh", "OK")).andReturn(foundTransactions);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<Transaction> expectedResponse = new ArrayList<Transaction>();
        expectedResponse.add(this.buildTransaction(Integer.valueOf(1), Utils.constructDate((int)2011, (int)11, (int)28, (int)9, (int)12, (int)45), "PLN", 3.3f, "111", "OK"));
        expectedResponse.add(this.buildTransaction(Integer.valueOf(2), Utils.constructDate((int)2011, (int)11, (int)29, (int)10, (int)23, (int)32), "PLN", 3.23f, "222", "OK"));
        List response = this.paymentService.getTransactionsAsAdmin(dateFrom, dateTo, "heh", "OK");
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetTransactionsAsAdminFailure() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        Date dateFrom = Utils.constructDate((int)2011, (int)11, (int)15, (int)10, (int)11, (int)11);
        Date dateTo = Utils.constructDate((int)2011, (int)11, (int)20, (int)10, (int)11, (int)11);
        EasyMock.expect((Object)this.transactionDAO.findTransactions(dateFrom, dateTo, "heh", "OK")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.paymentService.getTransactionsAsAdmin(dateFrom, dateTo, "heh", "OK");
        Assert.assertEquals(null, (Object)response);
        PowerMock.verifyAll();
    }

    private TransactionEntity buildTransactionEntity(Integer transactionId, Date timestamp, String currency, float amount, String refNr, String status) {
        TransactionEntity transaction = new TransactionEntity();
        transaction.setTransactionId(transactionId);
        transaction.setTimestamp(timestamp);
        transaction.setCurrency(currency);
        transaction.setAmount(new BigDecimal(amount));
        transaction.setReferenceNr(refNr);
        transaction.setStatus(status);
        transaction.setValidTo(Utils.constructDate((int)2014, (int)10, (int)10));
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setDeleted(Integer.valueOf(0));
        user.setFirstname("firstname");
        user.setLastname("lastname");
        user.setAddress("address");
        user.setTown("town");
        user.setZipCode("zipCode");
        user.setState("state");
        user.setCountry("PL");
        user.setLanguage("en");
        user.setMailing(false);
        transaction.setUser(user);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setProductfeatures(new HashSet());
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setName("Camera #1");
        device.setMac("11:22:33:44:55:66");
        device.setIpAddress("127.0.0.1");
        device.setPort(Integer.valueOf(80));
        device.setUsername("admin");
        device.setPass("admin");
        device.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        device.setProduct(product);
        transaction.setLanDevice(device);
        return transaction;
    }

    private Transaction buildTransaction(Integer transactionId, Date timestamp, String currency, float amount, String refNr, String status) {
        Transaction transaction = new Transaction();
        transaction.setTransactionId(transactionId);
        transaction.setTimestamp(timestamp);
        transaction.setCurrency(currency);
        transaction.setAmount(new BigDecimal(amount));
        transaction.setReferenceNr(refNr);
        transaction.setStatus(status);
        transaction.setValidTo(Utils.constructDate((int)2014, (int)10, (int)10));
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("test");
        user.setEmail("test@test.pl");
        user.setDeleted(Boolean.valueOf(false));
        user.setFirstname("firstname");
        user.setLastname("lastname");
        user.setAddress("address");
        user.setTown("town");
        user.setZipCode("zipCode");
        user.setState("state");
        user.setCountry("PL");
        user.setLanguage("en");
        user.setMailing(Boolean.valueOf(false));
        transaction.setUser(user);
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        LanDevice device = new LanDevice();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setName("Camera #1");
        device.setMac("11:22:33:44:55:66");
        device.setIpAddress("127.0.0.1");
        device.setPort(Integer.valueOf(80));
        device.setUser("admin");
        device.setPass("admin");
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setDeleted(Boolean.valueOf(false));
        device.setRecording(Boolean.valueOf(false));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setHasHome(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasLedControl(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        device.setConfigurationStatusChanged(false);
        device.setLanDeviceParams(new ArrayList());
        device.setProduct(deviceProduct);
        transaction.setLanDevice(device);
        return transaction;
    }

    @Test
    public void testProcessPaymentNotificationWithDefaultEmailTemplate() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationWithDediacatedEmailTemplateWithoutProductChange() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.PAYMENT_CONFIRMATION_CONT_EMAIL_TEMPLATE, "contProductEmailCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.PAYMENT_CONFIRMATION_NEW_EMAIL_TEMPLATE, "newProductEmailCode");
        transaction.getLanDevice().setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        updateDeviceProductResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.PREMIUM);
        updateDeviceProductResponse.setProductType(DeviceProduct.DeviceProductType.PREMIUM);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), "contProductEmailCode", placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        transactionSaved.getLanDevice().setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationWithDediacatedEmailTemplateWithProductChange() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setProductfeatures(new HashSet());
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.PAYMENT_CONFIRMATION_CONT_EMAIL_TEMPLATE, "contProductEmailCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.PAYMENT_CONFIRMATION_NEW_EMAIL_TEMPLATE, "newProductEmailCode");
        transaction.getLanDevice().setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        updateDeviceProductResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.BASIC);
        updateDeviceProductResponse.setProductType(DeviceProduct.DeviceProductType.PREMIUM);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), "newProductEmailCode", placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        transactionSaved.getLanDevice().setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationWithNullPaymentMethod() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, null);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", null, "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationForPosfincence() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.POSTFINANCE, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.POSTFINANCE, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.POSTFINANCE, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationFailureUpdateTransaction() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationFailureProlongDeviceValidity() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", null, "rawResponse", Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationFailureSendPaymentConfiramtion() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)false);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationFailureSendPaymentNotificationOperator() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)false);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationWithDecliendPayment() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, null, null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "declined", "12092917", null, "rawResponse", Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "declined", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationOverrideSuccessStatus() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, "success", null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationOverrideErrorStatus() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        TransactionEntity transaction = this.prepareTransactionEntity(timestamp, "error", null, null, null, Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn((Object)transaction);
        Date prolongValidTo = Utils.constructDate((int)2011, (int)11, (int)13, (int)12, (int)34, (int)56);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        updateDeviceProductResponse.setValidTo(prolongValidTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Transaction transactionDto = this.prepareTransaction(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2011-11-13");
        placeholders.put("%REFERENCE_NR%", "12092917");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2011-10-13");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transactionDto.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transactionDto.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        TransactionEntity transactionSaved = this.prepareTransactionEntity(timestamp, "success", "12092917", prolongValidTo, "rawResponse", Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(transactionSaved)).andReturn((Object)transactionSaved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationNotFoundTransaction() throws InvalidSessionException {
        Date timestamp = Utils.constructDate((int)2011, (int)10, (int)13, (int)12, (int)34, (int)56);
        EasyMock.expect((Object)this.transactionDAO.findTransactionByIdAndTimestamp(Integer.valueOf(14), timestamp)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("20111013123456000014", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testProcessPaymentNotificationInvalidOrderId() throws InvalidSessionException {
        PowerMock.replayAll((Object[])new Object[0]);
        this.paymentService.processPaymentNotification("2011101312345600001A", "success", "12092917", "VIS", "rawResponse");
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptForDatatransAndCorrectPaymentMethodWithDedicatedEmailTemplate() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        TransactionEntity transactionEntity = this.prepareTransactionEntity(Gateway.DATATRANS, "VIS");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.PAYMENT_CONFIRMATION_CONT_EMAIL_TEMPLATE, "contProductEmailCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.PAYMENT_CONFIRMATION_NEW_EMAIL_TEMPLATE, "newProductEmailCode");
        transactionEntity.getLanDevice().setProduct(productBuilder.getProduct());
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn((Object)transactionEntity);
        Transaction transaction = this.prepareTransaction(Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2012-06-30");
        placeholders.put("%REFERENCE_NR%", "111220083347196307");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2012-01-30");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transaction.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transaction.getUser(), "newProductEmailCode", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.SUCCESS, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptForDatatransAndCorrectPaymentMethodWithDefaultEmailTemplate() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        TransactionEntity transactionEntity = this.prepareTransactionEntity(Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn((Object)transactionEntity);
        Transaction transaction = this.prepareTransaction(Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2012-06-30");
        placeholders.put("%REFERENCE_NR%", "111220083347196307");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2012-01-30");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transaction.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transaction.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.SUCCESS, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptForDatatransAndIncorrectPaymentMethod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        TransactionEntity transactionEntity = this.prepareTransactionEntity(Gateway.DATATRANS, "DDD");
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn((Object)transactionEntity);
        Transaction transaction = this.prepareTransaction(Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2012-06-30");
        placeholders.put("%REFERENCE_NR%", "111220083347196307");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2012-01-30");
        placeholders.put("%PAYMENT_METHOD%", "");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transaction.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transaction.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.SUCCESS, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptForDatatransAndNullPaymentMethod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        TransactionEntity transactionEntity = this.prepareTransactionEntity(Gateway.DATATRANS, null);
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn((Object)transactionEntity);
        Transaction transaction = this.prepareTransaction(Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2012-06-30");
        placeholders.put("%REFERENCE_NR%", "111220083347196307");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2012-01-30");
        placeholders.put("%PAYMENT_METHOD%", "");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transaction.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transaction.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.SUCCESS, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptForPostfinanceAndNotNullPaymentMethod() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        TransactionEntity transactionEntity = this.prepareTransactionEntity(Gateway.POSTFINANCE, "VIS");
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn((Object)transactionEntity);
        Transaction transaction = this.prepareTransaction(Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2012-06-30");
        placeholders.put("%REFERENCE_NR%", "111220083347196307");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2012-01-30");
        placeholders.put("%PAYMENT_METHOD%", "");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transaction.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transaction.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.SUCCESS, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptFailureSendPaymentConfirmation() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        TransactionEntity transactionEntity = this.prepareTransactionEntity(Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn((Object)transactionEntity);
        Transaction transaction = this.prepareTransaction(Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2012-06-30");
        placeholders.put("%REFERENCE_NR%", "111220083347196307");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2012-01-30");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transaction.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)true);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transaction.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.ERROR, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptFailureSendPaymentNotificationOperator() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        TransactionEntity transactionEntity = this.prepareTransactionEntity(Gateway.DATATRANS, "VIS");
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn((Object)transactionEntity);
        Transaction transaction = this.prepareTransaction(Gateway.DATATRANS, "VIS");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", "2012-06-30");
        placeholders.put("%REFERENCE_NR%", "111220083347196307");
        placeholders.put("%AMOUNT%", "4.99");
        placeholders.put("%CURRENCY%", "CHF");
        placeholders.put("%CAMERA_NAME%", "Camera name");
        placeholders.put("%CAMERA_MAC%", "Camera mac");
        placeholders.put("%DATE%", "2012-01-30");
        placeholders.put("%PAYMENT_METHOD%", "VISA");
        placeholders.put("%USERNAME%", "user username");
        HashMap<String, String> userPlaceholders = new HashMap<String, String>();
        userPlaceholders.put("%USERNAME%", "user username");
        EasyMock.expect((Object)this.emailNotificationService.getUserPlaceholders(transaction.getUser())).andReturn(userPlaceholders);
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)"paymentOperatorEmail");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("paymentOperatorEmail", EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)).andReturn((Object)false);
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(transaction.getUser(), EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name(), placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.SUCCESS, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptNotFoundTransaction() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.transactionDAO.findTransactionById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.FAILED_TRANSACTIONNOTFOUND, (Object)this.paymentService.resendPaymentReceipt(Integer.valueOf(1), true));
        PowerMock.verifyAll();
    }

    @Test
    public void testResendPaymentReceiptInvalidTransactionid() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ResendPaymentReceiptStatus.FAILD_INVALIDTRANSACTIONID, (Object)this.paymentService.resendPaymentReceipt(null, true));
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidity() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("1234567890")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("VISA")).andReturn((Object)true);
        LanDeviceEntity device = this.buildLanDeviceEntity(Integer.valueOf(1), false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date validTo = Utils.constructDate((int)2012, (int)6, (int)30);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS, DeviceProduct.DeviceProductType.PREMIUM, DeviceProduct.DeviceProductType.PREMIUM, "premium", validTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Date currentDate = Utils.constructDate((int)2012, (int)2, (int)10, (int)13, (int)26, (int)35);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        TransactionEntity savedTransaction = new TransactionEntity();
        savedTransaction.setTimestamp(currentDate);
        savedTransaction.setUser(new UserEntity(Integer.valueOf(1)));
        savedTransaction.setCurrency("CHF");
        savedTransaction.setAmount(BigDecimal.valueOf(4.99));
        savedTransaction.setReferenceNr("1234567890");
        savedTransaction.setStatus("success");
        savedTransaction.setLanDevice(device);
        savedTransaction.setValidTo(validTo);
        savedTransaction.setGateway("DATATRANS");
        savedTransaction.setPaymentType("VISA");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(savedTransaction)).andReturn((Object)savedTransaction);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.SUCCESS, validTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityFailureStoreTransactionInDatabase() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("1234567890")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("VISA")).andReturn((Object)true);
        LanDeviceEntity device = this.buildLanDeviceEntity(Integer.valueOf(1), false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        Date validTo = Utils.constructDate((int)2012, (int)6, (int)30);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS, DeviceProduct.DeviceProductType.PREMIUM, DeviceProduct.DeviceProductType.PREMIUM, "premium", validTo);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        Date currentDate = Utils.constructDate((int)2012, (int)2, (int)10, (int)13, (int)26, (int)35);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        TransactionEntity savedTransaction = new TransactionEntity();
        savedTransaction.setTimestamp(currentDate);
        savedTransaction.setUser(new UserEntity(Integer.valueOf(1)));
        savedTransaction.setCurrency("CHF");
        savedTransaction.setAmount(BigDecimal.valueOf(4.99));
        savedTransaction.setReferenceNr("1234567890");
        savedTransaction.setStatus("success");
        savedTransaction.setLanDevice(device);
        savedTransaction.setValidTo(validTo);
        savedTransaction.setGateway("DATATRANS");
        savedTransaction.setPaymentType("VISA");
        EasyMock.expect((Object)this.transactionDAO.updateTransaction(savedTransaction)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityFailureProlongDeviceValidity() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("1234567890")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("VISA")).andReturn((Object)true);
        LanDeviceEntity device = this.buildLanDeviceEntity(Integer.valueOf(1), false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UpdateDeviceProductResponse updateDeviceProductResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        EasyMock.expect((Object)this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)updateDeviceProductResponse);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityForNotExistingDevice() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("1234567890")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("VISA")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_NOTFOUNDDEVICE);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityForDeletedDevice() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("1234567890")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("VISA")).andReturn((Object)true);
        LanDeviceEntity device = this.buildLanDeviceEntity(Integer.valueOf(1), true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_NOTFOUNDDEVICE);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityInvalidPaymentType() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("1234567890")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("VISA")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_INVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityInvalidReferenceNumber() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("1234567890")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_INVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityInvalidGateway() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)true);
        EasyMock.expect((Object)this.notEmptyValidator.validate("DATATRANS")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_INVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityInvalidCurrency() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        EasyMock.expect((Object)this.currencyValidator.validate("CHF")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_INVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testExtendValidityInvalidAmount() throws InvalidSessionException {
        Transaction transaction = new Transaction();
        transaction.setAmount(null);
        transaction.setCurrency("CHF");
        transaction.setGateway("DATATRANS");
        transaction.setReferenceNr("1234567890");
        transaction.setPaymentType("VISA");
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        PowerMock.replayAll((Object[])new Object[0]);
        ExtendValidityResponse response = this.paymentService.extendValidity(Integer.valueOf(1), transaction);
        ExtendValidityResponse expectedResponse = new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_INVALID);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private LanDeviceEntity buildLanDeviceEntity(Integer lanDeviceId, boolean deleted) {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(lanDeviceId);
        device.setDeleted(deleted);
        UserEntity user = new UserEntity(Integer.valueOf(1));
        device.setUser(user);
        return device;
    }

    private Transaction prepareTransaction(Gateway gateway, String paymentType) {
        return this.prepareTransaction(Utils.constructDate((int)2012, (int)1, (int)30, (int)10, (int)26, (int)31), "success", "111220083347196307", Utils.constructDate((int)2012, (int)6, (int)30), "raw_response", gateway, paymentType);
    }

    private TransactionEntity prepareTransactionEntity(Gateway gateway, String paymentType) {
        return this.prepareTransactionEntity(Utils.constructDate((int)2012, (int)1, (int)30, (int)10, (int)26, (int)31), "success", "111220083347196307", Utils.constructDate((int)2012, (int)6, (int)30), "raw_response", gateway, paymentType);
    }

    private TransactionEntity prepareTransactionEntity(Date timestamp, String status, String referenceNumber, Date validTo, String rawResponse, Gateway gateway, String paymentType) {
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setUsername("user username");
        user.setEmail("user email");
        user.setFirstname("user firstname");
        user.setLastname("user lastname");
        user.setAddress("user address");
        user.setTown("user town");
        user.setZipCode("user zip");
        user.setState("user state");
        user.setCountry("user country");
        user.setLanguage("user language");
        user.setDeleted(Integer.valueOf(0));
        user.setMailing(false);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setProductfeatures(new HashSet());
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setName("Camera name");
        device.setMac("Camera mac");
        device.setProduct(product);
        TransactionEntity transaction = new TransactionEntity();
        transaction.setTransactionId(Integer.valueOf(1));
        transaction.setTimestamp(timestamp);
        transaction.setCurrency("CHF");
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setStatus(status);
        transaction.setReferenceNr(referenceNumber);
        transaction.setValidTo(validTo);
        transaction.setGateway(gateway.name());
        transaction.setRawResponse(rawResponse);
        transaction.setPaymentType(paymentType);
        transaction.setUser(user);
        transaction.setLanDevice(device);
        return transaction;
    }

    private Transaction prepareTransaction(Date timestamp, String status, String referenceNumber, Date validTo, String rawResponse, Gateway gateway, String paymentType) {
        User user = new User();
        user.setId(Integer.valueOf(1));
        user.setUsername("user username");
        user.setEmail("user email");
        user.setFirstname("user firstname");
        user.setLastname("user lastname");
        user.setAddress("user address");
        user.setTown("user town");
        user.setZipCode("user zip");
        user.setState("user state");
        user.setCountry("user country");
        user.setLanguage("user language");
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        DeviceProduct product = new DeviceProduct();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setFeatures(new HashMap());
        LanDevice device = new LanDevice();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setName("Camera name");
        device.setMac("Camera mac");
        device.setProduct(product);
        Transaction transaction = new Transaction();
        transaction.setTransactionId(Integer.valueOf(1));
        transaction.setTimestamp(timestamp);
        transaction.setCurrency("CHF");
        transaction.setAmount(BigDecimal.valueOf(4.99));
        transaction.setStatus(status);
        transaction.setReferenceNr(referenceNumber);
        transaction.setValidTo(validTo);
        transaction.setGateway(gateway.name());
        transaction.setRawResponse(rawResponse);
        transaction.setPaymentType(paymentType);
        transaction.setUser(user);
        transaction.setLanDevice(device);
        return transaction;
    }
}

