/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.PaymentGateway;
import pl.smartapps.hm.WebViewer.shared.model.ResendPaymentReceiptStatus;
import pl.smartapps.hm.WebViewer.shared.model.Transaction;
import pl.smartapps.hm.WebViewer.shared.model.UpdateDeviceProductResponse;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.TransactionDAO;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.TransactionEntity;
import pl.smartapps.restserver.rest.response.ExtendValidityResponse;
import pl.smartapps.restserver.rest.response.InitTransactionResponse;
import pl.smartapps.restserver.rest.validator.CurrencyValidator;
import pl.smartapps.restserver.rest.validator.NotEmptyValidator;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.PaymentService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.util.Utils;

@Service
public class PaymentServiceImpl
implements PaymentService {
    private static Logger log = Logger.getLogger(PaymentServiceImpl.class);
    private EmailNotificationService emailNotificationService;
    private ParameterService parameterService;
    private AuthenticationUtils authUtils;
    private TransactionDAO transactionDAO;
    private LanDeviceService lanDeviceService;
    private LanDeviceDAO lanDeviceDAO;
    private SystemSupport systemSupport;
    private CurrencyValidator currencyValidator;
    private NotEmptyValidator notEmptyValidator;
    private ProductManagementService productManagementService;
    private Map<String, String> datatrancePaymentTypes = new /* Unavailable Anonymous Inner Class!! */;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$PaymentGateway;

    @Autowired
    @Required
    public void setEmailNotificationService(EmailNotificationService emailNotificationService) {
        this.emailNotificationService = emailNotificationService;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setTransactionDAO(TransactionDAO transactionDAO) {
        this.transactionDAO = transactionDAO;
    }

    @Autowired
    @Required
    public void setLanDeviceService(LanDeviceService lanDeviceService) {
        this.lanDeviceService = lanDeviceService;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setCurrencyValidator(CurrencyValidator currencyValidator) {
        this.currencyValidator = currencyValidator;
    }

    @Autowired
    @Required
    public void setNotEmptyValidator(NotEmptyValidator notEmptyValidator) {
        this.notEmptyValidator = notEmptyValidator;
    }

    @Autowired
    @Required
    public void setProductManagementService(ProductManagementService productManagementService) {
        this.productManagementService = productManagementService;
    }

    /*
     * Exception decompiling
     */
    @Transactional
    public InitTransactionResponse initTransaction(Integer lanDeviceId) throws InvalidSessionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private BigDecimal getAmount(ProductEntity product) {
        String amountText = this.productManagementService.getFeatureValue(product.getProductId(), DeviceFeatureCode.AMOUNT);
        if (amountText == null || amountText.length() == 0) {
            log.warn((Object)("Invalid amount value for product with productId=" + product.getProductId() + ": " + amountText + "."));
            return null;
        }
        try {
            return new BigDecimal(amountText);
        }
        catch (NumberFormatException ex) {
            log.warn((Object)("Amount value for product wwith productId=" + product.getProductId() + " is not a number: " + amountText + "."));
            return null;
        }
    }

    private String buildOrderId(TransactionEntity transaction) {
        return String.valueOf(Utils.formatDate((Date)transaction.getTimestamp(), (String)"yyyyMMddHHmmss")) + this.formatNumber(transaction.getTransactionId(), "000000");
    }

    private String formatNumber(Integer number, String pattern) {
        if (number == null) {
            log.warn((Object)"Number converted to text can not be null");
            return null;
        }
        if (pattern == null) {
            log.warn((Object)"Pattern can not be null to convert number to text.");
            return null;
        }
        DecimalFormat numberFormatter = new DecimalFormat(pattern);
        return numberFormatter.format(number);
    }

    public String getAmountWithCurrency(DeviceProduct.DeviceProductType deviceProductType) throws InvalidSessionException {
        log.trace((Object)("start getAmountWithCurrency(deviceProductType=" + deviceProductType + ")"));
        this.authUtils.ensureLoggedIn();
        String currency = this.productManagementService.getUserFeatureValue(UserFeatureCode.CURRENCY);
        if (currency == null) {
            log.error((Object)"initTransaction::currency is NULL");
            return null;
        }
        ProductEntity product = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), deviceProductType);
        if (product == null) {
            log.warn((Object)("Not found product for current logged user and for device product type '" + deviceProductType + "'."));
            return null;
        }
        String amount = this.productManagementService.getFeatureValue(product.getProductId(), DeviceFeatureCode.AMOUNT);
        if (amount == null || amount.length() == 0) {
            log.error((Object)"initTransaction::amount is NULL or empty");
            return null;
        }
        try {
            Float.parseFloat(amount);
        }
        catch (NumberFormatException ex) {
            log.error((Object)"initTransaction::amount is not a number");
            return null;
        }
        return String.valueOf(currency) + " " + amount;
    }

    public List<Transaction> getTransactions(Date dateFrom, Date dateTo, String status) throws InvalidSessionException {
        log.trace((Object)("start getTransactions(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", status=" + status + ")"));
        this.authUtils.ensureLoggedIn();
        List transactions = this.transactionDAO.findTransactions(this.authUtils.getCurrentUserId(), dateFrom, dateTo, status);
        return this.toDTOs(transactions);
    }

    public List<Transaction> getTransactionsAsAdmin(Date dateFrom, Date dateTo, String username, String status) throws InvalidSessionException {
        log.trace((Object)("start getTransactionsAsAdmin(dateFrom=" + dateFrom + ", dateTo=" + dateTo + ", username=" + username + ", status=" + status + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        List transactions = this.transactionDAO.findTransactions(dateFrom, dateTo, username, status);
        return this.toDTOs(transactions);
    }

    private Transaction toDTO(TransactionEntity transaction) {
        Transaction dto = new Transaction();
        dto.setTransactionId(transaction.getTransactionId());
        dto.setTimestamp(transaction.getTimestamp());
        dto.setCurrency(transaction.getCurrency());
        dto.setAmount(transaction.getAmount());
        dto.setStatus(transaction.getStatus());
        dto.setReferenceNr(transaction.getReferenceNr());
        dto.setValidTo(transaction.getValidTo());
        dto.setRawResponse(transaction.getRawResponse());
        dto.setUser(transaction.getUser().toDTO());
        dto.setLanDevice(transaction.getLanDevice().toDTO(null, null, false, false, true, null, null));
        return dto;
    }

    private List<Transaction> toDTOs(List<TransactionEntity> transactions) {
        if (transactions == null) {
            return null;
        }
        ArrayList<Transaction> dtos = new ArrayList<Transaction>();
        for (TransactionEntity transaction : transactions) {
            dtos.add(this.toDTO(transaction));
        }
        return dtos;
    }

    @Transactional
    public void processPaymentNotification(String orderId, String status, String referenceNumber, String paymentMethod, String rawResponse) throws InvalidSessionException {
        log.trace((Object)("start processPaymentNotification(orderId=" + orderId + ", status=" + status + ", referenceNumber=" + referenceNumber + ", paymentMethod=" + paymentMethod + "rawResponse=...)"));
        if (!this.verifyOrderId(orderId)) {
            log.warn((Object)("Unexpected form of orderId: " + orderId + "."));
            return;
        }
        TransactionEntity transaction = this.transactionDAO.findTransactionByIdAndTimestamp(this.getTransacionId(orderId), this.getTransactionTimestamp(orderId));
        if (transaction == null) {
            log.debug((Object)("Transaction not found with orderId=" + orderId + "."));
            return;
        }
        if (transaction.getStatus() != null) {
            log.warn((Object)("Transaction status has been already set and its status was: " + transaction.getStatus()));
            if (transaction.getStatus().equals("success")) {
                log.warn((Object)"Trying to override success status.");
                return;
            }
        }
        transaction.setStatus(status);
        transaction.setReferenceNr(referenceNumber);
        transaction.setRawResponse(rawResponse);
        transaction.setPaymentType(paymentMethod);
        if ("success".equals(status)) {
            UpdateDeviceProductResponse productUpdateResponse = this.lanDeviceService.updateDeviceProduct(transaction.getLanDevice(), DeviceProduct.DeviceProductType.PREMIUM);
            log.debug((Object)("productUpdateResponse: " + productUpdateResponse));
            if (productUpdateResponse.getStatus() == UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS) {
                boolean productChanged;
                transaction.setValidTo(productUpdateResponse.getValidTo());
                boolean bl = productChanged = productUpdateResponse.getProductType() != productUpdateResponse.getPrevoiusProductType();
                if (!this.sendPaymentConfirmationEmail(transaction, productChanged, true)) {
                    log.warn((Object)("Failed to send payment confirmation email for transaction with transactionId=" + transaction.getTransactionId() + "."));
                }
            } else {
                log.warn((Object)("Validity for lan device with lanDeviceId=" + transaction.getLanDevice().getLanDeviceId() + " was not prolonged."));
            }
        }
        if (this.transactionDAO.updateTransaction(transaction) == null) {
            log.warn((Object)"Transaction state was not updated in the database.");
        }
    }

    private boolean verifyOrderId(String orderId) {
        if (orderId == null) {
            return false;
        }
        if (!orderId.matches("[0-9]{20}")) {
            log.warn((Object)("Unexpected form of orderId: " + orderId + "."));
            return false;
        }
        return true;
    }

    private Integer getTransacionId(String orderId) {
        return Integer.parseInt(orderId.substring(14));
    }

    private Date getTransactionTimestamp(String orderId) {
        return Utils.parseDate((String)orderId.substring(0, 14), (String)"yyyyMMddHHmmss");
    }

    private boolean sendPaymentConfirmationEmail(TransactionEntity transaction, boolean changedProduct, boolean notifyOperator) {
        String paymentOperatorEmail;
        log.trace((Object)("start sendPaymentConfirmationEmail(transaction with transactionId=" + transaction.getTransactionId() + ", changedProduct=" + changedProduct + ", notifyOperator=" + notifyOperator + ")"));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%VALID_TO%", Utils.formatDate((Date)transaction.getValidTo(), (String)"yyyy-MM-dd"));
        placeholders.put("%REFERENCE_NR%", transaction.getReferenceNr());
        placeholders.put("%AMOUNT%", String.valueOf(transaction.getAmount()));
        placeholders.put("%CURRENCY%", transaction.getCurrency());
        placeholders.put("%CAMERA_NAME%", transaction.getLanDevice().getName());
        placeholders.put("%CAMERA_MAC%", transaction.getLanDevice().getMac());
        placeholders.put("%DATE%", Utils.formatDate((Date)transaction.getTimestamp(), (String)"yyyy-MM-dd"));
        placeholders.put("%PAYMENT_METHOD%", this.getPaymentType(transaction));
        placeholders.putAll(this.emailNotificationService.getUserPlaceholders(transaction.getUser().toDTO()));
        if (notifyOperator && !this.emailNotificationService.sendEmail(paymentOperatorEmail = this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL), EmailNotificationService.EmailCode.PAYMENT_OPERATOR_NOTIFICATION, "en", placeholders, null)) {
            log.warn((Object)("Failed to send payment operator notification for transaction with transactionId=" + transaction.getTransactionId() + "."));
        }
        String templateCode = null;
        if (changedProduct) {
            log.debug((Object)"Product has been changed. Sending email with product changed.");
            templateCode = transaction.getLanDevice().getProductFeatureValue(DeviceFeatureCode.PAYMENT_CONFIRMATION_NEW_EMAIL_TEMPLATE);
        } else {
            log.debug((Object)"Product has not been changed. Sending email with product continue.");
            templateCode = transaction.getLanDevice().getProductFeatureValue(DeviceFeatureCode.PAYMENT_CONFIRMATION_CONT_EMAIL_TEMPLATE);
        }
        if (templateCode == null) {
            log.debug((Object)"Not found any templates for payment. Sending default template");
            templateCode = EmailNotificationService.EmailCode.PAYMENT_CONFIRMATION.name();
        }
        return this.emailNotificationService.sendEmail(transaction.getUser().toDTO(), templateCode, placeholders, null);
    }

    private String getPaymentType(TransactionEntity transaction) {
        if (transaction == null) {
            return "";
        }
        if (transaction.getPaymentType() == null) {
            return "";
        }
        String paymentType = null;
        if ("DATATRANS".equals(transaction.getGateway())) {
            paymentType = (String)this.datatrancePaymentTypes.get(transaction.getPaymentType());
        }
        return paymentType == null ? "" : paymentType;
    }

    public ResendPaymentReceiptStatus resendPaymentReceipt(Integer transactionId, boolean notifyOperator) throws InvalidSessionException {
        log.trace((Object)("start resendPaymentReceipt(transactionId=" + transactionId + ", notifyOperator=" + notifyOperator + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (transactionId == null) {
            return ResendPaymentReceiptStatus.FAILD_INVALIDTRANSACTIONID;
        }
        TransactionEntity transaction = this.transactionDAO.findTransactionById(transactionId);
        if (transaction == null) {
            return ResendPaymentReceiptStatus.FAILED_TRANSACTIONNOTFOUND;
        }
        return this.sendPaymentConfirmationEmail(transaction, true, notifyOperator) ? ResendPaymentReceiptStatus.SUCCESS : ResendPaymentReceiptStatus.ERROR;
    }

    @Transactional
    public ExtendValidityResponse extendValidity(Integer lanDeviceId, Transaction transaction) throws InvalidSessionException {
        log.trace((Object)("start extendValidity(lanDeviceId=" + lanDeviceId + ", transaction=" + transaction + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.INTEGRATION);
        if (lanDeviceId == null) {
            return new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_INVALIDDEVICEID);
        }
        if (!this.verifyTransation(transaction)) {
            return new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_INVALID);
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null || device.getDeleted()) {
            return new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.FAILED_NOTFOUNDDEVICE);
        }
        UpdateDeviceProductResponse updateDeviceProductResponse = this.lanDeviceService.updateDeviceProduct(lanDeviceId, DeviceProduct.DeviceProductType.PREMIUM);
        if (updateDeviceProductResponse.getStatus() != UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS) {
            log.warn((Object)("Failed to prolong device validity for device with lanDeviceId=" + lanDeviceId + ": " + updateDeviceProductResponse.getStatus()));
            return new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.ERROR);
        }
        TransactionEntity transactionEntity = new TransactionEntity();
        transactionEntity.setTimestamp(this.systemSupport.getCurrentDate());
        transactionEntity.setUser(device.getUser());
        transactionEntity.setCurrency(transaction.getCurrency());
        transactionEntity.setAmount(transaction.getAmount());
        transactionEntity.setReferenceNr(transaction.getReferenceNr());
        transactionEntity.setStatus("success");
        transactionEntity.setLanDevice(device);
        transactionEntity.setValidTo(updateDeviceProductResponse.getValidTo());
        transactionEntity.setGateway(transaction.getGateway());
        transactionEntity.setPaymentType(transaction.getPaymentType());
        if (this.transactionDAO.updateTransaction(transactionEntity) == null) {
            return new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.ERROR);
        }
        return new ExtendValidityResponse(ExtendValidityResponse.ExtendValidityStatus.SUCCESS, updateDeviceProductResponse.getValidTo());
    }

    private boolean verifyTransation(Transaction transaction) {
        if (transaction == null) {
            log.debug((Object)"Invalid transation: null.");
            return false;
        }
        if (transaction.getAmount() == null) {
            log.debug((Object)"Invalid amount: null.");
            return false;
        }
        if (!this.currencyValidator.validate(transaction.getCurrency())) {
            log.debug((Object)("Invalid currency: " + transaction.getCurrency() + "."));
            return false;
        }
        if (!this.notEmptyValidator.validate(transaction.getGateway())) {
            log.debug((Object)("Invalid gateway: " + transaction.getGateway() + "."));
            return false;
        }
        if (!this.notEmptyValidator.validate(transaction.getReferenceNr())) {
            log.debug((Object)("Invalid reference number: " + transaction.getReferenceNr() + "."));
            return false;
        }
        if (!this.notEmptyValidator.validate(transaction.getPaymentType())) {
            log.debug((Object)("Invalid payment type: " + transaction.getPaymentType() + "."));
            return false;
        }
        return true;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$PaymentGateway() {
        if ($SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$PaymentGateway != null) {
            return $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$PaymentGateway;
        }
        int[] nArray = new int[PaymentGateway.values().length];
        try {
            nArray[PaymentGateway.DATATRANS.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[PaymentGateway.POSTFINANCE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$hm$WebViewer$shared$model$PaymentGateway = nArray;
        return nArray;
    }
}

