/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.ParameterDAO;
import pl.smartapps.restserver.db.main.ParameterEntity;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.ParameterServiceImpl;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={ParameterServiceImpl.class})
public class ParameterServiceImplTests {
    private ParameterServiceImpl parameterService;
    private ParameterDAO parameterDAO;

    @Before
    public void setUp() {
        this.parameterService = new ParameterServiceImpl();
        this.parameterDAO = (ParameterDAO)PowerMock.createMock(ParameterDAO.class);
        this.parameterService.setParameterDAO(this.parameterDAO);
    }

    @Test
    public void testGetParameterValue() {
        ParameterEntity parameter = new ParameterEntity(Integer.valueOf(1), "payment.notificationEmail", "parameterValue");
        EasyMock.expect((Object)this.parameterDAO.getParameter(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)parameter);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)"parameterValue", (Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetParameterValueForMissingParameter() {
        EasyMock.expect((Object)this.parameterDAO.getParameter(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL));
        PowerMock.verifyAll();
    }

    @Test
    public void testGetParameterValueForNullParameterCode() {
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals(null, (Object)this.parameterService.getParameterValue(null));
        PowerMock.verifyAll();
    }

    @Test
    public void testAddParameter() {
        ParameterEntity parameter = new ParameterEntity();
        parameter.setCode("payment.notificationEmail");
        parameter.setValue("parameterValue");
        ParameterEntity savedParameter = new ParameterEntity(Integer.valueOf(1), "payment.notificationEmail", "parameterValue");
        EasyMock.expect((Object)this.parameterDAO.createParameter(parameter)).andReturn((Object)savedParameter);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.parameterService.addParameter(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL, "parameterValue"));
        PowerMock.verifyAll();
    }

    @Test
    public void testAddParameterForNullParameterCode() {
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.parameterService.addParameter(null, "parameterValue"));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateParameter() {
        ParameterEntity parameter = new ParameterEntity(Integer.valueOf(1), "payment.notificationEmail", "parameterValue");
        EasyMock.expect((Object)this.parameterDAO.getParameter(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn((Object)parameter);
        parameter.setValue("newParameterValue");
        ParameterEntity savedParameter = new ParameterEntity(Integer.valueOf(1), "payment.notificationEmail", "newParameterValue");
        EasyMock.expect((Object)this.parameterDAO.update(parameter)).andReturn((Object)savedParameter);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.parameterService.updateParameter(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL, "newParameterValue"));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateParameterValueForMissingParameter() {
        EasyMock.expect((Object)this.parameterDAO.getParameter(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.parameterService.updateParameter(ParameterService.ParameterCode.PAYMENT_NOTIFICATION_EMAIL, "newParameterValue"));
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateParameterForNullParameterCode() {
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.parameterService.updateParameter(null, "parameterValue"));
        PowerMock.verifyAll();
    }
}

