/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Service;
import pl.smartapps.restserver.db.dao.ParameterDAO;
import pl.smartapps.restserver.db.main.ParameterEntity;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.util.Utils;

@Service
public class ParameterServiceImpl
implements ParameterService {
    private static Logger log = Logger.getLogger(ParameterServiceImpl.class);
    private ParameterDAO parameterDAO;
    private AuthenticationUtils authUtils;

    @Autowired
    @Required
    public void setParameterDAO(ParameterDAO parameterDAO) {
        this.parameterDAO = parameterDAO;
    }

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    public String getString(ParameterService.ParameterCode code) {
        return this.getString(code, null);
    }

    public String getString(ParameterService.ParameterCode code, String defaultValue) {
        ParameterEntity entity = this.parameterDAO.getParameter(code);
        return entity == null ? defaultValue : entity.getValue();
    }

    public String getParameterValue(ParameterService.ParameterCode code) {
        log.trace((Object)("start getParameterValue(parameterCode=" + code + ")"));
        if (code == null) {
            return null;
        }
        ParameterEntity parameter = this.parameterDAO.getParameter(code);
        return parameter == null ? null : parameter.getValue();
    }

    public boolean getBoolParameterValue(ParameterService.ParameterCode parameterCode, boolean defaultValue) {
        String value = this.getParameterValue(parameterCode);
        if (Utils.isBlank((String)value)) {
            return defaultValue;
        }
        String[] values = new String[]{"on", "off", "true", "false", "yes", "no"};
        if (!this.validate(value, values)) {
            log.warn((Object)("Unsupported bool value " + value + " for parameterCode=" + parameterCode + "."));
            return defaultValue;
        }
        return value.equalsIgnoreCase("on") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes");
    }

    private boolean validate(String value, String[] permittedValus) {
        String[] stringArray = permittedValus;
        int n = permittedValus.length;
        int n2 = 0;
        while (n2 < n) {
            String permittedValue = stringArray[n2];
            if (permittedValue.equalsIgnoreCase(value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean getBoolParameterValue(ParameterService.ParameterCode parameterCode) {
        return this.getBoolParameterValue(parameterCode, false);
    }

    public Integer getIntegerParameterValue(ParameterService.ParameterCode parameterCode, Integer defaultValue) {
        String value = this.getParameterValue(parameterCode);
        return value == null ? defaultValue : Integer.valueOf(value);
    }

    public Integer getIntegerParameterValue(ParameterService.ParameterCode parameterCode) {
        return this.getIntegerParameterValue(parameterCode, null);
    }

    public Long getLongParameterValue(ParameterService.ParameterCode parameterCode, Long defaultValue) {
        String value = this.getParameterValue(parameterCode);
        return value == null ? defaultValue : Long.valueOf(value);
    }

    public Long getLongParameterValue(ParameterService.ParameterCode parameterCode) {
        return this.getLongParameterValue(parameterCode, null);
    }

    public boolean addParameter(ParameterService.ParameterCode parameterCode, String parameterValue) {
        log.trace((Object)("start addParameter(parameterCode=" + parameterCode + ", parameterValue=" + parameterValue + ")"));
        if (parameterCode == null) {
            return false;
        }
        ParameterEntity parameter = new ParameterEntity();
        parameter.setCode(parameterCode.getCode());
        parameter.setValue(parameterValue);
        ParameterEntity savedParameter = this.parameterDAO.createParameter(parameter);
        return savedParameter != null;
    }

    public boolean updateParameter(ParameterService.ParameterCode code, String parameterValue) {
        log.trace((Object)("start updateParameter(code=" + code + ", parameterValue=" + parameterValue + ")"));
        if (code == null) {
            return false;
        }
        ParameterEntity parameter = this.parameterDAO.getParameter(code);
        if (parameter == null) {
            log.warn((Object)("No parameter found for code=" + code.getCode()));
            return false;
        }
        parameter.setValue(parameterValue);
        ParameterEntity savedParameter = this.parameterDAO.update(parameter);
        return savedParameter != null;
    }

    public String getParameterValueWhenLoggedIn(ParameterService.ParameterCode code) throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        return this.getParameterValue(code);
    }

    public String getParameterValueWhenLoggedIn(String code) throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        return this.getParameterValue(ParameterService.ParameterCode.valueOf((String)code));
    }
}

