/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.stereotype.Component;
import pl.smartapps.hm.WebViewer.shared.model.Message;
import pl.smartapps.restserver.db.dao.MessageDAO;
import pl.smartapps.restserver.db.main.MessageEntity;
import pl.smartapps.restserver.service.MessagesService;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class MessagesServiceImpl
implements MessagesService {
    private static Logger log = Logger.getLogger(MessagesServiceImpl.class);
    private MessageDAO messageDao;

    @Autowired
    @Required
    void setMessageDao(MessageDAO messageDao) {
        this.messageDao = messageDao;
    }

    public List<Message> getMessages(String version, String lang, String platform) {
        log.debug((Object)("start getMessages(version=" + version + ", platform=" + platform + ")"));
        if (platform == null || platform.isEmpty()) {
            platform = "iphone";
        }
        List allMessages = this.messageDao.getMessages(lang, platform);
        ArrayList<Message> messages = new ArrayList<Message>();
        for (MessageEntity messageEntity : allMessages) {
            String minVersion = messageEntity.getMinVersion();
            String maxVersion = messageEntity.getMaxVersion();
            if (minVersion != null && !minVersion.isEmpty() && MessagesServiceImpl.compare((String)version, (String)minVersion) < 0 || maxVersion != null && !maxVersion.isEmpty() && MessagesServiceImpl.compare((String)version, (String)maxVersion) > 0) continue;
            messages.add(messageEntity.toDTO());
        }
        log.debug((Object)("exit getMessages(version=" + version + ", platform=" + platform + ") messages=" + ((Object)messages).toString()));
        return messages;
    }

    public static int compare(String version, String toVersion) {
        if (version.compareTo(toVersion) == 0) {
            return 0;
        }
        String[] versionTab = version.split("\\.");
        String[] toTab = toVersion.split("\\.");
        int i = 0;
        while (i < versionTab.length) {
            int to;
            if (i >= toTab.length) break;
            int vers = Integer.parseInt(versionTab[i]);
            if (vers > (to = Integer.parseInt(toTab[i]))) {
                return 1;
            }
            if (vers < to) {
                return -1;
            }
            ++i;
        }
        if (versionTab.length < toTab.length) {
            if (toTab[toTab.length - 1].equals("0")) {
                return 0;
            }
            return -1;
        }
        if (toTab.length < versionTab.length) {
            if (versionTab[versionTab.length - 1].equals("0")) {
                return 0;
            }
            return 1;
        }
        return -1;
    }
}

