/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.util.SharedCache;
import java.util.concurrent.ConcurrentMap;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import org.powermock.reflect.Whitebox;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.impl.AttemptHandler;
import pl.smartapps.restserver.service.impl.LoginAttemptServiceImpl;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LoginAttemptServiceImpl.class, AttemptHandler.class})
public class LoginAttemptServiceImplTests {
    private LoginAttemptServiceImpl service;
    private ParameterService parameterService;
    private SharedCache sharedCache;

    @Before
    public void setUp() {
        this.service = new LoginAttemptServiceImpl();
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.service.setParameterService(this.parameterService);
        this.sharedCache = (SharedCache)PowerMock.createMock(SharedCache.class);
        this.service.setSharedCache(this.sharedCache);
    }

    @Test
    public void testInitialize() {
        ConcurrentMap map = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        EasyMock.expect((Object)this.sharedCache.getMap("loginAttempts")).andReturn((Object)map);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.initialize();
        PowerMock.verifyAll();
    }

    @Test
    public void testIsLockTrue() {
        ConcurrentMap loginAttempts = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.service, (String)"attempts", (Object)loginAttempts);
        String username = "testUsername";
        AttemptHandler loginAttempt = (AttemptHandler)PowerMock.createMock(AttemptHandler.class);
        EasyMock.expect(loginAttempts.get(username)).andReturn((Object)loginAttempt);
        EasyMock.expect((Object)loginAttempt.isLocked()).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)true, (Object)this.service.locked(username));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsLockFalseForNotNull() {
        ConcurrentMap loginAttempts = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.service, (String)"attempts", (Object)loginAttempts);
        String username = "testUsername";
        AttemptHandler loginAttempt = (AttemptHandler)PowerMock.createMock(AttemptHandler.class);
        EasyMock.expect(loginAttempts.get(username)).andReturn((Object)loginAttempt);
        EasyMock.expect((Object)loginAttempt.isLocked()).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.service.locked(username));
        PowerMock.verifyAll();
    }

    @Test
    public void testIsLockFalseForNull() {
        ConcurrentMap loginAttempts = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.service, (String)"attempts", (Object)loginAttempts);
        String username = "testUsername";
        EasyMock.expect(loginAttempts.get(username)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)false, (Object)this.service.locked(username));
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterLoginAttemptForNullAttempt() throws Exception {
        ConcurrentMap loginAttempts = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.service, (String)"attempts", (Object)loginAttempts);
        String username = "testUsername";
        EasyMock.expect(loginAttempts.get(username)).andReturn(null);
        AttemptHandler loginAttempt = (AttemptHandler)PowerMock.createMock(AttemptHandler.class);
        Long lockPeriod = 180000L;
        EasyMock.expect((Object)this.parameterService.getLongParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_LOCK_PERIOD, Long.valueOf(900000L))).andReturn((Object)lockPeriod);
        Integer maxAttemptCount = 3;
        EasyMock.expect((Object)this.parameterService.getIntegerParameterValue(ParameterService.ParameterCode.USER_AUTHENTICATION_MAX_ATTEMPT_COUNT, Integer.valueOf(5))).andReturn((Object)maxAttemptCount);
        PowerMock.expectNew(AttemptHandler.class, (Object[])new Object[]{lockPeriod, maxAttemptCount}).andReturn((Object)loginAttempt);
        loginAttempt.update();
        loginAttempts.put(username, loginAttempt);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.record(username);
        PowerMock.verifyAll();
    }

    @Test
    public void testRegisterLoginAttemptForNotNullAttempt() throws Exception {
        ConcurrentMap loginAttempts = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.service, (String)"attempts", (Object)loginAttempts);
        String username = "testUsername";
        AttemptHandler loginAttempt = (AttemptHandler)PowerMock.createMock(AttemptHandler.class);
        EasyMock.expect(loginAttempts.get(username)).andReturn((Object)loginAttempt);
        loginAttempt.update();
        loginAttempts.put(username, loginAttempt);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.record(username);
        PowerMock.verifyAll();
    }

    @Test
    public void testReset() {
        ConcurrentMap loginAttempts = (ConcurrentMap)PowerMock.createMock(ConcurrentMap.class);
        Whitebox.setInternalState((Object)this.service, (String)"attempts", (Object)loginAttempts);
        String username = "testUsername";
        EasyMock.expect(loginAttempts.remove(username)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.service.reset(username);
        PowerMock.verifyAll();
    }
}

