/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.allen_sauer.gwt.log.client.Log;
import com.vg.util.ContentRange;
import com.vg.util.LimitedBandwidthInputStream;
import com.vg.util.RandomAccessFileBufferedInputStream;
import com.vg.util.SeekableInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.service.EventsFilesController;
import pl.smartapps.restserver.service.SystemSupport;

@Component
public class LocalFilesController
implements EventsFilesController {
    private static Logger log = Logger.getLogger(LocalFilesController.class);
    private SystemSupport systemSupport;
    private String snapshotsPath;
    private long bandwidthLimit = 0x200000L;
    long firstBurst = 5000000L;

    @Autowired
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Value(value="${lanDevice.snapshotsPath:./events}")
    public void setSnapshotsPath(String snapshotsPath) {
        this.snapshotsPath = snapshotsPath;
    }

    public void uploadFile(String filePath) {
    }

    public void downloadImage(HttpServletRequest request, HttpServletResponse response, EventEntity event, String fileName, String saveFileName) throws UnsupportedEncodingException {
        File snapshot = null;
        snapshot = new File(String.valueOf(this.snapshotsPath) + fileName);
        if (!(snapshot.exists() && snapshot.isFile() && snapshot.canRead())) {
            Log.warn((String)("SC_NOT_FOUND: snapshot = " + snapshot.getAbsolutePath()));
            response.setStatus(404);
            return;
        }
        response.setContentType("image/jpeg");
        response.setContentLength((int)snapshot.length());
        this.prepareAttachmentHeader(request, response, saveFileName);
        try {
            FileInputStream in = new FileInputStream(snapshot);
            ServletOutputStream out = response.getOutputStream();
            byte[] buf = new byte[1024];
            int count = 0;
            while ((count = in.read(buf)) >= 0) {
                out.write(buf, 0, count);
            }
            in.close();
            out.close();
        }
        catch (IOException ioe) {
            log.warn((Object)("Failed to send event snapshot for event id " + event.getEventId() + " due to '" + ioe.getMessage() + "'"));
        }
    }

    private void prepareAttachmentHeader(HttpServletRequest request, HttpServletResponse response, String saveFileName) throws UnsupportedEncodingException {
        String attachmentString = "attachment; filename*=UTF-8''";
        if (this.isSafariBrowser(request) || this.isInternetExplorerBrowser(request)) {
            attachmentString = "attachment; filename=";
        }
        if (!this.isSafariBrowser(request)) {
            saveFileName = this.encodeFileName(saveFileName);
        }
        response.setHeader("Content-Disposition", String.valueOf(attachmentString) + saveFileName);
    }

    public void downloadVideo(HttpServletRequest request, HttpServletResponse response, EventEntity event, String fileName, String saveFileName) throws UnsupportedEncodingException {
        block9: {
            File footage = new File(String.valueOf(this.snapshotsPath) + fileName);
            if (!(footage.exists() && footage.isFile() && footage.canRead())) {
                response.setStatus(404);
                return;
            }
            int length = (int)footage.length();
            response.setContentType("video/mp4");
            response.setContentLength(length);
            response.setDateHeader("Expires", 0L);
            response.setHeader("Accept-Ranges", "bytes");
            if (!this.isInternetExplorerBrowser(request)) {
                response.setHeader("Pragma", "no-cache");
                response.setHeader("Cache-Control", "no-store,private,no-cache");
            }
            this.prepareAttachmentHeader(request, response, saveFileName);
            String range = request.getHeader("Range");
            RandomAccessFileBufferedInputStream baseIn = null;
            Object is = null;
            try {
                try {
                    is = baseIn = new RandomAccessFileBufferedInputStream(footage);
                    if (range == null) {
                        response.setHeader("Content-Length", String.valueOf(length));
                    } else {
                        response.setStatus(206);
                        ContentRange r = ContentRange.parseRange((String)range, (long)length);
                        response.setHeader("Content-Range", r.toHeaderValue());
                        response.setHeader("Content-Length", String.valueOf(r.getContentLength()));
                        is = r.limitedInputStream((SeekableInputStream)baseIn);
                    }
                    IOUtils.copy((InputStream)this.limitBandwidth((InputStream)is), (OutputStream)response.getOutputStream());
                }
                catch (IOException ioe) {
                    log.debug((Object)("Failed to send event footage for event id " + event.getEventId() + " due to '" + ioe.getMessage() + "'"));
                    IOUtils.closeQuietly((InputStream)is);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    private boolean isSafariBrowser(HttpServletRequest request) {
        String userAgentString = request.getHeader("User-Agent");
        boolean isSafari = userAgentString.contains("Safari");
        boolean isChrome = userAgentString.contains("Chrome");
        return isSafari && !isChrome;
    }

    private boolean isInternetExplorerBrowser(HttpServletRequest request) {
        return request.getHeader("User-Agent").contains("MSIE");
    }

    private String encodeFileName(String fileName) throws UnsupportedEncodingException {
        return URLEncoder.encode(fileName, "UTF-8").replace("+", "%20");
    }

    public boolean deleteFile(String fileName) {
        return this.systemSupport.deleteFile(this.generateFilePath(fileName));
    }

    public boolean fileExists(String fileName) {
        return this.systemSupport.getFile(this.generateFilePath(fileName)).exists();
    }

    public void stop() {
    }

    private String generateFilePath(String fileName) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.snapshotsPath);
        sb.append("/");
        sb.append(fileName);
        return sb.toString();
    }

    private InputStream limitBandwidth(InputStream in) {
        if (this.bandwidthLimit > 0L) {
            return new LimitedBandwidthInputStream(in, this.bandwidthLimit, this.firstBurst);
        }
        return in;
    }
}

