/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.VivotekCameraDiscoveryService;
import pl.smartapps.containerserver.VivotekCameraIpAddressDiscoveryService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.ActivateCameraResponse;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.EncryptionMode;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.ICEParameters;
import pl.smartapps.hm.WebViewer.shared.model.ICEParams;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LanDeviceParam;
import pl.smartapps.hm.WebViewer.shared.model.LanDeviceStatus;
import pl.smartapps.hm.WebViewer.shared.model.LogConfiguration;
import pl.smartapps.hm.WebViewer.shared.model.ReconfigurationDeviceStatus;
import pl.smartapps.hm.WebViewer.shared.model.Rssi;
import pl.smartapps.hm.WebViewer.shared.model.UpdateDeviceProductResponse;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.UpgradeFirmwareStatus;
import pl.smartapps.hm.WebViewer.shared.model.User;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoint;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoints;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.FeatureEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.rest.response.CheckDeviceTrialProductResponse;
import pl.smartapps.restserver.rest.response.DeviceVerificationResponse;
import pl.smartapps.restserver.rest.response.GetLanDevicesResponse;
import pl.smartapps.restserver.rest.response.VerifyGcResponse;
import pl.smartapps.restserver.rest.response.VideoStreamParamsResponse;
import pl.smartapps.restserver.rest.security.PasswordGenerator;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.VideoStreamService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;
import pl.smartapps.restserver.service.impl.ActivationCodeHandler;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.LanDeviceServiceImpl;
import pl.smartapps.restserver.service.impl.LanDeviceServiceInternal;
import pl.smartapps.restserver.service.impl.LanDeviceServiceTests;
import pl.smartapps.restserver.service.impl.ProductBuilder;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LanDeviceServiceImpl.class})
public class LanDeviceServiceTests
extends LanDeviceServiceInternal {
    private ParameterService parameterService;

    @Before
    public void setUp() throws ClassNotFoundException, SQLException {
        this.lanDeviceService = new LanDeviceServiceImpl();
        this.gatewayClientDAO = (GatewayClientDAO)PowerMock.createMock(GatewayClientDAO.class);
        this.lanDeviceService.setGatewayClientDAO(this.gatewayClientDAO);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.lanDeviceService.setLanDeviceDAO(this.lanDeviceDAO);
        this.deviceDescDAO = (DeviceDescDAO)PowerMock.createMock(DeviceDescDAO.class);
        this.lanDeviceService.setDeviceDescDAO(this.deviceDescDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.lanDeviceService.setAuthUtils(this.authUtils);
        this.deviceDriverFactory = (DeviceDriverFactory)PowerMock.createMock(DeviceDriverFactory.class);
        this.lanDeviceService.setDeviceDriverFactory(this.deviceDriverFactory);
        this.containerserverServiceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.lanDeviceService.setContainerserverServiceFactory(this.containerserverServiceFactory);
        this.passwordGenerator = (PasswordGenerator)PowerMock.createMock(PasswordGenerator.class);
        this.lanDeviceService.setPasswordGenerator(this.passwordGenerator);
        this.ipAddressDiscoveryService = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        this.eventlogService = (EventlogService)PowerMock.createMock(EventlogService.class);
        this.lanDeviceService.setEventlogService(this.eventlogService);
        this.gatewayClientService = (GatewayClientService)PowerMock.createMock(GatewayClientService.class);
        this.lanDeviceService.setGatewayClientService(this.gatewayClientService);
        this.activationCodeHandler = (ActivationCodeHandler)PowerMock.createMock(ActivationCodeHandler.class);
        this.lanDeviceService.setActivationCodeHandler(this.activationCodeHandler);
        this.gatewayDeviceConnection = (GatewayDeviceConnectionService)PowerMock.createMock(GatewayDeviceConnectionService.class);
        this.lanDeviceService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.productManagementService = (ProductManagementService)PowerMock.createMock(ProductManagementService.class);
        this.lanDeviceService.setProductManagementService(this.productManagementService);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.lanDeviceService.setSystemSupport(this.systemSupport);
        this.emailNotificationService = (EmailNotificationService)PowerMock.createMock(EmailNotificationService.class);
        this.lanDeviceService.setEmailNotificationService(this.emailNotificationService);
        this.videoStreamService = (VideoStreamService)PowerMock.createMock(VideoStreamService.class);
        this.lanDeviceService.setVideoStreamService(this.videoStreamService);
        this.eventDAO = (EventDAO)PowerMock.createMock(EventDAO.class);
        this.lanDeviceService.setEventDAO(this.eventDAO);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.lanDeviceService.setParameterService(this.parameterService);
    }

    @Test
    public void testFindLanDevices() throws Exception {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        GatewayClientEntity gatewayClient = TestDataUtils.prepareGatewaClientEntity();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1), false)).andReturn((Object)gatewayClient);
        ArrayList<DiscoveredLanDevice> discoveredDevices = new ArrayList<DiscoveredLanDevice>(2);
        DiscoveredLanDevice discoveredDevice1 = new DiscoveredLanDevice("00:0A:E6:3E:FD:E1", "192.168.1.1", "dev1");
        discoveredDevice1.setDeviceDriver("CameraVivotekGeneric");
        discoveredDevices.add(discoveredDevice1);
        DiscoveredLanDevice discoveredDevice2 = new DiscoveredLanDevice("00:0A:E6:3E:FD:10", "192.168.1.10", "dev10");
        discoveredDevice2.setDeviceDriver("CameraVivotekGeneric");
        discoveredDevices.add(discoveredDevice2);
        VivotekCameraDiscoveryService discoveryService = (VivotekCameraDiscoveryService)PowerMock.createMock(VivotekCameraDiscoveryService.class);
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraDiscoveryService()).andReturn((Object)discoveryService);
        EasyMock.expect((Object)discoveryService.discover("00:1A:B6:00:0B:B5")).andReturn(discoveredDevices);
        ArrayList<LanDeviceEntity> alreadyRegisteredDevices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity alreadyRegisteredDevice1 = new LanDeviceEntity();
        alreadyRegisteredDevice1.setLanDeviceId(Integer.valueOf(1));
        alreadyRegisteredDevice1.setName("dev1");
        alreadyRegisteredDevice1.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        alreadyRegisteredDevice1.setMac("00:0A:E6:3E:FD:E1");
        alreadyRegisteredDevice1.setIpAddress("192.168.1.1");
        alreadyRegisteredDevice1.setPort(Integer.valueOf(80));
        alreadyRegisteredDevice1.setUsername("root");
        alreadyRegisteredDevice1.setPass("rootPass");
        alreadyRegisteredDevice1.setVersion("TC5633-TCSW-0100h");
        alreadyRegisteredDevice1.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        alreadyRegisteredDevices.add(alreadyRegisteredDevice1);
        LanDeviceEntity alreadyRegisteredDevice2 = new LanDeviceEntity();
        alreadyRegisteredDevice2.setLanDeviceId(Integer.valueOf(2));
        alreadyRegisteredDevice2.setName("dev2");
        alreadyRegisteredDevice2.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        alreadyRegisteredDevice2.setMac("00:0A:E6:3E:FD:E2");
        alreadyRegisteredDevice2.setIpAddress("192.168.1.2");
        alreadyRegisteredDevice2.setPort(Integer.valueOf(80));
        alreadyRegisteredDevice2.setUsername("root");
        alreadyRegisteredDevice2.setPass("rootPass");
        alreadyRegisteredDevice2.setVersion("TC5633-TCSW-0100h");
        alreadyRegisteredDevice2.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        alreadyRegisteredDevices.add(alreadyRegisteredDevice2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewayClientId(Integer.valueOf(1))).andReturn(alreadyRegisteredDevices);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null).times(2);
        PowerMock.replayAll((Object[])new Object[0]);
        List response = this.lanDeviceService.findLanDevices(Integer.valueOf(1));
        PowerMock.verifyAll();
        LanDevice expDev = new LanDevice();
        expDev.setMac("00:0A:E6:3E:FD:10");
        expDev.setIpAddress("192.168.1.10");
        expDev.setName("dev10");
        expDev.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        expDev.setGatewayClient(TestDataUtils.prepareGatewaClient());
        ArrayList<LanDevice> expectedResponse = new ArrayList<LanDevice>();
        expectedResponse.add(expDev);
        Assert.assertEquals(expectedResponse, (Object)response);
    }

    @Test
    public void testVerifyDiscoveredLanDevice() throws Exception {
        GatewayClientEntity gatewayClient = TestDataUtils.prepareGatewaClientEntity();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1), false)).andReturn((Object)gatewayClient);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(devices);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescById(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        LanDevice deviceToVerify = new LanDevice();
        deviceToVerify.setMac("00:02:D1:06:CD:80");
        deviceToVerify.setIpAddress("192.168.21.138");
        deviceToVerify.setUser("root");
        deviceToVerify.setPass("rootPass");
        deviceToVerify.setGatewayClient(TestDataUtils.prepareGatewaClient());
        deviceToVerify.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        EasyMock.expect((Object)driver.verify(deviceToVerify)).andReturn((Object)AccessVerificationStatus.OK);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceVerificationResponse response = this.lanDeviceService.verifyDiscoveredLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:80", "192.168.21.138", Integer.valueOf(1));
        DeviceVerificationResponse expectedResponse = new DeviceVerificationResponse(DeviceVerificationResponse.DeviceVerificationStatus.OK, deviceToVerify);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testVerifyDiscoveredLanDeviceFailedVerify() throws Exception {
        GatewayClientEntity gatewayClient = TestDataUtils.prepareGatewaClientEntity();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1), false)).andReturn((Object)gatewayClient);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)false, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(devices);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescById(Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        LanDevice deviceToVerify = new LanDevice();
        deviceToVerify.setMac("00:02:D1:06:CD:80");
        deviceToVerify.setIpAddress("192.168.21.138");
        deviceToVerify.setUser("root");
        deviceToVerify.setPass("rootPass");
        deviceToVerify.setGatewayClient(TestDataUtils.prepareGatewaClient());
        deviceToVerify.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        EasyMock.expect((Object)driver.verify(deviceToVerify)).andReturn((Object)AccessVerificationStatus.NOANSWER);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceVerificationResponse response = this.lanDeviceService.verifyDiscoveredLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:80", "192.168.21.138", Integer.valueOf(1));
        DeviceVerificationResponse expectedResponse = new DeviceVerificationResponse(DeviceVerificationResponse.DeviceVerificationStatus.NOANSWER, deviceToVerify);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testVerifyDiscoveredLanDeviceFailedNoSuchGC() throws Exception {
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1), false)).andReturn(null);
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceVerificationResponse response = this.lanDeviceService.verifyDiscoveredLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:80", "192.168.21.138", Integer.valueOf(1));
        DeviceVerificationResponse expectedResponse = new DeviceVerificationResponse(DeviceVerificationResponse.DeviceVerificationStatus.FAILED, null);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetRegistredLanDevicesWithDeviceLimit() throws Exception {
        ArrayList<LanDeviceEntity> foundLanDeviceEntities = new ArrayList<LanDeviceEntity>();
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        Date activationDate = Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15);
        GatewayClientEntity gatewayClientEntity1 = TestDataUtils.prepareGatewaClientEntity((Integer)1, (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (Date)activationDate, (boolean)false);
        LanDeviceEntity foundLanDeviceEntity1 = new LanDeviceEntity();
        foundLanDeviceEntity1.setLanDeviceId(Integer.valueOf(1));
        foundLanDeviceEntity1.setName("TC5633-TCSW-0100h");
        foundLanDeviceEntity1.setDescription("Vivotek camea in office");
        foundLanDeviceEntity1.setLocation("Room No. 106");
        foundLanDeviceEntity1.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDeviceEntity1.setMac("00:02:D1:06:CD:80");
        foundLanDeviceEntity1.setIpAddress("192.168.21.138");
        foundLanDeviceEntity1.setPort(Integer.valueOf(80));
        foundLanDeviceEntity1.setUsername("root");
        foundLanDeviceEntity1.setPass("rootPass");
        foundLanDeviceEntity1.setVersion("TC5633-TCSW-0100h");
        foundLanDeviceEntity1.setGatewayClient(gatewayClientEntity1);
        foundLanDeviceEntity1.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        foundLanDeviceEntity1.setUser(null);
        foundLanDeviceEntity1.setDeleted(false);
        foundLanDeviceEntity1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        foundLanDeviceEntity1.setProduct(productEntity);
        foundLanDeviceEntities.add(foundLanDeviceEntity1);
        GenericLanDevice driver1 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundLanDeviceEntity1)).andReturn((Object)driver1);
        EasyMock.expect((Object)driver1.isFirmwareUpToDate(foundLanDeviceEntity1)).andReturn((Object)true);
        EasyMock.expect((Object)driver1.getConnCheckUrl()).andReturn((Object)"/driver1");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        GatewayClientEntity gatewayClientEntity2 = TestDataUtils.prepareGatewaClientEntity((Integer)2, (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (Date)activationDate, (boolean)false);
        LanDeviceEntity foundLanDeviceEntity2 = new LanDeviceEntity();
        foundLanDeviceEntity2.setLanDeviceId(Integer.valueOf(2));
        foundLanDeviceEntity2.setName("TC5633-TCSW-0100g");
        foundLanDeviceEntity2.setDescription("Vivotek camea in office");
        foundLanDeviceEntity2.setLocation("Room No. 106");
        foundLanDeviceEntity2.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDeviceEntity2.setMac("00:02:D1:06:CD:81");
        foundLanDeviceEntity2.setIpAddress("192.168.21.139");
        foundLanDeviceEntity2.setPort(Integer.valueOf(80));
        foundLanDeviceEntity2.setUsername("root");
        foundLanDeviceEntity2.setPass("rootPass");
        foundLanDeviceEntity2.setVersion("TC5633-TCSW-0100g");
        foundLanDeviceEntity2.setGatewayClient(gatewayClientEntity2);
        foundLanDeviceEntity2.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        foundLanDeviceEntity2.setUser(null);
        foundLanDeviceEntity2.setDeleted(false);
        foundLanDeviceEntity2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        foundLanDeviceEntity2.setProduct(productEntity);
        foundLanDeviceEntities.add(foundLanDeviceEntity2);
        GenericLanDevice driver2 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundLanDeviceEntity2)).andReturn((Object)driver2);
        EasyMock.expect((Object)driver2.isFirmwareUpToDate(foundLanDeviceEntity2)).andReturn((Object)true);
        EasyMock.expect((Object)driver2.getConnCheckUrl()).andReturn((Object)"/driver2");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(2), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"3");
        ArrayList<LanDevice> expectedDevices = new ArrayList<LanDevice>();
        GatewayClient gatewayClient1 = TestDataUtils.prepareGatewaClient((Integer)1, (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (Date)activationDate, (boolean)false);
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setType(DeviceProduct.DeviceProductType.BASIC);
        deviceProduct.setFeatures(new HashMap());
        LanDevice foundLanDevice1 = new LanDevice();
        foundLanDevice1.setLanDeviceId(Integer.valueOf(1));
        foundLanDevice1.setName("TC5633-TCSW-0100h");
        foundLanDevice1.setDescription("Vivotek camea in office");
        foundLanDevice1.setLocation("Room No. 106");
        foundLanDevice1.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDevice1.setMac("00:02:D1:06:CD:80");
        foundLanDevice1.setIpAddress("192.168.21.138");
        foundLanDevice1.setPort(Integer.valueOf(80));
        foundLanDevice1.setUser("root");
        foundLanDevice1.setPass("rootPass");
        foundLanDevice1.setVersion("TC5633-TCSW-0100h");
        foundLanDevice1.setGatewayClient(gatewayClient1);
        foundLanDevice1.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        foundLanDevice1.setRecording(Boolean.valueOf(false));
        foundLanDevice1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        foundLanDevice1.setDeleted(Boolean.valueOf(false));
        foundLanDevice1.setHasHome(Boolean.valueOf(false));
        foundLanDevice1.setHasPan(Boolean.valueOf(false));
        foundLanDevice1.setHasTilt(Boolean.valueOf(false));
        foundLanDevice1.setHasZoom(Boolean.valueOf(false));
        foundLanDevice1.setHasIllumination(Boolean.valueOf(false));
        foundLanDevice1.setHasMotionDetection(Boolean.valueOf(false));
        foundLanDevice1.setHasLedControl(Boolean.valueOf(false));
        foundLanDevice1.setHasPrivacyButtonControl(Boolean.valueOf(false));
        foundLanDevice1.setHasAudioDetection(Boolean.valueOf(false));
        foundLanDevice1.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        foundLanDevice1.setFirmwareUpToDate(Boolean.valueOf(true));
        foundLanDevice1.setConnCheckUrl("/driver1");
        foundLanDevice1.setLanDeviceParams(new ArrayList());
        foundLanDevice1.setProduct(deviceProduct);
        expectedDevices.add(foundLanDevice1);
        GatewayClient gatewayClient2 = TestDataUtils.prepareGatewaClient((Integer)2, (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (Date)activationDate, (boolean)false);
        LanDevice foundLanDevice2 = new LanDevice();
        foundLanDevice2.setLanDeviceId(Integer.valueOf(2));
        foundLanDevice2.setName("TC5633-TCSW-0100g");
        foundLanDevice2.setDescription("Vivotek camea in office");
        foundLanDevice2.setLocation("Room No. 106");
        foundLanDevice2.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDevice2.setMac("00:02:D1:06:CD:81");
        foundLanDevice2.setIpAddress("192.168.21.139");
        foundLanDevice2.setPort(Integer.valueOf(80));
        foundLanDevice2.setUser("root");
        foundLanDevice2.setPass("rootPass");
        foundLanDevice2.setVersion("TC5633-TCSW-0100g");
        foundLanDevice2.setGatewayClient(gatewayClient2);
        foundLanDevice2.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        foundLanDevice2.setRecording(Boolean.valueOf(false));
        foundLanDevice2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        foundLanDevice2.setDeleted(Boolean.valueOf(false));
        foundLanDevice2.setHasHome(Boolean.valueOf(false));
        foundLanDevice2.setHasPan(Boolean.valueOf(false));
        foundLanDevice2.setHasTilt(Boolean.valueOf(false));
        foundLanDevice2.setHasZoom(Boolean.valueOf(false));
        foundLanDevice2.setHasIllumination(Boolean.valueOf(false));
        foundLanDevice2.setHasMotionDetection(Boolean.valueOf(false));
        foundLanDevice2.setHasLedControl(Boolean.valueOf(false));
        foundLanDevice2.setHasPrivacyButtonControl(Boolean.valueOf(false));
        foundLanDevice2.setHasAudioDetection(Boolean.valueOf(false));
        foundLanDevice2.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        foundLanDevice2.setFirmwareUpToDate(Boolean.valueOf(true));
        foundLanDevice2.setConnCheckUrl("/driver2");
        foundLanDevice2.setLanDeviceParams(new ArrayList());
        foundLanDevice2.setProduct(deviceProduct);
        expectedDevices.add(foundLanDevice2);
        ArrayList<LanDevice> expectedSharedDevices = new ArrayList<LanDevice>();
        GatewayClient sharedGatewayClient = TestDataUtils.prepareGatewaClient((Integer)3, (String)"00:00:00:00:00:00", (String)"00:00:00:00:00:00", (String)"00:00:00:00:00:00", (Date)activationDate, (boolean)false);
        LanDevice sharedLanDevice = new LanDevice();
        sharedLanDevice.setLanDeviceId(Integer.valueOf(3));
        sharedLanDevice.setName("TC5633-TCSW-0100g");
        sharedLanDevice.setDescription("Vivotek camea in office");
        sharedLanDevice.setLocation("Room No. 106");
        sharedLanDevice.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        sharedLanDevice.setMac("00:02:D1:06:CD:81");
        sharedLanDevice.setIpAddress("192.168.21.139");
        sharedLanDevice.setPort(Integer.valueOf(80));
        sharedLanDevice.setUser("root");
        sharedLanDevice.setPass("rootPass");
        sharedLanDevice.setVersion("TC5633-TCSW-0100g");
        sharedLanDevice.setGatewayClient(sharedGatewayClient);
        sharedLanDevice.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        sharedLanDevice.setRecording(Boolean.valueOf(false));
        sharedLanDevice.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        sharedLanDevice.setDeleted(Boolean.valueOf(false));
        sharedLanDevice.setHasHome(Boolean.valueOf(false));
        sharedLanDevice.setHasPan(Boolean.valueOf(false));
        sharedLanDevice.setHasTilt(Boolean.valueOf(false));
        sharedLanDevice.setHasZoom(Boolean.valueOf(false));
        sharedLanDevice.setHasIllumination(Boolean.valueOf(false));
        sharedLanDevice.setHasMotionDetection(Boolean.valueOf(false));
        sharedLanDevice.setHasLedControl(Boolean.valueOf(false));
        sharedLanDevice.setHasPrivacyButtonControl(Boolean.valueOf(false));
        sharedLanDevice.setHasAudioDetection(Boolean.valueOf(false));
        sharedLanDevice.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        sharedLanDevice.setFirmwareUpToDate(Boolean.valueOf(true));
        sharedLanDevice.setConnCheckUrl("/driver2");
        sharedLanDevice.setLanDeviceParams(new ArrayList());
        sharedLanDevice.setProduct(deviceProduct);
        expectedSharedDevices.add(sharedLanDevice);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false, "camera")).andReturn(foundLanDeviceEntities);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null).times(2);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B6")).andReturn(null).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(2))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.videoStreamService.getICEParameters()).andReturn((Object)this.prepareIceParameters());
        PowerMock.replayAll((Object[])new Object[0]);
        GetLanDevicesResponse response = this.lanDeviceService.getLanDevices(null, "camera");
        GetLanDevicesResponse expectedResponse = new GetLanDevicesResponse(GetLanDevicesResponse.GetLanDevicesStatus.SUCCESS, expectedDevices, expectedSharedDevices, Integer.valueOf(3), this.prepareIceParameters());
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    private ICEParameters prepareIceParameters() {
        ICEParams iceParams = new ICEParams();
        iceParams.setStunAddress("192.168.1.1");
        iceParams.setStunPort(9001);
        iceParams.setTurnAddress("192.168.1.2");
        iceParams.setTurnPort(9002);
        ICEParameters iceParameters = new ICEParameters();
        iceParameters.setParams(iceParams);
        HashSet<Integer> gcIds = new HashSet<Integer>();
        gcIds.add(1);
        gcIds.add(3);
        gcIds.add(8);
        gcIds.add(9);
        gcIds.add(10);
        gcIds.add(11);
        gcIds.add(12);
        iceParameters.setGcIds(gcIds);
        LogConfiguration logConf = new LogConfiguration();
        logConf.setConf("test log conf");
        logConf.setUrl("http://192.168.21.105:8080/RESTServer/debuglog");
        iceParameters.setLogConf(logConf);
        return iceParameters;
    }

    @Test
    public void testGetRegistredLanDevicesWithDeviceLimitWithoutVideoRecording() throws Exception {
        ArrayList<LanDeviceEntity> foundLanDeviceEntities = new ArrayList<LanDeviceEntity>();
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        Date activationDate = Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15);
        GatewayClientEntity gatewayClientEntity1 = TestDataUtils.prepareGatewaClientEntity((Integer)1, (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (Date)activationDate, (boolean)false);
        LanDeviceEntity foundLanDeviceEntity1 = new LanDeviceEntity();
        foundLanDeviceEntity1.setLanDeviceId(Integer.valueOf(1));
        foundLanDeviceEntity1.setName("TC5633-TCSW-0100h");
        foundLanDeviceEntity1.setDescription("Vivotek camea in office");
        foundLanDeviceEntity1.setLocation("Room No. 106");
        foundLanDeviceEntity1.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDeviceEntity1.setMac("00:02:D1:06:CD:80");
        foundLanDeviceEntity1.setIpAddress("192.168.21.138");
        foundLanDeviceEntity1.setPort(Integer.valueOf(80));
        foundLanDeviceEntity1.setUsername("root");
        foundLanDeviceEntity1.setPass("rootPass");
        foundLanDeviceEntity1.setVersion("TC5633-TCSW-0100h");
        foundLanDeviceEntity1.setGatewayClient(gatewayClientEntity1);
        foundLanDeviceEntity1.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        foundLanDeviceEntity1.setUser(null);
        foundLanDeviceEntity1.setDeleted(false);
        foundLanDeviceEntity1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        foundLanDeviceEntity1.setProduct(productEntity);
        foundLanDeviceEntities.add(foundLanDeviceEntity1);
        GenericLanDevice driver1 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundLanDeviceEntity1)).andReturn((Object)driver1);
        EasyMock.expect((Object)driver1.isFirmwareUpToDate(foundLanDeviceEntity1)).andReturn((Object)true);
        EasyMock.expect((Object)driver1.getConnCheckUrl()).andReturn((Object)"/device1");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        GatewayClientEntity gatewayClientEntity2 = TestDataUtils.prepareGatewaClientEntity((Integer)2, (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (Date)activationDate, (boolean)false);
        LanDeviceEntity foundLanDeviceEntity2 = new LanDeviceEntity();
        foundLanDeviceEntity2.setLanDeviceId(Integer.valueOf(2));
        foundLanDeviceEntity2.setName("TC5633-TCSW-0100g");
        foundLanDeviceEntity2.setDescription("Vivotek camea in office");
        foundLanDeviceEntity2.setLocation("Room No. 106");
        foundLanDeviceEntity2.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDeviceEntity2.setMac("00:02:D1:06:CD:81");
        foundLanDeviceEntity2.setIpAddress("192.168.21.139");
        foundLanDeviceEntity2.setPort(Integer.valueOf(80));
        foundLanDeviceEntity2.setUsername("root");
        foundLanDeviceEntity2.setPass("rootPass");
        foundLanDeviceEntity2.setVersion("TC5633-TCSW-0100g");
        foundLanDeviceEntity2.setGatewayClient(gatewayClientEntity2);
        foundLanDeviceEntity2.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        foundLanDeviceEntity2.setUser(null);
        foundLanDeviceEntity2.setDeleted(false);
        foundLanDeviceEntity2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        foundLanDeviceEntity2.setProduct(productEntity);
        foundLanDeviceEntities.add(foundLanDeviceEntity2);
        GenericLanDevice driver2 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundLanDeviceEntity2)).andReturn((Object)driver2);
        EasyMock.expect((Object)driver2.isFirmwareUpToDate(foundLanDeviceEntity2)).andReturn((Object)true);
        EasyMock.expect((Object)driver2.getConnCheckUrl()).andReturn((Object)"/device2");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(2), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"3");
        ArrayList<LanDevice> expectedDevices = new ArrayList<LanDevice>();
        GatewayClient gatewayClient1 = TestDataUtils.prepareGatewaClient((Integer)1, (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (Date)activationDate, (boolean)false);
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setType(DeviceProduct.DeviceProductType.BASIC);
        deviceProduct.setFeatures(new HashMap());
        LanDevice foundLanDevice1 = new LanDevice();
        foundLanDevice1.setLanDeviceId(Integer.valueOf(1));
        foundLanDevice1.setName("TC5633-TCSW-0100h");
        foundLanDevice1.setDescription("Vivotek camea in office");
        foundLanDevice1.setLocation("Room No. 106");
        foundLanDevice1.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDevice1.setMac("00:02:D1:06:CD:80");
        foundLanDevice1.setIpAddress("192.168.21.138");
        foundLanDevice1.setPort(Integer.valueOf(80));
        foundLanDevice1.setUser("root");
        foundLanDevice1.setPass("rootPass");
        foundLanDevice1.setVersion("TC5633-TCSW-0100h");
        foundLanDevice1.setGatewayClient(gatewayClient1);
        foundLanDevice1.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        foundLanDevice1.setRecording(Boolean.valueOf(false));
        foundLanDevice1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        foundLanDevice1.setDeleted(Boolean.valueOf(false));
        foundLanDevice1.setHasHome(Boolean.valueOf(false));
        foundLanDevice1.setHasPan(Boolean.valueOf(false));
        foundLanDevice1.setHasTilt(Boolean.valueOf(false));
        foundLanDevice1.setHasZoom(Boolean.valueOf(false));
        foundLanDevice1.setHasIllumination(Boolean.valueOf(false));
        foundLanDevice1.setHasMotionDetection(Boolean.valueOf(false));
        foundLanDevice1.setHasLedControl(Boolean.valueOf(false));
        foundLanDevice1.setHasPrivacyButtonControl(Boolean.valueOf(false));
        foundLanDevice1.setHasAudioDetection(Boolean.valueOf(false));
        foundLanDevice1.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        foundLanDevice1.setFirmwareUpToDate(Boolean.valueOf(true));
        foundLanDevice1.setConnCheckUrl("/device1");
        foundLanDevice1.setLanDeviceParams(new ArrayList());
        foundLanDevice1.setProduct(deviceProduct);
        expectedDevices.add(foundLanDevice1);
        GatewayClient gatewayClient2 = TestDataUtils.prepareGatewaClient((Integer)2, (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (Date)activationDate, (boolean)false);
        LanDevice foundLanDevice2 = new LanDevice();
        foundLanDevice2.setLanDeviceId(Integer.valueOf(2));
        foundLanDevice2.setName("TC5633-TCSW-0100g");
        foundLanDevice2.setDescription("Vivotek camea in office");
        foundLanDevice2.setLocation("Room No. 106");
        foundLanDevice2.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDevice2.setMac("00:02:D1:06:CD:81");
        foundLanDevice2.setIpAddress("192.168.21.139");
        foundLanDevice2.setPort(Integer.valueOf(80));
        foundLanDevice2.setUser("root");
        foundLanDevice2.setPass("rootPass");
        foundLanDevice2.setVersion("TC5633-TCSW-0100g");
        foundLanDevice2.setGatewayClient(gatewayClient2);
        foundLanDevice2.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        foundLanDevice2.setRecording(Boolean.valueOf(false));
        foundLanDevice2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        foundLanDevice2.setDeleted(Boolean.valueOf(false));
        foundLanDevice2.setHasHome(Boolean.valueOf(false));
        foundLanDevice2.setHasPan(Boolean.valueOf(false));
        foundLanDevice2.setHasTilt(Boolean.valueOf(false));
        foundLanDevice2.setHasZoom(Boolean.valueOf(false));
        foundLanDevice2.setHasIllumination(Boolean.valueOf(false));
        foundLanDevice2.setHasMotionDetection(Boolean.valueOf(false));
        foundLanDevice2.setHasLedControl(Boolean.valueOf(false));
        foundLanDevice2.setHasPrivacyButtonControl(Boolean.valueOf(false));
        foundLanDevice2.setHasAudioDetection(Boolean.valueOf(false));
        foundLanDevice2.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        foundLanDevice2.setFirmwareUpToDate(Boolean.valueOf(true));
        foundLanDevice2.setConnCheckUrl("/device2");
        foundLanDevice2.setLanDeviceParams(new ArrayList());
        foundLanDevice2.setProduct(deviceProduct);
        expectedDevices.add(foundLanDevice2);
        ArrayList<LanDevice> expectedSharedDevices = new ArrayList<LanDevice>();
        GatewayClient sharedGatewayClient = TestDataUtils.prepareGatewaClient((Integer)3, (String)"00:00:00:00:00:00", (String)"00:00:00:00:00:00", (String)"00:00:00:00:00:00", (Date)activationDate, (boolean)false);
        LanDevice sharedLanDevice = new LanDevice();
        sharedLanDevice.setLanDeviceId(Integer.valueOf(3));
        sharedLanDevice.setName("TC5633-TCSW-0100g");
        sharedLanDevice.setDescription("Vivotek camea in office");
        sharedLanDevice.setLocation("Room No. 106");
        sharedLanDevice.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        sharedLanDevice.setMac("00:02:D1:06:CD:81");
        sharedLanDevice.setIpAddress("192.168.21.139");
        sharedLanDevice.setPort(Integer.valueOf(80));
        sharedLanDevice.setUser("root");
        sharedLanDevice.setPass("rootPass");
        sharedLanDevice.setVersion("TC5633-TCSW-0100g");
        sharedLanDevice.setGatewayClient(sharedGatewayClient);
        sharedLanDevice.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        sharedLanDevice.setRecording(Boolean.valueOf(false));
        sharedLanDevice.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        sharedLanDevice.setDeleted(Boolean.valueOf(false));
        sharedLanDevice.setHasHome(Boolean.valueOf(false));
        sharedLanDevice.setHasPan(Boolean.valueOf(false));
        sharedLanDevice.setHasTilt(Boolean.valueOf(false));
        sharedLanDevice.setHasZoom(Boolean.valueOf(false));
        sharedLanDevice.setHasIllumination(Boolean.valueOf(false));
        sharedLanDevice.setHasMotionDetection(Boolean.valueOf(false));
        sharedLanDevice.setHasLedControl(Boolean.valueOf(false));
        sharedLanDevice.setHasPrivacyButtonControl(Boolean.valueOf(false));
        sharedLanDevice.setHasAudioDetection(Boolean.valueOf(false));
        sharedLanDevice.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        sharedLanDevice.setFirmwareUpToDate(Boolean.valueOf(true));
        sharedLanDevice.setConnCheckUrl("/driver2");
        sharedLanDevice.setLanDeviceParams(new ArrayList());
        sharedLanDevice.setProduct(deviceProduct);
        expectedSharedDevices.add(sharedLanDevice);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false, "camera")).andReturn(foundLanDeviceEntities);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null).times(2);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B6")).andReturn(null).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(2))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.videoStreamService.getICEParameters()).andReturn((Object)this.prepareIceParameters());
        PowerMock.replayAll((Object[])new Object[0]);
        GetLanDevicesResponse response = this.lanDeviceService.getLanDevices(null, "camera");
        GetLanDevicesResponse expectedResponse = new GetLanDevicesResponse(GetLanDevicesResponse.GetLanDevicesStatus.SUCCESS, expectedDevices, expectedSharedDevices, Integer.valueOf(3), this.prepareIceParameters());
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetRegistredLanDevicesWithoutDeviceLimit() throws Exception {
        ArrayList<LanDeviceEntity> foundLanDeviceEntities = new ArrayList<LanDeviceEntity>();
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        Date activationDate = Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15);
        GatewayClientEntity gatewayClientEntity1 = TestDataUtils.prepareGatewaClientEntity((Integer)1, (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (Date)activationDate, (boolean)false);
        LanDeviceEntity foundLanDeviceEntity1 = new LanDeviceEntity();
        foundLanDeviceEntity1.setLanDeviceId(Integer.valueOf(1));
        foundLanDeviceEntity1.setName("TC5633-TCSW-0100h");
        foundLanDeviceEntity1.setDescription("Vivotek camea in office");
        foundLanDeviceEntity1.setLocation("Room No. 106");
        foundLanDeviceEntity1.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDeviceEntity1.setMac("00:02:D1:06:CD:80");
        foundLanDeviceEntity1.setIpAddress("192.168.21.138");
        foundLanDeviceEntity1.setPort(Integer.valueOf(80));
        foundLanDeviceEntity1.setUsername("root");
        foundLanDeviceEntity1.setPass("rootPass");
        foundLanDeviceEntity1.setVersion("TC5633-TCSW-0100h");
        foundLanDeviceEntity1.setGatewayClient(gatewayClientEntity1);
        foundLanDeviceEntity1.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        foundLanDeviceEntity1.setUser(null);
        foundLanDeviceEntity1.setDeleted(false);
        foundLanDeviceEntity1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        foundLanDeviceEntity1.setProduct(productEntity);
        foundLanDeviceEntities.add(foundLanDeviceEntity1);
        GenericLanDevice driver1 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundLanDeviceEntity1)).andReturn((Object)driver1);
        EasyMock.expect((Object)driver1.isFirmwareUpToDate(foundLanDeviceEntity1)).andReturn((Object)true);
        EasyMock.expect((Object)driver1.getConnCheckUrl()).andReturn((Object)"/device1");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        GatewayClientEntity gatewayClientEntity2 = TestDataUtils.prepareGatewaClientEntity((Integer)2, (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (Date)activationDate, (boolean)false);
        LanDeviceEntity foundLanDeviceEntity2 = new LanDeviceEntity();
        foundLanDeviceEntity2.setLanDeviceId(Integer.valueOf(2));
        foundLanDeviceEntity2.setName("TC5633-TCSW-0100g");
        foundLanDeviceEntity2.setDescription("Vivotek camea in office");
        foundLanDeviceEntity2.setLocation("Room No. 106");
        foundLanDeviceEntity2.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDeviceEntity2.setMac("00:02:D1:06:CD:81");
        foundLanDeviceEntity2.setIpAddress("192.168.21.139");
        foundLanDeviceEntity2.setPort(Integer.valueOf(80));
        foundLanDeviceEntity2.setUsername("root");
        foundLanDeviceEntity2.setPass("rootPass");
        foundLanDeviceEntity2.setVersion("TC5633-TCSW-0100g");
        foundLanDeviceEntity2.setGatewayClient(gatewayClientEntity2);
        foundLanDeviceEntity2.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        foundLanDeviceEntity2.setUser(null);
        foundLanDeviceEntity2.setDeleted(false);
        foundLanDeviceEntity2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        foundLanDeviceEntity2.setLanDeviceParams(new ArrayList());
        foundLanDeviceEntity2.setProduct(productEntity);
        foundLanDeviceEntities.add(foundLanDeviceEntity2);
        GenericLanDevice driver2 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundLanDeviceEntity2)).andReturn((Object)driver2);
        EasyMock.expect((Object)driver2.isFirmwareUpToDate(foundLanDeviceEntity2)).andReturn((Object)true);
        EasyMock.expect((Object)driver2.getConnCheckUrl()).andReturn((Object)"/device2");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(2), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList<LanDevice> expectedDevices = new ArrayList<LanDevice>();
        GatewayClient gatewayClient1 = TestDataUtils.prepareGatewaClient((Integer)1, (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (String)"00:1A:B6:00:0B:B5", (Date)activationDate, (boolean)false);
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setType(DeviceProduct.DeviceProductType.BASIC);
        deviceProduct.setFeatures(new HashMap());
        LanDevice foundLanDevice1 = new LanDevice();
        foundLanDevice1.setLanDeviceId(Integer.valueOf(1));
        foundLanDevice1.setName("TC5633-TCSW-0100h");
        foundLanDevice1.setDescription("Vivotek camea in office");
        foundLanDevice1.setLocation("Room No. 106");
        foundLanDevice1.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDevice1.setMac("00:02:D1:06:CD:80");
        foundLanDevice1.setIpAddress("192.168.21.138");
        foundLanDevice1.setPort(Integer.valueOf(80));
        foundLanDevice1.setUser("root");
        foundLanDevice1.setPass("rootPass");
        foundLanDevice1.setVersion("TC5633-TCSW-0100h");
        foundLanDevice1.setGatewayClient(gatewayClient1);
        foundLanDevice1.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        foundLanDevice1.setRecording(Boolean.valueOf(false));
        foundLanDevice1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        foundLanDevice1.setDeleted(Boolean.valueOf(false));
        foundLanDevice1.setHasHome(Boolean.valueOf(false));
        foundLanDevice1.setHasPan(Boolean.valueOf(false));
        foundLanDevice1.setHasTilt(Boolean.valueOf(false));
        foundLanDevice1.setHasZoom(Boolean.valueOf(false));
        foundLanDevice1.setHasIllumination(Boolean.valueOf(false));
        foundLanDevice1.setHasMotionDetection(Boolean.valueOf(false));
        foundLanDevice1.setHasLedControl(Boolean.valueOf(false));
        foundLanDevice1.setHasPrivacyButtonControl(Boolean.valueOf(false));
        foundLanDevice1.setHasAudioDetection(Boolean.valueOf(false));
        foundLanDevice1.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        foundLanDevice1.setFirmwareUpToDate(Boolean.valueOf(true));
        foundLanDevice1.setConnCheckUrl("/device1");
        foundLanDevice1.setLanDeviceParams(new ArrayList());
        foundLanDevice1.setProduct(deviceProduct);
        expectedDevices.add(foundLanDevice1);
        GatewayClient gatewayClient2 = TestDataUtils.prepareGatewaClient((Integer)2, (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (String)"00:1A:B6:00:0B:B6", (Date)activationDate, (boolean)false);
        LanDevice foundLanDevice2 = new LanDevice();
        foundLanDevice2.setLanDeviceId(Integer.valueOf(2));
        foundLanDevice2.setName("TC5633-TCSW-0100g");
        foundLanDevice2.setDescription("Vivotek camea in office");
        foundLanDevice2.setLocation("Room No. 106");
        foundLanDevice2.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        foundLanDevice2.setMac("00:02:D1:06:CD:81");
        foundLanDevice2.setIpAddress("192.168.21.139");
        foundLanDevice2.setPort(Integer.valueOf(80));
        foundLanDevice2.setUser("root");
        foundLanDevice2.setPass("rootPass");
        foundLanDevice2.setVersion("TC5633-TCSW-0100g");
        foundLanDevice2.setGatewayClient(gatewayClient2);
        foundLanDevice2.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        foundLanDevice2.setRecording(Boolean.valueOf(false));
        foundLanDevice2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        foundLanDevice2.setDeleted(Boolean.valueOf(false));
        foundLanDevice2.setHasHome(Boolean.valueOf(false));
        foundLanDevice2.setHasPan(Boolean.valueOf(false));
        foundLanDevice2.setHasTilt(Boolean.valueOf(false));
        foundLanDevice2.setHasZoom(Boolean.valueOf(false));
        foundLanDevice2.setHasIllumination(Boolean.valueOf(false));
        foundLanDevice2.setHasMotionDetection(Boolean.valueOf(false));
        foundLanDevice2.setHasLedControl(Boolean.valueOf(false));
        foundLanDevice2.setHasPrivacyButtonControl(Boolean.valueOf(false));
        foundLanDevice2.setHasAudioDetection(Boolean.valueOf(false));
        foundLanDevice2.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        foundLanDevice2.setLanDeviceParams(new ArrayList());
        foundLanDevice2.setFirmwareUpToDate(Boolean.valueOf(true));
        foundLanDevice2.setConnCheckUrl("/device2");
        foundLanDevice2.setLanDeviceParams(new ArrayList());
        foundLanDevice2.setProduct(deviceProduct);
        expectedDevices.add(foundLanDevice2);
        ArrayList<LanDevice> expectedSharedDevices = new ArrayList<LanDevice>();
        GatewayClient sharedGatewayClient = TestDataUtils.prepareGatewaClient((Integer)3, (String)"00:00:00:00:00:00", (String)"00:00:00:00:00:00", (String)"00:00:00:00:00:00", (Date)activationDate, (boolean)false);
        LanDevice sharedLanDevice = new LanDevice();
        sharedLanDevice.setLanDeviceId(Integer.valueOf(3));
        sharedLanDevice.setName("TC5633-TCSW-0100g");
        sharedLanDevice.setDescription("Vivotek camea in office");
        sharedLanDevice.setLocation("Room No. 106");
        sharedLanDevice.setAddedDate(Utils.constructDate((int)2011, (int)3, (int)24, (int)8, (int)12, (int)15));
        sharedLanDevice.setMac("00:02:D1:06:CD:81");
        sharedLanDevice.setIpAddress("192.168.21.139");
        sharedLanDevice.setPort(Integer.valueOf(80));
        sharedLanDevice.setUser("root");
        sharedLanDevice.setPass("rootPass");
        sharedLanDevice.setVersion("TC5633-TCSW-0100g");
        sharedLanDevice.setGatewayClient(sharedGatewayClient);
        sharedLanDevice.setDeviceDesc(TestDataUtils.prepareDeviceDesc());
        sharedLanDevice.setRecording(Boolean.valueOf(false));
        sharedLanDevice.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        sharedLanDevice.setDeleted(Boolean.valueOf(false));
        sharedLanDevice.setHasHome(Boolean.valueOf(false));
        sharedLanDevice.setHasPan(Boolean.valueOf(false));
        sharedLanDevice.setHasTilt(Boolean.valueOf(false));
        sharedLanDevice.setHasZoom(Boolean.valueOf(false));
        sharedLanDevice.setHasIllumination(Boolean.valueOf(false));
        sharedLanDevice.setHasMotionDetection(Boolean.valueOf(false));
        sharedLanDevice.setHasLedControl(Boolean.valueOf(false));
        sharedLanDevice.setHasPrivacyButtonControl(Boolean.valueOf(false));
        sharedLanDevice.setHasAudioDetection(Boolean.valueOf(false));
        sharedLanDevice.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        sharedLanDevice.setFirmwareUpToDate(Boolean.valueOf(true));
        sharedLanDevice.setConnCheckUrl("/driver2");
        sharedLanDevice.setLanDeviceParams(new ArrayList());
        sharedLanDevice.setProduct(deviceProduct);
        expectedSharedDevices.add(sharedLanDevice);
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false, "camera")).andReturn(foundLanDeviceEntities);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null).times(2);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B6")).andReturn(null).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(2))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.videoStreamService.getICEParameters()).andReturn((Object)this.prepareIceParameters());
        PowerMock.replayAll((Object[])new Object[0]);
        GetLanDevicesResponse response = this.lanDeviceService.getLanDevices(null, "camera");
        GetLanDevicesResponse expectedResponse = new GetLanDevicesResponse(GetLanDevicesResponse.GetLanDevicesStatus.SUCCESS, expectedDevices, expectedSharedDevices, null, this.prepareIceParameters());
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testFinalizeConfiguration() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity correctDevice1 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        correctDevice1.setLanDeviceId(Integer.valueOf(1));
        correctDevice1.setName("Camera #1");
        correctDevice1.setMac("AA:AA:AA:AA:AA:AA");
        correctDevice1.setProduct(productEntity);
        correctDevices.add(correctDevice1);
        LanDeviceEntity correctDevice2 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        correctDevice2.setLanDeviceId(Integer.valueOf(2));
        correctDevice2.setName("Camera #2");
        correctDevice2.setMac("BB:BB:BB:BB:BB:BB");
        correctDevice2.setProduct(productEntity);
        correctDevices.add(correctDevice2);
        EasyMock.expect((Object)this.authUtils.getStoredData("correct_devices")).andReturn(correctDevices);
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(2), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(2))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        this.expectCheckDeviceParameters(correctDevice1);
        this.expectCheckDeviceParameters(correctDevice2);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(3);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)3L);
        ArrayList<LanDeviceEntity> manualDevices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity manualDevice1 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        manualDevice1.setLanDeviceId(null);
        manualDevice1.setName("Camera #4");
        manualDevice1.setMac("CC:CC:CC:CC:CC:CC");
        manualDevice1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        manualDevice1.setProduct(productEntity);
        manualDevices.add(manualDevice1);
        LanDeviceEntity manualDevice1Saved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        manualDevice1Saved.setLanDeviceId(Integer.valueOf(4));
        manualDevice1Saved.setName("Camera #4");
        manualDevice1Saved.setMac("CC:CC:CC:CC:CC:CC");
        manualDevice1Saved.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        manualDevice1Saved.setProduct(productEntity);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)4.0);
        LanDeviceEntity manualDevice2 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        manualDevice2.setLanDeviceId(null);
        manualDevice2.setName("Camera #5");
        manualDevice2.setMac("DD:DD:DD:DD:DD:DD");
        manualDevice2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        manualDevice2.setProduct(productEntity);
        LanDeviceEntity manualDevice2Saved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        manualDevice2Saved.setLanDeviceId(Integer.valueOf(5));
        manualDevice2Saved.setName("Camera #5");
        manualDevice2Saved.setMac("DD:DD:DD:DD:DD:DD");
        manualDevice2Saved.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        manualDevice2Saved.setProduct(productEntity);
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(4), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(4))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(5), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(5))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        manualDevices.add(manualDevice2);
        EasyMock.expect((Object)this.authUtils.getStoredData("manual_devices")).andReturn(manualDevices);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        EasyMock.expectLastCall().times(2);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(manualDevice1.getGatewayClient())).andReturn((Object)manualDevice1.getGatewayClient());
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDevice(manualDevice1)).andReturn((Object)manualDevice1Saved);
        this.expectCheckDeviceParameters(manualDevice1Saved);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClient(manualDevice2.getGatewayClient())).andReturn((Object)manualDevice1.getGatewayClient());
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDevice(manualDevice2)).andReturn((Object)manualDevice2Saved);
        this.expectCheckDeviceParameters(manualDevice2Saved);
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null).times(4);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setType(DeviceProduct.DeviceProductType.BASIC);
        deviceProduct.setFeatures(new HashMap());
        ArrayList<LanDevice> expectedResponse = new ArrayList<LanDevice>();
        LanDevice expectedCorrectDevice1 = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedCorrectDevice1.setLanDeviceId(Integer.valueOf(1));
        expectedCorrectDevice1.setName("Camera #1");
        expectedCorrectDevice1.setMac("AA:AA:AA:AA:AA:AA");
        expectedCorrectDevice1.setHasHome(Boolean.valueOf(false));
        expectedCorrectDevice1.setHasPan(Boolean.valueOf(false));
        expectedCorrectDevice1.setHasTilt(Boolean.valueOf(false));
        expectedCorrectDevice1.setHasZoom(Boolean.valueOf(false));
        expectedCorrectDevice1.setHasIllumination(Boolean.valueOf(false));
        expectedCorrectDevice1.setHasMotionDetection(Boolean.valueOf(true));
        expectedCorrectDevice1.setHasLedControl(Boolean.valueOf(true));
        expectedCorrectDevice1.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedCorrectDevice1.setHasAudioDetection(Boolean.valueOf(false));
        expectedCorrectDevice1.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedCorrectDevice1.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedCorrectDevice1.setConnCheckUrl("/connCheck");
        expectedCorrectDevice1.setProduct(deviceProduct);
        expectedResponse.add(expectedCorrectDevice1);
        LanDevice expectedCorrectDevice2 = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedCorrectDevice2.setLanDeviceId(Integer.valueOf(2));
        expectedCorrectDevice2.setName("Camera #2");
        expectedCorrectDevice2.setMac("BB:BB:BB:BB:BB:BB");
        expectedCorrectDevice2.setHasHome(Boolean.valueOf(false));
        expectedCorrectDevice2.setHasPan(Boolean.valueOf(false));
        expectedCorrectDevice2.setHasTilt(Boolean.valueOf(false));
        expectedCorrectDevice2.setHasZoom(Boolean.valueOf(false));
        expectedCorrectDevice2.setHasIllumination(Boolean.valueOf(false));
        expectedCorrectDevice2.setHasMotionDetection(Boolean.valueOf(true));
        expectedCorrectDevice2.setHasLedControl(Boolean.valueOf(true));
        expectedCorrectDevice2.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedCorrectDevice2.setHasAudioDetection(Boolean.valueOf(false));
        expectedCorrectDevice2.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedCorrectDevice2.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedCorrectDevice2.setConnCheckUrl("/connCheck");
        expectedCorrectDevice2.setProduct(deviceProduct);
        expectedResponse.add(expectedCorrectDevice2);
        LanDevice expectedManualDevice1 = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedManualDevice1.setLanDeviceId(Integer.valueOf(4));
        expectedManualDevice1.setName("Camera #4");
        expectedManualDevice1.setMac("CC:CC:CC:CC:CC:CC");
        expectedManualDevice1.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        expectedManualDevice1.setHasHome(Boolean.valueOf(false));
        expectedManualDevice1.setHasPan(Boolean.valueOf(false));
        expectedManualDevice1.setHasTilt(Boolean.valueOf(false));
        expectedManualDevice1.setHasZoom(Boolean.valueOf(false));
        expectedManualDevice1.setHasIllumination(Boolean.valueOf(false));
        expectedManualDevice1.setHasMotionDetection(Boolean.valueOf(true));
        expectedManualDevice1.setHasLedControl(Boolean.valueOf(true));
        expectedManualDevice1.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedManualDevice1.setHasAudioDetection(Boolean.valueOf(false));
        expectedManualDevice1.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedManualDevice1.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedManualDevice1.setConnCheckUrl("/connCheck");
        expectedManualDevice1.setProduct(deviceProduct);
        expectedResponse.add(expectedManualDevice1);
        LanDevice expectedManualDevice2 = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        expectedManualDevice2.setLanDeviceId(Integer.valueOf(5));
        expectedManualDevice2.setName("Camera #5");
        expectedManualDevice2.setMac("DD:DD:DD:DD:DD:DD");
        expectedManualDevice2.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
        expectedManualDevice2.setHasHome(Boolean.valueOf(false));
        expectedManualDevice2.setHasPan(Boolean.valueOf(false));
        expectedManualDevice2.setHasTilt(Boolean.valueOf(false));
        expectedManualDevice2.setHasZoom(Boolean.valueOf(false));
        expectedManualDevice2.setHasIllumination(Boolean.valueOf(false));
        expectedManualDevice2.setHasMotionDetection(Boolean.valueOf(true));
        expectedManualDevice2.setHasLedControl(Boolean.valueOf(true));
        expectedManualDevice2.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedManualDevice2.setHasAudioDetection(Boolean.valueOf(false));
        expectedManualDevice2.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedManualDevice2.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedManualDevice2.setConnCheckUrl("/connCheck");
        expectedManualDevice2.setProduct(deviceProduct);
        expectedResponse.add(expectedManualDevice2);
        List response = this.lanDeviceService.finalizeConfiguration(true);
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @After
    public void tearDown() {
        PowerMock.resetAll((Object[])new Object[0]);
    }

    private void expectCheckDeviceParameters(LanDeviceEntity device) {
        GenericLanDevice deviceDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)deviceDriver);
        EasyMock.expect((Object)deviceDriver.isFirmwareUpToDate(device)).andReturn((Object)true);
        EasyMock.expect((Object)deviceDriver.getConnCheckUrl()).andReturn((Object)"/connCheck");
    }

    private LanDeviceEntity createLanDevice(Integer id, String mac, String ip, String lastCheckDate, boolean attachDepends) {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(id);
        device.setMac(mac);
        device.setIpAddress(ip);
        device.setPort(Integer.valueOf(80));
        device.setUsername("root");
        device.setPass("rootPass");
        device.setLanDeviceParams(new ArrayList());
        LanDeviceParamEntity param = new LanDeviceParamEntity();
        param.setName("dateLastCheckAddress");
        param.setValue(lastCheckDate);
        param.setRemoteValue(lastCheckDate);
        device.getLanDeviceParams().add(param);
        if (attachDepends) {
            device.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
            device.setGatewayClient(TestDataUtils.prepareGatewaClientEntity());
        }
        return device;
    }

    @Test
    public void testUpdateIpAddresses() throws Exception {
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_VERIFY_IP_ADDRESS_CYCLIC_PERIOD)).andReturn((Object)"3d").times(6);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(this.createLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:01", "192.168.21.101", "2011-05-27 10:00:00", true));
        devices.add(this.createLanDevice(Integer.valueOf(2), "00:02:D1:06:CD:02", "192.168.21.102", "2011-05-27 10:00:00", true));
        devices.add(this.createLanDevice(Integer.valueOf(3), "00:02:D1:06:CD:03", "192.168.21.103", "2011-05-27 10:00:00", true));
        devices.add(this.createLanDevice(Integer.valueOf(4), "00:02:D1:06:CD:04", "192.168.21.104", "2011-05-27 14:01:00", true));
        LanDeviceEntity integratedCamera1 = this.createLanDevice(Integer.valueOf(5), "00:02:D1:06:CD:05", "127.0.0.1", "2011-05-27 10:00:00", true);
        integratedCamera1.getGatewayClient().setDeviceType(Integer.valueOf(16));
        devices.add(integratedCamera1);
        LanDeviceEntity integratedCamera2 = this.createLanDevice(Integer.valueOf(6), "00:02:D1:06:CD:06", "127.0.0.1", "2011-05-27 10:00:00", true);
        devices.add(integratedCamera2);
        LanDeviceEntity integratedCamera3 = this.createLanDevice(Integer.valueOf(7), "00:02:D1:06:CD:07", "127.0.0.2", "2011-05-27 10:00:00", true);
        integratedCamera3.getGatewayClient().setDeviceType(Integer.valueOf(16));
        devices.add(integratedCamera3);
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevices(Integer.valueOf(0), Integer.valueOf(100))).andReturn(devices);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)30, (int)14, (int)0, (int)0);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)currentDate);
        EasyMock.expectLastCall().times(11);
        LanDeviceEntity dev1 = this.createLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:01", "192.168.21.101", "2011-05-27 10:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1), true, true)).andReturn((Object)dev1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev1)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev1)).andReturn((Object)"00:02:D1:06:CD:01");
        LanDeviceEntity dev1Save = this.createLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:01", "192.168.21.101", "2011-05-30 14:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev1Save)).andReturn((Object)dev1Save);
        LanDeviceEntity dev2 = this.createLanDevice(Integer.valueOf(2), "00:02:D1:06:CD:02", "192.168.21.102", "2011-05-27 10:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(2), true, true)).andReturn((Object)dev2);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev2)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev2)).andReturn((Object)"00:02:D1:06:CD:03");
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)this.ipAddressDiscoveryService);
        EasyMock.expect((Object)this.ipAddressDiscoveryService.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:02")).andReturn((Object)"192.168.21.199");
        LanDeviceEntity dev2Save = this.createLanDevice(Integer.valueOf(2), "00:02:D1:06:CD:02", "192.168.21.199", "2011-05-30 14:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev2Save)).andReturn((Object)dev2Save);
        this.eventlogService.registerEventlog(LDEventType.LANIPCHANGE, "00:02:D1:06:CD:02", "192.168.21.199", "OK", null);
        LanDeviceEntity dev3 = this.createLanDevice(Integer.valueOf(3), "00:02:D1:06:CD:03", "192.168.21.103", "2011-05-27 10:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(3), true, true)).andReturn((Object)dev3);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev3)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev3)).andReturn(null);
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)this.ipAddressDiscoveryService);
        EasyMock.expect((Object)this.ipAddressDiscoveryService.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:03")).andReturn((Object)"192.168.21.191");
        LanDeviceEntity dev3Save = this.createLanDevice(Integer.valueOf(3), "00:02:D1:06:CD:03", "192.168.21.191", "2011-05-30 14:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev3Save)).andReturn((Object)dev3Save);
        this.eventlogService.registerEventlog(LDEventType.LANIPCHANGE, "00:02:D1:06:CD:03", "192.168.21.191", "OK", null);
        LanDeviceEntity dev6 = this.createLanDevice(Integer.valueOf(6), "00:02:D1:06:CD:06", "127.0.0.1", "2011-05-27 10:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(6), true, true)).andReturn((Object)dev6);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev6)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev6)).andReturn((Object)"00:02:D1:06:CD:06");
        LanDeviceEntity dev6Save = this.createLanDevice(Integer.valueOf(6), "00:02:D1:06:CD:06", "127.0.0.1", "2011-05-30 14:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev6Save)).andReturn((Object)dev6Save);
        LanDeviceEntity dev7 = this.createLanDevice(Integer.valueOf(7), "00:02:D1:06:CD:07", "127.0.0.2", "2011-05-27 10:00:00", true);
        dev7.getGatewayClient().setDeviceType(Integer.valueOf(16));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(7), true, true)).andReturn((Object)dev7);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev7)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev7)).andReturn((Object)"00:02:D1:06:CD:07");
        LanDeviceEntity dev7Save = this.createLanDevice(Integer.valueOf(7), "00:02:D1:06:CD:07", "127.0.0.2", "2011-05-30 14:00:00", true);
        dev7Save.getGatewayClient().setDeviceType(Integer.valueOf(16));
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev7Save)).andReturn((Object)dev7Save);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateIpAddresses();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateIpAddressesForUnregisteredGc() {
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateIpAddresses("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateIpAddressForIntegratedCamera() {
        GatewayClientEntity gatewayClient = TestDataUtils.prepareGatewaClientEntity();
        gatewayClient.setDeviceType(Integer.valueOf(16));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(gatewayClient);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity camera = this.createLanDevice(Integer.valueOf(5), "00:02:D1:06:CD:05", "127.0.0.1", "2011-05-27 10:00:00", true);
        camera.getGatewayClient().setDeviceType(Integer.valueOf(16));
        devices.add(camera);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewayClientId(Integer.valueOf(1))).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateIpAddresses("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateIpAddressesForGcWithNullDevices() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewayClientId(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateIpAddresses("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateIpAddressesForGcWithoutDevices() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList devices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewayClientId(Integer.valueOf(1))).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateIpAddresses("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateIpAddressesForGc() throws Exception {
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_VERIFY_IP_ADDRESS_WHEN_GC_CONNECTED_PERIOD)).andReturn((Object)"4h").times(4);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(this.createLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:01", "192.168.21.101", "2011-05-30 09:00:00", false));
        devices.add(this.createLanDevice(Integer.valueOf(2), "00:02:D1:06:CD:02", "192.168.21.102", "2011-05-30 09:00:00", false));
        devices.add(this.createLanDevice(Integer.valueOf(3), "00:02:D1:06:CD:03", "192.168.21.103", "2011-05-30 09:00:00", false));
        devices.add(this.createLanDevice(Integer.valueOf(4), "00:02:D1:06:CD:04", "192.168.21.104", "2011-05-30 11:01:00", false));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewayClientId(Integer.valueOf(1))).andReturn(devices);
        Date currentDate = Utils.constructDate((int)2011, (int)5, (int)30, (int)14, (int)0, (int)0);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)currentDate);
        EasyMock.expectLastCall().times(7);
        LanDeviceEntity dev1 = this.createLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:01", "192.168.21.101", "2011-05-30 09:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1), true, true)).andReturn((Object)dev1);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev1)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev1)).andReturn((Object)"00:02:D1:06:CD:01");
        LanDeviceEntity dev1Save = this.createLanDevice(Integer.valueOf(1), "00:02:D1:06:CD:01", "192.168.21.101", "2011-05-30 14:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev1Save)).andReturn((Object)dev1Save);
        LanDeviceEntity dev2 = this.createLanDevice(Integer.valueOf(2), "00:02:D1:06:CD:02", "192.168.21.102", "2011-05-30 09:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(2), true, true)).andReturn((Object)dev2);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev2)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev2)).andReturn((Object)"00:02:D1:06:CD:03");
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)this.ipAddressDiscoveryService);
        EasyMock.expect((Object)this.ipAddressDiscoveryService.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:02")).andReturn((Object)"192.168.21.199");
        LanDeviceEntity dev2Save = this.createLanDevice(Integer.valueOf(2), "00:02:D1:06:CD:02", "192.168.21.199", "2011-05-30 14:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev2Save)).andReturn((Object)dev2Save);
        this.eventlogService.registerEventlog(LDEventType.LANIPCHANGE, "00:02:D1:06:CD:02", "192.168.21.199", "OK", null);
        LanDeviceEntity dev3 = this.createLanDevice(Integer.valueOf(3), "00:02:D1:06:CD:03", "192.168.21.103", "2011-05-30 09:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(3), true, true)).andReturn((Object)dev3);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(dev3)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.getMacAddress(dev3)).andReturn(null);
        EasyMock.expect((Object)this.containerserverServiceFactory.getVivotekCameraIpAddressDiscoveryService()).andReturn((Object)this.ipAddressDiscoveryService);
        EasyMock.expect((Object)this.ipAddressDiscoveryService.getCameraIpAddress("00:1A:B6:00:0B:B5", "00:02:D1:06:CD:03")).andReturn((Object)"192.168.21.191");
        LanDeviceEntity dev3Save = this.createLanDevice(Integer.valueOf(3), "00:02:D1:06:CD:03", "192.168.21.191", "2011-05-30 14:00:00", true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(dev3Save)).andReturn((Object)dev3Save);
        this.eventlogService.registerEventlog(LDEventType.LANIPCHANGE, "00:02:D1:06:CD:03", "192.168.21.191", "OK", null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateIpAddresses("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraGCVerificationCodeIncorrect() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.FAILED_CODEINCORRECT, "", ""));
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, "FAILED_CODEINCORRECT", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_CODEINCORRECT);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraGCVerificationNotConnected() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED, "", ""));
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, "FAILED_NOTCONNECTED", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_NOTCONNECTED);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraGCVerificationNotConnectedTryInstall() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED_TRYINSTALL, "", ""));
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, "FAILED_NOTCONNECTED_TRYINSTALL", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_NOTCONNECTED);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraDriverNotFound() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "FAILED", "Not found driver.");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraVerificationError() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraNoAccess() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.NOACCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.NOACCESS);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraNoAnswer() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.NOANSWER);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.NOANSWER);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraNotSupported() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.NOT_SUPPORTED);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.NOTSUPPORTED);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraInitError() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validToDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validToDate);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        1 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validToDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "viewerPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.ERROR);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "ERROR", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraInitFailed() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        2 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.FAILED);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "FAILED", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateManualCamera() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        3 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.MANUAL);
        ArrayList<LanDeviceEntity> manualDevices = new ArrayList<LanDeviceEntity>();
        manualDevices.add(deviceEntity);
        this.authUtils.storeData("manual_devices", manualDevices);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "MANUAL", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.MANUAL);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraNotSaved() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        4 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "ERROR", "Lan device has not been stored in database.");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraSuccessfulWithoutDeviceLimit() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        5 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithMacBasedActivationFeatureSuccessful() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "89.186.27.139", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn((Object)"ON");
        EasyMock.expect((Object)this.authUtils.getClientIpAddress()).andReturn((Object)"89.186.27.139");
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        6 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithMacBasedActivationFeatureFailure() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "89.186.27.139", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn((Object)"ON");
        EasyMock.expect((Object)this.authUtils.getClientIpAddress()).andReturn((Object)"89.186.27.140");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_ACTIVATIONOUTSIDEDEVICELOCALNETWORK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraSuccessfulWithDeviceLimit() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"5");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)4L);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        7 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraDeviceLimitReached() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"5");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_REACHEDMAXDEVICECOUNT);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraDeviceLimitExceed() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"5");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)6L);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_REACHEDMAXDEVICECOUNT);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraPrevoiuslyDeleted() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setGatewayClientId(null);
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setUser(TestDataUtils.prepareUserEntity());
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        8 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expectLastCall().times(3);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setLanDeviceId(null);
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"NgbE78eBUB");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setLanDeviceId(null);
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraAsignedToAnotherAccount() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        LanDeviceEntity anotherAccountCamera = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        anotherAccountCamera.setUser(new UserEntity(Integer.valueOf(2)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)anotherAccountCamera);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", null, ActivateCameraResponse.CameraActivationStatus.FAILED_ANOTHERACCOUNTASSIGNED.name(), null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_ANOTHERACCOUNTASSIGNED);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraAlreadyRegistredToCurrentUserDriverNotFound() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        GatewayClientEntity thisAccountGC = new GatewayClientEntity();
        thisAccountGC.setUser(new UserEntity(Integer.valueOf(1)));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(thisAccountGC);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:06:CD:80")).andReturn(clients);
        LanDeviceEntity thisAccountCamera = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        thisAccountCamera.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)thisAccountCamera);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "192.168.21.138", "FAILED", "Not found driver.");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        GenericLanDevice driverForDto = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(thisAccountCamera)).andReturn((Object)driverForDto);
        EasyMock.expect((Object)driverForDto.isFirmwareUpToDate(thisAccountCamera)).andReturn((Object)true);
        EasyMock.expect((Object)driverForDto.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraAlreadyRegistredToCurrentUserSuccessful() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        GatewayClientEntity currentGatewayClient = new GatewayClientEntity();
        currentGatewayClient.setDeviceType(Integer.valueOf(16));
        currentGatewayClient.setUser(new UserEntity(Integer.valueOf(1)));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(currentGatewayClient);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:06:CD:80")).andReturn(clients);
        LanDeviceEntity currentDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        currentDeviceEntity.setUser(new UserEntity(Integer.valueOf(1)));
        currentDeviceEntity.setReconfiguration(Boolean.valueOf(true));
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)currentDeviceEntity);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(1);
        GenericLanDevice driverForDto = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(currentDeviceEntity)).andReturn((Object)driverForDto);
        EasyMock.expect((Object)driverForDto.isFirmwareUpToDate(currentDeviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driverForDto.getConnCheckUrl()).andReturn((Object)"/connCheck");
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(2);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        LanDevice device = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        device.setReconfiguration(Boolean.valueOf(true));
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(true));
        device.setHasLedControl(Boolean.valueOf(true));
        device.setHasPrivacyButtonControl(Boolean.valueOf(true));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setConnCheckUrl("/connCheck");
        9 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expectLastCall().times(2);
        GatewayClientEntity gatewayClientEntitySaved = new GatewayClientEntity();
        gatewayClientEntitySaved.setGatewayClientId(Integer.valueOf(1));
        gatewayClientEntitySaved.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setMac("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setName("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setDeleted(false);
        gatewayClientEntitySaved.setUser(null);
        gatewayClientEntitySaved.setActivationDate(addedDate);
        gatewayClientEntitySaved.setDeviceType(Integer.valueOf(16));
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setLanDeviceId(Integer.valueOf(1));
        deviceEntity.setName("TC5633-TCSW-0100h");
        deviceEntity.setLocation("Room No. 106");
        deviceEntity.setDescription("Vivotek camea in office");
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("192.168.21.138");
        deviceEntity.setVersion("TC5633-TCSW-0100h");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setReconfiguration(Boolean.valueOf(true));
        deviceEntity.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"NgbE78eBUB");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setGatewayClient(currentGatewayClient);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSave.setName("TC5633-TCSW-0100h");
        deviceEntityToSave.setLocation("Room No. 106");
        deviceEntityToSave.setDescription("Vivotek camea in office");
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("192.168.21.138");
        deviceEntityToSave.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setReconfiguration(Boolean.valueOf(true));
        deviceEntityToSave.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(currentGatewayClient);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityWithoutParams = new LanDeviceEntity();
        deviceEntityWithoutParams.setLanDeviceId(Integer.valueOf(1));
        deviceEntityWithoutParams.setName("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setLocation("Room No. 106");
        deviceEntityWithoutParams.setDescription("Vivotek camea in office");
        deviceEntityWithoutParams.setMac("00:02:D1:06:CD:80");
        deviceEntityWithoutParams.setIpAddress("192.168.21.138");
        deviceEntityWithoutParams.setVersion("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setPort(Integer.valueOf(80));
        deviceEntityWithoutParams.setDeleted(false);
        deviceEntityWithoutParams.setUsername("root");
        deviceEntityWithoutParams.setPass("rootPass");
        deviceEntityWithoutParams.setReconfiguration(Boolean.valueOf(true));
        deviceEntityWithoutParams.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityWithoutParams.setLanDeviceParams(new ArrayList());
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityWithoutParams.setGatewayClient(currentGatewayClient);
        deviceEntityWithoutParams.setDeviceDesc(deviceDescEntity);
        deviceEntityWithoutParams.setAddedDate(addedDate);
        deviceEntityWithoutParams.setUser(user);
        deviceEntityWithoutParams.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setName("TC5633-TCSW-0100h");
        deviceEntityToSaved.setLocation("Room No. 106");
        deviceEntityToSaved.setDescription("Vivotek camea in office");
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("192.168.21.138");
        deviceEntityToSaved.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSaved.setGatewayClient(currentGatewayClient);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityWithoutParams)).andReturn((Object)deviceEntityWithoutParams);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    public void testActivateCameraAlreadyRegistredToCurrentUserFailureRemoveOrphanParams() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        GatewayClientEntity currentGatewayClient = new GatewayClientEntity();
        currentGatewayClient.setDeviceType(Integer.valueOf(16));
        currentGatewayClient.setUser(new UserEntity(Integer.valueOf(1)));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(currentGatewayClient);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:06:CD:80")).andReturn(clients);
        LanDeviceEntity currentDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        currentDeviceEntity.setUser(new UserEntity(Integer.valueOf(1)));
        currentDeviceEntity.setReconfiguration(Boolean.valueOf(true));
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)currentDeviceEntity);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(1);
        GenericLanDevice driverForDto = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(currentDeviceEntity)).andReturn((Object)driverForDto);
        EasyMock.expect((Object)driverForDto.isFirmwareUpToDate(currentDeviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driverForDto.getConnCheckUrl()).andReturn((Object)"/connCheck");
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(2);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        LanDevice device = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        device.setReconfiguration(Boolean.valueOf(true));
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(true));
        device.setHasLedControl(Boolean.valueOf(true));
        device.setHasPrivacyButtonControl(Boolean.valueOf(true));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setConnCheckUrl("/connCheck");
        10 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expectLastCall().times(2);
        GatewayClientEntity gatewayClientEntitySaved = new GatewayClientEntity();
        gatewayClientEntitySaved.setGatewayClientId(Integer.valueOf(1));
        gatewayClientEntitySaved.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setMac("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setName("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setDeleted(false);
        gatewayClientEntitySaved.setUser(null);
        gatewayClientEntitySaved.setActivationDate(addedDate);
        gatewayClientEntitySaved.setDeviceType(Integer.valueOf(16));
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setLanDeviceId(Integer.valueOf(1));
        deviceEntity.setName("TC5633-TCSW-0100h");
        deviceEntity.setLocation("Room No. 106");
        deviceEntity.setDescription("Vivotek camea in office");
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("192.168.21.138");
        deviceEntity.setVersion("TC5633-TCSW-0100h");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setReconfiguration(Boolean.valueOf(true));
        deviceEntity.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"NgbE78eBUB");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setGatewayClient(currentGatewayClient);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSave.setName("TC5633-TCSW-0100h");
        deviceEntityToSave.setLocation("Room No. 106");
        deviceEntityToSave.setDescription("Vivotek camea in office");
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("192.168.21.138");
        deviceEntityToSave.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setReconfiguration(Boolean.valueOf(true));
        deviceEntityToSave.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass", null));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(currentGatewayClient);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityWithoutParams = new LanDeviceEntity();
        deviceEntityWithoutParams.setLanDeviceId(Integer.valueOf(1));
        deviceEntityWithoutParams.setName("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setLocation("Room No. 106");
        deviceEntityWithoutParams.setDescription("Vivotek camea in office");
        deviceEntityWithoutParams.setMac("00:02:D1:06:CD:80");
        deviceEntityWithoutParams.setIpAddress("192.168.21.138");
        deviceEntityWithoutParams.setVersion("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setPort(Integer.valueOf(80));
        deviceEntityWithoutParams.setDeleted(false);
        deviceEntityWithoutParams.setUsername("root");
        deviceEntityWithoutParams.setPass("rootPass");
        deviceEntityWithoutParams.setReconfiguration(Boolean.valueOf(true));
        deviceEntityWithoutParams.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityWithoutParams.setLanDeviceParams(new ArrayList());
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass", null));
        deviceEntityWithoutParams.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityWithoutParams.setGatewayClient(currentGatewayClient);
        deviceEntityWithoutParams.setDeviceDesc(deviceDescEntity);
        deviceEntityWithoutParams.setAddedDate(addedDate);
        deviceEntityWithoutParams.setUser(user);
        deviceEntityWithoutParams.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setName("TC5633-TCSW-0100h");
        deviceEntityToSaved.setLocation("Room No. 106");
        deviceEntityToSaved.setDescription("Vivotek camea in office");
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("192.168.21.138");
        deviceEntityToSaved.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSaved.setGatewayClient(currentGatewayClient);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityWithoutParams)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "192.168.21.138", "ERROR", "Lan device has not been stored in database.");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    @Test
    public void testGetWlanAccessPointsDeviceNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        WlanAccessPoints expectedResponse = new WlanAccessPoints(WlanAccessPoints.GetWlanAccessPointsStatus.FAILED_DEVICENOTFOUND);
        WlanAccessPoints response = this.lanDeviceService.getWlanAccessPoints(Integer.valueOf(1));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetWlanAccessPointsDriverNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        WlanAccessPoints expectedResponse = new WlanAccessPoints(WlanAccessPoints.GetWlanAccessPointsStatus.FAILED_DRIVERNOTFOUND);
        WlanAccessPoints response = this.lanDeviceService.getWlanAccessPoints(Integer.valueOf(1));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private WlanAccessPoint buildWlanAccessPoint(WlanAccessPoint.WlanMode wlanMode, String ssid, int channel, int signalStrength, EncryptionMode.Encryption encryption, EncryptionMode.Algorithm algorithm) {
        WlanAccessPoint w = new WlanAccessPoint();
        w.setWlanMode(wlanMode);
        w.setSsid(ssid);
        w.setBssid("bssid");
        w.setChannel(Integer.valueOf(channel));
        w.setSignalStrength(Integer.valueOf(signalStrength));
        ArrayList<EncryptionMode> encryptionModes = new ArrayList<EncryptionMode>();
        encryptionModes.add(new EncryptionMode(encryption, algorithm));
        w.setEncryptionModes(encryptionModes);
        return w;
    }

    @Test
    public void testGetWlanAccessPointsSuccesful() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        ArrayList<WlanAccessPoint> wlanAccessPoints = new ArrayList<WlanAccessPoint>();
        WlanAccessPoint w1 = this.buildWlanAccessPoint(WlanAccessPoint.WlanMode.INFRASTRUCTURE, "netia", 2, 95, EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP);
        WlanAccessPoint w2 = this.buildWlanAccessPoint(WlanAccessPoint.WlanMode.INFRASTRUCTURE, "smart-apps", 2, 100, EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP);
        WlanAccessPoint w3 = this.buildWlanAccessPoint(WlanAccessPoint.WlanMode.INFRASTRUCTURE, "bb", 2, 44, EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP);
        WlanAccessPoint w4 = this.buildWlanAccessPoint(WlanAccessPoint.WlanMode.INFRASTRUCTURE, "ba", 2, 44, EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP);
        WlanAccessPoint w5 = this.buildWlanAccessPoint(WlanAccessPoint.WlanMode.INFRASTRUCTURE, "bt", 2, 44, EncryptionMode.Encryption.WPA2, EncryptionMode.Algorithm.AES_CCMP);
        wlanAccessPoints.add(w1);
        wlanAccessPoints.add(w2);
        wlanAccessPoints.add(w3);
        wlanAccessPoints.add(w4);
        wlanAccessPoints.add(w5);
        EasyMock.expect((Object)driver.getWirelessNetworks(device)).andReturn(wlanAccessPoints);
        PowerMock.replayAll((Object[])new Object[0]);
        ArrayList<WlanAccessPoint> expectedWlanAccessPoints = new ArrayList<WlanAccessPoint>();
        expectedWlanAccessPoints.add(w2);
        expectedWlanAccessPoints.add(w1);
        expectedWlanAccessPoints.add(w4);
        expectedWlanAccessPoints.add(w3);
        expectedWlanAccessPoints.add(w5);
        WlanAccessPoints expectedResponse = new WlanAccessPoints(WlanAccessPoints.GetWlanAccessPointsStatus.SUCCESS, expectedWlanAccessPoints);
        WlanAccessPoints response = this.lanDeviceService.getWlanAccessPoints(Integer.valueOf(1));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceParamNotFoundDevice() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.lanDeviceService.updateLanDeviceParamWithAuth(Integer.valueOf(1), "system_ledoff", "ON");
        UpdateSettingStatus expectedResponse = UpdateSettingStatus.FAILED_DEVICENOTFOUND;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceParamDriverNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundDevice)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.lanDeviceService.updateLanDeviceParamWithAuth(Integer.valueOf(1), "system_ledoff", "ON");
        UpdateSettingStatus expectedResponse = UpdateSettingStatus.FAILED_DRIVERNOTFOUND;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceParamNotFoundParam() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundDevice)).andReturn((Object)driver);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.lanDeviceService.updateLanDeviceParamWithAuth(Integer.valueOf(1), "test", "ON");
        UpdateSettingStatus expectedResponse = UpdateSettingStatus.FAILED_PARAMNOTFOUND;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceParamOnCameraSuccessfuly() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundDevice)).andReturn((Object)driver);
        HashSet<String> supportedParams = new HashSet<String>();
        supportedParams.add("system_ledoff");
        EasyMock.expect((Object)driver.getSupportedSettings()).andReturn(supportedParams);
        EasyMock.expect((Object)driver.updateSingleSetting(foundDevice, "system_ledoff", "ON")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.lanDeviceService.updateLanDeviceParamWithAuth(Integer.valueOf(1), "system_ledoff", "ON");
        UpdateSettingStatus expectedResponse = UpdateSettingStatus.SUCCESS;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceParamOnDatabaseOnlySuccessfuly() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundDevice)).andReturn((Object)driver);
        HashSet<String> supportedParams = new HashSet<String>();
        supportedParams.add("system_ledoff");
        EasyMock.expect((Object)driver.getSupportedSettings()).andReturn(supportedParams);
        LanDeviceParamEntity param = new LanDeviceParamEntity("alarm_limit", "120", "120");
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.lanDeviceService.updateLanDeviceParamWithAuth(Integer.valueOf(1), "alarm_limit", "120");
        UpdateSettingStatus expectedResponse = UpdateSettingStatus.SUCCESS;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDeviceParamOnDatabaseOnlyFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)foundDevice);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(foundDevice)).andReturn((Object)driver);
        HashSet<String> supportedParams = new HashSet<String>();
        supportedParams.add("system_ledoff");
        EasyMock.expect((Object)driver.getSupportedSettings()).andReturn(supportedParams);
        LanDeviceParamEntity param = new LanDeviceParamEntity("alarm_limit", "120", "120");
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateSettingStatus response = this.lanDeviceService.updateLanDeviceParamWithAuth(Integer.valueOf(1), "alarm_limit", "120");
        UpdateSettingStatus expectedResponse = UpdateSettingStatus.ERROR;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDeviceMACById() throws InvalidSessionException {
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)foundDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        String mac = this.lanDeviceService.getLanDeviceMACById(Integer.valueOf(1));
        Assert.assertEquals((Object)foundDevice.getMac(), (Object)mac);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDeviceIpAndPortById() throws InvalidSessionException {
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)foundDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        String ipAndPort = this.lanDeviceService.getLanDeviceIpAndPortById(Integer.valueOf(1));
        Assert.assertEquals((Object)(String.valueOf(foundDevice.getIpAddress()) + ":" + foundDevice.getPort()), (Object)ipAndPort);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraWithNullFreePeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        11 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private void testActivateCameraWithIncorrectPeriod(String period) throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)period);
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)validTo);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        12 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraWithIncorectPeriodValue() throws Exception {
        this.testActivateCameraWithIncorrectPeriod("a1d");
    }

    @Test
    public void testActivateCameraWithIncorectPeriodUnit() throws Exception {
        this.testActivateCameraWithIncorrectPeriod("a1S");
    }

    @Test
    public void testActivateCameraInMiddleOfMonthWithDayFreePeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"3d");
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(this.createLanDevice(Integer.valueOf(1), "Camera #1", "user1@test.pl", "en"));
        devices.add(this.createLanDevice(Integer.valueOf(2), "Camera #2", "user2@test.pl", "de"));
        Date twoWeeksForward = Utils.constructDate((int)2011, (int)10, (int)10, (int)10, (int)57, (int)48);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(twoWeeksForward)).andReturn(devices);
        HashMap<String, String> device1Placeholders = new HashMap<String, String>();
        device1Placeholders.put("%CAMERANAME%", "Camera #1");
        device1Placeholders.put("%EXPIRYDATE%", "2011-10-10");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(this.createUser("user1@test.pl", "en"), EmailNotificationService.EmailCode.CAMERA_VALIDITY_EXPIRY_APPROACH, device1Placeholders, null)).andReturn((Object)true);
        HashMap<String, String> device2Placeholders = new HashMap<String, String>();
        device2Placeholders.put("%CAMERANAME%", "Camera #2");
        device2Placeholders.put("%EXPIRYDATE%", "2011-10-10");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(this.createUser("user2@test.pl", "de"), EmailNotificationService.EmailCode.CAMERA_VALIDITY_EXPIRY_APPROACH, device2Placeholders, null)).andReturn((Object)true);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        13 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(null)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(null);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(null);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(null);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.notifyDeviceValidityExpiryApproach();
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraLastDayOfMonthWithDayFreePeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1d");
        Date currentDate = Utils.constructDate((int)2011, (int)3, (int)31, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date validTo = Utils.constructDate((int)2011, (int)4, (int)1, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        14 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraInMiddleOfMonthWithMonthFreePeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date validTo = Utils.constructDate((int)2011, (int)10, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        15 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraLastDayOfMonthWithOneMonthFreePeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        Date currentDate = Utils.constructDate((int)2011, (int)3, (int)31, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date validTo = Utils.constructDate((int)2011, (int)4, (int)30, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        16 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraLastDayOfMonthWithTwoMonthFreePeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq")).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"2m");
        Date currentDate = Utils.constructDate((int)2011, (int)3, (int)31, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date validTo = Utils.constructDate((int)2011, (int)5, (int)31, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        17 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"vieverPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSave.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "camera")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "vieverPass"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_user", "1_alarmUser"));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("alarm_pass", "alarmPass"));
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyDeviceValidityExpiryApproachSuccessfuly() {
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_NOTIFY_DEVICE_VALIDITY_DAYS)).andReturn((Object)"14d");
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)26, (int)10, (int)57, (int)48);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = this.createLanDevice(Integer.valueOf(1), "Camera #1", "user1@test.pl", "en");
        this.addDeviceFeature(device1, DeviceFeatureCode.VALIDITY_EXPIRY_SOON_EMAIL_TEMPLATE, "testTemplate1");
        devices.add(device1);
        LanDeviceEntity device2 = this.createLanDevice(Integer.valueOf(2), "Camera #2", "user2@test.pl", "de");
        this.addDeviceFeature(device2, DeviceFeatureCode.VALIDITY_EXPIRY_SOON_EMAIL_TEMPLATE, "testTemplate2");
        devices.add(device2);
        Date twoWeeksForward = Utils.constructDate((int)2011, (int)10, (int)10, (int)10, (int)57, (int)48);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(twoWeeksForward)).andReturn(devices);
        HashMap<String, String> device1Placeholders = new HashMap<String, String>();
        device1Placeholders.put("%CAMERANAME%", "Camera #1");
        device1Placeholders.put("%EXPIRYDATE%", "2011-10-10");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(this.createUser("user1@test.pl", "en"), "testTemplate1", device1Placeholders, null)).andReturn((Object)true);
        HashMap<String, String> device2Placeholders = new HashMap<String, String>();
        device2Placeholders.put("%CAMERANAME%", "Camera #2");
        device2Placeholders.put("%EXPIRYDATE%", "2011-10-10");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(this.createUser("user2@test.pl", "de"), "testTemplate2", device2Placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.notifyDeviceValidityExpiryApproach();
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyDeviceValidityExpiryApproachNullDevicesFound() {
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_NOTIFY_DEVICE_VALIDITY_DAYS)).andReturn((Object)"14d");
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)26, (int)10, (int)57, (int)48);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date twoWeeksForward = Utils.constructDate((int)2011, (int)10, (int)10, (int)10, (int)57, (int)48);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(twoWeeksForward)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.notifyDeviceValidityExpiryApproach();
        PowerMock.verifyAll();
    }

    @Test
    public void testNotifyDeviceValidityExpiryApproachNoDevicesFound() {
        EasyMock.expect((Object)this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_NOTIFY_DEVICE_VALIDITY_DAYS)).andReturn((Object)"14d");
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)26, (int)10, (int)57, (int)48);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        ArrayList devices = new ArrayList();
        Date twoWeeksForward = Utils.constructDate((int)2011, (int)10, (int)10, (int)10, (int)57, (int)48);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(twoWeeksForward)).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.notifyDeviceValidityExpiryApproach();
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToBasicProductSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.TRIAL);
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setDeleted(false);
        updatedDevice.setProduct(product);
        updatedDevice.setProductDate(currentDate);
        updatedDevice.setValidTo(null);
        updatedDevice.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        expectedResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.TRIAL);
        expectedResponse.setProductType(DeviceProduct.DeviceProductType.BASIC);
        expectedResponse.setProductName("productName");
        expectedResponse.setValidTo(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToTrialProductWithSendEmailNoificationSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setName("cameraName");
        device.setDeleted(false);
        device.setUser(user);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        Date validTo = Utils.constructDate((int)2012, (int)4, (int)6, (int)10, (int)21, (int)11);
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setName("cameraName");
        updatedDevice.setDeleted(false);
        updatedDevice.setProduct(product);
        updatedDevice.setProductDate(currentDate);
        updatedDevice.setTrialProductDate(currentDate);
        updatedDevice.setValidTo(validTo);
        updatedDevice.setUser(user);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.PRODUCT_WELCOME_EMAIL_TEMPLATE)).andReturn((Object)"code");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-04-06");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), "code", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        expectedResponse.setProductType(DeviceProduct.DeviceProductType.TRIAL);
        expectedResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.BASIC);
        expectedResponse.setProductName("productName");
        expectedResponse.setValidTo(validTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToTrialProductWithoutSendEmailNoificationSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        Date validTo = Utils.constructDate((int)2012, (int)4, (int)6, (int)10, (int)21, (int)11);
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setDeleted(false);
        updatedDevice.setProduct(product);
        updatedDevice.setProductDate(currentDate);
        updatedDevice.setTrialProductDate(currentDate);
        updatedDevice.setValidTo(validTo);
        updatedDevice.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getDeviceFeatureValue(Integer.valueOf(1), DeviceFeatureCode.PRODUCT_WELCOME_EMAIL_TEMPLATE)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        expectedResponse.setProductType(DeviceProduct.DeviceProductType.TRIAL);
        expectedResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.BASIC);
        expectedResponse.setProductName("productName");
        expectedResponse.setValidTo(validTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToPremiumProductWithNotUsedTrialSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setTrialProductDate(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(3));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(3), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        ProductEntity premiumProduct = new ProductEntity(Integer.valueOf(4));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)premiumProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(4), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"12m");
        Date validTo = Utils.constructDate((int)2013, (int)4, (int)6, (int)10, (int)21, (int)11);
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setDeleted(false);
        updatedDevice.setProduct(product);
        updatedDevice.setProductDate(currentDate);
        updatedDevice.setTrialProductDate(currentDate);
        updatedDevice.setValidTo(validTo);
        updatedDevice.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        expectedResponse.setProductType(DeviceProduct.DeviceProductType.PREMIUM);
        expectedResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.BASIC);
        expectedResponse.setProductName("productName");
        expectedResponse.setValidTo(validTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToPremiumProductWithTrialOngoingSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        Date trialProductDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)10, (int)21, (int)11);
        device.setTrialProductDate(trialProductDate);
        Date trialValidTo = Utils.constructDate((int)2012, (int)4, (int)1, (int)10, (int)21, (int)11);
        device.setValidTo(trialValidTo);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.TRIAL);
        ProductEntity premiumProduct = new ProductEntity(Integer.valueOf(4));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)premiumProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(4), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"12m");
        Date validTo = Utils.constructDate((int)2013, (int)4, (int)1, (int)10, (int)21, (int)11);
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setDeleted(false);
        updatedDevice.setProduct(product);
        updatedDevice.setProductDate(currentDate);
        updatedDevice.setTrialProductDate(trialProductDate);
        updatedDevice.setValidTo(validTo);
        updatedDevice.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        expectedResponse.setProductType(DeviceProduct.DeviceProductType.PREMIUM);
        expectedResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.TRIAL);
        expectedResponse.setProductName("productName");
        expectedResponse.setValidTo(validTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToPremiumProductWithNotUsedTrialFailureGetPremiumPeriod() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setTrialProductDate(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(3));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(3), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        ProductEntity premiumProduct = new ProductEntity(Integer.valueOf(4));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)premiumProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(4), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToPremiumProductWithNotUsedTrialFailureGetPremiumProduct() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setTrialProductDate(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(3));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(3), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToPremiumProductWithNotUsedTrialFailureGetTrialPeriod() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setTrialProductDate(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(3));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(3), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToPremiumProductWithNotUsedTrialFailureGetTrialProduct() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setTrialProductDate(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToPremiumProductWithUsedAndPassedTrialSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        Date trialProductDate = Utils.constructDate((int)2011, (int)3, (int)6, (int)10, (int)21, (int)11);
        device.setTrialProductDate(trialProductDate);
        device.setValidTo(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        ProductEntity premiumProduct = new ProductEntity(Integer.valueOf(4));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM)).andReturn((Object)premiumProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(4), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"12m");
        Date validTo = Utils.constructDate((int)2013, (int)3, (int)6, (int)10, (int)21, (int)11);
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setDeleted(false);
        updatedDevice.setProduct(product);
        updatedDevice.setProductDate(currentDate);
        updatedDevice.setTrialProductDate(trialProductDate);
        updatedDevice.setValidTo(validTo);
        updatedDevice.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.PREMIUM);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS);
        expectedResponse.setPrevoiusProductType(DeviceProduct.DeviceProductType.BASIC);
        expectedResponse.setProductType(DeviceProduct.DeviceProductType.PREMIUM);
        expectedResponse.setProductName("productName");
        expectedResponse.setValidTo(validTo);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductToTrialProductWithNotUsedTrialFailureGetTrialPeriod() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setTrialProductDate(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)6, (int)10, (int)21, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductFailureGetProduct() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setDeleted(false);
        device.setTrialProductDate(null);
        device.setUser(new UserEntity(Integer.valueOf(1)));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.FAILED_NOTFOUNDPRODUCT);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductFailureGetDevice() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.FAILED_NOTFOUNDDEVICE);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateDeviceProductInvalidProductType() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)new LanDeviceEntity());
        PowerMock.replayAll((Object[])new Object[0]);
        UpdateDeviceProductResponse response = this.lanDeviceService.updateDeviceProduct(Integer.valueOf(1), null);
        UpdateDeviceProductResponse expectedResponse = new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.FAILED_INVALIDPRODUCTTYPE);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationCorrect() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.checkConfiguration(device)).andReturn((Object)CheckConfigurationStatus.CORRECT);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.CORRECT, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationIncorrect() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.checkConfiguration(device)).andReturn((Object)CheckConfigurationStatus.INCORRECT);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.INCORRECT, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationNoAccess() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.checkConfiguration(device)).andReturn((Object)CheckConfigurationStatus.FAILED_NOACCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.FAILED_NOACCESS, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationNoAnswer() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.checkConfiguration(device)).andReturn((Object)CheckConfigurationStatus.FAILED_NOANSWER);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.FAILED_NOANSWER, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationError() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.checkConfiguration(device)).andReturn((Object)CheckConfigurationStatus.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.ERROR, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationDeviceNotConnected() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.FAILED_DEVICENOTCONNECTED, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationDriverNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.FAILED_DRIVERNOTFOUND, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckLanDeviceConfigurationDeviceNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)CheckConfigurationStatus.FAILED_DEVICENOTFOUND, (Object)this.lanDeviceService.checkLanDeviceConfigurationAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureLanDeviceSuccess() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.reconfigure(device)).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ReconfigurationDeviceStatus.SUCCESS, (Object)this.lanDeviceService.reconfigureLanDeviceAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureLanDeviceManual() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.reconfigure(device)).andReturn((Object)GenericLanDevice.ConfigurationStatus.MANUAL);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ReconfigurationDeviceStatus.MANUAL, (Object)this.lanDeviceService.reconfigureLanDeviceAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureLanDeviceFailed() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.reconfigure(device)).andReturn((Object)GenericLanDevice.ConfigurationStatus.FAILED);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ReconfigurationDeviceStatus.FAILED, (Object)this.lanDeviceService.reconfigureLanDeviceAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureLanDeviceError() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)driver.reconfigure(device)).andReturn((Object)GenericLanDevice.ConfigurationStatus.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ReconfigurationDeviceStatus.ERROR, (Object)this.lanDeviceService.reconfigureLanDeviceAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureLanDeviceNotConnected() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ReconfigurationDeviceStatus.FAILED_DEVICENOTCONNECTED, (Object)this.lanDeviceService.reconfigureLanDeviceAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureLanDeviceDriverNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ReconfigurationDeviceStatus.FAILED_DRIVERNOTFOUND, (Object)this.lanDeviceService.reconfigureLanDeviceAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void testReconfigureLanDeviceDeviceNotFound() throws InvalidSessionException {
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Assert.assertEquals((Object)ReconfigurationDeviceStatus.FAILED_DEVICENOTFOUND, (Object)this.lanDeviceService.reconfigureLanDeviceAsAdmin(Integer.valueOf(1)));
        PowerMock.verifyAll();
    }

    @Test
    public void verifyLanDevicesConfigurationForDeviceWithIncorrectConfiguration() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice checkConfigurationDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)checkConfigurationDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)checkConfigurationDriver.checkConfiguration(device)).andReturn((Object)CheckConfigurationStatus.INCORRECT);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice reconfigurationDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)reconfigurationDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)reconfigurationDriver.reconfigure(device)).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.verifyLanDevicesConfiguration("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void verifyLanDevicesConfigurationForDeviceWithCorrectConfiguration() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice checkConfigurationDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)checkConfigurationDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)checkConfigurationDriver.checkConfiguration(device)).andReturn((Object)CheckConfigurationStatus.CORRECT);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.verifyLanDevicesConfiguration("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void verifyLanDevicesConfigurationForNoneRegistredGatewayClient() {
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.verifyLanDevicesConfiguration("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void verifyLanDevicesConfigurationForGatewaclientWithoutAnyDevices() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList devices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.verifyLanDevicesConfiguration("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void verifyLanDevicesConfigurationForDeviceWithEmptyDriver() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.verifyLanDevicesConfiguration("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void verifyLanDevicesConfigurationForNotConnectedDevice() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice checkConfigurationDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)checkConfigurationDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.verifyLanDevicesConfiguration("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void verifyLanDevicesConfigurationForDeviceWithFirstDeviceCorrectAndSecondDeviceIncorrect() {
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        LanDeviceEntity device2 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device2.setLanDeviceId(Integer.valueOf(2));
        devices.add(device1);
        devices.add(device2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device1);
        GenericLanDevice checkConfigurationDriver1 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device1)).andReturn((Object)checkConfigurationDriver1);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)checkConfigurationDriver1.checkConfiguration(device1)).andReturn((Object)CheckConfigurationStatus.CORRECT);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(2))).andReturn((Object)device2);
        GenericLanDevice checkConfigurationDriver2 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device2)).andReturn((Object)checkConfigurationDriver2);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)checkConfigurationDriver2.checkConfiguration(device2)).andReturn((Object)CheckConfigurationStatus.INCORRECT);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(2))).andReturn((Object)device2);
        GenericLanDevice reconfigurationDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device2)).andReturn((Object)reconfigurationDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)reconfigurationDriver.reconfigure(device2)).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device2)).andReturn((Object)device2);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.verifyLanDevicesConfiguration("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionSuccessfully() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device1 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        LanDeviceEntity device2 = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device2.setLanDeviceId(Integer.valueOf(2));
        devices.add(device1);
        devices.add(device2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        GenericLanDevice getVersionDriver1 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device1)).andReturn((Object)getVersionDriver1);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)getVersionDriver1.getVersion(device1)).andReturn((Object)"1.1");
        LanDeviceEntity device1Saved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device1Saved.setVersion("1.1");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(device1Saved)).andReturn((Object)device1Saved);
        GenericLanDevice getVersionDriver2 = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device2)).andReturn((Object)getVersionDriver2);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)getVersionDriver2.getVersion(device2)).andReturn((Object)"1.2");
        LanDeviceEntity device2Saved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device2Saved.setLanDeviceId(Integer.valueOf(2));
        device2Saved.setVersion("1.2");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(device2Saved)).andReturn((Object)device2Saved);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionFailureDatabaseUpdate() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        GenericLanDevice getVersionDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)getVersionDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)getVersionDriver.getVersion(device)).andReturn((Object)"1.1");
        LanDeviceEntity device1Saved = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        device1Saved.setVersion("1.1");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(device1Saved)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionFailureGetVersion() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        GenericLanDevice getVersionDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)getVersionDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)getVersionDriver.getVersion(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionGatewacClientNotConnected() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        GenericLanDevice getVersionDriver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)getVersionDriver);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionFailureGetDriver() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionForNoneDevices() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        ArrayList devices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(devices);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionForNullDevices() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(TestDataUtils.prepareGatewaClientEntity());
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(Integer.valueOf(1), false)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionForNoneRegisteredgatewayClient() {
        this.lanDeviceService.setUpdateVersionOnConnect(true);
        ArrayList clients = new ArrayList();
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:1A:B6:00:0B:B5")).andReturn(clients);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testUpdateLanDevicesVersionDisabled() {
        this.lanDeviceService.setUpdateVersionOnConnect(false);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.updateLanDevicesVersion("00:1A:B6:00:0B:B5");
        PowerMock.verifyAll();
    }

    @Test
    public void testGetLanDevice() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        ProductEntity productEntity = new ProductEntity();
        productEntity.setProductId(Integer.valueOf(1));
        productEntity.setName("productName");
        productEntity.setCode("productCode");
        productEntity.setProductfeatures(new HashSet());
        device.setProduct(productEntity);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null).times(2);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(device)).andReturn((Object)true);
        EasyMock.expect((Object)driver.getConnCheckUrl()).andReturn((Object)"/driver1");
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        PowerMock.replayAll((Object[])new Object[0]);
        LanDevice response = this.lanDeviceService.getLanDevice(Integer.valueOf(1), null);
        LanDevice expectedRespone = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)false, (boolean)false);
        ArrayList<LanDeviceParam> params = new ArrayList<LanDeviceParam>();
        params.add(new LanDeviceParam("viewer_user", "viewer", "viewer"));
        params.add(new LanDeviceParam("viewer_pass", "NgbE78eBUB", "NgbE78eBUB"));
        params.add(new LanDeviceParam("system_ledoff", "OFF", "OFF"));
        params.add(new LanDeviceParam("privacy_button", "ON", "ON"));
        params.add(new LanDeviceParam("motion_detection", "OFF", "OFF"));
        params.add(new LanDeviceParam("alarm_limit", "15", "15"));
        params.add(new LanDeviceParam("record_video", "OFF", "OFF"));
        params.add(new LanDeviceParam("video_recording_duration", "30", "30"));
        params.add(new LanDeviceParam("email_notification_0", "q1@mail.com", "q1@mail.com"));
        params.add(new LanDeviceParam("email_notification_1", "q2@mail.com", "q2@mail.com"));
        params.add(new LanDeviceParam("path", "video2.mjpg", null));
        params.add(new LanDeviceParam("path_low", "video.mjpg", null));
        params.add(new LanDeviceParam("snapshot_path", "video2.mjpg", null));
        params.add(new LanDeviceParam("snapshot_path_low", "video.mjpg", null));
        params.add(new LanDeviceParam("resolution", "640x480", null));
        params.add(new LanDeviceParam("resolution_low", "320x240", null));
        expectedRespone.setLanDeviceParams(params);
        expectedRespone.setHasHome(Boolean.valueOf(false));
        expectedRespone.setHasPan(Boolean.valueOf(false));
        expectedRespone.setHasTilt(Boolean.valueOf(false));
        expectedRespone.setHasZoom(Boolean.valueOf(false));
        expectedRespone.setHasIllumination(Boolean.valueOf(false));
        expectedRespone.setHasMotionDetection(Boolean.valueOf(true));
        expectedRespone.setHasLedControl(Boolean.valueOf(true));
        expectedRespone.setHasAudioDetection(Boolean.valueOf(false));
        expectedRespone.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        expectedRespone.setHasPrivacyButtonControl(Boolean.valueOf(true));
        expectedRespone.setFirmwareUpToDate(Boolean.valueOf(true));
        expectedRespone.setConnCheckUrl("/driver1");
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setType(DeviceProduct.DeviceProductType.BASIC);
        deviceProduct.setFeatures(new HashMap());
        expectedRespone.setProduct(deviceProduct);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedRespone, (Object)response);
    }

    private LanDeviceEntity createLanDevice(Integer deviceId, String deviceName, String userEmailAddress, String userLanguage) {
        UserEntity user = new UserEntity();
        user.setEmail(userEmailAddress);
        user.setLanguage(userLanguage);
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(deviceId);
        device.setName(deviceName);
        device.setUser(user);
        ProductEntity product = new ProductEntity();
        product.setProductfeatures(new HashSet());
        device.setProduct(product);
        return device;
    }

    private void addDeviceFeature(LanDeviceEntity device, DeviceFeatureCode code, String value) {
        if (device.getProduct() == null) {
            ProductEntity product = new ProductEntity();
            product.setProductfeatures(new HashSet());
            device.setProduct(product);
        }
        FeatureEntity feature = new FeatureEntity(null, code.name(), code.name());
        ProductfeatureEntity productfeature = new ProductfeatureEntity();
        productfeature.setFeature(feature);
        productfeature.setFeatureValue(value);
        device.getProduct().getProductfeatures().add(productfeature);
    }

    private User createUser(String email, String language) {
        User user = new User();
        user.setEmail(email);
        user.setLanguage(language);
        user.setDeleted(Boolean.valueOf(false));
        user.setMailing(Boolean.valueOf(false));
        return user;
    }

    @Test
    public void testGetStatusForSomeDevices() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        devices.add(this.createLanDeviceEntity(Integer.valueOf(1), false, false, LanDevice.FirmwareUpgradeStatus.SUCCESS));
        devices.add(this.createLanDeviceEntity(Integer.valueOf(2), true, false, LanDevice.FirmwareUpgradeStatus.FAILURE));
        devices.add(this.createLanDeviceEntity(Integer.valueOf(3), false, true, LanDevice.FirmwareUpgradeStatus.SUCCESS));
        devices.add(this.createLanDeviceEntity(Integer.valueOf(4), true, true, LanDevice.FirmwareUpgradeStatus.FAILURE));
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false)).andReturn(devices);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(1))).andReturn(null);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(2))).andReturn(null);
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(3))).andReturn((Object)new EventEntity());
        EasyMock.expect((Object)this.eventDAO.getActiveEvent(Integer.valueOf(4))).andReturn((Object)new EventEntity());
        HashMap<Integer, LanDeviceStatus> expectedResponse = new HashMap<Integer, LanDeviceStatus>();
        expectedResponse.put(1, new LanDeviceStatus(false, false, false, LanDevice.FirmwareUpgradeStatus.SUCCESS));
        expectedResponse.put(2, new LanDeviceStatus(false, true, false, LanDevice.FirmwareUpgradeStatus.FAILURE));
        expectedResponse.put(3, new LanDeviceStatus(true, false, true, LanDevice.FirmwareUpgradeStatus.SUCCESS));
        expectedResponse.put(4, new LanDeviceStatus(true, true, true, LanDevice.FirmwareUpgradeStatus.FAILURE));
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.lanDeviceService.getStatus();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetStatusForNoneDevices() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ArrayList devices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false)).andReturn(devices);
        HashMap expectedResponse = new HashMap();
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.lanDeviceService.getStatus();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetStatusForNullDevices() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByUserId(Integer.valueOf(1), false)).andReturn(null);
        HashMap expectedResponse = new HashMap();
        PowerMock.replayAll((Object[])new Object[0]);
        Map response = this.lanDeviceService.getStatus();
        Assert.assertEquals(expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    private LanDeviceEntity createLanDeviceEntity(Integer lanDeviceId, boolean illuminationEnabled, boolean firmwareUpgradeInProgress, LanDevice.FirmwareUpgradeStatus firmwareUpgradeStatus) {
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(lanDeviceId);
        String value = illuminationEnabled ? "ON" : "OFF";
        Utils.addDeviceParam((LanDeviceEntity)device, (String)"illumination", (String)value, (String)value);
        device.setConfigurationStatus(firmwareUpgradeInProgress ? LanDevice.LanDeviceConfigurationStatus.FIRMWARE_UPGRADE : LanDevice.LanDeviceConfigurationStatus.OK);
        device.setUpgradeStatus(firmwareUpgradeStatus);
        return device;
    }

    @Test
    public void testCheckRssiSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.checkRSSI(device)).andReturn((Object)83);
        PowerMock.replayAll((Object[])new Object[0]);
        Rssi expectedResponse = new Rssi(Rssi.CheckRssiStatus.SUCCESS, Integer.valueOf(83));
        Rssi response = this.lanDeviceService.checkRssi(Integer.valueOf(1));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureDriverNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Rssi expectedResponse = new Rssi(Rssi.CheckRssiStatus.FAILED_DRIVERNOTFOUND, null);
        Rssi response = this.lanDeviceService.checkRssi(Integer.valueOf(1));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureDeviceDisconnected() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)TestDataUtils.prepareBrickcomLanDeviceEntity((boolean)true, (boolean)true, (boolean)false));
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        Rssi expectedResponse = new Rssi(Rssi.CheckRssiStatus.FAILED_DEVICEDISCONNECTED, null);
        Rssi response = this.lanDeviceService.checkRssi(Integer.valueOf(1));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureNotFoundDevice() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        Rssi expectedResponse = new Rssi(Rssi.CheckRssiStatus.FAILED_DEVICENOTFOUND, null);
        Rssi response = this.lanDeviceService.checkRssi(Integer.valueOf(1));
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckRssiFailureInvalidId() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        Rssi expectedResponse = new Rssi(Rssi.CheckRssiStatus.FAILED_INVALIDDEVICEID, null);
        Rssi response = this.lanDeviceService.checkRssi(null);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(device)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        LanDeviceEntity firmwareUpgradeInProgresDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        firmwareUpgradeInProgresDevice.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.FIRMWARE_UPGRADE);
        Date firmwareUpgradeDate = Utils.constructDate((int)2012, (int)1, (int)11, (int)10, (int)4, (int)5);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)firmwareUpgradeDate);
        firmwareUpgradeInProgresDevice.setUpgradeDate(firmwareUpgradeDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(firmwareUpgradeInProgresDevice)).andReturn((Object)firmwareUpgradeInProgresDevice);
        EasyMock.expect((Object)driver.upgradeFirmware(device)).andReturn((Object)true);
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, "00:02:D1:06:CD:80", "192.168.21.138", UpgradeFirmwareStatus.SUCCESS.name(), null);
        LanDeviceEntity firmwareUpgradedDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        firmwareUpgradedDevice.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        firmwareUpgradedDevice.setUpgradeStatus(LanDevice.FirmwareUpgradeStatus.SUCCESS);
        firmwareUpgradedDevice.setUpgradeDate(firmwareUpgradeDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(firmwareUpgradedDevice)).andReturn((Object)firmwareUpgradedDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        UpgradeFirmwareStatus response = this.lanDeviceService.upgradeFirmware(Integer.valueOf(1));
        Assert.assertEquals((Object)UpgradeFirmwareStatus.SUCCESS, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(device)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)true);
        LanDeviceEntity firmwareUpgradeInProgresDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        firmwareUpgradeInProgresDevice.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.FIRMWARE_UPGRADE);
        Date firmwareUpgradeDate = Utils.constructDate((int)2012, (int)1, (int)11, (int)10, (int)4, (int)5);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)firmwareUpgradeDate);
        firmwareUpgradeInProgresDevice.setUpgradeDate(firmwareUpgradeDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(firmwareUpgradeInProgresDevice)).andReturn((Object)firmwareUpgradeInProgresDevice);
        EasyMock.expect((Object)driver.upgradeFirmware(device)).andReturn((Object)false);
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, "00:02:D1:06:CD:80", "192.168.21.138", UpgradeFirmwareStatus.ERROR.name(), null);
        LanDeviceEntity firmwareUpgradedDevice = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        firmwareUpgradedDevice.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        firmwareUpgradedDevice.setUpgradeStatus(LanDevice.FirmwareUpgradeStatus.FAILURE);
        firmwareUpgradedDevice.setUpgradeDate(firmwareUpgradeDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(firmwareUpgradedDevice)).andReturn((Object)firmwareUpgradedDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        UpgradeFirmwareStatus response = this.lanDeviceService.upgradeFirmware(Integer.valueOf(1));
        Assert.assertEquals((Object)UpgradeFirmwareStatus.ERROR, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareDeviceDisconected() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(device)).andReturn((Object)false);
        EasyMock.expect((Object)this.gatewayClientService.isGatewayClientConnected("00:1A:B6:00:0B:B5")).andReturn((Object)false);
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, "00:02:D1:06:CD:80", "192.168.21.138", "FAILED_DEVICEDISCONNECTED", null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpgradeFirmwareStatus response = this.lanDeviceService.upgradeFirmware(Integer.valueOf(1));
        Assert.assertEquals((Object)UpgradeFirmwareStatus.FAILED_DEVICEDISCONNECTED, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeUpToDateFirmware() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.isFirmwareUpToDate(device)).andReturn((Object)true);
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, "00:02:D1:06:CD:80", "192.168.21.138", "FAILED_FIRMWAREISUPTODATE", null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpgradeFirmwareStatus response = this.lanDeviceService.upgradeFirmware(Integer.valueOf(1));
        Assert.assertEquals((Object)UpgradeFirmwareStatus.FAILED_FIRMWAREISUPTODATE, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareDriverNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        LanDeviceEntity device = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, "00:02:D1:06:CD:80", "192.168.21.138", "FAILED_DRIVERNOTFOUND", null);
        PowerMock.replayAll((Object[])new Object[0]);
        UpgradeFirmwareStatus response = this.lanDeviceService.upgradeFirmware(Integer.valueOf(1));
        Assert.assertEquals((Object)UpgradeFirmwareStatus.FAILED_DRIVERNOTFOUND, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareDeviceNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceByIdAndUserId(Integer.valueOf(1), Integer.valueOf(1))).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, "", "", "FAILED_DEVICENOTFOUND", "Attempt to make upgrade for device with lanDeiceId=1.");
        PowerMock.replayAll((Object[])new Object[0]);
        UpgradeFirmwareStatus response = this.lanDeviceService.upgradeFirmware(Integer.valueOf(1));
        Assert.assertEquals((Object)UpgradeFirmwareStatus.FAILED_DEVICENOTFOUND, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testUpgradeFirmwareInvelidDeviceId() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, "", "", "FAILED_INVALIDDEVICEID", "Attempt to make upgrade for device with lanDeiceId=null.");
        PowerMock.replayAll((Object[])new Object[0]);
        UpgradeFirmwareStatus response = this.lanDeviceService.upgradeFirmware(null);
        Assert.assertEquals((Object)UpgradeFirmwareStatus.FAILED_INVALIDDEVICEID, (Object)response);
        PowerMock.verifyAll();
    }

    @Test(expected=InvalidSessionException.class)
    public void testUpgradeFirmwareUserNotLoggedIn() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expectLastCall().andThrow((Throwable)new InvalidSessionException());
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.upgradeFirmware(Integer.valueOf(1));
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductWithIncorrectActivationCode() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.FAILED_CODEINCORRECT);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForNewCamera() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"ON");
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS, true, true);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForNewCameraWithAutomaticTrialFeatureOn() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"ON");
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS, true, true);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForNewCameraWithAutomaticTrialFeatureOff() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"OFF");
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS, true, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForNewCameraWithAutomaticTrialFeatureNull() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS, true, false);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForCameraTrialNotUsed() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setTrialProductDate(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn((Object)device);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"ON");
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS, true, true);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForCameraTrialOngoing() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"ON");
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        Date trialProductDate = Utils.constructDate((int)2012, (int)2, (int)28);
        device.setTrialProductDate(trialProductDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn((Object)device);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(3));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(3), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.TRIAL);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS);
        expectedResponse.setPossibleTrial(false);
        expectedResponse.setTrialDateValidFrom(trialProductDate);
        expectedResponse.setTrialDateValidTo(Utils.constructDate((int)2012, (int)3, (int)28));
        expectedResponse.setTrialPassed(false);
        expectedResponse.setAutomaticTrial(true);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForCameraTrialPassed() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"ON");
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        Date trialProductDate = Utils.constructDate((int)2012, (int)2, (int)28);
        device.setTrialProductDate(trialProductDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn((Object)device);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(3));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(3), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.PREMIUM);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS);
        expectedResponse.setPossibleTrial(false);
        expectedResponse.setTrialDateValidFrom(trialProductDate);
        expectedResponse.setTrialDateValidTo(Utils.constructDate((int)2012, (int)3, (int)28));
        expectedResponse.setTrialPassed(true);
        expectedResponse.setAutomaticTrial(true);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialFailureFindDeviceValidityProductFeature() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"ON");
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        Date trialProductDate = Utils.constructDate((int)2012, (int)2, (int)28);
        device.setTrialProductDate(trialProductDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn((Object)device);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(3));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(3), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testCheckDeviceTrialProductForCameraTrialOngoingFailureFindTrialProduct() throws InvalidSessionException {
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("activationCode")).andReturn((Object)"deviceMacAddress");
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL)).andReturn((Object)"ON");
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        Date trialProductDate = Utils.constructDate((int)2012, (int)2, (int)28);
        device.setTrialProductDate(trialProductDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("deviceMacAddress")).andReturn((Object)device);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        CheckDeviceTrialProductResponse response = this.lanDeviceService.checkDeviceTrialProduct("activationCode");
        CheckDeviceTrialProductResponse expectedResponse = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.ERROR);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testManageDevicesProductWithLockAndSendDefaultNotificatonEmail() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(user);
        device.setValidTo(exceededValidTo);
        device.setName("cameraName");
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "LOCK");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        devices.add(device);
        LanDeviceEntity deviceBasic = new LanDeviceEntity();
        deviceBasic.setLanDeviceId(Integer.valueOf(2));
        deviceBasic.setUser(user);
        deviceBasic.setValidTo(exceededValidTo);
        deviceBasic.setName("cameraName");
        ProductBuilder productBuilderBasic = new ProductBuilder();
        productBuilderBasic.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "LOCK");
        deviceBasic.setProduct(productBuilderBasic.getProduct());
        devices.add(deviceBasic);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-02-29");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), EmailNotificationService.EmailCode.CAMERA_VALIDITY_EXPIRED, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageDevicesProductWithLockAndSendDedicatedNotificatonEmail() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(user);
        device.setValidTo(exceededValidTo);
        device.setName("cameraName");
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "LOCK");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VALIDITY_EXPIRED_EMAIL_TEMPLATE, "code");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-02-29");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), "code", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageDevicesProductWithDowngradeAndSendDefaultNotificationEmail() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(user);
        device.setValidTo(exceededValidTo);
        device.setName("cameraName");
        ProductBuilder productBuilder = new ProductBuilder(Integer.valueOf(1), "productName", "productCode");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "DOWNGRADE");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        ProductBuilder basicProduct = new ProductBuilder(Integer.valueOf(2), "basic", "basic");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)basicProduct.getProduct());
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setName("cameraName");
        updatedDevice.setUser(user);
        updatedDevice.setProduct(basicProduct.getProduct());
        updatedDevice.setValidTo(exceededValidTo);
        updatedDevice.setProductDate(currentDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(2));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-02-29");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), EmailNotificationService.EmailCode.CAMERA_VALIDITY_EXPIRED, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageDevicesProductWithDowngradeAndSendDedicatedNotificationEmail() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(user);
        device.setValidTo(exceededValidTo);
        device.setName("cameraName");
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "DOWNGRADE");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VALIDITY_EXPIRED_EMAIL_TEMPLATE, "code");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        ProductBuilder basicProduct = new ProductBuilder(Integer.valueOf(2), "basic", "basic");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)basicProduct.getProduct());
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setName("cameraName");
        updatedDevice.setUser(user);
        updatedDevice.setProduct(basicProduct.getProduct());
        updatedDevice.setValidTo(exceededValidTo);
        updatedDevice.setProductDate(currentDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(2));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-02-29");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), "code", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageDevicesProductWithDowngradeProductAndDowngradeVideoQualityWithSuccesffulUpdateOnCamera() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(user);
        device.setValidTo(exceededValidTo);
        device.setName("cameraName");
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "DOWNGRADE");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VALIDITY_EXPIRED_EMAIL_TEMPLATE, "code");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("video_quality", "BEST");
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        ProductBuilder basicProduct = new ProductBuilder(Integer.valueOf(2), "basic", "basic");
        basicProduct.setDeviceFeature(DeviceFeatureCode.MAX_VIDEO_QUALITY, "GOOD");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)basicProduct.getProduct());
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setName("cameraName");
        updatedDevice.setUser(user);
        updatedDevice.setProduct(basicProduct.getProduct());
        updatedDevice.setValidTo(exceededValidTo);
        updatedDevice.setProductDate(currentDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(2));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-02-29");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), "code", placeholders, null)).andReturn((Object)true);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        HashSet<String> supportedParams = new HashSet<String>();
        supportedParams.add("video_quality");
        EasyMock.expect((Object)driver.getSupportedSettings()).andReturn(supportedParams);
        EasyMock.expect((Object)driver.updateSingleSetting(updatedDevice, "video_quality", "GOOD")).andReturn((Object)UpdateSettingStatus.SUCCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageDevicesProductWithDowngradeProductAndDowngradeVideoQualityWithFailureUpdateOnCamera() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(user);
        device.setValidTo(exceededValidTo);
        device.setName("cameraName");
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "DOWNGRADE");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VALIDITY_EXPIRED_EMAIL_TEMPLATE, "code");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("video_quality", "BEST");
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        ProductBuilder basicProduct = new ProductBuilder(Integer.valueOf(2), "basic", "basic");
        basicProduct.setDeviceFeature(DeviceFeatureCode.MAX_VIDEO_QUALITY, "GOOD");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)basicProduct.getProduct());
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setName("cameraName");
        updatedDevice.setUser(user);
        updatedDevice.setProduct(basicProduct.getProduct());
        updatedDevice.setValidTo(exceededValidTo);
        updatedDevice.setProductDate(currentDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(2));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-02-29");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), "code", placeholders, null)).andReturn((Object)true);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        HashSet<String> supportedParams = new HashSet<String>();
        supportedParams.add("video_quality");
        EasyMock.expect((Object)driver.getSupportedSettings()).andReturn(supportedParams);
        EasyMock.expect((Object)driver.updateSingleSetting(updatedDevice, "video_quality", "GOOD")).andReturn((Object)UpdateSettingStatus.ERROR);
        LanDeviceEntity expectedDowngradedVideoQualityDevice = new LanDeviceEntity();
        expectedDowngradedVideoQualityDevice.setLanDeviceId(Integer.valueOf(1));
        expectedDowngradedVideoQualityDevice.setName("cameraName");
        expectedDowngradedVideoQualityDevice.setUser(user);
        expectedDowngradedVideoQualityDevice.setProduct(basicProduct.getProduct());
        expectedDowngradedVideoQualityDevice.setValidTo(exceededValidTo);
        expectedDowngradedVideoQualityDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDowngradedVideoQualityDevice.setProductDate(currentDate);
        Capture downgradedVideoQualityDevice = new Capture();
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice((LanDeviceEntity)EasyMock.capture((Capture)downgradedVideoQualityDevice))).andReturn((Object)expectedDowngradedVideoQualityDevice);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)Utils.verifyDevice((LanDeviceEntity)expectedDowngradedVideoQualityDevice, (LanDeviceEntity)((LanDeviceEntity)downgradedVideoQualityDevice.getValue())));
    }

    @Test
    public void testManageDevicesProductWithDowngradeProductAndFailureDowngradeVideoQualityOnCameraAndInDatabse() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        UserEntity user = new UserEntity();
        user.setId(Integer.valueOf(1));
        user.setDeleted(Integer.valueOf(0));
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(user);
        device.setValidTo(exceededValidTo);
        device.setName("cameraName");
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "DOWNGRADE");
        productBuilder.setDeviceFeature(DeviceFeatureCode.VALIDITY_EXPIRED_EMAIL_TEMPLATE, "code");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        device.setParam("video_quality", "BEST");
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        ProductBuilder basicProduct = new ProductBuilder(Integer.valueOf(2), "basic", "basic");
        basicProduct.setDeviceFeature(DeviceFeatureCode.MAX_VIDEO_QUALITY, "GOOD");
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)basicProduct.getProduct());
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setName("cameraName");
        updatedDevice.setUser(user);
        updatedDevice.setProduct(basicProduct.getProduct());
        updatedDevice.setValidTo(exceededValidTo);
        updatedDevice.setProductDate(currentDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn((Object)updatedDevice);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(2));
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", "cameraName");
        placeholders.put("%EXPIRYDATE%", "2012-02-29");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(user.toDTO(), "code", placeholders, null)).andReturn((Object)true);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(device)).andReturn((Object)driver);
        HashSet<String> supportedParams = new HashSet<String>();
        supportedParams.add("video_quality");
        EasyMock.expect((Object)driver.getSupportedSettings()).andReturn(supportedParams);
        EasyMock.expect((Object)driver.updateSingleSetting(updatedDevice, "video_quality", "GOOD")).andReturn((Object)UpdateSettingStatus.ERROR);
        LanDeviceEntity expectedDowngradedVideoQualityDevice = new LanDeviceEntity();
        expectedDowngradedVideoQualityDevice.setLanDeviceId(Integer.valueOf(1));
        expectedDowngradedVideoQualityDevice.setName("cameraName");
        expectedDowngradedVideoQualityDevice.setUser(user);
        expectedDowngradedVideoQualityDevice.setProduct(basicProduct.getProduct());
        expectedDowngradedVideoQualityDevice.setValidTo(exceededValidTo);
        expectedDowngradedVideoQualityDevice.setParam("video_quality", "GOOD", "GOOD");
        expectedDowngradedVideoQualityDevice.setProductDate(currentDate);
        Capture downgradedVideoQualityDevice = new Capture();
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice((LanDeviceEntity)EasyMock.capture((Capture)downgradedVideoQualityDevice))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
        Assert.assertTrue((boolean)Utils.verifyDevice((LanDeviceEntity)expectedDowngradedVideoQualityDevice, (LanDeviceEntity)((LanDeviceEntity)downgradedVideoQualityDevice.getValue())));
    }

    @Test
    public void testManageDevicesProductWithDowngradeFailureUpdateDatabase() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(new UserEntity(Integer.valueOf(1)));
        device.setValidTo(exceededValidTo);
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "DOWNGRADE");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        ProductEntity basicProduct = new ProductEntity(Integer.valueOf(2));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)basicProduct);
        LanDeviceEntity updatedDevice = new LanDeviceEntity();
        updatedDevice.setLanDeviceId(Integer.valueOf(1));
        updatedDevice.setUser(new UserEntity(Integer.valueOf(1)));
        updatedDevice.setProduct(basicProduct);
        updatedDevice.setValidTo(exceededValidTo);
        updatedDevice.setProductDate(currentDate);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(updatedDevice)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
    }

    @Test
    public void testManageDevicesProductWithDowngradeFailureFindBasicProduct() throws InvalidSessionException {
        Date currentDate = Utils.constructDate((int)2012, (int)3, (int)1, (int)9, (int)29, (int)57);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date exceededValidTo = Utils.constructDate((int)2012, (int)2, (int)29, (int)9, (int)29, (int)57);
        ArrayList<LanDeviceEntity> devices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity device = new LanDeviceEntity();
        device.setLanDeviceId(Integer.valueOf(1));
        device.setUser(new UserEntity(Integer.valueOf(1)));
        ProductBuilder productBuilder = new ProductBuilder();
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION, "DOWNGRADE");
        productBuilder.setDeviceFeature(DeviceFeatureCode.LANDEVICE_VALIDITY, "30d");
        device.setProduct(productBuilder.getProduct());
        devices.add(device);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo)).andReturn(devices);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        this.lanDeviceService.manageDevicesProduct();
        PowerMock.verifyAll();
    }
}

