/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.VivotekCameraIpAddressDiscoveryService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.hm.WebViewer.shared.model.DeviceShare;
import pl.smartapps.hm.WebViewer.shared.model.DeviceSharedWithResponse;
import pl.smartapps.hm.WebViewer.shared.model.ShareDeviceResponse;
import pl.smartapps.hm.WebViewer.shared.model.UnshareDeviceResponse;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ShareEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.security.PasswordGenerator;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.VideoStreamService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.ActivationCodeHandler;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.LanDeviceServiceImpl;
import pl.smartapps.restserver.service.impl.LanDeviceServiceInternal;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LanDeviceServiceImpl.class})
public class LanDeviceServiceShareTests
extends LanDeviceServiceInternal {
    private UserDAO userDAO;

    @Before
    public void setUp() throws ClassNotFoundException, SQLException {
        this.lanDeviceService = new LanDeviceServiceImpl();
        this.gatewayClientDAO = (GatewayClientDAO)PowerMock.createMock(GatewayClientDAO.class);
        this.lanDeviceService.setGatewayClientDAO(this.gatewayClientDAO);
        this.lanDeviceDAO = (LanDeviceDAO)PowerMock.createMock(LanDeviceDAO.class);
        this.lanDeviceService.setLanDeviceDAO(this.lanDeviceDAO);
        this.deviceDescDAO = (DeviceDescDAO)PowerMock.createMock(DeviceDescDAO.class);
        this.lanDeviceService.setDeviceDescDAO(this.deviceDescDAO);
        this.authUtils = (AuthenticationUtils)PowerMock.createMock(AuthenticationUtils.class);
        this.lanDeviceService.setAuthUtils(this.authUtils);
        this.deviceDriverFactory = (DeviceDriverFactory)PowerMock.createMock(DeviceDriverFactory.class);
        this.lanDeviceService.setDeviceDriverFactory(this.deviceDriverFactory);
        this.containerserverServiceFactory = (ContainerserverServiceFactory)PowerMock.createMock(ContainerserverServiceFactory.class);
        this.lanDeviceService.setContainerserverServiceFactory(this.containerserverServiceFactory);
        this.passwordGenerator = (PasswordGenerator)PowerMock.createMock(PasswordGenerator.class);
        this.lanDeviceService.setPasswordGenerator(this.passwordGenerator);
        this.ipAddressDiscoveryService = (VivotekCameraIpAddressDiscoveryService)PowerMock.createMock(VivotekCameraIpAddressDiscoveryService.class);
        this.eventlogService = (EventlogService)PowerMock.createMock(EventlogService.class);
        this.lanDeviceService.setEventlogService(this.eventlogService);
        this.gatewayClientService = (GatewayClientService)PowerMock.createMock(GatewayClientService.class);
        this.lanDeviceService.setGatewayClientService(this.gatewayClientService);
        this.activationCodeHandler = (ActivationCodeHandler)PowerMock.createMock(ActivationCodeHandler.class);
        this.lanDeviceService.setActivationCodeHandler(this.activationCodeHandler);
        this.gatewayDeviceConnection = (GatewayDeviceConnectionService)PowerMock.createMock(GatewayDeviceConnectionService.class);
        this.lanDeviceService.setGatewayDeviceConnection(this.gatewayDeviceConnection);
        this.productManagementService = (ProductManagementService)PowerMock.createMock(ProductManagementService.class);
        this.lanDeviceService.setProductManagementService(this.productManagementService);
        this.systemSupport = (SystemSupport)PowerMock.createMock(SystemSupport.class);
        this.lanDeviceService.setSystemSupport(this.systemSupport);
        this.emailNotificationService = (EmailNotificationService)PowerMock.createMock(EmailNotificationService.class);
        this.lanDeviceService.setEmailNotificationService(this.emailNotificationService);
        this.videoStreamService = (VideoStreamService)PowerMock.createMock(VideoStreamService.class);
        this.lanDeviceService.setVideoStreamService(this.videoStreamService);
        this.eventDAO = (EventDAO)PowerMock.createMock(EventDAO.class);
        this.lanDeviceService.setEventDAO(this.eventDAO);
        this.parameterService = (ParameterService)PowerMock.createMock(ParameterService.class);
        this.lanDeviceService.setParameterService(this.parameterService);
        this.userDAO = (UserDAO)PowerMock.createMock(UserDAO.class);
        this.lanDeviceService.setUserDAO(this.userDAO);
    }

    @Test
    public void testShareLanDeviceForExistingAccountSuccessfullyForCamera() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        EasyMock.expect((Object)recipient.getEmail()).andReturn((Object)"recipient@test.com");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(recipient, EmailNotificationService.EmailCode.SHARE_DEVICE_CAMERA, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForExistingAccountSuccessfullyForNAS() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc).times(2);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"NAS").times(2);
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        EasyMock.expect((Object)recipient.getEmail()).andReturn((Object)"recipient@test.com");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(recipient, EmailNotificationService.EmailCode.SHARE_DEVICE_NAS, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForExistingAccountEmailFailed() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        EasyMock.expect((Object)recipient.getEmail()).andReturn((Object)"recipient@test.com");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(recipient, EmailNotificationService.EmailCode.SHARE_DEVICE_CAMERA, placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILPROBLEM, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForExistingAccountUpdateFailed() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.ERROR, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForExistingAccountSharedAlready() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, recipient));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICESHAREDALREADY, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountSuccessfullyForCamera() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)donor.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_CAMERA, "en", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountSuccessfullyForNAS() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc).times(2);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"NAS").times(2);
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)donor.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_NAS, "en", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountSuccessfullyWithRegistartionLinkWithSlash() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)donor.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_CAMERA, "en", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountSuccessfullyWithRegistartionLinkWithoutSlash() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)donor.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_CAMERA, "en", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountSuccessfullyWithServerUrlWithoutProtocol() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)donor.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_CAMERA, "en", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountEmailFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)donor.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_CAMERA, "en", placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILPROBLEM, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountNotFoundRegistationLink() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)donor.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)donor.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)donor.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)donor.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_CAMERA, "en", placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILPROBLEM, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountUpdateFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        Object recipient = null;
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(recipient);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "share1@test.com", device, (UserEntity)PowerMock.createMock(UserEntity.class)));
        shares.add(new ShareEntity(Integer.valueOf(2), "share2@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.addShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.ERROR, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceForNoneExistingAccountSharedAlready() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn((Object)device);
        Object recipient = null;
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(recipient);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICESHAREDALREADY, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceDeviceNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        UserEntity donor = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)donor);
        EasyMock.expect((Object)donor.getId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(1), Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICENOTFOUND, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceEmailNull() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), null);
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILUNDEFINED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceEmailEmpty() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(Integer.valueOf(1), "");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILUNDEFINED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testShareLanDeviceDeviceIdUndefined() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        ShareDeviceResponse response = this.lanDeviceService.shareLanDevice(null, "recipient@test.com");
        Assert.assertEquals((Object)ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICEIDUNDEFINED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForExistingAccountByOwnerSuccessfullyForCamera() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, recipient));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)claimant.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)claimant.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)claimant.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        EasyMock.expect((Object)recipient.getEmail()).andReturn((Object)"recipient@test.com");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(recipient, EmailNotificationService.EmailCode.UNSHARE_DEVICE_CAMERA, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForExistingAccountByOwnerSuccessfullyForNAS() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, recipient));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc).times(2);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"NAS").times(2);
        EasyMock.expect((Object)claimant.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)claimant.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)claimant.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        EasyMock.expect((Object)recipient.getEmail()).andReturn((Object)"recipient@test.com");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(recipient, EmailNotificationService.EmailCode.UNSHARE_DEVICE_NAS, placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForExistingAccountByOwnerSendEmailFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, recipient));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)claimant.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)claimant.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)claimant.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        EasyMock.expect((Object)recipient.getEmail()).andReturn((Object)"recipient@test.com");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail(recipient, EmailNotificationService.EmailCode.UNSHARE_DEVICE_CAMERA, placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILPROBLEM, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForExistingAccountByOwnerUpdateFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, recipient));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare(recipient)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.ERROR, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForExistingAccountDeviceNotShared() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        UserEntity recipient = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn((Object)recipient);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient2@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient3@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTSHARED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForNoneExistingAccountByOwnerSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(0), "recipient0@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, null));
        shares.add(new ShareEntity(Integer.valueOf(2), "recipient1@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)claimant.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)claimant.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)claimant.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)claimant.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.UNSHARE_DEVICE_CAMERA, "en", placeholders, null)).andReturn((Object)true);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForNoneExistingAccountByOwnerSendEmailFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(0), "recipient0@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, null));
        shares.add(new ShareEntity(Integer.valueOf(2), "recipient1@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        DeviceDescEntity deviceDesc = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)device.getDeviceDesc()).andReturn((Object)deviceDesc);
        EasyMock.expect((Object)deviceDesc.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)claimant.getFirstname()).andReturn((Object)"John");
        EasyMock.expect((Object)claimant.getLastname()).andReturn((Object)"Smith");
        EasyMock.expect((Object)claimant.getEmail()).andReturn((Object)"donor@test.com");
        EasyMock.expect((Object)claimant.getLanguage()).andReturn((Object)"en");
        EasyMock.expect((Object)device.getName()).andReturn((Object)"Device1");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%USER_NAME%", "John Smith");
        placeholders.put("%USER_EMAIL%", "donor@test.com");
        placeholders.put("%LANDEVICE_NAME%", "Device1");
        placeholders.put("%SHARE_EMAIL%", "recipient@test.com");
        EasyMock.expect((Object)this.emailNotificationService.sendEmail("recipient@test.com", EmailNotificationService.EmailCode.UNSHARE_DEVICE_CAMERA, "en", placeholders, null)).andReturn((Object)false);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILPROBLEM, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForNoneExistingAccountByOwnerUpdateFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(0), "recipient0@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, null));
        shares.add(new ShareEntity(Integer.valueOf(2), "recipient1@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare("recipient@test.com")).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.ERROR, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForNoneExistingAccountByOwnerDeviceNotShared() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)this.userDAO.findUserByEmailAddress("recipient@test.com")).andReturn(null);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(0), "recipient0@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(2), "recipient1@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTSHARED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForExistingAccountByOwnerEmailBlank() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), " ");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILUNDEFINED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void tesUnshareLanDeviceForExistingAccountByOwnerEmailNull() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)claimant);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), null);
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILUNDEFINED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testUnshareLanDeviceForExistingAccountByShareholderSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)new UserEntity());
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(0), "recipient0@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, claimant));
        shares.add(new ShareEntity(Integer.valueOf(2), "recipient1@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare(claimant)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), null);
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.SUCCESS, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testUnshareLanDeviceForExistingAccountByShareholderUpdateFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)new UserEntity());
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(0), "recipient0@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(1), "recipient@test.com", device, claimant));
        shares.add(new ShareEntity(Integer.valueOf(2), "recipient1@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.removeShare(claimant)).andReturn((Object)true);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), null);
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.ERROR, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testUnshareLanDeviceForExistingAccountByShareholderDeviceNotShared() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn((Object)device);
        UserEntity claimant = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)claimant);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)new UserEntity());
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        UserEntity user1 = new UserEntity(Integer.valueOf(1));
        user1.setProduct(new ProductEntity());
        shares.add(new ShareEntity(Integer.valueOf(0), "recipient0@test.com", device, user1));
        shares.add(new ShareEntity(Integer.valueOf(2), "recipient1@test.com", device, null));
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), null);
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTSHARED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testUnshareLanDeviceDeviceNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(Integer.valueOf(1))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(Integer.valueOf(1), "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTFOUND, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testUnshareLanDeviceUndeviceDeviceId() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        UnshareDeviceResponse response = this.lanDeviceService.unshareLanDevice(null, "recipient@test.com");
        Assert.assertEquals((Object)UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICEIDUNDEFINED, (Object)response.status);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceSharedWithSuccessfully() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)3);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(214), Integer.valueOf(3))).andReturn((Object)device);
        ShareEntity share1 = (ShareEntity)PowerMock.createMock(ShareEntity.class);
        ShareEntity share2 = (ShareEntity)PowerMock.createMock(ShareEntity.class);
        LinkedHashSet<ShareEntity> shares = new LinkedHashSet<ShareEntity>();
        shares.add(share1);
        shares.add(share2);
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)device.getShares()).andReturn(shares);
        EasyMock.expect((Object)share1.getUser()).andReturn(null);
        EasyMock.expect((Object)share1.getEmail()).andReturn((Object)"share1@test.com");
        EasyMock.expect((Object)share1.getName()).andReturn((Object)"camera name");
        DeviceShare deviceShare1 = new DeviceShare("share1@test.com", null, "camera name");
        UserEntity share2User = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)share2.getUser()).andReturn((Object)share2User);
        EasyMock.expect((Object)share2User.getEmail()).andReturn((Object)"share2@test.com");
        EasyMock.expect((Object)share2User.getId()).andReturn((Object)3);
        EasyMock.expect((Object)share2.getName()).andReturn((Object)"camera name 2");
        DeviceShare deviceShare2 = new DeviceShare("share2@test.com", Integer.valueOf(3), "camera name 2");
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceSharedWithResponse response = this.lanDeviceService.getDeviceSharedWith(Integer.valueOf(214));
        DeviceSharedWithResponse expectedResponse = new DeviceSharedWithResponse();
        expectedResponse.status = DeviceSharedWithResponse.DeviceSharedWithStatus.SUCCESS;
        expectedResponse.users = new ArrayList();
        expectedResponse.users.add(deviceShare1);
        expectedResponse.users.add(deviceShare2);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceSharedWithFailure() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)3);
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(214), Integer.valueOf(3))).andReturn((Object)device);
        EasyMock.expect((Object)device.getShares()).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceSharedWithResponse response = this.lanDeviceService.getDeviceSharedWith(Integer.valueOf(214));
        DeviceSharedWithResponse expectedResponse = new DeviceSharedWithResponse();
        expectedResponse.status = DeviceSharedWithResponse.DeviceSharedWithStatus.ERROR;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceSharedWithDeviceNotFound() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)3);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevice(Integer.valueOf(214), Integer.valueOf(3))).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceSharedWithResponse response = this.lanDeviceService.getDeviceSharedWith(Integer.valueOf(214));
        DeviceSharedWithResponse expectedResponse = new DeviceSharedWithResponse();
        expectedResponse.status = DeviceSharedWithResponse.DeviceSharedWithStatus.FAILED_DEVICENOTFOUND;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testGetDeviceSharedWithDeviceIdUndevined() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        DeviceSharedWithResponse response = this.lanDeviceService.getDeviceSharedWith(null);
        DeviceSharedWithResponse expectedResponse = new DeviceSharedWithResponse();
        expectedResponse.status = DeviceSharedWithResponse.DeviceSharedWithStatus.FAILED_DEVICEIDUNDEFINED;
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }
}

