/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.response.SetRegisteredResponse;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.RemoveResponse;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.LanDeviceServiceImpl;
import pl.smartapps.restserver.service.impl.LanDeviceServiceInternal;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LanDeviceServiceImpl.class})
public class LanDeviceServiceImplRemoveLanDeviceTests
extends LanDeviceServiceInternal {
    @Test
    public void testRemoveLanDeviceSuccessfully() throws InvalidSessionException {
        Integer deviceId = 1;
        String deviceMac = "testDeviceMac";
        Integer userId = 2;
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        device.setDeleted(true);
        Date now = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        device.setDeletedDate(now);
        HashSet<EventEntity> deviceEvents = new HashSet<EventEntity>();
        EventEntity deviceEvent1 = (EventEntity)PowerMock.createMock(EventEntity.class);
        deviceEvents.add(deviceEvent1);
        EventEntity deviceEvent2 = (EventEntity)PowerMock.createMock(EventEntity.class);
        deviceEvents.add(deviceEvent2);
        EasyMock.expect((Object)device.getEvents()).andReturn(deviceEvents);
        deviceEvent1.setDeleted(true);
        deviceEvent2.setDeleted(true);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)device.getGatewayClient()).andReturn((Object)client);
        Integer clientId = 3;
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        ArrayList<LanDeviceEntity> webDevices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity webDevice1 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        webDevices.add(webDevice1);
        LanDeviceEntity webDevice2 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        webDevices.add(webDevice2);
        LanDeviceEntity webDevice3 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        webDevices.add(webDevice3);
        LanDeviceEntity webDevice4 = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        webDevices.add(webDevice4);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(clientId, false)).andReturn(webDevices);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        EasyMock.expect((Object)webDevice1.getMac()).andReturn((Object)"webDevice1Mac");
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        EasyMock.expect((Object)webDevice2.getMac()).andReturn((Object)deviceMac);
        DeviceDescEntity webDeviceDesc2 = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)webDevice2.getDeviceDesc()).andReturn((Object)webDeviceDesc2);
        EasyMock.expect((Object)webDeviceDesc2.getClassDevice()).andReturn((Object)"camera");
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        EasyMock.expect((Object)webDevice3.getMac()).andReturn((Object)deviceMac);
        DeviceDescEntity webDeviceDesc3 = (DeviceDescEntity)PowerMock.createMock(DeviceDescEntity.class);
        EasyMock.expect((Object)webDevice3.getDeviceDesc()).andReturn((Object)webDeviceDesc3);
        EasyMock.expect((Object)webDeviceDesc3.getClassDevice()).andReturn((Object)"webinterface");
        webDevice3.setDeleted(true);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        webDevice3.setDeletedDate(now);
        HashSet<EventEntity> webEvents = new HashSet<EventEntity>();
        EventEntity webEvent1 = (EventEntity)PowerMock.createMock(EventEntity.class);
        webEvents.add(webEvent1);
        EventEntity webEvent2 = (EventEntity)PowerMock.createMock(EventEntity.class);
        webEvents.add(webEvent2);
        EasyMock.expect((Object)webDevice3.getEvents()).andReturn(webEvents);
        webEvent1.setDeleted(true);
        webEvent2.setDeleted(true);
        EasyMock.expect((Object)webDevice3.getGatewayClient()).andReturn((Object)client);
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        ArrayList webDevices2 = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(clientId, false)).andReturn(webDevices2);
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)16);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserIdAndGatewayClientId(userId, clientId)).andReturn((Object)1L);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(webDevice3)).andReturn((Object)webDevice3);
        String webDevice3Mac = "testWebDevice3Mac";
        EasyMock.expect((Object)webDevice3.getMac()).andReturn((Object)webDevice3Mac);
        String webDevice3IpAddress = "testWebDevice3IpAddress";
        EasyMock.expect((Object)webDevice3.getIpAddress()).andReturn((Object)webDevice3IpAddress);
        this.eventlogService.registerEventlog(LDEventType.DELETE, webDevice3Mac, webDevice3IpAddress, RemoveResponse.RemoveStatus.OK.name(), null);
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)16);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserIdAndGatewayClientId(userId, clientId)).andReturn((Object)0L);
        client.setDeleted(true);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client)).andReturn((Object)client);
        String clientMac = "testClientMac";
        EasyMock.expect((Object)client.getMac()).andReturn((Object)clientMac);
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        EasyMock.expect((Object)this.connector.setRegistered(clientMac, false)).andReturn((Object)response);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        String deviceIpAddress = "testDeviceIpAddress";
        EasyMock.expect((Object)device.getIpAddress()).andReturn((Object)deviceIpAddress);
        this.eventlogService.registerEventlog(LDEventType.DELETE, deviceMac, deviceIpAddress, RemoveResponse.RemoveStatus.OK.name(), null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.OK);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceFailureUpdateDevice() throws InvalidSessionException {
        Integer deviceId = 1;
        String deviceMac = "testDeviceMac";
        Integer userId = 2;
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        device.setDeleted(true);
        Date now = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        device.setDeletedDate(now);
        HashSet<EventEntity> events = new HashSet<EventEntity>();
        EventEntity event1 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event1);
        EventEntity event2 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event2);
        EasyMock.expect((Object)device.getEvents()).andReturn(events);
        event1.setDeleted(true);
        event2.setDeleted(true);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)device.getGatewayClient()).andReturn((Object)client);
        Integer clientId = 3;
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        ArrayList webDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(clientId, false)).andReturn(webDevices);
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)16);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserIdAndGatewayClientId(userId, clientId)).andReturn((Object)0L);
        client.setDeleted(true);
        EasyMock.expect((Object)this.gatewayClientDAO.updateGatewayClientWithTransaction(client)).andReturn((Object)client);
        String clientMac = "testClientMac";
        EasyMock.expect((Object)client.getMac()).andReturn((Object)clientMac);
        SetRegisteredResponse response = (SetRegisteredResponse)PowerMock.createMock(SetRegisteredResponse.class);
        EasyMock.expect((Object)this.connector.setRegistered(clientMac, false)).andReturn((Object)response);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn(null);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        String deviceIpAddress = "testDeviceIpAddress";
        EasyMock.expect((Object)device.getIpAddress()).andReturn((Object)deviceIpAddress);
        this.eventlogService.registerEventlog(LDEventType.DELETE, deviceMac, deviceIpAddress, RemoveResponse.RemoveStatus.ERROR.name(), "Lan device has not been updated in database.");
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.ERROR);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceThereAreAnotherDeviceAssignedToClient() throws InvalidSessionException {
        Integer deviceId = 1;
        String deviceMac = "testDeviceMac";
        Integer userId = 2;
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        device.setDeleted(true);
        Date now = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        device.setDeletedDate(now);
        HashSet<EventEntity> events = new HashSet<EventEntity>();
        EventEntity event1 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event1);
        EventEntity event2 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event2);
        EasyMock.expect((Object)device.getEvents()).andReturn(events);
        event1.setDeleted(true);
        event2.setDeleted(true);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)device.getGatewayClient()).andReturn((Object)client);
        Integer clientId = 3;
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        ArrayList webDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(clientId, false)).andReturn(webDevices);
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)16);
        EasyMock.expect((Object)client.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserIdAndGatewayClientId(userId, clientId)).andReturn((Object)1L);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        String deviceIpAddress = "testDeviceIpAddress";
        EasyMock.expect((Object)device.getIpAddress()).andReturn((Object)deviceIpAddress);
        this.eventlogService.registerEventlog(LDEventType.DELETE, deviceMac, deviceIpAddress, RemoveResponse.RemoveStatus.OK.name(), null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.OK);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceClientTypeNot16() throws InvalidSessionException {
        Integer deviceId = 1;
        String deviceMac = "testDeviceMac";
        Integer userId = 2;
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)userId);
        device.setDeleted(true);
        Date now = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        device.setDeletedDate(now);
        HashSet<EventEntity> events = new HashSet<EventEntity>();
        EventEntity event1 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event1);
        EventEntity event2 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event2);
        EasyMock.expect((Object)device.getEvents()).andReturn(events);
        event1.setDeleted(true);
        event2.setDeleted(true);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)device.getGatewayClient()).andReturn((Object)client);
        Integer clientId = 3;
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        ArrayList webDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(clientId, false)).andReturn(webDevices);
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)0);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        String deviceIpAddress = "testDeviceIpAddress";
        EasyMock.expect((Object)device.getIpAddress()).andReturn((Object)deviceIpAddress);
        this.eventlogService.registerEventlog(LDEventType.DELETE, deviceMac, deviceIpAddress, RemoveResponse.RemoveStatus.OK.name(), null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.OK);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceAsAdmin() throws InvalidSessionException {
        Integer deviceId = 1;
        String deviceMac = "testDeviceMac";
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)true);
        device.setDeleted(true);
        Date now = new Date();
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)now);
        device.setDeletedDate(now);
        HashSet<EventEntity> events = new HashSet<EventEntity>();
        EventEntity event1 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event1);
        EventEntity event2 = (EventEntity)PowerMock.createMock(EventEntity.class);
        events.add(event2);
        EasyMock.expect((Object)device.getEvents()).andReturn(events);
        event1.setDeleted(true);
        event2.setDeleted(true);
        GatewayClientEntity client = (GatewayClientEntity)PowerMock.createMock(GatewayClientEntity.class);
        EasyMock.expect((Object)device.getGatewayClient()).andReturn((Object)client);
        Integer clientId = 3;
        EasyMock.expect((Object)client.getGatewayClientId()).andReturn((Object)clientId);
        ArrayList webDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDevicesByGatewacClientId(clientId, false)).andReturn(webDevices);
        EasyMock.expect((Object)client.getDeviceType()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDevice(device)).andReturn((Object)device);
        EasyMock.expect((Object)device.getMac()).andReturn((Object)deviceMac);
        String deviceIpAddress = "testDeviceIpAddress";
        EasyMock.expect((Object)device.getIpAddress()).andReturn((Object)deviceIpAddress);
        this.eventlogService.registerEventlog(LDEventType.DELETE, deviceMac, deviceIpAddress, RemoveResponse.RemoveStatus.OK.name(), null);
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.OK);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceUserHasNoRightToRemove() throws InvalidSessionException {
        Integer deviceId = 1;
        Integer userId = 2;
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)).andReturn((Object)false);
        UserEntity user = (UserEntity)PowerMock.createMock(UserEntity.class);
        EasyMock.expect((Object)device.getUser()).andReturn((Object)user);
        EasyMock.expect((Object)user.getId()).andReturn((Object)userId);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)123).times(2);
        this.eventlogService.registerEventlog(LDEventType.DELETE, null, null, RemoveResponse.RemoveStatus.FAILED.name(), "Device with lanDeviceId=1 does not belong to user with userId=123.");
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceAlreadyDeleted() throws InvalidSessionException {
        Integer deviceId = 1;
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = (LanDeviceEntity)PowerMock.createMock(LanDeviceEntity.class);
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn((Object)device);
        EasyMock.expect((Object)device.getDeleted()).andReturn((Object)true);
        this.eventlogService.registerEventlog(LDEventType.DELETE, null, null, RemoveResponse.RemoveStatus.FAILED.name(), "Not found device with lanDeviceId=1 or device is deleted.");
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceNotFound() throws InvalidSessionException {
        Integer deviceId = 1;
        this.authUtils.ensureLoggedIn();
        EasyMock.expect((Object)this.lanDeviceDAO.findLanDeviceById(deviceId)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.DELETE, null, null, RemoveResponse.RemoveStatus.FAILED.name(), "Not found device with lanDeviceId=1 or device is deleted.");
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }

    @Test
    public void testRemoveLanDeviceNoDeviceId() throws InvalidSessionException {
        Integer deviceId = null;
        this.authUtils.ensureLoggedIn();
        PowerMock.replayAll((Object[])new Object[0]);
        RemoveResponse actual = this.lanDeviceService.removeLanDevice(deviceId);
        RemoveResponse expected = new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        Assert.assertEquals((Object)expected, (Object)actual);
        PowerMock.verifyAll();
    }
}

