/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.model.DiscoveredLanDevice;
import com.vestiacom.gdserver.rest.response.GatewayDevice;
import com.vestiacom.gdserver.rest.response.HttpProxyVerificationResponse;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import pl.smartapps.containerserver.ContainerserverServiceFactory;
import pl.smartapps.containerserver.GatewayDeviceConnectionService;
import pl.smartapps.containerserver.VivotekCameraDiscoveryService;
import pl.smartapps.containerserver.connector.Connector;
import pl.smartapps.containerserver.landevice.CameraDiscoveryService;
import pl.smartapps.containerserver.landevice.DeviceDriverFactory;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.ActivateCameraResponse;
import pl.smartapps.hm.WebViewer.shared.model.CheckConfigurationStatus;
import pl.smartapps.hm.WebViewer.shared.model.ConfigureFoundLanDevices;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.DeviceShare;
import pl.smartapps.hm.WebViewer.shared.model.DeviceSharedWithResponse;
import pl.smartapps.hm.WebViewer.shared.model.FoundLanDevices;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.LanDeviceStatus;
import pl.smartapps.hm.WebViewer.shared.model.ReconfigurationDeviceStatus;
import pl.smartapps.hm.WebViewer.shared.model.Rssi;
import pl.smartapps.hm.WebViewer.shared.model.ShareDeviceResponse;
import pl.smartapps.hm.WebViewer.shared.model.UnshareDeviceResponse;
import pl.smartapps.hm.WebViewer.shared.model.UpdateDeviceProductResponse;
import pl.smartapps.hm.WebViewer.shared.model.UpdateSettingStatus;
import pl.smartapps.hm.WebViewer.shared.model.UpgradeFirmwareStatus;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.VideoQualityLevel;
import pl.smartapps.hm.WebViewer.shared.model.WlanAccessPoints;
import pl.smartapps.restserver.db.dao.ApplicationDAO;
import pl.smartapps.restserver.db.dao.DeviceDescDAO;
import pl.smartapps.restserver.db.dao.EventDAO;
import pl.smartapps.restserver.db.dao.GatewayClientDAO;
import pl.smartapps.restserver.db.dao.LanDeviceDAO;
import pl.smartapps.restserver.db.dao.UserDAO;
import pl.smartapps.restserver.db.main.ApplicationEntity;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.EventEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ShareEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.AddDeviceRequest;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.rest.response.Account;
import pl.smartapps.restserver.rest.response.CancelPairingResponse;
import pl.smartapps.restserver.rest.response.CheckDeviceTrialProductResponse;
import pl.smartapps.restserver.rest.response.DeviceVerificationResponse;
import pl.smartapps.restserver.rest.response.ErrorReportResponse;
import pl.smartapps.restserver.rest.response.GetLanDevicesResponse;
import pl.smartapps.restserver.rest.response.RemoveResponse;
import pl.smartapps.restserver.rest.response.SaveResponse;
import pl.smartapps.restserver.rest.response.VerifyGcResponse;
import pl.smartapps.restserver.rest.security.PasswordGenerator;
import pl.smartapps.restserver.service.AddedDevice;
import pl.smartapps.restserver.service.EmailNotificationService;
import pl.smartapps.restserver.service.EventlogService;
import pl.smartapps.restserver.service.GatewayClientService;
import pl.smartapps.restserver.service.LanDeviceService;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ProductManagementService;
import pl.smartapps.restserver.service.SystemSupport;
import pl.smartapps.restserver.service.UserService;
import pl.smartapps.restserver.service.VideoStreamService;
import pl.smartapps.restserver.service.ext.InvalidSessionException;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;
import pl.smartapps.restserver.service.impl.AccountNameComparator;
import pl.smartapps.restserver.service.impl.ActivationCodeHandler;
import pl.smartapps.restserver.service.impl.AddDeviceException;
import pl.smartapps.restserver.service.impl.AuthenticationUtils;
import pl.smartapps.restserver.service.impl.DeviceNameGenerator;
import pl.smartapps.restserver.service.impl.LanDeviceServiceImpl;
import pl.smartapps.restserver.util.Utils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class LanDeviceServiceImpl
implements LanDeviceService {
    private static final String CORRECT_DEVICES = "correct_devices";
    private static final String MANUAL_DEVICES = "manual_devices";
    private static final String FOUND_DEVICES = "found_devices";
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Logger log = Logger.getLogger(LanDeviceServiceImpl.class);
    private DeviceDriverFactory deviceDriverFactory;
    private LanDeviceDAO lanDeviceDAO;
    private GatewayClientDAO gatewayClientDAO;
    private ContainerserverServiceFactory containerserverServiceFactory;
    private DeviceDescDAO deviceDescDAO;
    private PasswordGenerator passwordGenerator;
    private AuthenticationUtils authUtils;
    private GatewayDeviceConnectionService gatewayDeviceConnection;
    private EventlogService eventlogService;
    private GatewayClientService gatewayClientService;
    private ActivationCodeHandler activationCodeHandler;
    private ProductManagementService productManagementService;
    private SystemSupport systemSupport;
    private EmailNotificationService emailNotificationService;
    private VideoStreamService videoStreamService;
    private EventDAO eventDAO;
    private boolean updateVersionOnConnect;
    private ParameterService parameterService;
    private UserDAO userDAO;
    private String serverUrl;
    private Connector connector;
    private DeviceNameGenerator deviceNameGenerator;
    private UserService userService;
    private ApplicationDAO applicationDAO;
    private static final String LANDEVICE_VALIDITY_END_ACTION_LOCK = "LOCK";
    private static final String LANDEVICE_VALIDITY_END_ACTION_DOWNGRADE = "DOWNGRADE";
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$rest$response$VerifyGcResponse$VerifyGcStatus;
    private static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$containerserver$landevice$GenericLanDevice$ConfigurationStatus;

    @Autowired
    @Required
    public void setAuthUtils(AuthenticationUtils authUtils) {
        this.authUtils = authUtils;
    }

    @Autowired
    @Required
    public void setLanDeviceDAO(LanDeviceDAO lanDeviceDAO) {
        this.lanDeviceDAO = lanDeviceDAO;
    }

    @Autowired
    @Required
    public void setGatewayClientDAO(GatewayClientDAO gatewayClientDAO) {
        this.gatewayClientDAO = gatewayClientDAO;
    }

    @Autowired
    @Required
    public void setDeviceDescDAO(DeviceDescDAO deviceDescDAO) {
        this.deviceDescDAO = deviceDescDAO;
    }

    @Autowired
    @Required
    public void setPasswordGenerator(PasswordGenerator passwordGenerator) {
        this.passwordGenerator = passwordGenerator;
    }

    @Autowired
    @Required
    public void setDeviceDriverFactory(DeviceDriverFactory deviceDriverFactory) {
        this.deviceDriverFactory = deviceDriverFactory;
    }

    @Autowired
    @Required
    public void setContainerserverServiceFactory(ContainerserverServiceFactory containerserverServiceFactory) {
        this.containerserverServiceFactory = containerserverServiceFactory;
    }

    @Autowired
    @Required
    public void setGatewayDeviceConnection(GatewayDeviceConnectionService gatewayDeviceConnection) {
        this.gatewayDeviceConnection = gatewayDeviceConnection;
    }

    @Value(value="${lanDevice.updateVersionOnConnect:true}")
    public void setUpdateVersionOnConnect(boolean updateVersionOnConnect) {
        this.updateVersionOnConnect = updateVersionOnConnect;
    }

    @Autowired
    @Required
    public void setEventlogService(EventlogService eventlogService) {
        this.eventlogService = eventlogService;
    }

    @Autowired
    @Required
    public void setActivationCodeHandler(ActivationCodeHandler activationCodeHandler) {
        this.activationCodeHandler = activationCodeHandler;
    }

    @Autowired
    @Required
    public void setGatewayClientService(GatewayClientService gatewayClientService) {
        this.gatewayClientService = gatewayClientService;
    }

    @Autowired
    @Required
    public void setProductManagementService(ProductManagementService productManagementService) {
        this.productManagementService = productManagementService;
    }

    @Autowired
    @Required
    public void setSystemSupport(SystemSupport systemSupport) {
        this.systemSupport = systemSupport;
    }

    @Autowired
    @Required
    public void setEmailNotificationService(EmailNotificationService emailNotificationService) {
        this.emailNotificationService = emailNotificationService;
    }

    @Autowired
    @Required
    public void setVideoStreamService(VideoStreamService videoStreamService) {
        this.videoStreamService = videoStreamService;
    }

    @Autowired
    @Required
    public void setEventDAO(EventDAO eventDAO) {
        this.eventDAO = eventDAO;
    }

    @Autowired
    @Required
    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    @Autowired
    @Required
    public void setUserDAO(UserDAO userDAO) {
        this.userDAO = userDAO;
    }

    @Value(value="${lanDevice.serverUrl}")
    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    @Autowired
    @Required
    public void setConnector(Connector connector) {
        this.connector = connector;
    }

    @Autowired
    @Required
    public void setDeviceNameGenerator(DeviceNameGenerator deviceNameGenerator) {
        this.deviceNameGenerator = deviceNameGenerator;
    }

    @Autowired
    @Required
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Autowired
    @Required
    public void setApplicationDAO(ApplicationDAO applicationDAO) {
        this.applicationDAO = applicationDAO;
    }

    @PostConstruct
    public void init() {
        this.videoStreamService.setLanDeviceService((LanDeviceService)this);
    }

    @Transactional(readOnly=true)
    public GetLanDevicesResponse getLanDevices(String remoteAddress, String deviceClass) throws InvalidSessionException {
        log.trace((Object)"start getLanDevices()");
        this.authUtils.ensureLoggedIn();
        List devices = this.lanDeviceDAO.findLanDevicesByUserId(this.authUtils.getCurrentUserId(), false, deviceClass);
        List sharedDevices = this.lanDeviceDAO.findLanDevicesSharedWithUser(this.authUtils.getCurrentUserId(), deviceClass);
        if (devices == null || sharedDevices == null) {
            return new GetLanDevicesResponse(GetLanDevicesResponse.GetLanDevicesStatus.ERROR);
        }
        GetLanDevicesResponse response = new GetLanDevicesResponse();
        response.status = GetLanDevicesResponse.GetLanDevicesStatus.SUCCESS;
        response.devices = LanDeviceEntity.toDTOs((GatewayDeviceConnectionService)this.gatewayDeviceConnection, (DeviceDriverFactory)this.deviceDriverFactory, (List)devices, (boolean)true, (boolean)true, (boolean)true, (VideoStreamService)this.videoStreamService, (ProductManagementService)this.productManagementService, (Integer)this.authUtils.getCurrentUserId());
        response.devices.addAll(LanDeviceEntity.toDTOs((GatewayDeviceConnectionService)this.gatewayDeviceConnection, (DeviceDriverFactory)this.deviceDriverFactory, (List)sharedDevices, (boolean)true, (boolean)true, (boolean)true, (VideoStreamService)this.videoStreamService, (ProductManagementService)this.productManagementService, (Integer)this.authUtils.getCurrentUserId()));
        for (LanDevice lanDevice : response.devices) {
            this.detectAndSetLocalIpAddress(remoteAddress, lanDevice);
        }
        String maxDeviceCount = this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT);
        response.maxDeviceCount = maxDeviceCount == null ? null : Integer.valueOf(Integer.parseInt(maxDeviceCount));
        response.iceParameters = this.videoStreamService.getICEParameters();
        return response;
    }

    private void detectAndSetLocalIpAddress(String remote_addr, LanDevice lan_device) {
        GatewayClient gc = lan_device.getGatewayClient();
        GatewayDevice gd = this.gatewayDeviceConnection.findById(gc.getMac());
        if (remote_addr != null && gd != null && remote_addr.equals(gd.getPublicIpAddress())) {
            gc.setPublicIpAddress(gd.getLocalIpAddress());
            gc.setLocalIpAddress(gd.getLocalIpAddress());
            log.debug((Object)"plugin and gd have same ip addresses, sending localIp");
        } else {
            gc.setLocalIpAddress(null);
            gc.setLocalIpAddressDns(null);
            log.debug((Object)"plugin and gd have different ip addresses, sending publicIp");
            if (remote_addr == null) {
                log.debug((Object)"remote_addr == null");
            }
            if (gd == null) {
                log.debug((Object)("gd == null, mac = " + gc.getMac()));
            }
            if (gd != null && remote_addr != null) {
                log.debug((Object)("remote_addr=[" + remote_addr + "] != publicIp=[" + gd.getPublicIpAddress() + "]"));
            }
        }
    }

    @Transactional(readOnly=true)
    public List<LanDevice> getLanDevicesForGc(Integer gcId) throws InvalidSessionException {
        log.trace((Object)("start getLanDevicesForGc(" + gcId + ")"));
        this.authUtils.ensureLoggedIn();
        List devices = this.lanDeviceDAO.findLanDevicesByGatewayClientIdAndUserId(gcId, this.authUtils.getCurrentUserId());
        return LanDeviceEntity.toDTOs((GatewayDeviceConnectionService)this.gatewayDeviceConnection, (DeviceDriverFactory)this.deviceDriverFactory, (List)devices, (boolean)true, (boolean)true, (boolean)false, (VideoStreamService)this.videoStreamService, (ProductManagementService)this.productManagementService, (Integer)this.authUtils.getCurrentUserId());
    }

    public List<LanDevice> findLanDevices(Integer gcId) throws InvalidSessionException {
        log.debug((Object)("start findLanDevices(" + gcId + ")"));
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientByIdAndUserId(gcId, this.authUtils.getCurrentUserId(), false);
        return this.findLanDevices(gatewayClient);
    }

    private List<LanDevice> findLanDevices(GatewayClientEntity gatewayClient) throws InvalidSessionException {
        log.trace((Object)("start findLanDevices(gatewayClient=" + gatewayClient + ")"));
        this.authUtils.ensureLoggedIn();
        if (gatewayClient == null) {
            return Collections.emptyList();
        }
        log.debug((Object)("Finding lan devices for for gateway client with id " + gatewayClient.getGatewayClientId() + " and mac address " + gatewayClient.getMac() + "."));
        VivotekCameraDiscoveryService vivotekCameraDiscovery = this.containerserverServiceFactory.getVivotekCameraDiscoveryService();
        List discoveredDevices = vivotekCameraDiscovery.discover(gatewayClient.getMac());
        log.debug((Object)("Total number of discovered lan devices for gateway client with id = " + gatewayClient.getGatewayClientId() + ": " + discoveredDevices.size() + "."));
        if (discoveredDevices.isEmpty()) {
            return Collections.emptyList();
        }
        return this.extractNewDiscoveredLanDevice(discoveredDevices, gatewayClient);
    }

    public FoundLanDevices findLanDevices() throws InvalidSessionException {
        log.trace((Object)"start findLanDevices()");
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("found_devices");
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        List gatewayClients = this.gatewayClientDAO.findGatewayClientsByUserId(this.authUtils.getCurrentUserId());
        if (gatewayClients == null || gatewayClients.isEmpty()) {
            log.debug((Object)("No gateway clients found for user with id = " + this.authUtils.getCurrentUserId() + "."));
            return new FoundLanDevices();
        }
        log.debug((Object)("Searching lan devices for " + gatewayClients.size() + " gateway clients."));
        ArrayList discoveredDevices = new ArrayList();
        for (GatewayClientEntity gatewayClient : gatewayClients) {
            discoveredDevices.addAll(this.findLanDevices(gatewayClient));
        }
        log.debug((Object)("Total number of discovered lan devices: " + discoveredDevices.size() + "."));
        if (discoveredDevices.isEmpty()) {
            return new FoundLanDevices();
        }
        HashMap<LanDevice, AccessVerificationStatus> discoveredDevicesState = new HashMap<LanDevice, AccessVerificationStatus>();
        FoundLanDevices foundLanDevices = new FoundLanDevices();
        foundLanDevices.setTotal(discoveredDevices.size());
        for (LanDevice device : discoveredDevices) {
            if (this.isAssignedToAnotherAccount(device)) {
                foundLanDevices.setAnotherAccountAssigned(foundLanDevices.getAnotherAccountAssigned() + 1);
                continue;
            }
            AccessVerificationStatus status = this.verifyDiscoveredLanDevice(device);
            discoveredDevicesState.put(device, status);
            if (status == AccessVerificationStatus.OK) {
                foundLanDevices.setAvailable(foundLanDevices.getAvailable() + 1);
                continue;
            }
            if (status == AccessVerificationStatus.NOT_SUPPORTED) {
                foundLanDevices.setUnsupported(foundLanDevices.getUnsupported() + 1);
                continue;
            }
            foundLanDevices.setUnavailable(foundLanDevices.getUnavailable() + 1);
        }
        this.authUtils.storeData("found_devices", discoveredDevicesState);
        return foundLanDevices;
    }

    private boolean isAssignedToAnotherAccount(LanDevice device) {
        List foundDevice = this.lanDeviceDAO.findNotDeletedLanDevicesByMac(device.getMac());
        return !foundDevice.isEmpty();
    }

    private List<LanDevice> extractNewDiscoveredLanDevice(List<DiscoveredLanDevice> discoveredDevices, GatewayClientEntity gatewayClient) {
        if (discoveredDevices.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<String, LanDevice> newDevices = new LinkedHashMap<String, LanDevice>();
        for (DiscoveredLanDevice discoveredDevice : discoveredDevices) {
            LanDevice device = new LanDevice();
            device.setMac(discoveredDevice.getMac());
            device.setIpAddress(discoveredDevice.getIpAddress());
            device.setName(discoveredDevice.getName());
            device.setDeviceDesc(this.deviceDescDAO.findDeviceDescByDriverclass(discoveredDevice.getDeviceDriver()).toDTO());
            device.setGatewayClient(gatewayClient.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, false, false));
            newDevices.put(discoveredDevice.getMac(), device);
        }
        List registeredDevices = this.lanDeviceDAO.findLanDevicesByGatewayClientId(gatewayClient.getGatewayClientId());
        log.debug((Object)("Number of already registred lan devices for gateway client with id " + gatewayClient.getGatewayClientId() + ": " + registeredDevices.size()));
        for (LanDeviceEntity registeredDevice : registeredDevices) {
            newDevices.remove(registeredDevice.getMac());
        }
        log.debug((Object)("Number of new discovered lan devices for gateway client with id = " + gatewayClient.getGatewayClientId() + ": " + newDevices.size() + "."));
        return new ArrayList<LanDevice>(newDevices.values());
    }

    private AccessVerificationStatus verifyDiscoveredLanDevice(LanDevice device) {
        log.trace((Object)("start verifyDiscoveredLanDevice(device=" + device + ")"));
        List registredDevices = this.lanDeviceDAO.findAllLanDevicesByMac(device.getMac());
        if (!registredDevices.isEmpty()) {
            log.debug((Object)("found previous LD with MAC " + device.getMac() + ", copying credentials"));
            device.setUser(((LanDeviceEntity)registredDevices.get(0)).getUsername());
            device.setPass(((LanDeviceEntity)registredDevices.get(0)).getPass());
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device.getDeviceDesc().getDriverclass(), false);
        return driver.verify(device);
    }

    private LanDeviceEntity retrieveLatestLanDevice(String macAddress) {
        List devices = this.lanDeviceDAO.findAllLanDevicesByMac(macAddress);
        return devices.isEmpty() ? null : (LanDeviceEntity)devices.get(0);
    }

    public DeviceVerificationResponse verifyDiscoveredLanDevice(Integer gcId, String mac, String address, Integer deviceDescId) throws InvalidSessionException {
        log.trace((Object)("start verifyDescoveredLanDevice(gcId=" + gcId + ", mac=" + mac + ", address=" + address + ", deviceDescId=" + deviceDescId + ")"));
        this.authUtils.ensureLoggedIn();
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientByIdAndUserId(gcId, this.authUtils.getCurrentUserId(), false);
        if (gatewayClient == null) {
            DeviceVerificationResponse resp = new DeviceVerificationResponse(DeviceVerificationResponse.DeviceVerificationStatus.FAILED);
            return resp;
        }
        LanDevice device = new LanDevice();
        List registredDevices = this.lanDeviceDAO.findAllLanDevicesByMac(mac);
        if (!registredDevices.isEmpty()) {
            device.setUser(((LanDeviceEntity)registredDevices.get(0)).getUsername());
            device.setPass(((LanDeviceEntity)registredDevices.get(0)).getPass());
        }
        device.setMac(mac);
        device.setIpAddress(address);
        DeviceDescEntity deviceDesc = this.deviceDescDAO.findDeviceDescById(deviceDescId);
        device.setDeviceDesc(deviceDesc.toDTO());
        device.setGatewayClient(gatewayClient.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, false, false));
        log.debug((Object)("veryfied lanDevice: " + device.toString()));
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device.getDeviceDesc().getDriverclass(), false);
        AccessVerificationStatus status = driver.verify(device);
        return new DeviceVerificationResponse(this.getDeviceVerificationStatus(status), device);
    }

    /*
     * Exception decompiling
     */
    private DeviceVerificationResponse.DeviceVerificationStatus getDeviceVerificationStatus(AccessVerificationStatus status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional
    public SaveResponse addLanDevice(LanDevice dev) throws InvalidSessionException {
        log.trace((Object)("start addLanDevice(" + dev + ")"));
        this.authUtils.ensureLoggedIn();
        return ConfigurationDeviceResponse.access$0((ConfigurationDeviceResponse)this.configureLanDevice(dev, false)) == GenericLanDevice.ConfigurationStatus.OK ? new SaveResponse(SaveResponse.SaveStatus.SAVED) : new SaveResponse(SaveResponse.SaveStatus.NOTSAVED);
    }

    @Transactional
    public RemoveResponse removeLanDevice(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start removeLanDevice(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        if (lanDeviceId == null) {
            log.debug((Object)"Cannot remove device for no deviceId");
            return new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null || device.getDeleted()) {
            String message = "Not found device with lanDeviceId=" + lanDeviceId + " or device is deleted.";
            log.debug((Object)message);
            this.eventlogService.registerEventlog(LDEventType.DELETE, null, null, RemoveResponse.RemoveStatus.FAILED.name(), message);
            return new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        }
        if (!this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN) && !this.isOwner(device)) {
            String message = "Device with lanDeviceId=" + lanDeviceId + " does not belong to user with userId=" + this.authUtils.getCurrentUserId() + ".";
            log.debug((Object)message);
            this.eventlogService.registerEventlog(LDEventType.DELETE, null, null, RemoveResponse.RemoveStatus.FAILED.name(), message);
            return new RemoveResponse(RemoveResponse.RemoveStatus.FAILED);
        }
        return this.removeLanDevice(device);
    }

    private boolean isOwner(LanDeviceEntity device) {
        return device.getUser().getId().equals(this.authUtils.getCurrentUserId());
    }

    private RemoveResponse removeLanDevice(LanDeviceEntity lanDevice) {
        LanDeviceEntity updatedLanDevice;
        lanDevice.setDeleted(true);
        lanDevice.setDeletedDate(this.systemSupport.getCurrentDate());
        for (EventEntity eventEntity : lanDevice.getEvents()) {
            eventEntity.setDeleted(true);
        }
        GatewayClientEntity gatewayClient = lanDevice.getGatewayClient();
        List webInterfaceLanDevices = this.lanDeviceDAO.findLanDevicesByGatewacClientId(gatewayClient.getGatewayClientId(), false);
        if (webInterfaceLanDevices != null) {
            for (LanDeviceEntity webInterfaceLanDevice : webInterfaceLanDevices) {
                if (!lanDevice.getMac().equalsIgnoreCase(webInterfaceLanDevice.getMac()) || !webInterfaceLanDevice.getDeviceDesc().getClassDevice().equals("webinterface")) continue;
                this.removeLanDevice(webInterfaceLanDevice);
                break;
            }
        }
        if (gatewayClient.getDeviceType().equals(16)) {
            this.removeGatewayClientIfNeeded(gatewayClient);
        }
        if ((updatedLanDevice = this.lanDeviceDAO.updateLanDevice(lanDevice)) != null) {
            this.eventlogService.registerEventlog(LDEventType.DELETE, lanDevice.getMac(), lanDevice.getIpAddress(), RemoveResponse.RemoveStatus.OK.name(), null);
            return new RemoveResponse(RemoveResponse.RemoveStatus.OK);
        }
        this.eventlogService.registerEventlog(LDEventType.DELETE, lanDevice.getMac(), lanDevice.getIpAddress(), RemoveResponse.RemoveStatus.ERROR.name(), "Lan device has not been updated in database.");
        return new RemoveResponse(RemoveResponse.RemoveStatus.ERROR);
    }

    @Transactional
    public ConfigureFoundLanDevices configureFoundLanDevices() throws InvalidSessionException {
        log.trace((Object)"start configureFoundLanDevices()");
        this.authUtils.ensureLoggedIn();
        Map foundDevices = (Map)this.authUtils.getStoredData("found_devices");
        if (foundDevices == null) {
            return new ConfigureFoundLanDevices();
        }
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        ArrayList<LanDeviceEntity> manualDevices = new ArrayList<LanDeviceEntity>();
        ConfigureFoundLanDevices devicesConfigResult = new ConfigureFoundLanDevices();
        for (Map.Entry entry : foundDevices.entrySet()) {
            if (entry.getValue() != AccessVerificationStatus.OK) continue;
            ConfigurationDeviceResponse configResp = this.configureLanDevice((LanDevice)entry.getKey(), false);
            if (ConfigurationDeviceResponse.access$0((ConfigurationDeviceResponse)configResp) == GenericLanDevice.ConfigurationStatus.OK) {
                correctDevices.add(ConfigurationDeviceResponse.access$1((ConfigurationDeviceResponse)configResp));
                devicesConfigResult.setOk(devicesConfigResult.getOk() + 1);
                continue;
            }
            if (ConfigurationDeviceResponse.access$0((ConfigurationDeviceResponse)configResp) == GenericLanDevice.ConfigurationStatus.FAILED || ConfigurationDeviceResponse.access$0((ConfigurationDeviceResponse)configResp) == GenericLanDevice.ConfigurationStatus.ERROR) {
                devicesConfigResult.setFailed(devicesConfigResult.getFailed() + 1);
                continue;
            }
            if (ConfigurationDeviceResponse.access$0((ConfigurationDeviceResponse)configResp) != GenericLanDevice.ConfigurationStatus.MANUAL) continue;
            devicesConfigResult.setManual(devicesConfigResult.getManual() + 1);
            manualDevices.add(ConfigurationDeviceResponse.access$1((ConfigurationDeviceResponse)configResp));
        }
        this.authUtils.storeData("manual_devices", manualDevices);
        this.authUtils.storeData("correct_devices", correctDevices);
        this.authUtils.removeData("found_devices");
        return devicesConfigResult;
    }

    private ConfigurationDeviceResponse configureLanDevice(LanDevice dev, boolean trial) throws InvalidSessionException {
        log.trace((Object)("start configureLanDevice(device=" + dev + ")"));
        Integer gcId = dev.getGatewayClient().getGatewayClientId();
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientByIdAndUserId(gcId, this.authUtils.getCurrentUserId(), false);
        if (gatewayClient == null) {
            log.debug((Object)"Not found gateway client. Return ERROR status.");
            return new ConfigurationDeviceResponse(this, GenericLanDevice.ConfigurationStatus.ERROR);
        }
        return this.configureLanDevice(dev, gatewayClient, this.getDriver(gatewayClient.getMac()), trial);
    }

    private ConfigurationDeviceResponse configureLanDevice(LanDevice dev, GatewayClientEntity gatewayClient, GenericLanDevice driver, boolean trial) throws InvalidSessionException {
        boolean trialUsed;
        log.trace((Object)("start configureLanDevice(device=" + dev + ", gatewayClient=" + gatewayClient + ", trial=" + trial + ")"));
        Date currentDate = this.systemSupport.getCurrentDate();
        LanDeviceEntity foundDevice = this.lanDeviceDAO.findLatestLanDeviceByMac(dev.getMac());
        log.debug((Object)("Found latest device with mac=" + dev.getMac() + ": " + foundDevice));
        LanDeviceEntity device = new LanDeviceEntity(dev, false, false, false);
        boolean bl = foundDevice != null ? foundDevice.getTrialProductDate() != null : (trialUsed = false);
        if (this.isReconfiguration(dev.getReconfiguration()) && foundDevice != null && !foundDevice.getDeleted() && !foundDevice.getUser().getId().equals(this.authUtils.getCurrentUserId())) {
            foundDevice = this.lanDeviceDAO.findLatestLanDeviceByMacAndUserId(dev.getMac(), this.authUtils.getCurrentUserId());
            log.debug((Object)("Found latest device with mac=" + dev.getMac() + " and userId=" + this.authUtils.getCurrentUserId() + ": " + foundDevice));
            if (foundDevice == null) {
                log.warn((Object)("Detected device reconfiguration but not found device to reconfigure with mac=" + dev.getMac() + " and usrId=" + this.authUtils.getCurrentUserId() + "."));
                return new ConfigurationDeviceResponse(this, GenericLanDevice.ConfigurationStatus.ERROR);
            }
            device = foundDevice;
        }
        dev.setDeleted(Boolean.valueOf(false));
        String currentAdminPassword = null;
        device.setParam("viewer_user", device.getMac().replace(":", ""));
        device.setParam("viewer_pass", this.passwordGenerator.generate(10));
        device.setParam("alarm_user", this.generateAlarmUserName());
        device.setParam("alarm_pass", this.passwordGenerator.generate(10));
        boolean productChanged = false;
        if (foundDevice == null) {
            productChanged = true;
            device.setUsername(dev.getUser());
            currentAdminPassword = dev.getPass();
            device.setProductDate(currentDate);
            ProductEntity product = null;
            if (trial) {
                device.setTrialProductDate(currentDate);
                product = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), DeviceProduct.DeviceProductType.TRIAL);
                Date trialValidTo = this.constructTrialValidTo(product.getProductId());
                if (trialValidTo == null) {
                    log.warn((Object)"Calculated trial valid to date is null.");
                    return new ConfigurationDeviceResponse(this, GenericLanDevice.ConfigurationStatus.ERROR);
                }
                device.setValidTo(trialValidTo);
                device.setParam("video_quality", "GOOD", "GOOD");
            } else {
                product = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), DeviceProduct.DeviceProductType.BASIC);
                VideoQualityLevel videoQuality = this.getTrialVideoQuality(product);
                device.setParam("video_quality", videoQuality.name(), videoQuality.name());
                GregorianCalendar cal = new GregorianCalendar();
                cal.setTime(device.getProductDate());
                cal.add(5, -1);
                Date newValidTo = cal.getTime();
                device.setValidTo(newValidTo);
            }
            device.setProduct(product);
            if (this.isDisabledRootPassGeneration()) {
                log.debug((Object)"Root password generation disabled. Retyping password.");
                device.setPass(dev.getPass());
            } else {
                log.debug((Object)"Root password generation enabled. Generating new password.");
                device.setPass(this.passwordGenerator.generate(10));
            }
        } else {
            currentAdminPassword = foundDevice.getPass();
            device.setUsername(foundDevice.getUsername());
            device.setPass(foundDevice.getPass());
            if (trial && foundDevice.getTrialProductDate() == null) {
                productChanged = true;
                ProductEntity trialProduct = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), DeviceProduct.DeviceProductType.TRIAL);
                device.setProduct(trialProduct);
                device.setProductDate(currentDate);
                device.setTrialProductDate(currentDate);
                device.setValidTo(this.constructTrialValidTo(trialProduct.getProductId()));
            } else {
                productChanged = !this.isReconfiguration(dev.getReconfiguration());
                device.setValidTo(foundDevice.getValidTo());
                ProductEntity basicProduct = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), DeviceProduct.DeviceProductType.BASIC);
                Date exceededValidTo = Utils.adjustDate((Date)this.systemSupport.getCurrentDate(), (int)5, (int)-1, (boolean)true);
                boolean invalid = !foundDevice.getValidTo().after(exceededValidTo) && !foundDevice.getProduct().getProductId().equals(basicProduct.getProductId());
                device.setProduct(invalid ? basicProduct : foundDevice.getProduct());
                device.setProductDate(invalid ? this.systemSupport.getCurrentDate() : foundDevice.getProductDate());
                device.setTrialProductDate(foundDevice.getTrialProductDate());
            }
            if (this.isReconfiguration(dev.getReconfiguration())) {
                device.setLanDeviceId(foundDevice.getLanDeviceId());
                LinkedHashSet shares = new LinkedHashSet();
                shares.addAll(foundDevice.getShares());
                device.setShares(shares);
            } else {
                device.setLocation(null);
                device.setDescription(null);
            }
            device.setDeleted(false);
            device.setDeletedDate(null);
            device.setModifiedDate(null);
            device.setIpAddress(dev.getIpAddress());
            device.setAddedDate(null);
        }
        device.setReconfiguration(dev.getReconfiguration());
        device.setGatewayClient(gatewayClient);
        if (driver == null) {
            log.error((Object)("No driver found for device " + dev + ". Return FAILED status!"));
            this.eventlogService.registerEventlog(LDEventType.CONFIGURE, device.getMac(), dev.getIpAddress(), GenericLanDevice.ConfigurationStatus.FAILED.name(), "Not found driver.");
            return new ConfigurationDeviceResponse(this, GenericLanDevice.ConfigurationStatus.FAILED, device);
        }
        GenericLanDevice.ConfigurationStatus configurationStatus = driver.init(device, currentAdminPassword);
        log.debug((Object)("Camera with mac address " + device.getMac() + " and IP address " + device.getIpAddress() + " configuration status: " + configurationStatus));
        if (configurationStatus == GenericLanDevice.ConfigurationStatus.MANUAL && (foundDevice == null || !trialUsed && trial)) {
            this.resetProductToBasic(device);
        }
        if (configurationStatus == GenericLanDevice.ConfigurationStatus.OK) {
            log.debug((Object)("Camera with mac address " + device.getMac() + " and IP address " + device.getIpAddress() + " has been configured succesfully. Preparig to save data in database."));
            gatewayClient.setDeleted(false);
            gatewayClient.setUser(this.authUtils.getCurrentUser());
            device.setAddedDate(new Date());
            device.setUser(this.authUtils.getCurrentUser());
            device.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
            if (this.isIntegratedDevice(gatewayClient) && !this.isReconfiguration(dev.getReconfiguration())) {
                gatewayClient.setConnectedDate(this.getGatewayDeviceConnectedDate(gatewayClient.getMac()));
            }
            if (!this.isReconfiguration(dev.getReconfiguration())) {
                device.setName(this.generateName(device));
            }
            this.updateDateLastCheckIpAddress(device);
            LanDeviceEntity savedDevice = null;
            if (Boolean.TRUE.equals(device.getReconfiguration())) {
                List params = device.getLanDeviceParams();
                device.setLanDeviceParams(new ArrayList());
                if (this.lanDeviceDAO.updateLanDeviceWithTransaction(device) == null) {
                    this.eventlogService.registerEventlog(LDEventType.CONFIGURE, device.getMac(), dev.getIpAddress(), GenericLanDevice.ConfigurationStatus.ERROR.name(), "Lan device has not been stored in database.");
                    return new ConfigurationDeviceResponse(this, GenericLanDevice.ConfigurationStatus.ERROR);
                }
                device.setLanDeviceParams(params);
                savedDevice = this.lanDeviceDAO.updateLanDeviceWithTransaction(device);
            } else {
                savedDevice = this.lanDeviceDAO.saveLanDeviceWithTransaction(device);
            }
            if (productChanged) {
                this.productManagementService.logDeviceproduct(savedDevice.getLanDeviceId(), savedDevice.getProduct().getProductId());
            }
            if (this.isSavedDevice(savedDevice)) {
                this.eventlogService.registerEventlog(LDEventType.CONFIGURE, device.getMac(), dev.getIpAddress(), GenericLanDevice.ConfigurationStatus.OK.name(), null);
                this.gatewayClientService.setUpUpnpForwarding(device.getMac(), device.getGatewayClient().getUpnpPort());
                this.connector.setRegistered(device.getGatewayClient().getMac(), true);
                String commServerUrl = this.connector.getVeryfiedServerUrl(device.getGatewayClient().getMac());
                if (commServerUrl == null) {
                    log.warn((Object)("Got null commServerUrl for just registered device " + device.getGatewayClient().getMac() + "."));
                }
                this.gatewayClientService.updateGatewayClientStatus(device.getGatewayClient().getMac(), true, commServerUrl);
                if (!this.isReconfiguration(dev.getReconfiguration()) && this.isAutoUniqueFullNameEnabled()) {
                    this.userService.assignIndex(this.authUtils.getCurrentUserId(), savedDevice.getMac());
                }
                return new ConfigurationDeviceResponse(this, GenericLanDevice.ConfigurationStatus.OK, savedDevice);
            }
            this.eventlogService.registerEventlog(LDEventType.CONFIGURE, device.getMac(), dev.getIpAddress(), GenericLanDevice.ConfigurationStatus.ERROR.name(), "Lan device has not been stored in database.");
            return new ConfigurationDeviceResponse(this, GenericLanDevice.ConfigurationStatus.ERROR);
        }
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, device.getMac(), dev.getIpAddress(), configurationStatus.name(), null);
        return new ConfigurationDeviceResponse(this, configurationStatus, device);
    }

    private String generateName(LanDeviceEntity device) {
        return this.deviceNameGenerator.generate(this.authUtils.getCurrentUserId(), device.getDeviceDesc().getClassDevice(), device.getGatewayClient().getMac());
    }

    private boolean isDisabledRootPassGeneration() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION);
    }

    private boolean isAutoUniqueFullNameEnabled() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.AUTO_UNIQUE_FULL_NAME, false);
    }

    private boolean isIntegratedDevice(GatewayClientEntity gatewayClient) {
        return gatewayClient.getDeviceType().equals(16);
    }

    private VideoQualityLevel getTrialVideoQuality(ProductEntity product) {
        String basicVideoQualityText = product.getProductFeatureValue(DeviceFeatureCode.MAX_VIDEO_QUALITY);
        VideoQualityLevel basicVideoQuality = VideoQualityLevel.parse((String)basicVideoQualityText);
        return basicVideoQuality.ordinal() > VideoQualityLevel.GOOD.ordinal() ? VideoQualityLevel.GOOD : basicVideoQuality;
    }

    private Date getGatewayDeviceConnectedDate(String macAddress) {
        if (macAddress == null) {
            return null;
        }
        GatewayDevice device = this.gatewayDeviceConnection.findById(macAddress);
        return device == null ? null : device.getConnectedDate();
    }

    private String generateAlarmUserName() {
        return this.authUtils.getCurrentUserId() + "_" + this.passwordGenerator.generate(10);
    }

    private LanDeviceEntity saveOrUpdateDevice(LanDeviceEntity device) {
        log.trace((Object)("start saveOrUpdateDevice(device=" + device + ")"));
        log.trace((Object)("gc=" + device.getGatewayClient() + ")"));
        return device.getLanDeviceId() == null ? this.lanDeviceDAO.saveLanDevice(device) : this.lanDeviceDAO.updateLanDevice(device);
    }

    private boolean isSavedDevice(LanDeviceEntity device) {
        return device != null && device.getLanDeviceId() != null;
    }

    @Transactional
    public List<LanDevice> finalizeConfiguration(boolean needManual) throws InvalidSessionException {
        log.trace((Object)("start finalizeConfiguration(needManual=" + needManual + ")"));
        this.authUtils.ensureLoggedIn();
        ArrayList<LanDevice> activatedDevices = new ArrayList<LanDevice>();
        Object correctDevices = this.authUtils.getStoredData("correct_devices");
        if (correctDevices != null) {
            for (LanDeviceEntity correctDevice : (List)correctDevices) {
                LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(correctDevice.getLanDeviceId(), true, true, true, false);
                if (device == null) {
                    log.warn((Object)("Not found device with lanDeviceId=" + correctDevice.getLanDeviceId() + "."));
                    continue;
                }
                activatedDevices.add(device.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, true, true, true, this.videoStreamService, this.productManagementService));
            }
        }
        if (needManual) {
            List manualDevices = (List)this.authUtils.getStoredData("manual_devices");
            if (manualDevices == null) {
                log.debug((Object)"Found no devices that require manual configuration");
                return activatedDevices;
            }
            for (LanDeviceEntity device : manualDevices) {
                GatewayClientEntity gatewayClient = device.getGatewayClient();
                if (gatewayClient.getGatewayClientId() != null) {
                    gatewayClient.setDeleted(false);
                    GatewayClientEntity mergedGc = this.gatewayClientDAO.updateGatewayClient(gatewayClient);
                    device.setGatewayClient(mergedGc);
                }
                device.setAddedDate(new Date());
                device.setUser(this.authUtils.getCurrentUser());
                if (!this.isReconfiguration(device.getReconfiguration())) {
                    device.setName(this.generateName(device));
                }
                device.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.MANUAL);
                LanDeviceEntity savedDevice = this.saveOrUpdateDevice(device);
                if (savedDevice == null) {
                    log.warn((Object)"Lan device has not benn saved!");
                    continue;
                }
                activatedDevices.add(savedDevice.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, true, true, true, this.videoStreamService, this.productManagementService));
            }
        }
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        log.trace((Object)("exit finalizeConfiguration(needManual=" + needManual + "): " + activatedDevices));
        return activatedDevices;
    }

    private void resetProductToBasic(LanDeviceEntity device) {
        ProductEntity trialProduct = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), DeviceProduct.DeviceProductType.TRIAL);
        if (device.getProduct().getProductId().equals(trialProduct.getProductId())) {
            ProductEntity basicProduct = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), DeviceProduct.DeviceProductType.BASIC);
            device.setProduct(basicProduct);
            device.setProductDate(new Date());
            GregorianCalendar cal = new GregorianCalendar();
            cal.setTime(device.getProductDate());
            cal.add(5, -1);
            Date newValidTo = cal.getTime();
            device.setValidTo(newValidTo);
            device.setTrialProductDate(null);
        }
    }

    private boolean isReconfiguration(Boolean reconfiguration) {
        return reconfiguration != null && reconfiguration.equals(Boolean.TRUE);
    }

    public void updateIpAddresses() {
        log.trace((Object)"start updateIpAddresses()");
        Integer firstResult = 0;
        Integer maxResult = 100;
        List devices = null;
        do {
            devices = this.lanDeviceDAO.findNotDeletedLanDevices(firstResult, maxResult);
            firstResult = firstResult + devices.size();
            for (LanDeviceEntity device : devices) {
                this.updateIpAddress(device, true);
            }
        } while (devices.size() == maxResult.intValue());
    }

    private void updateIpAddress(LanDeviceEntity device, boolean cyclic) {
        this.updateIpAddress(device, cyclic, false);
    }

    private void updateIpAddress(LanDeviceEntity device, boolean cyclic, boolean force) {
        if (!this.isAllowedUpdateIpAddress(device.getGatewayClient(), device)) {
            return;
        }
        String lastDateText = device.getParamValue("dateLastCheckAddress");
        log.debug((Object)("Last date of ip address check: " + lastDateText + " for device with mac address " + device.getMac() + "."));
        if (force || this.isRequiredIpAddressCheck(lastDateText, this.getVerifyIpAddressPeriod(cyclic))) {
            device = this.lanDeviceDAO.findLanDeviceById(device.getLanDeviceId(), true, true);
            this.updateDateLastCheckIpAddress(device);
            log.debug((Object)"Verify ip address is required.");
            GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
            String retrievedMac = driver.getMacAddress(device);
            log.debug((Object)("Retrieved mac for device with id: '" + device.getLanDeviceId() + "'."));
            if (!this.areMacsEqual(retrievedMac, device.getMac())) {
                log.debug((Object)"ip address has changed.");
                String ipAddress = this.discoverIpAddress(device, driver);
                log.debug((Object)("discovered ip address: " + ipAddress + "."));
                if (ipAddress != null) {
                    device.setIpAddress(ipAddress);
                    this.eventlogService.registerEventlog(LDEventType.LANIPCHANGE, device.getMac(), ipAddress, "OK", null);
                } else {
                    this.eventlogService.registerEventlog(LDEventType.LANIPCHANGE, device.getMac(), ipAddress, "ERROR", "IP address lookup failed");
                }
            }
            this.lanDeviceDAO.updateLanDeviceWithTransaction(device);
        }
    }

    private boolean areMacsEqual(String retrievedMac, String deviceMac) {
        if (retrievedMac == null || deviceMac == null) {
            return false;
        }
        return retrievedMac.toUpperCase().replace(":", "").equals(deviceMac.toUpperCase().replace(":", ""));
    }

    private String getVerifyIpAddressPeriod(boolean cyclic) {
        if (cyclic) {
            return this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_VERIFY_IP_ADDRESS_CYCLIC_PERIOD);
        }
        return this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_VERIFY_IP_ADDRESS_WHEN_GC_CONNECTED_PERIOD);
    }

    private void updateDateLastCheckIpAddress(LanDeviceEntity device) {
        if (device == null || device.getLanDeviceParams() == null) {
            return;
        }
        LanDeviceParamEntity param = device.getParam("dateLastCheckAddress");
        String dateLastCheck = this.dateToString(new Date());
        if (param == null) {
            device.setParam("dateLastCheckAddress", dateLastCheck, dateLastCheck);
        } else {
            param.setValue(dateLastCheck);
            param.setRemoteValue(dateLastCheck);
        }
    }

    private String discoverIpAddress(LanDeviceEntity device, GenericLanDevice driver) {
        return driver.getIpAddress(device.getGatewayClient().getMac(), device.getMac());
    }

    private boolean isRequiredIpAddressCheck(String date, String period) {
        log.trace((Object)("start isRequiredIpAddressCheck(date=" + date + ", period=" + period + ")"));
        if (date == null) {
            return true;
        }
        return this.isRequiredIpAddressCheck(this.textToDate(date), period);
    }

    private boolean isRequiredIpAddressCheck(Date date, String period) {
        log.trace((Object)("start isRequiredIpAddressCheck(date=" + date + ", period=" + period + ")"));
        if (date == null) {
            return true;
        }
        Date currentDate = new Date();
        Date boundryDate = this.prepareBoundaryDate(date, period);
        return boundryDate.before(currentDate);
    }

    private Date prepareBoundaryDate(Date date, String period) {
        log.trace((Object)("start prepareBoundaryDate(date=" + date + ", period=" + period + ")"));
        if (date == null) {
            return null;
        }
        if (period == null || period.trim().length() == 0) {
            return date;
        }
        String[] periodSegs = period.toLowerCase().split(" ");
        int dayPeriod = 0;
        int hourPeriod = 0;
        int minutePeriod = 0;
        String[] stringArray = periodSegs;
        int n = periodSegs.length;
        int n2 = 0;
        while (n2 < n) {
            String periodSeg = stringArray[n2];
            if (periodSeg.contains("d")) {
                dayPeriod = Integer.parseInt(periodSeg.replace("d", ""));
            }
            if (periodSeg.contains("h")) {
                hourPeriod = Integer.parseInt(periodSeg.replace("h", ""));
            }
            if (periodSeg.contains("m")) {
                minutePeriod = Integer.parseInt(periodSeg.replace("m", ""));
            }
            ++n2;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        cal.add(6, dayPeriod);
        cal.add(11, hourPeriod);
        cal.add(12, minutePeriod);
        return cal.getTime();
    }

    public Date textToDate(String date) {
        if (date == null || date.trim().length() == 0) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String dateToString(Date date) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(date);
    }

    public void updateIpAddresses(String mac) {
        log.trace((Object)("start updateIpAddresses(mac=" + mac + ")"));
        List gatewayClients = this.gatewayClientDAO.findGatewayClientsByMacAddress(mac);
        for (GatewayClientEntity gatewayClient : gatewayClients) {
            List devices = this.lanDeviceDAO.findLanDevicesByGatewayClientId(gatewayClient.getGatewayClientId());
            if (devices == null || devices.isEmpty()) continue;
            for (LanDeviceEntity device : devices) {
                if (!this.isAllowedUpdateIpAddress(gatewayClient, device)) continue;
                this.updateIpAddress(device, false);
            }
        }
    }

    private boolean isAllowedUpdateIpAddress(GatewayClientEntity gatewayClient, LanDeviceEntity device) {
        if (this.gatewayDeviceConnection.findById(gatewayClient.getMac()) == null) {
            log.debug((Object)("not allowing IP address update on not connected gatewayClient " + gatewayClient.getMac()));
            return false;
        }
        return !gatewayClient.getDeviceType().equals(16) || !device.getIpAddress().equals("127.0.0.1");
    }

    public ActivateCameraResponse activateCamera(String activationCode, LanDeviceServiceExt.DeviceType deviceType) throws InvalidSessionException {
        return this.activateCamera(activationCode, false, deviceType);
    }

    private boolean isRemoteGatewayClientsEnabled() {
        return "ON".equals(this.parameterService.getParameterValue(ParameterService.ParameterCode.REMOTE_GATEWAY_CLIENTS_ENABLED));
    }

    private boolean isMultiRegistrationEnabled() {
        return this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.REGISTRATION_DEVICE_TO_MANY_ACCOUNTS);
    }

    public ActivateCameraResponse activateCamera(String activationCode, boolean trial, LanDeviceServiceExt.DeviceType deviceType) throws InvalidSessionException {
        boolean addingLanDeviceOnly;
        log.trace((Object)("start activateCamera(activationCode=" + activationCode + ")"));
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        GatewayDevice gatewayDevice = null;
        String macAddress = this.activationCodeHandler.getMacAddress(activationCode);
        VerifyGcResponse verifyGcResponse = this.gatewayClientService.verifyGatewayClient(activationCode, true);
        boolean bl = addingLanDeviceOnly = verifyGcResponse.status == VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED || verifyGcResponse.status == VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED_TRYINSTALL;
        if (addingLanDeviceOnly) {
            if (!this.isRemoteGatewayClientsEnabled()) {
                this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, verifyGcResponse.status.name(), null);
                return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR, ActivateCameraResponse.CameraActivationStatus.NOTCONNECTED_TRYINSTALL);
            }
            gatewayDevice = this.findGatewayDeviceForLanDevice(macAddress);
            if (gatewayDevice == null) {
                this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, verifyGcResponse.status.name(), null);
                return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR, ActivateCameraResponse.CameraActivationStatus.NOTCONNECTED_TRYINSTALL);
            }
        } else {
            if (verifyGcResponse.status != VerifyGcResponse.VerifyGcStatus.SUCCESS) {
                this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, verifyGcResponse.status.name(), null);
                return this.toActivateCameraResponse(verifyGcResponse);
            }
            gatewayDevice = this.gatewayDeviceConnection.findById(macAddress);
        }
        if (!this.isAllowedLanDeviceActivation(gatewayDevice)) {
            return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_ACTIVATIONOUTSIDEDEVICELOCALNETWORK);
        }
        List foundDevices = this.lanDeviceDAO.findNotDeletedLanDevicesByMac(macAddress);
        if (!foundDevices.isEmpty()) {
            LanDeviceEntity userDevice = this.getDeviceBelongsToUser(foundDevices, this.authUtils.getCurrentUser());
            if (userDevice != null) {
                String gcMac = userDevice.getGatewayClient().getMac();
                log.debug((Object)("Reconfiguration lan device with mac address " + macAddress + " and gc mac = " + gcMac + "."));
                GatewayClientEntity foundGC = this.gatewayClientDAO.findGatewayClientByMacAndUserId(gcMac, this.authUtils.getCurrentUserId());
                if (foundGC == null) {
                    this.eventlogService.registerEventlog(LDEventType.CONFIGURE, macAddress, null, "ERROR", "No gateway client found for mac address " + gcMac + " and userId=" + this.authUtils.getCurrentUserId() + ".");
                    return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
                }
                userDevice.setReconfiguration(Boolean.valueOf(true));
                return this.configureIntegratedDevice(userDevice.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, true, true, true, this.videoStreamService, this.productManagementService), foundGC, this.getDriver(macAddress), trial);
            }
            if (this.isMultiRegistrationEnabled()) {
                log.trace((Object)"Registration one device to many accounts enabled.");
                if (this.isReachedDeviceLimit()) {
                    log.debug((Object)"User already reached limit of the number of devices");
                    return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_REACHEDMAXDEVICECOUNT);
                }
                return this.configureIntegratedDevice(macAddress, gatewayDevice, addingLanDeviceOnly, trial, deviceType);
            }
            log.trace((Object)"Registration one device to many accounts disabled.");
            log.debug((Object)("Lan device with mac address '" + macAddress + "' has been registered to another account!"));
            this.eventlogService.registerEventlog(LDEventType.CONFIGURE, macAddress, null, ActivateCameraResponse.CameraActivationStatus.FAILED_ANOTHERACCOUNTASSIGNED.name(), null);
            return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_ANOTHERACCOUNTASSIGNED);
        }
        if (this.isReachedDeviceLimit()) {
            log.debug((Object)"User already reached limit of the number of devices");
            return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_REACHEDMAXDEVICECOUNT);
        }
        return this.configureIntegratedDevice(macAddress, gatewayDevice, addingLanDeviceOnly, trial, deviceType);
    }

    private GatewayDevice findGatewayDeviceForLanDevice(String macAddress) throws InvalidSessionException {
        GatewayDevice gatewayDevice;
        GenericLanDevice driver = this.getDriver(macAddress);
        if (driver == null) {
            log.debug((Object)("Cannot find device driver for MAC " + macAddress));
            return null;
        }
        List gatewayClients = this.gatewayClientService.getAllGatewayClients();
        ExecutorService executor = Executors.newCachedThreadPool();
        LinkedList results = new LinkedList();
        for (GatewayClient gatewayClient : gatewayClients) {
            CameraDiscoveryService cameraDiscovery;
            gatewayDevice = this.gatewayDeviceConnection.findById(gatewayClient.getMac());
            if (gatewayDevice == null || !gatewayDevice.isGateway() || (cameraDiscovery = driver.getCameraDiscoveryService()) == null) continue;
            Future callable = executor.submit(new /* Unavailable Anonymous Inner Class!! */);
            results.add(callable);
        }
        executor.shutdown();
        for (Future future : results) {
            try {
                gatewayDevice = (GatewayDevice)future.get();
                if (gatewayDevice == null) continue;
                return gatewayDevice;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private boolean deviceIsGatewayClientOnly(String macAddress) {
        String macAddressPrefix = macAddress.substring(0, 8);
        String value = this.parameterService.getParameterValue(ParameterService.ParameterCode.GATEWAY_CLIENT_ONLY_MAC_PREFIXES);
        return value != null && value.contains(macAddressPrefix);
    }

    private ActivateCameraResponse configureIntegratedDevice(String lanDeviceMacAddress, GatewayDevice gatewayDevice, boolean addingLanDeviceOnly, boolean trial, LanDeviceServiceExt.DeviceType deviceType) throws InvalidSessionException {
        GatewayClientEntity gatewayClientEntity = this.gatewayClientDAO.findGatewayClientByMacAndUserId(gatewayDevice.getMac(), this.authUtils.getCurrentUserId());
        GenericLanDevice driver = this.getDriver(lanDeviceMacAddress);
        if (this.deviceIsGatewayClientOnly(lanDeviceMacAddress)) {
            log.debug((Object)("Adding only GC with MAC " + gatewayDevice.getMac()));
            if (!this.validateSupportedServicesGCOnly(gatewayDevice)) {
                return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR, ActivateCameraResponse.CameraActivationStatus.NOTSUPPORTED);
            }
            if (gatewayClientEntity != null) {
                log.debug((Object)"trying to add already added and not deleted GC");
            } else {
                this.createGatewayClient(gatewayDevice);
            }
            return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        }
        if (addingLanDeviceOnly) {
            log.debug((Object)("Adding LD " + lanDeviceMacAddress + " for GC " + gatewayDevice.getMac()));
            if (!this.validateDeviceType(lanDeviceMacAddress, deviceType) || !this.validateSupportedServicesLDOnly(gatewayDevice, lanDeviceMacAddress)) {
                return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR, ActivateCameraResponse.CameraActivationStatus.NOTSUPPORTED);
            }
            if (gatewayClientEntity == null) {
                log.debug((Object)"cannot find GC, check for exceptions");
                return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR, ActivateCameraResponse.CameraActivationStatus.FAILED_NOTCONNECTED);
            }
            return this.configureIntegratedDevice(this.createLanDevice(gatewayDevice, driver, lanDeviceMacAddress), gatewayClientEntity, driver, trial);
        }
        log.debug((Object)("Adding integrated device LD " + lanDeviceMacAddress + " GC " + gatewayDevice.getMac()));
        if (!this.validateDeviceType(lanDeviceMacAddress, deviceType) || !this.validateSupportedServicesIntegratedDevice(gatewayDevice, lanDeviceMacAddress)) {
            return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR, ActivateCameraResponse.CameraActivationStatus.NOTSUPPORTED);
        }
        if (gatewayClientEntity == null) {
            gatewayClientEntity = this.createGatewayClient(gatewayDevice);
        }
        if (gatewayDevice.isStargate() && this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.ENABLE_STARGATE_WEB_INTERFACE)) {
            GenericLanDevice webInterfaceDriver = this.deviceDriverFactory.getDriver("StargateWebInterface", false);
            ActivateCameraResponse stargateLanDeviceConfigurationResponse = this.configureIntegratedDevice(this.createLanDevice(gatewayDevice, webInterfaceDriver, lanDeviceMacAddress), gatewayClientEntity, webInterfaceDriver, trial);
            if (stargateLanDeviceConfigurationResponse.status != ActivateCameraResponse.ActivateStatus.SUCCESS) {
                log.debug((Object)("failed to configure Stargate's web interface for " + gatewayDevice.getMac()));
                this.removeGatewayClientIfNeeded(gatewayClientEntity);
                return stargateLanDeviceConfigurationResponse;
            }
        }
        return this.configureIntegratedDevice(this.createLanDevice(gatewayDevice, driver, lanDeviceMacAddress), gatewayClientEntity, driver, trial);
    }

    private boolean validateDeviceType(String lanDeviceMacAddress, LanDeviceServiceExt.DeviceType deviceType) {
        String driverClass = this.getDriverClassName(lanDeviceMacAddress);
        if (driverClass == null) {
            log.debug((Object)("cannot find driver for MAC " + lanDeviceMacAddress));
            return false;
        }
        boolean deviceIsNAS = driverClass.equalsIgnoreCase("NAS");
        if (deviceIsNAS && deviceType != LanDeviceServiceExt.DeviceType.NAS) {
            log.debug((Object)"trying to add camera as NAS");
            return false;
        }
        if (!deviceIsNAS && deviceType == LanDeviceServiceExt.DeviceType.NAS) {
            log.debug((Object)"trying to add NAS as camera");
            return false;
        }
        return true;
    }

    private String getDriverClassName(String mac) {
        if (this.activationCodeHandler.isMacAddress(mac)) {
            return this.deviceDriverFactory.getDriverClassNameByMacPrefix(mac);
        }
        String forcedDriverName = this.parameterService.getParameterValue(ParameterService.ParameterCode.FORCED_DEVICE_DRIVER_NAME);
        if (forcedDriverName != null) {
            return forcedDriverName;
        }
        return null;
    }

    private boolean validateSupportedServicesIntegratedDevice(GatewayDevice gatewayDevice, String lanDeviceMacAddress) {
        String driverClass = this.getDriverClassName(gatewayDevice.getMac());
        if ("NAS".equalsIgnoreCase(driverClass) && !gatewayDevice.isNas()) {
            log.debug((Object)"cannot add NAS device - GC doesn't support NAS");
            return false;
        }
        return true;
    }

    private boolean validateSupportedServicesLDOnly(GatewayDevice gatewayDevice, String lanDeviceMacAddress) {
        String driverClass = this.getDriverClassName(lanDeviceMacAddress);
        if ("NAS".equalsIgnoreCase(driverClass)) {
            log.debug((Object)"cannot add NAS device to separate GC");
            return false;
        }
        if (!gatewayDevice.isGateway()) {
            log.debug((Object)("trying to add LD only for device with MAC " + lanDeviceMacAddress + " but GC is not a gateway"));
            return false;
        }
        if (gatewayDevice.isEmbedded()) {
            log.debug((Object)("trying to add LD only for device with MAC " + lanDeviceMacAddress + " but it's embedded"));
            return false;
        }
        return true;
    }

    private boolean validateSupportedServicesGCOnly(GatewayDevice gatewayDevice) {
        String driverClass = this.getDriverClassName(gatewayDevice.getMac());
        if (driverClass != null) {
            log.debug((Object)("trying to add GC only for device with MAC " + gatewayDevice.getMac() + " but it should be added with LD of class " + driverClass));
            return false;
        }
        if (!gatewayDevice.isGateway()) {
            log.debug((Object)("trying to add GC only for device with MAC " + gatewayDevice.getMac() + " but it's not a gateway"));
            return false;
        }
        if (gatewayDevice.isEmbedded()) {
            log.debug((Object)("trying to add GC only for device with MAC " + gatewayDevice.getMac() + " but it's embedded"));
            return false;
        }
        return true;
    }

    private GenericLanDevice getDriver(String macAddress) {
        if (this.activationCodeHandler.isMacAddress(macAddress)) {
            return this.deviceDriverFactory.getDriverByMacPrefix(macAddress, false);
        }
        String forcedDriverName = this.parameterService.getParameterValue(ParameterService.ParameterCode.FORCED_DEVICE_DRIVER_NAME);
        if (forcedDriverName != null) {
            return this.deviceDriverFactory.getDriver(forcedDriverName, false);
        }
        return null;
    }

    private boolean isReachedDeviceLimit() throws InvalidSessionException {
        log.trace((Object)"start isReachedDeviceLimit()");
        String maxDeviceCount = this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT);
        if (maxDeviceCount == null) {
            return false;
        }
        return (long)Integer.parseInt(maxDeviceCount) <= this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(this.authUtils.getCurrentUserId());
    }

    /*
     * Exception decompiling
     */
    private ActivateCameraResponse toActivateCameraResponse(VerifyGcResponse verifyGcResponse) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ActivateCameraResponse configureIntegratedDevice(LanDevice device, GatewayClientEntity gatewayClient, GenericLanDevice driver, boolean trial) throws InvalidSessionException {
        if (driver == null) {
            log.warn((Object)("No driver found for device " + device + ". Return ERROR status!"));
            this.eventlogService.registerEventlog(LDEventType.CONFIGURE, device.getMac(), device.getIpAddress(), GenericLanDevice.ConfigurationStatus.FAILED.name(), "Not found driver.");
            this.removeGatewayClientIfNeeded(gatewayClient);
            return new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        }
        AccessVerificationStatus verificationStatus = driver.verify(device);
        if (verificationStatus != AccessVerificationStatus.OK) {
            this.removeGatewayClientIfNeeded(gatewayClient);
            return this.toActivateCameraResponse(verificationStatus);
        }
        ConfigurationDeviceResponse configResp = this.configureLanDevice(device, gatewayClient, driver, trial);
        if (ConfigurationDeviceResponse.access$0((ConfigurationDeviceResponse)configResp) == GenericLanDevice.ConfigurationStatus.MANUAL) {
            ArrayList<LanDeviceEntity> manualDevices = new ArrayList<LanDeviceEntity>();
            manualDevices.add(ConfigurationDeviceResponse.access$1((ConfigurationDeviceResponse)configResp));
            this.authUtils.storeData("manual_devices", manualDevices);
        }
        if (ConfigurationDeviceResponse.access$0((ConfigurationDeviceResponse)configResp) == GenericLanDevice.ConfigurationStatus.OK) {
            ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
            correctDevices.add(ConfigurationDeviceResponse.access$1((ConfigurationDeviceResponse)configResp));
            this.authUtils.storeData("correct_devices", correctDevices);
        } else {
            this.removeGatewayClientIfNeeded(gatewayClient);
        }
        return this.toActivateCameraResponse(configResp);
    }

    private void removeGatewayClientIfNeeded(GatewayClientEntity gatewayClient) {
        Integer gatewayClientId;
        Integer userId = gatewayClient.getUser().getId();
        if (this.lanDeviceDAO.countNotDeletedLanDeviceByUserIdAndGatewayClientId(userId, gatewayClientId = gatewayClient.getGatewayClientId()) == 0L) {
            gatewayClient.setDeleted(true);
            this.gatewayClientDAO.updateGatewayClientWithTransaction(gatewayClient);
            List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(gatewayClient.getMac());
            if (clients.isEmpty()) {
                this.connector.setRegistered(gatewayClient.getMac(), false);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private ActivateCameraResponse toActivateCameraResponse(AccessVerificationStatus status) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private ActivateCameraResponse toActivateCameraResponse(ConfigurationDeviceResponse response) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private DeviceDescEntity retrieveDeviceDesc(GatewayDevice gatewayDevice) {
        if (gatewayDevice.getDeviceType() != 16) {
            log.warn((Object)"You are ryin register standalone camera. This wizard can register integrated cameras only!");
            return null;
        }
        String driverClassName = this.deviceDriverFactory.getDriverClassNameByMacPrefix(gatewayDevice.getMac());
        if (driverClassName == null) {
            return null;
        }
        return this.deviceDescDAO.findDeviceDescByDriverclass(driverClassName);
    }

    private GatewayClientEntity createGatewayClient(GatewayDevice gatewayDevice) {
        GatewayClientEntity gatewayClient = new GatewayClientEntity();
        gatewayClient.setSerialNumber(gatewayDevice.getMac());
        gatewayClient.setMac(gatewayDevice.getMac());
        gatewayClient.setName(gatewayDevice.getMac());
        gatewayClient.setDeleted(false);
        gatewayClient.setUser(this.authUtils.getCurrentUser());
        gatewayClient.setActivationDate(new Date());
        gatewayClient.setDeviceType(gatewayDevice.getDeviceType());
        gatewayClient.setVersion(gatewayDevice.getVersionMajor() + "." + gatewayDevice.getVersionMinor());
        gatewayClient.setBuildNo(gatewayDevice.getBuildNo());
        this.gatewayClientDAO.saveGatewayClientWithTransaction(gatewayClient);
        return gatewayClient;
    }

    private GatewayClient createGatewayClientDTO(GatewayDevice gatewayDevice) {
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber(gatewayDevice.getMac());
        gatewayClient.setMac(gatewayDevice.getMac());
        gatewayClient.setName(gatewayDevice.getMac());
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(gatewayDevice.getDeviceType());
        return gatewayClient;
    }

    private LanDevice createLanDevice(GatewayDevice gatewayDevice, GenericLanDevice driver, String lanDeviceMac) {
        LanDevice device = driver.getLanDevice(gatewayDevice, lanDeviceMac);
        if (device == null) {
            return null;
        }
        LanDeviceEntity latestDevice = this.retrieveLatestLanDevice(lanDeviceMac);
        if (latestDevice != null) {
            log.debug((Object)"found previous LD, borrowing credentials");
            device.setUser(latestDevice.getUsername());
            device.setPass(latestDevice.getPass());
        }
        device.setGatewayClient(this.createGatewayClientDTO(gatewayDevice));
        return device;
    }

    private boolean belongsToCurrentUser(GatewayClientEntity gatewayClient) {
        return gatewayClient.getUser().getId().equals(this.authUtils.getCurrentUserId());
    }

    private boolean belongsToCurrentUser(LanDeviceEntity device) {
        return device.getUser().getId().equals(this.authUtils.getCurrentUserId());
    }

    private LanDeviceEntity getDeviceBelongsToUser(List<LanDeviceEntity> devices, UserEntity user) {
        for (LanDeviceEntity device : devices) {
            if (!device.getUser().getId().equals(user.getId())) continue;
            return device;
        }
        return null;
    }

    @Transactional(readOnly=true)
    public WlanAccessPoints getWlanAccessPoints(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start getWlanAccessPoints(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity foundDevice = this.lanDeviceDAO.findLanDeviceByIdAndUserId(lanDeviceId, this.authUtils.getCurrentUserId());
        if (foundDevice == null) {
            return new WlanAccessPoints(WlanAccessPoints.GetWlanAccessPointsStatus.FAILED_DEVICENOTFOUND);
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(foundDevice);
        if (driver == null) {
            return new WlanAccessPoints(WlanAccessPoints.GetWlanAccessPointsStatus.FAILED_DRIVERNOTFOUND);
        }
        List wlanAccessPoints = driver.getWirelessNetworks(foundDevice);
        Collections.sort(wlanAccessPoints, new /* Unavailable Anonymous Inner Class!! */);
        return new WlanAccessPoints(WlanAccessPoints.GetWlanAccessPointsStatus.SUCCESS, wlanAccessPoints);
    }

    @Transactional
    public UpdateSettingStatus updateLanDeviceParam(Integer lanDeviceId, Integer userId, String paramName, String paramValue) {
        log.debug((Object)("start updateLanDeviceParam(lanDeviceId=" + lanDeviceId + ", paramName=" + paramName + ", paramValue=" + paramValue + ")"));
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceByIdAndUserId(lanDeviceId, userId);
        if (device == null) {
            log.warn((Object)("Not found lan device for lanDeviceId=" + lanDeviceId + "."));
            return UpdateSettingStatus.FAILED_DEVICENOTFOUND;
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            log.warn((Object)("Not found driver for lan device " + device + "."));
            return UpdateSettingStatus.FAILED_DRIVERNOTFOUND;
        }
        LanDeviceParamEntity currentParam = device.getParam(paramName);
        if (currentParam == null) {
            log.warn((Object)("Not found param for paramName=" + paramName + " for device with lanDeviceId=" + lanDeviceId + "."));
            return UpdateSettingStatus.FAILED_PARAMNOTFOUND;
        }
        if (driver.getSupportedSettings().contains(paramName)) {
            return driver.updateSingleSetting(device, paramName, paramValue);
        }
        return this.updateLanDeviceParam(lanDeviceId, paramName, paramValue, paramValue) ? UpdateSettingStatus.SUCCESS : UpdateSettingStatus.ERROR;
    }

    @Transactional
    public UpdateSettingStatus updateLanDeviceParamWithAuth(Integer lanDeviceId, String paramName, String paramValue) throws InvalidSessionException {
        log.trace((Object)("start updateLanDeviceParamWithAuth(lanDeviceId=" + lanDeviceId + ", paramName=" + paramName + ", paramValue=" + paramValue + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity lanDevice = this.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        if (lanDevice == null) {
            log.warn((Object)("Not found lan device for lanDeviceId=" + lanDeviceId + " and accessed by userId=" + this.authUtils.getCurrentUserId() + "."));
            return UpdateSettingStatus.FAILED_DEVICENOTFOUND;
        }
        UpdateSettingStatus status = this.updateLanDeviceParam(lanDeviceId, lanDevice.getUser().getId(), paramName, paramValue);
        log.trace((Object)("exit updateLanDeviceParamWithAuth(lanDeviceId=" + lanDeviceId + ", paramName=" + paramName + ", paramValue=" + paramValue + ") status = " + status));
        return status;
    }

    public String getLanDeviceMACById(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start getLanDeviceMACById(lanDeviceId=" + lanDeviceId + ")"));
        LanDeviceEntity foundDevice = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (foundDevice == null) {
            return null;
        }
        return foundDevice.getMac();
    }

    public String getLanDeviceIpAndPortById(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start getLanDeviceIpAndPortById(lanDeviceId=" + lanDeviceId + ")"));
        LanDeviceEntity foundDevice = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (foundDevice == null) {
            return null;
        }
        return String.valueOf(foundDevice.getIpAddress()) + ":" + foundDevice.getPort();
    }

    private Date constructTrialValidTo(Integer productId) throws InvalidSessionException {
        String period = this.productManagementService.getFeatureValue(productId, DeviceFeatureCode.LANDEVICE_VALIDITY);
        if (period == null) {
            log.warn((Object)"Unexpected LANDEVICE_VALIDITY feature value: null");
            return null;
        }
        if (!period.matches("^[0-9]+[dDmM]{1}$")) {
            log.warn((Object)("Unexpected LANDEVICE_VALIDITY feature value: '" + period + "'."));
            return null;
        }
        return this.adjustDate(this.systemSupport.getCurrentDate(), period);
    }

    private Date constructPremiumValidTo(LanDeviceEntity device) {
        Date today;
        log.trace((Object)("start constructPremiumValidTo(device" + (device == null ? "=null)" : " with lanDeviceId=" + device.getLanDeviceId() + ")")));
        if (device == null) {
            log.debug((Object)"Can not construct premium valid to date for null device.");
            return null;
        }
        Date validTo = device.getValidTo();
        if (validTo.before(today = this.systemSupport.getCurrentDate())) {
            validTo = today;
            log.debug((Object)("ValidTo date was null. Now is " + validTo));
        }
        if (device.getTrialProductDate() == null) {
            String trialPeriod = this.getDeviceValidityPeriod(device, DeviceProduct.DeviceProductType.TRIAL);
            log.debug((Object)("Trial period: " + trialPeriod));
            if (trialPeriod == null) {
                return null;
            }
            validTo = this.adjustDate(validTo, trialPeriod);
            log.debug((Object)("ValidTo after apply trial period: " + validTo));
        }
        String premiumPeriod = this.getDeviceValidityPeriod(device, DeviceProduct.DeviceProductType.PREMIUM);
        log.debug((Object)("Premium period: " + premiumPeriod));
        if (premiumPeriod == null) {
            return null;
        }
        validTo = this.adjustDate(validTo, premiumPeriod);
        log.debug((Object)("ValidTo after apply premium period: " + validTo));
        return validTo;
    }

    private String getDeviceValidityPeriod(LanDeviceEntity device, DeviceProduct.DeviceProductType productType) {
        log.trace((Object)("start getDeviceValidityPeriod(device=" + device + ", productType=" + productType + ")"));
        ProductEntity product = this.productManagementService.getProduct(device.getUser().getId(), productType);
        if (product == null) {
            log.warn((Object)("Not found product for device with lanDeviceId=" + device.getLanDeviceId() + " and for productType=" + productType + "."));
            return null;
        }
        String period = this.productManagementService.getFeatureValue(product.getProductId(), DeviceFeatureCode.LANDEVICE_VALIDITY);
        if (period == null) {
            log.warn((Object)("Unexpected LANDEVICE_VALIDITY feature value for device with lanDeviceId=" + device.getLanDeviceId() + " and productType=" + productType + ": null."));
            return null;
        }
        if (!period.matches("^[0-9]+[dDmM]{1}$")) {
            log.warn((Object)("Unexpected LANDEVICE_VALIDITY feature value for device with lanDeviceId=" + device.getLanDeviceId() + " and productType=" + productType + ": " + period + "."));
            return null;
        }
        return period;
    }

    private Date adjustDate(Date date, String period) {
        log.trace((Object)("start adjustDate(date=" + date + ", perdiod=" + period + ")"));
        PeriodUnit periodUnit = this.extractPeriodUnit(period);
        if (periodUnit == null) {
            log.warn((Object)("Unexpected period unit in period '" + period + "'. Allowed period units: d, D, m, M."));
            return null;
        }
        Integer periodValue = this.extractPeriodValue(period);
        if (periodValue == null) {
            log.warn((Object)("Unexpected period value in period '" + period + "'."));
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        if (periodUnit == PeriodUnit.DAY) {
            cal.add(5, periodValue);
            return cal.getTime();
        }
        if (periodUnit == PeriodUnit.MONTH) {
            cal.add(2, periodValue);
            return cal.getTime();
        }
        return null;
    }

    private PeriodUnit extractPeriodUnit(String period) {
        String periodUnit = period.substring(period.length() - 1, period.length());
        if (periodUnit.equalsIgnoreCase("d")) {
            return PeriodUnit.DAY;
        }
        if (periodUnit.equalsIgnoreCase("m")) {
            return PeriodUnit.MONTH;
        }
        return null;
    }

    private Integer extractPeriodValue(String period) {
        String periodValue = period.substring(0, period.length() - 1);
        if (!periodValue.matches("[0-9]+")) {
            return null;
        }
        return Integer.parseInt(periodValue);
    }

    @Transactional(readOnly=true)
    public void notifyDeviceValidityExpiryApproach() {
        log.trace((Object)"start notifyDeviceValidityExpiryApproach()");
        String notifyDeviceValidityDays = this.parameterService.getParameterValue(ParameterService.ParameterCode.LANDEVICE_NOTIFY_DEVICE_VALIDITY_DAYS);
        if (StringUtils.isBlank((CharSequence)notifyDeviceValidityDays)) {
            return;
        }
        Date validTo = this.adjustDate(this.systemSupport.getCurrentDate(), notifyDeviceValidityDays);
        List devices = this.lanDeviceDAO.findLanDevicesByValidTo(validTo);
        if (devices == null || devices.isEmpty()) {
            return;
        }
        for (LanDeviceEntity device : devices) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%CAMERANAME%", device.getName());
            placeholders.put("%EXPIRYDATE%", Utils.formatDate((Date)validTo, (String)"yyyy-MM-dd"));
            String emailCode = device.getProductFeatureValue(DeviceFeatureCode.VALIDITY_EXPIRY_SOON_EMAIL_TEMPLATE);
            if (emailCode != null && !emailCode.isEmpty()) {
                this.emailNotificationService.sendEmail(device.getUser().toDTO(), emailCode, placeholders, null);
                continue;
            }
            this.emailNotificationService.sendEmail(device.getUser().toDTO(), EmailNotificationService.EmailCode.CAMERA_VALIDITY_EXPIRY_APPROACH, placeholders, null);
        }
    }

    @Transactional(readOnly=true)
    public void notifyDeviceValidityExpired() {
        log.trace((Object)"start notifyDeviceValidityExpired()");
        Date currentDate = this.systemSupport.getCurrentDate();
        List devices = this.lanDeviceDAO.findLanDevicesByValidTo(currentDate);
        if (devices == null || devices.isEmpty()) {
            return;
        }
        for (LanDeviceEntity device : devices) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%CAMERANAME%", device.getName());
            placeholders.put("%EXPIRYDATE%", Utils.formatDate((Date)currentDate, (String)"yyyy-MM-dd"));
            this.emailNotificationService.sendEmail(device.getUser().toDTO(), EmailNotificationService.EmailCode.CAMERA_VALIDITY_EXPIRED, placeholders, null);
        }
    }

    private boolean isAllowedLanDeviceActivation(GatewayDevice gatewayDevice) throws InvalidSessionException {
        String macBasedActivation = this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION);
        log.debug((Object)("macBasedActivation: " + macBasedActivation));
        if (macBasedActivation != null && macBasedActivation.trim().equalsIgnoreCase("ON")) {
            return gatewayDevice.getPublicIpAddress().equals(this.authUtils.getClientIpAddress());
        }
        return true;
    }

    void verifyLanDevicesConfiguration(String gatewayClientMacAddress) {
        log.trace((Object)("start verifyLanDevicesConfiguration(gatewayClientMacAddress=" + gatewayClientMacAddress + ")"));
        List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(gatewayClientMacAddress);
        if (clients == null || clients.isEmpty()) {
            log.debug((Object)("Not found gateway client with mac=" + gatewayClientMacAddress + "."));
            return;
        }
        for (GatewayClientEntity client : clients) {
            List devices = this.lanDeviceDAO.findLanDevicesByGatewacClientId(client.getGatewayClientId(), false);
            if (devices == null) {
                log.warn((Object)("Failed to get lan devices for gateway client with gatewayClientId=" + client.getGatewayClientId() + "."));
                return;
            }
            for (LanDeviceEntity device : devices) {
                this.verifyLanDeviceConfiguration(device);
            }
        }
    }

    private void verifyLanDeviceConfiguration(LanDeviceEntity device) {
        log.trace((Object)("start verifyLanDeviceConfiguration(device=" + device + ")"));
        CheckConfigurationStatus configurationStatus = this.checkLanDeviceConfiguration(device.getLanDeviceId());
        if (configurationStatus != CheckConfigurationStatus.CORRECT && configurationStatus != CheckConfigurationStatus.INCORRECT) {
            log.info((Object)("Failed to check configuration for device with lanDeviceId=" + device.getLanDeviceId() + ": " + configurationStatus + "."));
            return;
        }
        String logMsg = "Failed to check configuration for device with lanDeviceId=" + device.getLanDeviceId() + ": " + configurationStatus + ".";
        if (configurationStatus == CheckConfigurationStatus.FAILED_NOANSWER) {
            log.debug((Object)logMsg);
        } else {
            log.info((Object)logMsg);
        }
        if (configurationStatus == CheckConfigurationStatus.CORRECT) {
            log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has correct configuration."));
            return;
        }
        log.info((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " requires to be reconfigured."));
        ReconfigurationDeviceStatus reconfigureStatus = this.reconfigureLanDevice(device.getLanDeviceId());
        if (reconfigureStatus != ReconfigurationDeviceStatus.SUCCESS) {
            log.warn((Object)("Failed to reconfigure device with lanDeviceId=" + device.getLanDeviceId() + ": " + reconfigureStatus + "."));
            return;
        }
        log.info((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has been reconfigured successfully."));
    }

    @Transactional
    public void updateLanDevicesVersion(String gatewayClientMacAddress) {
        if (!this.updateVersionOnConnect) {
            log.debug((Object)("updateLanDevicesVersion(gatewayClientMacAddress=" + gatewayClientMacAddress + ") - disabled"));
            return;
        }
        log.debug((Object)("start updateLanDevicesVersion(gatewayClientMacAddress=" + gatewayClientMacAddress + ")"));
        List clients = this.gatewayClientDAO.findGatewayClientsByMacAddress(gatewayClientMacAddress);
        if (clients == null || clients.isEmpty()) {
            log.debug((Object)("Not found gateway client with mac=" + gatewayClientMacAddress + "."));
            return;
        }
        for (GatewayClientEntity client : clients) {
            List devices = this.lanDeviceDAO.findLanDevicesByGatewacClientId(client.getGatewayClientId(), false);
            if (devices == null) {
                log.warn((Object)("Failed to get lan devices for gateway client with gatewayClientId=" + client.getGatewayClientId() + "."));
                return;
            }
            for (LanDeviceEntity device : devices) {
                this.updateLanDeviceVersion(device);
            }
        }
    }

    private void updateLanDeviceVersion(LanDeviceEntity device) {
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            log.warn((Object)("Failed to get driver for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        if (!this.gatewayClientService.isGatewayClientConnected(device.getGatewayClient().getSerialNumber()).booleanValue()) {
            return;
        }
        String version = driver.getVersion(device);
        if (version == null) {
            log.info((Object)("Failed to get firmware version for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        device.setVersion(version);
        if (this.lanDeviceDAO.updateLanDeviceWithTransaction(device) == null) {
            log.info((Object)("Failed to update firmware version for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        log.info((Object)("Firmware version for device with lanDeviceId=" + device.getLanDeviceId() + " has been update successfuly."));
    }

    public CheckConfigurationStatus checkLanDeviceConfigurationAsAdmin(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start checkLanDeviceConfigurationAsAdmin(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.checkLanDeviceConfiguration(lanDeviceId);
    }

    CheckConfigurationStatus checkLanDeviceConfiguration(Integer lanDeviceId) {
        log.trace((Object)("start checkLanDeviceConfiguration(lanDeviceId=" + lanDeviceId + ")"));
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null) {
            return CheckConfigurationStatus.FAILED_DEVICENOTFOUND;
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            return CheckConfigurationStatus.FAILED_DRIVERNOTFOUND;
        }
        if (!this.gatewayClientService.isGatewayClientConnected(device.getGatewayClient().getSerialNumber()).booleanValue()) {
            return CheckConfigurationStatus.FAILED_DEVICENOTCONNECTED;
        }
        return driver.checkConfiguration(device);
    }

    @Transactional
    public ReconfigurationDeviceStatus reconfigureLanDeviceAsAdmin(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start reconfigureLanDeviceAsAdmin(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        return this.reconfigureLanDevice(lanDeviceId);
    }

    /*
     * Exception decompiling
     */
    ReconfigurationDeviceStatus reconfigureLanDevice(Integer lanDeviceId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.entities.ClassFileField.getField()" because "fieldvar" is null
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewriteEclipse(SwitchEnumRewriter.java:239)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.tryRewrite(SwitchEnumRewriter.java:153)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchEnumRewriter.rewrite(SwitchEnumRewriter.java:86)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:882)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Transactional(readOnly=true)
    public LanDevice getLanDevice(Integer lanDeviceId, String remoteIPAddress) throws InvalidSessionException {
        log.trace((Object)("start getLanDevice(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = this.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        LanDevice ld = device.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, true, true, true, this.videoStreamService, this.productManagementService, this.authUtils.getCurrentUserId());
        this.detectAndSetLocalIpAddress(remoteIPAddress, ld);
        return ld;
    }

    public Map<Integer, LanDeviceStatus> getStatus() throws InvalidSessionException {
        this.authUtils.ensureLoggedIn();
        HashMap<Integer, LanDeviceStatus> devicesStatus = new HashMap<Integer, LanDeviceStatus>();
        List devices = this.lanDeviceDAO.findLanDevicesByUserId(this.authUtils.getCurrentUserId(), false);
        List sharedDevices = this.lanDeviceDAO.findLanDevicesSharedWithUser(this.authUtils.getCurrentUserId(), null);
        if (devices == null) {
            devices = sharedDevices;
        } else if (sharedDevices != null) {
            devices.addAll(sharedDevices);
        }
        if (devices == null) {
            return devicesStatus;
        }
        for (LanDeviceEntity device : devices) {
            LanDeviceStatus deviceStatus = new LanDeviceStatus(this.hasActiveEvent(device), this.isIlluminationEnabled(device), this.isFirmwareUpgrade(device), device.getUpgradeStatus());
            devicesStatus.put(device.getLanDeviceId(), deviceStatus);
        }
        return devicesStatus;
    }

    private boolean hasActiveEvent(LanDeviceEntity device) {
        EventEntity event = this.eventDAO.getActiveEvent(device.getLanDeviceId());
        return event != null;
    }

    private boolean isIlluminationEnabled(LanDeviceEntity device) {
        return "ON".equals(device.getParamValue("illumination"));
    }

    private boolean isFirmwareUpgrade(LanDeviceEntity device) {
        return LanDevice.LanDeviceConfigurationStatus.FIRMWARE_UPGRADE == device.getConfigurationStatus();
    }

    public Rssi checkRssi(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start checkRssi(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        if (lanDeviceId == null) {
            return new Rssi(Rssi.CheckRssiStatus.FAILED_INVALIDDEVICEID);
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceByIdAndUserId(lanDeviceId, this.authUtils.getCurrentUserId());
        if (device == null) {
            return new Rssi(Rssi.CheckRssiStatus.FAILED_DEVICENOTFOUND);
        }
        if (!this.gatewayClientService.isGatewayClientConnected(device.getGatewayClient().getSerialNumber()).booleanValue()) {
            return new Rssi(Rssi.CheckRssiStatus.FAILED_DEVICEDISCONNECTED);
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            return new Rssi(Rssi.CheckRssiStatus.FAILED_DRIVERNOTFOUND);
        }
        Integer rssi = driver.checkRSSI(device);
        Rssi.CheckRssiStatus status = rssi == null ? Rssi.CheckRssiStatus.ERROR : Rssi.CheckRssiStatus.SUCCESS;
        return new Rssi(status, rssi);
    }

    @Transactional
    public void updateLanDeviceAfterConnect(String gatewayClientMacAddress) {
        this.updateIpAddresses(gatewayClientMacAddress);
        this.updateLanDevicesVersion(gatewayClientMacAddress);
        if (this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_AUTO_CORRECT_CONFIG)) {
            this.verifyLanDevicesConfiguration(gatewayClientMacAddress);
        }
    }

    public UpgradeFirmwareStatus upgradeFirmware(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start upgradeFirmware(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureHasRole(AuthenticationUtils.Role.ADMIN);
        if (lanDeviceId == null) {
            this.logFirmwareUpgrade(null, UpgradeFirmwareStatus.FAILED_INVALIDDEVICEID, "Attempt to make upgrade for device with lanDeiceId=" + lanDeviceId + ".");
            return UpgradeFirmwareStatus.FAILED_INVALIDDEVICEID;
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null) {
            this.logFirmwareUpgrade(null, UpgradeFirmwareStatus.FAILED_DEVICENOTFOUND, "Attempt to make upgrade for device with lanDeiceId=" + lanDeviceId + ".");
            return UpgradeFirmwareStatus.FAILED_DEVICENOTFOUND;
        }
        if (device.getConfigurationStatus() == LanDevice.LanDeviceConfigurationStatus.FIRMWARE_UPGRADE) {
            this.logFirmwareUpgrade(null, UpgradeFirmwareStatus.FAILED_UPGRADEINPROGRESS, "Attempt to make upgrade for device with lanDeiceId=" + lanDeviceId + ".");
            return UpgradeFirmwareStatus.FAILED_UPGRADEINPROGRESS;
        }
        GenericLanDevice driver = this.deviceDriverFactory.getDriver(device);
        if (driver == null) {
            this.logFirmwareUpgrade(device, UpgradeFirmwareStatus.FAILED_DRIVERNOTFOUND, null);
            return UpgradeFirmwareStatus.FAILED_DRIVERNOTFOUND;
        }
        Boolean firmwareUpToDate = driver.isFirmwareUpToDate(device);
        if (firmwareUpToDate == null) {
            this.logFirmwareUpgrade(device, UpgradeFirmwareStatus.FAILED_LATESTVERSIONUNDEFINED, null);
            return UpgradeFirmwareStatus.FAILED_LATESTVERSIONUNDEFINED;
        }
        if (firmwareUpToDate.booleanValue()) {
            this.logFirmwareUpgrade(device, UpgradeFirmwareStatus.FAILED_FIRMWAREISUPTODATE, null);
            return UpgradeFirmwareStatus.FAILED_FIRMWAREISUPTODATE;
        }
        if (!this.gatewayClientService.isGatewayClientConnected(device.getGatewayClient().getSerialNumber()).booleanValue()) {
            this.logFirmwareUpgrade(device, UpgradeFirmwareStatus.FAILED_DEVICEDISCONNECTED, null);
            return UpgradeFirmwareStatus.FAILED_DEVICEDISCONNECTED;
        }
        device.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.FIRMWARE_UPGRADE);
        device.setUpgradeDate(this.systemSupport.getCurrentDate());
        device.setUpgradeStatus(null);
        if (this.lanDeviceDAO.updateLanDeviceWithTransaction(device) == null) {
            log.warn((Object)("Failed to change device configuration status to 'FIRMWARE_UPGRADE' for device with lanDeviceId=" + lanDeviceId));
        }
        boolean status = driver.upgradeFirmware(device);
        log.debug((Object)("upgrade firmware staus for device with lanDeviceId=" + lanDeviceId + ": " + status + "."));
        if (status) {
            this.logFirmwareUpgrade(device, UpgradeFirmwareStatus.SUCCESS, null);
            device.setUpgradeStatus(LanDevice.FirmwareUpgradeStatus.SUCCESS);
        } else {
            this.logFirmwareUpgrade(device, UpgradeFirmwareStatus.ERROR, null);
            device.setUpgradeStatus(LanDevice.FirmwareUpgradeStatus.FAILURE);
        }
        device.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        if (this.lanDeviceDAO.updateLanDeviceWithTransaction(device) == null) {
            log.warn((Object)("Failed to restore device configuration status for device with lanDeviceId=" + lanDeviceId));
        }
        return status ? UpgradeFirmwareStatus.SUCCESS : UpgradeFirmwareStatus.ERROR;
    }

    private void logFirmwareUpgrade(LanDeviceEntity device, UpgradeFirmwareStatus status, String description) {
        String mac = device == null ? "" : device.getMac();
        String ip = device == null ? "" : device.getIpAddress();
        this.eventlogService.registerEventlog(LDEventType.FIRMWAREUPGRADE, mac, ip, status.name(), description);
    }

    public CheckDeviceTrialProductResponse checkDeviceTrialProduct(String activationCode) throws InvalidSessionException {
        log.trace((Object)("checkDeviceProduct(activationCode=" + activationCode + ")"));
        String macAddress = this.activationCodeHandler.getMacAddress(activationCode);
        if (macAddress == null) {
            return new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.FAILED_CODEINCORRECT);
        }
        boolean automaticTrial = "ON".equals(this.productManagementService.getUserFeatureValue(UserFeatureCode.AUTOMATIC_TRIAL));
        LanDeviceEntity device = this.lanDeviceDAO.findLatestLanDeviceByMac(macAddress);
        if (this.deviceIsGatewayClientOnly(macAddress)) {
            return new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS, true);
        }
        if (device == null || device.getTrialProductDate() == null) {
            return new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS, true, automaticTrial);
        }
        ProductEntity trialProduct = this.productManagementService.getProduct(this.authUtils.getCurrentUserId(), DeviceProduct.DeviceProductType.TRIAL);
        if (trialProduct == null) {
            log.warn((Object)("Not found trial product for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.ERROR);
        }
        String trialPeriod = this.productManagementService.getFeatureValue(trialProduct.getProductId(), DeviceFeatureCode.LANDEVICE_VALIDITY);
        if (trialPeriod == null) {
            log.warn((Object)("Not found LANDEVICE_VALIDITY product feature for trial product identyficated by productId=" + trialProduct.getProductId() + "."));
            return new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.ERROR);
        }
        CheckDeviceTrialProductResponse response = new CheckDeviceTrialProductResponse(CheckDeviceTrialProductResponse.CheckDeviceProductStatus.SUCCESS);
        response.setAutomaticTrial(automaticTrial);
        response.setPossibleTrial(false);
        response.setTrialDateValidFrom(device.getTrialProductDate());
        Date trialDateValidTo = this.adjustDate(device.getTrialProductDate(), trialPeriod);
        response.setTrialDateValidTo(trialDateValidTo);
        response.setTrialPassed(this.isTrialPassed(device));
        return response;
    }

    private boolean isTrialPassed(LanDeviceEntity device) {
        DeviceProduct.DeviceProductType productType = this.productManagementService.getDeviceProductType(device.getLanDeviceId(), device.getDeleted());
        if (device.getTrialProductDate() == null) {
            return false;
        }
        return productType != DeviceProduct.DeviceProductType.TRIAL;
    }

    @Transactional
    public void manageDevicesProduct() throws InvalidSessionException {
        log.trace((Object)"start manageDevicesProduct()");
        Date exceededValidTo = Utils.adjustDate((Date)this.systemSupport.getCurrentDate(), (int)5, (int)-1, (boolean)true);
        List devices = this.lanDeviceDAO.findLanDevicesByValidTo(exceededValidTo);
        if (devices == null || devices.isEmpty()) {
            return;
        }
        for (LanDeviceEntity device : devices) {
            if (device.getProductFeature(DeviceFeatureCode.LANDEVICE_VALIDITY) == null) continue;
            this.manageDeviceProduct(device);
        }
    }

    private void manageDeviceProduct(LanDeviceEntity device) throws InvalidSessionException {
        log.trace((Object)("start manageDeviceProduct(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        String endAction = device.getProductFeatureValue(DeviceFeatureCode.LANDEVICE_VALIDITY_END_ACTION);
        if (endAction == null) {
            log.warn((Object)("Not found LANDEVICE_VALIDITY_END_ACTION product feature for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        String emailCode = device.getProductFeatureValue(DeviceFeatureCode.VALIDITY_EXPIRED_EMAIL_TEMPLATE);
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("%CAMERANAME%", device.getName());
        placeholders.put("%EXPIRYDATE%", Utils.formatDate((Date)device.getValidTo(), (String)"yyyy-MM-dd"));
        if (endAction.equalsIgnoreCase("LOCK")) {
            log.info((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has been locked."));
        } else if (endAction.equalsIgnoreCase("DOWNGRADE")) {
            if (!this.downgradeDeviceProduct(device)) {
                log.debug((Object)("Failed to downgrade device product for device with lanDeviceId=" + device.getLanDeviceId() + "."));
                return;
            }
        } else {
            log.warn((Object)("Unexpected LANDEVICE_VALIDITY_END_ACTION feature value for device with lanDeviceId=" + device.getLanDeviceId() + ": " + endAction + "."));
            return;
        }
        if (emailCode != null && !emailCode.isEmpty()) {
            this.emailNotificationService.sendEmail(device.getUser().toDTO(), emailCode, placeholders, null);
        } else {
            this.emailNotificationService.sendEmail(device.getUser().toDTO(), EmailNotificationService.EmailCode.CAMERA_VALIDITY_EXPIRED, placeholders, null);
        }
    }

    private boolean downgradeDeviceProduct(LanDeviceEntity device) throws InvalidSessionException {
        log.trace((Object)("downgradeDeviceProduct(device with lanDeviceId=" + device.getLanDeviceId() + ")"));
        ProductEntity productDowngradeTo = this.productManagementService.getProduct(device.getUser().getId(), DeviceProduct.DeviceProductType.BASIC);
        if (productDowngradeTo == null) {
            log.warn((Object)("Not found basic product for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return false;
        }
        device.setProduct(productDowngradeTo);
        device.setProductDate(this.systemSupport.getCurrentDate());
        if (this.lanDeviceDAO.updateLanDevice(device) == null) {
            log.warn((Object)("Failed to update device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return false;
        }
        this.productManagementService.logDeviceproduct(device.getLanDeviceId(), productDowngradeTo.getProductId());
        this.resetLanDevicePremiumCapabilitiesToDefault(device, productDowngradeTo);
        return true;
    }

    private void downgradeVideoQuality(LanDeviceEntity device, ProductEntity product) throws InvalidSessionException {
        log.trace((Object)("start downgradeVideoQuality(device with lanDeviceId=" + device.getLanDeviceId() + ", product with productId=" + product.getProductId() + ")"));
        VideoQualityLevel maxVideoQuality = VideoQualityLevel.parse((String)product.getProductFeatureValue(DeviceFeatureCode.MAX_VIDEO_QUALITY));
        if (maxVideoQuality == null) {
            log.debug((Object)("Max video quality for product with productId=" + product.getProductId() + " is not . Video quality for device wth lanDeviceId=" + device.getLanDeviceId() + " will not bee downgraded."));
            return;
        }
        VideoQualityLevel currentVideoQuality = VideoQualityLevel.parse((String)device.getParamValue("video_quality"));
        if (!this.isNeedToDowngradeVideoQaulity(currentVideoQuality, maxVideoQuality)) {
            log.debug((Object)("There is no need to downgrade video quality for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has video quality with higher rank than product max video quality. Video quality will be downgraded."));
        UpdateSettingStatus updateSettingStatus = this.updateLanDeviceParam(device.getLanDeviceId(), device.getUser().getId(), "video_quality", maxVideoQuality.name());
        if (updateSettingStatus != UpdateSettingStatus.SUCCESS) {
            log.debug((Object)("Failed to downgrade video quality for device with lanDeviceId=" + device.getLanDeviceId() + ": " + updateSettingStatus + "."));
            log.debug((Object)("Downgrade video quality for device with lanDeviceId=" + device.getLanDeviceId() + " will be done during restore configuration procedure."));
            device.getParam("video_quality").setValue(maxVideoQuality.name());
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                log.warn((Object)("Failed to defer downgrade video quality for device with lanDeviceId=" + device.getLanDeviceId() + " to restore configuration procedure."));
            }
        }
    }

    private void resetLanDevicePremiumCapabilitiesToDefault(LanDeviceEntity device, ProductEntity product) throws InvalidSessionException {
        this.downgradeVideoQuality(device, product);
        this.resetIlluminationToDefault(device, product);
        this.resetAlarmsToDefault(device, product);
        this.resetPrivacyButtonToDefault(device, product);
    }

    private void resetAlarmsToDefault(LanDeviceEntity device, ProductEntity product) {
        this.resetMotionDetectionToDefault(device, product);
        this.resetAudioDetectionToDefault(device, product);
    }

    private void resetIlluminationToDefault(LanDeviceEntity device, ProductEntity product) {
        log.debug((Object)("start resetIlluminationToDefault(device with lanDeviceId=" + device.getLanDeviceId() + ", product with productId=" + product.getProductId() + ")"));
        String illuminationForProduct = product.getProductFeatureValue(DeviceFeatureCode.CAMERALED);
        if (illuminationForProduct == null) {
            log.debug((Object)("There is no 'camera led' for product with productId=" + product.getProductId() + ". Illumination for device wth lanDeviceId=" + device.getLanDeviceId() + " will not be reset."));
            return;
        }
        String currentIllumination = device.getParamValue("illumination");
        if (currentIllumination == null) {
            log.debug((Object)("Lan device with lanDeviceId=" + device.getLanDeviceId() + "does not have 'illumination' param, nothing to do."));
            return;
        }
        if (!this.isNeedToChangeIllumination(currentIllumination, illuminationForProduct)) {
            log.debug((Object)("There is no need to reset illumination for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has illumination enabled and 'camera led' is disabled in the product. Illumination will be reset."));
        UpdateSettingStatus updateSettingStatus = this.updateLanDeviceParam(device.getLanDeviceId(), device.getUser().getId(), "illumination", "OFF");
        if (updateSettingStatus != UpdateSettingStatus.SUCCESS) {
            log.debug((Object)("Failed to reset illumination for device with lanDeviceId=" + device.getLanDeviceId() + ": " + updateSettingStatus + "."));
            log.debug((Object)("Reset illumination for device with lanDeviceId=" + device.getLanDeviceId() + " will be done during restore configuration procedure."));
            device.getParam("illumination").setValue("OFF");
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                log.warn((Object)("Failed to defer reset illumination for device with lanDeviceId=" + device.getLanDeviceId() + " to restore configuration procedure."));
            }
        }
    }

    private void resetMotionDetectionToDefault(LanDeviceEntity device, ProductEntity product) {
        UpdateSettingStatus updateSettingStatus;
        String currentVideoclip;
        log.debug((Object)("start resetMotionDetectionToDefault(device with lanDeviceId=" + device.getLanDeviceId() + ", product with productId=" + product.getProductId() + ")"));
        String motionDetectionForProduct = product.getProductFeatureValue(DeviceFeatureCode.ALARM);
        if (motionDetectionForProduct == null) {
            log.debug((Object)("There is no 'alarm' for product with productId=" + product.getProductId() + ". Motion detection for device wth lanDeviceId=" + device.getLanDeviceId() + " will not be reset."));
            return;
        }
        String currentMotionDetection = device.getParamValue("motion_detection");
        if (currentMotionDetection == null) {
            log.debug((Object)("Lan device with lanDeviceId=" + device.getLanDeviceId() + "does not have 'motion detection' param, nothing to do."));
            return;
        }
        if (!this.isNeedToChangeMotionDetection(currentMotionDetection, motionDetectionForProduct)) {
            log.debug((Object)("There is no need to reset motion detection for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has motion detection enabled and 'alarm' is disabled in the product. Motion detection will be reset."));
        String videoclipForProduct = product.getProductFeatureValue(DeviceFeatureCode.ALARM_VIDEORECORDING);
        if (videoclipForProduct == null) {
            log.debug((Object)("There is no 'alarm video clip' for product with productId=" + product.getProductId() + ". Videclip for device wth lanDeviceId=" + device.getLanDeviceId() + " will not be reset."));
        }
        if (videoclipForProduct != null && (currentVideoclip = device.getParamValue("alarm_video_clip")) != null && this.isNeedToChangeVideoclip(currentVideoclip, videoclipForProduct)) {
            device.getParam("alarm_video_clip").setValue("OFF");
        }
        if ((updateSettingStatus = this.updateLanDeviceParam(device.getLanDeviceId(), device.getUser().getId(), "motion_detection", "OFF")) != UpdateSettingStatus.SUCCESS) {
            log.debug((Object)("Failed to reset motion detection for device with lanDeviceId=" + device.getLanDeviceId() + ": " + updateSettingStatus + "."));
            log.debug((Object)("Reset motion detection for device with lanDeviceId=" + device.getLanDeviceId() + " will be done during restore configuration procedure."));
            device.getParam("motion_detection").setValue("OFF");
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                log.warn((Object)("Failed to defer reset motion detection for device with lanDeviceId=" + device.getLanDeviceId() + " to restore configuration procedure."));
            }
        }
    }

    private void resetAudioDetectionToDefault(LanDeviceEntity device, ProductEntity product) {
        UpdateSettingStatus updateSettingStatus;
        String currentVideoclip;
        log.debug((Object)("start resetAudioDetectionToDefault(device with lanDeviceId=" + device.getLanDeviceId() + ", product with productId=" + product.getProductId() + ")"));
        String audioDetectionForProduct = product.getProductFeatureValue(DeviceFeatureCode.ALARM);
        if (audioDetectionForProduct == null) {
            log.debug((Object)("There is no 'alarm' for product with productId=" + product.getProductId() + ". Audio detection for device wth lanDeviceId=" + device.getLanDeviceId() + " will not be reset."));
            return;
        }
        String currentAudioDetection = device.getParamValue("audio_detection");
        if (currentAudioDetection == null) {
            log.debug((Object)("Lan device with lanDeviceId=" + device.getLanDeviceId() + "does not have 'audio detection' param, nothing to do."));
            return;
        }
        if (!this.isNeedToChangeAudioDetection(currentAudioDetection, audioDetectionForProduct)) {
            log.debug((Object)("There is no need to reset audio detection for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has audio detection enabled and 'alarm' is disabled in the product. Audio detection will be reset."));
        String videoclipForProduct = product.getProductFeatureValue(DeviceFeatureCode.ALARM_VIDEORECORDING);
        if (videoclipForProduct == null) {
            log.debug((Object)("There is no 'alarm video clip' for product with productId=" + product.getProductId() + ". Videclip for device wth lanDeviceId=" + device.getLanDeviceId() + " will not be reset."));
        }
        if (videoclipForProduct != null && (currentVideoclip = device.getParamValue("alarm_video_clip")) != null && this.isNeedToChangeVideoclip(currentVideoclip, videoclipForProduct)) {
            device.getParam("alarm_video_clip").setValue("OFF");
        }
        if ((updateSettingStatus = this.updateLanDeviceParam(device.getLanDeviceId(), device.getUser().getId(), "audio_detection", "OFF")) != UpdateSettingStatus.SUCCESS) {
            log.debug((Object)("Failed to reset audio detection for device with lanDeviceId=" + device.getLanDeviceId() + ": " + updateSettingStatus + "."));
            log.debug((Object)("Reset audio detection for device with lanDeviceId=" + device.getLanDeviceId() + " will be done during restore configuration procedure."));
            device.getParam("audio_detection").setValue("OFF");
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                log.warn((Object)("Failed to defer reset audio detection for device with lanDeviceId=" + device.getLanDeviceId() + " to restore configuration procedure."));
            }
        }
    }

    private void resetPrivacyButtonToDefault(LanDeviceEntity device, ProductEntity product) {
        log.debug((Object)("start resetPrivacyButtonToDefault(device with lanDeviceId=" + device.getLanDeviceId() + ", product with productId=" + product.getProductId() + ")"));
        String privacyButtonForProduct = product.getProductFeatureValue(DeviceFeatureCode.PRIVACYBUTTON);
        if (privacyButtonForProduct == null) {
            log.debug((Object)("There is no 'privacy button' for product with productId=" + product.getProductId() + ". Privacy button for device wth lanDeviceId=" + device.getLanDeviceId() + " will not be reset."));
            return;
        }
        String currentPrivacyButton = device.getParamValue("privacy_button");
        if (currentPrivacyButton == null) {
            log.debug((Object)("Lan device with lanDeviceId=" + device.getLanDeviceId() + "does not have 'privacy button' param, nothing to do."));
            return;
        }
        if (!this.isNeedToChangePrivacyButton(currentPrivacyButton, privacyButtonForProduct)) {
            log.debug((Object)("There is no need to reset privacy button for device with lanDeviceId=" + device.getLanDeviceId() + "."));
            return;
        }
        log.debug((Object)("Device with lanDeviceId=" + device.getLanDeviceId() + " has privacy button disnabled and 'privacy button' is disabled in the product. Privacy button will be reset."));
        UpdateSettingStatus updateSettingStatus = this.updateLanDeviceParam(device.getLanDeviceId(), device.getUser().getId(), "privacy_button", "ON");
        if (updateSettingStatus != UpdateSettingStatus.SUCCESS) {
            log.debug((Object)("Failed to reset privacy button for device with lanDeviceId=" + device.getLanDeviceId() + ": " + updateSettingStatus + "."));
            log.debug((Object)("Reset privacy button for device with lanDeviceId=" + device.getLanDeviceId() + " will be done during restore configuration procedure."));
            device.getParam("privacy_button").setValue("ON");
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                log.warn((Object)("Failed to defer reset privacy button for device with lanDeviceId=" + device.getLanDeviceId() + " to restore configuration procedure."));
            }
        }
    }

    private boolean isNeedToDowngradeVideoQaulity(VideoQualityLevel currentQaulity, VideoQualityLevel otherQaulity) {
        log.trace((Object)("start isNeedToDowngradeVideoQaulity(currentQaulity=" + currentQaulity + ", otherQaulity=" + otherQaulity + ")"));
        if (currentQaulity.ordinal() == 1) {
            log.debug((Object)"Current video quality has the lowest rank. There is no need to downgrade video quality.");
            return false;
        }
        return currentQaulity.ordinal() - otherQaulity.ordinal() > 0;
    }

    private boolean isNeedToChangeIllumination(String currentIllumination, String illuminationAvailable) {
        log.debug((Object)("start isNeedToChangeIllumination(currentIllumination=" + currentIllumination + ", illuminationAvailable=" + illuminationAvailable + ")"));
        return illuminationAvailable.equalsIgnoreCase("OFF") && currentIllumination.equalsIgnoreCase("ON");
    }

    private boolean isNeedToChangeMotionDetection(String currentMotionDetection, String motionDetectionAvailable) {
        log.debug((Object)("start isNeedToChangeMotionDetection(currentMotionDetection=" + currentMotionDetection + ", motionDetectionAvailable=" + motionDetectionAvailable + ")"));
        return motionDetectionAvailable.equalsIgnoreCase("OFF") && currentMotionDetection.equalsIgnoreCase("ON");
    }

    private boolean isNeedToChangeAudioDetection(String currentAudioDetection, String audioDetectionAvailable) {
        log.debug((Object)("start isNeedToChangeAudioDetection(currentAudioDetection=" + currentAudioDetection + ", audioDetectionAvailable=" + audioDetectionAvailable + ")"));
        return audioDetectionAvailable.equalsIgnoreCase("OFF") && currentAudioDetection.equalsIgnoreCase("ON");
    }

    private boolean isNeedToChangeVideoclip(String currentVideoclip, String alarmVideoRecordingForProduct) {
        log.debug((Object)("start alarmVideoRecordingForProduct(currentVideoclip=" + currentVideoclip + ", alarmVideoRecordingForProduct=" + alarmVideoRecordingForProduct + ")"));
        Boolean availableForProduct = alarmVideoRecordingForProduct != null && !alarmVideoRecordingForProduct.equalsIgnoreCase("OFF");
        return availableForProduct == false && currentVideoclip.equalsIgnoreCase("ON");
    }

    private boolean isNeedToChangePrivacyButton(String currentPrivacyButton, String privacyButtonAvailable) {
        log.debug((Object)("start isNeedToChangeAudioDetection(currentPrivacyButton=" + currentPrivacyButton + ", privacyButtonAvailable=" + privacyButtonAvailable + ")"));
        return privacyButtonAvailable.equalsIgnoreCase("OFF") && currentPrivacyButton.equalsIgnoreCase("OFF");
    }

    @Transactional
    public UpdateDeviceProductResponse updateDeviceProduct(Integer lanDeviceId, DeviceProduct.DeviceProductType productType) throws InvalidSessionException {
        String templateCode;
        if (lanDeviceId == null) {
            return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.FAILED_INVALIDDEVICEID);
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceByIdAndUserId(lanDeviceId, this.authUtils.getCurrentUserId());
        if (device == null || device.getDeleted()) {
            return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.FAILED_NOTFOUNDDEVICE);
        }
        UpdateDeviceProductResponse response = this.updateDeviceProduct(device, productType);
        if (productType == DeviceProduct.DeviceProductType.TRIAL && response.getStatus() == UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS && (templateCode = this.productManagementService.getDeviceFeatureValue(lanDeviceId, DeviceFeatureCode.PRODUCT_WELCOME_EMAIL_TEMPLATE)) != null) {
            HashMap<String, String> placeholders = new HashMap<String, String>();
            placeholders.put("%CAMERANAME%", device.getName());
            placeholders.put("%EXPIRYDATE%", Utils.formatDate((Date)response.getValidTo(), (String)"yyyy-MM-dd"));
            this.emailNotificationService.sendEmail(device.getUser().toDTO(), templateCode, placeholders, null);
        }
        return response;
    }

    @Transactional
    public UpdateDeviceProductResponse updateDeviceProduct(LanDeviceEntity device, DeviceProduct.DeviceProductType productType) throws InvalidSessionException {
        log.trace((Object)("start updateDeviceProduct(device with lanDeviceId=" + device.getLanDeviceId() + ", productType=" + productType + ")"));
        if (productType == null) {
            return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.FAILED_INVALIDPRODUCTTYPE);
        }
        ProductEntity product = this.productManagementService.getProduct(device.getUser().getId(), productType);
        if (product == null) {
            return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.FAILED_NOTFOUNDPRODUCT);
        }
        DeviceProduct.DeviceProductType previousProductType = this.productManagementService.getDeviceProductType(device.getLanDeviceId());
        Date currentDate = this.systemSupport.getCurrentDate();
        if (productType == DeviceProduct.DeviceProductType.TRIAL) {
            Date trialValidTo = this.constructTrialValidTo(product.getProductId());
            if (trialValidTo == null) {
                log.warn((Object)("Calculated trial valid to date for device with lanDeviceId=" + device.getLanDeviceId() + " is null."));
                return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
            }
            device.setTrialProductDate(currentDate);
            device.setValidTo(trialValidTo);
        } else if (productType == DeviceProduct.DeviceProductType.PREMIUM) {
            Date premiumValidTo = this.constructPremiumValidTo(device);
            if (premiumValidTo == null) {
                log.warn((Object)("Calculated premium valid to date for device with lanDeviceId=" + device.getLanDeviceId() + " is null."));
                return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
            }
            device.setValidTo(premiumValidTo);
            if (device.getTrialProductDate() == null) {
                device.setTrialProductDate(currentDate);
            }
        }
        device.setProduct(product);
        device.setProductDate(currentDate);
        if (this.lanDeviceDAO.updateLanDevice(device) == null) {
            return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.ERROR);
        }
        this.productManagementService.logDeviceproduct(device.getLanDeviceId(), product.getProductId());
        return new UpdateDeviceProductResponse(UpdateDeviceProductResponse.UpdateDeviceProductStatus.SUCCESS, previousProductType, productType, product.getName(), device.getValidTo());
    }

    @Transactional
    public ErrorReportResponse checkLanDeviceAfterErrorReport(Integer lanDeviceId, String remoteAddress) throws InvalidSessionException {
        log.trace((Object)"checkLanDeviceAfterErrorReport");
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity device = this.getLanDeviceByIdWithAccessVerification(lanDeviceId);
        if (device == null) {
            log.warn((Object)("cannot find LD with id " + lanDeviceId));
            return new ErrorReportResponse(ErrorReportResponse.Status.FAILED);
        }
        String gatewayClientMacAddress = device.getGatewayClient().getMac();
        GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(gatewayClientMacAddress);
        if (gatewayDevice == null) {
            log.debug((Object)("GC " + gatewayClientMacAddress + " not connected, ignoring error report"));
        } else if (gatewayDevice.isEmbedded()) {
            log.debug((Object)("GC " + gatewayClientMacAddress + " is embedded, ignoring error report"));
        } else {
            this.updateIpAddress(device, false, true);
        }
        device = this.lanDeviceDAO.findLanDeviceById(device.getLanDeviceId(), true, true);
        LanDevice lanDevice = device.toDTO(this.gatewayDeviceConnection, this.deviceDriverFactory, true, true, true, this.videoStreamService, this.productManagementService, this.authUtils.getCurrentUserId());
        this.detectAndSetLocalIpAddress(remoteAddress, lanDevice);
        return new ErrorReportResponse(lanDevice);
    }

    @Transactional
    public ShareDeviceResponse shareLanDevice(Integer lanDeviceId, String email) throws InvalidSessionException {
        log.trace((Object)("start shareLanDevice(lanDeviceId=" + lanDeviceId + ", email=" + email + ")"));
        this.authUtils.ensureLoggedIn();
        if (lanDeviceId == null) {
            return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICEIDUNDEFINED);
        }
        if (email == null || email.trim().isEmpty()) {
            return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILUNDEFINED);
        }
        UserEntity donor = this.authUtils.getCurrentUser();
        LanDeviceEntity device = this.lanDeviceDAO.findLanDevice(lanDeviceId, donor.getId());
        if (device == null) {
            return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICENOTFOUND);
        }
        UserEntity recipient = null;
        try {
            recipient = this.userDAO.findUserByEmailAddress(email);
        }
        catch (RuntimeException re) {
            return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.ERROR);
        }
        if (recipient == null) {
            if (this.isDeviceShared(device, email)) {
                return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICESHAREDALREADY);
            }
            device.addShare(email);
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.ERROR);
            }
            if (!this.sendShareDeviceInvitation(email, donor, device)) {
                return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILPROBLEM);
            }
        } else {
            if (this.isDeviceShared(device, recipient)) {
                return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.FAILED_DEVICESHAREDALREADY);
            }
            device.addShare(recipient);
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.ERROR);
            }
            if (!this.sendShareDeviceNotification(recipient, donor, device)) {
                return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.FAILED_EMAILPROBLEM);
            }
        }
        return new ShareDeviceResponse(ShareDeviceResponse.ShareDeviceStatus.SUCCESS);
    }

    private boolean isDeviceShared(LanDeviceEntity device, String email) {
        for (ShareEntity share : device.getShares()) {
            if (share.getEmail() == null || !share.getEmail().equals(email)) continue;
            return true;
        }
        return false;
    }

    private boolean sendShareDeviceInvitation(String recipient, UserEntity donor, LanDeviceEntity device) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        EmailNotificationService.EmailCode emailCode = null;
        if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("camera")) {
            emailCode = EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_CAMERA;
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient);
        } else if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("NAS")) {
            emailCode = EmailNotificationService.EmailCode.SHARE_DEVICE_INVITATION_NAS;
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient);
        }
        return this.emailNotificationService.sendEmail(recipient, emailCode, donor.getLanguage(), placeholders, null);
    }

    private boolean isDeviceShared(LanDeviceEntity device, UserEntity user) {
        for (ShareEntity share : device.getShares()) {
            if (share.getUser() == null || !share.getUser().getId().equals(user.getId())) continue;
            return true;
        }
        return false;
    }

    private boolean sendShareDeviceNotification(UserEntity recipient, UserEntity donor, LanDeviceEntity device) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        EmailNotificationService.EmailCode emailCode = null;
        if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("camera")) {
            emailCode = EmailNotificationService.EmailCode.SHARE_DEVICE_CAMERA;
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient.getUsername());
        } else if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("NAS")) {
            emailCode = EmailNotificationService.EmailCode.SHARE_DEVICE_NAS;
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient.getUsername());
        }
        return this.emailNotificationService.sendEmail(recipient, emailCode, placeholders, null);
    }

    @Transactional
    public UnshareDeviceResponse unshareLanDevice(Integer lanDeviceId, String email) throws InvalidSessionException {
        log.trace((Object)("start unshareLanDevice(lanDeviceId=" + lanDeviceId + ", email=" + email + ")"));
        this.authUtils.ensureLoggedIn();
        if (lanDeviceId == null) {
            return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICEIDUNDEFINED);
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (device == null) {
            return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTFOUND);
        }
        UserEntity claimant = this.authUtils.getCurrentUser();
        if (this.isOwnerOfDevice(claimant, device)) {
            if (email == null || email.trim().isEmpty()) {
                return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILUNDEFINED);
            }
            UserEntity recipient = null;
            try {
                recipient = this.userDAO.findUserByEmailAddress(email);
            }
            catch (RuntimeException re) {
                return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.ERROR);
            }
            if (recipient == null) {
                if (!this.isDeviceShared(device, email)) {
                    return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTSHARED);
                }
                device.removeShare(email);
                if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                    return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.ERROR);
                }
                if (!this.sendUnshareDeviceNotification(email, claimant, device)) {
                    return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILPROBLEM);
                }
            } else {
                if (!this.isDeviceShared(device, recipient)) {
                    return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTSHARED);
                }
                device.removeShare(recipient);
                if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                    return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.ERROR);
                }
                if (!this.sendUnshareDeviceNotification(recipient, claimant, device)) {
                    return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_EMAILPROBLEM);
                }
            }
        } else {
            if (!this.isDeviceShared(device, claimant)) {
                return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.FAILED_DEVICENOTSHARED);
            }
            device.removeShare(claimant);
            if (this.lanDeviceDAO.updateLanDevice(device) == null) {
                return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.ERROR);
            }
        }
        return new UnshareDeviceResponse(UnshareDeviceResponse.UnshareDeviceStatus.SUCCESS);
    }

    private boolean isOwnerOfDevice(UserEntity user, LanDeviceEntity device) {
        return device.getUser().getId().equals(user.getId());
    }

    private boolean sendUnshareDeviceNotification(String recipient, UserEntity donor, LanDeviceEntity device) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        EmailNotificationService.EmailCode emailCode = null;
        if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("camera")) {
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient);
            emailCode = EmailNotificationService.EmailCode.UNSHARE_DEVICE_CAMERA;
        } else if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("NAS")) {
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient);
            emailCode = EmailNotificationService.EmailCode.UNSHARE_DEVICE_NAS;
        }
        return this.emailNotificationService.sendEmail(recipient, emailCode, donor.getLanguage(), placeholders, null);
    }

    private boolean sendUnshareDeviceNotification(UserEntity recipient, UserEntity donor, LanDeviceEntity device) {
        HashMap<String, String> placeholders = new HashMap<String, String>();
        EmailNotificationService.EmailCode emailCode = null;
        if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("camera")) {
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient.getUsername());
            emailCode = EmailNotificationService.EmailCode.UNSHARE_DEVICE_CAMERA;
        } else if (device.getDeviceDesc().getClassDevice().equalsIgnoreCase("NAS")) {
            placeholders.put("%USER_NAME%", String.valueOf(donor.getFirstname()) + " " + donor.getLastname());
            placeholders.put("%USER_EMAIL%", donor.getEmail());
            placeholders.put("%LANDEVICE_NAME%", device.getName());
            placeholders.put("%SHARE_EMAIL%", recipient.getUsername());
            emailCode = EmailNotificationService.EmailCode.UNSHARE_DEVICE_NAS;
        }
        return this.emailNotificationService.sendEmail(recipient, emailCode, placeholders, null);
    }

    @Transactional(readOnly=true)
    public DeviceSharedWithResponse getDeviceSharedWith(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start deviceSharedWith(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        if (lanDeviceId == null) {
            return new DeviceSharedWithResponse(DeviceSharedWithResponse.DeviceSharedWithStatus.FAILED_DEVICEIDUNDEFINED);
        }
        LanDeviceEntity device = this.lanDeviceDAO.findLanDevice(lanDeviceId, this.authUtils.getCurrentUserId());
        if (device == null) {
            return new DeviceSharedWithResponse(DeviceSharedWithResponse.DeviceSharedWithStatus.FAILED_DEVICENOTFOUND);
        }
        if (device.getShares() == null) {
            return new DeviceSharedWithResponse(DeviceSharedWithResponse.DeviceSharedWithStatus.ERROR);
        }
        ArrayList<DeviceShare> shares = new ArrayList<DeviceShare>();
        for (ShareEntity share : device.getShares()) {
            UserEntity user = share.getUser();
            if (user == null) {
                shares.add(new DeviceShare(share.getEmail(), null, share.getName()));
                continue;
            }
            shares.add(new DeviceShare(user.getEmail(), user.getId(), share.getName()));
        }
        return new DeviceSharedWithResponse(DeviceSharedWithResponse.DeviceSharedWithStatus.SUCCESS, shares);
    }

    @Transactional
    public LanDeviceEntity getLanDeviceByIdWithAccessVerification(Integer lanDeviceId) throws InvalidSessionException {
        log.trace((Object)("start getLanDeviceByIdWithAccessVerification(lanDeviceId=" + lanDeviceId + ")"));
        this.authUtils.ensureLoggedIn();
        LanDeviceEntity lanDevice = this.lanDeviceDAO.findLanDeviceById(lanDeviceId);
        if (this.authUtils.hasRole(AuthenticationUtils.Role.ADMIN)) {
            return lanDevice;
        }
        Integer currentUserId = this.authUtils.getCurrentUserId();
        if (lanDevice == null) {
            log.debug((Object)("exit getLanDeviceByIdWithAccessVerification(lanDeviceId=" + lanDeviceId + ") - not found lanDevice, returning null"));
            return null;
        }
        if (currentUserId.equals(lanDevice.getUser().getId())) {
            log.debug((Object)("exit getLanDeviceByIdWithAccessVerification(lanDeviceId=" + lanDeviceId + ") - lanDevice belongs to current user - returning lanDevice=" + lanDevice.toString()));
            return lanDevice;
        }
        if (lanDevice.getShares().isEmpty()) {
            log.debug((Object)("exit getLanDeviceByIdWithAccessVerification(lanDeviceId=" + lanDeviceId + ") - lanDevice does not belong to current and doesn't have shares - returning null"));
            return null;
        }
        for (ShareEntity share : lanDevice.getShares()) {
            if (!currentUserId.equals(share.getUser() != null ? share.getUser().getId() : null)) continue;
            log.debug((Object)("exit getLanDeviceByIdWithAccessVerification(lanDeviceId=" + lanDeviceId + ") - lanDevice shared with current user - returning lanDevice=" + lanDevice.toString()));
            return lanDevice;
        }
        log.trace((Object)("exit getLanDeviceByIdWithAccessVerification(lanDeviceId=" + lanDeviceId + ") - lanDevice does not belong to current and user_id not found in shares - returning null"));
        return null;
    }

    @Transactional(readOnly=true)
    public List<Account> getPairing(String mac) {
        List devices = this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac);
        log.debug((Object)("pairing details requested for LD " + mac));
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (LanDeviceEntity device : devices) {
            Account account = new Account();
            UserEntity user = device.getUser();
            account.setName(String.valueOf(this.getName(user.getFirstname())) + " " + this.getName(user.getLastname()));
            account.setEmail(user.getEmail());
            accounts.add(account);
        }
        Collections.sort(accounts, new AccountNameComparator());
        return accounts;
    }

    private String getName(String name) {
        return name == null ? "" : name.trim();
    }

    @Transactional
    public CancelPairingResponse cancelPairing(String mac, String email) {
        List devices = this.lanDeviceDAO.findNotDeletedLanDevicesByMac(mac);
        if (devices.isEmpty()) {
            log.debug((Object)("cannot cancel pairing for LD " + mac + ": no such lan device"));
            return new CancelPairingResponse(CancelPairingResponse.Status.ERROR);
        }
        LanDeviceEntity device = this.getDeviceBelongsToUser(devices, email);
        if (device == null) {
            log.debug((Object)("cannot cancel pairing for LD " + mac + ": no such lan device"));
            return new CancelPairingResponse(CancelPairingResponse.Status.ERROR);
        }
        RemoveResponse removeResponse = this.removeLanDevice(device);
        if (removeResponse.status != RemoveResponse.RemoveStatus.OK) {
            log.debug((Object)("cannot cancel pairing for LD " + mac + ": failed to delete device"));
            return new CancelPairingResponse(CancelPairingResponse.Status.ERROR);
        }
        return new CancelPairingResponse(CancelPairingResponse.Status.SUCCESS);
    }

    private LanDeviceEntity getDeviceBelongsToUser(List<LanDeviceEntity> devices, String email) {
        for (LanDeviceEntity device : devices) {
            if (!device.getUser().getEmail().equals(email)) continue;
            return device;
        }
        return null;
    }

    public HttpProxyVerificationResponse verifyHttpProxyConnection(String deviceId, int gcId, int ldId) throws InvalidSessionException {
        log.debug((Object)("starting HTTP proxy verification for device " + deviceId + ", gc " + gcId + ", LD " + ldId));
        this.authUtils.ensureLoggedIn();
        UserEntity user = this.authUtils.getCurrentUser();
        if (user == null) {
            log.debug((Object)"failed to get current user");
            return null;
        }
        GatewayClientEntity gatewayClient = this.gatewayClientDAO.findGatewayClientByMacAndUserId(deviceId, user.getId());
        if (gatewayClient == null) {
            log.debug((Object)("received HTTP proxy verification request from GC " + deviceId + " that doesn't belong to current user " + user.getId()));
            return null;
        }
        String address = null;
        short port = 0;
        if (ldId != 0) {
            LanDeviceEntity lanDevice = this.lanDeviceDAO.findLanDevice(Integer.valueOf(ldId), user.getId());
            if (lanDevice == null) {
                log.debug((Object)("LD " + ldId + " not found for user " + user.getId()));
                return null;
            }
            address = lanDevice.getIpAddress();
            port = lanDevice.getPort().shortValue();
        } else if (gcId != 0) {
            address = "127.0.0.1";
            port = 0;
        }
        return new HttpProxyVerificationResponse(address, port);
    }

    @Transactional
    public boolean updateLanDeviceParam(Integer deviceId, String name, String value, String remoteValue) {
        log.trace((Object)("start updateLanDeviceParam(deviceId=" + deviceId + ", name=" + name + ", value=" + value + ", remoteValue=" + remoteValue + ")"));
        LanDeviceEntity device = this.lanDeviceDAO.findLanDeviceById(deviceId);
        if (device == null) {
            log.trace((Object)("Not foud device with id=" + deviceId + "."));
            return false;
        }
        device.setParam(name, value, remoteValue);
        return this.lanDeviceDAO.updateLanDevice(device) != null;
    }

    @Transactional
    public AddedDevice addDevice(UserEntity user, AddDeviceRequest request) {
        log.trace((Object)("start addDevice(user=" + user.getId() + ", request=" + request + ")"));
        if (!this.isValid(request)) {
            throw new AddDeviceException(AddDeviceException.ErrorCode.NOT_SUPPORTED);
        }
        DeviceDescEntity deviceDesc = this.deviceDescDAO.findDeviceDesc(request.getDeviceClass(), request.getVendor(), request.getModel());
        if (deviceDesc == null) {
            throw new AddDeviceException(AddDeviceException.ErrorCode.NOT_SUPPORTED);
        }
        if (request.isGateway() || request.isCamera()) {
            GatewayDevice gatewayDevice = this.gatewayDeviceConnection.findById(request.getMac());
            if (gatewayDevice == null) {
                log.trace((Object)("Device " + request.getMac() + " is not connected"));
                throw new AddDeviceException(AddDeviceException.ErrorCode.GATEWAY_DISCONNECTED);
            }
            LanDeviceEntity foundDevice = this.lanDeviceDAO.findLNotDeletedByMacAndUserId(request.getMac(), user.getId());
            if (foundDevice != null) {
                log.debug((Object)("Device " + request.getMac() + " is registered aleready"));
                AddedDevice addedDevice = new AddedDevice();
                addedDevice.setDrivercode(deviceDesc.getDrivercode());
                addedDevice.setGcid(foundDevice.getGatewayClient().getGatewayClientId());
                addedDevice.setToken(foundDevice.getToken());
                return addedDevice;
            }
            GatewayClientEntity gatewayClient = new GatewayClientEntity();
            gatewayClient.setSerialNumber(gatewayDevice.getMac());
            gatewayClient.setMac(gatewayDevice.getMac());
            gatewayClient.setName(gatewayDevice.getMac());
            gatewayClient.setDeleted(false);
            gatewayClient.setUser(user);
            gatewayClient.setActivationDate(this.systemSupport.getCurrentDate());
            gatewayClient.setDeviceType(gatewayDevice.getDeviceType());
            gatewayClient.setVersion(gatewayDevice.getVersion());
            gatewayClient.setBuildNo(gatewayDevice.getBuildNo());
            LanDeviceEntity device = new LanDeviceEntity();
            device.setMac(request.getMac());
            device.setIpAddress("127.0.0.1");
            device.setPort(Integer.valueOf(request.isCamera() ? 80 : 7379));
            if (request.isGateway()) {
                device.setUsername("none");
                device.setPass("none");
            }
            device.setVideoEncoding("MJPEG");
            device.setDeleted(false);
            device.setGatewayClient(gatewayClient);
            device.setUser(user);
            device.setDeviceDesc(deviceDesc);
            device.setName(this.deviceNameGenerator.generate(user.getId(), request.getDeviceClass(), request.getMac()));
            device.setAddedDate(this.systemSupport.getCurrentDate());
            device.setDeleted(false);
            device.setReconfiguration(Boolean.valueOf(false));
            GenericLanDevice driver = null;
            if (request.getDeviceClass().equals("camera")) {
                log.debug((Object)"Registering device is a camera");
                driver = this.deviceDriverFactory.getDriver(request.getDeviceClass(), request.getVendor(), request.getModel());
                if (driver == null) {
                    log.warn((Object)("Not found driver to type=camera, vendor=" + request.getVendor() + ", model=" + request.getModel() + "."));
                    throw new AddDeviceException(AddDeviceException.ErrorCode.ERROR);
                }
                device.setParam("viewer_user", "viewer");
                device.setParam("viewer_pass", "viewer");
                device.setToken(UUID.randomUUID().toString());
            }
            ProductEntity product = this.productManagementService.getProduct(user.getId(), DeviceProduct.DeviceProductType.BASIC);
            device.setProduct(product);
            device.setProductDate(this.systemSupport.getCurrentDate());
            device.setValidTo(this.getYesterday());
            if (!this.configure(device, driver, request)) {
                log.warn((Object)("Failed to configure device: " + request));
                throw new AddDeviceException(AddDeviceException.ErrorCode.ERROR);
            }
            device.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
            this.lanDeviceDAO.store(device);
            AddedDevice addedDevice = new AddedDevice();
            addedDevice.setDrivercode(deviceDesc.getDrivercode());
            addedDevice.setGcid(gatewayClient.getGatewayClientId());
            addedDevice.setToken(device.getToken());
            if (request.getAppid() != null) {
                addedDevice.setAppcode(this.getAppCode(request.getAppid()));
            }
            this.connector.setRegistered(device.getGatewayClient().getMac(), true);
            String commServerUrl = this.connector.getVeryfiedServerUrl(device.getGatewayClient().getMac());
            if (commServerUrl == null) {
                log.warn((Object)("Got null commServerUrl for just registered device " + device.getGatewayClient().getMac() + "."));
            }
            this.gatewayClientService.updateGatewayClientStatus(device.getGatewayClient().getMac(), true, commServerUrl);
            this.gatewayClientService.setUpUpnpForwarding(device.getMac(), device.getGatewayClient().getUpnpPort());
            this.gatewayClientService.setUpLocalIpDomain(device.getMac(), gatewayDevice.getLocalIpAddress());
            log.debug((Object)("returning added device: " + addedDevice));
            return addedDevice;
        }
        if (request.isSwitch()) {
            AddedDevice addedDevice = new AddedDevice();
            addedDevice.setDrivercode(deviceDesc.getDrivercode());
            if (request.getAppid() != null) {
                addedDevice.setAppcode(this.getAppCode(request.getAppid()));
            }
            return addedDevice;
        }
        log.warn((Object)("Unsupported device class " + request.getDeviceClass()));
        throw new AddDeviceException(AddDeviceException.ErrorCode.ERROR);
    }

    private boolean isValid(AddDeviceRequest request) {
        return request.getDeviceClass().equals("gateway") || request.getDeviceClass().equals("camera") || request.getDeviceClass().equals("switch");
    }

    private boolean isGatewayRegistered(UserEntity user, AddDeviceRequest request) {
        return this.gatewayClientDAO.findGatewayClientByMacAndUserId(request.getMac(), user.getId()) != null;
    }

    private boolean isDeviceRegistered(UserEntity user, AddDeviceRequest request) {
        return this.lanDeviceDAO.findLNotDeletedByMacAndUserId(request.getMac(), user.getId()) != null;
    }

    private Date getYesterday() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.add(5, -1);
        return cal.getTime();
    }

    private boolean configure(LanDeviceEntity device, GenericLanDevice driver, AddDeviceRequest request) throws AddDeviceException {
        if (driver != null) {
            log.info((Object)("Start of configuration device with mac=" + device.getMac() + " and with driver " + driver.getClass()));
            AccessVerificationStatus accessVerificationStatus = driver.verify(device);
            if (accessVerificationStatus != AccessVerificationStatus.OK) {
                log.info((Object)("Can not access to device with mac=" + device.getMac() + ": " + accessVerificationStatus));
                return false;
            }
            GenericLanDevice.ConfigurationStatus configurationStatus = driver.init(device, device.getPass());
            if (configurationStatus != GenericLanDevice.ConfigurationStatus.OK) {
                log.info((Object)("Failed t oconfigure device with mac=" + device.getMac() + ": " + configurationStatus));
                return false;
            }
        }
        return true;
    }

    private String getAppCode(String appId) {
        try {
            ApplicationEntity entity = this.applicationDAO.getApplicationById(Integer.valueOf(appId));
            if (entity == null) {
                throw new AddDeviceException(AddDeviceException.ErrorCode.APP_NOT_FOUND);
            }
            return entity.getCode();
        }
        catch (NumberFormatException ex) {
            throw new AddDeviceException(AddDeviceException.ErrorCode.APP_NOT_FOUND);
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus() {
        if ($SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus != null) {
            return $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus;
        }
        int[] nArray = new int[AccessVerificationStatus.values().length];
        try {
            nArray[AccessVerificationStatus.ERROR.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.NOACCESS.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.NOANSWER.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.NOT_SUPPORTED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[AccessVerificationStatus.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$restserver$rest$response$AccessVerificationStatus = nArray;
        return nArray;
    }

    static /* synthetic */ Logger access$1() {
        return log;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$restserver$rest$response$VerifyGcResponse$VerifyGcStatus() {
        if ($SWITCH_TABLE$pl$smartapps$restserver$rest$response$VerifyGcResponse$VerifyGcStatus != null) {
            return $SWITCH_TABLE$pl$smartapps$restserver$rest$response$VerifyGcResponse$VerifyGcStatus;
        }
        int[] nArray = new int[VerifyGcResponse.VerifyGcStatus.values().length];
        try {
            nArray[VerifyGcResponse.VerifyGcStatus.ERROR.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[VerifyGcResponse.VerifyGcStatus.FAILED_ANOTHERACCOUNTASSIGNED.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[VerifyGcResponse.VerifyGcStatus.FAILED_CODEINCORRECT.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED_TRYINSTALL.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[VerifyGcResponse.VerifyGcStatus.SUCCESS.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$restserver$rest$response$VerifyGcResponse$VerifyGcStatus = nArray;
        return nArray;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$pl$smartapps$containerserver$landevice$GenericLanDevice$ConfigurationStatus() {
        if ($SWITCH_TABLE$pl$smartapps$containerserver$landevice$GenericLanDevice$ConfigurationStatus != null) {
            return $SWITCH_TABLE$pl$smartapps$containerserver$landevice$GenericLanDevice$ConfigurationStatus;
        }
        int[] nArray = new int[GenericLanDevice.ConfigurationStatus.values().length];
        try {
            nArray[GenericLanDevice.ConfigurationStatus.ERROR.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GenericLanDevice.ConfigurationStatus.FAILED.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GenericLanDevice.ConfigurationStatus.MANUAL.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[GenericLanDevice.ConfigurationStatus.OK.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$pl$smartapps$containerserver$landevice$GenericLanDevice$ConfigurationStatus = nArray;
        return nArray;
    }
}

