/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.vestiacom.gdserver.rest.response.GatewayDevice;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.containerserver.landevice.GenericLanDevice;
import pl.smartapps.hm.WebViewer.shared.model.ActivateCameraResponse;
import pl.smartapps.hm.WebViewer.shared.model.DeviceFeatureCode;
import pl.smartapps.hm.WebViewer.shared.model.DeviceProduct;
import pl.smartapps.hm.WebViewer.shared.model.GatewayClient;
import pl.smartapps.hm.WebViewer.shared.model.LDEventType;
import pl.smartapps.hm.WebViewer.shared.model.LanDevice;
import pl.smartapps.hm.WebViewer.shared.model.UserFeatureCode;
import pl.smartapps.restserver.db.main.DeviceDescEntity;
import pl.smartapps.restserver.db.main.FeatureEntity;
import pl.smartapps.restserver.db.main.GatewayClientEntity;
import pl.smartapps.restserver.db.main.LanDeviceEntity;
import pl.smartapps.restserver.db.main.LanDeviceParamEntity;
import pl.smartapps.restserver.db.main.ProductEntity;
import pl.smartapps.restserver.db.main.ProductfeatureEntity;
import pl.smartapps.restserver.db.main.UserEntity;
import pl.smartapps.restserver.rest.response.AccessVerificationStatus;
import pl.smartapps.restserver.rest.response.VerifyGcResponse;
import pl.smartapps.restserver.rest.response.VideoStreamParamsResponse;
import pl.smartapps.restserver.service.ParameterService;
import pl.smartapps.restserver.service.ext.LanDeviceServiceExt;
import pl.smartapps.restserver.service.impl.LanDeviceServiceActivateCameraTests;
import pl.smartapps.restserver.service.impl.LanDeviceServiceImpl;
import pl.smartapps.restserver.service.impl.LanDeviceServiceInternal;
import pl.smartapps.restserver.test.rest.TestDataUtils;
import pl.smartapps.restserver.test.rest.Utils;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={LanDeviceServiceImpl.class})
public class LanDeviceServiceActivateCameraTests
extends LanDeviceServiceInternal {
    @Test
    public void testActivateNewCameraWithTrialProductAndWithoutDeviceLimitInMiddleOfMonthWithOneMonthPeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        Date validTo = Utils.constructDate((int)2011, (int)10, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        1 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        2 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setTrialProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(currentDate);
        deviceEntityToSaved.setTrialProductDate(currentDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithTrialProductAndWithoutDeviceLimitInLastDayOfMonthWithOneMonthPeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)3, (int)31, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        Date validTo = Utils.constructDate((int)2011, (int)4, (int)30, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        3 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        4 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setTrialProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(currentDate);
        deviceEntityToSaved.setTrialProductDate(currentDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithTrialProductAndWithoutDeviceLimitInMiddleOfMonthWithOneDayPeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1d");
        Date validTo = Utils.constructDate((int)2011, (int)9, (int)17, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        5 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        6 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setTrialProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(currentDate);
        deviceEntityToSaved.setTrialProductDate(currentDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithTrialProductAndWithoutDeviceLimitInLastDayOfMonthWithOneDayPeriod() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)3, (int)31, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1d");
        Date validTo = Utils.constructDate((int)2011, (int)4, (int)1, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        7 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        8 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setTrialProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(currentDate);
        deviceEntityToSaved.setTrialProductDate(currentDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithTrialProductIncorrectValidityPeriodValue() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"a1d");
        Date validTo = Utils.constructDate((int)2011, (int)10, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        9 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(1);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(1);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    public void testActivateNewCameraWithTrialProductIncorrectValidityPeriodUnit() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(1);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(1), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1S");
        Date validTo = Utils.constructDate((int)2011, (int)10, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        10 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(1);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(1);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithBasicProductAndWithoutDeviceLimitSuccessfully() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date newValidToDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        ProductfeatureEntity maxVideoQualityFeature = new ProductfeatureEntity();
        maxVideoQualityFeature.setFeature(new FeatureEntity(Integer.valueOf(1), DeviceFeatureCode.MAX_VIDEO_QUALITY.name(), ""));
        maxVideoQualityFeature.setFeatureValue("MODERATE");
        HashSet<ProductfeatureEntity> productfeatures = new HashSet<ProductfeatureEntity>();
        productfeatures.add(maxVideoQualityFeature);
        product.setProductfeatures(productfeatures);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        11 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(newValidToDate);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(null);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        12 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(newValidToDate);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setTrialProductDate(null);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(newValidToDate);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(currentDate);
        deviceEntityToSaved.setTrialProductDate(null);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivatePreviouslyDeletedCameraWithBasicProductAssignedAndAleradyUsedTrialProductWithBasicProductAndWithoutDeviceLimitSuccessfully() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        LanDeviceEntity foundDevice = new LanDeviceEntity();
        foundDevice.setMac("00:02:D1:06:CD:80");
        foundDevice.setIpAddress("127.0.0.1");
        foundDevice.setPort(Integer.valueOf(80));
        foundDevice.setDeleted(false);
        foundDevice.setUsername("root");
        foundDevice.setPass("rootPass");
        foundDevice.setValidTo(null);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        foundDevice.setProduct(product);
        Date productDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setProductDate(productDate);
        Date productTrialDate = Utils.constructDate((int)2011, (int)6, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setTrialProductDate(productTrialDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        13 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(null);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(productDate);
        deviceEntity.setTrialProductDate(productTrialDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        14 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(null);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(productDate);
        deviceEntityToSave.setTrialProductDate(productTrialDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(null);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(productDate);
        deviceEntityToSaved.setTrialProductDate(productTrialDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivatePrevouslyDeletedCameraWithBasicProductAssignedAndNeverUsedTrialProductWithTrialProductAndWithoutDeviceLimitSuccessfully() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate).times(2);
        LanDeviceEntity foundDevice = new LanDeviceEntity();
        foundDevice.setMac("00:02:D1:06:CD:80");
        foundDevice.setIpAddress("127.0.0.1");
        foundDevice.setPort(Integer.valueOf(80));
        foundDevice.setDeleted(false);
        foundDevice.setUsername("root");
        foundDevice.setPass("rootPass");
        foundDevice.setValidTo(null);
        ProductEntity alreadyAssignedProduct = new ProductEntity(Integer.valueOf(1));
        foundDevice.setProduct(alreadyAssignedProduct);
        Date alreadyAssignedProductDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setProductDate(alreadyAssignedProductDate);
        foundDevice.setTrialProductDate(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity trialProduct = new ProductEntity(Integer.valueOf(2));
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.TRIAL)).andReturn((Object)trialProduct);
        EasyMock.expect((Object)this.productManagementService.getFeatureValue(Integer.valueOf(2), DeviceFeatureCode.LANDEVICE_VALIDITY)).andReturn((Object)"1m");
        Date validTo = Utils.constructDate((int)2011, (int)10, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        15 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(trialProduct);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setTrialProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        16 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(trialProduct);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setTrialProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(trialProduct);
        deviceEntityToSaved.setProductDate(currentDate);
        deviceEntityToSaved.setTrialProductDate(currentDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(2));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivatePreviouslyDeletedCameraWithBasicProductAssignedAndAleradyUsedTrialProductWithTrialProductAndWithoutDeviceLimitSuccessfully() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        LanDeviceEntity foundDevice = new LanDeviceEntity();
        foundDevice.setMac("00:02:D1:06:CD:80");
        foundDevice.setIpAddress("127.0.0.1");
        foundDevice.setPort(Integer.valueOf(80));
        foundDevice.setDeleted(false);
        foundDevice.setUsername("root");
        foundDevice.setPass("rootPass");
        foundDevice.setValidTo(null);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        foundDevice.setProduct(product);
        Date productDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setProductDate(productDate);
        Date trialProductDate = Utils.constructDate((int)2011, (int)5, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setTrialProductDate(trialProductDate);
        Date productTrialDate = Utils.constructDate((int)2011, (int)6, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setTrialProductDate(productTrialDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        17 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(null);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(productDate);
        deviceEntity.setTrialProductDate(productTrialDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        18 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(null);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(productDate);
        deviceEntityToSave.setTrialProductDate(productTrialDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(null);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(productDate);
        deviceEntityToSaved.setTrialProductDate(productTrialDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivatePreviouslyDeletedCameraWithTrialProductAssignedAndAleradyUsedTrialProductWithTrialProductAndWithoutDeviceLimitSuccessfully() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        LanDeviceEntity foundDevice = new LanDeviceEntity();
        foundDevice.setMac("00:02:D1:06:CD:80");
        foundDevice.setIpAddress("127.0.0.1");
        foundDevice.setPort(Integer.valueOf(80));
        foundDevice.setDeleted(false);
        foundDevice.setUsername("root");
        foundDevice.setPass("rootPass");
        Date validTo = Utils.constructDate((int)2011, (int)10, (int)16, (int)14, (int)11, (int)6);
        foundDevice.setValidTo(validTo);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        foundDevice.setProduct(product);
        Date productDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setProductDate(productDate);
        Date trialProductDate = Utils.constructDate((int)2011, (int)5, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setTrialProductDate(trialProductDate);
        Date productTrialDate = Utils.constructDate((int)2011, (int)6, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setTrialProductDate(productTrialDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        19 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(productDate);
        deviceEntity.setTrialProductDate(productTrialDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        20 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(productDate);
        deviceEntityToSave.setTrialProductDate(productTrialDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(productDate);
        deviceEntityToSaved.setTrialProductDate(productTrialDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", true, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateAlreadyRegistredToCurrentUserCameraWithBasicProductAssignedAndAleradyUsedTrialProductWithBasicProductAndWithoutDeviceLimitSuccessfully() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        LanDeviceEntity deviceRegisteredToCurrentUser = new LanDeviceEntity();
        deviceRegisteredToCurrentUser.setLanDeviceId(Integer.valueOf(1));
        deviceRegisteredToCurrentUser.setName("Camera #1");
        deviceRegisteredToCurrentUser.setMac("00:02:D1:06:CD:80");
        deviceRegisteredToCurrentUser.setIpAddress("127.0.0.1");
        deviceRegisteredToCurrentUser.setLanDeviceId(Integer.valueOf(1));
        deviceRegisteredToCurrentUser.setUser(new UserEntity(Integer.valueOf(1)));
        ProductEntity productAlreadyAssigned = new ProductEntity(Integer.valueOf(1));
        productAlreadyAssigned.setProductfeatures(new HashSet());
        deviceRegisteredToCurrentUser.setLanDeviceParams(new ArrayList());
        deviceRegisteredToCurrentUser.setProduct(productAlreadyAssigned);
        GatewayClientEntity gce = new GatewayClientEntity();
        gce.setSerialNumber("00:02:D1:06:CD:80");
        gce.setMac("00:02:D1:06:CD:80");
        gce.setName("00:02:D1:06:CD:80");
        gce.setDeleted(false);
        gce.setDeviceType(Integer.valueOf(16));
        deviceRegisteredToCurrentUser.setGatewayClient(gce);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(deviceRegisteredToCurrentUser)).andReturn(null);
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.PATHNOTFOUND));
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)deviceRegisteredToCurrentUser);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(2);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11));
        gatewayClientEntity.setConnectedDate(Utils.constructDate((int)2011, (int)8, (int)16, (int)14, (int)11, (int)6));
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(gatewayClientEntity);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:06:CD:80")).andReturn(clients);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        LanDeviceEntity foundDevice = new LanDeviceEntity();
        foundDevice.setLanDeviceId(Integer.valueOf(1));
        foundDevice.setName("Camera #1");
        foundDevice.setMac("00:02:D1:06:CD:80");
        foundDevice.setIpAddress("127.0.0.1");
        foundDevice.setPort(Integer.valueOf(80));
        foundDevice.setDeleted(false);
        foundDevice.setUsername("root");
        foundDevice.setPass("rootPass");
        foundDevice.setValidTo(null);
        foundDevice.setUser(new UserEntity(Integer.valueOf(1)));
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        foundDevice.setProduct(product);
        Date productDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setProductDate(productDate);
        Date productTrialDate = Utils.constructDate((int)2011, (int)6, (int)15, (int)14, (int)11, (int)6);
        foundDevice.setTrialProductDate(productTrialDate);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setStatus(GatewayClient.GatewayClientStatus.CONNECTED);
        gatewayClient.setPublicIpAddress("0.0.0.0.");
        gatewayClient.setUpnpPort(Integer.valueOf(0));
        gatewayClient.setUpnpReason("none");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setName("Camera #1");
        device.setLanDeviceId(Integer.valueOf(1));
        device.setRecording(Boolean.valueOf(false));
        device.setReconfiguration(Boolean.valueOf(true));
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(false));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setHasLedControl(Boolean.valueOf(false));
        device.setHasPrivacyButtonControl(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setGatewayClient(gatewayClient);
        DeviceProduct dp = new DeviceProduct();
        dp.setProductId(Integer.valueOf(1));
        dp.setType(DeviceProduct.DeviceProductType.BASIC);
        device.setProduct(dp);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setLanDeviceParams(new ArrayList());
        device.setDeleted(Boolean.valueOf(false));
        21 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(2);
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setLanDeviceId(Integer.valueOf(1));
        deviceEntity.setName("Camera #1");
        deviceEntity.setReconfiguration(Boolean.valueOf(true));
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(null);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(productDate);
        deviceEntity.setTrialProductDate(productTrialDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        22 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(null);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(productDate);
        deviceEntityToSave.setTrialProductDate(productTrialDate);
        deviceEntityToSave.setReconfiguration(Boolean.valueOf(true));
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(1);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityWithoutParams = new LanDeviceEntity();
        deviceEntityWithoutParams.setLanDeviceId(Integer.valueOf(1));
        deviceEntityWithoutParams.setMac("00:02:D1:06:CD:80");
        deviceEntityWithoutParams.setIpAddress("127.0.0.1");
        deviceEntityWithoutParams.setPort(Integer.valueOf(80));
        deviceEntityWithoutParams.setDeleted(false);
        deviceEntityWithoutParams.setUsername("root");
        deviceEntityWithoutParams.setPass("rootPass");
        deviceEntityWithoutParams.setValidTo(null);
        deviceEntityWithoutParams.setProduct(product);
        deviceEntityWithoutParams.setProductDate(productDate);
        deviceEntityWithoutParams.setTrialProductDate(productTrialDate);
        deviceEntityWithoutParams.setLanDeviceParams(new ArrayList());
        deviceEntityWithoutParams.setGatewayClient(gatewayClientEntity);
        deviceEntityWithoutParams.setDeviceDesc(deviceDescEntity);
        deviceEntityWithoutParams.setAddedDate(addedDate);
        deviceEntityWithoutParams.setUser(user);
        deviceEntityWithoutParams.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityWithoutParams.setName("Camera #1");
        deviceEntityWithoutParams.setReconfiguration(Boolean.valueOf(true));
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityWithoutParams)).andReturn((Object)deviceEntityWithoutParams);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityWithoutParams)).andReturn((Object)deviceEntityWithoutParams);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityWithoutParams);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraGCVerificationError() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.ERROR, "", ""));
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, "ERROR", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraGCVerificationCodeIncorrect() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.FAILED_CODEINCORRECT, "", ""));
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, "FAILED_CODEINCORRECT", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_CODEINCORRECT);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraGCVerificationNotConnected() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.FAILED_NOTCONNECTED, "", ""));
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, null, null, "FAILED_NOTCONNECTED", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_NOTCONNECTED);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraDriverNotFound() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "FAILED", "Not found driver.");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraVerificationError() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.ERROR);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraNoAccess() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.NOACCESS);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.NOACCESS);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraNoAnswer() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.NOANSWER);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.NOANSWER);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraNotSupported() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)TestDataUtils.prepareUserEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.verify(device)).andReturn((Object)AccessVerificationStatus.NOT_SUPPORTED);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.NOTSUPPORTED);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraInitError() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date newValidToDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        ProductfeatureEntity maxVideoQualityFeature = new ProductfeatureEntity();
        maxVideoQualityFeature.setFeature(new FeatureEntity(Integer.valueOf(1), DeviceFeatureCode.MAX_VIDEO_QUALITY.name(), ""));
        maxVideoQualityFeature.setFeatureValue("MODERATE");
        HashSet<ProductfeatureEntity> productfeatures = new HashSet<ProductfeatureEntity>();
        productfeatures.add(maxVideoQualityFeature);
        product.setProductfeatures(productfeatures);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        23 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(newValidToDate);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.ERROR);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "ERROR", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraInitFailed() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date newValidToDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        ProductfeatureEntity maxVideoQualityFeature = new ProductfeatureEntity();
        maxVideoQualityFeature.setFeature(new FeatureEntity(Integer.valueOf(1), DeviceFeatureCode.MAX_VIDEO_QUALITY.name(), ""));
        maxVideoQualityFeature.setFeatureValue("MODERATE");
        HashSet<ProductfeatureEntity> productfeatures = new HashSet<ProductfeatureEntity>();
        productfeatures.add(maxVideoQualityFeature);
        product.setProductfeatures(productfeatures);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        Date validTo = newValidToDate;
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        24 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andReturn((Object)GenericLanDevice.ConfigurationStatus.FAILED);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "FAILED", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateManualCamera() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date newValidToDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        ProductfeatureEntity maxVideoQualityFeature = new ProductfeatureEntity();
        maxVideoQualityFeature.setFeature(new FeatureEntity(Integer.valueOf(1), DeviceFeatureCode.MAX_VIDEO_QUALITY.name(), ""));
        maxVideoQualityFeature.setFeatureValue("MODERATE");
        HashSet<ProductfeatureEntity> productfeatures = new HashSet<ProductfeatureEntity>();
        productfeatures.add(maxVideoQualityFeature);
        product.setProductfeatures(productfeatures);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        Date validTo = newValidToDate;
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        25 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        26 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        ArrayList<LanDeviceEntity> manualDevices = new ArrayList<LanDeviceEntity>();
        LanDeviceEntity manualDevice = new LanDeviceEntity();
        manualDevice.setMac("00:02:D1:06:CD:80");
        manualDevice.setIpAddress("127.0.0.1");
        manualDevice.setPort(Integer.valueOf(80));
        manualDevice.setDeleted(false);
        manualDevice.setValidTo(validTo);
        manualDevice.setProduct(product);
        manualDevice.setProductDate(currentDate);
        manualDevice.setLanDeviceParams(new ArrayList());
        manualDevice.setParam("viewer_user", "0002D106CD80");
        manualDevice.setParam("viewer_pass", "viewerPass");
        manualDevice.setParam("alarm_user", "1_alarmUser");
        manualDevice.setParam("alarm_pass", "alarmPass");
        manualDevice.setUsername("root");
        manualDevice.setPass("rootPass");
        manualDevice.setGatewayClient(gatewayClientEntity);
        manualDevice.setDeviceDesc(TestDataUtils.prepareDeviceDescEntity());
        manualDevices.add(manualDevice);
        this.authUtils.storeData("manual_devices", manualDevices);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "MANUAL", null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.MANUAL);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraNotSaved() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date newValidToDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        ProductfeatureEntity maxVideoQualityFeature = new ProductfeatureEntity();
        maxVideoQualityFeature.setFeature(new FeatureEntity(Integer.valueOf(1), DeviceFeatureCode.MAX_VIDEO_QUALITY.name(), ""));
        maxVideoQualityFeature.setFeatureValue("MODERATE");
        HashSet<ProductfeatureEntity> productfeatures = new HashSet<ProductfeatureEntity>();
        productfeatures.add(maxVideoQualityFeature);
        product.setProductfeatures(productfeatures);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        Date validTo = newValidToDate;
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        27 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        28 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "ERROR", "Lan device has not been stored in database.");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithMacBasedActivationFeatureSuccessful() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "89.186.27.139", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn((Object)"ON");
        EasyMock.expect((Object)this.authUtils.getClientIpAddress()).andReturn((Object)"89.186.27.139");
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date newValidToDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        ProductfeatureEntity maxVideoQualityFeature = new ProductfeatureEntity();
        maxVideoQualityFeature.setFeature(new FeatureEntity(Integer.valueOf(1), DeviceFeatureCode.MAX_VIDEO_QUALITY.name(), ""));
        maxVideoQualityFeature.setFeatureValue("MODERATE");
        HashSet<ProductfeatureEntity> productfeatures = new HashSet<ProductfeatureEntity>();
        productfeatures.add(maxVideoQualityFeature);
        product.setProductfeatures(productfeatures);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        Date validTo = newValidToDate;
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn(null);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        29 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        30 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraWithMacBasedActivationFeatureFailure() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "89.186.27.139", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn((Object)"ON");
        EasyMock.expect((Object)this.authUtils.getClientIpAddress()).andReturn((Object)"89.186.27.140");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_ACTIVATIONOUTSIDEDEVICELOCALNETWORK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraSuccessfulWithDeviceLimit() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        Date currentDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        Date newValidToDate = Utils.constructDate((int)2011, (int)9, (int)15, (int)14, (int)11, (int)6);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.parameterService.getBoolParameterValue(ParameterService.ParameterCode.LANDEVICE_DISABLE_ROOT_PASS_GENERATION)).andReturn((Object)false);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        ProductEntity product = new ProductEntity(Integer.valueOf(1));
        ProductfeatureEntity maxVideoQualityFeature = new ProductfeatureEntity();
        maxVideoQualityFeature.setFeature(new FeatureEntity(Integer.valueOf(1), DeviceFeatureCode.MAX_VIDEO_QUALITY.name(), ""));
        maxVideoQualityFeature.setFeatureValue("MODERATE");
        HashSet<ProductfeatureEntity> productfeatures = new HashSet<ProductfeatureEntity>();
        productfeatures.add(maxVideoQualityFeature);
        product.setProductfeatures(productfeatures);
        EasyMock.expect((Object)this.productManagementService.getProduct(Integer.valueOf(1), DeviceProduct.DeviceProductType.BASIC)).andReturn((Object)product);
        Date validTo = newValidToDate;
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"5");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)4L);
        ArrayList foundDevices = new ArrayList();
        EasyMock.expect((Object)this.lanDeviceDAO.findAllLanDevicesByMac("00:02:D1:06:CD:80")).andReturn(foundDevices);
        GatewayClient gatewayClient = new GatewayClient();
        gatewayClient.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClient.setMac("00:02:D1:06:CD:80");
        gatewayClient.setName("00:02:D1:06:CD:80");
        gatewayClient.setDeleted(Boolean.valueOf(false));
        gatewayClient.setDeviceType(Integer.valueOf(16));
        LanDevice device = new LanDevice();
        device.setGatewayClient(gatewayClient);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        device.setMac("00:02:D1:06:CD:80");
        device.setIpAddress("127.0.0.1");
        device.setDeleted(Boolean.valueOf(false));
        31 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user).times(3);
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(3);
        GatewayClientEntity gatewayClientEntity = new GatewayClientEntity();
        gatewayClientEntity.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntity.setMac("00:02:D1:06:CD:80");
        gatewayClientEntity.setName("00:02:D1:06:CD:80");
        gatewayClientEntity.setDeleted(false);
        gatewayClientEntity.setUser(user);
        gatewayClientEntity.setActivationDate(addedDate);
        gatewayClientEntity.setDeviceType(Integer.valueOf(16));
        gatewayClientEntity.setVersion("0.0");
        gatewayClientEntity.setBuildNo(Integer.valueOf(0));
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("127.0.0.1");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setValidTo(validTo);
        deviceEntity.setProduct(product);
        deviceEntity.setProductDate(currentDate);
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setUsername("root");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"rootPass");
        deviceEntity.setPass("rootPass");
        deviceEntity.setGatewayClient(gatewayClientEntity);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        32 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "")).andAnswer((IAnswer)initAnswer);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        GatewayClientEntity gatewayClientEntityToSave = new GatewayClientEntity();
        gatewayClientEntityToSave.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setMac("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setName("00:02:D1:06:CD:80");
        gatewayClientEntityToSave.setDeleted(false);
        gatewayClientEntityToSave.setUser(user);
        gatewayClientEntityToSave.setActivationDate(addedDate);
        gatewayClientEntityToSave.setDeviceType(Integer.valueOf(16));
        gatewayClientEntityToSave.setVersion("0.0");
        gatewayClientEntityToSave.setBuildNo(Integer.valueOf(0));
        gatewayClientEntityToSave.setConnectedDate(gatewayDeviceConnecedDate);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("127.0.0.1");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setValidTo(validTo);
        deviceEntityToSave.setProduct(product);
        deviceEntityToSave.setProductDate(currentDate);
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(gatewayClientEntityToSave);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        EasyMock.expect((Object)this.lanDeviceDAO.findMaxCameraIndex(Integer.valueOf(1), "")).andReturn((Object)0.0);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)0L);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(2);
        deviceEntityToSave.setName("Camera #1");
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("127.0.0.1");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(validTo);
        deviceEntityToSaved.setProduct(product);
        deviceEntityToSaved.setProductDate(currentDate);
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSaved.setParam("viewer_pass", "viewerPass");
        deviceEntityToSaved.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSaved.setParam("alarm_pass", "alarmPass");
        deviceEntityToSaved.setGatewayClient(gatewayClientEntity);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.saveLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "127.0.0.1", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        this.productManagementService.logDeviceproduct(Integer.valueOf(1), Integer.valueOf(1));
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraDeviceLimitReached() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"5");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)5L);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_REACHEDMAXDEVICECOUNT);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateNewCameraDeviceLimitExceed() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        Date gatewayDeviceConnecedDate = Utils.constructDate((int)2011, (int)9, (int)16, (int)14, (int)11, (int)6);
        gatewayDevice.setConnectedDate(gatewayDeviceConnecedDate);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn(null);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAX_DEVICE_COUNT)).andReturn((Object)"5");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.lanDeviceDAO.countNotDeletedLanDeviceByUserId(Integer.valueOf(1))).andReturn((Object)6L);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_REACHEDMAXDEVICECOUNT);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraAsignedToAnotherAccount() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        LanDeviceEntity anotherAccountCamera = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        anotherAccountCamera.setUser(new UserEntity(Integer.valueOf(2)));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)anotherAccountCamera);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", null, ActivateCameraResponse.CameraActivationStatus.FAILED_ANOTHERACCOUNTASSIGNED.name(), null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.FAILED_ANOTHERACCOUNTASSIGNED);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraAlreadyRegistredToCurrentUserDriverNotFound() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        GatewayClientEntity thisAccountGC = new GatewayClientEntity();
        thisAccountGC.setUser(new UserEntity(Integer.valueOf(1)));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(thisAccountGC);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:06:CD:80")).andReturn(clients);
        LanDeviceEntity thisAccountCamera = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        thisAccountCamera.setUser(new UserEntity(Integer.valueOf(1)));
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setProductfeatures(new HashSet());
        thisAccountCamera.setProduct(product);
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)thisAccountCamera);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "192.168.21.138", "FAILED", "Not found driver.");
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        GenericLanDevice driverForDto = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(thisAccountCamera)).andReturn((Object)driverForDto);
        EasyMock.expect((Object)driverForDto.isFirmwareUpToDate(thisAccountCamera)).andReturn((Object)true);
        EasyMock.expect((Object)driverForDto.getConnCheckUrl()).andReturn((Object)"/connCheck");
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        Assert.assertEquals((Object)expectedResponse, (Object)response);
        PowerMock.verifyAll();
    }

    @Test
    public void testActivateCameraAlreadyRegistredToCurrentUserSuccessful() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        GatewayClientEntity currentGatewayClient = new GatewayClientEntity();
        currentGatewayClient.setDeviceType(Integer.valueOf(16));
        currentGatewayClient.setUser(new UserEntity(Integer.valueOf(1)));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(currentGatewayClient);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:06:CD:80")).andReturn(clients);
        LanDeviceEntity currentDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        currentDeviceEntity.setUser(new UserEntity(Integer.valueOf(1)));
        currentDeviceEntity.setReconfiguration(Boolean.valueOf(true));
        ProductEntity product = new ProductEntity();
        product.setProductId(Integer.valueOf(1));
        product.setName("productName");
        product.setCode("productCode");
        product.setProductfeatures(new HashSet());
        currentDeviceEntity.setProduct(product);
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.productManagementService.getDeviceProductType(Integer.valueOf(1))).andReturn((Object)DeviceProduct.DeviceProductType.BASIC);
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)currentDeviceEntity);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(1);
        GenericLanDevice driverForDto = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(currentDeviceEntity)).andReturn((Object)driverForDto);
        EasyMock.expect((Object)driverForDto.isFirmwareUpToDate(currentDeviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driverForDto.getConnCheckUrl()).andReturn((Object)"/connCheck");
        Date currentDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        EasyMock.expect((Object)this.systemSupport.getCurrentDate()).andReturn((Object)currentDate);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)currentDate).times(2);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        LanDevice device = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        device.setReconfiguration(Boolean.valueOf(true));
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(true));
        device.setHasLedControl(Boolean.valueOf(true));
        device.setHasPrivacyButtonControl(Boolean.valueOf(true));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        DeviceProduct deviceProduct = new DeviceProduct();
        deviceProduct.setProductId(Integer.valueOf(1));
        deviceProduct.setName("productName");
        deviceProduct.setCode("productCode");
        deviceProduct.setType(DeviceProduct.DeviceProductType.BASIC);
        deviceProduct.setFeatures(new HashMap());
        device.setProduct(deviceProduct);
        device.setConnCheckUrl("/connCheck");
        33 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expectLastCall().times(2);
        GatewayClientEntity gatewayClientEntitySaved = new GatewayClientEntity();
        gatewayClientEntitySaved.setGatewayClientId(Integer.valueOf(1));
        gatewayClientEntitySaved.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setMac("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setName("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setDeleted(false);
        gatewayClientEntitySaved.setUser(null);
        gatewayClientEntitySaved.setActivationDate(currentDate);
        gatewayClientEntitySaved.setDeviceType(Integer.valueOf(16));
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setLanDeviceId(Integer.valueOf(1));
        deviceEntity.setName("TC5633-TCSW-0100h");
        deviceEntity.setLocation("Room No. 106");
        deviceEntity.setDescription("Vivotek camea in office");
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("192.168.21.138");
        deviceEntity.setVersion("TC5633-TCSW-0100h");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setReconfiguration(Boolean.valueOf(true));
        deviceEntity.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setGatewayClient(currentGatewayClient);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        34 initAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andAnswer((IAnswer)initAnswer);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSave.setName("TC5633-TCSW-0100h");
        deviceEntityToSave.setLocation("Room No. 106");
        deviceEntityToSave.setDescription("Vivotek camea in office");
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("192.168.21.138");
        deviceEntityToSave.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setReconfiguration(Boolean.valueOf(true));
        deviceEntityToSave.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(currentGatewayClient);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(currentDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityWithoutParams = new LanDeviceEntity();
        deviceEntityWithoutParams.setLanDeviceId(Integer.valueOf(1));
        deviceEntityWithoutParams.setName("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setLocation("Room No. 106");
        deviceEntityWithoutParams.setDescription("Vivotek camea in office");
        deviceEntityWithoutParams.setMac("00:02:D1:06:CD:80");
        deviceEntityWithoutParams.setIpAddress("192.168.21.138");
        deviceEntityWithoutParams.setVersion("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setPort(Integer.valueOf(80));
        deviceEntityWithoutParams.setDeleted(false);
        deviceEntityWithoutParams.setUsername("root");
        deviceEntityWithoutParams.setPass("rootPass");
        deviceEntityWithoutParams.setReconfiguration(Boolean.valueOf(true));
        deviceEntityWithoutParams.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityWithoutParams.setLanDeviceParams(new ArrayList());
        deviceEntityWithoutParams.setParam("viewer_user", "0002D106CD80");
        deviceEntityWithoutParams.setParam("viewer_pass", "viewerPass");
        deviceEntityWithoutParams.setParam("alarm_user", "1_alarmUser");
        deviceEntityWithoutParams.setParam("alarm_pass", "alarmPass");
        deviceEntityWithoutParams.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityWithoutParams.setGatewayClient(currentGatewayClient);
        deviceEntityWithoutParams.setDeviceDesc(deviceDescEntity);
        deviceEntityWithoutParams.setAddedDate(currentDate);
        deviceEntityWithoutParams.setUser(user);
        deviceEntityWithoutParams.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setName("TC5633-TCSW-0100h");
        deviceEntityToSaved.setLocation("Room No. 106");
        deviceEntityToSaved.setDescription("Vivotek camea in office");
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("192.168.21.138");
        deviceEntityToSaved.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSaved.setGatewayClient(currentGatewayClient);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(currentDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityWithoutParams)).andReturn((Object)deviceEntityWithoutParams);
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityToSave)).andReturn((Object)deviceEntityToSaved);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "192.168.21.138", "OK", null);
        this.gatewayClientService.setUpUpnpForwarding("00:02:D1:06:CD:80", null);
        ArrayList<LanDeviceEntity> correctDevices = new ArrayList<LanDeviceEntity>();
        correctDevices.add(deviceEntityToSaved);
        this.authUtils.storeData("correct_devices", correctDevices);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:1A:B6:00:0B:B5")).andReturn(null);
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.SUCCESS, ActivateCameraResponse.CameraActivationStatus.OK);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }

    public void testActivateCameraAlreadyRegistredToCurrentUserFailureRemoveOrphanParams() throws Exception {
        this.authUtils.ensureLoggedIn();
        this.authUtils.removeData("correct_devices");
        this.authUtils.removeData("manual_devices");
        EasyMock.expect((Object)this.gatewayClientService.verifyGatewayClient("aabo-cbyo-raaq", true)).andReturn((Object)new VerifyGcResponse(VerifyGcResponse.VerifyGcStatus.SUCCESS, "", ""));
        EasyMock.expect((Object)this.activationCodeHandler.getMacAddress("aabo-cbyo-raaq")).andReturn((Object)"00:02:D1:06:CD:80");
        GatewayDevice gatewayDevice = new GatewayDevice("00:02:D1:06:CD:80", "0.0.0.0.", "0.0.0.0", 0, 0, 0, 16);
        EasyMock.expect((Object)this.gatewayDeviceConnection.findById("00:02:D1:06:CD:80")).andReturn((Object)gatewayDevice);
        EasyMock.expect((Object)this.productManagementService.getUserFeatureValue(UserFeatureCode.MAC_BASED_ACTIVATION)).andReturn(null);
        GatewayClientEntity currentGatewayClient = new GatewayClientEntity();
        currentGatewayClient.setDeviceType(Integer.valueOf(16));
        currentGatewayClient.setUser(new UserEntity(Integer.valueOf(1)));
        ArrayList<GatewayClientEntity> clients = new ArrayList<GatewayClientEntity>();
        clients.add(currentGatewayClient);
        EasyMock.expect((Object)this.gatewayClientDAO.findGatewayClientsByMacAddress("00:02:D1:06:CD:80")).andReturn(clients);
        LanDeviceEntity currentDeviceEntity = TestDataUtils.prepareLanDeviceEntity((boolean)true, (boolean)true, (boolean)false);
        currentDeviceEntity.setUser(new UserEntity(Integer.valueOf(1)));
        currentDeviceEntity.setReconfiguration(Boolean.valueOf(true));
        EasyMock.expect((Object)this.videoStreamService.getVideoStreamPameters(Integer.valueOf(1), true)).andReturn((Object)new VideoStreamParamsResponse(VideoStreamParamsResponse.VideoStreamResponseStatus.OK));
        EasyMock.expect((Object)this.lanDeviceDAO.findNotDeletedLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)currentDeviceEntity);
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1).times(1);
        GenericLanDevice driverForDto = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver(currentDeviceEntity)).andReturn((Object)driverForDto);
        EasyMock.expect((Object)driverForDto.isFirmwareUpToDate(currentDeviceEntity)).andReturn((Object)true);
        EasyMock.expect((Object)driverForDto.getConnCheckUrl()).andReturn((Object)"/connCheck");
        Date addedDate = Utils.constructDate((int)2011, (int)7, (int)15, (int)7, (int)58, (int)11);
        PowerMock.expectNew(Date.class, (Object[])new Object[0]).andReturn((Object)addedDate).times(2);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverClassNameByMacPrefix("00:02:D1:06:CD:80")).andReturn((Object)"CameraVivotekGeneric");
        EasyMock.expect((Object)this.deviceDescDAO.findDeviceDescByDriverclass("CameraVivotekGeneric")).andReturn((Object)TestDataUtils.prepareDeviceDescEntity());
        GenericLanDevice driver = (GenericLanDevice)PowerMock.createMock(GenericLanDevice.class);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriver("CameraVivotekGeneric", false)).andReturn((Object)driver);
        LanDevice device = TestDataUtils.prepareLanDevice((boolean)true, (boolean)true, (boolean)true, (boolean)false);
        device.setReconfiguration(Boolean.valueOf(true));
        device.setHasHome(Boolean.valueOf(false));
        device.setHasPan(Boolean.valueOf(false));
        device.setHasTilt(Boolean.valueOf(false));
        device.setHasZoom(Boolean.valueOf(false));
        device.setHasIllumination(Boolean.valueOf(false));
        device.setHasMotionDetection(Boolean.valueOf(true));
        device.setHasLedControl(Boolean.valueOf(true));
        device.setHasPrivacyButtonControl(Boolean.valueOf(true));
        device.setHasAudioDetection(Boolean.valueOf(false));
        device.setNeedsRestartAfterNetworkChanges(Boolean.valueOf(false));
        device.setFirmwareUpToDate(Boolean.valueOf(true));
        device.setConnCheckUrl("/connCheck");
        35 verifyAnswer = new /* Unavailable Anonymous Inner Class!! */;
        EasyMock.expect((Object)driver.verify(device)).andAnswer((IAnswer)verifyAnswer);
        UserEntity user = TestDataUtils.prepareUserEntity();
        EasyMock.expect((Object)this.authUtils.getCurrentUser()).andReturn((Object)user);
        EasyMock.expectLastCall().times(2);
        GatewayClientEntity gatewayClientEntitySaved = new GatewayClientEntity();
        gatewayClientEntitySaved.setGatewayClientId(Integer.valueOf(1));
        gatewayClientEntitySaved.setSerialNumber("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setMac("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setName("00:02:D1:06:CD:80");
        gatewayClientEntitySaved.setDeleted(false);
        gatewayClientEntitySaved.setUser(null);
        gatewayClientEntitySaved.setActivationDate(addedDate);
        gatewayClientEntitySaved.setDeviceType(Integer.valueOf(16));
        LanDeviceEntity foundDevice = TestDataUtils.prepareLanDeviceEntity((boolean)false, (boolean)true, (boolean)false);
        EasyMock.expect((Object)this.lanDeviceDAO.findLatestLanDeviceByMac("00:02:D1:06:CD:80")).andReturn((Object)foundDevice);
        LanDeviceEntity deviceEntity = new LanDeviceEntity();
        deviceEntity.setLanDeviceId(Integer.valueOf(1));
        deviceEntity.setName("TC5633-TCSW-0100h");
        deviceEntity.setLocation("Room No. 106");
        deviceEntity.setDescription("Vivotek camea in office");
        deviceEntity.setMac("00:02:D1:06:CD:80");
        deviceEntity.setIpAddress("192.168.21.138");
        deviceEntity.setVersion("TC5633-TCSW-0100h");
        deviceEntity.setPort(Integer.valueOf(80));
        deviceEntity.setDeleted(false);
        deviceEntity.setUsername("root");
        deviceEntity.setPass("rootPass");
        deviceEntity.setReconfiguration(Boolean.valueOf(true));
        deviceEntity.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntity.setLanDeviceParams(new ArrayList());
        deviceEntity.setParam("viewer_user", "0002D106CD80");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"viewerPass");
        deviceEntity.setParam("viewer_pass", "viewerPass");
        EasyMock.expect((Object)this.authUtils.getCurrentUserId()).andReturn((Object)1);
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmUser");
        deviceEntity.setParam("alarm_user", "1_alarmUser");
        EasyMock.expect((Object)this.passwordGenerator.generate(10)).andReturn((Object)"alarmPass");
        deviceEntity.setParam("alarm_pass", "alarmPass");
        deviceEntity.setGatewayClient(currentGatewayClient);
        DeviceDescEntity deviceDescEntity = TestDataUtils.prepareDeviceDescEntity();
        deviceEntity.setDeviceDesc(deviceDescEntity);
        EasyMock.expect((Object)this.deviceDriverFactory.getDriverByMacPrefix("00:02:D1:06:CD:80", false)).andReturn((Object)driver);
        EasyMock.expect((Object)driver.init(deviceEntity, "rootPass")).andReturn((Object)GenericLanDevice.ConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSave = new LanDeviceEntity();
        deviceEntityToSave.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSave.setName("TC5633-TCSW-0100h");
        deviceEntityToSave.setLocation("Room No. 106");
        deviceEntityToSave.setDescription("Vivotek camea in office");
        deviceEntityToSave.setMac("00:02:D1:06:CD:80");
        deviceEntityToSave.setIpAddress("192.168.21.138");
        deviceEntityToSave.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSave.setPort(Integer.valueOf(80));
        deviceEntityToSave.setDeleted(false);
        deviceEntityToSave.setUsername("root");
        deviceEntityToSave.setPass("rootPass");
        deviceEntityToSave.setReconfiguration(Boolean.valueOf(true));
        deviceEntityToSave.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSave.setLanDeviceParams(new ArrayList());
        deviceEntityToSave.setParam("viewer_user", "0002D106CD80");
        deviceEntityToSave.setParam("viewer_pass", "viewerPass");
        deviceEntityToSave.setParam("alarm_user", "1_alarmUser");
        deviceEntityToSave.setParam("alarm_pass", "alarmPass");
        deviceEntityToSave.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityToSave.setGatewayClient(currentGatewayClient);
        deviceEntityToSave.setDeviceDesc(deviceDescEntity);
        deviceEntityToSave.setAddedDate(addedDate);
        deviceEntityToSave.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityWithoutParams = new LanDeviceEntity();
        deviceEntityWithoutParams.setLanDeviceId(Integer.valueOf(1));
        deviceEntityWithoutParams.setName("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setLocation("Room No. 106");
        deviceEntityWithoutParams.setDescription("Vivotek camea in office");
        deviceEntityWithoutParams.setMac("00:02:D1:06:CD:80");
        deviceEntityWithoutParams.setIpAddress("192.168.21.138");
        deviceEntityWithoutParams.setVersion("TC5633-TCSW-0100h");
        deviceEntityWithoutParams.setPort(Integer.valueOf(80));
        deviceEntityWithoutParams.setDeleted(false);
        deviceEntityWithoutParams.setUsername("root");
        deviceEntityWithoutParams.setPass("rootPass");
        deviceEntityWithoutParams.setReconfiguration(Boolean.valueOf(true));
        deviceEntityWithoutParams.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityWithoutParams.setLanDeviceParams(new ArrayList());
        deviceEntityWithoutParams.setParam("viewer_user", "0002D106CD80");
        deviceEntityWithoutParams.setParam("viewer_pass", "viewerPass");
        deviceEntityWithoutParams.setParam("alarm_user", "1_alarmUser");
        deviceEntityWithoutParams.setParam("alarm_pass", "alarmPass");
        deviceEntityWithoutParams.setParam("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11");
        deviceEntityWithoutParams.setGatewayClient(currentGatewayClient);
        deviceEntityWithoutParams.setDeviceDesc(deviceDescEntity);
        deviceEntityWithoutParams.setAddedDate(addedDate);
        deviceEntityWithoutParams.setUser(user);
        deviceEntityWithoutParams.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        LanDeviceEntity deviceEntityToSaved = new LanDeviceEntity();
        deviceEntityToSaved.setLanDeviceId(Integer.valueOf(1));
        deviceEntityToSaved.setName("TC5633-TCSW-0100h");
        deviceEntityToSaved.setLocation("Room No. 106");
        deviceEntityToSaved.setDescription("Vivotek camea in office");
        deviceEntityToSaved.setMac("00:02:D1:06:CD:80");
        deviceEntityToSaved.setIpAddress("192.168.21.138");
        deviceEntityToSaved.setVersion("TC5633-TCSW-0100h");
        deviceEntityToSaved.setPort(Integer.valueOf(80));
        deviceEntityToSaved.setDeleted(false);
        deviceEntityToSaved.setUsername("root");
        deviceEntityToSaved.setPass("rootPass");
        deviceEntityToSaved.setValidTo(Utils.constructDate((int)2011, (int)9, (int)15, (int)10, (int)0, (int)0));
        deviceEntityToSaved.setLanDeviceParams(new ArrayList());
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_user", "0002D106CD80", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("viewer_pass", "NgbE78eBUB", null));
        deviceEntityToSaved.getLanDeviceParams().add(new LanDeviceParamEntity("dateLastCheckAddress", "2011-07-15 07:58:11", "2011-07-15 07:58:11"));
        deviceEntityToSaved.setGatewayClient(currentGatewayClient);
        deviceEntityToSaved.setDeviceDesc(deviceDescEntity);
        deviceEntityToSaved.setAddedDate(addedDate);
        deviceEntityToSaved.setUser(user);
        deviceEntityToSave.setConfigurationStatus(LanDevice.LanDeviceConfigurationStatus.OK);
        deviceEntityToSaved.setName("Camera #1");
        EasyMock.expect((Object)this.lanDeviceDAO.updateLanDeviceWithTransaction(deviceEntityWithoutParams)).andReturn(null);
        this.eventlogService.registerEventlog(LDEventType.CONFIGURE, "00:02:D1:06:CD:80", "192.168.21.138", "ERROR", "Lan device has not been stored in database.");
        PowerMock.replayAll((Object[])new Object[0]);
        ActivateCameraResponse expectedResponse = new ActivateCameraResponse(ActivateCameraResponse.ActivateStatus.ERROR);
        ActivateCameraResponse response = this.lanDeviceService.activateCamera("aabo-cbyo-raaq", false, LanDeviceServiceExt.DeviceType.Camera);
        PowerMock.verifyAll();
        Assert.assertEquals((Object)expectedResponse, (Object)response);
    }
}

