/*
 * Decompiled with CFR 0.152.
 */
package pl.smartapps.restserver.service.impl;

import com.notnoop.apns.ApnsService;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.api.easymock.PowerMock;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;
import pl.smartapps.restserver.db.dao.EventNotificationDAO;
import pl.smartapps.restserver.service.notification.impl.ApnsServiceFactory;
import pl.smartapps.restserver.service.notification.impl.InactiveAppleDeviceServiceImpl;

@RunWith(value=PowerMockRunner.class)
@PrepareForTest(value={InactiveAppleDeviceServiceImpl.class})
public class InactiveAppleDeviceServiceTests {
    private InactiveAppleDeviceServiceImpl appleDeviceService;
    private ApnsServiceFactory apnsServiceFactory;
    private EventNotificationDAO eventNotificationDAO;

    @Before
    public void setUp() {
        this.appleDeviceService = new InactiveAppleDeviceServiceImpl();
        this.apnsServiceFactory = (ApnsServiceFactory)PowerMock.createMock(ApnsServiceFactory.class);
        this.appleDeviceService.setApnsServiceFactory(this.apnsServiceFactory);
        this.eventNotificationDAO = (EventNotificationDAO)PowerMock.createMock(EventNotificationDAO.class);
        this.appleDeviceService.setEventNotificationDAO(this.eventNotificationDAO);
    }

    @Test
    public void testDeleteInactiveDevices() {
        ApnsService apnsService = (ApnsService)PowerMock.createMock(ApnsService.class);
        EasyMock.expect((Object)this.apnsServiceFactory.getInstance()).andReturn((Object)apnsService);
        apnsService.start();
        HashMap<String, Date> inactiveDevices = new HashMap<String, Date>();
        Date date = new Date();
        inactiveDevices.put("1", date);
        inactiveDevices.put("2", date);
        inactiveDevices.put("3", date);
        EasyMock.expect((Object)apnsService.getInactiveDevices()).andReturn(inactiveDevices);
        apnsService.stop();
        HashSet<String> tokens = new HashSet<String>();
        tokens.add("1");
        tokens.add("2");
        tokens.add("3");
        EasyMock.expect((Object)this.eventNotificationDAO.removeEventNotifications(tokens)).andReturn((Object)3);
        PowerMock.replayAll((Object[])new Object[0]);
        this.appleDeviceService.deleteInactiveDevices();
        PowerMock.verifyAll();
    }

    @After
    public void tearDown() {
        this.eventNotificationDAO = null;
        this.apnsServiceFactory = null;
        this.appleDeviceService = null;
    }
}

